/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao;

import jalis.comum.ConstantesGerais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.cadastro.ConvenioVO;
import jalis.model.vo.cadastro.MedicoVO;
import jalis.service.cadastro.ConvenioService;
import jalis.service.cadastro.MedicoService;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.LinkedHashMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

class JanelaConfiguracaoImportacao
extends AbstractDialogoOKCancelar {
    private TTextField textConvenio = new TTextField(10, 1);
    private TTextField textCrmMedico = new TTextField(10, 1);
    private JComboBox comboConselhos = new JComboBox<String>(ConstantesGerais.CONSELHOS);
    private JComboBox comboUfs = new JComboBox<String>(ConstantesGerais.ESTADOS);
    private JLabel labelConvenio = new JLabel("Conv\u00eanio:");
    private JLabel labelMedico = new JLabel("M\u00e9dico:");
    private JLabel labelVlrConvenio = new JLabel();
    private JLabel labelVlrMedico = new JLabel();
    private JButton buttonConvenio = ComponenteFactory.novoJButton(this, new Dimension(20, 20), new Dimension(20, 20), true);
    private JButton buttonMedico = ComponenteFactory.novoJButton(this, new Dimension(20, 20), new Dimension(20, 20), true);
    private String codigoConvenio = null;
    private String crmMedico = null;
    private String conselhoMedico = null;
    private String ufMedico = null;
    private ConvenioVO convenioAux = null;
    private MedicoVO medicoAux = null;

    public static JanelaConfiguracaoImportacao novaInstancia(Window pai, String codigoConvenio, String crmMedico, String conselhoMedico, String ufMedico) {
        if (pai instanceof Frame) {
            return new JanelaConfiguracaoImportacao((Frame)pai, codigoConvenio, crmMedico, conselhoMedico, ufMedico);
        }
        if (pai instanceof Dialog) {
            return new JanelaConfiguracaoImportacao((Dialog)pai, codigoConvenio, crmMedico, conselhoMedico, ufMedico);
        }
        return null;
    }

    private JanelaConfiguracaoImportacao(Dialog pai, String codigoConvenio, String crmMedico, String conselhoMedico, String ufMedico) {
        super(pai, "Configura\u00e7\u00f5es de importa\u00e7\u00e3o");
        this.codigoConvenio = codigoConvenio;
        this.crmMedico = crmMedico;
        this.conselhoMedico = conselhoMedico;
        this.ufMedico = ufMedico;
        this.montaTela();
    }

    private JanelaConfiguracaoImportacao(Frame pai, String codigoConvenio, String crmMedico, String conselhoMedico, String ufMedico) {
        super(pai, "Configura\u00e7\u00f5es de importa\u00e7\u00e3o");
        this.codigoConvenio = codigoConvenio;
        this.crmMedico = crmMedico;
        this.conselhoMedico = conselhoMedico;
        this.ufMedico = ufMedico;
        this.montaTela();
    }

    private void montaTela() {
        JPanel panelCentral = this.getPanelCentral();
        panelCentral.setLayout(new GridBagLayout());
        ScreenUtil.setBorda(new JComponent[]{this.labelVlrConvenio, this.labelVlrMedico}, new TitledBorder(""));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 0, 0);
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.labelConvenio.setDisplayedMnemonic('o');
        this.labelConvenio.setLabelFor(this.textConvenio);
        panelCentral.add((Component)this.labelConvenio, c);
        ++c.gridx;
        c.fill = 2;
        this.textConvenio.setMinimumSize(new Dimension(70, 20));
        this.textConvenio.setPreferredSize(new Dimension(70, 20));
        panelCentral.add((Component)this.textConvenio, c);
        ++c.gridx;
        c.fill = 0;
        panelCentral.add((Component)this.buttonConvenio, c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        c.gridwidth = 4;
        c.insets = new Insets(1, 1, 0, 1);
        this.labelVlrConvenio.setMinimumSize(new Dimension(20, 20));
        this.labelVlrConvenio.setPreferredSize(new Dimension(20, 20));
        panelCentral.add((Component)this.labelVlrConvenio, c);
        ++c.gridy;
        c.gridx = 0;
        c.fill = 0;
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.insets = new Insets(1, 1, 0, 0);
        this.labelMedico.setDisplayedMnemonic('M');
        this.labelMedico.setLabelFor(this.comboConselhos);
        panelCentral.add((Component)this.labelMedico, c);
        ++c.gridx;
        this.comboConselhos.setMinimumSize(new Dimension(70, 20));
        this.comboConselhos.setPreferredSize(new Dimension(70, 20));
        panelCentral.add((Component)this.comboConselhos, c);
        ++c.gridx;
        c.gridwidth = 2;
        this.comboUfs.setMinimumSize(new Dimension(50, 20));
        this.comboUfs.setPreferredSize(new Dimension(50, 20));
        panelCentral.add((Component)this.comboUfs, c);
        c.gridx += 2;
        c.gridwidth = 1;
        this.textCrmMedico.setMinimumSize(new Dimension(70, 20));
        this.textCrmMedico.setPreferredSize(new Dimension(70, 20));
        panelCentral.add((Component)this.textCrmMedico, c);
        ++c.gridx;
        panelCentral.add((Component)this.buttonMedico, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.labelVlrMedico.setMinimumSize(new Dimension(20, 20));
        this.labelVlrMedico.setPreferredSize(new Dimension(20, 20));
        c.insets = new Insets(1, 1, 0, 1);
        panelCentral.add((Component)this.labelVlrMedico, c);
        this.textConvenio.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    JanelaConfiguracaoImportacao.this.pesquisaConvenio();
                }
            }
        });
        this.textConvenio.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (Funcoes.textoVazio(JanelaConfiguracaoImportacao.this.textConvenio)) {
                    JanelaConfiguracaoImportacao.this.labelVlrConvenio.setText("");
                    JanelaConfiguracaoImportacao.this.convenioAux = null;
                } else {
                    JanelaConfiguracaoImportacao.this.buscaConvenio(Variaveis.filialPadrao, JanelaConfiguracaoImportacao.this.textConvenio.getText());
                }
            }
        });
        this.textCrmMedico.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    JanelaConfiguracaoImportacao.this.pesquisaMedico();
                }
            }
        });
        this.textCrmMedico.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (Funcoes.textoVazio(JanelaConfiguracaoImportacao.this.textCrmMedico)) {
                    JanelaConfiguracaoImportacao.this.labelVlrMedico.setText("");
                    JanelaConfiguracaoImportacao.this.medicoAux = null;
                } else {
                    JanelaConfiguracaoImportacao.this.buscaMedico(Variaveis.filialPadrao, JanelaConfiguracaoImportacao.this.textCrmMedico.getText(), JanelaConfiguracaoImportacao.this.comboUfs.getSelectedItem().toString(), JanelaConfiguracaoImportacao.this.comboConselhos.getSelectedItem().toString());
                }
            }
        });
        this.setSize(530, 130);
        this.setResizable(false);
        ScreenUtil.centralizar(this);
        this.carregaDados();
        ScreenUtil.requisitarFoco(this.textConvenio);
    }

    private void carregaDados() {
        this.convenioAux = null;
        this.buscaConvenio(Variaveis.filialPadrao, this.codigoConvenio);
        this.medicoAux = null;
        this.buscaMedico(Variaveis.filialPadrao, this.crmMedico, this.ufMedico, this.conselhoMedico);
    }

    private void buscaConvenio(String filial, String codigoConvenio) {
        if (!Funcoes.textoVazio(codigoConvenio)) {
            try {
                this.convenioAux = (ConvenioVO)new ConvenioService().getVO(filial, codigoConvenio);
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar os dados do conv\u00eanio.", e.getStackTrace());
            }
            if (this.convenioAux != null) {
                this.textConvenio.setText(this.convenioAux.getCodigo().toString());
                this.labelVlrConvenio.setText(this.convenioAux.getFantasia());
            } else {
                this.labelVlrConvenio.setText("N\u00e3o cadastrado");
            }
        }
    }

    private void buscaMedico(String filial, String crmMedico, String ufMedico, String conselhoMedico) {
        if (!(Funcoes.textoVazio(crmMedico) || Funcoes.textoVazio(conselhoMedico) || Funcoes.textoVazio(ufMedico))) {
            LinkedHashMap<String, Object> chaves = new LinkedHashMap<String, Object>();
            chaves.put("fil_codigo", filial);
            chaves.put("med_crm", crmMedico);
            chaves.put("med_uf", ufMedico);
            chaves.put("med_conselho", conselhoMedico);
            try {
                this.medicoAux = (MedicoVO)new MedicoService().getVO(chaves);
            }
            catch (ThreadDaoException e) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar os dados do m\u00e9dico.", e.getStackTrace());
            }
            if (this.medicoAux != null) {
                this.comboConselhos.setSelectedItem(this.medicoAux.getConselho());
                this.comboUfs.setSelectedItem(this.medicoAux.getUf());
                this.textCrmMedico.setText(this.medicoAux.getCrm());
                this.labelVlrMedico.setText(this.medicoAux.getNome());
            } else {
                this.labelVlrMedico.setText("N\u00e3o cadastrado");
            }
        }
    }

    private boolean validaCampos() {
        if (this.convenioAux == null) {
            return false;
        }
        return this.medicoAux != null;
    }

    @Override
    protected boolean acaoOk() {
        return this.validaCampos();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        if (e.getSource() == this.buttonConvenio) {
            this.pesquisaConvenio();
        } else if (e.getSource() == this.buttonMedico) {
            this.pesquisaMedico();
        }
    }

    private void pesquisaConvenio() {
        ConvenioVO convenio = (ConvenioVO)new ConvenioService().pesquisaVO(this, new ConvenioVO(), "Pesquisando conv\u00eanios", false);
        if (convenio != null) {
            this.convenioAux = convenio;
            this.textConvenio.setText(convenio.getCodigo().toString());
            this.labelVlrConvenio.setText(convenio.getFantasia());
        }
    }

    private void pesquisaMedico() {
        MedicoVO medico = (MedicoVO)new MedicoService().pesquisaVO(this, new MedicoVO(), "Pesquisando m\u00e9dicos", false);
        if (medico != null) {
            this.medicoAux = medico;
            this.comboConselhos.setSelectedItem(medico.getConselho());
            this.comboUfs.setSelectedItem(medico.getUf());
            this.textCrmMedico.setText(medico.getCrm());
            this.labelVlrMedico.setText(medico.getNome());
        }
    }

    public ConvenioVO getConvenio() {
        return this.convenioAux;
    }

    public MedicoVO getMedico() {
        return this.medicoAux;
    }
}

