/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao;

import jalis.apoio.util.Util;
import jalis.comum.Conexao;
import jalis.comum.ConstantesGerais;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosUsuarios;
import jalis.comum.Variaveis;
import jalis.comum.dados.DadosConvenios;
import jalis.comum.dados.DadosExames;
import jalis.comum.dados.DadosMaterial;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.comum.padroes.FrmPadrao;
import jalis.laboratorio.exportacao.DadosExameMaterial;
import jalis.laboratorio.exportacao.DadosImportacaoNefrodata;
import jalis.laboratorio.exportacao.Grupo3;
import jalis.laboratorio.exportacao.TipoIdade;
import jalis.model.bean.cadastro.convenio.ConvenioBean;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.cadastro.ConvenioVO;
import jalis.model.vo.cadastro.MedicoVO;
import jalis.service.cadastro.ConvenioService;
import jalis.service.cadastro.MedicoService;
import jalis.service.recepcao.RequisicaoService;
import jalis.util.ConvenioUtil;
import jalis.util.DBUtil;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.SplashMensagem;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.ThreadFinalizadaListener;
import jalis.util.ValidaDoc;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Scanner;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;

public class ImportarRequisicaoNefrodataAcd
extends FrmPadrao
implements ActionListener,
ThreadFinalizadaListener {
    private static final int LIMITE_NOME = 80;
    private static final String EXAMES_DUPLICADOS = "Os seguintes exames possuem configura\u00e7\u00e3o do c\u00f3digo nefrodata duplicados:\n";
    private JButton buttonImportar = ComponenteFactory.novoJButton("Importar", 'I', this);
    private JButton buttonFechar = ComponenteFactory.novoJButton("Fechar", 'F', this);
    private JButton buttonConfigurar = ComponenteFactory.novoJButton("Configurar", 'C', this);
    private JPanel panelBotoesDireita = ComponenteFactory.novoJPanelFlowLayout(2, this.buttonImportar, this.buttonFechar);
    private JPanel panelBotoesEsquerda = ComponenteFactory.novoJPanelFlowLayout(0, this.buttonConfigurar);
    private JTextArea textInformacoes = new JTextArea();
    private JScrollPane scrollInformacoes = new JScrollPane(this.textInformacoes);
    private String codigoConvenio = null;
    private String conselhoMedico = null;
    private String ufMedico = null;
    private String crmMedico = null;
    private ConvenioBean con = null;
    private String codlay = null;
    private boolean isExecutando = false;
    private RequisicaoService requisicaoService = new RequisicaoService();
    private static final String CONFIGURACAO = "ImportarResultadoNefrodataAcd.configuracao";
    private Map<String, String> examesNefroData = new HashMap<String, String>();

    public ImportarRequisicaoNefrodataAcd() {
        this.montaTela();
        this.carregarParametros();
        this.carregaListaExames();
    }

    private void carregaListaExames() {
        this.examesNefroData.put("001", "\u00c1cido Urico");
        this.examesNefroData.put("002", "Albumina");
        this.examesNefroData.put("003", "Aluminio S\u00e9rico");
        this.examesNefroData.put("004", "Anti HBC IGM");
        this.examesNefroData.put("005", "Anti HBs");
        this.examesNefroData.put("006", "Anti HCV");
        this.examesNefroData.put("007", "Anti HIV (Valor)");
        this.examesNefroData.put("008", "C\u00e1lcio");
        this.examesNefroData.put("009", "C\u00e1lcio X F\u00f3sforo");
        this.examesNefroData.put("010", "Cap. Latente de Liga\u00e7\u00e3o do Ferro");
        this.examesNefroData.put("011", "Cap. Total de Liga\u00e7\u00e3o do Ferro");
        this.examesNefroData.put("012", "Colesterol");
        this.examesNefroData.put("013", "Colesterol HDL");
        this.examesNefroData.put("014", "Colesterol LDL");
        this.examesNefroData.put("015", "Colesterol VLDL");
        this.examesNefroData.put("016", "Creatinina");
        this.examesNefroData.put("017", "Grupo Sangu\u00edneo - Fator Rh");
        this.examesNefroData.put("018", "Ferritina");
        this.examesNefroData.put("019", "Ferro S\u00e9rico");
        this.examesNefroData.put("020", "Fosfatase Alcalina");
        this.examesNefroData.put("021", "F\u00f3sforo");
        this.examesNefroData.put("022", "Glicose");
        this.examesNefroData.put("023", "Globulina");
        this.examesNefroData.put("024", "HbsAg");
        this.examesNefroData.put("025", "Hem\u00e1cias");
        this.examesNefroData.put("026", "Hemat\u00f3crito");
        this.examesNefroData.put("027", "Hemoglobina");
        this.examesNefroData.put("028", "Hemograma Completo");
        this.examesNefroData.put("029", "Indice de Satura\u00e7\u00e3o da Transferrina");
        this.examesNefroData.put("030", "Plaquetas");
        this.examesNefroData.put("031", "Pot\u00e1ssio");
        this.examesNefroData.put("032", "Prote\u00ednas");
        this.examesNefroData.put("033", "PTH");
        this.examesNefroData.put("034", "S\u00f3dio");
        this.examesNefroData.put("035", "TGP");
        this.examesNefroData.put("036", "Transferrina");
        this.examesNefroData.put("037", "Triglic\u00e9rides");
        this.examesNefroData.put("038", "Ur\u00e9ia P\u00f3s");
        this.examesNefroData.put("039", "Ur\u00e9ia Pr\u00e9");
        this.examesNefroData.put("040", "Hemoglobina Glicosilada");
        this.examesNefroData.put("041", "25 Hidroxivitamina D");
        this.examesNefroData.put("042", "Anti HBC-IgG");
        this.examesNefroData.put("043", "TSH");
        this.examesNefroData.put("044", "Tiroxina (T4)");
        this.examesNefroData.put("045", "Bacterioscopia (GRAM)");
        this.examesNefroData.put("046", "Cultura de Bact\u00e9rias p/identifica\u00e7\u00e3o");
        this.examesNefroData.put("047", "Hemocultura");
        this.examesNefroData.put("048", "Exame de Carac. F\u00edsicos Contagem Global e Espec. de C\u00e9lulas");
        this.examesNefroData.put("049", "Ultrassonagrafia de Aparelho Urin\u00e1rio");
        this.examesNefroData.put("050", "Eletrocardiograma");
        this.examesNefroData.put("051", "Gasometria");
    }

    private void montaTela() {
        this.setLayout(new BorderLayout());
        Funcoes.criaBarraDescricao(this, "Importar Nefrodata-ACD", "Importa\u00e7\u00e3o de Requisi\u00e7\u00e3o de Exames do Nefrodata-ACD", "integracao/importar_resultado_nefrodata.jpg");
        JPanel panelInformacoes = new JPanel(new BorderLayout());
        panelInformacoes.setBorder(new TitledBorder("Informa\u00e7\u00f5es"));
        JPanel panelBotoes = new JPanel(new BorderLayout());
        this.add((Component)panelInformacoes, "Center");
        this.add((Component)panelBotoes, "South");
        panelInformacoes.add(this.scrollInformacoes);
        panelBotoes.add((Component)this.panelBotoesDireita, "East");
        panelBotoes.add((Component)this.panelBotoesEsquerda, "West");
        this.textInformacoes.setFont(new Font("Monospaced", 0, 12));
        this.textInformacoes.setEditable(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void importaArquivo() {
        SplashMensagem splash = SplashMensagem.getInstancia(this);
        try {
            if (!this.validaConfiguracoes()) {
                return;
            }
            JFileChooser chooser = ComponenteFactory.novoJFileChooser();
            if (chooser.showOpenDialog(this) == 0) {
                File file = new File(chooser.getSelectedFile().getPath());
                this.textInformacoes.setText("Importando exames...");
                splash.mostrar("Importando arquivo. Aguarde...");
                if (this.processaArquivo(file)) {
                    String nomeNovo = file.getParent() + File.separator + Funcoes.formataData("dd_MM_yyyy_HH_mm", Calendar.getInstance().getTime()) + "_" + file.getName();
                    File newFile = new File(nomeNovo);
                    file.renameTo(newFile);
                }
            }
        }
        catch (Exception e) {
            Funcoes.mensagem(this, e.getMessage(), 1);
        }
        finally {
            splash.apagar();
        }
    }

    private boolean validaConfiguracoes() {
        if (Funcoes.textoVazio(this.codigoConvenio)) {
            Funcoes.mensagem(this, "Informe o conv\u00eanio.", 2);
            return false;
        }
        if (Funcoes.textoVazio(this.conselhoMedico)) {
            Funcoes.mensagem(this, "Informe o conselho do m\u00e9dico.", 2);
            return false;
        }
        if (Funcoes.textoVazio(this.crmMedico)) {
            Funcoes.mensagem(this, "Informe o crm do m\u00e9dico.", 2);
            return false;
        }
        if (Funcoes.textoVazio(this.ufMedico)) {
            Funcoes.mensagem(this, "Informe estado do m\u00e9dico.", 2);
            return false;
        }
        return true;
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0910000800");
    }

    private boolean processaArquivo(File arquivo) throws Exception {
        boolean retorno = true;
        if (arquivo == null) {
            return false;
        }
        StringBuilder bufInformacoes = new StringBuilder();
        ArrayList<Exception> erros = new ArrayList<Exception>();
        Statement st = Conexao.getStatement();
        StringBuilder conteudoArquivo = new StringBuilder();
        FileInputStream fis = new FileInputStream(arquivo);
        InputStreamReader reader = new InputStreamReader(fis);
        BufferedReader br = new BufferedReader(reader);
        String linha = br.readLine();
        List<DadosImportacaoNefrodata> dadosImportacaoNefrodatas = this.preencheListaBeans(br, linha);
        fis.close();
        conteudoArquivo = null;
        System.gc();
        ArrayList<String> listaRequisicoesInseridas = this.processaRequisicoes(st, dadosImportacaoNefrodatas, erros);
        bufInformacoes.append("Importa\u00e7\u00e3o finalizada.");
        if (erros != null && erros.size() > 0) {
            Conexao.anulaSQL();
            this.imprimeErros(erros, bufInformacoes);
            Funcoes.mensagem(this, "Importa\u00e7\u00e3o n\u00e3o pode ser conclu\u00edda por conter erros.", 1);
            retorno = false;
        } else {
            Conexao.arquivaSQL();
            Funcoes.mensagem(this, "Importa\u00e7\u00e3o conclu\u00edda.", 2);
            this.imprimeRequisicoesImportadas(listaRequisicoesInseridas, bufInformacoes);
        }
        this.textInformacoes.setText(bufInformacoes.toString());
        return retorno;
    }

    private List<DadosImportacaoNefrodata> preencheListaBeans(BufferedReader br, String linha) throws IOException, ThreadDaoException {
        ArrayList<DadosImportacaoNefrodata> dadosImportacaoNefrodatas = new ArrayList<DadosImportacaoNefrodata>();
        DadosImportacaoNefrodata dadosImportacaoNefrodata = new DadosImportacaoNefrodata();
        while (linha != null && !Funcoes.textoVazio(linha.trim())) {
            Scanner scanner = new Scanner(linha.trim()).useDelimiter("\\||\\n");
            int grupo = scanner.nextInt();
            if (grupo == 1) {
                if (dadosImportacaoNefrodata.getCodigoGrupo() > 0) {
                    dadosImportacaoNefrodatas.add(dadosImportacaoNefrodata);
                }
                dadosImportacaoNefrodata = new DadosImportacaoNefrodata();
                dadosImportacaoNefrodata.setCodigoGrupo(grupo);
                dadosImportacaoNefrodata.setLinha(scanner.nextInt());
                dadosImportacaoNefrodata.setProntuarioPaciente(scanner.next());
                dadosImportacaoNefrodata.setNomePaciente(scanner.next());
                dadosImportacaoNefrodata.setSexoPaciente(scanner.next());
                dadosImportacaoNefrodata.setCpfPaciente(scanner.next());
                dadosImportacaoNefrodata.setDataNacimento(scanner.next());
                dadosImportacaoNefrodata.setTipoLogradouro(scanner.next());
                dadosImportacaoNefrodata.setEnderecoPaciente(scanner.next());
                dadosImportacaoNefrodata.setNumeroLogradouro(scanner.next());
                dadosImportacaoNefrodata.setComplemento(scanner.next());
                dadosImportacaoNefrodata.setBairroPaciente(scanner.next());
                dadosImportacaoNefrodata.setTelefonePaciente(scanner.next());
                dadosImportacaoNefrodata.setCidadePaciente(scanner.next());
                dadosImportacaoNefrodata.setEstadoPaciente(scanner.next());
                dadosImportacaoNefrodata.setCepPaciente(scanner.next());
                dadosImportacaoNefrodata.setIdentidadePaciente(scanner.next());
                dadosImportacaoNefrodata.setEstadoCivilPaciente(scanner.next());
                dadosImportacaoNefrodata.setGrupoSanguineoPaciente(scanner.next());
                try {
                    dadosImportacaoNefrodata.setFatorRhPaciente(scanner.next());
                }
                catch (NoSuchElementException noSuchElementException) {}
            } else if (grupo == 2) {
                dadosImportacaoNefrodata.addGrupo2(grupo, scanner.nextInt(), scanner.nextInt(), scanner.next());
            } else if (grupo == 3) {
                dadosImportacaoNefrodata.addExame(grupo, scanner.nextInt(), scanner.next());
            } else {
                throw new ThreadDaoException("Arquivo de importa\u00e7\u00e3o incorreto.");
            }
            linha = br.readLine();
        }
        dadosImportacaoNefrodatas.add(dadosImportacaoNefrodata);
        return dadosImportacaoNefrodatas;
    }

    private void imprimeRequisicoesImportadas(ArrayList<String> listaRequisicoesInseridas, StringBuilder buf) {
        if (listaRequisicoesInseridas == null) {
            return;
        }
        buf.append("\n\nIMPORTA\u00c7\u00c3O FINALIZADA COM SUCESSO.\n\n");
        buf.append("+-----------------------------------------+----------------------------------------------+\n");
        buf.append("|                               REQUISI\u00c7\u00d5ES INSERIDAS                                    |\n");
        buf.append("+-----------------------------------------+----------------------------------------------+");
        for (String req : listaRequisicoesInseridas) {
            buf.append("\n|" + StringUtil.formatarColuna(req, 88, 'e') + "|");
        }
        buf.append("\n+-----------------------------------------+----------------------------------------------+");
    }

    private void imprimeErros(ArrayList<Exception> erros, StringBuilder buf) {
        if (erros == null) {
            return;
        }
        buf.append("\n\nFORAM DETECTADOS PROBLEMAS AO IMPORTAR.\n\n");
        buf.append("+-----------------------------------------+----------------------------------------------+\n");
        buf.append("|                                      PROBLEMAS                                         |\n");
        buf.append("+-----------------------------------------+----------------------------------------------+");
        HashSet<String> msgs = new HashSet<String>();
        HashSet<String> msgsExame = new HashSet<String>();
        String anterior = null;
        String msg = "";
        for (Exception erro : erros) {
            if (msgs.contains(erro.getMessage())) continue;
            msg = erro.getMessage();
            if (anterior != null) {
                if (anterior.indexOf(EXAMES_DUPLICADOS) > -1) {
                    String[] exame;
                    msg = erro.getMessage().trim().split("\\:")[1];
                    for (String exa : exame = msg.split("\\,")) {
                        if (msgsExame.contains(exa) || anterior.indexOf(exa) != -1) continue;
                        buf.append(",").append(exa);
                        msgsExame.add(exa);
                    }
                } else {
                    buf.append("\n" + msg.trim());
                }
            } else {
                buf.append("\n" + msg.trim());
            }
            anterior = erro.getMessage();
            msgs.add(erro.getMessage());
        }
        buf.append("\n+-----------------------------------------+----------------------------------------------+");
    }

    public boolean validarDocumento(DadosImportacaoNefrodata requisicao, ArrayList<Exception> erros, Statement st) throws Exception {
        String valorDoc;
        if (Funcoes.textoVazio(requisicao.getCpfPaciente()) && Funcoes.textoVazio(requisicao.getCepPaciente())) {
            return true;
        }
        String valor = requisicao.getCpfPaciente();
        String string = valorDoc = !Funcoes.textoVazio(valor) ? valor : "";
        if (!Funcoes.textoVazio(valorDoc) && !ValidaDoc.checkDoc(valorDoc, 8)) {
            erros.add(new Exception("CPF do paciente inv\u00e1lido. Paciente: " + requisicao.getNomePaciente()));
        }
        String string2 = valorDoc = !Funcoes.textoVazio(valor = requisicao.getCepPaciente()) ? valor : "";
        if (!Funcoes.textoVazio(valorDoc) && !(valorDoc = valorDoc.substring(0, 5) + "-" + valorDoc.substring(5, valorDoc.length())).matches("[0-9]{5}-[0-9]{3}")) {
            erros.add(new Exception("CEP do paciente inv\u00e1lido. Paciente: " + requisicao.getNomePaciente()));
        }
        TipoIdade idade = new TipoIdade(requisicao.getDataNacimento(), Calendar.getInstance().getTime());
        ArrayList<String> errosExame = new ArrayList<String>();
        for (Grupo3 exame : requisicao.getExames()) {
            this.getExameMatColeta(st, exame.getCodigoExame(), idade, errosExame);
        }
        this.addErroExame(erros, errosExame);
        return erros.isEmpty();
    }

    private ArrayList<String> processaRequisicoes(Statement st, List<DadosImportacaoNefrodata> conteudo, ArrayList<Exception> erros) throws Exception {
        if (conteudo.isEmpty()) {
            erros.add(new Exception("Arquivo sem conte\u00fado."));
            return null;
        }
        for (DadosImportacaoNefrodata requisicao : conteudo) {
            this.validarDocumento(requisicao, erros, st);
        }
        if (erros != null && !erros.isEmpty()) {
            return null;
        }
        ArrayList<String> listaRequisicoesInseridas = new ArrayList<String>();
        for (DadosImportacaoNefrodata requisicao : conteudo) {
            try {
                String codigoRequisicao = this.insereRequisicao(st, requisicao, erros);
                listaRequisicoesInseridas.add("Prontu\u00e1rio: " + requisicao.getProntuarioPaciente() + " - C\u00f3d. Req.: " + codigoRequisicao + ", Pac.: " + requisicao.getNomePaciente() + ".");
            }
            catch (Exception e) {
                if (erros == null) continue;
                erros.add(e);
            }
        }
        return listaRequisicoesInseridas;
    }

    private String insereRequisicao(Statement st, DadosImportacaoNefrodata requisicao, ArrayList<Exception> erros) throws Exception {
        java.util.Date data = new java.util.Date();
        java.util.Date dataRequisicao = new SimpleDateFormat("dd/MM/yyyy").parse(requisicao.getGrupo2().getDataSolicitacao());
        String codigoRequisicao = DBUtil.getSequencia(st, "requisicao", Variaveis.filialPadrao);
        TipoIdade idade = new TipoIdade(requisicao.getDataNacimento(), data);
        String codigoPaciente = this.inserePaciente(st, requisicao, idade, data);
        LinkedHashMap<String, Object> chaves = new LinkedHashMap<String, Object>();
        chaves.put("fil_codigo", Variaveis.filialPadrao);
        chaves.put("con_codigo", this.codigoConvenio);
        ConvenioBean convenioBean = (ConvenioBean)new ConvenioService().getBean(chaves);
        StringBuilder buf = new StringBuilder();
        buf.append(" insert into requisicao ");
        buf.append("       (fil_codigo ");
        buf.append("       ,req_codigo ");
        buf.append("       ,req_prontuario ");
        buf.append("       ,con_codigo ");
        buf.append("       ,med_crm ");
        buf.append("       ,med_conselho ");
        buf.append("       ,med_uf ");
        buf.append("       ,pac_codigo ");
        buf.append("       ,req_urgente ");
        buf.append("       ,req_avisarpaciente ");
        buf.append("       ,req_imprimirseparado ");
        buf.append("       ,req_totpago ");
        buf.append("       ,req_total ");
        buf.append("       ,req_vlrexames ");
        buf.append("       ,req_vlrmateriais ");
        buf.append("       ,req_data ");
        buf.append("       ,req_hora ");
        buf.append("       ,req_gestante ");
        buf.append("       ,req_neonato ");
        buf.append("       ,req_idade ");
        buf.append("       ,req_anomes ");
        buf.append("       ,req_quarto ");
        buf.append("       ,req_leito ");
        buf.append("       ,req_desconto ");
        buf.append("       ,req_vlrdesconto ");
        buf.append("       ,req_acrescimo ");
        buf.append("       ,req_vlracrescimo ");
        buf.append("       ,req_telacoleta ");
        buf.append("       ,est_codigo ");
        buf.append("       ,usr_codigo ");
        buf.append("       ,req_datarequisicao ");
        buf.append("       ,usr_codabertura ");
        buf.append("       ,req_validadeguia ");
        buf.append("       ,req_deveguia ");
        buf.append("       ,req_guia ");
        buf.append("       ,req_excluida ");
        buf.append("       ,req_dtfatura ");
        buf.append("       ,req_horafatura ");
        buf.append("       ,col_codigo ");
        buf.append("       ,des_codigo ");
        buf.append("       ,req_senhaweb ");
        buf.append("       ,req_codigoapoiado ");
        buf.append(" ) ");
        buf.append(" values (");
        buf.append(Variaveis.filialPadrao);
        buf.append(",").append(codigoRequisicao);
        buf.append(",").append(ImportarRequisicaoNefrodataAcd.getTextoSql(requisicao.getProntuarioPaciente(), false));
        buf.append(",").append(this.codigoConvenio);
        buf.append(",").append(this.crmMedico);
        buf.append(",").append(ImportarRequisicaoNefrodataAcd.getTextoSql(this.conselhoMedico, false));
        buf.append(",").append(ImportarRequisicaoNefrodataAcd.getTextoSql(this.ufMedico, false));
        buf.append(",").append(codigoPaciente);
        buf.append(",false ");
        buf.append(",false ");
        buf.append(",false ");
        buf.append(",0 ");
        buf.append(",0 ");
        buf.append(",0 ");
        buf.append(",0 ");
        buf.append(",").append(ImportarRequisicaoNefrodataAcd.getTextoSql(Funcoes.formataData("yyyy-MM-dd", dataRequisicao), false));
        buf.append(",date_trunc('minute', cast(LOCALTIMESTAMP as time)) ");
        buf.append(",false ");
        buf.append(",false ");
        buf.append(",").append(idade.getQuantidade() == null ? "0" : idade.getQuantidade());
        buf.append(",").append(ImportarRequisicaoNefrodataAcd.getTextoSql(idade.getTipoIdade()));
        buf.append(",null ");
        buf.append(",null ");
        buf.append(",0 ");
        buf.append(",0 ");
        buf.append(",0 ");
        buf.append(",0 ");
        buf.append(",false ");
        buf.append(",").append(Variaveis.codigoEstacao);
        buf.append(",").append(ImportarRequisicaoNefrodataAcd.getTextoSql(Variaveis.login, false));
        buf.append(",LOCALTIMESTAMP ");
        buf.append(",").append(ImportarRequisicaoNefrodataAcd.getTextoSql(Variaveis.login, false));
        buf.append(",null ");
        buf.append(",false ");
        buf.append(",null ");
        buf.append(",false ");
        buf.append(",").append(ImportarRequisicaoNefrodataAcd.getTextoSql(Funcoes.formataData("yyyy-MM-dd", data), false));
        buf.append(",date_trunc('minute', cast(LOCALTIMESTAMP as time)) ");
        buf.append(",").append(ImportarRequisicaoNefrodataAcd.getTextoSql(convenioBean.getColeta().getCodigo(), false));
        buf.append(",").append(ImportarRequisicaoNefrodataAcd.getTextoSql(convenioBean.getDestino().getCodigo(), false));
        buf.append(",").append(ImportarRequisicaoNefrodataAcd.getTextoSql(Funcoes.gerarSenhaWeb(), false));
        buf.append(",").append(ImportarRequisicaoNefrodataAcd.getTextoSql(requisicao.getGrupo2().getSolicitacao().toString(), false));
        buf.append(" ) ");
        int qtde = Conexao.executeUpdate(Variaveis.filialPadrao, st, buf.toString(), true);
        if (qtde > 0) {
            this.insereExamesRequisicao(st, codigoRequisicao, dataRequisicao, idade, requisicao.getExames(), erros);
            Util.exportaWebRequisicao(Variaveis.filialPadrao, codigoRequisicao.toString(), true);
            return codigoRequisicao;
        }
        throw new ThreadDaoException("A requisi\u00e7\u00e3o n\u00e3o foi inserida.\n" + requisicao.toString());
    }

    private void insereExamesRequisicao(Statement st, String codigoRequisicao, java.util.Date dataRequisicao, TipoIdade idade, List<Grupo3> exames, ArrayList<Exception> erros) throws Exception {
        ArrayList<DadosExameMaterial> listaExamesJalis = new ArrayList<DadosExameMaterial>();
        for (Grupo3 exame : exames) {
            ArrayList<String> errosExame = new ArrayList<String>();
            DadosExameMaterial dadosExameMaterialJalis = this.getExameMatColeta(st, exame.getCodigoExame(), idade, errosExame);
            this.addErroExame(erros, errosExame);
            if (listaExamesJalis.contains(dadosExameMaterialJalis)) continue;
            DadosMaterial dadosMaterial = ExameUtil.getDadosMaterial(Variaveis.filialPadrao, dadosExameMaterialJalis.getCodigoMaterial(), st);
            DadosExames dadosExame = ExameUtil.getDadosExame(Variaveis.filialPadrao, dadosExameMaterialJalis.getCodigoExame(), dadosMaterial, st);
            DadosConvenios dadosConvenio = ConvenioUtil.getDadosConvenios(Variaveis.filialPadrao, Integer.parseInt(this.codigoConvenio), st);
            ExameUtil.calculaPrecoExame(Variaveis.filialPadrao, dadosExame, dadosMaterial, dadosConvenio, false, true, false, null, null, (Integer)Integer.parseInt(dadosExame.getCodMetodo()), st);
            StringBuilder buf = new StringBuilder();
            buf.append(" insert into examerequisicao ");
            buf.append("       (fil_codigo ");
            buf.append("       ,req_codigo ");
            buf.append("       ,exa_codigo ");
            buf.append("       ,mco_codigo ");
            buf.append("       ,exr_dataetqcoleta ");
            buf.append("       ,exr_situacao ");
            buf.append("       ,exr_excluido ");
            buf.append("       ,usr_codigo ");
            buf.append("       ,exr_data ");
            buf.append("       ,exr_vlrchexame ");
            buf.append("       ,exr_vlrexame ");
            buf.append("       ,exr_vlrmaterial ");
            buf.append("       ,exr_valorporte ");
            buf.append("       ,exr_valorcusto ");
            buf.append("       ,exr_porte ");
            buf.append("       ,exr_valoruco ");
            buf.append("       ,exr_valorchexamerepasse ");
            buf.append("       ,exr_valorchrepasse ");
            buf.append("       ,exr_valorporterepasse ");
            buf.append("       ,exr_valorcustorepasse ");
            buf.append("       ,exr_porterepasse ");
            buf.append("       ,exr_valorucorepasse ");
            buf.append("       ,exr_guia ");
            buf.append("       ,exr_validadeguia ");
            buf.append("       ,exr_codautorizacao ");
            buf.append("       ,exr_custosimples ");
            buf.append("       ,met_codigo ");
            buf.append("       ,exr_dataguia ");
            buf.append("       ,exr_datacoletar ");
            buf.append("       ,exr_datamaterial ");
            buf.append(" ) ");
            buf.append("     values (").append(Variaveis.filialPadrao);
            buf.append(" ,").append(codigoRequisicao);
            buf.append(" ,").append(ImportarRequisicaoNefrodataAcd.getTextoSql(dadosExame.getCodigo()));
            buf.append(" ,").append(dadosMaterial.getCodigo());
            buf.append(" ,null ");
            buf.append(" ,").append(ImportarRequisicaoNefrodataAcd.getTextoSql("F"));
            buf.append(",false ");
            buf.append(" ,").append(ImportarRequisicaoNefrodataAcd.getTextoSql(Variaveis.login, false));
            buf.append(" ,").append(ImportarRequisicaoNefrodataAcd.getTextoSql(Funcoes.formataData("yyyy-MM-dd HH:mm:ss", dataRequisicao), false));
            buf.append(" ,").append(dadosExame.getValorCH().doubleValue());
            buf.append(" ,").append(dadosExame.getValorExame().doubleValue());
            buf.append(" ,").append(dadosExame.getValorMaterial().doubleValue());
            buf.append(" ,").append(dadosExame.getValorPorte().doubleValue());
            buf.append(" ,").append(dadosExame.getCusto().doubleValue());
            buf.append(" ,").append(ImportarRequisicaoNefrodataAcd.getTextoSql(dadosExame.getPorte()));
            buf.append(" ,0 ");
            buf.append(" ,0 ");
            buf.append(" ,0 ");
            buf.append(" ,0 ");
            buf.append(" ,0 ");
            buf.append(" ,null ");
            buf.append(" ,0 ");
            buf.append(" ,null ");
            buf.append(" ,null ");
            buf.append(" ,null ");
            buf.append(" ,").append(this.requisicaoService.valorExameCustoSimples(dadosExame.getCodigo(), dadosMaterial.getCodigo(), Variaveis.filialPadrao));
            buf.append(" ,").append(Funcoes.textoVazio(dadosExame.getCodMetodo()) ? "null" : dadosExame.getCodMetodo());
            buf.append(" ,").append(ImportarRequisicaoNefrodataAcd.getTextoSql(Funcoes.formataData("yyyy-MM-dd", dataRequisicao)));
            buf.append(" ,null");
            buf.append(" ,null");
            buf.append(" ) ");
            int qtde = Conexao.executeUpdate(Variaveis.filialPadrao, st, buf.toString(), true);
            DBUtil.gravaLogSituacaoExameRequisicao(Conexao.getStatement(), Variaveis.filialPadrao, codigoRequisicao.toString(), dadosExame.getCodigo(), "" + dadosMaterial.getCodigo(), "T", true);
            if (qtde == 0) {
                throw new ThreadDaoException("O exame n\u00e3o foi inserido.\n" + exame.toString());
            }
            listaExamesJalis.add(dadosExameMaterialJalis);
        }
    }

    private void addErroExame(ArrayList<Exception> erros, ArrayList<String> errosExame) {
        if (!errosExame.isEmpty()) {
            erros.add(new Exception("Nenhum exame localizado ou configurado com o(s) c\u00f3digo(s) do Nefrodata"));
            for (String erroExame : errosExame) {
                erros.add(new Exception(erroExame));
            }
        }
    }

    private String inserePaciente(Statement st, DadosImportacaoNefrodata dados, TipoIdade idade, java.util.Date dataAux) throws Exception {
        String cpfPaciente = dados.getCpfPaciente();
        if (!Funcoes.textoVazio(cpfPaciente)) {
            cpfPaciente = StringUtil.limpaString(cpfPaciente, new String[]{".", "-", "/"});
            StringBuilder buf = new StringBuilder();
            buf.append(" select pac_codigo as codigo ");
            buf.append("   from paciente ");
            buf.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
            buf.append("   and length(trim(pac_cpf)) > 0 ");
            buf.append("   and cast(trim(replace(replace(pac_cpf, '.', ''), '-', '')) as text) = '").append(cpfPaciente).append("' ");
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                dados.setCodigoPaciente(rs.getString("codigo"));
            }
        }
        java.util.Date dataNascimentoAux = Funcoes.getData("dd/MM/yyyy", dados.getDataNacimento());
        StringBuilder buf = new StringBuilder();
        int i = 1;
        PreparedStatement pst = null;
        if (Funcoes.textoVazio(dados.getCodigoPaciente())) {
            dados.setCodigoPaciente(DBUtil.getSequencia(st, "paciente", Variaveis.filialPadrao));
            buf.append("  insert into paciente ");
            buf.append("        (fil_codigo ");
            buf.append("        ,pac_codigo ");
            buf.append("        ,pac_cpf");
            buf.append("        ,pac_nome ");
            buf.append("        ,pac_datanasc ");
            buf.append("        ,pac_sexo ");
            buf.append("        ,pac_senhaweb ");
            buf.append("        ,pac_anomes ");
            buf.append("        ,pac_idade ");
            buf.append("        ,pac_codigoapoiado ");
            buf.append("        ,pac_datahora ");
            buf.append("        ,usr_codigo ");
            buf.append("        ,pac_endereco ");
            buf.append("        ,pac_cep ");
            buf.append("        ,pac_estcivil ");
            buf.append("        ,pac_grpsangue ");
            buf.append("        ,pac_fatorrh ");
            buf.append("        ,pac_numeroendereco ");
            buf.append("        ,pac_complemento ");
            buf.append("        ,pac_tipologradouroendereco ");
            buf.append("        ,pac_rg");
            buf.append(" ) ");
            buf.append(" values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?);");
            pst = Conexao.getPreparedStatement(buf.toString());
            pst.setInt(i++, Integer.parseInt(Variaveis.filialPadrao));
            pst.setInt(i++, Integer.parseInt(dados.getCodigoPaciente()));
            pst.setString(i++, dados.getCpfPaciente());
        } else {
            buf.append("  update paciente set ");
            buf.append("         pac_nome = ? ");
            buf.append("        ,pac_datanasc = ? ");
            buf.append("        ,pac_sexo = ? ");
            buf.append("        ,pac_senhaweb = ? ");
            buf.append("        ,pac_anomes = ? ");
            buf.append("        ,pac_idade = ? ");
            buf.append("        ,pac_codigoapoiado = ? ");
            buf.append("        ,pac_datahora = ? ");
            buf.append("        ,usr_codigo = ? ");
            buf.append("        ,pac_endereco = ? ");
            buf.append("        ,pac_cep = ? ");
            buf.append("        ,pac_estcivil = ? ");
            buf.append("        ,pac_grpsangue = ? ");
            buf.append("        ,pac_fatorrh = ? ");
            buf.append("        ,pac_numeroendereco = ? ");
            buf.append("        ,pac_complemento = ? ");
            buf.append("        ,pac_tipologradouroendereco = ? ");
            buf.append("        ,pac_rg = ? ");
            buf.append("   where fil_codigo = ").append(Variaveis.filialPadrao);
            buf.append("     and pac_codigo = ").append(dados.getCodigoPaciente());
            pst = Conexao.getPreparedStatement(buf.toString());
        }
        String nomePaciente = dados.getNomePaciente();
        if (nomePaciente.length() > 80) {
            nomePaciente = nomePaciente.substring(0, 80);
        }
        pst.setString(i++, nomePaciente);
        pst.setDate(i++, new Date(dataNascimentoAux.getTime()));
        pst.setString(i++, dados.getSexoPaciente());
        pst.setString(i++, Funcoes.gerarSenhaWeb());
        pst.setString(i++, idade.getTipoIdade());
        pst.setInt(i++, idade.getQuantidade());
        pst.setString(i++, dados.getProntuarioPaciente());
        pst.setDate(i++, new Date(new java.util.Date().getTime()));
        pst.setString(i++, Variaveis.login);
        pst.setString(i++, dados.getEnderecoPaciente());
        pst.setString(i++, dados.getCepPaciente());
        pst.setString(i++, this.estadoCivil(dados));
        pst.setString(i++, dados.getGrupoSanguineoPaciente());
        pst.setString(i++, dados.getFatorRhPaciente());
        pst.setString(i++, dados.getNumeroLogradouro());
        pst.setString(i++, dados.getComplemento());
        pst.setString(i++, dados.getTipoLogradouro());
        pst.setString(i++, dados.getIdentidadePaciente());
        int qtde = pst.executeUpdate();
        if (qtde == 0) {
            throw new ThreadDaoException("O paciente \"" + dados.getNomePaciente() + "\" n\u00e3o foi inserido.\n" + dados.toString());
        }
        Util.exportaWebPaciente(Variaveis.filialPadrao, dados.getCodigoPaciente().toString(), true, Conexao.getStatement());
        return dados.getCodigoPaciente();
    }

    private String estadoCivil(DadosImportacaoNefrodata dados) {
        String estado = dados.getEstadoCivilPaciente();
        if (estado.equals("SOLTEIRO")) {
            return "S";
        }
        if (estado.equals("CASADO")) {
            return "C";
        }
        if (estado.equals("VIUVO")) {
            return "V";
        }
        if (estado.equals("DIVORCIADO")) {
            return "D";
        }
        if (estado.equals("OUTRO")) {
            return "O";
        }
        return "I";
    }

    private static String getTextoSql(String texto) {
        return ImportarRequisicaoNefrodataAcd.getTextoSql(texto, true);
    }

    private static String getTextoSql(String texto, boolean podeUtilizarUppercase) {
        if (Funcoes.textoVazio(texto)) {
            return "null";
        }
        if (podeUtilizarUppercase && ParametrosGerais.getUpperCase()) {
            return "'" + StringUtil.textoDB(texto.toString().toUpperCase()) + "'";
        }
        return "'" + StringUtil.textoDB(texto.toString()) + "'";
    }

    private Integer getSequencialPaciente(Statement st) throws Exception {
        StringBuilder buf = new StringBuilder();
        buf.append(" select nextval('paciente_").append(Variaveis.filialPadrao).append("_sequence') as codigo ");
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        if (rs.next()) {
            return rs.getInt("codigo");
        }
        throw new ThreadDaoException("N\u00e3o foi poss\u00ed\u00advel requisitar o sequencial para o paciente.");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonImportar) {
            this.importaArquivo();
        } else if (e.getSource() == this.buttonFechar) {
            this.setVisible(false);
        } else if (e.getSource() == this.buttonConfigurar) {
            this.configurar();
        }
    }

    private void configurar() {
        JanelaConfiguracaoImportacaoNefrodata janela = JanelaConfiguracaoImportacaoNefrodata.novaInstancia((Window)this.getTopLevelAncestor(), this.codigoConvenio, this.crmMedico, this.conselhoMedico, this.ufMedico);
        janela.setVisible(true);
        try {
            if (janela.getOK()) {
                ConvenioVO convenioAux = janela.getConvenio();
                MedicoVO medicoAux = janela.getMedico();
                this.codigoConvenio = convenioAux.getCodigo().toString();
                this.crmMedico = medicoAux.getCrm();
                this.conselhoMedico = medicoAux.getConselho();
                this.ufMedico = medicoAux.getUf();
                this.gravarParametros();
            }
        }
        catch (ThreadDaoException e) {
            Funcoes.mensagem(this, e.getMessage(), 1);
        }
    }

    private void carregarParametros() {
        if (ParametrosUsuarios.contemParametro(CONFIGURACAO)) {
            String parametros = StringUtil.getValor(ParametrosUsuarios.getValor(CONFIGURACAO), "configuracao");
            this.codigoConvenio = StringUtil.getValor(parametros, "convenio");
            this.crmMedico = StringUtil.getValor(parametros, "crm");
            this.conselhoMedico = StringUtil.getValor(parametros, "conselho");
            this.ufMedico = StringUtil.getValor(parametros, "uf");
            if (!Funcoes.textoVazio(this.codigoConvenio)) {
                HashMap<String, Object> chaves = new HashMap<String, Object>();
                chaves.put("fil_codigo", Variaveis.filialPadrao);
                chaves.put("con_codigo", this.codigoConvenio);
                try {
                    this.con = (ConvenioBean)new ConvenioService().getBean(chaves);
                }
                catch (Exception e) {
                    ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar os dados do conv\u00eanio.\n" + e.getMessage(), e.getStackTrace());
                }
            }
            if (this.con != null) {
                this.codlay = ExameUtil.getCodigoLayout(String.valueOf(this.con.getFilial().getCodigo()), String.valueOf(this.con.getCodigo()), this.con.getDestino().getCodigo());
            }
        }
    }

    private void gravarParametros() throws ThreadDaoException {
        XMLStringBuilder xmlConfiguracao = new XMLStringBuilder();
        xmlConfiguracao.abrir("configuracao");
        xmlConfiguracao.escrever("convenio", this.codigoConvenio);
        xmlConfiguracao.escrever("crm", this.crmMedico);
        xmlConfiguracao.escrever("conselho", this.conselhoMedico);
        xmlConfiguracao.escrever("uf", this.ufMedico);
        try {
            xmlConfiguracao.fechar("configuracao");
        }
        catch (XMLStringBuilderException e) {
            throw new ThreadDaoException("N\u00e3o foi poss\u00edvel montar xml da configura\u00e7\u00e3o da importa\u00e7\u00e3o.");
        }
        ParametrosUsuarios.setValor(CONFIGURACAO, xmlConfiguracao.getXML());
    }

    @Override
    public void threadIniciada(EventObject e) {
        this.isExecutando = true;
        this.controlaCampos();
    }

    @Override
    public void threadFinalizada(EventObject e) {
        this.isExecutando = false;
        this.controlaCampos();
    }

    private void controlaCampos() {
        boolean enabled = !this.isExecutando;
        this.buttonFechar.setEnabled(enabled);
        this.buttonImportar.setEnabled(enabled);
    }

    private DadosExameMaterial getExameMatColeta(Statement st, String codigoExameNefrodata, TipoIdade idade, ArrayList<String> errosCodDescricao) throws Exception {
        if (Funcoes.textoVazio(codigoExameNefrodata)) {
            throw new ThreadDaoException("O c\u00f3digo do exame no Nefrodata n\u00e3o foi informado.\n---> " + codigoExameNefrodata);
        }
        StringBuilder buf = new StringBuilder();
        buf.append(" select b.lay_codigo ");
        buf.append("       ,a.emc_default ");
        buf.append("       ,c.ela_idadeini, c.ela_idadefim, c.ela_idadeinitipo, c.ela_idadefimtipo ");
        buf.append("       ,b.ela_padrao ");
        buf.append("       ,a.exa_codigo as codigoExame ");
        buf.append("       ,a.mco_codigo as codigoMaterial ");
        buf.append("   from examematcoleta a ");
        buf.append("   join examelayout b on a.fil_codigo = b.fil_codigo and a.exa_codigo = b.exa_codigo and a.mco_codigo = b.mco_codigo ");
        buf.append("   left join examelayoutmetodo c on b.fil_codigo = c.fil_codigo and b.exa_codigo = c.exa_codigo ");
        buf.append("         and b.mco_codigo = c.mco_codigo and b.ela_idadeini = c.ela_idadeini and b.ela_idadefim = c.ela_idadefim ");
        buf.append("         and b.ela_idadeinitipo = c.ela_idadeinitipo and b.ela_idadefimtipo = c.ela_idadefimtipo and b.lay_codigo = c.lay_codigo ");
        buf.append("  where a.fil_codigo = ").append(Variaveis.filialPadrao);
        buf.append("    and ((c.ela_idadeini <= ").append(idade.getQuantidade());
        buf.append("         and c.ela_idadefim >= ").append(idade.getQuantidade());
        buf.append("         and c.ela_idadeinitipo = '").append(idade.getTipoIdade()).append("' ");
        buf.append("         and c.ela_idadefimtipo = '").append(idade.getTipoIdade()).append("') ");
        buf.append("         or (c.ela_idadeini = 0 and c.ela_idadefim >= 0))");
        buf.append("    and c.elm_exportartexto ilike '%<pai>").append(codigoExameNefrodata).append("</pai>%'");
        buf.append("    and c.elm_exportartexto is not null ");
        buf.append("    and c.elm_exportartexto <> '' ");
        buf.append("  order by  a.emc_default desc");
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        int linha = 0;
        boolean linhaPadrao = false;
        boolean padrao = false;
        boolean matPadrao = false;
        boolean continuar = rs.next();
        boolean isFinalizado = false;
        while (continuar) {
            boolean idadeZero;
            padrao = rs.getBoolean("ela_padrao");
            matPadrao = rs.getBoolean("emc_default");
            int idIni = rs.getInt("ela_idadeini");
            int idFin = rs.getInt("ela_idadefim");
            String tpIni = rs.getString("ela_idadeinitipo");
            String tpFin = rs.getString("ela_idadefimtipo");
            boolean interValido = ExameUtil.intervaloValido(idIni, idFin, tpIni, tpFin, idade.getTipoIdade(), idade.getQuantidade());
            boolean bl = idadeZero = idIni == 0 && idFin == 0;
            if (idadeZero && linha == 0 || interValido && (this.codlay.equals(rs.getString("lay_codigo")) || matPadrao)) {
                linha = rs.getRow();
                if (this.codlay != null && this.codlay.equals(rs.getString("lay_codigo")) && !rs.next()) {
                    continuar = false;
                }
                rs.absolute(linha);
            }
            if (!continuar) continue;
            continuar = rs.next();
        }
        if (linha > 0) {
            rs.absolute(linha);
            return new DadosExameMaterial(rs.getString("codigoExame"), rs.getInt("codigoMaterial"));
        }
        String descricaoExame = "Exame com c\u00f3digo desconhecido";
        if (this.examesNefroData.containsKey(codigoExameNefrodata)) {
            descricaoExame = "(" + this.examesNefroData.get(codigoExameNefrodata) + ")";
            descricaoExame = descricaoExame + " no Modelo com faixa et\u00e1ria de " + idade.getQuantidade();
            if (idade.getTipoIdade().equalsIgnoreCase("A")) {
                descricaoExame = descricaoExame + (idade.getQuantidade() > 1 ? " anos " : " ano ");
            } else if (idade.getTipoIdade().equalsIgnoreCase("M")) {
                descricaoExame = descricaoExame + (idade.getQuantidade() > 1 ? " meses " : " m\u00eas ");
            } else if (idade.getTipoIdade().equalsIgnoreCase("D")) {
                descricaoExame = descricaoExame + (idade.getQuantidade() > 1 ? " dias " : " dia ");
            }
        }
        errosCodDescricao.add(" - \"" + codigoExameNefrodata + "\" " + descricaoExame);
        return null;
    }

    static class JanelaConfiguracaoImportacaoNefrodata
    extends AbstractDialogoOKCancelar {
        private TTextField textConvenio = new TTextField(10, 1);
        private TTextField textCrmMedico = new TTextField(10, 1);
        private JComboBox comboConselhos = new JComboBox<String>(ConstantesGerais.CONSELHOS);
        private JComboBox comboUfs = new JComboBox<String>(ConstantesGerais.ESTADOS);
        private JLabel labelConvenio = new JLabel("Conv\u00eanio:");
        private JLabel labelMedico = new JLabel("M\u00e9dico:");
        private JLabel labelVlrConvenio = new JLabel();
        private JLabel labelVlrMedico = new JLabel();
        private JButton buttonConvenio = ComponenteFactory.novoJButton(this, new Dimension(20, 20), new Dimension(20, 20), true);
        private JButton buttonMedico = ComponenteFactory.novoJButton(this, new Dimension(20, 20), new Dimension(20, 20), true);
        private String codigoConvenio = null;
        private String crmMedico = null;
        private String conselhoMedico = null;
        private String ufMedico = null;
        private ConvenioVO convenioAux = null;
        private MedicoVO medicoAux = null;

        public static JanelaConfiguracaoImportacaoNefrodata novaInstancia(Window pai, String codigoConvenio, String crmMedico, String conselhoMedico, String ufMedico) {
            if (pai instanceof Frame) {
                return new JanelaConfiguracaoImportacaoNefrodata((Frame)pai, codigoConvenio, crmMedico, conselhoMedico, ufMedico);
            }
            if (pai instanceof Dialog) {
                return new JanelaConfiguracaoImportacaoNefrodata((Dialog)pai, codigoConvenio, crmMedico, conselhoMedico, ufMedico);
            }
            return null;
        }

        private JanelaConfiguracaoImportacaoNefrodata(Dialog pai, String codigoConvenio, String crmMedico, String conselhoMedico, String ufMedico) {
            super(pai, "Configura\u00e7\u00f5es de importa\u00e7\u00e3o");
            this.codigoConvenio = codigoConvenio;
            this.crmMedico = crmMedico;
            this.conselhoMedico = conselhoMedico;
            this.ufMedico = ufMedico;
            this.montaTela();
        }

        private JanelaConfiguracaoImportacaoNefrodata(Frame pai, String codigoConvenio, String crmMedico, String conselhoMedico, String ufMedico) {
            super(pai, "Configura\u00e7\u00f5es de importa\u00e7\u00e3o");
            this.codigoConvenio = codigoConvenio;
            this.crmMedico = crmMedico;
            this.conselhoMedico = conselhoMedico;
            this.ufMedico = ufMedico;
            this.montaTela();
        }

        private void montaTela() {
            JPanel panelCentral = this.getPanelCentral();
            panelCentral.setLayout(new GridBagLayout());
            ScreenUtil.setBorda(new JComponent[]{this.labelVlrConvenio, this.labelVlrMedico}, new TitledBorder(""));
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 17;
            c.fill = 0;
            c.gridheight = 1;
            c.gridwidth = 1;
            c.gridx = 0;
            c.gridy = 0;
            c.insets = new Insets(1, 1, 0, 0);
            c.weightx = 0.0;
            c.weighty = 0.0;
            this.labelConvenio.setDisplayedMnemonic('o');
            this.labelConvenio.setLabelFor(this.textConvenio);
            panelCentral.add((Component)this.labelConvenio, c);
            ++c.gridx;
            c.fill = 2;
            this.textConvenio.setMinimumSize(new Dimension(70, 20));
            this.textConvenio.setPreferredSize(new Dimension(70, 20));
            panelCentral.add((Component)this.textConvenio, c);
            ++c.gridx;
            c.fill = 0;
            panelCentral.add((Component)this.buttonConvenio, c);
            ++c.gridx;
            c.fill = 2;
            c.weightx = 1.0;
            c.gridwidth = 4;
            c.insets = new Insets(1, 1, 0, 1);
            this.labelVlrConvenio.setMinimumSize(new Dimension(20, 20));
            this.labelVlrConvenio.setPreferredSize(new Dimension(20, 20));
            panelCentral.add((Component)this.labelVlrConvenio, c);
            ++c.gridy;
            c.gridx = 0;
            c.fill = 0;
            c.weightx = 0.0;
            c.gridwidth = 1;
            c.insets = new Insets(1, 1, 0, 0);
            this.labelMedico.setDisplayedMnemonic('M');
            this.labelMedico.setLabelFor(this.comboConselhos);
            panelCentral.add((Component)this.labelMedico, c);
            ++c.gridx;
            this.comboConselhos.setMinimumSize(new Dimension(70, 20));
            this.comboConselhos.setPreferredSize(new Dimension(70, 20));
            panelCentral.add((Component)this.comboConselhos, c);
            ++c.gridx;
            c.gridwidth = 2;
            this.comboUfs.setMinimumSize(new Dimension(50, 20));
            this.comboUfs.setPreferredSize(new Dimension(50, 20));
            panelCentral.add((Component)this.comboUfs, c);
            c.gridx += 2;
            c.gridwidth = 1;
            this.textCrmMedico.setMinimumSize(new Dimension(70, 20));
            this.textCrmMedico.setPreferredSize(new Dimension(70, 20));
            panelCentral.add((Component)this.textCrmMedico, c);
            ++c.gridx;
            panelCentral.add((Component)this.buttonMedico, c);
            ++c.gridx;
            c.weightx = 1.0;
            c.fill = 2;
            this.labelVlrMedico.setMinimumSize(new Dimension(20, 20));
            this.labelVlrMedico.setPreferredSize(new Dimension(20, 20));
            c.insets = new Insets(1, 1, 0, 1);
            panelCentral.add((Component)this.labelVlrMedico, c);
            this.textConvenio.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 113) {
                        this.pesquisaConvenio();
                    }
                }
            });
            this.textConvenio.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    if (Funcoes.textoVazio(textConvenio)) {
                        labelVlrConvenio.setText("");
                        convenioAux = null;
                    } else {
                        this.buscaConvenio(Variaveis.filialPadrao, textConvenio.getText());
                    }
                }
            });
            this.textCrmMedico.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 113) {
                        this.pesquisaMedico();
                    }
                }
            });
            this.textCrmMedico.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    if (Funcoes.textoVazio(textCrmMedico)) {
                        labelVlrMedico.setText("");
                        medicoAux = null;
                    } else {
                        this.buscaMedico(Variaveis.filialPadrao, textCrmMedico.getText(), comboUfs.getSelectedItem().toString(), comboConselhos.getSelectedItem().toString());
                    }
                }
            });
            this.setSize(530, 116);
            this.setResizable(false);
            ScreenUtil.centralizar(this);
            this.carregaDados();
            ScreenUtil.requisitarFoco(this.textConvenio);
        }

        private void carregaDados() {
            this.convenioAux = null;
            this.buscaConvenio(Variaveis.filialPadrao, this.codigoConvenio);
            this.medicoAux = null;
            this.buscaMedico(Variaveis.filialPadrao, this.crmMedico, this.ufMedico, this.conselhoMedico);
        }

        private void buscaConvenio(String filial, String codigoConvenio) {
            if (!Funcoes.textoVazio(codigoConvenio)) {
                try {
                    this.convenioAux = (ConvenioVO)new ConvenioService().getVO(filial, codigoConvenio);
                }
                catch (Exception e) {
                    ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar os dados do conv\u00eanio.", e.getStackTrace());
                }
                if (this.convenioAux != null) {
                    this.textConvenio.setText(this.convenioAux.getCodigo().toString());
                    this.labelVlrConvenio.setText(this.convenioAux.getFantasia());
                } else {
                    this.labelVlrConvenio.setText("N\u00e3o cadastrado");
                }
            }
        }

        private void buscaMedico(String filial, String crmMedico, String ufMedico, String conselhoMedico) {
            if (!(Funcoes.textoVazio(crmMedico) || Funcoes.textoVazio(conselhoMedico) || Funcoes.textoVazio(ufMedico))) {
                LinkedHashMap<String, Object> chaves = new LinkedHashMap<String, Object>();
                chaves.put("fil_codigo", filial);
                chaves.put("med_crm", crmMedico);
                chaves.put("med_uf", ufMedico);
                chaves.put("med_conselho", conselhoMedico);
                try {
                    this.medicoAux = (MedicoVO)new MedicoService().getVO(chaves);
                }
                catch (ThreadDaoException e) {
                    ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar os dados do m\u00e9dico.", e.getStackTrace());
                }
                if (this.medicoAux != null) {
                    this.comboConselhos.setSelectedItem(this.medicoAux.getConselho());
                    this.comboUfs.setSelectedItem(this.medicoAux.getUf());
                    this.textCrmMedico.setText(this.medicoAux.getCrm());
                    this.labelVlrMedico.setText(this.medicoAux.getNome());
                } else {
                    this.labelVlrMedico.setText("N\u00e3o cadastrado");
                }
            }
        }

        private boolean validaCampos() {
            if (this.convenioAux == null) {
                return false;
            }
            return this.medicoAux != null;
        }

        @Override
        protected boolean acaoOk() {
            return this.validaCampos();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            if (e.getSource() == this.buttonConvenio) {
                this.pesquisaConvenio();
            } else if (e.getSource() == this.buttonMedico) {
                this.pesquisaMedico();
            }
        }

        private void pesquisaConvenio() {
            ConvenioVO convenio = (ConvenioVO)new ConvenioService().pesquisaVO(this, new ConvenioVO(), "Pesquisando conv\u00eanios", false);
            if (convenio != null) {
                this.convenioAux = convenio;
                this.textConvenio.setText(convenio.getCodigo().toString());
                this.labelVlrConvenio.setText(convenio.getFantasia());
            }
        }

        private void pesquisaMedico() {
            MedicoVO medico = (MedicoVO)new MedicoService().pesquisaVO(this, new MedicoVO(), "Pesquisando m\u00e9dicos", false);
            if (medico != null) {
                this.medicoAux = medico;
                this.comboConselhos.setSelectedItem(medico.getConselho());
                this.comboUfs.setSelectedItem(medico.getUf());
                this.textCrmMedico.setText(medico.getCrm());
                this.labelVlrMedico.setText(medico.getNome());
            }
        }

        public ConvenioVO getConvenio() {
            return this.convenioAux;
        }

        public MedicoVO getMedico() {
            return this.medicoAux;
        }
    }
}

