/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao;

import jalis.apoio.util.Util;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosUsuarios;
import jalis.comum.Variaveis;
import jalis.comum.dados.DadosConvenios;
import jalis.comum.dados.DadosExames;
import jalis.comum.dados.DadosMaterial;
import jalis.comum.padroes.FrmPadrao;
import jalis.laboratorio.exportacao.DadosExameMaterial;
import jalis.laboratorio.exportacao.ExamesNephrosys;
import jalis.laboratorio.exportacao.JanelaConfiguracaoImportacaoNephrosysV2;
import jalis.laboratorio.exportacao.ObjetoDados;
import jalis.laboratorio.exportacao.TipoIdade;
import jalis.model.bean.cadastro.convenio.ConvenioBean;
import jalis.model.vo.cadastro.ConvenioVO;
import jalis.model.vo.cadastro.MedicoVO;
import jalis.service.cadastro.ConvenioService;
import jalis.service.recepcao.RequisicaoService;
import jalis.util.ConvenioUtil;
import jalis.util.DBUtil;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.SplashMensagem;
import jalis.util.StringUtil;
import jalis.util.ThreadFinalizadaListener;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;

public class ImportarNephrosysV2
extends FrmPadrao
implements ActionListener,
ThreadFinalizadaListener {
    private final int TAMANHO_LINHA = 102;
    private JButton buttonImportar = ComponenteFactory.novoJButton("Importar", 'I', this);
    private JButton buttonFechar = ComponenteFactory.novoJButton("Fechar", 'F', this);
    private JButton buttonConfigurar = ComponenteFactory.novoJButton("Configurar", 'C', this);
    private JPanel panelBotoesDireita = ComponenteFactory.novoJPanelFlowLayout(2, this.buttonImportar, this.buttonFechar);
    private JPanel panelBotoesEsquerda = ComponenteFactory.novoJPanelFlowLayout(0, this.buttonConfigurar);
    private JTextArea textInformacoes = new JTextArea();
    private JScrollPane scrollInformacoes = new JScrollPane(this.textInformacoes);
    private String codigoConvenio = null;
    private String conselhoMedico = null;
    private String ufMedico = null;
    private String crmMedico = null;
    private boolean isExecutando = false;
    private RequisicaoService requisicaoService = new RequisicaoService();
    private static final String CONFIGURACAO = "ImportarNephrosysV2.configuracao";
    private static final int[] EXAMES_HEMOGRAMA = new int[]{9, 11, 10, 530, 531, 532, 533, 550, 12, 102, 103, 104, 105, 106, 109, 108, 107, 101, 121, 122, 110, 120, 15};

    public ImportarNephrosysV2() {
        this.montaTela();
        this.carregarParametros();
    }

    private void montaTela() {
        this.setLayout(new BorderLayout());
        Funcoes.criaBarraDescricao(this, "Importa\u00e7\u00e3o NephrosysV2", "Importa\u00e7\u00e3o de Requisi\u00e7\u00e3o de Exames do Nephrosys", "integracao/importar_result_nephrosys.jpg");
        JPanel panelInformacoes = new JPanel(new BorderLayout());
        panelInformacoes.setBorder(new TitledBorder("Informa\u00e7\u00f5es"));
        JPanel panelBotoes = new JPanel(new BorderLayout());
        this.add((Component)panelInformacoes, "Center");
        this.add((Component)panelBotoes, "South");
        panelInformacoes.add(this.scrollInformacoes);
        panelBotoes.add((Component)this.panelBotoesDireita, "East");
        panelBotoes.add((Component)this.panelBotoesEsquerda, "West");
        this.textInformacoes.setFont(new Font("Monospaced", 0, 12));
        this.textInformacoes.setEditable(false);
    }

    protected void importaArquivo() {
        try {
            if (!this.validaConfiguracoes()) {
                Funcoes.mensagem(this, "As configura\u00e7\u00f5es devem ser feitas antes de importar.", 2);
                return;
            }
            JFileChooser chooser = ComponenteFactory.novoJFileChooser();
            chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
            chooser.setFileFilter(ComponenteFactory.novoFileFilter("Arquivo TXT do Nephrosys (*.txt)", "txt"));
            if (chooser.showOpenDialog(this) == 0) {
                File file = new File(chooser.getSelectedFile().getPath());
                this.textInformacoes.setText("Importando exames...");
                this.processaArquivo(file);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
        }
    }

    private boolean validaConfiguracoes() {
        if (Funcoes.textoVazio(this.codigoConvenio)) {
            return false;
        }
        if (Funcoes.textoVazio(this.conselhoMedico)) {
            return false;
        }
        if (Funcoes.textoVazio(this.crmMedico)) {
            return false;
        }
        return !Funcoes.textoVazio(this.ufMedico);
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0910001700");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processaArquivo(File arquivo) throws Exception {
        if (arquivo == null) {
            return;
        }
        StringBuilder bufInformacoes = new StringBuilder();
        SplashMensagem splash = SplashMensagem.getInstancia(this);
        try {
            splash.mostrar("Importando arquivo. Aguarde...");
            String conteudoArquivo = StringUtil.lerArquivoTexto(arquivo);
            if (!this.validaArquivo(conteudoArquivo.toString()) && !this.validaArquivo((conteudoArquivo = StringUtil.lerArquivoTexto(arquivo, "utf-8")).toString())) {
                splash.apagar();
                Funcoes.mensagem(this, "Layout incorreto de arquivo Nephrosys.", 2);
                return;
            }
            ArrayList<Exception> erros = new ArrayList<Exception>();
            LinkedHashMap<String, ArrayList<ObjetoDados>> arquivoTokenizado = null;
            try {
                arquivoTokenizado = this.tokenizaArquivo(conteudoArquivo.toString());
            }
            catch (Exception e) {
                erros.add(e);
            }
            conteudoArquivo = null;
            System.gc();
            Statement st = Conexao.getStatement();
            try {
                ArrayList<String> listaRequisicoesInseridas = this.processaLinhas(st, arquivoTokenizado, erros);
                bufInformacoes.append("Importa\u00e7\u00e3o finalizada.");
                if (erros != null && erros.size() > 0) {
                    throw new Exception();
                }
                Conexao.arquivaSQL();
                this.imprimeRequisicoesImportadas(listaRequisicoesInseridas, bufInformacoes);
            }
            catch (Exception e) {
                try {
                    Conexao.anulaSQL();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.imprimeErros(erros, bufInformacoes);
            }
        }
        finally {
            this.textInformacoes.setText(bufInformacoes.toString());
            splash.apagar();
        }
    }

    private void imprimeRequisicoesImportadas(ArrayList<String> listaRequisicoesInseridas, StringBuilder buf) {
        if (listaRequisicoesInseridas == null) {
            return;
        }
        buf.append("\n\nIMPORTA\u00c7\u00c3O FINALIZADA COM SUCESSO.\n\n");
        buf.append("+-----------------------------------------+----------------------------------------------+\n");
        buf.append("|                               REQUISI\u00c7\u00d5ES INSERIDAS                                    |\n");
        buf.append("+-----------------------------------------+----------------------------------------------+");
        for (String req : listaRequisicoesInseridas) {
            buf.append("\n|" + StringUtil.formatarColuna(req, 88, 'e') + "|");
        }
        buf.append("\n+-----------------------------------------+----------------------------------------------+");
    }

    private void imprimeErros(ArrayList<Exception> erros, StringBuilder buf) {
        if (erros == null) {
            return;
        }
        buf.append("\n\nFORAM DETECTADOS PROBLEMAS AO IMPORTAR.\n\n");
        buf.append("+-----------------------------------------+----------------------------------------------+\n");
        buf.append("|                                      PROBLEMAS                                         |\n");
        buf.append("+-----------------------------------------+----------------------------------------------+");
        for (Exception erro : erros) {
            buf.append("\n|" + StringUtil.formatarColuna(Funcoes.textoVazio(erro.getMessage()) ? "NullPointerException" : erro.getMessage(), 88, 'c') + "|");
        }
        buf.append("\n+-----------------------------------------+----------------------------------------------+");
    }

    private ArrayList<String> processaLinhas(Statement st, LinkedHashMap<String, ArrayList<ObjetoDados>> conteudo, ArrayList<Exception> erros) throws Exception {
        if (conteudo == null) {
            erros.add(new Exception("Arquivo sem conte\u00fado."));
            return null;
        }
        ArrayList<String> listaRequisicoesInseridas = new ArrayList<String>();
        for (String prontuario : conteudo.keySet()) {
            try {
                ArrayList<ObjetoDados> dados = conteudo.get(prontuario);
                Integer codigoRequisicao = this.insereRequisicao(st, prontuario, dados);
                listaRequisicoesInseridas.add("Prontu\u00e1rio: " + prontuario + " - C\u00f3d. Req.: " + codigoRequisicao + ", Pac.: " + dados.get(0).getNomePaciente() + ".");
            }
            catch (Exception e) {
                if (erros == null) continue;
                erros.add(e);
            }
        }
        return listaRequisicoesInseridas;
    }

    private Integer insereRequisicao(Statement st, String prontuario, ArrayList<ObjetoDados> exames) throws Exception {
        ObjetoDados dados = exames.get(0);
        Date dataAux = new Date();
        Integer codigoRequisicao = this.getSequencialRequisicao(st);
        TipoIdade idade = new TipoIdade(dados.getDataNascimento(), dataAux, "yyyy-MM-dd");
        Integer codigoPaciente = this.inserePaciente(st, dados, idade, dataAux);
        LinkedHashMap<String, Object> chaves = new LinkedHashMap<String, Object>();
        chaves.put("fil_codigo", Variaveis.filialPadrao);
        chaves.put("con_codigo", this.codigoConvenio);
        ConvenioBean convenioBean = (ConvenioBean)new ConvenioService().getBean(chaves);
        StringBuilder buf = new StringBuilder();
        buf.append(" insert into requisicao ");
        buf.append("       (fil_codigo ");
        buf.append("       ,req_codigo ");
        buf.append("       ,req_prontuario ");
        buf.append("       ,con_codigo ");
        buf.append("       ,med_crm ");
        buf.append("       ,med_conselho ");
        buf.append("       ,med_uf ");
        buf.append("       ,pac_codigo ");
        buf.append("       ,req_urgente ");
        buf.append("       ,req_avisarpaciente ");
        buf.append("       ,req_imprimirseparado ");
        buf.append("       ,req_totpago ");
        buf.append("       ,req_total ");
        buf.append("       ,req_vlrexames ");
        buf.append("       ,req_vlrmateriais ");
        buf.append("       ,req_data ");
        buf.append("       ,req_hora ");
        buf.append("       ,req_gestante ");
        buf.append("       ,req_neonato ");
        buf.append("       ,req_idade ");
        buf.append("       ,req_anomes ");
        buf.append("       ,req_quarto ");
        buf.append("       ,req_leito ");
        buf.append("       ,req_desconto ");
        buf.append("       ,req_vlrdesconto ");
        buf.append("       ,req_acrescimo ");
        buf.append("       ,req_vlracrescimo ");
        buf.append("       ,req_telacoleta ");
        buf.append("       ,est_codigo ");
        buf.append("       ,usr_codigo ");
        buf.append("       ,req_datarequisicao ");
        buf.append("       ,usr_codabertura ");
        buf.append("       ,req_validadeguia ");
        buf.append("       ,req_deveguia ");
        buf.append("       ,req_guia ");
        buf.append("       ,req_excluida ");
        buf.append("       ,req_dtfatura ");
        buf.append("       ,req_horafatura ");
        buf.append("       ,col_codigo ");
        buf.append("       ,des_codigo ");
        buf.append("       ,req_senhaweb ");
        buf.append("       ,req_codigoapoiado ");
        buf.append("       ,req_valorminimo ");
        buf.append("       ,req_percentualmaterialbalcao ");
        buf.append("       ,req_totaltaxa ");
        buf.append(" ) ");
        buf.append(" values (");
        buf.append(Variaveis.filialPadrao);
        buf.append(",").append(codigoRequisicao);
        buf.append(",").append(ImportarNephrosysV2.getTextoSql(prontuario, false));
        buf.append(",").append(this.codigoConvenio);
        buf.append(",").append(this.crmMedico);
        buf.append(",").append(ImportarNephrosysV2.getTextoSql(this.conselhoMedico, false));
        buf.append(",").append(ImportarNephrosysV2.getTextoSql(this.ufMedico, false));
        buf.append(",").append(codigoPaciente);
        buf.append(",false ");
        buf.append(",false ");
        buf.append(",false ");
        buf.append(",0 ");
        buf.append(",0 ");
        buf.append(",0 ");
        buf.append(",0 ");
        buf.append(",").append(ImportarNephrosysV2.getTextoSql(Funcoes.formataData("yyyy-MM-dd", dataAux), false));
        buf.append(",date_trunc('minute', cast(LOCALTIMESTAMP as time)) ");
        buf.append(",false ");
        buf.append(",false ");
        buf.append(",").append(idade.getQuantidade() == null ? "0" : idade.getQuantidade());
        buf.append(",").append(ImportarNephrosysV2.getTextoSql(idade.getTipoIdade()));
        buf.append(",null ");
        buf.append(",null ");
        buf.append(",0 ");
        buf.append(",0 ");
        buf.append(",0 ");
        buf.append(",0 ");
        buf.append(",false ");
        buf.append(",").append(Variaveis.codigoEstacao);
        buf.append(",").append(ImportarNephrosysV2.getTextoSql(Variaveis.login, false));
        buf.append(",LOCALTIMESTAMP ");
        buf.append(",").append(ImportarNephrosysV2.getTextoSql(Variaveis.login, false));
        buf.append(",null ");
        buf.append(",false ");
        buf.append(",null ");
        buf.append(",false ");
        buf.append(",").append(ImportarNephrosysV2.getTextoSql(Funcoes.formataData("yyyy-MM-dd", dataAux), false));
        buf.append(",date_trunc('minute', cast(LOCALTIMESTAMP as time)) ");
        buf.append(",").append(ImportarNephrosysV2.getTextoSql(convenioBean.getColeta().getCodigo(), false));
        buf.append(",").append(ImportarNephrosysV2.getTextoSql(convenioBean.getDestino().getCodigo(), false));
        buf.append(",").append(ImportarNephrosysV2.getTextoSql(Funcoes.gerarSenhaWeb(), false));
        buf.append(",").append(ImportarNephrosysV2.getTextoSql(prontuario, false));
        buf.append(",").append(ImportarNephrosysV2.getValorSql(convenioBean.getMinimoRequisicao().toString()));
        buf.append(",").append(ImportarNephrosysV2.getValorSql(convenioBean.getPercentualPagamentoMaterial().toString()));
        buf.append(",").append(ImportarNephrosysV2.getValorSql(convenioBean.getValorTotalTaxa().toString()));
        buf.append(" ) ");
        int qtde = Conexao.executeUpdate(Variaveis.filialPadrao, st, buf.toString(), true);
        if (qtde > 0) {
            this.insereExamesRequisicao(st, codigoRequisicao, dataAux, idade, exames);
            Util.exportaWebRequisicao(Variaveis.filialPadrao, codigoRequisicao.toString(), true);
            return codigoRequisicao;
        }
        throw new Exception("A requisi\u00e7\u00e3o n\u00e3o foi inserida.");
    }

    private void insereExamesRequisicao(Statement st, Integer codigoRequisicao, Date dataRequisicao, TipoIdade idade, ArrayList<ObjetoDados> exames) throws Exception {
        ArrayList<DadosExameMaterial> listaExamesJalis = new ArrayList<DadosExameMaterial>();
        boolean haHemograma = this.verificaHaHemograma(exames);
        boolean isHemogramaInserido = false;
        for (ObjetoDados exame : exames) {
            boolean exameParteHemograma;
            boolean bl = exameParteHemograma = haHemograma && this.verificaExameListaHemograma(exame);
            if (isHemogramaInserido && exameParteHemograma) continue;
            DadosExameMaterial dadosExameMaterialJalis = this.getExameMatColeta(st, exame.getCodigoExame(), idade, exameParteHemograma);
            if (exameParteHemograma) {
                isHemogramaInserido = true;
            }
            if (listaExamesJalis.contains(dadosExameMaterialJalis)) continue;
            DadosMaterial dadosMaterial = ExameUtil.getDadosMaterial(Variaveis.filialPadrao, dadosExameMaterialJalis.getCodigoMaterial(), st);
            DadosExames dadosExame = ExameUtil.getDadosExame(Variaveis.filialPadrao, dadosExameMaterialJalis.getCodigoExame(), dadosMaterial, st);
            DadosConvenios dadosConvenio = ConvenioUtil.getDadosConvenios(Variaveis.filialPadrao, Integer.parseInt(this.codigoConvenio), st);
            ExameUtil.calculaPrecoExame(Variaveis.filialPadrao, dadosExame, dadosMaterial, dadosConvenio, false, true, false, null, null, (Integer)Integer.parseInt(dadosExame.getCodMetodo()), st);
            StringBuilder buf = new StringBuilder();
            buf.append(" insert into examerequisicao ");
            buf.append("       (fil_codigo ");
            buf.append("       ,req_codigo ");
            buf.append("       ,exa_codigo ");
            buf.append("       ,mco_codigo ");
            buf.append("       ,exr_dataetqcoleta ");
            buf.append("       ,exr_situacao ");
            buf.append("       ,exr_excluido ");
            buf.append("       ,usr_codigo ");
            buf.append("       ,exr_data ");
            buf.append("       ,exr_vlrchexame ");
            buf.append("       ,exr_vlrexame ");
            buf.append("       ,exr_vlrmaterial ");
            buf.append("       ,exr_valorporte ");
            buf.append("       ,exr_valorcusto ");
            buf.append("       ,exr_porte ");
            buf.append("       ,exr_valoruco ");
            buf.append("       ,exr_valorchexamerepasse ");
            buf.append("       ,exr_valorchrepasse ");
            buf.append("       ,exr_valorporterepasse ");
            buf.append("       ,exr_valorcustorepasse ");
            buf.append("       ,exr_porterepasse ");
            buf.append("       ,exr_valorucorepasse ");
            buf.append("       ,exr_guia ");
            buf.append("       ,exr_validadeguia ");
            buf.append("       ,exr_codautorizacao ");
            buf.append("       ,exr_custosimples ");
            buf.append("       ,met_codigo ");
            buf.append("       ,exr_ordem ");
            buf.append("       ,exr_vlrch ");
            buf.append("       ,exr_vlrbalcaoconvenio ");
            buf.append(" ) ");
            buf.append("     values (").append(Variaveis.filialPadrao);
            buf.append(" ,").append(codigoRequisicao);
            buf.append(" ,").append(ImportarNephrosysV2.getTextoSql(dadosExame.getCodigo()));
            buf.append(" ,").append(dadosMaterial.getCodigo());
            buf.append(" ,null ");
            buf.append(" ,").append(ImportarNephrosysV2.getTextoSql("T"));
            buf.append(" ,false ");
            buf.append(" ,").append(ImportarNephrosysV2.getTextoSql(Variaveis.login, false));
            buf.append(" ,").append(ImportarNephrosysV2.getTextoSql(Funcoes.formataData("yyyy-MM-dd HH:mm:ss", dataRequisicao), false));
            buf.append(" ,").append(dadosExame.getValorCH().doubleValue());
            buf.append(" ,").append(dadosExame.getValorExame().doubleValue());
            buf.append(" ,").append(dadosExame.getValorMaterial().doubleValue());
            buf.append(" ,").append(dadosExame.getValorPorte().doubleValue());
            buf.append(" ,").append(dadosExame.getCusto().doubleValue());
            buf.append(" ,").append(dadosExame.getPorte());
            buf.append(" ,0 ");
            buf.append(" ,0 ");
            buf.append(" ,0 ");
            buf.append(" ,0 ");
            buf.append(" ,0 ");
            buf.append(" ,null ");
            buf.append(" ,0 ");
            buf.append(" ,null ");
            buf.append(" ,null ");
            buf.append(" ,null ");
            buf.append(" ,").append(this.requisicaoService.valorExameCustoSimples(dadosExame.getCodigo(), dadosMaterial.getCodigo(), Variaveis.filialPadrao));
            buf.append(" ,").append(Funcoes.textoVazio(dadosExame.getCodMetodo()) ? "null" : dadosExame.getCodMetodo());
            buf.append(" , ").append(dadosExame.getOrdem());
            buf.append(" ,").append(ImportarNephrosysV2.getValorSql(dadosExame.getValorCH().toString()));
            buf.append(" ,").append(ImportarNephrosysV2.getValorSql(dadosExame.getPercentualBalcaoExames().toString()));
            buf.append(" ) ");
            int qtde = Conexao.executeUpdate(Variaveis.filialPadrao, st, buf.toString(), true);
            DBUtil.gravaLogSituacaoExameRequisicao(Conexao.getStatement(), Variaveis.filialPadrao, codigoRequisicao.toString(), dadosExame.getCodigo(), "" + dadosMaterial.getCodigo(), "T", true);
            if (qtde == 0) {
                throw new Exception("O exame n\u00e3o foi inserido.");
            }
            listaExamesJalis.add(dadosExameMaterialJalis);
        }
    }

    private boolean verificaHaHemograma(ArrayList<ObjetoDados> exames) {
        int qtde = 0;
        for (ObjetoDados exame : exames) {
            if (!this.verificaExameListaHemograma(exame)) continue;
            ++qtde;
        }
        return qtde == EXAMES_HEMOGRAMA.length;
    }

    private boolean verificaExameListaHemograma(ObjetoDados exame) {
        int codigoExame = Integer.parseInt(exame.getCodigoExame());
        for (int codigoExameAux : EXAMES_HEMOGRAMA) {
            if (codigoExame != codigoExameAux) continue;
            return true;
        }
        return false;
    }

    private Integer getSequencialRequisicao(Statement st) throws Exception {
        StringBuilder buf = new StringBuilder();
        buf.append(" select nextval('requisicao_").append(Variaveis.filialPadrao).append("_sequence') as codigo ");
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        if (rs.next()) {
            return rs.getInt("codigo");
        }
        throw new Exception("N\u00e3o foi poss\u00edvel requisitar o sequencial para a requisi\u00e7\u00e3o.");
    }

    private Integer inserePaciente(Statement st, ObjetoDados dados, TipoIdade idade, Date dataAux) throws Exception {
        if (!Funcoes.textoVazio(dados.getCpfPaciente())) {
            StringBuilder buf = new StringBuilder();
            buf.append(" select pac_codigo as codigo ");
            buf.append("   from paciente ");
            buf.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
            buf.append("   and length(trim(pac_cpf)) > 0 ");
            buf.append("   and trim(replace(replace(pac_cpf, '.', ''), '-', '')) = '").append(dados.getCpfPaciente()).append("'");
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                return rs.getInt("codigo");
            }
        }
        Integer codigoPaciente = this.getSequencialPaciente(st);
        StringBuilder buf = new StringBuilder();
        buf.append("  insert into paciente ");
        buf.append("        (fil_codigo ");
        buf.append("        ,pac_codigo ");
        buf.append("        ,pac_nome ");
        buf.append("        ,pac_datanasc ");
        buf.append("        ,pac_sexo ");
        buf.append("        ,pac_cpf ");
        buf.append("        ,pac_senhaweb ");
        buf.append("        ,pac_anomes ");
        buf.append("        ,pac_idade ");
        buf.append(" ) ");
        buf.append(" values (");
        buf.append(Variaveis.filialPadrao);
        buf.append(",").append(codigoPaciente);
        buf.append(",").append(ImportarNephrosysV2.getTextoSql(dados.getNomePaciente()));
        buf.append(",").append(ImportarNephrosysV2.getTextoSql(dados.getDataNascimento() + " 00:00"));
        buf.append(",").append(ImportarNephrosysV2.getTextoSql(dados.getSexoPaciente()));
        buf.append(",").append(ImportarNephrosysV2.getTextoSql(dados.getCpfPaciente()));
        buf.append(",").append(ImportarNephrosysV2.getTextoSql(Funcoes.gerarSenhaWeb()));
        buf.append(",").append(ImportarNephrosysV2.getTextoSql(idade.getTipoIdade()));
        buf.append(",").append(idade.getQuantidade());
        buf.append(") ");
        int qtde = Conexao.executeUpdate(Variaveis.filialPadrao, st, buf.toString(), true);
        if (qtde == 0) {
            throw new Exception("O paciente \"" + dados.getNomePaciente() + "\" n\u00e3o foi inserido.");
        }
        Util.exportaWebPaciente(Variaveis.filialPadrao, codigoPaciente.toString(), true, Conexao.getStatement());
        return codigoPaciente;
    }

    private static String getTextoSql(String texto) {
        return ImportarNephrosysV2.getTextoSql(texto, true);
    }

    private static String getTextoSql(String texto, boolean podeUtilizarUppercase) {
        if (Funcoes.textoVazio(texto)) {
            return "null";
        }
        if (podeUtilizarUppercase && ParametrosGerais.getUpperCase()) {
            return "'" + StringUtil.textoDB(texto.toString().toUpperCase()) + "'";
        }
        return "'" + StringUtil.textoDB(texto.toString()) + "'";
    }

    private static String getValorSql(String texto) {
        if (Funcoes.textoVazio(texto)) {
            return "0";
        }
        return "'" + StringUtil.textoDB(texto.toString()) + "'";
    }

    private Integer getSequencialPaciente(Statement st) throws Exception {
        StringBuilder buf = new StringBuilder();
        buf.append(" select nextval('paciente_").append(Variaveis.filialPadrao).append("_sequence') as codigo ");
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        if (rs.next()) {
            return rs.getInt("codigo");
        }
        throw new Exception("N\u00e3o foi poss\u00ed\u00advel requisitar o sequencial para o paciente.");
    }

    private LinkedHashMap<String, ArrayList<ObjetoDados>> tokenizaArquivo(String conteudo) throws Exception {
        if (Funcoes.textoVazio(conteudo)) {
            return null;
        }
        LinkedHashMap<String, ArrayList<ObjetoDados>> retorno = new LinkedHashMap<String, ArrayList<ObjetoDados>>();
        StringTokenizer tokenizer = new StringTokenizer(conteudo, "\n", false);
        int numeroLinha = 1;
        while (tokenizer.hasMoreTokens()) {
            String linha = tokenizer.nextToken().trim();
            if (linha.length() != 102) continue;
            String prontuario = linha.substring(0, 10);
            if (!Funcoes.isNumeric(prontuario)) {
                throw new Exception("N\u00famero do prontu\u00e1rio inv\u00e1lido: \"" + prontuario + "\".");
            }
            if (Integer.parseInt(prontuario) == 0) {
                throw new Exception("N\u00famero do prontu\u00e1rio zerado.");
            }
            if (!retorno.containsKey(prontuario)) {
                ArrayList<ObjetoDados> exames = new ArrayList<ObjetoDados>();
                ObjetoDados dado = new ObjetoDados(linha, numeroLinha++);
                exames.add(dado);
                retorno.put(prontuario, exames);
                continue;
            }
            retorno.get(prontuario).add(new ObjetoDados(linha, numeroLinha++));
        }
        return retorno;
    }

    private boolean validaArquivo(String conteudo) {
        if (Funcoes.textoVazio(conteudo)) {
            return false;
        }
        StringTokenizer tokenizer = new StringTokenizer(conteudo, "\n", false);
        while (tokenizer.hasMoreTokens()) {
            String linha = tokenizer.nextToken().trim();
            if (linha.length() <= 0 || linha.length() == 102) continue;
            return false;
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonImportar) {
            this.importaArquivo();
        } else if (e.getSource() == this.buttonFechar) {
            this.setVisible(false);
        } else if (e.getSource() == this.buttonConfigurar) {
            this.configurar();
        }
    }

    private void configurar() {
        JanelaConfiguracaoImportacaoNephrosysV2 janela = JanelaConfiguracaoImportacaoNephrosysV2.novaInstancia((Window)this.getTopLevelAncestor(), this.codigoConvenio, this.crmMedico, this.conselhoMedico, this.ufMedico);
        janela.setVisible(true);
        if (janela.getOK()) {
            ConvenioVO convenioAux = janela.getConvenio();
            MedicoVO medicoAux = janela.getMedico();
            this.codigoConvenio = convenioAux.getCodigo().toString();
            this.crmMedico = medicoAux.getCrm();
            this.conselhoMedico = medicoAux.getConselho();
            this.ufMedico = medicoAux.getUf();
            this.gravarParametros();
        }
    }

    private void carregarParametros() {
        if (ParametrosUsuarios.contemParametro(CONFIGURACAO)) {
            String parametros = StringUtil.getValor(ParametrosUsuarios.getValor(CONFIGURACAO), "configuracao");
            this.codigoConvenio = StringUtil.getValor(parametros, "convenio");
            this.crmMedico = StringUtil.getValor(parametros, "crm");
            this.conselhoMedico = StringUtil.getValor(parametros, "conselho");
            this.ufMedico = StringUtil.getValor(parametros, "uf");
        }
    }

    private void gravarParametros() {
        XMLStringBuilder xmlConfiguracao = new XMLStringBuilder();
        xmlConfiguracao.abrir("configuracao");
        xmlConfiguracao.escrever("convenio", this.codigoConvenio);
        xmlConfiguracao.escrever("crm", this.crmMedico);
        xmlConfiguracao.escrever("conselho", this.conselhoMedico);
        xmlConfiguracao.escrever("uf", this.ufMedico);
        try {
            xmlConfiguracao.fechar("configuracao");
        }
        catch (XMLStringBuilderException e) {
            ErrorLogger.mostraMensagem(this, "Erro ao montar xml da configura\u00e7\u00e3o.\n" + e.getMessage(), e.getStackTrace());
        }
        ParametrosUsuarios.setValor(CONFIGURACAO, xmlConfiguracao.getXML());
    }

    @Override
    public void threadIniciada(EventObject e) {
        this.isExecutando = true;
        this.controlaCampos();
    }

    @Override
    public void threadFinalizada(EventObject e) {
        this.isExecutando = false;
        this.controlaCampos();
    }

    private void controlaCampos() {
        boolean enabled = !this.isExecutando;
        this.buttonFechar.setEnabled(enabled);
        this.buttonImportar.setEnabled(enabled);
    }

    private DadosExameMaterial getExameMatColeta(Statement st, String codigoExameNephrosys, TipoIdade idade, boolean isHemograma) throws Exception {
        if (Funcoes.textoVazio(codigoExameNephrosys)) {
            throw new Exception("O c\u00f3digo do exame no Nephrosys V2 n\u00e3o foi informado.");
        }
        StringBuilder buf = new StringBuilder();
        buf.append(" select a.exa_codigo as codigoExame ");
        buf.append("       ,a.mco_codigo as codigoMaterial ");
        buf.append("   from examematcoleta a ");
        buf.append("   join examelayout b on a.fil_codigo = b.fil_codigo and a.exa_codigo = b.exa_codigo and a.mco_codigo = b.mco_codigo ");
        buf.append("   left join examelayoutmetodo c on b.fil_codigo = c.fil_codigo and b.exa_codigo = c.exa_codigo ");
        buf.append("         and b.mco_codigo = c.mco_codigo and b.ela_idadeini = c.ela_idadeini and b.ela_idadefim = c.ela_idadefim ");
        buf.append("         and b.ela_idadeinitipo = c.ela_idadeinitipo and b.ela_idadefimtipo = c.ela_idadefimtipo and b.lay_codigo = c.lay_codigo ");
        buf.append("  where a.fil_codigo = ").append(Variaveis.filialPadrao);
        buf.append("    and ((c.ela_idadeini <= ").append(idade.getQuantidade());
        buf.append("    and c.ela_idadefim >= ").append(idade.getQuantidade());
        buf.append("    and c.ela_idadeinitipo = '").append(idade.getTipoIdade()).append("' ");
        buf.append("    and c.ela_idadefimtipo = '").append(idade.getTipoIdade()).append("') ");
        buf.append("        or (c.ela_idadeini = 0 and c.ela_idadefim >= 0)) ");
        buf.append("    and c.elm_exportartexto ilike '%<").append("exportarnephrosys2").append(">%' ");
        if (isHemograma) {
            buf.append("    and c.elm_exportartexto ilike '%<").append("hemograma").append(">true</").append("hemograma").append(">%' ");
        } else {
            buf.append("    and not c.elm_exportartexto ilike '%<").append("hemograma").append(">true</").append("hemograma").append(">%' ");
            buf.append("    and (c.elm_exportartexto ilike '%<").append("pai").append(">").append(codigoExameNephrosys).append("</").append("pai").append(">%' ");
            buf.append("    or c.elm_exportartexto ilike '%<").append("valor").append(">").append(codigoExameNephrosys).append("</").append("valor").append(">%' )");
        }
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        if (rs.next()) {
            return new DadosExameMaterial(rs.getString("codigoExame"), rs.getInt("codigoMaterial"));
        }
        ExamesNephrosys exame = ExamesNephrosys.getExame(codigoExameNephrosys, isHemograma);
        if (isHemograma) {
            throw new Exception("Hemograma n\u00e3o localizado.");
        }
        throw new Exception("Nenhum exame localizado com o c\u00f3digo do Nephrosys = \"" + codigoExameNephrosys + "\"" + (exame == null ? "." : " (" + exame.descricao + ")."));
    }
}

