/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao;

import jalis.comum.Conexao;
import jalis.comum.ParametrosUsuarios;
import jalis.comum.Variaveis;
import jalis.laboratorio.cadastro.ConfiguradorResultadoTexto;
import jalis.laboratorio.digitacao.Resultado;
import jalis.laboratorio.exportacao.SemResultado;
import jalis.laboratorio.exportacao.texto.CampoDetalhe;
import jalis.laboratorio.exportacao.texto.CampoValor;
import jalis.util.CheckItemFiltro;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.SplashMensagem;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.CorTableCellRenderer;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableModel;

public class ExportarResultadoTexto
extends JPanel
implements ActionListener,
ListSelectionListener {
    private static final long ACESSO = Long.parseLong("0906000101");
    private final int COLUNA_EXAMES = 2;
    private CheckItemFiltro itemColeta;
    private CheckItemFiltro itemConvenio;
    private CheckItemFiltro itemDestino;
    private CheckItemFiltro itemExame;
    private JCheckBox itemRelacionamento;
    private TTextField textDataIni = new TTextField(0, 4);
    private TTextField textDataFin = new TTextField(0, 4);
    private JLabel labelDataIni = new JLabel("Data Inicial:");
    private JLabel labelDataFin = new JLabel("Data Final:");
    private JButton buttonDataIni = ComponenteFactory.novoJButton(this, null, new Dimension(20, 20), true);
    private JButton buttonDataFin = ComponenteFactory.novoJButton(this, null, new Dimension(20, 20), true);
    private JButton buttonConsultar = ComponenteFactory.novoJButton("Consultar", 'C', this, null, null);
    private JButton buttonNovo = ComponenteFactory.novoJButton("Novo", 'N', this, null, null);
    private JButton buttonExportar = ComponenteFactory.novoJButton("Exportar", 'E', this, null, null);
    private JButton buttonFechar = ComponenteFactory.novoJButton("Fechar", 'F', this, null, null);
    private JPanel panelRequisicoes = new JPanel(new BorderLayout());
    private JPanel panelExames = new JPanel(new BorderLayout());
    private JSplitPane splitCentral = new JSplitPane(1, this.panelRequisicoes, this.panelExames);
    private ModeloGridTable modeloRequisicoes = new ModeloGridTable(new String[]{"Requisi\u00e7\u00e3o", "Paciente"});
    private CorTableCellRenderer renderer = new CorTableCellRenderer();
    private JTable tableRequisicoes = ComponenteFactory.novoJTable((TableModel)this.modeloRequisicoes, (ListSelectionListener)this, 70, 0);
    private JScrollPane scrollRequisicoes = new JScrollPane(this.tableRequisicoes);
    private ModeloGridTable modeloExames = new ModeloGridTable(new String[]{"C\u00f3d.", "Mat.", "Exame", "Sit."});
    private JTable tableExames = ComponenteFactory.novoJTable((TableModel)this.modeloExames, null, 50, 30, 0, 20);
    private JScrollPane scrollExames = new JScrollPane(this.tableExames);
    private JCheckBox checkGerarXML = new JCheckBox("Criar arquivo utilizando XML para os campos");
    private int posicaoDivisor = 350;
    private static final String EXIBIR_EXAMES = "ExportarResultadoTexto.exibirExames";
    private static final String POSICAO_DIVISOR = "ExportarResultadoTexto.posicaoDivisor";
    private static final String ULTIMO_FILTRO = "ExportarResultadoTexto.ultimoFiltro";
    private ArrayList<Registro> requisicoes = new ArrayList();

    public ExportarResultadoTexto() {
        this.montaTela();
        this.tableRequisicoes.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127 && ExportarResultadoTexto.this.tableRequisicoes.getSelectedRow() > -1) {
                    ExportarResultadoTexto.this.excluirRequisicao();
                }
            }
        });
    }

    private void montaTela() {
        this.setLayout(new BorderLayout());
        Funcoes.criaBarraDescricao(this, "Exportar resultados para texto", "Exporta\u00e7\u00e3o de resultados para arquivos de texto", "integracao/export_result_text.jpg");
        Dimension dimensionFiltro = new Dimension(180, 20);
        Dimension dimensionText = new Dimension(90, 20);
        Dimension dimensionButton = new Dimension(20, 20);
        JPanel panelAux = new JPanel();
        panelAux.setLayout(new BorderLayout());
        this.add((Component)panelAux, "Center");
        JPanel panel = new JPanel();
        panelAux.add((Component)panel, "North");
        panel.setBorder(BorderFactory.createTitledBorder("Filtro"));
        panel.setLayout(new GridBagLayout());
        this.itemColeta = new CheckItemFiltro("Coleta", "Filtrar", "Filtrando coletas", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemColeta.setDados("coletas", new String[]{"col_codigo", "col_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemColeta.setColunaHint(1);
        this.itemColeta.setPreferredSize(dimensionFiltro);
        this.itemColeta.setMinimumSize(dimensionFiltro);
        this.itemConvenio = new CheckItemFiltro("Conv\u00eanio", "Filtrar", "Filtrando conv\u00eanios", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemConvenio.setDados("convenios", new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Fantasia"}, new int[]{70, 0});
        this.itemConvenio.setColunaHint(1);
        this.itemConvenio.setPreferredSize(dimensionFiltro);
        this.itemConvenio.setMinimumSize(dimensionFiltro);
        this.itemRelacionamento = ComponenteFactory.novoJCheckBox("Apenas exames com relacionamento", this);
        this.itemRelacionamento.setPreferredSize(dimensionFiltro);
        this.itemRelacionamento.setMinimumSize(dimensionFiltro);
        this.itemExame = new CheckItemFiltro("Exame", "Filtrar", "Filtrando exames", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemExame.setDados("exames", new String[]{"exa_codigo", "exa_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemExame.setColunaHint(1);
        this.itemExame.setPreferredSize(dimensionFiltro);
        this.itemExame.setMinimumSize(dimensionFiltro);
        this.itemDestino = new CheckItemFiltro("Destino", "Filtrar", "Filtrando destinos", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemDestino.setDados("destino", new String[]{"des_codigo", "des_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemDestino.setColunaHint(1);
        this.itemDestino.setPreferredSize(dimensionFiltro);
        this.itemDestino.setMinimumSize(dimensionFiltro);
        Insets insetsNormal = new Insets(0, 0, 0, 0);
        Insets insetsEsquerda = new Insets(0, 20, 0, 0);
        GridBagConstraints cons = new GridBagConstraints();
        cons.anchor = 17;
        cons.fill = 0;
        cons.gridheight = 1;
        cons.gridwidth = 1;
        cons.gridx = 0;
        cons.gridy = 0;
        cons.insets = insetsNormal;
        cons.weightx = 0.0;
        cons.weighty = 0.0;
        panel.add((Component)this.itemColeta, cons);
        ++cons.gridx;
        cons.insets = insetsEsquerda;
        panel.add((Component)this.itemDestino, cons);
        ++cons.gridx;
        panel.add((Component)this.labelDataIni, cons);
        ++cons.gridx;
        cons.insets = insetsNormal;
        this.textDataIni.setPreferredSize(dimensionText);
        this.textDataIni.setMinimumSize(dimensionText);
        panel.add((Component)this.textDataIni, cons);
        ++cons.gridx;
        this.buttonDataIni.setPreferredSize(dimensionButton);
        this.buttonDataFin.setPreferredSize(dimensionButton);
        panel.add((Component)this.buttonDataIni, cons);
        ++cons.gridy;
        cons.gridx = 0;
        panel.add((Component)this.itemConvenio, cons);
        ++cons.gridx;
        cons.insets = insetsEsquerda;
        panel.add((Component)this.itemExame, cons);
        ++cons.gridx;
        panel.add((Component)this.labelDataFin, cons);
        ++cons.gridx;
        cons.insets = insetsNormal;
        this.textDataFin.setPreferredSize(dimensionText);
        this.textDataFin.setMinimumSize(dimensionText);
        panel.add((Component)this.textDataFin, cons);
        ++cons.gridx;
        this.buttonDataIni.setPreferredSize(dimensionButton);
        this.buttonDataFin.setPreferredSize(dimensionButton);
        panel.add((Component)this.buttonDataFin, cons);
        ++cons.gridy;
        cons.gridx = 0;
        cons.gridwidth = 2;
        cons.fill = 2;
        panel.add((Component)this.itemRelacionamento, cons);
        cons.gridx += 3;
        cons.gridwidth = 3;
        cons.anchor = 13;
        cons.fill = 0;
        cons.weightx = 1.0;
        panel.add((Component)this.buttonConsultar, cons);
        panelAux.add((Component)this.splitCentral, "Center");
        this.splitCentral.setBorder(null);
        this.splitCentral.setDividerSize(3);
        this.splitCentral.setDividerLocation(this.posicaoDivisor);
        JPanel panelCheck = new JPanel(new FlowLayout(0, 0, 0));
        panelCheck.add(this.checkGerarXML);
        panelAux = new JPanel(new FlowLayout(2, 3, 3));
        this.add((Component)ComponenteFactory.novoJPanelBorderLayout(panelAux, null, null, null, panelCheck), "South");
        panelAux.add(this.buttonNovo);
        panelAux.add(this.buttonExportar);
        panelAux.add(this.buttonFechar);
        this.panelRequisicoes.setBorder(BorderFactory.createTitledBorder("Requisi\u00e7\u00f5es"));
        this.panelRequisicoes.add((Component)this.scrollRequisicoes, "Center");
        this.panelExames.setBorder(BorderFactory.createTitledBorder("Exames"));
        this.panelExames.add((Component)this.scrollExames, "Center");
        this.tableRequisicoes.getColumnModel().getColumn(0).setMinWidth(70);
        this.tableExames.setDefaultRenderer(Object.class, this.renderer);
        this.textDataIni.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    ExportarResultadoTexto.this.buttonDataIni.doClick();
                }
            }
        });
        this.textDataFin.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    ExportarResultadoTexto.this.buttonDataFin.doClick();
                }
            }
        });
        this.carregarParametros();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.buttonFechar) {
            this.setVisible(false);
            if (this.getParent() != null) {
                this.getParent().removeAll();
            }
        } else if (o == this.buttonNovo) {
            this.modeloRequisicoes.clear();
            this.modeloExames.clear();
            this.requisicoes.clear();
            this.renderer.limpar();
            this.textDataIni.setText("");
            this.textDataFin.setText("");
            this.itemColeta.clear();
            this.itemConvenio.clear();
            this.itemDestino.clear();
            this.itemExame.clear();
        } else if (o == this.buttonConsultar) {
            this.consultarRequisicoes();
            this.gravarParametros();
        } else if (o == this.buttonExportar) {
            try {
                this.exportar();
            }
            catch (ParseException e1) {
                ErrorLogger.mostraMensagem(this, e1.getMessage(), e1.getStackTrace(), "ExportarResultadoTexto: 278");
            }
        } else if (o == this.buttonDataIni) {
            Funcoes.mostraData(this.textDataIni, this.buttonDataIni, (JPanel)this.buttonDataIni.getParent(), false);
        } else if (o == this.buttonDataFin) {
            Funcoes.mostraData(this.textDataFin, this.buttonDataFin, (JPanel)this.buttonDataFin.getParent(), false);
        }
    }

    public static long getModuloAcesso() {
        return ACESSO;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        try {
            this.modeloExames.clear();
            this.renderer.limpar();
            if (this.tableRequisicoes.getSelectedRow() > -1 && this.modeloRequisicoes.getValueAt(this.tableRequisicoes.getSelectedRow(), 2) != null && this.modeloRequisicoes.getValueAt(this.tableRequisicoes.getSelectedRow(), 2) instanceof ArrayList) {
                ArrayList exames = (ArrayList)this.modeloRequisicoes.getValueAt(this.tableRequisicoes.getSelectedRow(), 2);
                int i = 0;
                for (Registro r : exames) {
                    if (Funcoes.textoVazio(r.getString("xml"))) {
                        this.renderer.setCorLinha(new Color(255, 91, 117), i);
                    }
                    ++i;
                    this.modeloExames.addLine(new Object[]{r.getString("exa_codigo"), r.getString("mco_abreviatura"), r.getString("exa_descricao"), r.getString("exr_situacao"), r.getBoolean("enviado")});
                }
            }
        }
        catch (Exception e1) {
            ErrorLogger.mostraMensagem(this, e1.getMessage(), e1.getStackTrace(), "ExportarResultadoTexto: 315");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void consultarRequisicoes() {
        String SQL = "";
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        SplashMensagem spl = SplashMensagem.getInstancia(this);
        try {
            this.modeloRequisicoes.clear();
            this.requisicoes.clear();
            this.habilitarDesabilitar(false);
            if (st != null) {
                ResultSet rs = Conexao.executeQuery(st, this.getSelectRequisicao());
                while (rs.next()) {
                    ArrayList<Registro> exames = this.pegaExamesRequisicao(st2, rs.getString("req_codigo"));
                    ArrayList<Registro> examesRel = new ArrayList<Registro>();
                    for (Registro re : exames) {
                        String xmlResultado = this.getXmlResultado(st2, rs.getString("req_codigo"), re.getString("exa_codigo"), re.getInt("mco_codigo"));
                        String xml = ExameUtil.pegaRelacionamentoExportaTextoIdade(Variaveis.filialPadrao, rs.getInt("req_idade"), rs.getString("req_anomes"), ExameUtil.getCodigoLayout(Variaveis.filialPadrao, rs.getString("con_codigo"), rs.getString("des_codigo")), re.getString("exa_codigo"), re.getInt("mco_codigo"), re.getString("met_codigo"));
                        re.setValor("xmlResultado", xmlResultado);
                        re.setValor("xml", xml);
                        if (!this.itemRelacionamento.isSelected()) {
                            examesRel.add(re);
                            continue;
                        }
                        if (Funcoes.textoVazio(xml)) continue;
                        examesRel.add(re);
                    }
                    if (examesRel.size() <= 0) continue;
                    this.requisicoes.add(new Registro(rs));
                    this.modeloRequisicoes.addLine(new Object[]{rs.getString("req_codigo"), rs.getString("pac_nome"), examesRel});
                }
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage() + "\nSQL: " + SQL, e.getStackTrace(), "ExportarResultadoTexto: 333");
        }
        finally {
            this.habilitarDesabilitar(true);
            spl.apagar();
        }
    }

    private void carregarParametros() {
        if (ParametrosUsuarios.contemParametro(ULTIMO_FILTRO)) {
            String str = StringUtil.getValor(ParametrosUsuarios.getValor(ULTIMO_FILTRO), "filtro");
            this.setAtributosFiltro(this.itemColeta, StringUtil.getValor(str, "coleta"));
            this.setAtributosFiltro(this.itemConvenio, StringUtil.getValor(str, "convenio"));
            this.setAtributosFiltro(this.itemDestino, StringUtil.getValor(str, "destino"));
            this.setAtributosFiltro(this.itemExame, StringUtil.getValor(str, "exame"));
            this.textDataIni.setText(StringUtil.getValor(str, "dataInicial"));
            this.textDataFin.setText(StringUtil.getValor(str, "dataFinal"));
        }
        if (ParametrosUsuarios.contemParametro(POSICAO_DIVISOR)) {
            this.posicaoDivisor = Integer.parseInt(ParametrosUsuarios.getValor(POSICAO_DIVISOR));
        }
    }

    private void gravarParametros() {
        StringBuilder bui = new StringBuilder();
        bui.append(this.getAtributosFiltro(this.itemColeta, "coleta"));
        bui.append(this.getAtributosFiltro(this.itemConvenio, "convenio"));
        bui.append(this.getAtributosFiltro(this.itemDestino, "destino"));
        bui.append(this.getAtributosFiltro(this.itemExame, "exame"));
        bui.append(StringUtil.getTag("dataInicial", this.textDataIni.getText()));
        bui.append(StringUtil.getTag("dataFinal", this.textDataFin.getText()));
        ParametrosUsuarios.setValor(ULTIMO_FILTRO, StringUtil.getTag("filtro", bui.toString()));
        ParametrosUsuarios.setValor(POSICAO_DIVISOR, String.valueOf(this.splitCentral.getDividerLocation()));
    }

    private void habilitarDesabilitar(boolean valor) {
        this.tableRequisicoes.setEnabled(valor);
        if (this.tableExames != null) {
            this.tableExames.setEnabled(valor);
        }
        this.itemColeta.setEnabled(valor);
        this.itemConvenio.setEnabled(valor);
        this.itemDestino.setEnabled(valor);
        this.itemExame.setEnabled(valor);
        this.itemRelacionamento.setEnabled(valor);
        this.buttonConsultar.setEnabled(valor);
        this.buttonDataFin.setEnabled(valor);
        this.buttonDataIni.setEnabled(valor);
        this.buttonNovo.setEnabled(valor);
        this.buttonExportar.setEnabled(valor);
        this.buttonFechar.setEnabled(valor);
        this.labelDataIni.setEnabled(valor);
        this.labelDataFin.setEnabled(valor);
        this.textDataFin.setEnabled(valor);
        this.textDataIni.setEnabled(valor);
    }

    private String getSelectRequisicao() {
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        StringBuilder bui = new StringBuilder("select distinct ");
        try {
            bui.append("  a.req_codigo, a.req_data, g.pac_codigo, g.pac_nome, a.con_codigo, a.req_idade, a.req_anomes, a.des_codigo, g.pac_cpf, g.pac_tipopessoa, ");
            bui.append("  a.req_matricula ");
            bui.append("from requisicao a ");
            bui.append("left join examerequisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo ");
            bui.append("left join paciente g on a.fil_codigo = g.fil_codigo and a.pac_codigo = g.pac_codigo ");
            bui.append("where a.fil_codigo = ").append(Variaveis.filialPadrao);
            bui.append(" and a.req_excluida = false ");
            if (Funcoes.verificaData(this.textDataIni.getText())) {
                if (bui.length() > 0) {
                    bui.append(" and ");
                }
                bui.append(" a.req_data >= '");
                bui.append(Funcoes.formataData("MM/dd/yyyy", sdf.parse(this.textDataIni.getText())));
                bui.append("' ");
            }
            if (Funcoes.verificaData(this.textDataFin.getText())) {
                if (bui.length() > 0) {
                    bui.append(" and ");
                }
                bui.append("a.req_data <= '");
                bui.append(Funcoes.formataData("MM/dd/yyyy", sdf.parse(this.textDataFin.getText())));
                bui.append("' ");
            }
            if (this.itemColeta.isSelected()) {
                this.addExpressao(bui, ExportarResultadoTexto.getExpressao("a.col_codigo", this.itemColeta.getSelecionados(0), true));
            }
            if (this.itemConvenio.isSelected()) {
                this.addExpressao(bui, ExportarResultadoTexto.getExpressao("a.con_codigo", this.itemConvenio.getSelecionados(0), false));
            }
            if (this.itemDestino.isSelected()) {
                this.addExpressao(bui, ExportarResultadoTexto.getExpressao("a.des_codigo", this.itemDestino.getSelecionados(0), true));
            }
            if (this.itemExame.isSelected()) {
                this.addExpressao(bui, ExportarResultadoTexto.getExpressao("b.exa_codigo", this.itemExame.getSelecionados(0), true));
            }
            bui.append(" order by g.pac_nome ");
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ExportarResultadoTexto: 455");
        }
        return bui.toString();
    }

    private ArrayList<Registro> pegaExamesRequisicao(Statement st, String requisicao) throws Exception {
        ArrayList<Registro> retorno = new ArrayList<Registro>();
        StringBuilder buf = new StringBuilder("select a.exa_codigo, a.mco_codigo, b.mco_abreviatura, ");
        buf.append(" a.met_codigo, c.exa_descricao, a.met_codigo, a.exr_datadigita, a.exr_situacao, a.exr_datamaterial ");
        buf.append("from examerequisicao a ");
        buf.append("left join materialcoleta b on a.fil_codigo = b.fil_codigo and a.mco_codigo = b.mco_codigo ");
        buf.append("left join exames c on a.fil_codigo = c.fil_codigo and a.exa_codigo = c.exa_codigo ");
        buf.append("where a.fil_codigo = ").append(Variaveis.filialPadrao);
        buf.append(" and a.req_codigo = ").append(requisicao);
        buf.append(" and a.exr_excluido = false ");
        if (this.itemExame.isSelected()) {
            this.addExpressao(buf, ExportarResultadoTexto.getExpressao("a.exa_codigo", this.itemExame.getSelecionados(0), true));
        }
        ResultSet rs = Conexao.executeQuery(st, buf);
        while (rs.next()) {
            retorno.add(new Registro(rs));
        }
        return retorno;
    }

    private void addExpressao(StringBuilder bui, String exp) {
        if (exp != null && exp.length() > 0) {
            if (bui.length() > 0) {
                bui.append("and ");
            }
            bui.append(exp);
            bui.append(' ');
        }
    }

    private String getAtributosFiltro(CheckItemFiltro item, String nome) {
        StringBuilder bui = new StringBuilder();
        bui.append(StringUtil.getTag("sel", String.valueOf(item.isSelected())));
        bui.append(StringUtil.getTag("item", item.getSelecionados(0)));
        return StringUtil.getTag(nome, bui.toString());
    }

    private void setAtributosFiltro(CheckItemFiltro item, String atributos) {
        if (StringUtil.getBoolean(atributos, "sel")) {
            item.setSelected(true);
            item.setSelecionados(StringUtil.getValores(atributos, "item"));
        }
    }

    private void excluirRequisicao() {
        if (Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.requisicoes.remove(this.tableRequisicoes.getSelectedRow());
            this.modeloRequisicoes.removeLine(this.tableRequisicoes.getSelectedRow());
        }
    }

    private void exportar() throws ParseException {
        if (this.requisicoes != null && this.requisicoes.size() > 0) {
            String MENSAGEM = "Exportando requisi\u00e7\u00f5es... Aguarde...";
            ArrayList<String> requisicoesSemResultado = new ArrayList<String>();
            StringBuilder file = new StringBuilder();
            int linha = 0;
            boolean semXml = false;
            boolean excluiRequisicao = true;
            for (Registro r : this.requisicoes) {
                try {
                    excluiRequisicao = true;
                    String requisicao = r.getString("req_codigo");
                    ArrayList exames = (ArrayList)this.modeloRequisicoes.getValueAt(linha, 2);
                    for (Registro re : exames) {
                        String xmlResultado = re.getString("xmlResultado");
                        String xml = re.getString("xml");
                        if (!semXml && Funcoes.textoVazio(xml) && !(semXml = Funcoes.mensagem(this, "A exporta\u00e7\u00e3o possui exames sem relacionamento!\nDeseja continuar mesmo assim?", 4) == 0)) {
                            return;
                        }
                        if (Funcoes.textoVazio(xmlResultado)) {
                            requisicoesSemResultado.add(Funcoes.preencheVazio(requisicao, 8, 1) + "\t" + re.getString("exa_codigo") + "-" + re.getString("exa_descricao"));
                            continue;
                        }
                        Map<String, Object> h = Resultado.getCamposResultado(xmlResultado, false);
                        LinkedHashMap<String, CampoValor> hash = ConfiguradorResultadoTexto.getRelacionamentoCampos(xml);
                        for (String s : hash.keySet()) {
                            try {
                                if (h.get(s.toLowerCase()) == null) {
                                    requisicoesSemResultado.add("Campo: " + s.toLowerCase() + " n\u00e3o localizado na requisi\u00e7\u00e3o: " + Funcoes.preencheVazio(requisicao, 8, 1) + "\t" + re.getString("exa_codigo") + "-" + re.getString("exa_descricao"));
                                    continue;
                                }
                                String valorExame = h.get(s.toLowerCase()).toString();
                                CampoValor exameExportado = hash.get(s);
                                for (CampoDetalhe c : exameExportado.getDetalhes()) {
                                    if (!c.getValor().equalsIgnoreCase(valorExame)) continue;
                                    valorExame = c.getTroca();
                                    break;
                                }
                                valorExame = valorExame.replace('.', ',');
                                if (!this.checkGerarXML.isSelected()) {
                                    file.append(StringUtil.preencheString(Funcoes.cortaString(StringUtil.removerAcentos(r.getString("pac_nome")), 40), 40, ' ', 0));
                                    file.append(StringUtil.preencheString(StringUtil.removerAcentos(exameExportado.getValor()), 20, ' ', 0));
                                    file.append(StringUtil.preencheString(Funcoes.formataData("dd/MM/yyyy", re.getDate("exr_datamaterial")), 10, ' ', 0));
                                    file.append(StringUtil.preencheString(valorExame, 10, '0', 1));
                                    file.append(StringUtil.preencheString(StringUtil.removerAcentos(r.getString("req_matricula")), 10, '0', 1));
                                    file.append(StringUtil.preencheString("", 15, ' ', 1));
                                    file.append(StringUtil.preencheString(StringUtil.limpaString(r.getString("pac_cpf"), new String[]{".", "-"}), 11, ' ', 1));
                                    file.append("\n");
                                    continue;
                                }
                                file.append("<resultado>");
                                file.append("<paciente>").append(StringUtil.removerAcentos(r.getString("pac_nome"))).append("</paciente>");
                                file.append("<exame>").append(StringUtil.removerAcentos(exameExportado.getValor())).append("</exame>");
                                file.append("<data>").append(Funcoes.formataData("dd/MM/yyyy", re.getDate("exr_datamaterial"))).append("</data>");
                                file.append("<valor>").append(valorExame).append("</valor>");
                                file.append("<matricula>").append(StringUtil.removerAcentos(r.getString("req_matricula"))).append("</matricula>");
                                file.append("<cpf>").append(r.getString("pac_cpf")).append("</cpf>");
                                file.append("</resultado>");
                                file.append("\n");
                            }
                            catch (Exception e) {
                                excluiRequisicao = false;
                            }
                        }
                    }
                    if (!excluiRequisicao) continue;
                    this.modeloRequisicoes.removeLine(linha);
                }
                catch (NullPointerException e) {
                    ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ExportarResultadoTexto (641)");
                    ++linha;
                }
            }
            if (file.length() > 0) {
                JFileChooser f = ComponenteFactory.novoJFileChooser();
                FileFilter flt = ComponenteFactory.novoFileFilter("(*.txt)", "txt");
                if (this.checkGerarXML.isSelected()) {
                    flt = ComponenteFactory.novoFileFilter("(*.xml)", "xml");
                }
                f.setFileFilter(flt);
                if (f.showSaveDialog(this) == 0) {
                    try {
                        String arquivo = f.getSelectedFile().getAbsolutePath();
                        if (this.checkGerarXML.isSelected()) {
                            if (!arquivo.toUpperCase().endsWith(".XML")) {
                                arquivo = arquivo + ".xml";
                            }
                            StringUtil.escreverArquivoTexto(arquivo, "<resultados>\n" + file.toString() + "</resultados>");
                        } else {
                            if (!arquivo.toUpperCase().endsWith(".TXT")) {
                                arquivo = arquivo + ".txt";
                            }
                            StringUtil.escreverArquivoTexto(arquivo, file.toString());
                        }
                        Funcoes.mensagem(this, "Exporta\u00e7\u00e3o realizada com sucesso!\nArquivo: " + arquivo, 5);
                    }
                    catch (Exception e) {
                        Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel exportar os resultados para o arquivo.\nMensagem: " + e.getMessage(), 1);
                    }
                }
                if (requisicoesSemResultado.size() > 0) {
                    SemResultado sem = SemResultado.novaInstancia(this.getTopLevelAncestor());
                    sem.setLocationRelativeTo(this.getTopLevelAncestor());
                    sem.setRequisicoes(requisicoesSemResultado);
                    sem.setVisible(true);
                }
            } else {
                Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel realizar a exporta\u00e7\u00e3o", 5);
            }
        }
    }

    private String getXmlResultado(Statement st, String requisicao, String exame, int materialColetado) {
        try {
            StringBuilder buf = new StringBuilder("select pegaResultadoExame(fil_codigo, req_codigo, exa_codigo, mco_codigo) as exr_resultado ");
            buf.append("from examerequisicao ");
            buf.append("where fil_codigo = ").append(Variaveis.filialPadrao);
            buf.append(" and req_codigo = ").append(requisicao);
            buf.append(" and exa_codigo = '").append(exame).append("'");
            buf.append(" and mco_codigo = ").append(materialColetado);
            buf.append(" and exr_excluido = false ");
            ResultSet rs = Conexao.executeQuery(st, buf);
            if (rs.next()) {
                return rs.getString("exr_resultado");
            }
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ExportarResultadoTexto: 581");
        }
        return "";
    }

    public void pressioneiF2() {
        if (this.textDataIni.hasFocus()) {
            Funcoes.mostraData(this.textDataIni, this.buttonDataIni, this, true);
        } else if (this.textDataFin.hasFocus()) {
            Funcoes.mostraData(this.textDataFin, this.buttonDataFin, this, true);
        }
    }

    public static String getExpressao(String campo, String[] valores, boolean aspas) {
        if (campo != null && valores != null && valores.length > 0) {
            StringBuilder buf = new StringBuilder("(");
            for (int i = 0; i < valores.length; ++i) {
                if (i > 0) {
                    buf.append(" or ");
                }
                buf.append(campo);
                buf.append(" = ");
                if (aspas) {
                    buf.append('\'');
                }
                buf.append(valores[i]);
                if (!aspas) continue;
                buf.append('\'');
            }
            return buf.append(")").toString();
        }
        return "";
    }
}

