/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao;

import jalis.comum.Conexao;
import jalis.comum.ParametrosUsuarios;
import jalis.comum.Variaveis;
import jalis.laboratorio.digitacao.Resultado;
import jalis.util.CheckItemFiltro;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.CorTableCellRenderer;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;

public class ExportarResultadoSisLabo
extends JPanel
implements ActionListener,
ListSelectionListener {
    private static final long ACESSO = Long.parseLong("0910001400");
    private final int COLUNA_EXAMES = 2;
    private final String[] nomeColunaExames = new String[]{"C\u00f3d.", "Mat.", "Exame", "Sit."};
    private final int[] tamanhoColunaExames = new int[]{50, 30, 0, 22};
    private final Color corLegendaRequisicao = ScreenUtil.clarearCor(Color.ORANGE, 0);
    private final Color corLegendaExame = ScreenUtil.clarearCor(Color.RED, 100);
    private CheckItemFiltro itemColeta;
    private CheckItemFiltro itemConvenio;
    private CheckItemFiltro itemDestino;
    private CheckItemFiltro itemExame;
    private TTextField textDataInicial = new TTextField(0, 4);
    private TTextField textDataFinal = new TTextField(0, 4);
    private JLabel labelDataInicial = new JLabel("Data Inicial:");
    private JLabel labelDataFinal = new JLabel("Data Final:");
    private JButton buttonDataInicial = ComponenteFactory.novoJButton(this, null, new Dimension(20, 20), true);
    private JButton buttonDataFinal = ComponenteFactory.novoJButton(this, null, new Dimension(20, 20), true);
    private JButton buttonConsultar = ComponenteFactory.novoJButton("Consultar", 'C', this, null, null);
    private JButton buttonNovo = ComponenteFactory.novoJButton("Novo", 'N', this, null, null);
    private JButton buttonExportar = ComponenteFactory.novoJButton("Exportar", 'E', this, null, null);
    private JButton buttonFechar = ComponenteFactory.novoJButton("Fechar", 'F', this, null, null);
    private JPanel panelRequisicoes = new JPanel(new BorderLayout());
    private JPanel panelExames = new JPanel(new BorderLayout());
    private JPanel panelOutrosExames = new JPanel(new BorderLayout());
    private JPanel panelGerenciadorPanelExames = new JPanel(new BorderLayout());
    private JSplitPane splitCentral = new JSplitPane(1, this.panelRequisicoes, this.panelGerenciadorPanelExames);
    private CorTableCellRenderer rendererRequisicao = new CorTableCellRenderer();
    private CorTableCellRenderer rendererExame = new CorTableCellRenderer();
    private ModeloGridTable modeloRequisicoes = new ModeloGridTable(new String[]{"Requisi\u00e7\u00e3o", "Paciente"});
    private JTable tableRequisicoes = ComponenteFactory.novoJTable((TableModel)this.modeloRequisicoes, (ListSelectionListener)this, 70, 0);
    private JScrollPane scrollRequisicoes = new JScrollPane(this.tableRequisicoes);
    private ModeloGridTable modeloExames = new ModeloGridTable(this.nomeColunaExames);
    private JTable tableExames = ComponenteFactory.novoJTable((TableModel)this.modeloExames, null, this.tamanhoColunaExames);
    private JScrollPane scrollExames = new JScrollPane(this.tableExames);
    private ModeloGridTable modeloOutrosExames = new ModeloGridTable(this.nomeColunaExames);
    private JTable tableOutrosExames = ComponenteFactory.novoJTable((TableModel)this.modeloOutrosExames, null, this.tamanhoColunaExames);
    private JScrollPane scrollOutrosExames = new JScrollPane(this.tableOutrosExames);
    private int posicaoDivisor = 350;
    private static final String POSICAO_DIVISOR = "ExportarResultadoSisLabo.posicaoDivisor";
    private static final String ULTIMO_FILTRO = "ExportarResultadoSisLabo.ultimoFiltro";
    private ArrayList<Registro> requisicoes = new ArrayList();

    public ExportarResultadoSisLabo() {
        this.montaTela();
        this.tableRequisicoes.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127 && ExportarResultadoSisLabo.this.tableRequisicoes.getSelectedRow() > -1) {
                    ExportarResultadoSisLabo.this.excluirRequisicao();
                }
            }
        });
    }

    private void montaTela() {
        this.setLayout(new BorderLayout());
        Funcoes.criaBarraDescricao(this, "Exportar SIS-LABO", "Exporta\u00e7\u00e3o de resultados em arquivos para o sistema SIS-LABO", "integracao/export_result_sislabo.jpg");
        Funcoes.montaEnter((JComponent)this);
        Dimension dimensionFiltro = new Dimension(180, 20);
        Dimension dimensionText = new Dimension(90, 20);
        Dimension dimensionButton = new Dimension(20, 20);
        JPanel panelAux = new JPanel();
        panelAux.setLayout(new BorderLayout());
        this.add((Component)panelAux, "Center");
        JPanel panel = new JPanel();
        panelAux.add((Component)panel, "North");
        panel.setBorder(BorderFactory.createTitledBorder("Filtro"));
        panel.setLayout(new GridBagLayout());
        this.itemColeta = new CheckItemFiltro("Coleta", "Filtrar", "Filtrando coletas", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemColeta.setDados("coletas", new String[]{"col_codigo", "col_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemColeta.setColunaHint(1);
        this.itemColeta.setPreferredSize(dimensionFiltro);
        this.itemColeta.setMinimumSize(dimensionFiltro);
        this.itemConvenio = new CheckItemFiltro("Conv\u00eanio", "Filtrar", "Filtrando conv\u00eanios", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemConvenio.setDados("convenios", new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Fantasia"}, new int[]{70, 0});
        this.itemConvenio.setColunaHint(1);
        this.itemConvenio.setPreferredSize(dimensionFiltro);
        this.itemConvenio.setMinimumSize(dimensionFiltro);
        this.itemExame = new CheckItemFiltro("Exame", "Filtrar", "Filtrando exames", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemExame.setDados("exames", new String[]{"exa_codigo", "exa_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemExame.setColunaHint(1);
        this.itemExame.setPreferredSize(dimensionFiltro);
        this.itemExame.setMinimumSize(dimensionFiltro);
        this.itemDestino = new CheckItemFiltro("Destino", "Filtrar", "Filtrando destinos", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemDestino.setDados("destino", new String[]{"des_codigo", "des_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemDestino.setColunaHint(1);
        this.itemDestino.setPreferredSize(dimensionFiltro);
        this.itemDestino.setMinimumSize(dimensionFiltro);
        this.textDataInicial.setPreferredSize(dimensionText);
        this.textDataInicial.setMinimumSize(dimensionText);
        this.buttonDataInicial.setPreferredSize(dimensionButton);
        this.buttonDataInicial.setMinimumSize(dimensionButton);
        this.textDataFinal.setPreferredSize(dimensionText);
        this.textDataFinal.setMinimumSize(dimensionText);
        this.buttonDataFinal.setPreferredSize(dimensionButton);
        this.buttonDataFinal.setMinimumSize(dimensionButton);
        this.splitCentral.setBorder(null);
        this.splitCentral.setDividerSize(3);
        this.splitCentral.setDividerLocation(this.posicaoDivisor);
        this.tableRequisicoes.getColumnModel().getColumn(0).setMinWidth(70);
        this.tableRequisicoes.setDefaultRenderer(Object.class, this.rendererRequisicao);
        this.tableOutrosExames.setDefaultRenderer(Object.class, this.rendererExame);
        this.textDataInicial.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    ExportarResultadoSisLabo.this.buttonDataInicial.doClick();
                }
            }
        });
        this.textDataFinal.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    ExportarResultadoSisLabo.this.buttonDataFinal.doClick();
                }
            }
        });
        this.panelRequisicoes.setBorder(BorderFactory.createTitledBorder("Requisi\u00e7\u00f5es"));
        this.panelRequisicoes.add((Component)this.scrollRequisicoes, "Center");
        this.panelRequisicoes.add((Component)this.montaPanelLegenda("Sem Guia", this.corLegendaRequisicao), "South");
        this.panelExames.setBorder(BorderFactory.createTitledBorder("Exames para exportar"));
        this.panelExames.add((Component)this.scrollExames, "Center");
        this.panelOutrosExames.setBorder(BorderFactory.createTitledBorder("Outros Exames"));
        this.panelOutrosExames.add((Component)this.scrollOutrosExames, "Center");
        this.panelOutrosExames.setPreferredSize(new Dimension(1, (int)((double)this.splitCentral.getPreferredSize().height * 0.5)));
        this.panelOutrosExames.add((Component)this.montaPanelLegenda("Sem Configura\u00e7\u00e3o", this.corLegendaExame), "South");
        this.panelGerenciadorPanelExames.add((Component)this.panelExames, "Center");
        this.panelGerenciadorPanelExames.add((Component)this.panelOutrosExames, "South");
        Insets insetsNormal = new Insets(0, 0, 0, 0);
        Insets insetsEsquerda = new Insets(0, 20, 0, 0);
        GridBagConstraints cons = new GridBagConstraints();
        cons.anchor = 17;
        cons.fill = 0;
        cons.gridheight = 1;
        cons.gridwidth = 1;
        cons.gridx = 0;
        cons.gridy = 0;
        cons.insets = insetsNormal;
        cons.weightx = 0.0;
        cons.weighty = 0.0;
        panel.add((Component)this.itemColeta, cons);
        ++cons.gridx;
        cons.insets = insetsEsquerda;
        panel.add((Component)this.itemDestino, cons);
        ++cons.gridx;
        panel.add((Component)this.labelDataInicial, cons);
        ++cons.gridx;
        cons.insets = insetsNormal;
        panel.add((Component)this.textDataInicial, cons);
        ++cons.gridx;
        panel.add((Component)this.buttonDataInicial, cons);
        ++cons.gridy;
        cons.gridx = 0;
        panel.add((Component)this.itemConvenio, cons);
        ++cons.gridx;
        cons.insets = insetsEsquerda;
        panel.add((Component)this.itemExame, cons);
        ++cons.gridx;
        panel.add((Component)this.labelDataFinal, cons);
        ++cons.gridx;
        cons.insets = insetsNormal;
        panel.add((Component)this.textDataFinal, cons);
        ++cons.gridx;
        panel.add((Component)this.buttonDataFinal, cons);
        cons.gridx += 3;
        cons.gridwidth = 3;
        cons.anchor = 13;
        cons.fill = 0;
        cons.weightx = 1.0;
        panel.add((Component)this.buttonConsultar, cons);
        panelAux.add((Component)this.splitCentral, "Center");
        panelAux = new JPanel(new FlowLayout(2, 3, 3));
        this.add((Component)ComponenteFactory.novoJPanelBorderLayout(panelAux, null, null, null, null), "South");
        panelAux.add(this.buttonNovo);
        panelAux.add(this.buttonExportar);
        panelAux.add(this.buttonFechar);
        this.carregarParametros();
    }

    private void gravarParametros() {
        StringBuilder bui = new StringBuilder();
        bui.append(this.getAtributosFiltro(this.itemColeta, "coleta"));
        bui.append(this.getAtributosFiltro(this.itemConvenio, "convenio"));
        bui.append(this.getAtributosFiltro(this.itemDestino, "destino"));
        bui.append(this.getAtributosFiltro(this.itemExame, "exame"));
        bui.append(StringUtil.getTag("dataInicial", this.textDataInicial.getText()));
        bui.append(StringUtil.getTag("dataFinal", this.textDataFinal.getText()));
        ParametrosUsuarios.setValor(ULTIMO_FILTRO, StringUtil.getTag("filtro", bui.toString()));
        ParametrosUsuarios.setValor(POSICAO_DIVISOR, String.valueOf(this.splitCentral.getDividerLocation()));
    }

    private void carregarParametros() {
        if (ParametrosUsuarios.contemParametro(ULTIMO_FILTRO)) {
            String str = StringUtil.getValor(ParametrosUsuarios.getValor(ULTIMO_FILTRO), "filtro");
            this.setAtributosFiltro(this.itemColeta, StringUtil.getValor(str, "coleta"));
            this.setAtributosFiltro(this.itemConvenio, StringUtil.getValor(str, "convenio"));
            this.setAtributosFiltro(this.itemDestino, StringUtil.getValor(str, "destino"));
            this.setAtributosFiltro(this.itemExame, StringUtil.getValor(str, "exame"));
            this.textDataInicial.setText(StringUtil.getValor(str, "dataInicial"));
            this.textDataFinal.setText(StringUtil.getValor(str, "dataFinal"));
        }
        if (ParametrosUsuarios.contemParametro(POSICAO_DIVISOR)) {
            this.posicaoDivisor = Integer.parseInt(ParametrosUsuarios.getValor(POSICAO_DIVISOR));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void consultarRequisicoes() {
        if (Funcoes.objectIsNull(this.itemConvenio.getSelecionados(0))) {
            Funcoes.mensagem(this, "O conv\u00eanio deve ser selecionado.", 2);
            return;
        }
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        this.modeloRequisicoes.clear();
        this.modeloExames.clear();
        this.modeloOutrosExames.clear();
        this.requisicoes.clear();
        this.rendererRequisicao.limpar();
        try {
            this.habilitarDesabilitar(false);
            if (st != null) {
                ResultSet rs = Conexao.executeQuery(st, this.getSelect());
                while (rs.next()) {
                    ArrayList<Registro> exames = this.pegaExamesRequisicao(st2, rs.getString("req_codigo"));
                    ArrayList<Registro> examesRel = new ArrayList<Registro>();
                    for (Registro re : exames) {
                        String xmlResultado = this.getXmlResultado(st2, rs.getString("req_codigo"), re.getString("exa_codigo"), re.getInt("mco_codigo"));
                        String xml = ExameUtil.pegaRelacionamentoExportaTextoIdade(Variaveis.filialPadrao, rs.getInt("req_idade"), rs.getString("req_anomes"), ExameUtil.getCodigoLayout(Variaveis.filialPadrao, rs.getString("con_codigo"), rs.getString("des_codigo")), re.getString("exa_codigo"), re.getInt("mco_codigo"), re.getString("met_codigo"));
                        re.setValor("xmlResultado", xmlResultado);
                        re.setValor("contemguia", !Funcoes.textoVazio(rs.getString("req_guia")));
                        re.setValor("req_guia", rs.getString("req_guia"));
                        re.setValor("xml", xml);
                        boolean exameConfigurado = false;
                        if (!Funcoes.textoVazio(xml) && !StringUtil.getValor(xml, "exportarsislabo").isEmpty()) {
                            exameConfigurado = true;
                        }
                        re.setValor("configurado", exameConfigurado);
                        examesRel.add(re);
                    }
                    if (examesRel.size() <= 0) continue;
                    this.requisicoes.add(new Registro(rs));
                    this.modeloRequisicoes.addLine(new Object[]{rs.getString("req_codigo"), rs.getString("pac_nome"), examesRel});
                    if (!Funcoes.textoVazio(rs.getString("req_guia"))) continue;
                    this.rendererRequisicao.setCorLinha(this.corLegendaRequisicao, this.modeloRequisicoes.getRowCount() - 1);
                }
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage() + "\nSQL: " + this.getSelect(), e.getStackTrace(), "ExportarResultadoSisLabo: 333");
        }
        finally {
            this.habilitarDesabilitar(true);
        }
    }

    private void excluirRequisicao() {
        if (Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.requisicoes.remove(this.tableRequisicoes.getSelectedRow());
            this.modeloRequisicoes.removeLine(this.tableRequisicoes.getSelectedRow());
            this.rendererRequisicao.limpar();
            for (int linha = 0; linha < this.modeloRequisicoes.getRowCount(); ++linha) {
                if (this.modeloRequisicoes.getValueAt(linha, 2) == null || !(this.modeloRequisicoes.getValueAt(linha, 2) instanceof ArrayList) || ((Registro)((ArrayList)this.modeloRequisicoes.getValueAt(linha, 2)).get(0)).getBoolean("contemguia")) continue;
                this.rendererRequisicao.setCorLinha(this.corLegendaRequisicao, linha);
            }
        }
    }

    private JPanel montaPanelLegenda(String nome, Color cor) {
        JPanel panelLegenda = new JPanel(new FlowLayout(0));
        JPanel panelCorLegenda = new JPanel();
        panelCorLegenda.setPreferredSize(new Dimension(8, 8));
        panelCorLegenda.setBackground(cor);
        panelLegenda.add(panelCorLegenda);
        JLabel labelLegenda = new JLabel(nome);
        Font font = new Font(labelLegenda.getFont().getName(), 0, 10);
        labelLegenda.setFont(font);
        panelLegenda.add(labelLegenda);
        return panelLegenda;
    }

    private String getAtributosFiltro(CheckItemFiltro item, String nome) {
        StringBuilder bui = new StringBuilder();
        bui.append(StringUtil.getTag("sel", String.valueOf(item.isSelected())));
        bui.append(StringUtil.getTag("item", item.getSelecionados(0)));
        return StringUtil.getTag(nome, bui.toString());
    }

    private void setAtributosFiltro(CheckItemFiltro item, String atributos) {
        if (StringUtil.getBoolean(atributos, "sel")) {
            item.setSelected(true);
            item.setSelecionados(StringUtil.getValores(atributos, "item"));
        }
    }

    private void exportar() {
        if (this.modeloRequisicoes.getRowCount() < 0) {
            return;
        }
        boolean contemExameSemGuia = false;
        StringBuilder arquivoExportacao = new StringBuilder();
        for (int linha = 0; linha < this.modeloRequisicoes.getRowCount(); ++linha) {
            if (Funcoes.objectIsNull(this.modeloRequisicoes.getValueAt(linha, 2)) || !(this.modeloRequisicoes.getValueAt(linha, 2) instanceof ArrayList)) continue;
            ArrayList listaRegistros = (ArrayList)this.modeloRequisicoes.getValueAt(linha, 2);
            if (!(listaRegistros.isEmpty() || ((Registro)listaRegistros.get(0)).getBoolean("contemguia") || contemExameSemGuia)) {
                if (Funcoes.showPerguntaSimNao((Frame)this.getTopLevelAncestor(), "Aten\u00e7\u00e3o", "As requisi\u00e7\u00f5es sem n\u00famero de guia n\u00e3o ser\u00e3o adicionadas no arquivo de integra\u00e7\u00e3o. Deseja continuar?") == 1) {
                    return;
                }
                contemExameSemGuia = true;
            }
            for (Registro registro : listaRegistros) {
                if (!registro.getString("exr_situacao").equals("C") && !registro.getString("exr_situacao").equals("I") && !registro.getString("exr_situacao").equals("E") || !registro.getBoolean("configurado") || !registro.getBoolean("contemguia")) continue;
                Map<String, Object> h = Resultado.getCamposResultado(registro.getString("xmlResultado"), false);
                Hashtable hash = this.getRelacionamentoCampos(registro.getString("xml"));
                for (String s : hash.keySet()) {
                    if (Funcoes.objectIsNull(h.get(s.toLowerCase()))) continue;
                    String valorExame = h.get(s.toLowerCase()).toString();
                    String exameExportado = (String)hash.get(s);
                    if (!h.get(s.toLowerCase()).toString().equals(valorExame)) continue;
                    arquivoExportacao.append(registro.getValor("req_guia")).append("|");
                    arquivoExportacao.append(exameExportado).append("|");
                    arquivoExportacao.append(valorExame).append("\n");
                }
            }
        }
        if (arquivoExportacao.length() > 0) {
            StringBuilder endereco = new StringBuilder();
            JFileChooser f = ComponenteFactory.novoJFileChooser();
            f.setFileSelectionMode(1);
            if (f.showSaveDialog(this) == 0) {
                endereco.append(f.getSelectedFile().getAbsolutePath());
                endereco.append(File.separatorChar);
                endereco.append("SIS_");
                endereco.append(Funcoes.formataData("yyyyMMddHHmmss", new Date()));
                endereco.append(".RET");
                try {
                    StringUtil.escreverArquivoTexto(endereco.toString(), arquivoExportacao.toString());
                    Funcoes.mensagem(this, "Arquivo criado com sucesso!\n" + endereco, 5);
                }
                catch (Exception e) {
                    Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel exportar os resultados para o arquivo " + endereco + ".\nMensagem: " + e.getMessage(), 1);
                }
            }
        } else {
            Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel realizar a exporta\u00e7\u00e3o", 5);
        }
    }

    private Hashtable getRelacionamentoCampos(String xml) {
        Hashtable<String, String> lista = new Hashtable<String, String>();
        if (!Funcoes.textoVazio(StringUtil.getValor(xml, "exportarsislabo"))) {
            String[] campos;
            for (String s : campos = StringUtil.getValores(StringUtil.getValor(xml, "exportarsislabo"), "campo")) {
                String nome = StringUtil.getValor(s, "nome");
                String valor = StringUtil.getValor(s, "valor");
                lista.put(nome, valor);
            }
        }
        return lista;
    }

    private void habilitarDesabilitar(boolean valor) {
        this.tableRequisicoes.setEnabled(valor);
        this.tableExames.setEnabled(valor);
        this.tableOutrosExames.setEnabled(valor);
        this.itemColeta.setEnabled(valor);
        this.itemConvenio.setEnabled(valor);
        this.itemDestino.setEnabled(valor);
        this.itemExame.setEnabled(valor);
        this.buttonConsultar.setEnabled(valor);
        this.buttonDataFinal.setEnabled(valor);
        this.buttonDataInicial.setEnabled(valor);
        this.buttonNovo.setEnabled(valor);
        this.buttonExportar.setEnabled(valor);
        this.buttonFechar.setEnabled(valor);
        this.labelDataInicial.setEnabled(valor);
        this.labelDataFinal.setEnabled(valor);
        this.textDataFinal.setEnabled(valor);
        this.textDataInicial.setEnabled(valor);
    }

    private String getSelect() {
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        StringBuilder buffer = new StringBuilder("select distinct ");
        try {
            buffer.append("  a.req_codigo, a.req_data, g.pac_codigo, g.pac_nome, a.con_codigo, a.req_idade, a.req_anomes, a.des_codigo, g.pac_cpf, g.pac_tipopessoa, ");
            buffer.append("  a.req_matricula, a.req_prontuario, a.req_guia ");
            buffer.append("from requisicao a ");
            buffer.append("left join examerequisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo ");
            buffer.append("left join paciente g on a.fil_codigo = g.fil_codigo and a.pac_codigo = g.pac_codigo ");
            buffer.append("where a.fil_codigo = ").append(Variaveis.filialPadrao);
            buffer.append(" and a.req_excluida = false ");
            if (Funcoes.verificaData(this.textDataInicial.getText())) {
                if (buffer.length() > 0) {
                    buffer.append(" and ");
                }
                buffer.append(" a.req_data >= '");
                buffer.append(Funcoes.formataData("MM/dd/yyyy", sdf.parse(this.textDataInicial.getText())));
                buffer.append("' ");
            }
            if (Funcoes.verificaData(this.textDataFinal.getText())) {
                if (buffer.length() > 0) {
                    buffer.append(" and ");
                }
                buffer.append("a.req_data <= '");
                buffer.append(Funcoes.formataData("MM/dd/yyyy", sdf.parse(this.textDataFinal.getText())));
                buffer.append("' ");
            }
            if (this.itemColeta.isSelected()) {
                this.addExpressao(buffer, ExportarResultadoSisLabo.getExpressao("a.col_codigo", this.itemColeta.getSelecionados(0), true));
            }
            if (this.itemConvenio.isSelected()) {
                this.addExpressao(buffer, ExportarResultadoSisLabo.getExpressao("a.con_codigo", this.itemConvenio.getSelecionados(0), false));
            }
            if (this.itemDestino.isSelected()) {
                this.addExpressao(buffer, ExportarResultadoSisLabo.getExpressao("a.des_codigo", this.itemDestino.getSelecionados(0), true));
            }
            if (this.itemExame.isSelected()) {
                this.addExpressao(buffer, ExportarResultadoSisLabo.getExpressao("b.exa_codigo", this.itemExame.getSelecionados(0), true));
            }
            buffer.append(" order by g.pac_nome ");
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ExportarResultadoSisLabo: 455");
        }
        return buffer.toString();
    }

    private String getXmlResultado(Statement st, String requisicao, String exame, int materialColetado) {
        try {
            StringBuilder buf = new StringBuilder("select pegaResultadoExame(fil_codigo, req_codigo, exa_codigo, mco_codigo) as exr_resultado ");
            buf.append("from examerequisicao ");
            buf.append("where fil_codigo = ").append(Variaveis.filialPadrao);
            buf.append(" and req_codigo = ").append(requisicao);
            buf.append(" and exa_codigo = '").append(exame).append("'");
            buf.append(" and mco_codigo = ").append(materialColetado);
            buf.append(" and exr_excluido = false ");
            ResultSet rs = Conexao.executeQuery(st, buf);
            if (rs.next()) {
                return rs.getString("exr_resultado");
            }
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ExportarResultadoSisLabo: 581");
        }
        return "";
    }

    private ArrayList<Registro> pegaExamesRequisicao(Statement st, String requisicao) throws Exception {
        ArrayList<Registro> retorno = new ArrayList<Registro>();
        StringBuilder buf = new StringBuilder("select a.exa_codigo, a.mco_codigo, b.mco_abreviatura, ");
        buf.append(" a.met_codigo, c.exa_descricao, a.met_codigo, a.exr_datadigita, a.exr_situacao, a.exr_datamaterial ");
        buf.append("from examerequisicao a ");
        buf.append("left join materialcoleta b on a.fil_codigo = b.fil_codigo and a.mco_codigo = b.mco_codigo ");
        buf.append("left join exames c on a.fil_codigo = c.fil_codigo and a.exa_codigo = c.exa_codigo ");
        buf.append("where a.fil_codigo = ").append(Variaveis.filialPadrao);
        buf.append(" and a.req_codigo = ").append(requisicao);
        buf.append(" and a.exr_excluido = false ");
        if (this.itemExame.isSelected()) {
            this.addExpressao(buf, ExportarResultadoSisLabo.getExpressao("a.exa_codigo", this.itemExame.getSelecionados(0), true));
        }
        ResultSet rs = Conexao.executeQuery(st, buf);
        while (rs.next()) {
            retorno.add(new Registro(rs));
        }
        return retorno;
    }

    public static String getExpressao(String campo, String[] valores, boolean aspas) {
        if (campo != null && valores != null && valores.length > 0) {
            StringBuilder buf = new StringBuilder("(");
            for (int i = 0; i < valores.length; ++i) {
                if (i > 0) {
                    buf.append(" or ");
                }
                buf.append(campo);
                buf.append(" = ");
                if (aspas) {
                    buf.append('\'');
                }
                buf.append(valores[i]);
                if (!aspas) continue;
                buf.append('\'');
            }
            return buf.append(")").toString();
        }
        return "";
    }

    private void addExpressao(StringBuilder bui, String exp) {
        if (exp != null && exp.length() > 0) {
            if (bui.length() > 0) {
                bui.append("and ");
            }
            bui.append(exp);
            bui.append(' ');
        }
    }

    public static long getModuloAcesso() {
        return ACESSO;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        try {
            this.modeloExames.clear();
            this.modeloOutrosExames.clear();
            this.rendererExame.limpar();
            if (this.tableRequisicoes.getSelectedRow() > -1 && this.modeloRequisicoes.getValueAt(this.tableRequisicoes.getSelectedRow(), 2) != null && this.modeloRequisicoes.getValueAt(this.tableRequisicoes.getSelectedRow(), 2) instanceof ArrayList) {
                ArrayList exames = (ArrayList)this.modeloRequisicoes.getValueAt(this.tableRequisicoes.getSelectedRow(), 2);
                for (Registro r : exames) {
                    Object[] registro = new Object[]{r.getString("exa_codigo"), r.getString("mco_abreviatura"), r.getString("exa_descricao"), r.getString("exr_situacao"), r.getBoolean("enviado")};
                    if ((r.getString("exr_situacao").equals("C") || r.getString("exr_situacao").equals("I") || r.getString("exr_situacao").equals("E")) && r.getBoolean("configurado")) {
                        this.modeloExames.addLine(registro);
                        continue;
                    }
                    this.modeloOutrosExames.addLine(registro);
                    if (r.getBoolean("configurado")) continue;
                    this.rendererExame.setCorLinha(this.corLegendaExame, this.modeloOutrosExames.getRowCount() - 1);
                }
            }
        }
        catch (Exception e1) {
            ErrorLogger.mostraMensagem(this, e1.getMessage(), e1.getStackTrace(), "ExportarResultadoSisLabo: 315");
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.buttonDataInicial) {
            Funcoes.mostraData(this.textDataInicial, this.buttonDataInicial, (JPanel)this.buttonDataInicial.getParent(), false);
        } else if (o == this.buttonDataFinal) {
            Funcoes.mostraData(this.textDataFinal, this.buttonDataFinal, (JPanel)this.buttonDataFinal.getParent(), false);
        } else if (o == this.buttonConsultar) {
            this.consultarRequisicoes();
            this.gravarParametros();
        } else if (o == this.buttonNovo) {
            this.modeloRequisicoes.clear();
            this.modeloExames.clear();
            this.modeloOutrosExames.clear();
            this.requisicoes.clear();
            this.rendererRequisicao.limpar();
            this.rendererExame.limpar();
            this.textDataInicial.setText("");
            this.textDataFinal.setText("");
            this.itemColeta.clear();
            this.itemConvenio.clear();
            this.itemDestino.clear();
            this.itemExame.clear();
        } else if (o == this.buttonExportar) {
            this.exportar();
        } else if (o == this.buttonFechar) {
            this.setVisible(false);
            if (this.getParent() != null) {
                this.getParent().removeAll();
            }
        }
    }
}

