/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao;

import jalis.comum.Conexao;
import jalis.comum.ParametrosUsuarios;
import jalis.comum.Variaveis;
import jalis.laboratorio.util.faturamento.eletronico.Save;
import jalis.laboratorio.util.faturamento.eletronico.save.SaveService;
import jalis.util.CheckItemFiltro;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;

public class ExportarResultadoSave
extends JPanel
implements ActionListener,
ListSelectionListener {
    private static final long ACESSO = Long.parseLong("0910001300");
    private final int COLUNA_EXAMES = 2;
    private final String[] nomeColunaExames = new String[]{"C\u00f3d.", "Mat.", "Exame", "Sit."};
    private final int[] tamanhoColunaExames = new int[]{50, 30, 0, 22};
    private CheckItemFiltro itemColeta;
    private CheckItemFiltro itemConvenio;
    private CheckItemFiltro itemDestino;
    private CheckItemFiltro itemExame;
    private TTextField textDataInicial = new TTextField(0, 4);
    private TTextField textDataFinal = new TTextField(0, 4);
    private JLabel labelDataInicial = new JLabel("Data Inicial:");
    private JLabel labelDataFinal = new JLabel("Data Final:");
    private JButton buttonDataInicial = ComponenteFactory.novoJButton(this, null, new Dimension(20, 20), true);
    private JButton buttonDataFinal = ComponenteFactory.novoJButton(this, null, new Dimension(20, 20), true);
    private JButton buttonConsultar = ComponenteFactory.novoJButton("Consultar", 'C', this, null, null);
    private JButton buttonNovo = ComponenteFactory.novoJButton("Novo", 'N', this, null, null);
    private JButton buttonExportar = ComponenteFactory.novoJButton("Exportar", 'E', this, null, null);
    private JButton buttonFechar = ComponenteFactory.novoJButton("Fechar", 'F', this, null, null);
    private JPanel panelRequisicoes = new JPanel(new BorderLayout());
    private JPanel panelExames = new JPanel(new BorderLayout());
    private JPanel panelOutrosExames = new JPanel(new BorderLayout());
    private JPanel panelGerenciadorPanelExames = new JPanel(new BorderLayout());
    private JSplitPane splitCentral = new JSplitPane(1, this.panelRequisicoes, this.panelGerenciadorPanelExames);
    private ModeloGridTable modeloRequisicoes = new ModeloGridTable(new String[]{"Requisi\u00e7\u00e3o", "Paciente"});
    private JTable tableRequisicoes = ComponenteFactory.novoJTable((TableModel)this.modeloRequisicoes, (ListSelectionListener)this, 70, 0);
    private JScrollPane scrollRequisicoes = new JScrollPane(this.tableRequisicoes);
    private ModeloGridTable modeloExames = new ModeloGridTable(this.nomeColunaExames);
    private JTable tableExames = ComponenteFactory.novoJTable((TableModel)this.modeloExames, null, this.tamanhoColunaExames);
    private JScrollPane scrollExames = new JScrollPane(this.tableExames);
    private ModeloGridTable modeloOutrosExames = new ModeloGridTable(this.nomeColunaExames);
    private JTable tableOutrosExames = ComponenteFactory.novoJTable((TableModel)this.modeloOutrosExames, null, this.tamanhoColunaExames);
    private JScrollPane scrollOutrosExames = new JScrollPane(this.tableOutrosExames);
    private int posicaoDivisor = 350;
    private final String POSICAO_DIVISOR = "ExportarResultadoSave.posicaoDivisor";
    private final String ULTIMO_FILTRO = "ExportarResultadoSave.ultimoFiltro";
    private String xmlConfiguracao = "";
    private ArrayList<Registro> requisicoes = new ArrayList();

    public ExportarResultadoSave() {
        this.montaTela();
        this.tableRequisicoes.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127 && ExportarResultadoSave.this.tableRequisicoes.getSelectedRow() > -1) {
                    ExportarResultadoSave.this.excluirRequisicao();
                }
            }
        });
    }

    private void montaTela() {
        this.setLayout(new BorderLayout());
        Funcoes.criaBarraDescricao(this, "Exportar SAVE", "Exporta\u00e7\u00e3o de arquivos para o sistema SAVE", "integracao/export_result_save.jpg");
        Funcoes.montaEnter((JComponent)this);
        Dimension dimensionFiltro = new Dimension(180, 20);
        Dimension dimensionText = new Dimension(90, 20);
        Dimension dimensionButton = new Dimension(20, 20);
        JPanel panelAux = new JPanel();
        panelAux.setLayout(new BorderLayout());
        this.add((Component)panelAux, "Center");
        JPanel panel = new JPanel();
        panelAux.add((Component)panel, "North");
        panel.setBorder(BorderFactory.createTitledBorder("Filtro"));
        panel.setLayout(new GridBagLayout());
        this.itemColeta = new CheckItemFiltro("Coleta", "Filtrar", "Filtrando coletas", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemColeta.setDados("coletas", new String[]{"col_codigo", "col_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemColeta.setColunaHint(1);
        this.itemColeta.setPreferredSize(dimensionFiltro);
        this.itemColeta.setMinimumSize(dimensionFiltro);
        this.itemConvenio = new CheckItemFiltro("Conv\u00eanio", "Filtrar", "Filtrando conv\u00eanios", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemConvenio.setDados("convenios", new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Fantasia"}, new int[]{70, 0});
        this.itemConvenio.setColunaHint(1);
        this.itemConvenio.setPreferredSize(dimensionFiltro);
        this.itemConvenio.setMinimumSize(dimensionFiltro);
        this.itemExame = new CheckItemFiltro("Exame", "Filtrar", "Filtrando exames", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemExame.setDados("exames", new String[]{"exa_codigo", "exa_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemExame.setColunaHint(1);
        this.itemExame.setPreferredSize(dimensionFiltro);
        this.itemExame.setMinimumSize(dimensionFiltro);
        this.itemDestino = new CheckItemFiltro("Destino", "Filtrar", "Filtrando destinos", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemDestino.setDados("destino", new String[]{"des_codigo", "des_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemDestino.setColunaHint(1);
        this.itemDestino.setPreferredSize(dimensionFiltro);
        this.itemDestino.setMinimumSize(dimensionFiltro);
        this.textDataInicial.setPreferredSize(dimensionText);
        this.textDataInicial.setMinimumSize(dimensionText);
        this.buttonDataInicial.setPreferredSize(dimensionButton);
        this.buttonDataInicial.setMinimumSize(dimensionButton);
        this.textDataFinal.setPreferredSize(dimensionText);
        this.textDataFinal.setMinimumSize(dimensionText);
        this.buttonDataFinal.setPreferredSize(dimensionButton);
        this.buttonDataFinal.setMinimumSize(dimensionButton);
        this.splitCentral.setBorder(null);
        this.splitCentral.setDividerSize(3);
        this.splitCentral.setDividerLocation(this.posicaoDivisor);
        this.tableRequisicoes.getColumnModel().getColumn(0).setMinWidth(70);
        this.textDataInicial.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    ExportarResultadoSave.this.buttonDataInicial.doClick();
                }
            }
        });
        this.textDataFinal.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    ExportarResultadoSave.this.buttonDataFinal.doClick();
                }
            }
        });
        this.panelRequisicoes.setBorder(BorderFactory.createTitledBorder("Requisi\u00e7\u00f5es"));
        this.panelRequisicoes.add((Component)this.scrollRequisicoes, "Center");
        this.panelExames.setBorder(BorderFactory.createTitledBorder("Exames para exportar"));
        this.panelExames.add((Component)this.scrollExames, "Center");
        this.panelOutrosExames.setBorder(BorderFactory.createTitledBorder("Outros Exames"));
        this.panelOutrosExames.add((Component)this.scrollOutrosExames, "Center");
        this.panelOutrosExames.setPreferredSize(new Dimension(1, (int)((double)this.splitCentral.getPreferredSize().height * 0.5)));
        this.panelGerenciadorPanelExames.add((Component)this.panelExames, "Center");
        this.panelGerenciadorPanelExames.add((Component)this.panelOutrosExames, "South");
        Insets insetsNormal = new Insets(0, 0, 0, 0);
        Insets insetsEsquerda = new Insets(0, 20, 0, 0);
        GridBagConstraints cons = new GridBagConstraints();
        cons.anchor = 17;
        cons.fill = 0;
        cons.gridheight = 1;
        cons.gridwidth = 1;
        cons.gridx = 0;
        cons.gridy = 0;
        cons.insets = insetsNormal;
        cons.weightx = 0.0;
        cons.weighty = 0.0;
        panel.add((Component)this.itemColeta, cons);
        ++cons.gridx;
        cons.insets = insetsEsquerda;
        panel.add((Component)this.itemDestino, cons);
        ++cons.gridx;
        panel.add((Component)this.labelDataInicial, cons);
        ++cons.gridx;
        cons.insets = insetsNormal;
        panel.add((Component)this.textDataInicial, cons);
        ++cons.gridx;
        panel.add((Component)this.buttonDataInicial, cons);
        ++cons.gridy;
        cons.gridx = 0;
        panel.add((Component)this.itemConvenio, cons);
        ++cons.gridx;
        cons.insets = insetsEsquerda;
        panel.add((Component)this.itemExame, cons);
        ++cons.gridx;
        panel.add((Component)this.labelDataFinal, cons);
        ++cons.gridx;
        cons.insets = insetsNormal;
        panel.add((Component)this.textDataFinal, cons);
        ++cons.gridx;
        panel.add((Component)this.buttonDataFinal, cons);
        cons.gridx += 3;
        cons.gridwidth = 3;
        cons.anchor = 13;
        cons.fill = 0;
        cons.weightx = 1.0;
        panel.add((Component)this.buttonConsultar, cons);
        panelAux.add((Component)this.splitCentral, "Center");
        panelAux = new JPanel(new FlowLayout(2, 3, 3));
        this.add((Component)ComponenteFactory.novoJPanelBorderLayout(panelAux, null, null, null, null), "South");
        panelAux.add(this.buttonNovo);
        panelAux.add(this.buttonExportar);
        panelAux.add(this.buttonFechar);
        this.carregarParametros();
    }

    private void gravarParametros() {
        StringBuilder bui = new StringBuilder();
        bui.append(this.getAtributosFiltro(this.itemColeta, "coleta"));
        bui.append(this.getAtributosFiltro(this.itemConvenio, "convenio"));
        bui.append(this.getAtributosFiltro(this.itemDestino, "destino"));
        bui.append(this.getAtributosFiltro(this.itemExame, "exame"));
        bui.append(StringUtil.getTag("dataInicial", this.textDataInicial.getText()));
        bui.append(StringUtil.getTag("dataFinal", this.textDataFinal.getText()));
        ParametrosUsuarios.setValor("ExportarResultadoSave.ultimoFiltro", StringUtil.getTag("filtro", bui.toString()));
        ParametrosUsuarios.setValor("ExportarResultadoSave.posicaoDivisor", String.valueOf(this.splitCentral.getDividerLocation()));
    }

    private void carregarParametros() {
        if (ParametrosUsuarios.contemParametro("ExportarResultadoSave.ultimoFiltro")) {
            String str = StringUtil.getValor(ParametrosUsuarios.getValor("ExportarResultadoSave.ultimoFiltro"), "filtro");
            this.setAtributosFiltro(this.itemColeta, StringUtil.getValor(str, "coleta"));
            this.setAtributosFiltro(this.itemConvenio, StringUtil.getValor(str, "convenio"));
            this.setAtributosFiltro(this.itemDestino, StringUtil.getValor(str, "destino"));
            this.setAtributosFiltro(this.itemExame, StringUtil.getValor(str, "exame"));
            this.textDataInicial.setText(StringUtil.getValor(str, "dataInicial"));
            this.textDataFinal.setText(StringUtil.getValor(str, "dataFinal"));
        }
        if (ParametrosUsuarios.contemParametro("ExportarResultadoSave.posicaoDivisor")) {
            this.posicaoDivisor = Integer.parseInt(ParametrosUsuarios.getValor("ExportarResultadoSave.posicaoDivisor"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void consultarRequisicoes() {
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        this.modeloRequisicoes.clear();
        this.modeloExames.clear();
        this.modeloOutrosExames.clear();
        this.requisicoes.clear();
        try {
            this.habilitarDesabilitar(false);
            this.xmlConfiguracao = "";
            if (st != null) {
                ResultSet rs = Conexao.executeQuery(st, this.getSelectRequisicoes());
                SaveService saveService = new SaveService();
                while (rs.next()) {
                    ArrayList<Registro> exames = saveService.buscaExamesRequisicao(rs.getInt("fil_codigo"), rs.getInt("req_codigo"), ExportarResultadoSave.getExpressao("exr.exa_codigo", this.itemExame.getSelecionados(0), true));
                    ArrayList<Registro> examesRel = new ArrayList<Registro>();
                    for (Registro re : exames) {
                        examesRel.add(re);
                    }
                    if (examesRel.size() > 0) {
                        this.requisicoes.add(new Registro(rs));
                        this.modeloRequisicoes.addLine(new Object[]{rs.getString("req_codigo"), rs.getString("pac_nome"), examesRel});
                    }
                    if (!this.xmlConfiguracao.isEmpty()) continue;
                    this.xmlConfiguracao = rs.getString("xml");
                }
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage() + "\nSQL: " + this.getSelectRequisicoes(), e.getStackTrace(), "ExportarResultadoSave: 311");
        }
        finally {
            this.habilitarDesabilitar(true);
        }
    }

    private void excluirRequisicao() {
        if (Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.requisicoes.remove(this.tableRequisicoes.getSelectedRow());
            this.modeloRequisicoes.removeLine(this.tableRequisicoes.getSelectedRow());
        }
    }

    private String getAtributosFiltro(CheckItemFiltro item, String nome) {
        StringBuilder bui = new StringBuilder();
        bui.append(StringUtil.getTag("sel", String.valueOf(item.isSelected())));
        bui.append(StringUtil.getTag("item", item.getSelecionados(0)));
        return StringUtil.getTag(nome, bui.toString());
    }

    private void setAtributosFiltro(CheckItemFiltro item, String atributos) {
        if (StringUtil.getBoolean(atributos, "sel")) {
            item.setSelected(true);
            item.setSelecionados(StringUtil.getValores(atributos, "item"));
        }
    }

    private void exportar() {
        if (this.modeloRequisicoes.getRowCount() <= 0) {
            return;
        }
        ArrayList<Registro> listaExamesExportar = new ArrayList<Registro>();
        boolean contemExamesSemResultado = false;
        for (int reqAtual = 0; reqAtual < this.modeloRequisicoes.getRowCount(); ++reqAtual) {
            ArrayList listaExamesRequisicao = (ArrayList)this.modeloRequisicoes.getValueAt(reqAtual, 2);
            for (Registro registro : listaExamesRequisicao) {
                if (registro.getValor("exr_situacao").equals("C") || registro.getValor("exr_situacao").equals("I") || registro.getValor("exr_situacao").equals("E")) {
                    listaExamesExportar.add(registro);
                    continue;
                }
                if (contemExamesSemResultado) continue;
                contemExamesSemResultado = true;
                if (Funcoes.mensagem(this, "Os exames sem resultados n\u00e3o ser\u00e3o adicionados no arquivo de integra\u00e7\u00e3o.\nDeseja continuar?", 4, true) != 1) continue;
                return;
            }
        }
        SaveService saveService = new SaveService();
        try {
            saveService.gerarArquivo(this, listaExamesExportar, this.xmlConfiguracao);
            Conexao.arquivaSQL();
        }
        catch (Exception e) {
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ExportarResultadoSave: 371");
        }
    }

    private void habilitarDesabilitar(boolean valor) {
        this.tableRequisicoes.setEnabled(valor);
        this.tableExames.setEnabled(valor);
        this.tableOutrosExames.setEnabled(valor);
        this.itemColeta.setEnabled(valor);
        this.itemConvenio.setEnabled(valor);
        this.itemDestino.setEnabled(valor);
        this.itemExame.setEnabled(valor);
        this.buttonConsultar.setEnabled(valor);
        this.buttonDataFinal.setEnabled(valor);
        this.buttonDataInicial.setEnabled(valor);
        this.buttonNovo.setEnabled(valor);
        this.buttonExportar.setEnabled(valor);
        this.buttonFechar.setEnabled(valor);
        this.labelDataInicial.setEnabled(valor);
        this.labelDataFinal.setEnabled(valor);
        this.textDataFinal.setEnabled(valor);
        this.textDataInicial.setEnabled(valor);
    }

    private String getSelectRequisicoes() {
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        StringBuilder buffer = new StringBuilder();
        try {
            buffer.append("select distinct ");
            buffer.append("a.fil_codigo, a.req_codigo, g.pac_nome, con.con_faturaeletronica as xml ");
            buffer.append("from requisicao a ");
            buffer.append("left join examerequisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo ");
            buffer.append("left join paciente g on a.fil_codigo = g.fil_codigo and a.pac_codigo = g.pac_codigo ");
            buffer.append("inner join convenios con ");
            buffer.append("on a.fil_codigo = con.fil_codigo ");
            buffer.append("and a.con_codigo = con.con_codigo ");
            buffer.append("and con.con_faturaeletronica like '%").append(StringUtil.getTag("protocolo", Save.getNomeProtocolo())).append("%' ");
            buffer.append("where ");
            buffer.append("a.req_excluida = false ");
            buffer.append("and a.req_tipoatendimentosave is not null and a.req_tipoatendimentosave <> ''");
            if (Funcoes.verificaData(this.textDataInicial.getText())) {
                if (buffer.length() > 0) {
                    buffer.append(" and ");
                }
                buffer.append(" a.req_data >= '");
                buffer.append(Funcoes.formataData("MM/dd/yyyy", sdf.parse(this.textDataInicial.getText())));
                buffer.append("' ");
            }
            if (Funcoes.verificaData(this.textDataFinal.getText())) {
                if (buffer.length() > 0) {
                    buffer.append(" and ");
                }
                buffer.append("a.req_data <= '");
                buffer.append(Funcoes.formataData("MM/dd/yyyy", sdf.parse(this.textDataFinal.getText())));
                buffer.append("' ");
            }
            if (this.itemColeta.isSelected()) {
                this.addExpressao(buffer, ExportarResultadoSave.getExpressao("a.col_codigo", this.itemColeta.getSelecionados(0), true));
            }
            if (this.itemConvenio.isSelected()) {
                this.addExpressao(buffer, ExportarResultadoSave.getExpressao("a.con_codigo", this.itemConvenio.getSelecionados(0), false));
            }
            if (this.itemDestino.isSelected()) {
                this.addExpressao(buffer, ExportarResultadoSave.getExpressao("a.des_codigo", this.itemDestino.getSelecionados(0), true));
            }
            if (this.itemExame.isSelected()) {
                this.addExpressao(buffer, ExportarResultadoSave.getExpressao("b.exa_codigo", this.itemExame.getSelecionados(0), true));
            }
            buffer.append(" order by g.pac_nome ");
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ExportarResultadoSave: 446");
        }
        return buffer.toString();
    }

    public static String getExpressao(String campo, String[] valores, boolean aspas) {
        if (campo != null && valores != null && valores.length > 0) {
            StringBuilder buf = new StringBuilder("(");
            for (int i = 0; i < valores.length; ++i) {
                if (i > 0) {
                    buf.append(" or ");
                }
                buf.append(campo);
                buf.append(" = ");
                if (aspas) {
                    buf.append(StringUtil.textoDBEscape(valores[i]));
                    continue;
                }
                buf.append(valores[i]);
            }
            return buf.append(")").toString();
        }
        return "";
    }

    private void addExpressao(StringBuilder bui, String exp) {
        if (exp != null && exp.length() > 0) {
            if (bui.length() > 0) {
                bui.append("and ");
            }
            bui.append(exp);
            bui.append(' ');
        }
    }

    public static long getModuloAcesso() {
        return ACESSO;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        try {
            this.modeloExames.clear();
            this.modeloOutrosExames.clear();
            if (this.tableRequisicoes.getSelectedRow() > -1 && this.modeloRequisicoes.getValueAt(this.tableRequisicoes.getSelectedRow(), 2) != null && this.modeloRequisicoes.getValueAt(this.tableRequisicoes.getSelectedRow(), 2) instanceof ArrayList) {
                ArrayList exames = (ArrayList)this.modeloRequisicoes.getValueAt(this.tableRequisicoes.getSelectedRow(), 2);
                for (Registro r : exames) {
                    Object[] registro = new Object[]{r.getString("exa_codigo"), r.getString("mco_abreviatura"), r.getString("exa_descricao"), r.getString("exr_situacao")};
                    if (r.getString("exr_situacao").equals("C") || r.getString("exr_situacao").equals("I") || r.getString("exr_situacao").equals("E")) {
                        this.modeloExames.addLine(registro);
                        continue;
                    }
                    this.modeloOutrosExames.addLine(registro);
                }
            }
        }
        catch (Exception e1) {
            ErrorLogger.mostraMensagem(this, e1.getMessage(), e1.getStackTrace(), "ExportarResultadoSave: 508");
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.buttonDataInicial) {
            Funcoes.mostraData(this.textDataInicial, this.buttonDataInicial, (JPanel)this.buttonDataInicial.getParent(), false);
        } else if (o == this.buttonDataFinal) {
            Funcoes.mostraData(this.textDataFinal, this.buttonDataFinal, (JPanel)this.buttonDataFinal.getParent(), false);
        } else if (o == this.buttonConsultar) {
            this.consultarRequisicoes();
            this.gravarParametros();
        } else if (o == this.buttonNovo) {
            this.modeloRequisicoes.clear();
            this.modeloExames.clear();
            this.modeloOutrosExames.clear();
            this.requisicoes.clear();
            this.textDataInicial.setText("");
            this.textDataFinal.setText("");
            this.itemColeta.clear();
            this.itemConvenio.clear();
            this.itemDestino.clear();
            this.itemExame.clear();
        } else if (o == this.buttonExportar) {
            this.exportar();
        } else if (o == this.buttonFechar) {
            this.setVisible(false);
            if (this.getParent() != null) {
                this.getParent().removeAll();
            }
        }
    }
}

