/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.ParametrosUsuarios;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.digitacao.Resultado;
import jalis.laboratorio.exportacao.ConfiguradorXml;
import jalis.laboratorio.exportacao.SemResultadoSaoLucas;
import jalis.model.bean.cadastro.FilialBean;
import jalis.service.cadastro.FilialService;
import jalis.util.CheckItemFiltro;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.SplashMensagem;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.CorTableCellRenderer;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableModel;

public class ExportarResultadoSaoLucas
extends JPanel
implements ActionListener,
ListSelectionListener {
    private static final long ACESSO = Long.parseLong("0910000500");
    private static final long CONFIGURAR = Long.parseLong("0910000501");
    private final int COLUNA_EXAMES = 2;
    private JLabel legendaVermelha = new JLabel("Exames sem relacionamento");
    private CheckItemFiltro itemColeta;
    private CheckItemFiltro itemConvenio;
    private CheckItemFiltro itemDestino;
    private CheckItemFiltro itemExame;
    private JCheckBox itemRelacionamento;
    private TTextField textDataIni = new TTextField(0, 4);
    private TTextField textDataFin = new TTextField(0, 4);
    private JLabel labelDataIni = new JLabel("Data Inicial:");
    private JLabel labelDataFin = new JLabel("Data Final:");
    private JButton buttonDataIni = ComponenteFactory.novoJButton(this, null, new Dimension(20, 20), true);
    private JButton buttonDataFin = ComponenteFactory.novoJButton(this, null, new Dimension(20, 20), true);
    private JButton buttonConsultar = ComponenteFactory.novoJButton("Consultar", 'C', this, null, null);
    private JButton buttonNovo = ComponenteFactory.novoJButton("Novo", 'N', this, null, null);
    private JButton buttonExportar = ComponenteFactory.novoJButton("Exportar", 'E', this, null, null);
    private JButton buttonFechar = ComponenteFactory.novoJButton("Fechar", 'F', this, null, null);
    private JPanel panelRequisicoes = new JPanel(new BorderLayout());
    private JPanel panelExames = new JPanel(new BorderLayout());
    private JSplitPane splitCentral = new JSplitPane(1, this.panelRequisicoes, this.panelExames);
    private ModeloGridTable modeloRequisicoes = new ModeloGridTable(new String[]{"Requisi\u00e7\u00e3o", "Paciente"});
    private CorTableCellRenderer renderer = new CorTableCellRenderer();
    private JTable tableRequisicoes = ComponenteFactory.novoJTable((TableModel)this.modeloRequisicoes, (ListSelectionListener)this, 70, 0);
    private JScrollPane scrollRequisicoes = new JScrollPane(this.tableRequisicoes);
    private ModeloGridTable modeloExames = new ModeloGridTable(new String[]{"C\u00f3d.", "Mat.", "Exame", "Sit."});
    private JTable tableExames = ComponenteFactory.novoJTable((TableModel)this.modeloExames, null, 50, 30, 0, 20);
    private JScrollPane scrollExames = new JScrollPane(this.tableExames);
    private JButton buttonConfigurar = ComponenteFactory.novoJButton("Configurar", 'O', this);
    private int posicaoDivisor = 350;
    private static final String POSICAO_DIVISOR = "ExportarResultadoSaoLucas.posicaoDivisor";
    private static final String ULTIMO_FILTRO = "ExportarResultadoSaoLucas.ultimoFiltro";
    private ArrayList<Registro> requisicoes = new ArrayList();

    public ExportarResultadoSaoLucas() {
        this.montaTela();
        this.tableRequisicoes.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127 && ExportarResultadoSaoLucas.this.tableRequisicoes.getSelectedRow() > -1) {
                    ExportarResultadoSaoLucas.this.excluirRequisicao();
                }
            }
        });
    }

    private void montaTela() {
        this.setLayout(new BorderLayout());
        Funcoes.criaBarraDescricao(this, "Exportar S\u00e3o Lucas", "Exporta\u00e7\u00e3o de resultados em arquivos para o sistema S\u00e3o Lucas", "integracao/export_result_saolucas.jpg");
        Dimension dimensionFiltro = new Dimension(150, 20);
        Dimension dimensionText = new Dimension(90, 20);
        Dimension dimensionButton = new Dimension(20, 20);
        JPanel panelAux = new JPanel();
        panelAux.setLayout(new BorderLayout());
        this.add((Component)panelAux, "Center");
        JPanel panel = new JPanel();
        panelAux.add((Component)panel, "North");
        panel.setBorder(BorderFactory.createTitledBorder("Filtro"));
        panel.setLayout(new GridBagLayout());
        this.legendaVermelha.setIcon(ImagemUtils.criarImagemLegenda(8, 8, Color.RED, Color.BLACK));
        this.legendaVermelha.setFont(new Font(this.legendaVermelha.getFont().getName(), 0, 10));
        this.itemColeta = new CheckItemFiltro("Coleta", "Filtrar", "Filtrando coletas", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemColeta.setDados("coletas", new String[]{"col_codigo", "col_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemColeta.setColunaHint(1);
        this.itemColeta.setPreferredSize(dimensionFiltro);
        this.itemColeta.setMinimumSize(dimensionFiltro);
        this.itemConvenio = new CheckItemFiltro("Conv\u00eanio", "Filtrar", "Filtrando conv\u00eanios", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemConvenio.setDados("convenios", new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Fantasia"}, new int[]{70, 0});
        this.itemConvenio.setColunaHint(1);
        this.itemConvenio.setPreferredSize(dimensionFiltro);
        this.itemConvenio.setMinimumSize(dimensionFiltro);
        this.itemRelacionamento = ComponenteFactory.novoJCheckBox("Apenas exames com relacionamento", this);
        this.itemExame = new CheckItemFiltro("Exame", "Filtrar", "Filtrando exames", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemExame.setDados("exames", new String[]{"exa_codigo", "exa_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemExame.setColunaHint(1);
        this.itemExame.setPreferredSize(dimensionFiltro);
        this.itemExame.setMinimumSize(dimensionFiltro);
        this.itemDestino = new CheckItemFiltro("Destino", "Filtrar", "Filtrando destinos", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemDestino.setDados("destino", new String[]{"des_codigo", "des_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemDestino.setColunaHint(1);
        this.itemDestino.setPreferredSize(dimensionFiltro);
        this.itemDestino.setMinimumSize(dimensionFiltro);
        Insets insetsNormal = new Insets(0, 0, 0, 0);
        Insets insetsEsquerda = new Insets(0, 20, 0, 0);
        GridBagConstraints cons = new GridBagConstraints();
        cons.anchor = 17;
        cons.fill = 0;
        cons.gridheight = 1;
        cons.gridwidth = 1;
        cons.gridx = 0;
        cons.gridy = 0;
        cons.insets = insetsNormal;
        cons.weightx = 0.0;
        cons.weighty = 0.0;
        panel.add((Component)this.itemColeta, cons);
        ++cons.gridx;
        cons.insets = insetsEsquerda;
        panel.add((Component)this.itemDestino, cons);
        ++cons.gridx;
        panel.add((Component)this.labelDataIni, cons);
        ++cons.gridx;
        cons.insets = insetsNormal;
        this.textDataIni.setPreferredSize(dimensionText);
        this.textDataIni.setMinimumSize(dimensionText);
        panel.add((Component)this.textDataIni, cons);
        ++cons.gridx;
        this.buttonDataIni.setPreferredSize(dimensionButton);
        this.buttonDataIni.setMinimumSize(dimensionButton);
        panel.add((Component)this.buttonDataIni, cons);
        ++cons.gridy;
        cons.gridx = 0;
        panel.add((Component)this.itemConvenio, cons);
        ++cons.gridx;
        cons.insets = insetsEsquerda;
        panel.add((Component)this.itemExame, cons);
        ++cons.gridx;
        panel.add((Component)this.labelDataFin, cons);
        ++cons.gridx;
        cons.insets = insetsNormal;
        this.textDataFin.setPreferredSize(dimensionText);
        this.textDataFin.setMinimumSize(dimensionText);
        panel.add((Component)this.textDataFin, cons);
        ++cons.gridx;
        this.buttonDataFin.setPreferredSize(dimensionButton);
        this.buttonDataFin.setMinimumSize(dimensionButton);
        panel.add((Component)this.buttonDataFin, cons);
        ++cons.gridy;
        cons.gridx = 0;
        cons.gridwidth = 2;
        cons.fill = 2;
        panel.add((Component)this.itemRelacionamento, cons);
        cons.gridx += 3;
        cons.gridwidth = 3;
        cons.anchor = 13;
        cons.fill = 0;
        cons.weightx = 1.0;
        panel.add((Component)this.buttonConsultar, cons);
        panelAux.add((Component)this.splitCentral, "Center");
        this.splitCentral.setBorder(null);
        this.splitCentral.setDividerSize(3);
        this.splitCentral.setDividerLocation(this.posicaoDivisor);
        panelAux.add((Component)this.legendaVermelha, "South");
        this.buttonConfigurar.setVisible(Acesso.getAcesso(this.getModuloConfigurar()));
        panelAux = new JPanel(new BorderLayout());
        this.add((Component)ComponenteFactory.novoJPanelBorderLayout(panelAux, null, null, null, null), "South");
        JPanel botoes = new JPanel(new FlowLayout(2));
        JPanel configurar = new JPanel(new FlowLayout(0));
        configurar.add(this.buttonConfigurar);
        botoes.add(this.buttonNovo);
        botoes.add(this.buttonExportar);
        botoes.add(this.buttonFechar);
        panelAux.add((Component)configurar, "West");
        panelAux.add(botoes);
        this.panelRequisicoes.setBorder(BorderFactory.createTitledBorder("Requisi\u00e7\u00f5es"));
        this.panelRequisicoes.add((Component)this.scrollRequisicoes, "Center");
        this.panelExames.setBorder(BorderFactory.createTitledBorder("Exames"));
        this.panelExames.add((Component)this.scrollExames, "Center");
        this.tableRequisicoes.getColumnModel().getColumn(0).setMinWidth(70);
        this.tableExames.setDefaultRenderer(Object.class, this.renderer);
        this.textDataIni.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    ExportarResultadoSaoLucas.this.buttonDataIni.doClick();
                }
            }
        });
        this.textDataFin.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    ExportarResultadoSaoLucas.this.buttonDataFin.doClick();
                }
            }
        });
        this.carregarParametros();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.buttonFechar) {
            this.setVisible(false);
            if (this.getParent() != null) {
                this.getParent().removeAll();
            }
        } else if (o == this.buttonNovo) {
            this.modeloRequisicoes.clear();
            this.modeloExames.clear();
            this.requisicoes.clear();
            this.renderer.limpar();
            this.textDataIni.setText("");
            this.textDataFin.setText("");
            this.itemColeta.clear();
            this.itemConvenio.clear();
            this.itemDestino.clear();
            this.itemExame.clear();
        } else if (o == this.buttonConsultar) {
            this.consultarRequisicoes();
            this.gravarParametros();
        } else if (o == this.buttonExportar) {
            try {
                this.exportar();
            }
            catch (ParseException e1) {
                ErrorLogger.mostraMensagem(this, e1.getMessage(), e1.getStackTrace());
            }
        } else if (o == this.buttonDataIni) {
            Funcoes.mostraData(this.textDataIni, this.buttonDataIni, (JPanel)this.buttonDataIni.getParent(), false);
        } else if (o == this.buttonDataFin) {
            Funcoes.mostraData(this.textDataFin, this.buttonDataFin, (JPanel)this.buttonDataFin.getParent(), false);
        } else if (o == this.buttonConfigurar) {
            this.configurarCampos();
        }
    }

    private void configurarCampos() {
        ConfiguradorXml configuradorXml = ConfiguradorXml.novaInstancia(Laboratorio.getInstancia(), false);
        if (configuradorXml.getOK()) {
            this.atualizarCampoXmlSaoLucas(configuradorXml.xmlConfiguracao());
        }
    }

    private void atualizarCampoXmlSaoLucas(String configuradorXml) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" update filiais_postocoleta set fil_configsaolucas = '");
        stringBuilder.append(configuradorXml);
        stringBuilder.append("' ");
        stringBuilder.append("where fil_codigo = ").append(Variaveis.filialPadrao);
        try {
            Conexao.executeUpdate(Variaveis.filialPadrao, Conexao.getStatement(), stringBuilder);
            Conexao.arquivaSQL();
        }
        catch (SQLException e) {
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException e1) {
                new Exception(e1);
            }
        }
    }

    public static long getModuloAcesso() {
        return ACESSO;
    }

    public static long getModuloConfigurar() {
        return CONFIGURAR;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        try {
            this.modeloExames.clear();
            this.renderer.limpar();
            if (this.tableRequisicoes.getSelectedRow() > -1 && this.modeloRequisicoes.getValueAt(this.tableRequisicoes.getSelectedRow(), 2) != null && this.modeloRequisicoes.getValueAt(this.tableRequisicoes.getSelectedRow(), 2) instanceof ArrayList) {
                ArrayList exames = (ArrayList)this.modeloRequisicoes.getValueAt(this.tableRequisicoes.getSelectedRow(), 2);
                int i = 0;
                for (Registro r : exames) {
                    if (Funcoes.textoVazio(r.getString("xml"))) {
                        this.renderer.setCorLinha(Color.RED, i);
                    }
                    ++i;
                    this.modeloExames.addLine(new Object[]{r.getString("exa_codigo"), r.getString("mco_abreviatura"), r.getString("exa_descricao"), r.getString("exr_situacao"), r.getBoolean("enviado")});
                }
            }
        }
        catch (Exception e1) {
            ErrorLogger.mostraMensagem(this, e1.getMessage(), e1.getStackTrace());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void consultarRequisicoes() {
        String SQL = "";
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        SplashMensagem spl = SplashMensagem.getInstancia(this);
        try {
            this.modeloRequisicoes.clear();
            this.requisicoes.clear();
            this.habilitarDesabilitar(false);
            if (st != null) {
                spl.mostrar("Aguarde... Buscando requisi\u00e7\u00f5es");
                ResultSet rsQtd = Conexao.executeQuery(st, this.getSelectQuantidadeRequisicao());
                if (!rsQtd.next()) {
                    return;
                }
                int qdt = rsQtd.getInt("qtd");
                if (qdt <= 0) {
                    return;
                }
                qdt = qdt / 60 + 2;
                int qtdOffSet = 0;
                for (int i = 0; i <= qdt; ++i) {
                    ResultSet rs = Conexao.executeQuery(st, this.getSelectRequisicao(qtdOffSet));
                    HashSet<String> requisicoesSet = new HashSet<String>();
                    while (rs.next()) {
                        if (requisicoesSet.contains(rs.getString("req_codigo"))) continue;
                        ArrayList<Registro> exames = this.pegaExamesRequisicao(st2, rs.getString("req_codigo"));
                        ArrayList<Registro> examesRel = new ArrayList<Registro>();
                        for (Registro re : exames) {
                            String xmlResultado = this.getXmlResultado(st2, rs.getString("req_codigo"), re.getString("exa_codigo"), re.getInt("mco_codigo"));
                            String xml = ExameUtil.pegaRelacionamentoExportaTextoIdade(Variaveis.filialPadrao, rs.getInt("req_idade"), rs.getString("req_anomes"), ExameUtil.getCodigoLayout(Variaveis.filialPadrao, rs.getString("con_codigo"), rs.getString("des_codigo")), re.getString("exa_codigo"), re.getInt("mco_codigo"), re.getString("met_codigo"));
                            re.setValor("xmlResultado", xmlResultado);
                            re.setValor("xml", xml);
                            if (xml == null) {
                                xml = "";
                            }
                            String configuracao = StringUtil.getValor(xml, "exportarsaolucas");
                            if (!this.itemRelacionamento.isSelected()) {
                                examesRel.add(re);
                                continue;
                            }
                            if (Funcoes.textoVazio(configuracao)) continue;
                            examesRel.add(re);
                        }
                        if (examesRel.size() <= 0) continue;
                        this.requisicoes.add(new Registro(rs));
                        requisicoesSet.add(rs.getString("req_codigo"));
                        this.modeloRequisicoes.addLine(new Object[]{rs.getString("req_codigo"), rs.getString("pac_nome"), examesRel});
                    }
                    qtdOffSet += 60;
                    Conexao.arquivaSQL();
                    System.gc();
                }
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage() + "\nSQL: " + SQL, e.getStackTrace());
        }
        finally {
            this.habilitarDesabilitar(true);
            spl.apagar();
        }
    }

    private void carregarParametros() {
        if (ParametrosUsuarios.contemParametro(ULTIMO_FILTRO)) {
            String str = StringUtil.getValor(ParametrosUsuarios.getValor(ULTIMO_FILTRO), "filtro");
            this.setAtributosFiltro(this.itemColeta, StringUtil.getValor(str, "coleta"));
            this.setAtributosFiltro(this.itemConvenio, StringUtil.getValor(str, "convenio"));
            this.setAtributosFiltro(this.itemDestino, StringUtil.getValor(str, "destino"));
            this.setAtributosFiltro(this.itemExame, StringUtil.getValor(str, "exame"));
            this.textDataIni.setText(StringUtil.getValor(str, "dataInicial"));
            this.textDataFin.setText(StringUtil.getValor(str, "dataFinal"));
        }
        if (ParametrosUsuarios.contemParametro(POSICAO_DIVISOR)) {
            this.posicaoDivisor = Integer.parseInt(ParametrosUsuarios.getValor(POSICAO_DIVISOR));
        }
    }

    private void gravarParametros() {
        StringBuilder bui = new StringBuilder();
        bui.append(this.getAtributosFiltro(this.itemColeta, "coleta"));
        bui.append(this.getAtributosFiltro(this.itemConvenio, "convenio"));
        bui.append(this.getAtributosFiltro(this.itemDestino, "destino"));
        bui.append(this.getAtributosFiltro(this.itemExame, "exame"));
        bui.append(StringUtil.getTag("dataInicial", this.textDataIni.getText()));
        bui.append(StringUtil.getTag("dataFinal", this.textDataFin.getText()));
        ParametrosUsuarios.setValor(ULTIMO_FILTRO, StringUtil.getTag("filtro", bui.toString()));
        ParametrosUsuarios.setValor(POSICAO_DIVISOR, String.valueOf(this.splitCentral.getDividerLocation()));
    }

    private void habilitarDesabilitar(boolean valor) {
        this.tableRequisicoes.setEnabled(valor);
        if (this.tableExames != null) {
            this.tableExames.setEnabled(valor);
        }
        this.itemColeta.setEnabled(valor);
        this.itemConvenio.setEnabled(valor);
        this.itemDestino.setEnabled(valor);
        this.itemExame.setEnabled(valor);
        this.itemRelacionamento.setEnabled(valor);
        this.buttonConsultar.setEnabled(valor);
        this.buttonDataFin.setEnabled(valor);
        this.buttonDataIni.setEnabled(valor);
        this.buttonNovo.setEnabled(valor);
        this.buttonExportar.setEnabled(valor);
        this.buttonFechar.setEnabled(valor);
        this.labelDataIni.setEnabled(valor);
        this.labelDataFin.setEnabled(valor);
        this.textDataFin.setEnabled(valor);
        this.textDataIni.setEnabled(valor);
    }

    private String getSelectRequisicao(int qtdOffSet) {
        StringBuilder bui = new StringBuilder("select distinct ");
        try {
            bui.append("  a.req_codigo, a.req_data, g.pac_codigo, g.pac_nome, a.con_codigo, a.req_idade, a.req_anomes, a.des_codigo, g.pac_cpf, g.pac_tipopessoa, ");
            bui.append("  a.req_matricula, a.req_prontuario, b.exr_datadigita, cast(b.exr_datamaterial as date), a.con_codigo, a.med_conselho, a.med_crm, ");
            bui.append("  a.med_uf, a.req_matricula, a.req_guia, c.tpe_codigo, b.exa_codigo, ");
            bui.append("  a.fil_codigo, b.mco_codigo, tpe.tpe_tabelaans, dtp.dtp_codamb ");
            bui.append(" from requisicao a ");
            bui.append(" left join examerequisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo ");
            bui.append(" left join paciente g on a.fil_codigo = g.fil_codigo and a.pac_codigo = g.pac_codigo ");
            bui.append(" left join convenios c on a.fil_codigo = c.fil_codigo and a.con_codigo = c.con_codigo ");
            bui.append(" left join tabelaprecoexames tpe on a.fil_codigo = tpe.fil_codigo and tpe.tpe_codigo = c.tpe_codigo ");
            bui.append(" left join detalhetabelapreco dtp on a.fil_codigo = dtp.fil_codigo and dtp.exa_codigo = b.exa_codigo and dtp.tpe_codigo = tpe.tpe_codigo");
            bui.append(" where a.fil_codigo = ").append(Variaveis.filialPadrao);
            bui.append(" and a.req_excluida = false and b.exr_excluido = false ");
            if (Funcoes.verificaData(this.textDataIni.getText())) {
                if (bui.length() > 0) {
                    bui.append(" and ");
                }
                bui.append(" a.req_data >= '");
                bui.append(Funcoes.formataData("yyyy-MM-dd", this.textDataIni.getText()));
                bui.append("' ");
            }
            if (Funcoes.verificaData(this.textDataFin.getText())) {
                if (bui.length() > 0) {
                    bui.append(" and ");
                }
                bui.append("a.req_data <= '");
                bui.append(Funcoes.formataData("yyyy-MM-dd", this.textDataFin.getText()));
                bui.append("' ");
            }
            if (this.itemColeta.isSelected()) {
                this.addExpressao(bui, ExportarResultadoSaoLucas.getExpressao("a.col_codigo", this.itemColeta.getSelecionados(0), true));
            }
            if (this.itemConvenio.isSelected()) {
                this.addExpressao(bui, ExportarResultadoSaoLucas.getExpressao("a.con_codigo", this.itemConvenio.getSelecionados(0), false));
            }
            if (this.itemDestino.isSelected()) {
                this.addExpressao(bui, ExportarResultadoSaoLucas.getExpressao("a.des_codigo", this.itemDestino.getSelecionados(0), true));
            }
            if (this.itemExame.isSelected()) {
                this.addExpressao(bui, ExportarResultadoSaoLucas.getExpressao("b.exa_codigo", this.itemExame.getSelecionados(0), true));
            }
            bui.append(" order by a.fil_codigo, a.req_codigo, b.exa_codigo, b.mco_codigo ");
            bui.append(" offSet ").append(qtdOffSet).append(" limit 60 ");
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
        }
        return bui.toString();
    }

    private String getSelectQuantidadeRequisicao() {
        StringBuilder bui = new StringBuilder("select count(1) as qtd ");
        try {
            bui.append(" from requisicao a ");
            bui.append(" left join examerequisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo ");
            bui.append(" left join paciente g on a.fil_codigo = g.fil_codigo and a.pac_codigo = g.pac_codigo ");
            bui.append(" left join convenios c on a.fil_codigo = c.fil_codigo and a.con_codigo = c.con_codigo ");
            bui.append(" left join tabelaprecoexames tpe on a.fil_codigo = tpe.fil_codigo and tpe.tpe_codigo = c.tpe_codigo ");
            bui.append(" left join detalhetabelapreco dtp on a.fil_codigo = dtp.fil_codigo and dtp.exa_codigo = b.exa_codigo and dtp.tpe_codigo = tpe.tpe_codigo");
            bui.append(" where a.fil_codigo = ").append(Variaveis.filialPadrao);
            bui.append(" and a.req_excluida = false ");
            if (Funcoes.verificaData(this.textDataIni.getText())) {
                if (bui.length() > 0) {
                    bui.append(" and ");
                }
                bui.append(" a.req_data >= '");
                bui.append(Funcoes.formataData("yyyy-MM-dd", this.textDataIni.getText()));
                bui.append("' ");
            }
            if (Funcoes.verificaData(this.textDataFin.getText())) {
                if (bui.length() > 0) {
                    bui.append(" and ");
                }
                bui.append("a.req_data <= '");
                bui.append(Funcoes.formataData("yyyy-MM-dd", this.textDataFin.getText()));
                bui.append("' ");
            }
            if (this.itemColeta.isSelected()) {
                this.addExpressao(bui, ExportarResultadoSaoLucas.getExpressao("a.col_codigo", this.itemColeta.getSelecionados(0), true));
            }
            if (this.itemConvenio.isSelected()) {
                this.addExpressao(bui, ExportarResultadoSaoLucas.getExpressao("a.con_codigo", this.itemConvenio.getSelecionados(0), false));
            }
            if (this.itemDestino.isSelected()) {
                this.addExpressao(bui, ExportarResultadoSaoLucas.getExpressao("a.des_codigo", this.itemDestino.getSelecionados(0), true));
            }
            if (this.itemExame.isSelected()) {
                this.addExpressao(bui, ExportarResultadoSaoLucas.getExpressao("b.exa_codigo", this.itemExame.getSelecionados(0), true));
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
        }
        return bui.toString();
    }

    private ArrayList<Registro> pegaExamesRequisicao(Statement st, String requisicao) throws Exception {
        ArrayList<Registro> retorno = new ArrayList<Registro>();
        StringBuilder buf = new StringBuilder("select a.exa_codigo, a.mco_codigo, b.mco_abreviatura, ");
        buf.append(" a.met_codigo, c.exa_descricao, a.met_codigo, a.exr_datadigita, a.exr_situacao, a.exr_datamaterial, tpe.tpe_tabelaans, dtp.dtp_codamb ");
        buf.append("from examerequisicao a ");
        buf.append("left join materialcoleta b on a.fil_codigo = b.fil_codigo and a.mco_codigo = b.mco_codigo ");
        buf.append("left join exames c on a.fil_codigo = c.fil_codigo and a.exa_codigo = c.exa_codigo ");
        buf.append("left join requisicao req on a.fil_codigo = req.fil_codigo and req.req_codigo = a.req_codigo ");
        buf.append("left join convenios con on a.fil_codigo = con.fil_codigo and req.con_codigo = con.con_codigo ");
        buf.append("left join tabelaprecoexames tpe on a.fil_codigo = tpe.fil_codigo and tpe.tpe_codigo = con.tpe_codigo ");
        buf.append("left join detalhetabelapreco dtp on a.fil_codigo = dtp.fil_codigo and dtp.exa_codigo = a.exa_codigo and dtp.tpe_codigo = tpe.tpe_codigo and b.mco_codigo = dtp.mco_codigo ");
        buf.append("where a.fil_codigo = ").append(Variaveis.filialPadrao);
        buf.append(" and a.req_codigo = ").append(requisicao);
        buf.append(" and a.exr_excluido = false ");
        if (this.itemExame.isSelected()) {
            this.addExpressao(buf, ExportarResultadoSaoLucas.getExpressao("a.exa_codigo", this.itemExame.getSelecionados(0), true));
        }
        ResultSet rs = Conexao.executeQuery(st, buf);
        while (rs.next()) {
            retorno.add(new Registro(rs));
        }
        return retorno;
    }

    private void addExpressao(StringBuilder bui, String exp) {
        if (exp != null && exp.length() > 0) {
            if (bui.length() > 0) {
                bui.append("and ");
            }
            bui.append(exp);
            bui.append(' ');
        }
    }

    private String getAtributosFiltro(CheckItemFiltro item, String nome) {
        StringBuilder bui = new StringBuilder();
        bui.append(StringUtil.getTag("sel", String.valueOf(item.isSelected())));
        bui.append(StringUtil.getTag("item", item.getSelecionados(0)));
        return StringUtil.getTag(nome, bui.toString());
    }

    private void setAtributosFiltro(CheckItemFiltro item, String atributos) {
        if (StringUtil.getBoolean(atributos, "sel")) {
            item.setSelected(true);
            item.setSelecionados(StringUtil.getValores(atributos, "item"));
        }
    }

    private void excluirRequisicao() {
        if (Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.requisicoes.remove(this.tableRequisicoes.getSelectedRow());
            this.modeloRequisicoes.removeLine(this.tableRequisicoes.getSelectedRow());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportar() throws ParseException {
        if (this.requisicoes != null && this.requisicoes.size() > 0 && this.modeloRequisicoes.getRowCount() > 0) {
            StringBuilder configXmlFilial = new StringBuilder();
            try {
                configXmlFilial.append(((FilialBean)new FilialService().get(Variaveis.filialPadrao)).getConfigSaoLucas());
                if (Funcoes.textoVazio(configXmlFilial.toString())) {
                    Funcoes.mensagem(this, "Configura\u00e7\u00f5es inv\u00e1lidas", 2);
                    ScreenUtil.requisitarFoco(this.buttonConfigurar);
                    return;
                }
                ConfiguradorXml configuradorXmlValidar = ConfiguradorXml.novaInstancia(Laboratorio.getInstancia(), true);
                if (configuradorXmlValidar.getPossuiCampoVazio()) {
                    SemResultadoSaoLucas sem = SemResultadoSaoLucas.novaInstancia(this.getTopLevelAncestor(), "Campos sem configura\u00e7\u00e3o");
                    sem.setLocationRelativeTo(this.getTopLevelAncestor());
                    sem.setCampoSemConfiguracao(configuradorXmlValidar.getCampoSemConfiguracao());
                    sem.setVisible(true);
                    this.configurarCampos();
                    return;
                }
            }
            catch (Exception e1) {
                new Exception(e1);
            }
            String MENSAGEM = "Exportando requisi\u00e7\u00f5es... Aguarde...";
            SplashMensagem splashMensagem = new SplashMensagem();
            splashMensagem.mostrar("Exportando requisi\u00e7\u00f5es... Aguarde...");
            boolean contadorLinha = false;
            StringBuilder file = new StringBuilder();
            ArrayList<String> requisicoesSemResultado = new ArrayList<String>();
            ArrayList<String> problemas = new ArrayList<String>();
            int linhaTabela = 0;
            int sequenciaRegistro = 1;
            boolean semXml = false;
            for (Registro r : this.requisicoes) {
                try {
                    ArrayList exames = (ArrayList)this.modeloRequisicoes.getValueAt(linhaTabela, 2);
                    String requisicao = r.getString("req_codigo");
                    String nomePaciente = r.getString("pac_nome");
                    String prontuario = r.getString("req_prontuario");
                    String cpf = r.getString("pac_cpf");
                    for (Registro re : exames) {
                        String xmlResultado = re.getString("xmlResultado");
                        String xml = re.getString("xml");
                        if (!semXml && Funcoes.textoVazio(xml) && !(semXml = Funcoes.mensagem(this, "A exporta\u00e7\u00e3o possui exames sem relacionamento.\nDeseja continuar mesmo assim ?", 4) == 0)) {
                            splashMensagem.apagar();
                            return;
                        }
                        if (Funcoes.textoVazio(xmlResultado)) {
                            requisicoesSemResultado.add(Funcoes.preencheVazio(requisicao, 8, 1) + "\t" + re.getString("exa_codigo") + "-" + re.getString("exa_descricao"));
                            continue;
                        }
                        if (Funcoes.textoVazio(xml) || !this.preencheLinhaArquivo(file, sequenciaRegistro, r, re, configXmlFilial, problemas)) continue;
                        ++sequenciaRegistro;
                    }
                    this.modeloRequisicoes.clear();
                    if (file.length() > 0 && problemas.isEmpty()) {
                        this.gerarArquivoTxt(file, requisicoesSemResultado, configXmlFilial, problemas);
                    }
                    splashMensagem.apagar();
                    if (requisicoesSemResultado.size() > 0 || problemas.size() > 0) {
                        SemResultadoSaoLucas sem = SemResultadoSaoLucas.novaInstancia(this.getTopLevelAncestor(), "Requisi\u00e7\u00f5es sem resultado");
                        sem.setLocationRelativeTo(this.getTopLevelAncestor());
                        sem.setRequisicoes(requisicoesSemResultado, problemas);
                        sem.setVisible(true);
                    }
                }
                catch (Exception e) {
                    ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
                }
                finally {
                    splashMensagem.apagar();
                }
                ++linhaTabela;
            }
        }
    }

    private boolean preencheLinhaArquivo(StringBuilder file, int sequenciaRegistro, Registro r, Registro re, StringBuilder configXmlFilial, ArrayList<String> problemas) throws ParseException {
        boolean adicionou = false;
        StringBuilder linhasRequisicao = new StringBuilder();
        if (Funcoes.textoVazio(r.getString("med_conselho"))) {
            problemas.add(r.getString("req_codigo") + " - campo conselho do m\u00e9dico n\u00e3o informado.");
            return false;
        }
        if (Funcoes.textoVazio(r.getString("med_crm"))) {
            problemas.add(r.getString("req_codigo") + " - campo crm do m\u00e9dico n\u00e3o informado.");
            return false;
        }
        if (Funcoes.textoVazio(r.getString("med_uf"))) {
            problemas.add(r.getString("req_codigo") + " - campo UF do m\u00e9dico n\u00e3o informado.");
            return false;
        }
        if (re.getDate("exr_datamaterial") == null || re.getDate("exr_datamaterial") != null && Funcoes.textoVazio(Funcoes.formataData("yyyyMMdd", re.getDate("exr_datamaterial")))) {
            problemas.add(r.getString("req_codigo") + " - campo data do material n\u00e3o informado.");
            return false;
        }
        if (Funcoes.textoVazio(r.getString("req_matricula"))) {
            problemas.add(r.getString("req_codigo") + " - campo matr\u00edcula n\u00e3o informado.");
            return false;
        }
        if (Funcoes.textoVazio(r.getString("req_guia"))) {
            problemas.add(r.getString("req_codigo") + " - campo c\u00f3digo da autoriza\u00e7\u00e3o n\u00e3o informado (guia da requisi\u00e7\u00e3o).");
            return false;
        }
        if (Funcoes.textoVazio(re.getString("dtp_codamb"))) {
            problemas.add(r.getString("req_codigo") + " (Exame: " + re.getString("exa_codigo") + ") - campo c\u00f3digo AMB n\u00e3o informado.");
            return false;
        }
        linhasRequisicao.append(StringUtil.removerAcentos(this.getObterCodigoPrestadorOperadora(configXmlFilial)));
        linhasRequisicao.append(StringUtil.removerAcentos(this.getDataGeracaoArquivo()));
        linhasRequisicao.append(StringUtil.removerAcentos(this.getNumeroSerquencialArquivo(configXmlFilial)));
        linhasRequisicao.append(StringUtil.removerAcentos(this.getSequencialRegistroArquivo(sequenciaRegistro)));
        linhasRequisicao.append(StringUtil.removerAcentos(this.getOrdemServicoLaboratorio(r, re)));
        linhasRequisicao.append(StringUtil.removerAcentos(this.getCodigoLocalColetaExame(configXmlFilial)));
        linhasRequisicao.append(StringUtil.removerAcentos(this.getCodigoConvenio(r, re)));
        linhasRequisicao.append(StringUtil.removerAcentos(this.getCodigoConselhoProfissionalSolicitante(r, re)));
        linhasRequisicao.append(StringUtil.removerAcentos(this.getNumeroConselhoProfissionalSolicitante(r, re)));
        linhasRequisicao.append(StringUtil.removerAcentos(this.getUfConselhoProfissionalSolicitante(r, re)));
        linhasRequisicao.append(StringUtil.removerAcentos(this.getDataColetaExame(r, re)));
        linhasRequisicao.append(StringUtil.removerAcentos(this.getMatriculaCodigoBeneficiario(r, re)));
        linhasRequisicao.append(StringUtil.removerAcentos(this.getNumeroAutorizacaoConvenio(r, re)));
        linhasRequisicao.append(StringUtil.removerAcentos(this.getCodigoTabelaProcedimento(r, re)));
        linhasRequisicao.append(StringUtil.removerAcentos(this.getCodigoTuss(r, re)));
        String resultadoNumeric = StringUtil.removerAcentos(this.getResultadoAnaliseNumerico(r, re));
        if (!Funcoes.textoVazio(resultadoNumeric) && Funcoes.isNumeric(resultadoNumeric)) {
            linhasRequisicao.append(Funcoes.preencheVazio(resultadoNumeric, 15, 1));
            linhasRequisicao.append(Funcoes.preencheVazio(StringUtil.removerAcentos(""), 40, 2));
        } else {
            linhasRequisicao.append(Funcoes.preencheVazio("", 15, 1));
            linhasRequisicao.append(Funcoes.preencheVazio(StringUtil.removerAcentos(this.getResultadoAnaliseTexto(r, re)), 40, 2));
        }
        if (Funcoes.textoVazio(this.getObservacaoResultado(r, re))) {
            linhasRequisicao.append(this.getObservacaoResultado(r, re));
        } else {
            linhasRequisicao.append(StringUtil.removerAcentos(this.getObservacaoResultado(r, re)));
        }
        linhasRequisicao.append(StringUtil.removerAcentos(this.getCodigoConselhoProfExecutante(configXmlFilial)));
        linhasRequisicao.append(StringUtil.removerAcentos(this.getNumeroConselhoProfExecutante(configXmlFilial)));
        linhasRequisicao.append(StringUtil.removerAcentos(this.getUfConselhoProfExecutante(configXmlFilial)));
        if (linhasRequisicao.toString().length() == 305) {
            file.append(linhasRequisicao.toString().toUpperCase().trim());
            file.append("\n");
            adicionou = true;
        }
        linhasRequisicao.setLength(0);
        return adicionou;
    }

    private void gerarArquivoTxt(StringBuilder file, ArrayList<String> requisicoesSemResultado, StringBuilder configXmlFilial, ArrayList<String> problemas) throws IOException, Exception {
        JFileChooser f = ComponenteFactory.novoJFileChooser();
        FileFilter flt = ComponenteFactory.novoFileFilter("(*.txt)", "txt");
        f.setFileFilter(flt);
        if (f.showSaveDialog(this) == 0) {
            String arquivo = f.getSelectedFile().getAbsolutePath();
            if (!arquivo.toUpperCase().endsWith(".TXT")) {
                arquivo = arquivo + ".txt";
            }
            StringUtil.escreverArquivoTexto(arquivo, file.toString());
            String xmlTag = StringUtil.getValor(configXmlFilial.toString(), "configSaoLucas");
            String valor = StringUtil.getValor(xmlTag.toString(), "nsga");
            if (Funcoes.textoVazio(valor)) {
                valor = "0";
            }
            Integer sequenciaArquivo = Integer.valueOf(valor) + 1;
            StringUtil.setValor(configXmlFilial, "nsga", sequenciaArquivo.toString());
            this.atualizarCampoXmlSaoLucas(configXmlFilial.toString());
            Funcoes.mensagem(this, "Exporta\u00e7\u00e3o realizada com sucesso!\nArquivo: " + arquivo, 5);
        }
        if (requisicoesSemResultado.size() > 0) {
            SemResultadoSaoLucas sem = SemResultadoSaoLucas.novaInstancia(this.getTopLevelAncestor(), "Requisi\u00e7\u00f5es sem resultado");
            sem.setLocationRelativeTo(this.getTopLevelAncestor());
            sem.setRequisicoes(requisicoesSemResultado, problemas);
            sem.setVisible(true);
        }
    }

    private String getDataGeracaoArquivo() {
        return Funcoes.formataData("yyyyMMdd", Calendar.getInstance().getTime());
    }

    private String getUfConselhoProfExecutante(StringBuilder xml) {
        String retorno = StringUtil.getValor(StringUtil.getValor(xml.toString(), "configSaoLucas"), "upe");
        if (retorno.length() > 2) {
            retorno = retorno.substring(0, 2);
        }
        return Funcoes.preencheVazio(retorno, 2, 2);
    }

    private String getNumeroConselhoProfExecutante(StringBuilder xml) {
        String retorno = StringUtil.getValor(StringUtil.getValor(xml.toString(), "configSaoLucas"), "npe");
        if (retorno.length() > 6) {
            retorno = retorno.substring(0, 6);
        }
        return Funcoes.preencheVazio(retorno, 6, 2);
    }

    private String getCodigoConselhoProfExecutante(StringBuilder xml) {
        String retorno = StringUtil.getValor(StringUtil.getValor(xml.toString(), "configSaoLucas"), "cpe");
        retorno = retorno.replaceAll("\\.", "");
        if ((retorno = retorno.replaceAll("\\-", "")).length() > 7) {
            retorno = retorno.substring(0, 7);
        }
        return Funcoes.preencheVazio(retorno, 7, 2);
    }

    private String getObservacaoResultado(Registro r, Registro re) {
        String resultado = this.getValorObsResultado(re);
        if (resultado == null) {
            resultado = "";
        }
        if ((resultado = StringUtil.removerAcentos(resultado)).length() > 120) {
            return resultado.substring(0, 120);
        }
        return Funcoes.preencheVazio(resultado, 120, 2);
    }

    private String getValorObsResultado(Registro re) {
        String[] campos;
        String resultado = "";
        Map<String, Object> camposResultado = Resultado.getCamposResultado(re.getString("xmlResultado"));
        String xml = StringUtil.getValor(re.getString("xml"), "exportarsaolucas");
        for (String campo : campos = StringUtil.getValores(xml, "campo")) {
            String campoModelo = StringUtil.getValor(campo, "campomodelo");
            String tipo = StringUtil.getValor(campo, "tipo");
            if (!tipo.equalsIgnoreCase("textobservacao")) continue;
            resultado = (String)camposResultado.get(campoModelo.toLowerCase());
            break;
        }
        if (resultado != null) {
            resultado = resultado.replaceAll("\\<.[html]*[b]*[i]*[u]*[sub]*[sup]*\\>", "");
        }
        return resultado;
    }

    private String getResultadoAnaliseTexto(Registro r, Registro re) {
        String[] campos;
        Map<String, Object> camposResultado = Resultado.getCamposResultado(re.getString("xmlResultado"));
        String xml = StringUtil.getValor(re.getString("xml"), "exportarsaolucas");
        String resultado = "";
        for (String campo : campos = StringUtil.getValores(xml, "campo")) {
            String campoModelo = StringUtil.getValor(campo, "campomodelo");
            String tipo = StringUtil.getValor(campo, "tipo");
            if (!tipo.equalsIgnoreCase("resultadotexto")) continue;
            resultado = (String)camposResultado.get(campoModelo.toLowerCase());
            break;
        }
        if (resultado == null) {
            resultado = "";
        }
        if (resultado != null) {
            resultado = resultado.replaceAll("\\<.[html]*[b]*[i]*[u]*[sub]*[sup]*\\>", "");
        }
        if ((resultado = StringUtil.removerAcentos(resultado)).length() > 40) {
            return resultado.substring(0, 40);
        }
        return Funcoes.preencheVazio(resultado, 40, 2);
    }

    private String getResultadoAnaliseNumerico(Registro r, Registro re) {
        String[] campos;
        Map<String, Object> camposResultado = Resultado.getCamposResultado(re.getString("xmlResultado"));
        String xml = StringUtil.getValor(re.getString("xml"), "exportarsaolucas");
        String resultado = "";
        for (String campo : campos = StringUtil.getValores(xml, "campo")) {
            String campoModelo = StringUtil.getValor(campo, "campomodelo");
            String tipo = StringUtil.getValor(campo, "tipo");
            if (!tipo.equalsIgnoreCase("resultadonumerico")) continue;
            resultado = (String)camposResultado.get(campoModelo.toLowerCase());
            break;
        }
        if (resultado == null) {
            resultado = "";
        }
        if (resultado.length() > 15) {
            return resultado.substring(0, 15);
        }
        return Funcoes.preencheVazio(resultado, 15, 1);
    }

    private String getCodigoTuss(Registro r, Registro re) {
        String tuss = re.getString("dtp_codamb");
        tuss = tuss.trim().replaceAll("\\.", "");
        if ((tuss = tuss.trim().replaceAll("\\-", "")).length() > 8) {
            return tuss.substring(0, 8);
        }
        return Funcoes.preencheVazio(tuss, 8, 2);
    }

    private String getCodigoTabelaProcedimento(Registro r, Registro re) {
        if (re.getString("tpe_tabelaans").length() > 2) {
            return re.getString("tpe_tabelaans").substring(0, 2);
        }
        return Funcoes.preencheZero(r.getString("tpe_tabelaans"), 2);
    }

    private String getNumeroAutorizacaoConvenio(Registro r, Registro re) {
        if (r.getString("req_guia").length() > 18) {
            return r.getString("req_guia").substring(0, 18);
        }
        return Funcoes.preencheVazio(r.getString("req_guia"), 18, 2);
    }

    private String getMatriculaCodigoBeneficiario(Registro r, Registro re) {
        if (r.getString("req_matricula").trim().length() > 17) {
            return r.getString("req_matricula").substring(0, 17);
        }
        return Funcoes.preencheVazio(r.getString("req_matricula").trim(), 17, 2);
    }

    private String getDataColetaExame(Registro r, Registro re) {
        try {
            return Funcoes.formataData("yyyyMMdd", re.getDate("exr_datamaterial"));
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel converter data de coleta.", e.getStackTrace());
            return null;
        }
    }

    private String getUfConselhoProfissionalSolicitante(Registro r, Registro re) {
        if (r.getString("med_uf").length() > 2) {
            return r.getString("med_uf").substring(0, 2);
        }
        return r.getString("med_uf");
    }

    private String getNumeroConselhoProfissionalSolicitante(Registro r, Registro re) {
        String crm = r.getString("med_crm");
        if (crm == null) {
            crm = "";
        }
        if ((crm = crm.replaceAll("\\.", "")).length() > 6) {
            return crm.substring(0, 6);
        }
        return Funcoes.preencheVazio(crm, 6, 2);
    }

    private String getCodigoConselhoProfissionalSolicitante(Registro r, Registro re) {
        String conselho = r.getString("med_conselho");
        if (conselho == null) {
            conselho = "";
        }
        if ((conselho = conselho.replaceAll("\\.", "")).length() > 7) {
            return conselho.substring(0, 7);
        }
        return Funcoes.preencheVazio(conselho, 7, 2);
    }

    private String getCodigoConvenio(Registro r, Registro re) {
        if (r.getString("con_codigo").length() > 6) {
            return r.getString("con_codigo").substring(0, 6);
        }
        return Funcoes.preencheZero(r.getString("con_codigo"), 6);
    }

    private String getCodigoLocalColetaExame(StringBuilder xml) {
        String retorno = StringUtil.getValor(StringUtil.getValor(xml.toString(), "configSaoLucas"), "clce");
        if (retorno.length() > 6) {
            retorno = retorno.substring(0, 6);
        }
        return Funcoes.preencheZero(retorno, 6);
    }

    private String getOrdemServicoLaboratorio(Registro r, Registro re) {
        return Funcoes.preencheZero(r.getString("req_codigo"), 9);
    }

    private String getNumeroSerquencialArquivo(StringBuilder xml) {
        String retorno = StringUtil.getValor(StringUtil.getValor(xml.toString(), "configSaoLucas"), "nsga");
        if (retorno.length() > 6) {
            retorno = retorno.substring(0, 6);
        }
        if (Funcoes.textoVazio(retorno)) {
            retorno = "0";
        }
        return Funcoes.preencheZero(Integer.parseInt(retorno) + 1, 6);
    }

    private String getSequencialRegistroArquivo(int sequenciaRegistro) {
        return Funcoes.preencheZero(sequenciaRegistro, 6);
    }

    private String getObterCodigoPrestadorOperadora(StringBuilder xml) {
        String retorno = StringUtil.getValor(StringUtil.getValor(xml.toString(), "configSaoLucas"), "cpo");
        if (retorno.length() > 6) {
            retorno = retorno.substring(0, 6);
        }
        return Funcoes.preencheZero(retorno, 6);
    }

    private String getXmlResultado(Statement st, String requisicao, String exame, int materialColetado) {
        try {
            StringBuilder buf = new StringBuilder("select pegaResultadoExame(fil_codigo, req_codigo, exa_codigo, mco_codigo) as exr_resultado ");
            buf.append("from examerequisicao ");
            buf.append("where fil_codigo = ").append(Variaveis.filialPadrao);
            buf.append(" and req_codigo = ").append(requisicao);
            buf.append(" and exa_codigo = '").append(exame).append("'");
            buf.append(" and mco_codigo = ").append(materialColetado);
            buf.append(" and exr_excluido = false ");
            ResultSet rs = Conexao.executeQuery(st, buf);
            if (rs.next()) {
                return rs.getString("exr_resultado");
            }
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
        }
        return "";
    }

    public void pressioneiF2() {
        if (this.textDataIni.hasFocus()) {
            Funcoes.mostraData(this.textDataIni, this.buttonDataIni, this, true);
        } else if (this.textDataFin.hasFocus()) {
            Funcoes.mostraData(this.textDataFin, this.buttonDataFin, this, true);
        }
    }

    public static String getExpressao(String campo, String[] valores, boolean aspas) {
        if (campo != null && valores != null && valores.length > 0) {
            StringBuilder buf = new StringBuilder("(");
            for (int i = 0; i < valores.length; ++i) {
                if (i > 0) {
                    buf.append(" or ");
                }
                buf.append(campo);
                buf.append(" = ");
                if (aspas) {
                    buf.append('\'');
                }
                buf.append(valores[i]);
                if (!aspas) continue;
                buf.append('\'');
            }
            return buf.append(")").toString();
        }
        return "";
    }
}

