/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao;

import jalis.comum.Conexao;
import jalis.comum.ParametrosUsuarios;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.util.faturamento.eletronico.Resuline;
import jalis.util.CheckItemFiltro;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.SplashMensagem;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.ThreadFinalizadaListener;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.EventObject;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ExportarResultadoResuline
extends JPanel
implements ActionListener,
ThreadFinalizadaListener {
    private static final long ACESSO_ACESSAR = Long.parseLong("0910000700");
    private static final String POSICAO_DIVISOR = "ExportarResultadoResuLine.posicaoDivisor";
    private static final String ULTIMO_FILTRO = "ExportarResultadoResuLine.ultimoFiltro";
    private final int COLUNA_REQUISICAO_CODIGO = 0;
    private final int COLUNA_REQUISICAO_EXAMES = 2;
    private CheckItemFiltro itemConvenio;
    private TTextField textDataInicial = new TTextField(0, 4);
    private TTextField textDataFinal = new TTextField(0, 4);
    private TTextField textHoraInicial = new TTextField(0, 6);
    private TTextField textHoraFinal = new TTextField(0, 6);
    private JLabel labelDataInicial = new JLabel("Data Inicial:");
    private JLabel labelDataFinal = new JLabel("Data Final:");
    private JLabel labelHoraInicial = new JLabel("Hora Inicial:");
    private JLabel labelHoraFinal = new JLabel("Hora Final:");
    private JLabel labelCampoData = new JLabel("Campo Data:");
    private JButton buttonDataInicial = ComponenteFactory.novoJButton(this, null, new Dimension(20, 20), true);
    private JButton buttonDataFinal = ComponenteFactory.novoJButton(this, null, new Dimension(20, 20), true);
    private JButton buttonConsultar = ComponenteFactory.novoJButton("Consultar", 'C', this, null, null);
    private JButton buttonNovo = ComponenteFactory.novoJButton("Novo", 'N', this, null, null);
    private JButton buttonExportar = ComponenteFactory.novoJButton("Exportar", 'E', this, null, null);
    private JButton buttonFechar = ComponenteFactory.novoJButton("Fechar", 'F', this, null, null);
    private JPanel panelRequisicoes = new JPanel(new BorderLayout());
    private JPanel panelExames = new JPanel(new BorderLayout());
    private JPanel panelBotoes = new JPanel(new FlowLayout(2));
    private JPanel panelFiltros = new JPanel(new GridBagLayout());
    private JPanel panelCentral = new JPanel(new BorderLayout());
    private JComboBox comboData = new JComboBox<String>(new String[]{"Requisi\u00e7\u00e3o", "Fatura"});
    private JSplitPane splitCentral = new JSplitPane(1, this.panelRequisicoes, this.panelExames);
    private JTable tableRequisicoes = new JTable();
    private JScrollPane scrollRequisicoes = new JScrollPane(this.tableRequisicoes);
    private ModeloGridTable modeloRequisicoes = new ModeloGridTable(new String[]{"Requisi\u00e7\u00e3o", "Paciente"});
    private JTable tableExames = new JTable();
    private JScrollPane scrollExames = new JScrollPane(this.tableExames);
    private ModeloGridTable modeloExames = new ModeloGridTable(new String[]{"C\u00f3d.", "Mat.", "Exame"});
    private int posicaoDivisor = 350;
    private ArrayList<Registro> requisicoes = new ArrayList();
    private String codigoConvenio = null;
    private String xmlConfiguracao = null;

    public ExportarResultadoResuline() {
        this.montaTela();
        this.novo();
    }

    private void montaTela() {
        this.setLayout(new BorderLayout());
        Funcoes.criaBarraDescricao(this, "Exportar Resuline", "Exporta\u00e7\u00e3o de resultados para o sistema Resuline", "integracao/export_result_resuline.jpg");
        Dimension dimensionFiltro = new Dimension(170, 20);
        Dimension dimensionData = new Dimension(90, 20);
        Dimension dimensionHora = new Dimension(50, 20);
        Dimension dimensionButton = new Dimension(20, 20);
        Dimension dimensionCombo = new Dimension(110, 20);
        StringBuilder bufFiltro = new StringBuilder();
        bufFiltro.append(" fil_codigo = ").append(Variaveis.filialPadrao);
        bufFiltro.append(" and con_faturaeletronica ilike '%<protocolo>").append(Resuline.getNomeProtocolo()).append("</protocolo>%' ");
        this.itemConvenio = new CheckItemFiltro("Conv\u00eanio", "Filtrar", "Filtrando conv\u00eanios que exportam para Resuline", bufFiltro.toString());
        this.itemConvenio.setDados("convenios", new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Fantasia"}, new int[]{70, 0});
        this.itemConvenio.setColunaHint(1);
        this.itemConvenio.setPreferredSize(dimensionFiltro);
        this.itemConvenio.setMinimumSize(dimensionFiltro);
        this.add((Component)this.panelCentral, "Center");
        this.panelFiltros.setBorder(BorderFactory.createTitledBorder("Filtro"));
        this.splitCentral.setBorder(null);
        this.splitCentral.setDividerSize(3);
        this.splitCentral.setDividerLocation(this.posicaoDivisor);
        this.panelCentral.add((Component)this.panelFiltros, "North");
        this.panelCentral.add((Component)this.splitCentral, "Center");
        this.panelCentral.add((Component)this.panelBotoes, "South");
        Insets insetsNormal = new Insets(0, 1, 0, 0);
        Insets insetsEsquerda = new Insets(0, 20, 0, 0);
        GridBagConstraints cons = new GridBagConstraints();
        cons.anchor = 17;
        cons.fill = 0;
        cons.gridheight = 1;
        cons.gridwidth = 1;
        cons.gridx = 0;
        cons.gridy = 0;
        cons.insets = insetsNormal;
        cons.weightx = 0.0;
        cons.weighty = 0.0;
        this.panelFiltros.add((Component)this.labelCampoData, cons);
        ++cons.gridx;
        this.comboData.setPreferredSize(dimensionCombo);
        this.comboData.setMinimumSize(dimensionCombo);
        this.panelFiltros.add((Component)this.comboData, cons);
        ++cons.gridx;
        cons.gridwidth = 1;
        cons.insets = insetsEsquerda;
        this.panelFiltros.add((Component)this.labelDataInicial, cons);
        ++cons.gridx;
        cons.insets = insetsNormal;
        this.textDataInicial.setPreferredSize(dimensionData);
        this.textDataInicial.setMinimumSize(dimensionData);
        this.panelFiltros.add((Component)this.textDataInicial, cons);
        ++cons.gridx;
        this.buttonDataInicial.setPreferredSize(dimensionButton);
        this.buttonDataInicial.setMinimumSize(dimensionButton);
        this.panelFiltros.add((Component)this.buttonDataInicial, cons);
        ++cons.gridx;
        cons.insets = insetsEsquerda;
        this.panelFiltros.add((Component)this.labelHoraInicial, cons);
        ++cons.gridx;
        cons.insets = insetsNormal;
        this.textHoraInicial.setPreferredSize(dimensionHora);
        this.textHoraInicial.setMinimumSize(dimensionHora);
        this.panelFiltros.add((Component)this.textHoraInicial, cons);
        ++cons.gridy;
        cons.gridx = 0;
        cons.gridwidth = 2;
        cons.fill = 2;
        this.panelFiltros.add((Component)this.itemConvenio, cons);
        cons.gridx += 2;
        cons.gridwidth = 1;
        cons.insets = insetsEsquerda;
        cons.fill = 0;
        this.panelFiltros.add((Component)this.labelDataFinal, cons);
        ++cons.gridx;
        cons.insets = insetsNormal;
        this.textDataFinal.setPreferredSize(dimensionData);
        this.textDataFinal.setMinimumSize(dimensionData);
        this.panelFiltros.add((Component)this.textDataFinal, cons);
        ++cons.gridx;
        this.buttonDataFinal.setPreferredSize(dimensionButton);
        this.buttonDataFinal.setMinimumSize(dimensionButton);
        this.panelFiltros.add((Component)this.buttonDataFinal, cons);
        ++cons.gridx;
        cons.insets = insetsEsquerda;
        this.panelFiltros.add((Component)this.labelHoraFinal, cons);
        ++cons.gridx;
        cons.insets = insetsNormal;
        this.textHoraFinal.setPreferredSize(dimensionHora);
        this.textHoraFinal.setMinimumSize(dimensionHora);
        this.panelFiltros.add((Component)this.textHoraFinal, cons);
        ++cons.gridx;
        cons.weightx = 1.0;
        cons.gridwidth = 1;
        cons.anchor = 13;
        this.buttonConsultar.setPreferredSize(new Dimension(85, 25));
        this.buttonConsultar.setMinimumSize(new Dimension(85, 25));
        this.panelFiltros.add((Component)this.buttonConsultar, cons);
        this.panelBotoes.add(this.buttonNovo);
        this.panelBotoes.add(this.buttonExportar);
        this.panelBotoes.add(this.buttonFechar);
        this.panelRequisicoes.setBorder(BorderFactory.createTitledBorder("Requisi\u00e7\u00f5es"));
        this.panelRequisicoes.add((Component)this.scrollRequisicoes, "Center");
        this.tableRequisicoes.setModel(this.modeloRequisicoes);
        this.modeloRequisicoes.setColumnSize(new int[]{80, 0}, this.tableRequisicoes);
        this.tableRequisicoes.getTableHeader().addMouseListener(this.modeloRequisicoes);
        this.panelExames.setBorder(BorderFactory.createTitledBorder("Exames"));
        this.panelExames.add((Component)this.scrollExames, "Center");
        this.tableExames.setModel(this.modeloExames);
        this.modeloExames.setColumnSize(new int[]{50, 45, 0}, this.tableExames);
        this.tableExames.getTableHeader().addMouseListener(this.modeloExames);
        this.montaListeners();
        Funcoes.montaEnter((JComponent)this);
        this.carregarParametros();
    }

    private void montaListeners() {
        this.tableRequisicoes.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127 && ExportarResultadoResuline.this.tableRequisicoes.getSelectedRow() > -1) {
                    ExportarResultadoResuline.this.excluirRequisicao();
                }
            }
        });
        this.tableRequisicoes.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ExportarResultadoResuline.this.modeloExames.clear();
                int row = ExportarResultadoResuline.this.tableRequisicoes.getSelectedRow();
                if (row > -1 && ExportarResultadoResuline.this.modeloRequisicoes.getValueAt(row, 2) != null && ExportarResultadoResuline.this.modeloRequisicoes.getValueAt(row, 2) instanceof ArrayList) {
                    ArrayList exames = (ArrayList)ExportarResultadoResuline.this.modeloRequisicoes.getValueAt(row, 2);
                    for (Registro r : exames) {
                        ExportarResultadoResuline.this.modeloExames.addLine(new Object[]{r.getString("exa_codigo"), r.getString("mco_abreviatura"), r.getString("exa_descricao"), r.getString("exr_situacao"), r.getBoolean("enviado")});
                    }
                }
            }
        });
        this.textDataInicial.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    ExportarResultadoResuline.this.buttonDataInicial.doClick();
                }
            }
        });
        this.textDataFinal.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    ExportarResultadoResuline.this.buttonDataFinal.doClick();
                }
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.buttonFechar) {
            this.fechar();
        } else if (o == this.buttonNovo) {
            this.novo();
        } else if (o == this.buttonConsultar) {
            this.consultar();
        } else if (o == this.buttonExportar) {
            this.exportar();
        } else if (o == this.buttonDataInicial) {
            Funcoes.mostraData(this.textDataInicial, this.buttonDataInicial, (JPanel)this.buttonDataInicial.getParent(), false);
        } else if (o == this.buttonDataFinal) {
            Funcoes.mostraData(this.textDataFinal, this.buttonDataFinal, (JPanel)this.buttonDataFinal.getParent(), false);
        }
    }

    private void fechar() {
        this.setVisible(false);
        if (this.getParent() != null) {
            this.getParent().removeAll();
        }
    }

    private void consultar() {
        if (this.validaCampos()) {
            this.consultarRequisicoes();
            this.gravarParametros();
        }
    }

    private boolean validaCampos() {
        if (Funcoes.textoVazio(this.textDataInicial)) {
            Funcoes.mensagem(this, "A data inicial deve ser informada.", 2);
            ScreenUtil.requisitarFoco(this.textDataInicial);
            return false;
        }
        String[] conveniosSelecionados = this.itemConvenio.getSelecionados();
        if (conveniosSelecionados == null || conveniosSelecionados.length == 0) {
            Funcoes.mensagem(this, "\u00c9 necess\u00e1rio selecionar um conv\u00eanio.", 2);
            ScreenUtil.requisitarFoco(this.itemConvenio);
            return false;
        }
        if (conveniosSelecionados.length > 1) {
            Funcoes.mensagem(this, "Somente um conv\u00eanio pode ser selecionado.", 2);
            ScreenUtil.requisitarFoco(this.itemConvenio);
            return false;
        }
        if (Funcoes.textoVazio(this.textDataFinal) && !Funcoes.textoVazio(this.textHoraFinal)) {
            Funcoes.mensagem(this, "\u00c9 necess\u00e1rio informar a data final.", 2);
            ScreenUtil.requisitarFoco(this.textDataFinal);
            return false;
        }
        return true;
    }

    private void novo() {
        this.limparCampos();
        this.carregarParametros();
        ScreenUtil.requisitarFoco(this.textDataInicial);
    }

    private void limparCampos() {
        this.modeloRequisicoes.clear();
        this.modeloExames.clear();
        this.requisicoes.clear();
        this.textDataInicial.clear();
        this.textDataFinal.clear();
        this.textHoraInicial.clear();
        this.textHoraFinal.clear();
        this.itemConvenio.clear();
        this.codigoConvenio = null;
        this.xmlConfiguracao = null;
    }

    public static long getModuloAcesso() {
        return ACESSO_ACESSAR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void consultarRequisicoes() {
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        SplashMensagem splash = new SplashMensagem();
        try {
            this.modeloRequisicoes.clear();
            this.requisicoes.clear();
            if (st != null) {
                splash.mostrar("Aguarde... Buscando requisi\u00e7\u00f5es.");
                ResultSet rs = Conexao.executeQuery(st, this.getSelectRequisicao());
                while (rs.next()) {
                    this.xmlConfiguracao = rs.getString("xmlConfiguracao");
                    ArrayList<Registro> exames = this.pegaExamesRequisicao(st2, rs.getString("codigoRequisicao"));
                    if (exames.size() <= 0) continue;
                    this.requisicoes.add(new Registro(rs));
                    this.modeloRequisicoes.addLine(new Object[]{rs.getString("codigoRequisicao"), rs.getString("nomePaciente"), exames});
                }
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar requisi\u00e7\u00f5es.\n" + e.getMessage(), e.getStackTrace());
        }
        finally {
            splash.apagar();
        }
    }

    private void carregarParametros() {
        if (ParametrosUsuarios.contemParametro(ULTIMO_FILTRO)) {
            String str = StringUtil.getValor(ParametrosUsuarios.getValor(ULTIMO_FILTRO), "filtro");
            this.codigoConvenio = StringUtil.getValor(str, "convenio");
            this.setAtributosFiltro(this.itemConvenio, this.codigoConvenio);
            this.textDataInicial.setText(StringUtil.getValor(str, "dataInicial"));
            this.textDataFinal.setText(StringUtil.getValor(str, "dataFinal"));
            this.textHoraInicial.setText(StringUtil.getValor(str, "horaInicial"));
            this.textHoraFinal.setText(StringUtil.getValor(str, "horaFinal"));
            this.comboData.setSelectedItem(StringUtil.getValor(str, "campoData"));
        }
        if (ParametrosUsuarios.contemParametro(POSICAO_DIVISOR)) {
            this.posicaoDivisor = Integer.parseInt(ParametrosUsuarios.getValor(POSICAO_DIVISOR));
        }
    }

    private void gravarParametros() {
        StringBuilder bui = new StringBuilder();
        bui.append(this.getAtributosFiltro(this.itemConvenio, "convenio"));
        bui.append(StringUtil.getTag("dataInicial", this.textDataInicial.getText()));
        bui.append(StringUtil.getTag("dataFinal", this.textDataFinal.getText()));
        bui.append(StringUtil.getTag("horaInicial", this.textHoraInicial.getText()));
        bui.append(StringUtil.getTag("horaFinal", this.textHoraFinal.getText()));
        bui.append(StringUtil.getTag("campoData", this.comboData.getSelectedItem().toString()));
        ParametrosUsuarios.setValor(ULTIMO_FILTRO, StringUtil.getTag("filtro", bui.toString()));
        ParametrosUsuarios.setValor(POSICAO_DIVISOR, String.valueOf(this.splitCentral.getDividerLocation()));
    }

    private void controlaCampos(boolean isEnabled) {
        this.tableRequisicoes.setEnabled(isEnabled);
        this.tableExames.setEnabled(isEnabled);
        this.itemConvenio.setEnabled(isEnabled);
        this.buttonConsultar.setEnabled(isEnabled);
        this.buttonDataFinal.setEnabled(isEnabled);
        this.buttonDataInicial.setEnabled(isEnabled);
        this.buttonExportar.setEnabled(isEnabled);
        this.textDataFinal.setEnabled(isEnabled);
        this.textDataInicial.setEnabled(isEnabled);
        this.textHoraFinal.setEnabled(isEnabled);
        this.textHoraInicial.setEnabled(isEnabled);
        this.buttonNovo.setEnabled(isEnabled);
        this.buttonFechar.setEnabled(isEnabled);
    }

    private String getSelectRequisicao() {
        StringBuilder bui = new StringBuilder();
        bui.append(" select req.req_codigo as codigoRequisicao ");
        bui.append("       ,pac.pac_nome as nomePaciente ");
        bui.append("       ,con.con_faturaeletronica as xmlConfiguracao ");
        bui.append("   from requisicao req ");
        bui.append("   join paciente pac on req.fil_codigo = pac.fil_codigo and req.pac_codigo = pac.pac_codigo ");
        bui.append("   join convenios con on req.fil_codigo = con.fil_codigo and req.con_codigo = con.con_codigo ");
        bui.append("  where req.fil_codigo = ").append(Variaveis.filialPadrao);
        bui.append("    and NOT req.req_excluida ");
        String[] convenios = this.itemConvenio.getSelecionados();
        if (convenios != null && convenios.length > 0) {
            this.codigoConvenio = convenios[0];
            bui.append("  and req.con_codigo = ").append(this.codigoConvenio);
        }
        if (Funcoes.verificaData(this.textDataInicial.getText())) {
            String horaInicial = "00:00";
            if (Funcoes.verificaHora(this.textHoraInicial.getText())) {
                horaInicial = this.textHoraInicial.getText();
            }
            if (this.comboData.getSelectedIndex() == 0) {
                bui.append("  and date_trunc('minute', req.req_data + req.req_hora) >= '").append(Funcoes.formataData("yyyy-MM-dd", this.textDataInicial.getText())).append(" ").append(horaInicial).append("' ");
            } else {
                bui.append(" and date_trunc('minute', req.req_dtfatura + req.req_horafatura) >= '").append(Funcoes.formataData("yyyy-MM-dd", this.textDataInicial.getText())).append(" ").append(horaInicial).append("' ");
            }
        }
        if (Funcoes.verificaData(this.textDataFinal.getText())) {
            String horaFinal = "23:59";
            if (Funcoes.verificaHora(this.textHoraFinal.getText())) {
                horaFinal = this.textHoraFinal.getText();
            }
            if (this.comboData.getSelectedIndex() == 0) {
                bui.append("  and date_trunc('minute', req.req_data + req.req_hora) <= '").append(Funcoes.formataData("yyyy-MM-dd", this.textDataFinal.getText())).append(" ").append(horaFinal).append("' ");
            } else {
                bui.append(" and date_trunc('minute', req.req_dtfatura + req.req_horafatura) <= '").append(Funcoes.formataData("yyyy-MM-dd", this.textDataFinal.getText())).append(" ").append(horaFinal).append("' ");
            }
        }
        bui.append("  order by req.req_codigo ");
        return bui.toString();
    }

    private ArrayList<Registro> pegaExamesRequisicao(Statement st, String requisicao) throws Exception {
        ArrayList<Registro> retorno = new ArrayList<Registro>();
        StringBuilder buf = new StringBuilder();
        buf.append(" select exr.exa_codigo ");
        buf.append("       ,mco.mco_abreviatura ");
        buf.append("       ,exa.exa_descricao ");
        buf.append("   from examerequisicao exr ");
        buf.append("   join exames exa on exr.fil_codigo = exa.fil_codigo and exr.exa_codigo = exa.exa_codigo ");
        buf.append("   join materialcoleta mco on exr.fil_codigo = mco.fil_codigo and exr.mco_codigo = mco.mco_codigo ");
        buf.append("  where exr.fil_codigo = ").append(Variaveis.filialPadrao);
        buf.append("    and exr.req_codigo = ").append(requisicao);
        buf.append("    and exr.exr_excluido = false ");
        buf.append("    and exr.exr_situacao IN ('").append("C").append("', '").append("E").append("', '");
        buf.append("I").append("') ");
        ResultSet rs = Conexao.executeQuery(st, buf);
        while (rs.next()) {
            retorno.add(new Registro(rs));
        }
        return retorno;
    }

    private String getAtributosFiltro(CheckItemFiltro item, String nome) {
        StringBuilder bui = new StringBuilder();
        bui.append(StringUtil.getTag("sel", String.valueOf(item.isSelected())));
        bui.append(StringUtil.getTag("item", item.getSelecionados(0)));
        return StringUtil.getTag(nome, bui.toString());
    }

    private void setAtributosFiltro(CheckItemFiltro item, String atributos) {
        if (StringUtil.getBoolean(atributos, "sel")) {
            item.setSelected(true);
            item.setSelecionados(StringUtil.getValores(atributos, "item"));
        }
    }

    private void excluirRequisicao() {
        int row = this.tableRequisicoes.getSelectedRow();
        if (row > -1 && Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.requisicoes.remove(row);
            this.modeloRequisicoes.removeLine(row);
        }
    }

    private void exportar() {
        SplashMensagem splashMensagem = SplashMensagem.getInstancia(Laboratorio.getInstancia());
        try {
            if (this.modeloRequisicoes.getRowCount() == 0) {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 requisi\u00e7\u00f5es para gerar exportar.", 2);
                return;
            }
            splashMensagem.mostrar("Aguarde...");
            if (Funcoes.textoVazio(this.xmlConfiguracao)) {
                Funcoes.mensagem(this, "Protocolo para o conv\u00eanio n\u00e3o est\u00e1 configurado.", 2);
                return;
            }
            String pathfileresultado = StringUtil.getValor(this.xmlConfiguracao, "pathfileresultado");
            if (Funcoes.textoVazio(pathfileresultado)) {
                Funcoes.mensagem(this, "Caminho da pasta de gera\u00e7\u00e3o do arquivos n\u00e3o est\u00e1 configurado no protocolo do conv\u00eanio.", 2);
                return;
            }
            boolean retorno = new Resuline().gerarArquivoSemFatura(this.getTopLevelAncestor(), this.getCodigosRequisicoes(), this.codigoConvenio, this.xmlConfiguracao);
            if (retorno) {
                Funcoes.mensagem(this, "Exporta\u00e7\u00e3o conclu\u00edda.", 2);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel gerar arquivo de exporta\u00e7\u00e3o de resultados.\n" + e.getMessage(), e.getStackTrace());
        }
        finally {
            splashMensagem.apagar();
        }
    }

    private String getCodigosRequisicoes() {
        String codigos = "";
        for (int i = 0; i < this.modeloRequisicoes.getRowCount(); ++i) {
            if (i > 0) {
                codigos = codigos + ",";
            }
            codigos = codigos + this.modeloRequisicoes.getValueAt(i, 0).toString();
        }
        return codigos;
    }

    @Override
    public void threadIniciada(EventObject e) {
        this.controlaCampos(false);
    }

    @Override
    public void threadFinalizada(EventObject e) {
        this.controlaCampos(true);
    }
}

