/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao;

import jalis.comum.Conexao;
import jalis.comum.ParametrosUsuarios;
import jalis.comum.Variaveis;
import jalis.laboratorio.digitacao.Resultado;
import jalis.laboratorio.exportacao.ConfiguradorResultadoNephrosysV2;
import jalis.laboratorio.exportacao.JanelaConfiguracoes;
import jalis.laboratorio.exportacao.JanelaRequisicoesErro;
import jalis.laboratorio.exportacao.texto.CampoValor;
import jalis.util.CheckItemFiltro;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.SplashMensagem;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.CorTableCellRenderer;
import jalis.util.tabela.Registro;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;

public class ExportarResultadoNephrosysV2
extends JPanel
implements ActionListener,
ListSelectionListener {
    private final int COLUNA_EXAMES = 2;
    private final Color COR_SEM_RELACIONAMENTO = new Color(255, 91, 117);
    private CheckItemFiltro itemColeta;
    private CheckItemFiltro itemConvenio;
    private CheckItemFiltro itemDestino;
    private CheckItemFiltro itemExame;
    private TTextField textDataIni = new TTextField(0, 4);
    private TTextField textDataFin = new TTextField(0, 4);
    private JLabel labelDataIni = new JLabel("Data Inicial: ");
    private JLabel labelDataFin = new JLabel("Data Final:");
    private JButton buttonDataIni = ComponenteFactory.novoJButton(this, null, new Dimension(20, 20), true);
    private JButton buttonDataFin = ComponenteFactory.novoJButton(this, null, new Dimension(20, 20), true);
    private JButton buttonConsultar = ComponenteFactory.novoJButton("Consultar", 'C', this, null, null);
    private JButton buttonNovo = ComponenteFactory.novoJButton("Novo", 'N', this, null, null);
    private JButton buttonExportar = ComponenteFactory.novoJButton("Exportar", 'E', this, null, null);
    private JButton buttonFechar = ComponenteFactory.novoJButton("Fechar", 'F', this, null, null);
    private JPanel panelRequisicoes = new JPanel(new BorderLayout());
    private JPanel panelExames = new JPanel(new BorderLayout());
    private JSplitPane splitCentral = new JSplitPane(1, this.panelRequisicoes, this.panelExames);
    private ModeloGridTable modeloRequisicoes = new ModeloGridTable(new String[]{"Requisi\u00e7\u00e3o", "Paciente"});
    private CorTableCellRenderer renderer = new CorTableCellRenderer();
    private JTable tableRequisicoes = ComponenteFactory.novoJTable((TableModel)this.modeloRequisicoes, (ListSelectionListener)this, 70, 0);
    private JScrollPane scrollRequisicoes = new JScrollPane(this.tableRequisicoes);
    private ModeloGridTable modeloExames = new ModeloGridTable(new String[]{"C\u00f3d.", "Mat.", "Exame", "Sit."});
    private JTable tableExames = ComponenteFactory.novoJTable((TableModel)this.modeloExames, null, 50, 30, 0, 30);
    private JScrollPane scrollExames = new JScrollPane(this.tableExames);
    private int status = 1;
    private boolean isCarregando = false;
    private JCheckBox checkRelacionamento;
    private JPanel panelLegenda = new JPanel(new GridBagLayout());
    private JButton buttonConfigurar = ComponenteFactory.novoJButton("Configurar", 'o', this, null, null);
    private final int COLUNA_REQUISICAO_CODIGO = 0;
    private final int COLUNA_REQUISICAO_PACIENTE = 1;
    private final int COLUNA_REQUISICAO_REGISTROS = 2;
    private final int TAMANHO_NOME_PACIENTE = 40;
    private final int TAMANHO_CODIGO_EXAME = 20;
    private final int TAMANHO_RESULTADO_EXAME = 10;
    private final int TAMANHO_PRONTUARIO = 10;
    private final int TAMANH0_VALOR_MARCADOR = 15;
    private final int TAMANHO_CPF_PACIENTE = 11;
    private final int TAMANHO_DATA_COLETA = 10;
    private int posicaoDivisor = 350;
    private String anoReferencia = null;
    private String mesReferencia = null;
    private static final String EXIBIR_EXAMES = "ExportarResultadoNephrosysV2.exibirExames";
    private static final String POSICAO_DIVISOR = "ExportarResultadoNephrosysV2.posicaoDivisor";
    private static final String ULTIMO_FILTRO = "ExportarResultadoNephrosysV2.ultimoFiltro";
    private static final String CONFIGURACAO = "ExportarResultadoNephrosysV2.configuracao";
    private ArrayList<Registro> requisicoes = new ArrayList();

    public ExportarResultadoNephrosysV2() {
        this.montaTela();
        this.tableRequisicoes.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127 && ExportarResultadoNephrosysV2.this.tableRequisicoes.getSelectedRow() > -1) {
                    ExportarResultadoNephrosysV2.this.excluirRequisicao();
                }
            }
        });
    }

    private void montaTela() {
        this.setLayout(new BorderLayout());
        Funcoes.criaBarraDescricao(this, "Exportar NephrosysV2", "Exporta\u00e7\u00e3o de resultados em arquivos para o sistema NephrosysV2", "integracao/export_result_nephrosys.jpg");
        JPanel panelPrincipal = new JPanel(new BorderLayout());
        this.add((Component)panelPrincipal, "Center");
        JPanel panelFiltro = this.montaPanelFiltro();
        JPanel panelDados = this.montaPanelDados();
        JPanel panelBotoes = this.montaPanelBotoes();
        panelPrincipal.add((Component)panelFiltro, "North");
        panelPrincipal.add((Component)panelDados, "Center");
        panelPrincipal.add((Component)panelBotoes, "South");
        Funcoes.montaEnter((JComponent)panelPrincipal);
        this.controlaCampos();
    }

    private void controlaCampos() {
        boolean enabled;
        boolean bl = enabled = this.status == 2 && !this.isCarregando;
        if (this.tableExames != null) {
            this.tableExames.setEnabled(enabled);
        }
        this.tableRequisicoes.setEnabled(enabled);
        this.itemColeta.setEnabled(enabled);
        this.itemConvenio.setEnabled(enabled);
        this.itemDestino.setEnabled(enabled);
        this.itemExame.setEnabled(enabled);
        this.checkRelacionamento.setEnabled(enabled);
        this.buttonConsultar.setEnabled(enabled);
        this.buttonDataFin.setEnabled(enabled);
        this.buttonDataIni.setEnabled(enabled);
        this.buttonNovo.setEnabled(this.status == 1 && !this.isCarregando);
        this.buttonExportar.setEnabled(enabled);
        this.buttonConfigurar.setEnabled(enabled && !this.isCarregando);
        this.buttonFechar.setEnabled(!this.isCarregando);
        this.labelDataIni.setEnabled(enabled);
        this.labelDataFin.setEnabled(enabled);
        this.textDataFin.setEnabled(enabled);
        this.textDataIni.setEnabled(enabled);
    }

    private JPanel montaPanelFiltro() {
        final JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder("Filtro"));
        Dimension dimensionFiltro = new Dimension(180, 20);
        Dimension dimensionText = new Dimension(90, 20);
        Dimension dimensionButton = new Dimension(20, 20);
        this.itemColeta = new CheckItemFiltro("Coleta", "Filtrar", "Filtrando coletas", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemColeta.setDados("coletas", new String[]{"col_codigo", "col_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemColeta.setColunaHint(1);
        this.itemColeta.setPreferredSize(dimensionFiltro);
        this.itemColeta.setMinimumSize(dimensionFiltro);
        this.itemConvenio = new CheckItemFiltro("Conv\u00eanio", "Filtrar", "Filtrando conv\u00eanios", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemConvenio.setDados("convenios", new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Fantasia"}, new int[]{70, 0});
        this.itemConvenio.setColunaHint(1);
        this.itemConvenio.setPreferredSize(dimensionFiltro);
        this.itemConvenio.setMinimumSize(dimensionFiltro);
        this.itemExame = new CheckItemFiltro("Exame", "Filtrar", "Filtrando exames", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemExame.setDados("exames", new String[]{"exa_codigo", "exa_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemExame.setColunaHint(1);
        this.itemExame.setPreferredSize(dimensionFiltro);
        this.itemExame.setMinimumSize(dimensionFiltro);
        this.itemDestino = new CheckItemFiltro("Destino", "Filtrar", "Filtrando destinos", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemDestino.setDados("destino", new String[]{"des_codigo", "des_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemDestino.setColunaHint(1);
        this.itemDestino.setPreferredSize(dimensionFiltro);
        this.itemDestino.setMinimumSize(dimensionFiltro);
        this.checkRelacionamento = ComponenteFactory.novoJCheckBox("Apenas exames com relacionamento", this);
        this.textDataIni.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    Funcoes.mostraData(ExportarResultadoNephrosysV2.this.textDataIni, ExportarResultadoNephrosysV2.this.buttonDataIni, panel, true);
                }
            }
        });
        this.textDataFin.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    Funcoes.mostraData(ExportarResultadoNephrosysV2.this.textDataFin, ExportarResultadoNephrosysV2.this.buttonDataFin, panel, true);
                }
            }
        });
        Insets insetsNormal = new Insets(0, 0, 0, 0);
        Insets insetsEsquerda = new Insets(0, 20, 0, 0);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = insetsNormal;
        c.weightx = 0.0;
        c.weighty = 0.0;
        panel.add((Component)this.itemColeta, c);
        ++c.gridx;
        c.insets = insetsEsquerda;
        panel.add((Component)this.itemDestino, c);
        ++c.gridx;
        panel.add((Component)this.labelDataIni, c);
        ++c.gridx;
        c.insets = insetsNormal;
        this.textDataIni.setPreferredSize(dimensionText);
        this.textDataIni.setMinimumSize(dimensionText);
        panel.add((Component)this.textDataIni, c);
        ++c.gridx;
        this.buttonDataIni.setPreferredSize(dimensionButton);
        this.buttonDataIni.setMinimumSize(dimensionButton);
        panel.add((Component)this.buttonDataIni, c);
        ++c.gridy;
        c.gridx = 0;
        panel.add((Component)this.itemConvenio, c);
        ++c.gridx;
        c.insets = insetsEsquerda;
        panel.add((Component)this.itemExame, c);
        ++c.gridx;
        panel.add((Component)this.labelDataFin, c);
        ++c.gridx;
        c.insets = insetsNormal;
        this.textDataFin.setPreferredSize(dimensionText);
        this.textDataFin.setMinimumSize(dimensionText);
        panel.add((Component)this.textDataFin, c);
        ++c.gridx;
        this.buttonDataFin.setPreferredSize(dimensionButton);
        this.buttonDataFin.setMinimumSize(dimensionButton);
        panel.add((Component)this.buttonDataFin, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 2;
        c.fill = 2;
        panel.add((Component)this.checkRelacionamento, c);
        c.gridx += 3;
        c.gridwidth = 3;
        c.anchor = 13;
        c.fill = 0;
        c.weightx = 1.0;
        panel.add((Component)this.buttonConsultar, c);
        return panel;
    }

    private JPanel montaPanelDados() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.splitCentral, "Center");
        this.splitCentral.setDividerLocation(this.posicaoDivisor);
        this.panelRequisicoes.setBorder(BorderFactory.createTitledBorder("Requisi\u00e7\u00f5es"));
        this.panelRequisicoes.add((Component)this.scrollRequisicoes, "Center");
        this.panelExames.setBorder(BorderFactory.createTitledBorder("Exames"));
        this.panelExames.add((Component)this.scrollExames, "Center");
        this.tableExames.setDefaultRenderer(Object.class, this.renderer);
        this.tableRequisicoes.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127 && ExportarResultadoNephrosysV2.this.tableRequisicoes.getSelectedRow() > -1) {
                    ExportarResultadoNephrosysV2.this.excluirRequisicao();
                }
            }
        });
        this.montaPanelLegenda();
        panel.add((Component)this.panelLegenda, "South");
        return panel;
    }

    private void montaPanelLegenda() {
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 2, 1, 1);
        c.weightx = 0.0;
        c.weighty = 0.0;
        JPanel pnlCorLegenda = new JPanel();
        pnlCorLegenda.setPreferredSize(new Dimension(10, 10));
        pnlCorLegenda.setBackground(this.COR_SEM_RELACIONAMENTO);
        pnlCorLegenda.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
        this.panelLegenda.add((Component)pnlCorLegenda, c);
        JLabel lblLegenda = new JLabel("Exame sem relacionamento");
        Font font = new Font(lblLegenda.getFont().getName(), 0, 10);
        lblLegenda.setFont(font);
        ++c.gridx;
        this.panelLegenda.add((Component)lblLegenda, c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        this.panelLegenda.add((Component)new JLabel(""), c);
    }

    private JPanel montaPanelBotoes() {
        JPanel panelBotoes = new JPanel(new BorderLayout());
        JPanel panelDireita = new JPanel(new FlowLayout(2));
        JPanel panelEsquerda = new JPanel(new FlowLayout(0));
        panelBotoes.add((Component)panelEsquerda, "West");
        panelBotoes.add((Component)panelDireita, "East");
        panelEsquerda.add(this.buttonConfigurar);
        panelDireita.add(this.buttonNovo);
        panelDireita.add(this.buttonExportar);
        panelDireita.add(this.buttonFechar);
        return panelBotoes;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.buttonFechar) {
            this.setVisible(false);
            if (this.getParent() != null) {
                this.getParent().removeAll();
            }
        } else if (o == this.buttonNovo) {
            this.status = 2;
            this.modeloRequisicoes.clear();
            this.modeloExames.clear();
            this.requisicoes.clear();
            this.renderer.limpar();
            this.textDataIni.setText("");
            this.textDataFin.setText("");
            this.itemColeta.clear();
            this.itemConvenio.clear();
            this.itemDestino.clear();
            this.itemExame.clear();
            this.controlaCampos();
            this.carregarParametros();
            ScreenUtil.requisitarFoco(this.textDataIni);
        } else if (o == this.buttonConsultar) {
            this.consultarRequisicoes();
            this.gravarParametros();
        } else if (o == this.buttonExportar) {
            this.exportar();
        } else if (o == this.buttonDataIni) {
            Funcoes.mostraData(this.textDataIni, this.buttonDataIni, (JPanel)this.buttonDataIni.getParent(), false);
        } else if (o == this.buttonDataFin) {
            Funcoes.mostraData(this.textDataFin, this.buttonDataFin, (JPanel)this.buttonDataFin.getParent(), false);
        } else if (e.getSource() == this.buttonConfigurar) {
            this.configurar();
        }
    }

    private void configurar() {
        JanelaConfiguracoes janela = JanelaConfiguracoes.novaInstancia((Window)this.getTopLevelAncestor(), this.anoReferencia, this.mesReferencia);
        janela.setVisible(true);
        if (janela.getOK()) {
            this.anoReferencia = janela.getAnoReferencia();
            this.mesReferencia = janela.getMesReferencia();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        try {
            this.modeloExames.clear();
            this.renderer.limpar();
            if (this.tableRequisicoes.getSelectedRow() > -1 && this.modeloRequisicoes.getValueAt(this.tableRequisicoes.getSelectedRow(), 2) != null && this.modeloRequisicoes.getValueAt(this.tableRequisicoes.getSelectedRow(), 2) instanceof ArrayList) {
                ArrayList exames = (ArrayList)this.modeloRequisicoes.getValueAt(this.tableRequisicoes.getSelectedRow(), 2);
                int i = 0;
                for (Registro r : exames) {
                    if (Funcoes.textoVazio(r.getString("xml"))) {
                        this.renderer.setCorLinha(this.COR_SEM_RELACIONAMENTO, i);
                    }
                    ++i;
                    this.modeloExames.addLine(new Object[]{r.getString("exa_codigo"), r.getString("mco_abreviatura"), r.getString("exa_descricao"), r.getString("exr_situacao"), r.getBoolean("enviado")});
                }
            }
        }
        catch (Exception e1) {
            ErrorLogger.mostraMensagem(this, e1.getMessage(), e1.getStackTrace(), "ExportarResultadoNephrosysV2: 315");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void consultarRequisicoes() {
        String SQL = "";
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        SplashMensagem spl = SplashMensagem.getInstancia(this);
        HashSet<String> examesSemRelacionamento = new HashSet<String>();
        try {
            this.modeloRequisicoes.clear();
            this.requisicoes.clear();
            this.habilitarDesabilitar(false);
            if (st != null) {
                ResultSet rs = Conexao.executeQuery(st, this.getSelectRequisicao());
                while (rs.next()) {
                    ArrayList<Registro> exames = this.pegaExamesRequisicao(st2, rs.getString("req_codigo"));
                    ArrayList<Registro> examesRel = new ArrayList<Registro>();
                    for (Registro re : exames) {
                        String xmlResultado = this.getXmlResultado(st2, rs.getString("req_codigo"), re.getString("exa_codigo"), re.getInt("mco_codigo"));
                        String xml = ExameUtil.pegaRelacionamentoExportaTextoIdade(Variaveis.filialPadrao, rs.getInt("req_idade"), rs.getString("req_anomes"), ExameUtil.getCodigoLayout(Variaveis.filialPadrao, rs.getString("con_codigo"), rs.getString("des_codigo")), re.getString("exa_codigo"), re.getInt("mco_codigo"), re.getString("met_codigo"));
                        re.setValor("xmlResultado", xmlResultado);
                        re.setValor("xml", xml);
                        if (Funcoes.textoVazio(xml)) {
                            examesSemRelacionamento.add(re.getString("exa_codigo"));
                        }
                        if (!this.checkRelacionamento.isSelected()) {
                            examesRel.add(re);
                            continue;
                        }
                        if (Funcoes.textoVazio(xml) && !xml.contains("exportarnephrosys2")) continue;
                        examesRel.add(re);
                    }
                    if (examesRel.size() <= 0) continue;
                    this.requisicoes.add(new Registro(rs));
                    this.modeloRequisicoes.addLine(new Object[]{rs.getString("req_codigo"), rs.getString("pac_nome"), examesRel});
                }
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage() + "\nSQL: " + SQL, e.getStackTrace(), "ExportarResultadoNephrosysV2: 333");
        }
        finally {
            this.habilitarDesabilitar(true);
            this.buttonNovo.setEnabled(false);
            spl.apagar();
        }
        if (!examesSemRelacionamento.isEmpty() && !this.checkRelacionamento.isSelected()) {
            String exames = "";
            for (String exa : examesSemRelacionamento) {
                exames = exames + exa + ", ";
            }
            Funcoes.mensagem(this, "Os seguintes exames n\u00e3o possuem relacionamento: \n" + exames.substring(0, exames.length() - 2), 2);
        }
    }

    private void carregarParametros() {
        if (ParametrosUsuarios.contemParametro(ULTIMO_FILTRO)) {
            String str = StringUtil.getValor(ParametrosUsuarios.getValor(ULTIMO_FILTRO), "filtro");
            this.setAtributosFiltro(this.itemColeta, StringUtil.getValor(str, "coleta"));
            this.setAtributosFiltro(this.itemConvenio, StringUtil.getValor(str, "convenio"));
            this.setAtributosFiltro(this.itemDestino, StringUtil.getValor(str, "destino"));
            this.setAtributosFiltro(this.itemExame, StringUtil.getValor(str, "exame"));
            this.textDataIni.setText(StringUtil.getValor(str, "dataInicial"));
            this.textDataFin.setText(StringUtil.getValor(str, "dataFinal"));
        }
        if (ParametrosUsuarios.contemParametro(CONFIGURACAO)) {
            String parametros = StringUtil.getValor(ParametrosUsuarios.getValor(CONFIGURACAO), "configuracao");
            this.anoReferencia = StringUtil.getValor(parametros, "ano");
            this.mesReferencia = StringUtil.getValor(parametros, "mes");
        }
        if (ParametrosUsuarios.contemParametro(POSICAO_DIVISOR)) {
            this.posicaoDivisor = Integer.parseInt(ParametrosUsuarios.getValor(POSICAO_DIVISOR));
        }
    }

    private void gravarParametros() {
        XMLStringBuilder xmlFiltros = new XMLStringBuilder();
        xmlFiltros.abrir("filtro");
        xmlFiltros.escrever("coleta", this.getXMLItensSelecionados(this.itemColeta));
        xmlFiltros.escrever("convenio", this.getXMLItensSelecionados(this.itemConvenio));
        xmlFiltros.escrever("destino", this.getXMLItensSelecionados(this.itemDestino));
        xmlFiltros.escrever("exame", this.getXMLItensSelecionados(this.itemExame));
        xmlFiltros.escrever("dataInicial", this.textDataIni.getText());
        xmlFiltros.escrever("dataFinal", this.textDataFin.getText());
        try {
            xmlFiltros.fechar("filtro");
        }
        catch (XMLStringBuilderException e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel montar xml dos par\u00e2metros de usu\u00e1rio.\n" + e.getMessage(), e.getStackTrace());
        }
        XMLStringBuilder xmlConfiguracao = new XMLStringBuilder();
        xmlConfiguracao.abrir("configuracao");
        xmlConfiguracao.escrever("ano", this.anoReferencia);
        xmlConfiguracao.escrever("mes", this.mesReferencia);
        try {
            xmlConfiguracao.fechar("configuracao");
        }
        catch (XMLStringBuilderException e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel montar xml da configura\u00e7\u00e3o.\n" + e.getMessage(), e.getStackTrace());
        }
        ParametrosUsuarios.setValor(ULTIMO_FILTRO, xmlFiltros.getXML());
        ParametrosUsuarios.setValor(CONFIGURACAO, xmlConfiguracao.getXML());
        ParametrosUsuarios.setValor(POSICAO_DIVISOR, String.valueOf(this.splitCentral.getDividerLocation()));
    }

    private String getXMLItensSelecionados(CheckItemFiltro item) {
        XMLStringBuilder xml = new XMLStringBuilder();
        xml.escrever("sel", String.valueOf(item.isSelected()));
        String[] selecionados = item.getSelecionados(0);
        if (selecionados != null) {
            for (String selecionado : selecionados) {
                xml.escrever("item", selecionado.toString());
            }
        }
        return xml.getXML();
    }

    private void habilitarDesabilitar(boolean valor) {
        this.tableRequisicoes.setEnabled(valor);
        if (this.tableExames != null) {
            this.tableExames.setEnabled(valor);
        }
        this.itemColeta.setEnabled(valor);
        this.itemConvenio.setEnabled(valor);
        this.itemDestino.setEnabled(valor);
        this.itemExame.setEnabled(valor);
        this.checkRelacionamento.setEnabled(valor);
        this.buttonConsultar.setEnabled(valor);
        this.buttonDataFin.setEnabled(valor);
        this.buttonDataIni.setEnabled(valor);
        this.buttonNovo.setEnabled(valor);
        this.buttonExportar.setEnabled(valor);
        this.buttonFechar.setEnabled(valor);
        this.labelDataIni.setEnabled(valor);
        this.labelDataFin.setEnabled(valor);
        this.textDataFin.setEnabled(valor);
        this.textDataIni.setEnabled(valor);
    }

    private String getSelectRequisicao() {
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        StringBuilder bui = new StringBuilder("select distinct ");
        try {
            bui.append("  a.req_codigo, a.req_data, g.pac_codigo, g.pac_nome, a.con_codigo, a.req_idade, a.req_anomes, a.des_codigo, g.pac_cpf, g.pac_tipopessoa, ");
            bui.append("  a.req_matricula, a.req_prontuario ");
            bui.append("from requisicao a ");
            bui.append("left join examerequisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo ");
            bui.append("left join paciente g on a.fil_codigo = g.fil_codigo and a.pac_codigo = g.pac_codigo ");
            bui.append("where a.fil_codigo = ").append(Variaveis.filialPadrao);
            bui.append(" and a.req_excluida = false ");
            if (Funcoes.verificaData(this.textDataIni.getText())) {
                if (bui.length() > 0) {
                    bui.append(" and ");
                }
                bui.append(" a.req_data >= '");
                bui.append(Funcoes.formataData("MM/dd/yyyy", sdf.parse(this.textDataIni.getText())));
                bui.append("' ");
            }
            if (Funcoes.verificaData(this.textDataFin.getText())) {
                if (bui.length() > 0) {
                    bui.append(" and ");
                }
                bui.append("a.req_data <= '");
                bui.append(Funcoes.formataData("MM/dd/yyyy", sdf.parse(this.textDataFin.getText())));
                bui.append("' ");
            }
            if (this.itemColeta.isSelected()) {
                this.addExpressao(bui, ExportarResultadoNephrosysV2.getExpressao("a.col_codigo", this.itemColeta.getSelecionados(0), true));
            }
            if (this.itemConvenio.isSelected()) {
                this.addExpressao(bui, ExportarResultadoNephrosysV2.getExpressao("a.con_codigo", this.itemConvenio.getSelecionados(0), false));
            }
            if (this.itemDestino.isSelected()) {
                this.addExpressao(bui, ExportarResultadoNephrosysV2.getExpressao("a.des_codigo", this.itemDestino.getSelecionados(0), true));
            }
            if (this.itemExame.isSelected()) {
                this.addExpressao(bui, ExportarResultadoNephrosysV2.getExpressao("b.exa_codigo", this.itemExame.getSelecionados(0), true));
            }
            bui.append(" order by g.pac_nome ");
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ExportarResultadoNephrosysV2: 455");
        }
        return bui.toString();
    }

    private ArrayList<Registro> pegaExamesRequisicao(Statement st, String requisicao) throws Exception {
        ArrayList<Registro> retorno = new ArrayList<Registro>();
        StringBuilder buf = new StringBuilder("select a.exa_codigo, a.mco_codigo, b.mco_abreviatura, ");
        buf.append(" a.met_codigo, c.exa_descricao, a.met_codigo, a.exr_datadigita, a.exr_situacao, a.exr_datamaterial ");
        buf.append("from examerequisicao a ");
        buf.append("left join materialcoleta b on a.fil_codigo = b.fil_codigo and a.mco_codigo = b.mco_codigo ");
        buf.append("left join exames c on a.fil_codigo = c.fil_codigo and a.exa_codigo = c.exa_codigo ");
        buf.append("where a.fil_codigo = ").append(Variaveis.filialPadrao);
        buf.append(" and a.req_codigo = ").append(requisicao);
        buf.append(" and a.exr_excluido = false ");
        if (this.itemExame.isSelected()) {
            this.addExpressao(buf, ExportarResultadoNephrosysV2.getExpressao("a.exa_codigo", this.itemExame.getSelecionados(0), true));
        }
        ResultSet rs = Conexao.executeQuery(st, buf);
        while (rs.next()) {
            retorno.add(new Registro(rs));
        }
        return retorno;
    }

    private void addExpressao(StringBuilder bui, String exp) {
        if (exp != null && exp.length() > 0) {
            if (bui.length() > 0) {
                bui.append("and ");
            }
            bui.append(exp);
            bui.append(' ');
        }
    }

    private String getAtributosFiltro(CheckItemFiltro item, String nome) {
        StringBuilder bui = new StringBuilder();
        bui.append(StringUtil.getTag("sel", String.valueOf(item.isSelected())));
        bui.append(StringUtil.getTag("item", item.getSelecionados(0)));
        return StringUtil.getTag(nome, bui.toString());
    }

    private void setAtributosFiltro(CheckItemFiltro item, String atributos) {
        if (StringUtil.getBoolean(atributos, "sel")) {
            item.setSelected(true);
            item.setSelecionados(StringUtil.getValores(atributos, "item"));
        }
    }

    private void excluirRequisicao() {
        if (Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.requisicoes.remove(this.tableRequisicoes.getSelectedRow());
            this.modeloRequisicoes.removeLine(this.tableRequisicoes.getSelectedRow());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportar() {
        if (Funcoes.textoVazio(this.textDataIni) || Funcoes.textoVazio(this.textDataFin)) {
            Funcoes.mensagem(this, "As datas devem ser configuradas.", 2);
            return;
        }
        if (Funcoes.textoVazio(this.anoReferencia) || Funcoes.textoVazio(this.mesReferencia)) {
            Funcoes.mensagem(this, "O m\u00eas e ano de refer\u00eancia devem ser configurados.", 2);
            return;
        }
        if (this.requisicoes != null && this.requisicoes.size() > 0) {
            ArrayList<String> requisicoesErro = new ArrayList<String>();
            StringBuilder conteudo = new StringBuilder();
            SplashMensagem splash = SplashMensagem.getInstancia(this);
            try {
                splash.mostrar("Gerando arquivo de resultados. Aguarde...");
                for (int iReq = 0; iReq < this.requisicoes.size(); ++iReq) {
                    Registro r = this.requisicoes.get(iReq);
                    String requisicao = r.getString("req_codigo");
                    ArrayList exames = (ArrayList)this.modeloRequisicoes.getValueAt(iReq, 2);
                    for (Registro re : exames) {
                        String prontuario;
                        String xml = re.getString("xml");
                        String xmlResultado = re.getString("xmlResultado");
                        String nomePaciente = r.getString("pac_nome");
                        if ((nomePaciente = StringUtil.removerAcentos(nomePaciente)).trim().length() > 40) {
                            nomePaciente = nomePaciente.trim().substring(0, 40);
                        }
                        if (!Funcoes.isNumeric(prontuario = r.getString("req_prontuario"))) {
                            Funcoes.mensagem(this, "O n\u00famero do prontu\u00e1rio \u00e9 inv\u00e1lido: \"" + prontuario + "\" - Paciente: \"" + nomePaciente + "\".", 2);
                            continue;
                        }
                        if (Long.parseLong(prontuario) == 0L) {
                            Funcoes.mensagem(this, "O n\u00famero do prontu\u00e1rio est\u00e1 zerado - Paciente: \"" + nomePaciente + "\".", 2);
                            continue;
                        }
                        if (prontuario.length() > 10) {
                            prontuario = prontuario.substring(0, 10);
                        }
                        String cpf = r.getString("pac_cpf");
                        if ((cpf = StringUtil.limpaString(cpf, new String[]{"/", ".", "-"})).length() > 11) {
                            cpf = cpf.substring(0, 11);
                        }
                        String dataColeta = null;
                        try {
                            dataColeta = Funcoes.formataData("dd/MM/yyyy", re.getDate("exr_datamaterial"));
                        }
                        catch (ParseException parseException) {
                            // empty catch block
                        }
                        if (Funcoes.textoVazio(xmlResultado)) {
                            requisicoesErro.add(Funcoes.preencheVazio(requisicao, 8, 1) + "\t" + re.getString("exa_codigo") + " - " + re.getString("exa_descricao") + " - REQUISI\u00c7\u00c3O SEM RESULTADO");
                            continue;
                        }
                        Map<String, Object> h = Resultado.getCamposResultado(xmlResultado, false);
                        Hashtable<String, CampoValor> hash = ConfiguradorResultadoNephrosysV2.getRelacionamentoCampos(xml);
                        for (String s : hash.keySet()) {
                            String valorExame;
                            if (h.get(s.toLowerCase()) == null) {
                                requisicoesErro.add(Funcoes.preencheVazio(requisicao, 8, 1) + "\t" + re.getString("exa_codigo") + " - " + re.getString("exa_descricao") + " - CAMPO \"" + s.toLowerCase() + "\" N\u00c3O LOCALIZADO");
                                continue;
                            }
                            CampoValor exameExportado = hash.get(s);
                            String codigoExame = exameExportado.getValor();
                            if (Funcoes.textoVazio(codigoExame)) {
                                codigoExame = "";
                            }
                            if (codigoExame.length() > 20) {
                                codigoExame = codigoExame.substring(0, 20);
                            }
                            if (Funcoes.textoVazio(valorExame = h.get(s.toLowerCase()).toString())) {
                                requisicoesErro.add(Funcoes.preencheVazio(requisicao, 8, 1) + "\t" + re.getString("exa_codigo") + "-" + re.getString("exa_descricao") + " - RESULTADO VAZIO.");
                                continue;
                            }
                            valorExame = valorExame.toLowerCase();
                            if (!Funcoes.isNumeric(valorExame = valorExame.trim())) {
                                String valorAux = valorExame;
                                if (Funcoes.textoVazio(valorExame)) {
                                    requisicoesErro.add(Funcoes.preencheVazio(requisicao, 8, 1) + "\t" + re.getString("exa_codigo") + "-" + re.getString("exa_descricao") + " - VALOR INV\u00c1LIDO \"" + valorAux + "\"");
                                    continue;
                                }
                                if (valorExame.trim().length() > 10) {
                                    valorExame = valorExame.trim().substring(0, 10);
                                }
                            }
                            if (valorExame != null && valorExame.trim().length() > 10) {
                                valorExame = valorExame.trim().substring(0, 10);
                            }
                            conteudo.append(Funcoes.preencheVazio(nomePaciente, 40, 2));
                            conteudo.append(Funcoes.preencheVazio(codigoExame, 20, 2));
                            conteudo.append(Funcoes.preencheVazio(dataColeta == null ? "" : dataColeta, 10, 2));
                            conteudo.append(Funcoes.preencheZero(valorExame, 10));
                            conteudo.append(Funcoes.preencheZero(prontuario, 10));
                            conteudo.append(Funcoes.preencheZero(cpf, 11));
                            conteudo.append("\n");
                        }
                    }
                }
            }
            finally {
                splash.apagar();
            }
            if (conteudo.length() > 0) {
                JFileChooser file = ComponenteFactory.novoJFileChooser("Selecione a pasta onde o arquivo ser\u00e1 gerado");
                file.setFileSelectionMode(1);
                if (file.showSaveDialog(this) == 0) {
                    String arquivo = file.getSelectedFile().getAbsolutePath();
                    if (!arquivo.toUpperCase().endsWith(".TXT")) {
                        arquivo = arquivo + System.getProperty("file.separator") + "EX" + this.anoReferencia + this.mesReferencia + ".TXT";
                    }
                    try {
                        StringUtil.escreverArquivoTexto(arquivo, conteudo.toString());
                        Funcoes.mensagem(this, "Exporta\u00e7\u00e3o realizada com sucesso.\nArquivo: " + arquivo, 5);
                    }
                    catch (Exception e) {
                        Funcoes.mensagem(null, "N\u00e3o foi poss\u00edvel exportar os resultados para o arquivo.\nMensagem: " + e.getMessage(), 1);
                    }
                }
                if (requisicoesErro.size() > 0) {
                    JanelaRequisicoesErro janela = JanelaRequisicoesErro.novaInstancia((Window)this.getTopLevelAncestor());
                    janela.setLocationRelativeTo(this.getTopLevelAncestor());
                    janela.setRequisicoes(requisicoesErro);
                    janela.setVisible(true);
                }
            } else {
                Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel realizar a exporta\u00e7\u00e3o.", 5);
            }
        }
        this.gravarParametros();
    }

    private String getXmlResultado(Statement st, String requisicao, String exame, int materialColetado) {
        try {
            StringBuilder buf = new StringBuilder("select pegaResultadoExame(fil_codigo, req_codigo, exa_codigo, mco_codigo) as exr_resultado ");
            buf.append("from examerequisicao ");
            buf.append("where fil_codigo = ").append(Variaveis.filialPadrao);
            buf.append(" and req_codigo = ").append(requisicao);
            buf.append(" and exa_codigo = '").append(exame).append("'");
            buf.append(" and mco_codigo = ").append(materialColetado);
            buf.append(" and exr_excluido = false ");
            ResultSet rs = Conexao.executeQuery(st, buf);
            if (rs.next()) {
                return rs.getString("exr_resultado");
            }
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ExportarResultadoNephrosysV2: 581");
        }
        return "";
    }

    public void pressioneiF2() {
        if (this.textDataIni.hasFocus()) {
            Funcoes.mostraData(this.textDataIni, this.buttonDataIni, this, true);
        } else if (this.textDataFin.hasFocus()) {
            Funcoes.mostraData(this.textDataFin, this.buttonDataFin, this, true);
        }
    }

    public static String getExpressao(String campo, String[] valores, boolean aspas) {
        if (campo != null && valores != null && valores.length > 0) {
            StringBuilder buf = new StringBuilder("(");
            for (int i = 0; i < valores.length; ++i) {
                if (i > 0) {
                    buf.append(" or ");
                }
                buf.append(campo);
                buf.append(" = ");
                if (aspas) {
                    buf.append('\'');
                }
                buf.append(valores[i]);
                if (!aspas) continue;
                buf.append('\'');
            }
            return buf.append(")").toString();
        }
        return "";
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0910001600");
    }
}

