/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosUsuarios;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.laboratorio.digitacao.Resultado;
import jalis.util.CheckItemFiltro;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.SplashMensagem;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import jalis.util.xml.XMLStringBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableModel;

public class ExportarResultadoClinica
extends JPanel
implements ActionListener,
ListSelectionListener {
    private static final long ACESSO = Long.parseLong("0910000201");
    private final int COLUNA_EXAMES = 2;
    private CheckItemFiltro itemColeta;
    private CheckItemFiltro itemConvenio;
    private CheckItemFiltro itemDestino;
    private CheckItemFiltro itemExame;
    private TTextField textDataIni = new TTextField(0, 4);
    private TTextField textDataFin = new TTextField(0, 4);
    private JLabel labelDataIni = new JLabel("Data Inicial:");
    private JLabel labelDataFin = new JLabel("Data Final:");
    private JButton buttonDataIni = ComponenteFactory.novoJButton(this, null, new Dimension(20, 20), true);
    private JButton buttonDataFin = ComponenteFactory.novoJButton(this, null, new Dimension(20, 20), true);
    private JButton buttonConsultar = ComponenteFactory.novoJButton("Consultar", 'C', this, null, null);
    private JButton buttonNovo = ComponenteFactory.novoJButton("Novo", 'N', this, null, null);
    private JButton buttonExportar = ComponenteFactory.novoJButton("Exportar", 'E', this, null, null);
    private JButton buttonFechar = ComponenteFactory.novoJButton("Fechar", 'F', this, null, null);
    private JPanel panelRequisicoes = new JPanel(new BorderLayout());
    private JPanel panelExames = new JPanel(new BorderLayout());
    private JSplitPane splitCentral = new JSplitPane(1, this.panelRequisicoes, this.panelExames);
    private ModeloGridTable modeloRequisicoes = new ModeloGridTable(new String[]{"Requisi\u00e7\u00e3o", "Paciente"});
    private JTable tableRequisicoes = ComponenteFactory.novoJTable((TableModel)this.modeloRequisicoes, (ListSelectionListener)this, 70, 0);
    private JScrollPane scrollRequisicoes = new JScrollPane(this.tableRequisicoes);
    private ModeloGridTable modeloExames = new ModeloGridTable(new String[]{"C\u00f3d.", "Mat.", "Exame", "Sit."});
    private JTable tableExames = ComponenteFactory.novoJTable((TableModel)this.modeloExames, null, 50, 30, 0, 20);
    private JScrollPane scrollExames = new JScrollPane(this.tableExames);
    private int posicaoDivisor = 350;
    private static final String EXIBIR_EXAMES = "ExportarResultadoClinica.exibirExames";
    private static final String POSICAO_DIVISOR = "ExportarResultadoClinica.posicaoDivisor";
    private static final String ULTIMO_FILTRO = "ExportarResultadoClinica.ultimoFiltro";
    private ArrayList<Registro> requisicoes = new ArrayList();

    public ExportarResultadoClinica() {
        this.montaTela();
        this.tableRequisicoes.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127 && ExportarResultadoClinica.this.tableRequisicoes.getSelectedRow() > -1) {
                    ExportarResultadoClinica.this.excluirRequisicao();
                }
            }
        });
    }

    private void montaTela() {
        this.setLayout(new BorderLayout());
        Funcoes.criaBarraDescricao(this, "Exportar Cl\u00ednica", "Exporta\u00e7\u00e3o de resultados em arquivos utilizando formato HTML", "integracao/export_result_clinica.jpg");
        Dimension dimensionFiltro = new Dimension(180, 20);
        Dimension dimensionText = new Dimension(90, 20);
        Dimension dimensionButton = new Dimension(20, 20);
        JPanel panelAux = new JPanel();
        panelAux.setLayout(new BorderLayout());
        this.add((Component)panelAux, "Center");
        JPanel panel = new JPanel();
        panelAux.add((Component)panel, "North");
        panel.setBorder(BorderFactory.createTitledBorder("Filtro"));
        panel.setLayout(new GridBagLayout());
        this.itemColeta = new CheckItemFiltro("Coleta", "Filtrar", "Filtrando coletas", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemColeta.setDados("coletas", new String[]{"col_codigo", "col_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemColeta.setColunaHint(1);
        this.itemColeta.setPreferredSize(dimensionFiltro);
        this.itemColeta.setMinimumSize(dimensionFiltro);
        this.itemConvenio = new CheckItemFiltro("Conv\u00eanio", "Filtrar", "Filtrando conv\u00eanios", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemConvenio.setDados("convenios", new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Fantasia"}, new int[]{70, 0});
        this.itemConvenio.setColunaHint(1);
        this.itemConvenio.setPreferredSize(dimensionFiltro);
        this.itemConvenio.setMinimumSize(dimensionFiltro);
        this.itemExame = new CheckItemFiltro("Exame", "Filtrar", "Filtrando exames", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemExame.setDados("exames", new String[]{"exa_codigo", "exa_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemExame.setColunaHint(1);
        this.itemExame.setPreferredSize(dimensionFiltro);
        this.itemExame.setMinimumSize(dimensionFiltro);
        this.itemDestino = new CheckItemFiltro("Destino", "Filtrar", "Filtrando destinos", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemDestino.setDados("destino", new String[]{"des_codigo", "des_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemDestino.setColunaHint(1);
        this.itemDestino.setPreferredSize(dimensionFiltro);
        this.itemDestino.setMinimumSize(dimensionFiltro);
        Insets insetsNormal = new Insets(0, 0, 0, 0);
        Insets insetsEsquerda = new Insets(0, 20, 0, 0);
        GridBagConstraints cons = new GridBagConstraints();
        cons.anchor = 17;
        cons.fill = 0;
        cons.gridheight = 1;
        cons.gridwidth = 1;
        cons.gridx = 0;
        cons.gridy = 0;
        cons.insets = insetsNormal;
        cons.weightx = 0.0;
        cons.weighty = 0.0;
        panel.add((Component)this.itemColeta, cons);
        ++cons.gridx;
        cons.insets = insetsEsquerda;
        panel.add((Component)this.itemDestino, cons);
        ++cons.gridx;
        panel.add((Component)this.labelDataIni, cons);
        ++cons.gridx;
        cons.insets = insetsNormal;
        this.textDataIni.setPreferredSize(dimensionText);
        this.textDataIni.setMinimumSize(dimensionText);
        panel.add((Component)this.textDataIni, cons);
        ++cons.gridx;
        this.buttonDataIni.setPreferredSize(dimensionButton);
        this.buttonDataIni.setMinimumSize(dimensionButton);
        panel.add((Component)this.buttonDataIni, cons);
        ++cons.gridy;
        cons.gridx = 0;
        panel.add((Component)this.itemConvenio, cons);
        ++cons.gridx;
        cons.insets = insetsEsquerda;
        panel.add((Component)this.itemExame, cons);
        ++cons.gridx;
        panel.add((Component)this.labelDataFin, cons);
        ++cons.gridx;
        cons.insets = insetsNormal;
        this.textDataFin.setPreferredSize(dimensionText);
        this.textDataFin.setMinimumSize(dimensionText);
        panel.add((Component)this.textDataFin, cons);
        ++cons.gridx;
        this.buttonDataFin.setPreferredSize(dimensionButton);
        this.buttonDataFin.setMinimumSize(dimensionButton);
        panel.add((Component)this.buttonDataFin, cons);
        ++cons.gridy;
        cons.gridx = 3;
        cons.gridwidth = 3;
        cons.anchor = 13;
        cons.weightx = 1.0;
        panel.add((Component)this.buttonConsultar, cons);
        panelAux.add((Component)this.splitCentral, "Center");
        this.splitCentral.setBorder(null);
        this.splitCentral.setDividerSize(3);
        this.splitCentral.setDividerLocation(this.posicaoDivisor);
        panelAux = new JPanel(new FlowLayout(2, 3, 3));
        this.add((Component)ComponenteFactory.novoJPanelBorderLayout(panelAux, null, null, null, null), "South");
        panelAux.add(this.buttonNovo);
        panelAux.add(this.buttonExportar);
        panelAux.add(this.buttonFechar);
        this.panelRequisicoes.setBorder(BorderFactory.createTitledBorder("Requisi\u00e7\u00f5es"));
        this.panelRequisicoes.add((Component)this.scrollRequisicoes, "Center");
        this.panelExames.setBorder(BorderFactory.createTitledBorder("Exames"));
        this.panelExames.add((Component)this.scrollExames, "Center");
        this.tableRequisicoes.getColumnModel().getColumn(0).setMinWidth(70);
        this.textDataIni.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    ExportarResultadoClinica.this.buttonDataIni.doClick();
                }
            }
        });
        this.textDataFin.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    ExportarResultadoClinica.this.buttonDataFin.doClick();
                }
            }
        });
        this.carregarParametros();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.buttonFechar) {
            this.setVisible(false);
            if (this.getParent() != null) {
                this.getParent().removeAll();
            }
        } else if (o == this.buttonNovo) {
            this.modeloRequisicoes.clear();
            this.modeloExames.clear();
            this.requisicoes.clear();
            this.textDataIni.setText("");
            this.textDataFin.setText("");
            this.itemColeta.clear();
            this.itemConvenio.clear();
            this.itemDestino.clear();
            this.itemExame.clear();
        } else if (o == this.buttonConsultar) {
            this.consultarRequisicoes();
            this.gravarParametros();
        } else if (o == this.buttonExportar) {
            try {
                this.exportar();
            }
            catch (ParseException e1) {
                ErrorLogger.mostraMensagem(this, e1.getMessage(), e1.getStackTrace(), "ExportarResultadoClinica: 278");
            }
        } else if (o == this.buttonDataIni) {
            Funcoes.mostraData(this.textDataIni, this.buttonDataIni, (JPanel)this.buttonDataIni.getParent(), false);
        } else if (o == this.buttonDataFin) {
            Funcoes.mostraData(this.textDataFin, this.buttonDataFin, (JPanel)this.buttonDataFin.getParent(), false);
        }
    }

    public static long getModuloAcesso() {
        return ACESSO;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        try {
            this.modeloExames.clear();
            if (this.tableRequisicoes.getSelectedRow() > -1 && this.modeloRequisicoes.getValueAt(this.tableRequisicoes.getSelectedRow(), 2) != null && this.modeloRequisicoes.getValueAt(this.tableRequisicoes.getSelectedRow(), 2) instanceof ArrayList) {
                ArrayList exames = (ArrayList)this.modeloRequisicoes.getValueAt(this.tableRequisicoes.getSelectedRow(), 2);
                for (Registro r : exames) {
                    this.modeloExames.addLine(new Object[]{r.getString("exa_codigo"), r.getString("mco_abreviatura"), r.getString("exa_descricao"), r.getString("exr_situacao"), r.getBoolean("enviado")});
                }
            }
        }
        catch (Exception e1) {
            ErrorLogger.mostraMensagem(this, e1.getMessage(), e1.getStackTrace(), "ExportarResultadoClinica: 315");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void consultarRequisicoes() {
        String SQL = "";
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        SplashMensagem spl = SplashMensagem.getInstancia(this);
        try {
            this.modeloRequisicoes.clear();
            this.requisicoes.clear();
            this.habilitarDesabilitar(false);
            if (st != null) {
                ResultSet rs = Conexao.executeQuery(st, this.getSelectRequisicao());
                while (rs.next()) {
                    ArrayList<Registro> exames = this.pegaExamesRequisicao(st2, rs.getString("req_codigo"));
                    ArrayList<Registro> examesRel = new ArrayList<Registro>();
                    for (Registro re : exames) {
                        String xmlResultado = this.getXmlResultado(st2, rs.getString("req_codigo"), re.getString("exa_codigo"), re.getInt("mco_codigo"));
                        re.setValor("xmlResultado", xmlResultado);
                        examesRel.add(re);
                    }
                    if (examesRel.size() <= 0) continue;
                    Registro r = new Registro(rs);
                    r.setValor("exames", examesRel);
                    this.requisicoes.add(r);
                    this.modeloRequisicoes.addLine(new Object[]{rs.getString("req_codigo"), rs.getString("pac_nome"), examesRel});
                }
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage() + "\nSQL: " + SQL, e.getStackTrace(), "ExportarResultadoClinica: 333");
        }
        finally {
            this.habilitarDesabilitar(true);
            spl.apagar();
        }
    }

    private void carregarParametros() {
        if (ParametrosUsuarios.contemParametro(ULTIMO_FILTRO)) {
            String str = StringUtil.getValor(ParametrosUsuarios.getValor(ULTIMO_FILTRO), "filtro");
            this.setAtributosFiltro(this.itemColeta, StringUtil.getValor(str, "coleta"));
            this.setAtributosFiltro(this.itemConvenio, StringUtil.getValor(str, "convenio"));
            this.setAtributosFiltro(this.itemDestino, StringUtil.getValor(str, "destino"));
            this.setAtributosFiltro(this.itemExame, StringUtil.getValor(str, "exame"));
            this.textDataIni.setText(StringUtil.getValor(str, "dataInicial"));
            this.textDataFin.setText(StringUtil.getValor(str, "dataFinal"));
        }
        if (ParametrosUsuarios.contemParametro(POSICAO_DIVISOR)) {
            this.posicaoDivisor = Integer.parseInt(ParametrosUsuarios.getValor(POSICAO_DIVISOR));
        }
    }

    private void gravarParametros() {
        StringBuilder bui = new StringBuilder();
        bui.append(this.getAtributosFiltro(this.itemColeta, "coleta"));
        bui.append(this.getAtributosFiltro(this.itemConvenio, "convenio"));
        bui.append(this.getAtributosFiltro(this.itemDestino, "destino"));
        bui.append(this.getAtributosFiltro(this.itemExame, "exame"));
        bui.append(StringUtil.getTag("dataInicial", this.textDataIni.getText()));
        bui.append(StringUtil.getTag("dataFinal", this.textDataFin.getText()));
        ParametrosUsuarios.setValor(ULTIMO_FILTRO, StringUtil.getTag("filtro", bui.toString()));
        ParametrosUsuarios.setValor(POSICAO_DIVISOR, String.valueOf(this.splitCentral.getDividerLocation()));
    }

    private void habilitarDesabilitar(boolean valor) {
        this.tableRequisicoes.setEnabled(valor);
        if (this.tableExames != null) {
            this.tableExames.setEnabled(valor);
        }
        this.itemColeta.setEnabled(valor);
        this.itemConvenio.setEnabled(valor);
        this.itemDestino.setEnabled(valor);
        this.itemExame.setEnabled(valor);
        this.buttonConsultar.setEnabled(valor);
        this.buttonDataFin.setEnabled(valor);
        this.buttonDataIni.setEnabled(valor);
        this.buttonNovo.setEnabled(valor);
        this.buttonExportar.setEnabled(valor);
        this.buttonFechar.setEnabled(valor);
        this.labelDataIni.setEnabled(valor);
        this.labelDataFin.setEnabled(valor);
        this.textDataFin.setEnabled(valor);
        this.textDataIni.setEnabled(valor);
    }

    private String getSelectRequisicao() {
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        StringBuilder bui = new StringBuilder("select distinct ");
        try {
            bui.append("  a.req_codigo, a.req_data, g.pac_codigo, g.pac_nome, g.pac_datanasc, a.req_idade, a.req_anomes, g.pac_cpf, g.pac_rg, g.pac_mae, g.pac_rg, ");
            bui.append("  a.req_matricula, a.req_prontuario, a.req_quarto, a.req_leito, ala.ala_descricao ");
            bui.append("from requisicao a ");
            bui.append("left join examerequisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo ");
            bui.append("left join paciente g on a.fil_codigo = g.fil_codigo and a.pac_codigo = g.pac_codigo ");
            bui.append("left join alahospital ala on a.fil_codigo = ala.fil_codigo and a.ala_codigo = ala.ala_codigo ");
            bui.append("where a.fil_codigo = ").append(Variaveis.filialPadrao);
            bui.append(" and a.req_excluida = false and b.exr_excluido = false ");
            bui.append(" and b.exr_situacao in (");
            bui.append("'").append("C").append("',");
            bui.append("'").append("I").append("',");
            bui.append("'").append("E").append("'");
            if (!ParametrosGerais.getConferencia()) {
                bui.append("'").append("L").append("'");
            }
            bui.append(") ");
            if (Funcoes.verificaData(this.textDataIni.getText())) {
                if (bui.length() > 0) {
                    bui.append(" and ");
                }
                bui.append(" a.req_data >= '");
                bui.append(Funcoes.formataData("MM/dd/yyyy", sdf.parse(this.textDataIni.getText())));
                bui.append("' ");
            }
            if (Funcoes.verificaData(this.textDataFin.getText())) {
                if (bui.length() > 0) {
                    bui.append(" and ");
                }
                bui.append("a.req_data <= '");
                bui.append(Funcoes.formataData("MM/dd/yyyy", sdf.parse(this.textDataFin.getText())));
                bui.append("' ");
            }
            if (this.itemColeta.isSelected()) {
                this.addExpressao(bui, ExportarResultadoClinica.getExpressao("a.col_codigo", this.itemColeta.getSelecionados(0), true));
            }
            if (this.itemConvenio.isSelected()) {
                this.addExpressao(bui, ExportarResultadoClinica.getExpressao("a.con_codigo", this.itemConvenio.getSelecionados(0), false));
            }
            if (this.itemDestino.isSelected()) {
                this.addExpressao(bui, ExportarResultadoClinica.getExpressao("a.des_codigo", this.itemDestino.getSelecionados(0), true));
            }
            if (this.itemExame.isSelected()) {
                this.addExpressao(bui, ExportarResultadoClinica.getExpressao("b.exa_codigo", this.itemExame.getSelecionados(0), true));
            }
            bui.append(" order by g.pac_nome ");
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ExportarResultadoClinica: 455");
        }
        return bui.toString();
    }

    private ArrayList<Registro> pegaExamesRequisicao(Statement st, String requisicao) throws Exception {
        ArrayList<Registro> retorno = new ArrayList<Registro>();
        StringBuilder buf = new StringBuilder("select a.exa_codigo, a.mco_codigo, b.mco_abreviatura, b.mco_descricao, e.emc_codigoamb, e.emc_codigocbhpm, ");
        buf.append(" a.met_codigo, c.exa_descricao, a.met_codigo, d.met_descricao, a.exr_datadigita, a.exr_dataassina, a.exr_datamaterial, a.exr_situacao ");
        buf.append("from examerequisicao a ");
        buf.append("left join materialcoleta b on a.fil_codigo = b.fil_codigo and a.mco_codigo = b.mco_codigo ");
        buf.append("left join exames c on a.fil_codigo = c.fil_codigo and a.exa_codigo = c.exa_codigo ");
        buf.append("left join metodologia d on a.fil_codigo = d.fil_codigo and a.met_codigo = d.met_codigo ");
        buf.append("left join examematcoleta e on a.fil_codigo = e.fil_codigo and a.exa_codigo = e.exa_codigo and a.mco_codigo = e.mco_codigo ");
        buf.append("where a.fil_codigo = ").append(Variaveis.filialPadrao);
        buf.append(" and a.req_codigo = ").append(requisicao);
        buf.append(" and a.exr_excluido = false ");
        if (this.itemExame.isSelected()) {
            this.addExpressao(buf, ExportarResultadoClinica.getExpressao("a.exa_codigo", this.itemExame.getSelecionados(0), true));
        }
        ResultSet rs = Conexao.executeQuery(st, buf);
        while (rs.next()) {
            retorno.add(new Registro(rs));
        }
        return retorno;
    }

    private void addExpressao(StringBuilder bui, String exp) {
        if (exp != null && exp.length() > 0) {
            if (bui.length() > 0) {
                bui.append("and ");
            }
            bui.append(exp);
            bui.append(' ');
        }
    }

    private String getAtributosFiltro(CheckItemFiltro item, String nome) {
        StringBuilder bui = new StringBuilder();
        bui.append(StringUtil.getTag("sel", String.valueOf(item.isSelected())));
        bui.append(StringUtil.getTag("item", item.getSelecionados(0)));
        return StringUtil.getTag(nome, bui.toString());
    }

    private void setAtributosFiltro(CheckItemFiltro item, String atributos) {
        if (StringUtil.getBoolean(atributos, "sel")) {
            item.setSelected(true);
            item.setSelecionados(StringUtil.getValores(atributos, "item"));
        }
    }

    private void excluirRequisicao() {
        if (Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.requisicoes.remove(this.tableRequisicoes.getSelectedRow());
            this.modeloRequisicoes.removeLine(this.tableRequisicoes.getSelectedRow());
        }
    }

    private void exportar() throws ParseException {
        if (this.requisicoes != null && this.requisicoes.size() > 0) {
            String MENSAGEM = "Exportando requisi\u00e7\u00f5es... Aguarde...";
            try {
                XMLStringBuilder arquivoXML = new XMLStringBuilder();
                arquivoXML.abrir("requisicoes");
                arquivoXML.escrever("dataGeracao", Funcoes.formataData("dd/MM/yyyy HH:mm:ss", new Date()));
                arquivoXML.escrever("versao", "1.0");
                for (Registro requisicao : this.requisicoes) {
                    ArrayList exames = (ArrayList)requisicao.getValor("exames");
                    arquivoXML.abrir("requisicao");
                    if (!Funcoes.textoVazio(requisicao.getString("req_prontuario"))) {
                        arquivoXML.escrever("prontuario", requisicao.getString("req_prontuario"));
                    }
                    arquivoXML.escrever("codigo", requisicao.getString("req_codigo"));
                    arquivoXML.escrever("data", Funcoes.formataData("dd/MM/yyyy", requisicao.getDate("req_data")));
                    if (!Funcoes.textoVazio(requisicao.getString("req_quarto"))) {
                        arquivoXML.escrever("quarto", requisicao.getString("req_quarto"));
                    }
                    if (!Funcoes.textoVazio(requisicao.getString("req_leito"))) {
                        arquivoXML.escrever("leito", requisicao.getString("req_leito"));
                    }
                    if (!Funcoes.textoVazio(requisicao.getString("req_ala"))) {
                        arquivoXML.escrever("ala", requisicao.getString("ala_descricao"));
                    }
                    if (!Funcoes.textoVazio(requisicao.getString("req_matricula"))) {
                        arquivoXML.escrever("matricula", requisicao.getString("req_matricula"));
                    }
                    arquivoXML.escrever("idade", requisicao.getString("req_idade") + " " + Tipos.tipoIdade(requisicao.getString("req_anomes")));
                    arquivoXML.abrir("paciente");
                    arquivoXML.escrever("codigo", requisicao.getString("pac_codigo"));
                    if (!Funcoes.textoVazio(requisicao.getString("pac_cpf")) && !requisicao.getString("pac_cpf").trim().equals(".   .   -")) {
                        arquivoXML.escrever("cpf", requisicao.getString("pac_cpf"));
                    }
                    if (!Funcoes.textoVazio(requisicao.getString("pac_rg"))) {
                        arquivoXML.escrever("rg", requisicao.getString("pac_rg"));
                    }
                    arquivoXML.escrever("nome", requisicao.getString("pac_nome"));
                    if (!Funcoes.textoVazio(requisicao.getString("pac_mae"))) {
                        arquivoXML.escrever("mae", requisicao.getString("pac_mae"));
                    }
                    if (requisicao.getValor("pac_datanasc") != null) {
                        arquivoXML.escrever("dataNascimento", Funcoes.formataData("dd/MM/yyyy", requisicao.getDate("pac_datanasc")));
                    }
                    arquivoXML.fechar("paciente");
                    arquivoXML.abrir("exames");
                    for (Registro exame : exames) {
                        arquivoXML.abrir("exame");
                        arquivoXML.escrever("codigo", exame.getString("exa_codigo"));
                        arquivoXML.escrever("descricao", exame.getString("exa_descricao"));
                        arquivoXML.abrir("material");
                        arquivoXML.escrever("codigo", exame.getString("mco_codigo"));
                        arquivoXML.escrever("descricao", exame.getString("mco_descricao"));
                        arquivoXML.escrever("abreviatura", exame.getString("mco_abreviatura"));
                        arquivoXML.fechar("material");
                        arquivoXML.abrir("metodo");
                        arquivoXML.escrever("codigo", exame.getString("met_codigo"));
                        arquivoXML.escrever("descricao", exame.getString("met_descricao"));
                        arquivoXML.fechar("metodo");
                        arquivoXML.escrever("codigoAMB", exame.getString("emc_codigoamb"));
                        arquivoXML.escrever("codigoCBHPM", exame.getString("emc_codigocbhpm"));
                        arquivoXML.escrever("dataColeta", Funcoes.formataData("dd/MM/yyyy", exame.getString("exr_datamaterial")));
                        String resultadoHTML = Resultado.getResultadoHTML(exame.getString("xmlResultado"), null, requisicao.getString("req_codigo"), exame.getString("exa_codigo"), exame.getString("mco_codigo"), "", true, 0, 0, false).get("laudo").toString();
                        arquivoXML.escreverCData("resultado", resultadoHTML);
                        arquivoXML.fechar("exame");
                    }
                    arquivoXML.fechar("exames");
                    arquivoXML.fechar("requisicao");
                }
                arquivoXML.fechar("requisicoes");
                if (!arquivoXML.vazio()) {
                    JFileChooser f = ComponenteFactory.novoJFileChooser();
                    FileFilter flt = ComponenteFactory.novoFileFilter("(*.xml)", "xml");
                    f.setFileFilter(flt);
                    if (f.showSaveDialog(this) == 0) {
                        String arquivo = f.getSelectedFile().getAbsolutePath();
                        if (!arquivo.toUpperCase().endsWith(".XML")) {
                            arquivo = arquivo + ".xml";
                        }
                        StringUtil.escreverArquivoTexto(arquivo, arquivoXML.getXML(), "utf-8");
                        Funcoes.mensagem(this, "Exporta\u00e7\u00e3o realizada com sucesso!\nArquivo: " + arquivo, 5);
                    }
                } else {
                    Funcoes.mensagem(this, "Nenhum resultado foi selecionado para exporta\u00e7\u00e3o", 5);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private String getXmlResultado(Statement st, String requisicao, String exame, int materialColetado) {
        try {
            StringBuilder buf = new StringBuilder("select pegaResultadoExame(fil_codigo, req_codigo, exa_codigo, mco_codigo) as exr_resultado ");
            buf.append("from examerequisicao ");
            buf.append("where fil_codigo = ").append(Variaveis.filialPadrao);
            buf.append(" and req_codigo = ").append(requisicao);
            buf.append(" and exa_codigo = '").append(exame).append("'");
            buf.append(" and mco_codigo = ").append(materialColetado);
            buf.append(" and exr_excluido = false ");
            ResultSet rs = Conexao.executeQuery(st, buf);
            if (rs.next()) {
                return rs.getString("exr_resultado");
            }
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ExportarResultadoClinica: 581");
        }
        return "";
    }

    public void pressioneiF2() {
        if (this.textDataIni.hasFocus()) {
            Funcoes.mostraData(this.textDataIni, this.buttonDataIni, this, true);
        } else if (this.textDataFin.hasFocus()) {
            Funcoes.mostraData(this.textDataFin, this.buttonDataFin, this, true);
        }
    }

    public static String getExpressao(String campo, String[] valores, boolean aspas) {
        if (campo != null && valores != null && valores.length > 0) {
            StringBuilder buf = new StringBuilder("(");
            for (int i = 0; i < valores.length; ++i) {
                if (i > 0) {
                    buf.append(" or ");
                }
                buf.append(campo);
                buf.append(" = ");
                if (aspas) {
                    buf.append('\'');
                }
                buf.append(valores[i]);
                if (!aspas) continue;
                buf.append('\'');
            }
            return buf.append(")").toString();
        }
        return "";
    }
}

