/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao;

import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.comum.dados.faturamento.DadosExameFaturamento;
import jalis.comum.dados.faturamento.DadosFaturamento;
import jalis.comum.dados.faturamento.DadosTotalGeral;
import jalis.comum.padroes.FrmPadrao;
import jalis.laboratorio.util.faturamento.BuscaFatura;
import jalis.laboratorio.util.faturamento.FuncoesGerais;
import jalis.laboratorio.util.faturamento.LinhasTabela;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.ThreadFinalizadaListener;
import jalis.util.ValidaDoc;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class ExportarFaturamento
extends FrmPadrao
implements ThreadFinalizadaListener {
    private JPanel panelEsquerdo = new JPanel(new GridBagLayout());
    private JPanel panelDireito = new JPanel(new BorderLayout());
    private JPanel panelDireitoExames = new JPanel();
    private JPanel panelDireitoLegenda = new JPanel();
    private JPanel panelBotoes = new JPanel(new BorderLayout());
    private JPanel panelBotoesE = new JPanel(new FlowLayout(0));
    private JPanel panelBotoesD = new JPanel(new FlowLayout(2));
    private JButton buttonFechar = new JButton("Fechar");
    private JButton buttonExportar = new JButton("Exportar");
    private JButton buttonCancelar = new JButton("Cancelar");
    private JButton buttonNovo = new JButton("Novo");
    private JButton buttonConsultar = new JButton("Consultar");
    private JLabel labelFatura = new JLabel("Fatura:");
    private TTextField txtFatura = new TTextField(5, 1);
    private JButton buttonFatura = new JButton();
    private static final int REGISTRO_DADOS_PERIODO = 0;
    private static final int REGISTRO_PACIENTE = 1;
    private static final int REGISTRO_EXAME = 2;
    private boolean executandoBusca = false;
    private int status = 1;
    private BuscaFatura consulta;

    public ExportarFaturamento() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "");
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        this.add((Component)this.panelEsquerdo, "West");
        this.add((Component)this.panelBotoes, "South");
        this.add((Component)this.panelDireito, "Center");
        this.panelEsquerdo.setPreferredSize(new Dimension(150, 100));
        this.panelDireito.add((Component)this.panelDireitoExames, "Center");
        this.panelDireito.add((Component)this.panelDireitoLegenda, "South");
        FuncoesGerais.montaLegenda(this.panelDireitoLegenda);
        Funcoes.criaBarraDescricao(this, "Exportar faturamento", "Exporta\u00e7\u00e3o de faturamento em formato texto", "integracao/export_faturamento.jpg");
        this.panelBotoes.add((Component)this.panelBotoesE, "West");
        this.panelBotoes.add((Component)this.panelBotoesD, "East");
        this.panelBotoesD.add(this.buttonNovo);
        this.panelBotoesD.add(this.buttonExportar);
        this.panelBotoesD.add(this.buttonCancelar);
        this.panelBotoesD.add(this.buttonFechar);
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridx = 0;
        cons.gridy = 0;
        cons.weightx = 1.0;
        cons.fill = 2;
        cons.anchor = 17;
        this.panelEsquerdo.add((Component)this.labelFatura, cons);
        cons.gridx = 1;
        cons.anchor = 13;
        cons.weightx = 0.0;
        cons.fill = 0;
        this.txtFatura.setPreferredSize(new Dimension(70, 20));
        this.txtFatura.setMinimumSize(new Dimension(70, 20));
        this.panelEsquerdo.add((Component)this.txtFatura, cons);
        cons.gridx = 2;
        this.buttonFatura.setPreferredSize(new Dimension(20, 20));
        this.buttonFatura.setMinimumSize(new Dimension(20, 20));
        this.panelEsquerdo.add((Component)this.buttonFatura, cons);
        cons.gridx = 0;
        cons.gridy = 1;
        cons.gridwidth = 3;
        cons.anchor = 13;
        this.panelEsquerdo.add((Component)this.buttonConsultar, cons);
        cons.gridy = 2;
        cons.fill = 1;
        cons.weightx = 1.0;
        cons.weighty = 1.0;
        cons.gridwidth = 3;
        this.panelEsquerdo.add((Component)new JPanel(), cons);
        this.panelEsquerdo.setBorder(new TitledBorder("Filtro"));
        this.buttonFechar.setMnemonic('F');
        this.buttonConsultar.setMnemonic('t');
        this.buttonNovo.setMnemonic('N');
        this.buttonExportar.setMnemonic('S');
        this.buttonCancelar.setMnemonic('C');
        Funcoes.imagemPesquisa(this.buttonFatura);
        this.buttonFatura.setFocusable(false);
        this.buttonConsultar.setMargin(new Insets(2, 2, 2, 2));
        this.controlaCampos();
        this.buttonFechar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportarFaturamento.this.setVisible(false);
            }
        });
        this.buttonConsultar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportarFaturamento.this.pesquisaFaturamento();
                System.gc();
            }
        });
        this.buttonFatura.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportarFaturamento.this.pesquisaFatura();
            }
        });
        this.buttonNovo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportarFaturamento.this.limpaCampos();
                ExportarFaturamento.this.status = 2;
                ExportarFaturamento.this.controlaCampos();
                ExportarFaturamento.this.txtFatura.requestFocus();
            }
        });
        this.buttonCancelar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Funcoes.mensagem(ExportarFaturamento.this, "As informa\u00e7\u00f5es adicionadas ser\u00e3o perdidas.", 4) == 0) {
                    ExportarFaturamento.this.limpaCampos();
                    ExportarFaturamento.this.status = 1;
                    ExportarFaturamento.this.controlaCampos();
                    ExportarFaturamento.this.buttonNovo.requestFocus();
                }
            }
        });
        this.buttonExportar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportarFaturamento.this.exportar();
            }
        });
    }

    private void limpaCampos() {
        this.txtFatura.clear();
        this.panelDireitoExames.removeAll();
        this.panelDireitoExames.repaint();
    }

    private void controlaCampos() {
        boolean habilita;
        boolean bl = habilita = this.status == 2;
        boolean faturaCarregada = FuncoesGerais.pegaTabela(this.panelDireitoExames) == null ? false : FuncoesGerais.pegaTabela(this.panelDireitoExames).getModel().getRowCount() > 0;
        this.txtFatura.setEnabled(habilita && !this.executandoBusca && !faturaCarregada);
        this.buttonFatura.setEnabled(habilita && !this.executandoBusca && !faturaCarregada);
        this.buttonConsultar.setEnabled(habilita && !this.executandoBusca && !faturaCarregada);
        this.buttonNovo.setEnabled(!habilita && !this.executandoBusca);
        this.buttonExportar.setEnabled(habilita && !this.executandoBusca && faturaCarregada);
        this.buttonCancelar.setEnabled(habilita && !this.executandoBusca);
        this.buttonFechar.setEnabled(!habilita && !this.executandoBusca);
    }

    public static Long getModuloAcesso() {
        return Long.parseLong("0910001000");
    }

    @Override
    public void pressioneiF2() {
        if (this.txtFatura.hasFocus()) {
            this.buttonFatura.doClick();
        }
    }

    private void pesquisaFaturamento() {
        if (!Funcoes.isNumeric(this.txtFatura.getText())) {
            Funcoes.mensagem(this, "C\u00f3digo da fatura n\u00e3o informado", 1);
            this.txtFatura.grabFocus();
            return;
        }
        this.buttonConsultar.setEnabled(false);
        this.panelDireitoExames.removeAll();
        this.panelDireitoExames.setLayout(null);
        this.consulta = new BuscaFatura((Frame)this.getTopLevelAncestor(), this.panelDireitoExames, this.buttonConsultar, false, false, false, this);
        this.consulta.addThreadListener(this);
        this.consulta.setPararSeConferida(false);
        this.consulta.setCodigoFatura(this.txtFatura.getText());
        this.consulta.start();
    }

    private void pesquisaFatura() {
        Hashtable resultado = Pesquisas.fatura(this.getTopLevelAncestor());
        if (resultado != null) {
            this.txtFatura.setText(resultado.get("fat_codigo").toString());
        }
        this.txtFatura.requestFocus();
    }

    @Override
    public void threadIniciada(EventObject e) {
        this.executandoBusca = true;
        this.controlaCampos();
    }

    @Override
    public void threadFinalizada(EventObject e) {
        this.executandoBusca = false;
        this.controlaCampos();
    }

    private void exportar() {
        boolean continuar;
        DadosArquivo dado = this.escreverArquivo();
        JFileChooser chooser = ComponenteFactory.novoJFileChooser(null, Variaveis.ultimoDiretorioDialogo != null ? Variaveis.ultimoDiretorioDialogo.getAbsolutePath() : null);
        chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
        chooser.setSelectedFile(dado.getArquivo());
        chooser.setFileFilter(ComponenteFactory.novoFileFilter("Arquivo de faturamento", "xml"));
        int option = -1;
        option = chooser.showOpenDialog(null);
        boolean bl = continuar = option == 0;
        if (continuar) {
            String arquivo = chooser.getSelectedFile().getParent();
            try {
                StringUtil.escreverArquivoTexto(arquivo, dado.getTexto());
            }
            catch (Exception e) {
                Funcoes.mensagem(null, "N\u00e3o foi poss\u00edvel exportar os dados para o arquivo " + arquivo + ".\nMensagem: " + e.getMessage(), 1);
            }
        }
    }

    private DadosArquivo escreverArquivo() {
        LinhasTabela linhas = FuncoesGerais.pegaModeloFatura(this.panelDireitoExames);
        StringBuilder buf = new StringBuilder();
        ArrayList<DadosFaturamento> requisicoes = new ArrayList<DadosFaturamento>();
        for (int i = 0; i < linhas.getRowCount(); ++i) {
            if (!(linhas.getValueAt(i, 1) instanceof DadosFaturamento)) continue;
            requisicoes.add((DadosFaturamento)linhas.getValueAt(i, 1));
        }
        String cnpjCpf = "";
        Date data = new Date();
        if (!requisicoes.isEmpty()) {
            DadosTotalGeral total = ((DadosFaturamento)requisicoes.get(0)).getDadosTotalGeral();
            buf.append(0).append("|");
            buf.append(Funcoes.formataData("yyyy-MM-dd HH:mm:ss", data)).append("|");
            buf.append(this.txtFatura.getText()).append("|");
            buf.append(((DadosFaturamento)requisicoes.get(0)).getDataInicioFatura()).append("|");
            buf.append(((DadosFaturamento)requisicoes.get(0)).getDataFinalFatura()).append("|");
            buf.append(Funcoes.formataDecimal(total.getTotal().doubleValue())).append("|");
            buf.append(Funcoes.formataDecimal(total.getAdicional().doubleValue())).append("|");
            String cobranca = Funcoes.formataDecimal(total.getTotalExames().add(total.getTotalMateriais()).doubleValue() * (total.getPercentualBonus().doubleValue() / 100.0));
            buf.append(cobranca).append("|").append('\r').append('\n');
        }
        for (DadosFaturamento requisicao : requisicoes) {
            buf.append(1).append("|");
            buf.append(this.txtFatura.getText()).append("|");
            buf.append(requisicao.getRequisicao()).append("|");
            buf.append(requisicao.getDataRequisicao()).append("|");
            buf.append(requisicao.getCodigoConvenioPrincipal()).append("|");
            buf.append(requisicao.getConvenioRazao()).append("|");
            boolean isCnpj = false;
            String documento = StringUtil.limpaString(requisicao.getCnpjCpf(), new String[]{",", ".", "/", "-"});
            if (requisicao.getCnpjCpf().length() > 13 && ValidaDoc.checkDoc(documento, 7)) {
                buf.append(requisicao.getCnpjCpf()).append("|");
                isCnpj = true;
            } else {
                buf.append("").append("|");
            }
            cnpjCpf = documento;
            if (!isCnpj && !Funcoes.textoVazio(requisicao.getCnpjCpf())) {
                buf.append(requisicao.getCnpjCpf()).append("|");
            } else {
                buf.append("").append("|");
            }
            buf.append(requisicao.getCidadeConvenio()).append("|");
            buf.append(requisicao.getUfConvenio()).append("|");
            buf.append(Funcoes.formataDecimal(requisicao.getValorTotal().doubleValue())).append("|").append('\r').append('\n');
            for (DadosExameFaturamento dadoExame : requisicao.getExames()) {
                buf.append(2).append("|");
                buf.append(this.txtFatura.getText()).append("|");
                buf.append(dadoExame.getCodigoExame()).append("|");
                buf.append(dadoExame.getCodigoMaterial()).append("|");
                buf.append(dadoExame.getNomeExame()).append("|");
                buf.append(dadoExame.getDescricaoMaterial()).append("|");
                buf.append(dadoExame.getDataExame()).append("|");
                buf.append(dadoExame.getDataColeta()).append("|");
                if (dadoExame.getDataConferencia() != null) {
                    buf.append(dadoExame.getDataConferencia()).append("|");
                } else {
                    buf.append("").append("|");
                }
                buf.append(Funcoes.formataDecimal(dadoExame.getValorExame().doubleValue())).append("|").append('\r').append('\n');
            }
        }
        DadosArquivo dados = new DadosArquivo();
        dados.setArquivo(new File(cnpjCpf + "_" + Funcoes.formataData("ddMMyyyyHHmmss", data) + ".txt"));
        dados.setTexto(buf.toString());
        return dados;
    }

    class DadosArquivo {
        File arquivo = null;
        String texto = null;

        DadosArquivo() {
        }

        public File getArquivo() {
            return this.arquivo;
        }

        public void setArquivo(File arquivo) {
            this.arquivo = arquivo;
        }

        public String getTexto() {
            return this.texto;
        }

        public void setTexto(String texto) {
            this.texto = texto;
        }
    }
}

