/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.exportacao.AvisaFinal;
import jalis.util.DBUtil;
import jalis.util.StringUtil;
import jalis.util.Tempo;
import jalis.util.logger.ErrorLogger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JProgressBar;

class Exportar
extends Thread {
    private JProgressBar progresso;
    private Tempo timer;
    private JLabel labelTempo;
    private String[] itemMedicoCrm;
    private String[] itemMedicoUF;
    private String[] itemMedicoConselho;
    private String[] itemConvenio;
    private String[] itemExame;
    private String[] itemPaciente;
    private String[] itemDestino;
    private String[] itemFiscal;
    private String[] itemResponsavel;
    private String[] itemUsuario;
    private int qtdeMedicos = 0;
    private int qtdeConvenios = 0;
    private int qtdeExames = 0;
    private int qtdePacientes = 0;
    private int qtdeDestinos = 0;
    private int qtdeFiscais = 0;
    private int qtdeResponsaveis = 0;
    private int qtdeUsuarios = 0;
    private ArrayList<AvisaFinal> listenerList = new ArrayList();

    public Exportar(JProgressBar barra, JLabel tempo) {
        super("Thread - Selecionar para web");
        this.setPriority(1);
        this.progresso = barra;
        this.labelTempo = tempo;
    }

    public void addAvisaFinal(AvisaFinal l) {
        this.listenerList.add(l);
    }

    public void removeAvisaFinal(AvisaFinal l) {
        this.listenerList.remove(l);
    }

    private void fireAvisaFinal() {
        for (AvisaFinal c : this.listenerList) {
            c.threadParada();
        }
    }

    public void setQtdeUsuarios(int q) {
        this.qtdeUsuarios = q;
    }

    public void setQtdeMedicos(int q) {
        this.qtdeMedicos = q;
    }

    public void setQtdeConvenios(int q) {
        this.qtdeConvenios = q;
    }

    public void setQtdeExames(int q) {
        this.qtdeExames = q;
    }

    public void setQtdePacientes(int q) {
        this.qtdePacientes = q;
    }

    public void setQtdeDestinos(int q) {
        this.qtdeDestinos = q;
    }

    public void setQtdeFiscais(int q) {
        this.qtdeFiscais = q;
    }

    public void setQtdeResponsaveis(int q) {
        this.qtdeResponsaveis = q;
    }

    public void setSelecaoMedicos(String[] conselho, String[] crm, String[] uf) {
        this.itemMedicoConselho = conselho;
        this.itemMedicoCrm = crm;
        this.itemMedicoUF = uf;
    }

    public void setSelecaoConvenio(String[] s) {
        this.itemConvenio = s;
    }

    public void setSelecaoExame(String[] s) {
        this.itemExame = s;
    }

    public void setSelecaoPaciente(String[] s) {
        this.itemPaciente = s;
    }

    public void setSelecaoDestino(String[] s) {
        this.itemDestino = s;
    }

    public void setSelecaoFiscal(String[] s) {
        this.itemFiscal = s;
    }

    public void setSelecaoResponsavel(String[] s) {
        this.itemResponsavel = s;
    }

    public void setSelecaoUsuario(String[] s) {
        this.itemUsuario = s;
    }

    @Override
    public void start() {
        this.timer = new Tempo(this.labelTempo);
        this.timer.start();
        super.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int contaItens = 0;
        if (this.itemDestino != null) {
            contaItens += this.itemDestino.length;
        }
        if (this.itemMedicoCrm != null) {
            contaItens += this.itemMedicoCrm.length;
        }
        if (this.itemConvenio != null) {
            contaItens += this.itemConvenio.length;
        }
        if (this.itemExame != null) {
            contaItens += this.itemExame.length;
        }
        if (this.itemPaciente != null) {
            contaItens += this.itemPaciente.length;
        }
        if (this.itemFiscal != null) {
            contaItens += this.itemFiscal.length;
        }
        if (this.itemResponsavel != null) {
            contaItens += this.itemResponsavel.length;
        }
        if (this.itemUsuario != null) {
            contaItens += this.itemUsuario.length;
        }
        this.progresso.setMaximum(contaItens);
        this.progresso.setValue(0);
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        Statement st3 = Conexao.getStatement();
        try {
            ResultSet rs;
            int i;
            StringBuilder buf = new StringBuilder();
            if (this.itemDestino != null) {
                buf.delete(0, buf.length());
                buf.append("select des_codigo, des_descricao, des_senhaweb, des_conectarweb from destino where fil_codigo = ");
                buf.append(Variaveis.filialPadrao);
                if (this.itemDestino.length != this.qtdeConvenios && this.itemDestino.length > 0) {
                    buf.append(" and (");
                    for (i = 0; i < this.itemDestino.length; ++i) {
                        buf.append("des_codigo = ");
                        buf.append("'").append(this.itemDestino[i]).append("'");
                        if (i >= this.itemDestino.length - 1) continue;
                        buf.append(" or ");
                    }
                    buf.append(")");
                }
                rs = Conexao.executeQuery(st, buf.toString());
                while (rs.next()) {
                    String[] comando = new String[]{"codigoBase", Variaveis.codigoBaseWeb, "codigoDestino", rs.getString("des_codigo"), "descricaoDestino", rs.getString("des_descricao"), "senhaDestino", rs.getString("des_senhaweb"), "ativadoDestino", rs.getBoolean("des_conectarweb") ? "true" : "false"};
                    DBUtil.insereExportaWeb(st2, "destinos", "I", comando);
                    this.progresso.setValue(this.progresso.getValue() + 1);
                }
            }
            if (this.itemMedicoCrm != null) {
                buf.delete(0, buf.length());
                buf.append("select med_conselho, med_crm, med_nome, med_uf, med_senhaweb from medico where fil_codigo = ");
                buf.append(Variaveis.filialPadrao);
                if (this.itemMedicoCrm.length != this.qtdeMedicos && this.itemMedicoCrm.length > 0) {
                    buf.append(" and (");
                    for (i = 0; i < this.itemMedicoCrm.length; ++i) {
                        buf.append("(med_conselho = '");
                        buf.append(this.itemMedicoConselho[i]);
                        buf.append("' and med_crm = '");
                        buf.append(this.itemMedicoCrm[i]);
                        buf.append("' and med_uf = '");
                        buf.append(this.itemMedicoUF[i]);
                        buf.append("')");
                        if (i >= this.itemMedicoCrm.length - 1) continue;
                        buf.append(" or ");
                    }
                    buf.append(")");
                }
                rs = Conexao.executeQuery(st, buf.toString());
                while (rs.next()) {
                    String[] comando = new String[]{"codigoBase", Variaveis.codigoBaseWeb, "conselhoMedico", rs.getString("med_conselho"), "crmMedico", rs.getString("med_crm"), "ufMedico", rs.getString("med_uf"), "senhaMedico", rs.getString("med_senhaweb"), "nomeMedico", rs.getString("med_nome")};
                    DBUtil.insereExportaWeb(st2, "medicos", "I", comando);
                    buf.setLength(0);
                    buf.append("select med_conselho, med_crm, med_uf, exa_codigo, mew_proibido from medicoexameweb ");
                    buf.append("where fil_codigo = ").append(Variaveis.filialPadrao);
                    buf.append(" and med_conselho = '").append(StringUtil.textoDB(rs.getString("med_conselho"))).append("' ");
                    buf.append(" and med_crm = '").append(StringUtil.textoDB(rs.getString("med_crm"))).append("' ");
                    buf.append(" and med_uf = '").append(StringUtil.textoDB(rs.getString("med_uf"))).append("' ");
                    ResultSet rsM = Conexao.executeQuery(st3, buf);
                    while (rsM.next()) {
                        String[] comando2 = new String[]{"codigoBase", Variaveis.codigoBaseWeb, "conselhoMedicoExame", rsM.getString("med_conselho"), "crmMedicoExame", rsM.getString("med_crm"), "ufMedicoExame", rsM.getString("med_uf"), "codigoExameMedicoExame", rsM.getString("exa_codigo"), "proibidoMedicoExame", rsM.getString("mew_proibido")};
                        DBUtil.insereExportaWeb(st2, "medicosexames", "I", ParametrosGerais.getCopiaMedico(), comando2);
                    }
                    this.progresso.setValue(this.progresso.getValue() + 1);
                }
            }
            if (this.itemUsuario != null) {
                buf.delete(0, buf.length());
                buf.append("select usr_codigo, usr_nome, usr_assinaturaweb from usuario ");
                if (this.itemUsuario.length != this.qtdeUsuarios && this.itemUsuario.length > 0) {
                    buf.append(" where ");
                    for (i = 0; i < this.itemUsuario.length; ++i) {
                        buf.append("usr_codigo = '");
                        buf.append(this.itemUsuario[i]);
                        buf.append("' ");
                        if (i >= this.itemUsuario.length - 1) continue;
                        buf.append(" or ");
                    }
                }
                rs = Conexao.executeQuery(st, buf.toString());
                while (rs.next()) {
                    String[] comando = new String[]{"codigoBase", Variaveis.codigoBaseWeb, "codigoUsuario", rs.getString("usr_codigo"), "nomeUsuario", rs.getString("usr_nome"), "assinaturaUsuario", rs.getString("usr_assinaturaweb")};
                    DBUtil.insereExportaWeb(st2, "usuario", "I", comando);
                    this.progresso.setValue(this.progresso.getValue() + 1);
                }
            }
            if (this.itemConvenio != null) {
                buf.delete(0, buf.length());
                buf.append("select con_codigo, con_fantasia, con_senhaweb, con_proibidoweb from convenios where fil_codigo = ");
                buf.append(Variaveis.filialPadrao);
                if (this.itemConvenio.length != this.qtdeConvenios && this.itemConvenio.length > 0) {
                    buf.append(" and (");
                    for (i = 0; i < this.itemConvenio.length; ++i) {
                        buf.append("con_codigo = ");
                        buf.append(this.itemConvenio[i]);
                        if (i >= this.itemConvenio.length - 1) continue;
                        buf.append(" or ");
                    }
                    buf.append(")");
                }
                rs = Conexao.executeQuery(st, buf.toString());
                while (rs.next()) {
                    String[] comando = new String[]{"codigoBase", Variaveis.codigoBaseWeb, "codigoConvenio", rs.getString("con_codigo"), "descricaoConvenio", rs.getString("con_fantasia"), "senhaConvenio", rs.getString("con_senhaweb"), "bloqueadoConvenio", rs.getBoolean("con_proibidoweb") ? "1" : "0"};
                    DBUtil.insereExportaWeb(st2, "convenios", "I", comando);
                    this.progresso.setValue(this.progresso.getValue() + 1);
                }
            }
            if (this.itemPaciente != null) {
                buf.delete(0, buf.length());
                buf.append("select pac_codigo, pac_nome, pac_senhaweb, pac_sif, pac_cpf, pac_proprietario from paciente where fil_codigo = ");
                buf.append(Variaveis.filialPadrao);
                if (this.itemPaciente.length != this.qtdePacientes && this.itemPaciente.length > 0) {
                    buf.append(" and (");
                    for (i = 0; i < this.itemPaciente.length; ++i) {
                        buf.append("pac_codigo = ");
                        buf.append(this.itemPaciente[i]);
                        if (i >= this.itemPaciente.length - 1) continue;
                        buf.append(" or ");
                    }
                    buf.append(")");
                }
                rs = Conexao.executeQuery(st, buf.toString());
                while (rs.next()) {
                    String[] comando = new String[]{"codigoBase", Variaveis.codigoBaseWeb, "codigoPaciente", rs.getString("pac_codigo"), "nomePaciente", rs.getString("pac_nome"), "senhaPaciente", rs.getString("pac_senhaweb"), "cpfPaciente", rs.getString("pac_cpf"), "sifPaciente", rs.getString("pac_sif"), "proprietarioPaciente", rs.getString("pac_proprietario")};
                    DBUtil.insereExportaWeb(st2, "paciente", "I", comando);
                    this.progresso.setValue(this.progresso.getValue() + 1);
                }
            }
            if (this.itemFiscal != null) {
                buf.delete(0, buf.length());
                buf.append("select ent_codigo, ent_fantasia, ent_senhaweb, ent_tipo, ent_cpfcnpj from entidade where fil_codigo = ");
                buf.append(Variaveis.filialPadrao);
                buf.append(" and ent_tipo = '").append("I").append("' ");
                if (this.itemFiscal.length != this.qtdeFiscais && this.itemFiscal.length > 0) {
                    buf.append(" and (");
                    for (i = 0; i < this.itemFiscal.length; ++i) {
                        buf.append("ent_codigo = ");
                        buf.append(this.itemFiscal[i]);
                        if (i >= this.itemFiscal.length - 1) continue;
                        buf.append(" or ");
                    }
                    buf.append(")");
                }
                rs = Conexao.executeQuery(st, buf.toString());
                while (rs.next()) {
                    String[] comando = new String[]{"codigoBase", Variaveis.codigoBaseWeb, "codigoEntidade", rs.getString("ent_codigo"), "nomeEntidade", rs.getString("ent_fantasia"), "senhaEntidade", rs.getString("ent_senhaweb"), "cpfEntidade", rs.getString("ent_cpfcnpj"), "tipoEntidade", "I"};
                    DBUtil.insereExportaWeb(st2, "entidade", "I", comando);
                    this.progresso.setValue(this.progresso.getValue() + 1);
                }
            }
            if (this.itemResponsavel != null) {
                buf.delete(0, buf.length());
                buf.append("select ent_codigo, ent_fantasia, ent_senhaweb, ent_tipo, ent_cpfcnpj from entidade where fil_codigo = ");
                buf.append(Variaveis.filialPadrao);
                buf.append(" and ent_tipo = '").append("P").append("' ");
                if (this.itemResponsavel.length != this.qtdeResponsaveis && this.itemResponsavel.length > 0) {
                    buf.append(" and (");
                    for (i = 0; i < this.itemResponsavel.length; ++i) {
                        buf.append("ent_codigo = ");
                        buf.append(this.itemResponsavel[i]);
                        if (i >= this.itemResponsavel.length - 1) continue;
                        buf.append(" or ");
                    }
                    buf.append(")");
                }
                rs = Conexao.executeQuery(st, buf.toString());
                while (rs.next()) {
                    String[] comando = new String[]{"codigoBase", Variaveis.codigoBaseWeb, "codigoEntidade", rs.getString("ent_codigo"), "nomeEntidade", rs.getString("ent_fantasia"), "senhaEntidade", rs.getString("ent_senhaweb"), "cpfEntidade", rs.getString("ent_cpfcnpj"), "tipoEntidade", "P"};
                    DBUtil.insereExportaWeb(st2, "entidade", "I", comando);
                    this.progresso.setValue(this.progresso.getValue() + 1);
                }
            }
            if (this.itemExame != null) {
                buf.delete(0, buf.length());
                buf.append("select a.exa_codigo, a.exa_descricao, a.exa_interferencia, a.exa_diagnostico, a.exa_sinonimo, a.exa_interferencia, ");
                buf.append("a.exa_diagnostico, a.exa_proibidoweb, b.mco_codigo, b.emc_codigoamb, b.emc_codigocbhpm, b.emc_referencia, b.emc_preparo, ");
                buf.append("b.emc_prepamostra, b.emc_inadequada, b.emc_conservacao, b.emc_procedimento, b.emc_instrcoleta, c.met_descricao, ");
                buf.append("d.mco_descricao, e.prz_descricao, b.emc_proibido, a.exa_proibido ");
                buf.append("from exames a ");
                buf.append("left join examematcoleta b on a.fil_codigo = b.fil_codigo and a.exa_codigo = b.exa_codigo ");
                buf.append("left join metodologia c on b.fil_codigo = c.fil_codigo and b.met_codigo = c.met_codigo ");
                buf.append("left join materialcoleta d on b.fil_codigo = d.fil_codigo and b.mco_codigo = d.mco_codigo ");
                buf.append("left join prazoentrega e on b.fil_codigo = e.fil_codigo and b.prz_codigo = e.prz_codigo ");
                buf.append(" where a.fil_codigo = ");
                buf.append(Variaveis.filialPadrao);
                if (this.itemExame.length != this.qtdeExames && this.itemExame.length > 0) {
                    buf.append(" and (");
                    for (i = 0; i < this.itemExame.length; ++i) {
                        buf.append("a.exa_codigo = '");
                        buf.append(this.itemExame[i]);
                        buf.append("'");
                        if (i >= this.itemExame.length - 1) continue;
                        buf.append(" or ");
                    }
                    buf.append(")");
                }
                rs = Conexao.executeQuery(st, buf.toString());
                while (rs.next()) {
                    String[] comando = new String[]{"codigoBase", Variaveis.codigoBaseWeb, "codigoExame", rs.getString("exa_codigo"), "codigoMaterialExame", rs.getString("mco_codigo"), "descricaoExame", rs.getString("exa_descricao"), "modoColetaExame", StringUtil.tratarEntidadesHTML(rs.getString("emc_instrcoleta")), "sinonimoExame", rs.getString("exa_sinonimo"), "metodoExame", rs.getString("met_descricao"), "ambExame", rs.getString("emc_codigoamb"), "cbhpmExame", rs.getString("emc_codigocbhpm"), "prazoExame", rs.getString("prz_descricao"), "valorReferenciaExame", StringUtil.tratarEntidadesHTML(rs.getString("emc_referencia")), "interferenciaExame", StringUtil.tratarEntidadesHTML(rs.getString("exa_interferencia")), "diagnosticoExame", StringUtil.tratarEntidadesHTML(rs.getString("exa_diagnostico")), "proibidoExame", rs.getString("exa_proibidoweb"), "modoPreparoExame", StringUtil.tratarEntidadesHTML(rs.getString("emc_preparo")), "materialExame", rs.getString("mco_descricao"), "preparoAmostraExame", StringUtil.tratarEntidadesHTML(rs.getString("emc_prepamostra")), "amostraInadequadaExame", StringUtil.tratarEntidadesHTML(rs.getString("emc_inadequada")), "conservacaoExame", StringUtil.tratarEntidadesHTML(rs.getString("emc_conservacao")), "procedimentoExame", StringUtil.tratarEntidadesHTML(rs.getString("emc_procedimento")), "bloqueadoExame", rs.getBoolean("emc_proibido") || rs.getBoolean("exa_proibido") ? "S" : "N"};
                    DBUtil.insereExportaWeb(st2, "exames", "I", comando);
                    this.progresso.setValue(this.progresso.getValue() + 1);
                }
            }
            Conexao.arquivaSQL();
        }
        catch (Exception ex) {
            try {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                Conexao.fecharStatement(st2);
                Conexao.fecharStatement(st3);
                throw throwable;
            }
            Conexao.fecharStatement(st);
            Conexao.fecharStatement(st2);
            Conexao.fecharStatement(st3);
        }
        Conexao.fecharStatement(st);
        Conexao.fecharStatement(st2);
        Conexao.fecharStatement(st3);
        Conexao.fecharStatement(st);
        this.timer.stop();
        this.fireAvisaFinal();
    }
}

