/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao;

import jalis.comum.Acesso;
import jalis.comum.padroes.FrmPadrao;
import jalis.laboratorio.exportacao.thread.ExportaWeb;
import jalis.util.Funcoes;
import jalis.util.SplashMensagem;
import jalis.util.Tempo;
import jalis.util.ThreadListener;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class ExportacaoWeb
extends FrmPadrao
implements ActionListener,
ThreadListener {
    private final long ACESSO_AUTOMATICO = Long.parseLong("0900100001");
    private final long ACESSO_IGNORAR_FILIAL = Long.parseLong("0900100002");
    private GridBagLayout grid = new GridBagLayout();
    private GridBagConstraints constraints = new GridBagConstraints();
    private ExportaWeb exportaWeb;
    private JButton buttonFechar = ComponenteFactory.novoJButton("Fechar", 'F', this, null, null, true);
    private JButton buttonExportar = ComponenteFactory.novoJButton("Exportar", 'E', this, null, null, true);
    private JButton buttonParar = ComponenteFactory.novoJButton("Parar", 'P', this, null, null, false);
    private JProgressBar progresso = new JProgressBar();
    private JLabel labelTempo = new JLabel("00:00:00");
    private JTextArea texto = new JTextArea();
    private JScrollPane scroll = new JScrollPane(this.texto);
    private JCheckBox checkAutomatico = ComponenteFactory.novoJCheckBox("Autom\u00e1tico", 'm');
    private JCheckBox checkIgnoraFilial = ComponenteFactory.novoJCheckBox("Ignorar filiais", 'I');
    private JPanel panelCentro = new JPanel(this.grid);
    private JPanel panelBotoes = new JPanel(new FlowLayout(2));
    private Tempo tempo = new Tempo(this.labelTempo);

    public ExportacaoWeb() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        Funcoes.criaBarraDescricao(this, "Exporta\u00e7\u00e3o para Web", "Exporta os dados gerados pelo sistema para o site de resultados", "integracao/export_web.jpg");
        this.add((Component)this.panelCentro, "Center");
        this.add((Component)this.panelBotoes, "South");
        this.panelBotoes.add(this.buttonParar);
        this.panelBotoes.add(this.buttonExportar);
        this.panelBotoes.add(this.buttonFechar);
        this.montaTela();
        this.checkAutomatico.setVisible(Acesso.getAcesso(this.ACESSO_AUTOMATICO));
        this.checkIgnoraFilial.setVisible(Acesso.getAcesso(this.ACESSO_IGNORAR_FILIAL));
        this.scroll.setBorder(null);
        this.texto.setBackground(this.getBackground());
        this.texto.setFocusable(false);
    }

    private void montaTela() {
        this.constraints.gridx = 0;
        this.constraints.gridy = 3;
        this.constraints.fill = 0;
        this.constraints.anchor = 17;
        this.panelCentro.add((Component)this.checkAutomatico, this.constraints);
        this.constraints.gridx = 1;
        this.panelCentro.add((Component)this.checkIgnoraFilial, this.constraints);
        this.constraints.fill = 2;
        this.constraints.anchor = 13;
        this.constraints.gridwidth = 2;
        this.constraints.gridx = 0;
        this.constraints.gridy = 2;
        this.constraints.weightx = 1.0;
        this.panelCentro.add((Component)this.progresso, this.constraints);
        this.constraints.gridy = 1;
        this.labelTempo.setHorizontalAlignment(4);
        this.panelCentro.add((Component)this.labelTempo, this.constraints);
        this.constraints.gridy = 0;
        this.constraints.fill = 1;
        this.constraints.anchor = 17;
        this.constraints.weighty = 1.0;
        this.panelCentro.add((Component)this.scroll, this.constraints);
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0900100000");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonFechar) {
            if (this.exportaWeb != null) {
                this.exportaWeb.parar();
            }
            this.setVisible(false);
        } else if (e.getSource() == this.buttonExportar) {
            this.exportaWeb = new ExportaWeb();
            this.exportaWeb.addThreadListener(this);
            this.exportaWeb.setProgressBar(this.progresso);
            this.exportaWeb.setTextMensagens(this.texto);
            this.exportaWeb.setMostrarIcones(false);
            this.exportaWeb.setAutomatico(this.checkAutomatico.isSelected());
            this.exportaWeb.setIgnorarFiliais(this.checkIgnoraFilial.isSelected());
            this.exportaWeb.start();
        } else if (e.getSource() == this.buttonParar) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (this.exportaWeb != null) {
                this.exportaWeb.parar();
                if (this.exportaWeb.exportando()) {
                    SplashMensagem splash = SplashMensagem.getInstancia(this);
                    splash.mostrar("Finalizando exporta\u00e7\u00e3o...");
                    while (this.exportaWeb.exportando()) {
                    }
                    splash.apagar();
                }
            }
            this.tempo.stop();
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    @Override
    public void iniciouExecucao(EventObject e) {
        this.texto.setText("");
        this.buttonExportar.setEnabled(false);
        this.buttonParar.setEnabled(true);
        this.tempo.start();
    }

    @Override
    public void terminouExecucao(EventObject e) {
        this.buttonExportar.setEnabled(true);
        this.buttonParar.setEnabled(false);
        this.tempo.stop();
    }
}

