/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao;

import jalis.comum.Conexao;
import jalis.comum.ParametrosUsuarios;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.digitacao.Digitacao;
import jalis.laboratorio.digitacao.Resultado;
import jalis.laboratorio.exportacao.CampoResultado;
import jalis.laboratorio.exportacao.ConfiguradorExportacaoSoc;
import jalis.laboratorio.exportacao.ConfigurarCodigos;
import jalis.laboratorio.exportacao.Dados;
import jalis.laboratorio.exportacao.DadosLinha;
import jalis.laboratorio.exportacao.SemResultadoSoc;
import jalis.util.CheckItemFiltro;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;

public class ExportacaoSoc
extends JPanel
implements ActionListener {
    private static final long ACESSO = Long.parseLong("0905000100");
    private final Color COR_SEM_RELACIONAMENTO = new Color(255, 91, 117);
    private final Color COR_SEM_EMPRESA = new Color(255, 168, 88);
    private TTextField textDataIni = new TTextField(0, 4);
    private TTextField textDataFin = new TTextField(0, 4);
    private JLabel labelDataIni = new JLabel("Data Inicial:");
    private JLabel labelDataFin = new JLabel("Data Final:");
    private JButton buttonDataIni = ComponenteFactory.novoJButton(this, null, new Dimension(20, 20), true);
    private JButton buttonDataFin = ComponenteFactory.novoJButton(this, null, new Dimension(20, 20), true);
    private JButton buttonConsultar = ComponenteFactory.novoJButton("Consultar", 'C', this, null, null);
    private JButton buttonNovo = ComponenteFactory.novoJButton("Novo", 'N', this, null, null);
    private JButton buttonConfigurar = ComponenteFactory.novoJButton("Configurar", 'o', this, null, null);
    private JButton buttonExportar = ComponenteFactory.novoJButton("Exportar", 'E', this, null, null);
    private JButton buttonFechar = ComponenteFactory.novoJButton("Fechar", 'F', this, null, null);
    private JPanel panelRequisicoes = new JPanel(new BorderLayout());
    private JPanel panelExames = new JPanel(new BorderLayout());
    private JPanel panelLegendas = new JPanel(new FlowLayout(0));
    private ModeloGridTable modeloRequisicoes = new ModeloGridTable(new String[]{"Requisi\u00e7\u00e3o", "Paciente"});
    private DefaultTableCellRenderer rendererExames = null;
    private DefaultTableCellRenderer rendererRequisicoes = null;
    private JTable tableRequisicoes = ComponenteFactory.novoJTable((TableModel)this.modeloRequisicoes, 70, 0);
    private ModeloGridTable modeloExames = new ModeloGridTable(new String[]{"C\u00f3d.", "Mat.", "Exame", "Sit."});
    private JTable tableExames = ComponenteFactory.novoJTable((TableModel)this.modeloExames, 50, 30, 0, 20);
    private JScrollPane scrollRequisicoes = new JScrollPane(this.tableRequisicoes);
    private JScrollPane scrollExames = new JScrollPane(this.tableExames);
    private CheckItemFiltro itemColeta;
    private CheckItemFiltro itemConvenio;
    private CheckItemFiltro itemDestino;
    private CheckItemFiltro itemExame;
    private JCheckBox itemRelacionamento;
    private JSplitPane splitCentral = new JSplitPane(1, this.panelRequisicoes, this.panelExames);
    private String auxMedico = null;
    private String auxExaminador = null;
    private String auxPrestador = null;
    private int posicaoDivisor = 350;
    private static final String ULTIMO_FILTRO = "ExportacaoSoc.ultimoFiltro";
    private static final String POSICAO_DIVISOR = "posicaoDivisor";
    private static final String CODIGO_MEDICO = "codigoMedico";
    private static final String CODIGO_EXAMINADOR = "codigoExaminador";
    private static final String CODIGO_PRESTADOR = "codigoPrestador";
    private static final String[] CARACTERES_PROIBIDOS = new String[]{",", ";"};
    private static final String DEL = ";";
    private ArrayList<Registro> requisicoes = new ArrayList();
    private final int COLUNA_REQ_CODIGO = 0;
    private final int COLUNA_REQ_NOME = 1;
    private final int COLUNA_REQ_XML = 2;
    private final int COLUNA_REQ_RELACIONAMENTO = 3;
    private final int COLUNA_EXA_EXAME = 0;
    private final int COLUNA_EXA_ABREVIATURA = 1;
    private final int COLUNA_EXA_DESCRICAO = 2;
    private final int COLUNA_EXA_SITUACAO = 3;
    private final int COLUNA_EXA_ENVIADO = 4;

    public ExportacaoSoc() {
        this.montaTela();
        this.tableRequisicoes.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127 && ExportacaoSoc.this.tableRequisicoes.getSelectedRow() > -1) {
                    ExportacaoSoc.this.excluirRequisicao();
                }
            }
        });
    }

    private void montaTela() {
        this.setLayout(new BorderLayout());
        Funcoes.criaBarraDescricao(this, "Exportar SOC", "Exporta\u00e7\u00e3o de resultados para sistema SOC", "integracao/export_result_soc.jpg");
        JPanel panelAux = new JPanel();
        panelAux.setLayout(new BorderLayout());
        this.add((Component)panelAux, "Center");
        JPanel panel = new JPanel();
        panelAux.add((Component)panel, "North");
        panel.setBorder(BorderFactory.createTitledBorder("Filtro"));
        panel.setLayout(new GridBagLayout());
        Dimension dim = new Dimension(175, 20);
        this.itemColeta = new CheckItemFiltro("Coleta", "Filtrar", "Filtrando coletas", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemColeta.setDados("coletas", new String[]{"col_codigo", "col_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemColeta.setColunaHint(1);
        this.itemColeta.setPreferredSize(dim);
        this.itemColeta.setMinimumSize(dim);
        this.itemConvenio = new CheckItemFiltro("Conv\u00eanio", "Filtrar", "Filtrando conv\u00eanios", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemConvenio.setDados("convenios", new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Fantasia"}, new int[]{70, 0});
        this.itemConvenio.setColunaHint(1);
        this.itemConvenio.setPreferredSize(dim);
        this.itemColeta.setMinimumSize(dim);
        this.itemRelacionamento = ComponenteFactory.novoJCheckBox("Apenas exames com relacionamento", this);
        this.itemExame = new CheckItemFiltro("Exame", "Filtrar", "Filtrando exames", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemExame.setDados("exames", new String[]{"exa_codigo", "exa_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemExame.setColunaHint(1);
        this.itemExame.setPreferredSize(dim);
        this.itemExame.setMinimumSize(dim);
        this.itemDestino = new CheckItemFiltro("Destino", "Filtrar", "Filtrando destinos", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemDestino.setDados("destino", new String[]{"des_codigo", "des_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemDestino.setColunaHint(1);
        this.itemDestino.setPreferredSize(dim);
        this.itemDestino.setMinimumSize(dim);
        this.textDataIni.setPreferredSize(new Dimension(100, 20));
        this.textDataIni.setMinimumSize(new Dimension(100, 20));
        this.buttonDataIni.setFocusable(false);
        this.buttonDataIni.setPreferredSize(new Dimension(20, 20));
        this.buttonDataIni.setMinimumSize(new Dimension(20, 20));
        this.textDataFin.setPreferredSize(new Dimension(100, 20));
        this.textDataFin.setMinimumSize(new Dimension(100, 20));
        this.buttonDataFin.setFocusable(false);
        this.buttonDataFin.setPreferredSize(new Dimension(20, 20));
        this.buttonDataFin.setMinimumSize(new Dimension(20, 20));
        this.splitCentral.setBorder(null);
        this.splitCentral.setDividerSize(3);
        this.splitCentral.setDividerLocation(this.posicaoDivisor);
        this.tableRequisicoes.getColumnModel().getColumn(0).setMinWidth(70);
        this.tableRequisicoes.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                try {
                    ExportacaoSoc.this.modeloExames.clear();
                    if (ExportacaoSoc.this.tableRequisicoes.getSelectedRow() > -1 && ExportacaoSoc.this.modeloRequisicoes.getValueAt(ExportacaoSoc.this.tableRequisicoes.getSelectedRow(), 3) != null && ExportacaoSoc.this.modeloRequisicoes.getValueAt(ExportacaoSoc.this.tableRequisicoes.getSelectedRow(), 3) instanceof ArrayList) {
                        ArrayList exames = (ArrayList)ExportacaoSoc.this.modeloRequisicoes.getValueAt(ExportacaoSoc.this.tableRequisicoes.getSelectedRow(), 3);
                        for (int i = 0; i < exames.size(); ++i) {
                            Registro r = (Registro)exames.get(i);
                            ExportacaoSoc.this.modeloExames.addLine(new Object[]{r.getString("exa_codigo"), r.getString("mco_abreviatura"), r.getString("exa_descricao"), r.getString("exr_situacao"), r.getBoolean("enviado")});
                        }
                    }
                }
                catch (Exception e1) {
                    ErrorLogger.mostraMensagem(ExportacaoSoc.this, e1.getMessage(), e1.getStackTrace());
                }
            }
        });
        this.rendererExames = new DefaultTableCellRenderer(){

            @Override
            public synchronized Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focused, int row, int column) {
                Component c = super.getTableCellRendererComponent(table, value, selected, focused, row, column);
                this.setValue(value);
                if (selected) {
                    this.setForeground(table.getSelectionForeground());
                    this.setBackground(table.getSelectionBackground());
                } else {
                    this.setForeground(table.getForeground());
                    this.setBackground(table.getBackground());
                }
                if (focused) {
                    Border border = selected ? UIManager.getBorder("Table.focusSelectedCellHighlightBorder") : UIManager.getBorder("Table.focusCellHighlightBorder");
                    ((JComponent)c).setBorder(border);
                    if (!selected && table.isCellEditable(row, column)) {
                        Color col = UIManager.getColor("Table.focusCellForeground");
                        if (col != null) {
                            c.setForeground(col);
                        }
                        if ((col = UIManager.getColor("Table.focusCellBackground")) != null) {
                            c.setBackground(col);
                        }
                    }
                } else {
                    ((JComponent)c).setBorder(noFocusBorder);
                }
                if (ExportacaoSoc.this.tableRequisicoes.getSelectedRow() > -1 && ExportacaoSoc.this.modeloRequisicoes.getValueAt(ExportacaoSoc.this.tableRequisicoes.getSelectedRow(), 3) != null && ExportacaoSoc.this.modeloRequisicoes.getValueAt(ExportacaoSoc.this.tableRequisicoes.getSelectedRow(), 3) instanceof ArrayList) {
                    ArrayList exames = (ArrayList)ExportacaoSoc.this.modeloRequisicoes.getValueAt(ExportacaoSoc.this.tableRequisicoes.getSelectedRow(), 3);
                    for (int i = 0; i < exames.size(); ++i) {
                        Registro r = (Registro)exames.get(i);
                        if ((!r.getString("exa_codigo").equalsIgnoreCase((String)ExportacaoSoc.this.modeloExames.getValueAt(row, column)) || !Funcoes.textoVazio(r.getString("xml"))) && !Funcoes.textoVazio(StringUtil.getValor(r.getString("xml"), "soc"))) continue;
                        c.setBackground(ExportacaoSoc.this.COR_SEM_RELACIONAMENTO);
                        if (selected) {
                            c.setBackground(ScreenUtil.escurecerCor(ExportacaoSoc.this.COR_SEM_RELACIONAMENTO, 25));
                            break;
                        }
                        c.setBackground(ExportacaoSoc.this.COR_SEM_RELACIONAMENTO);
                        break;
                    }
                }
                return c;
            }
        };
        this.rendererRequisicoes = new DefaultTableCellRenderer(){

            @Override
            public synchronized Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focused, int row, int column) {
                Component c = super.getTableCellRendererComponent(table, value, selected, focused, row, column);
                this.setValue(value);
                if (selected) {
                    this.setForeground(table.getSelectionForeground());
                    this.setBackground(table.getSelectionBackground());
                } else {
                    this.setForeground(table.getForeground());
                    this.setBackground(table.getBackground());
                }
                if (ExportacaoSoc.this.modeloRequisicoes.getValueAt(row, 2) == null || Funcoes.textoVazio((String)ExportacaoSoc.this.modeloRequisicoes.getValueAt(row, 2))) {
                    if (selected) {
                        c.setBackground(ScreenUtil.escurecerCor(ExportacaoSoc.this.COR_SEM_EMPRESA, 25));
                    } else {
                        c.setBackground(ExportacaoSoc.this.COR_SEM_EMPRESA);
                    }
                }
                if (focused) {
                    Border border = selected ? UIManager.getBorder("Table.focusSelectedCellHighlightBorder") : UIManager.getBorder("Table.focusCellHighlightBorder");
                    ((JComponent)c).setBorder(border);
                    if (!selected && table.isCellEditable(row, column)) {
                        Color col = UIManager.getColor("Table.focusCellForeground");
                        if (col != null) {
                            c.setForeground(col);
                        }
                        if ((col = UIManager.getColor("Table.focusCellBackground")) != null) {
                            c.setBackground(col);
                        }
                    }
                } else {
                    ((JComponent)c).setBorder(noFocusBorder);
                }
                return c;
            }
        };
        this.tableRequisicoes.setDefaultRenderer(Object.class, this.rendererRequisicoes);
        this.tableExames.setDefaultRenderer(Object.class, this.rendererExames);
        GridBagConstraints cons = new GridBagConstraints();
        cons.fill = 0;
        cons.anchor = 17;
        cons.gridwidth = 1;
        cons.gridheight = 1;
        cons.gridx = 0;
        cons.gridy = 0;
        panel.add((Component)this.itemColeta, cons);
        cons.gridx = 0;
        cons.gridy = 1;
        panel.add((Component)this.itemConvenio, cons);
        cons.gridx = 0;
        cons.gridy = 2;
        cons.gridwidth = 2;
        panel.add((Component)this.itemRelacionamento, cons);
        cons.gridx = 1;
        cons.gridy = 0;
        cons.gridwidth = 1;
        cons.insets = new Insets(0, 20, 0, 0);
        panel.add((Component)this.itemDestino, cons);
        cons.gridx = 1;
        cons.gridy = 1;
        panel.add((Component)this.itemExame, cons);
        cons.gridx = 2;
        cons.gridy = 0;
        panel.add((Component)this.labelDataIni, cons);
        cons.gridx = 2;
        cons.gridy = 1;
        panel.add((Component)this.labelDataFin, cons);
        cons.gridx = 3;
        cons.gridy = 0;
        cons.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)this.textDataIni, cons);
        cons.gridx = 3;
        cons.gridy = 1;
        panel.add((Component)this.textDataFin, cons);
        cons.gridx = 4;
        cons.gridy = 0;
        panel.add((Component)this.buttonDataIni, cons);
        cons.gridx = 4;
        cons.gridy = 1;
        panel.add((Component)this.buttonDataFin, cons);
        cons.gridx = 3;
        cons.gridwidth = 3;
        cons.weightx = 1.0;
        cons.gridy = 2;
        cons.anchor = 13;
        cons.gridwidth = 2;
        panel.add((Component)this.buttonConsultar, cons);
        panelAux.add((Component)this.splitCentral, "Center");
        panelAux = new JPanel(new BorderLayout());
        this.add((Component)panelAux, "South");
        this.montaPanelLegenda(this.panelLegendas);
        panelAux.add((Component)this.panelLegendas, "West");
        JPanel panelBotoes = new JPanel(new FlowLayout(2, 3, 3));
        panelBotoes.add(this.buttonNovo);
        panelBotoes.add(this.buttonConfigurar);
        panelBotoes.add(this.buttonExportar);
        panelBotoes.add(this.buttonFechar);
        panelAux.add((Component)panelBotoes, "East");
        this.panelRequisicoes.setBorder(BorderFactory.createTitledBorder("Requisi\u00e7\u00f5es"));
        this.panelRequisicoes.add((Component)this.scrollRequisicoes, "Center");
        this.panelExames.setBorder(BorderFactory.createTitledBorder("Exames"));
        this.panelExames.add((Component)this.scrollExames, "Center");
        this.textDataIni.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    ExportacaoSoc.this.buttonDataIni.doClick();
                }
            }
        });
        this.textDataFin.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    ExportacaoSoc.this.buttonDataFin.doClick();
                }
            }
        });
        this.carregarParametros();
        Funcoes.montaEnter((JComponent)this);
    }

    private JPanel montaPanelLegenda(JPanel pnlLegenda) {
        if (pnlLegenda == null) {
            pnlLegenda = new JPanel(new GridBagLayout());
        } else if (!(pnlLegenda.getLayout() instanceof GridBagLayout)) {
            pnlLegenda.setLayout(new GridBagLayout());
        }
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 0.0;
        c.weighty = 0.0;
        JPanel pnlCorLegenda = new JPanel();
        pnlCorLegenda.setPreferredSize(new Dimension(10, 10));
        pnlCorLegenda.setBackground(this.COR_SEM_EMPRESA);
        pnlCorLegenda.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
        pnlLegenda.add((Component)pnlCorLegenda, c);
        JLabel lblLegenda = new JLabel("Paciente sem c\u00f3digo da empresa");
        Font font = new Font(lblLegenda.getFont().getName(), 0, 10);
        lblLegenda.setFont(font);
        ++c.gridx;
        pnlLegenda.add((Component)lblLegenda, c);
        ++c.gridx;
        c.insets = new Insets(1, 10, 1, 1);
        pnlCorLegenda = new JPanel();
        pnlCorLegenda.setPreferredSize(new Dimension(10, 10));
        pnlCorLegenda.setBackground(this.COR_SEM_RELACIONAMENTO);
        pnlCorLegenda.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
        pnlLegenda.add((Component)pnlCorLegenda, c);
        lblLegenda = new JLabel("Exame sem relacionamento");
        lblLegenda.setFont(font);
        c.insets = new Insets(1, 1, 1, 1);
        ++c.gridx;
        pnlLegenda.add((Component)lblLegenda, c);
        return pnlLegenda;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.buttonFechar) {
            this.setVisible(false);
            if (this.getParent() != null) {
                this.getParent().removeAll();
            }
        } else if (o == this.buttonNovo) {
            this.modeloRequisicoes.clear();
            this.modeloExames.clear();
            this.requisicoes.clear();
            this.textDataIni.setText("");
            this.textDataFin.setText("");
            this.itemColeta.clear();
            this.itemConvenio.clear();
            this.itemDestino.clear();
            this.itemExame.clear();
        } else if (o == this.buttonConfigurar) {
            this.configurar();
        } else if (o == this.buttonConsultar) {
            this.consultarRequisicoes();
            this.gravarParametros(true);
        } else if (o == this.buttonExportar) {
            try {
                this.exportar();
                this.gravarParametros(true);
            }
            catch (ParseException e1) {
                ErrorLogger.mostraMensagem(this, e1.getMessage(), e1.getStackTrace());
            }
        } else if (o == this.buttonDataIni) {
            Funcoes.mostraData(this.textDataIni, this.buttonDataIni, (JPanel)this.buttonDataIni.getParent(), false);
        } else if (o == this.buttonDataFin) {
            Funcoes.mostraData(this.textDataFin, this.buttonDataFin, (JPanel)this.buttonDataFin.getParent(), false);
        }
    }

    private void configurar() {
        ConfigurarCodigos config = new ConfigurarCodigos((Frame)Laboratorio.getInstancia(), "Configurando SOC");
        config.setValores(this.auxMedico, this.auxExaminador, this.auxPrestador);
        config.setVisible(true);
        if (config.getOK()) {
            this.auxMedico = config.getCodigoMedico();
            this.auxExaminador = config.getCodigoExaminador();
            this.auxPrestador = config.getCodigoPrestador();
        }
    }

    public static long getModuloAcesso() {
        return ACESSO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void consultarRequisicoes() {
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        try {
            this.modeloRequisicoes.clear();
            this.requisicoes.clear();
            this.habilitarDesabilitar(false);
            if (st != null) {
                ResultSet rs = Conexao.executeQuery(st, this.getSelectRequisicao());
                while (rs.next()) {
                    ArrayList<Registro> exames = this.pegaExamesRequisicao(st2, rs.getString("req_codigo"));
                    ArrayList<Registro> examesRel = new ArrayList<Registro>();
                    for (Registro re : exames) {
                        String xmlResultado = this.getXmlResultado(st2, rs.getString("req_codigo"), re.getString("exa_codigo"), re.getInt("mco_codigo"));
                        String xml = ExameUtil.pegaRelacionamentoExportaTextoIdade(Variaveis.filialPadrao, rs.getInt("req_idade"), rs.getString("req_anomes"), ExameUtil.getCodigoLayout(Variaveis.filialPadrao, rs.getString("con_codigo"), rs.getString("des_codigo")), re.getString("exa_codigo"), re.getInt("mco_codigo"), re.getString("met_codigo"));
                        re.setValor("xmlResultado", xmlResultado);
                        re.setValor("xml", xml);
                        if (!this.itemRelacionamento.isSelected()) {
                            examesRel.add(re);
                            continue;
                        }
                        if (Funcoes.textoVazio(xml)) continue;
                        examesRel.add(re);
                    }
                    this.requisicoes.add(new Registro(rs));
                    this.modeloRequisicoes.addLine(new Object[]{rs.getString("req_codigo"), rs.getString("pac_nome"), rs.getString("ent_xmlintegracao"), examesRel});
                }
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
        }
        finally {
            this.habilitarDesabilitar(true);
        }
    }

    private void carregarParametros() {
        if (ParametrosUsuarios.contemParametro(ULTIMO_FILTRO)) {
            String str = StringUtil.getValor(ParametrosUsuarios.getValor(ULTIMO_FILTRO), "filtro");
            this.setAtributosFiltro(this.itemColeta, StringUtil.getValor(str, "coleta"));
            this.setAtributosFiltro(this.itemConvenio, StringUtil.getValor(str, "convenio"));
            this.setAtributosFiltro(this.itemDestino, StringUtil.getValor(str, "destino"));
            this.setAtributosFiltro(this.itemExame, StringUtil.getValor(str, "exame"));
            this.textDataIni.setText(StringUtil.getValor(str, "dataInicial"));
            this.textDataFin.setText(StringUtil.getValor(str, "dataFinal"));
            if (!Funcoes.textoVazio(StringUtil.getValor(str, POSICAO_DIVISOR))) {
                this.posicaoDivisor = Integer.parseInt(Funcoes.textoVazio(StringUtil.getValor(str, POSICAO_DIVISOR)) ? "350" : StringUtil.getValor(str, POSICAO_DIVISOR));
            }
            if (!Funcoes.textoVazio(StringUtil.getValor(str, CODIGO_MEDICO))) {
                this.auxMedico = StringUtil.getValor(str, CODIGO_MEDICO);
            }
            if (!Funcoes.textoVazio(StringUtil.getValor(str, CODIGO_EXAMINADOR))) {
                this.auxExaminador = StringUtil.getValor(str, CODIGO_EXAMINADOR);
            }
            if (!Funcoes.textoVazio(StringUtil.getValor(str, CODIGO_PRESTADOR))) {
                this.auxPrestador = StringUtil.getValor(str, CODIGO_PRESTADOR);
            }
        }
    }

    private void gravarParametros(boolean executarCommitParametros) {
        StringBuilder bui = new StringBuilder();
        bui.append("<filtro>");
        bui.append(this.getAtributosFiltro(this.itemColeta, "coleta"));
        bui.append(this.getAtributosFiltro(this.itemConvenio, "convenio"));
        bui.append(this.getAtributosFiltro(this.itemDestino, "destino"));
        bui.append(this.getAtributosFiltro(this.itemExame, "exame"));
        bui.append(StringUtil.getTag("dataInicial", this.textDataIni.getText()));
        bui.append(StringUtil.getTag("dataFinal", this.textDataFin.getText()));
        bui.append(StringUtil.getTag(POSICAO_DIVISOR, String.valueOf(this.splitCentral.getDividerLocation())));
        if (this.auxMedico != null) {
            bui.append(StringUtil.getTag(CODIGO_MEDICO, this.auxMedico));
        }
        if (this.auxExaminador != null) {
            bui.append(StringUtil.getTag(CODIGO_EXAMINADOR, this.auxExaminador));
        }
        if (this.auxPrestador != null) {
            bui.append(StringUtil.getTag(CODIGO_PRESTADOR, this.auxPrestador));
        }
        bui.append("</filtro>");
        ParametrosUsuarios.setValor(ULTIMO_FILTRO, bui.toString());
        ParametrosUsuarios.salvarParametros(executarCommitParametros);
    }

    private void habilitarDesabilitar(boolean valor) {
        if (this.tableExames != null) {
            this.tableExames.setEnabled(valor);
        }
        this.tableRequisicoes.setEnabled(valor);
        this.itemColeta.setEnabled(valor);
        this.itemConvenio.setEnabled(valor);
        this.itemDestino.setEnabled(valor);
        this.itemExame.setEnabled(valor);
        this.itemRelacionamento.setEnabled(valor);
        this.buttonConsultar.setEnabled(valor);
        this.buttonDataFin.setEnabled(valor);
        this.buttonDataIni.setEnabled(valor);
        this.buttonNovo.setEnabled(valor);
        this.buttonExportar.setEnabled(valor);
        this.buttonFechar.setEnabled(valor);
        this.labelDataIni.setEnabled(valor);
        this.labelDataFin.setEnabled(valor);
        this.textDataFin.setEnabled(valor);
        this.textDataIni.setEnabled(valor);
    }

    private String getSelectRequisicao() {
        StringBuilder bui = new StringBuilder();
        try {
            bui.append(" select distinct pac.pac_nome ");
            bui.append("       ,req.req_data ");
            bui.append("       ,req.req_matricula ");
            bui.append("       ,sit.sit_xmlintegracao ");
            bui.append("       ,sit.sit_descricao ");
            bui.append("       ,req.req_codigo ");
            bui.append("       ,req.req_idade ");
            bui.append("       ,req.req_anomes ");
            bui.append("       ,req.con_codigo ");
            bui.append("       ,req.des_codigo ");
            bui.append("       ,ent.ent_xmlintegracao ");
            bui.append("   from requisicao req ");
            bui.append("   join examerequisicao exr on req.fil_codigo = exr.fil_codigo and req.req_codigo = exr.req_codigo ");
            bui.append("   join paciente pac on req.fil_codigo = pac.fil_codigo and req.pac_codigo = pac.pac_codigo ");
            bui.append("   left join entidade ent on pac.fil_codigo = ent.fil_codigo and pac.ent_codempresa = ent.ent_codigo ");
            bui.append("   left join situacao sit on req.fil_codigo = sit.fil_codigo and req.sit_codigo = sit.sit_codigo ");
            bui.append("  where req.fil_codigo = ").append(Variaveis.filialPadrao);
            bui.append("    and req.req_excluida = false ");
            if (Funcoes.verificaData(this.textDataIni.getText())) {
                bui.append(" and req.req_data >= '").append(Funcoes.formataData("yyyy-MM-dd", this.textDataIni.getText())).append("' ");
            }
            if (Funcoes.verificaData(this.textDataFin.getText())) {
                bui.append(" and req.req_data <= '").append(Funcoes.formataData("yyyy-MM-dd", this.textDataFin.getText())).append("' ");
            }
            if (this.itemColeta.isSelected()) {
                this.addExpressao(bui, ExportacaoSoc.getExpressao("req.col_codigo", this.itemColeta.getSelecionados(0), true));
            }
            if (this.itemConvenio.isSelected()) {
                this.addExpressao(bui, ExportacaoSoc.getExpressao("req.con_codigo", this.itemConvenio.getSelecionados(0), false));
            }
            if (this.itemDestino.isSelected()) {
                this.addExpressao(bui, ExportacaoSoc.getExpressao("req.des_codigo", this.itemDestino.getSelecionados(0), true));
            }
            if (this.itemExame.isSelected()) {
                this.addExpressao(bui, ExportacaoSoc.getExpressao("exr.exa_codigo", this.itemExame.getSelecionados(0), true));
            }
            bui.append(" order by pac.pac_nome ");
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
        }
        return bui.toString();
    }

    private ArrayList<Registro> pegaExamesRequisicao(Statement st, String requisicao) throws Exception {
        ArrayList<Registro> retorno = new ArrayList<Registro>();
        StringBuilder buf = new StringBuilder();
        buf.append(" select emc.emc_codigoamb ");
        buf.append("       ,exa.exa_descricao ");
        buf.append("       ,exr.exr_situacao <> '").append("C").append("' as emAnalise ");
        buf.append("       ,exr.exa_codigo ");
        buf.append("       ,exr.mco_codigo ");
        buf.append("       ,exr.met_codigo ");
        buf.append("       ,mco.mco_abreviatura ");
        buf.append("       ,exr.exr_situacao ");
        buf.append("       ,exr.exr_datadigita ");
        buf.append("   from examerequisicao exr ");
        buf.append("   join materialcoleta mco on exr.fil_codigo = mco.fil_codigo and exr.mco_codigo = mco.mco_codigo ");
        buf.append("   join examematcoleta emc on exr.fil_codigo = emc.fil_codigo and exr.mco_codigo = emc.mco_codigo and exr.exa_codigo = emc.exa_codigo ");
        buf.append("   join exames exa on exr.fil_codigo = exa.fil_codigo and exr.exa_codigo = exa.exa_codigo ");
        buf.append("  where exr.fil_codigo = ").append(Variaveis.filialPadrao);
        buf.append("    and exr.req_codigo = ").append(requisicao);
        buf.append("    and exr.exr_excluido = false ");
        if (this.itemExame.isSelected()) {
            this.addExpressao(buf, ExportacaoSoc.getExpressao("exr.exa_codigo", this.itemExame.getSelecionados(0), true));
        }
        ResultSet rs = Conexao.executeQuery(st, buf);
        while (rs.next()) {
            retorno.add(new Registro(rs));
        }
        return retorno;
    }

    private void addExpressao(StringBuilder bui, String exp) {
        if (exp != null && exp.length() > 0) {
            if (bui.length() > 0) {
                bui.append("and ");
            }
            bui.append(exp);
            bui.append(' ');
        }
    }

    public static String getExpressao(String campo, String[] valores, boolean aspas) {
        if (campo != null && valores != null && valores.length > 0) {
            StringBuilder buf = new StringBuilder("(");
            for (int i = 0; i < valores.length; ++i) {
                if (i > 0) {
                    buf.append(" or ");
                }
                buf.append(campo);
                buf.append(" = ");
                if (aspas) {
                    buf.append('\'');
                }
                buf.append(valores[i]);
                if (!aspas) continue;
                buf.append('\'');
            }
            return buf.append(")").toString();
        }
        return "";
    }

    private String getAtributosFiltro(CheckItemFiltro item, String nome) {
        StringBuilder bui = new StringBuilder();
        bui.append(StringUtil.getTag("sel", String.valueOf(item.isSelected())));
        bui.append(StringUtil.getTag("item", item.getSelecionados(0)));
        return StringUtil.getTag(nome, bui.toString());
    }

    private void setAtributosFiltro(CheckItemFiltro item, String atributos) {
        if (StringUtil.getBoolean(atributos, "sel")) {
            item.setSelected(true);
            item.setSelecionados(StringUtil.getValores(atributos, "item"));
        }
    }

    private void excluirRequisicao() {
        if (Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            if (this.tableRequisicoes.getSelectedRow() == -1) {
                return;
            }
            this.requisicoes.remove(this.tableRequisicoes.getSelectedRow());
            this.modeloRequisicoes.removeLine(this.tableRequisicoes.getSelectedRow());
            this.tableRequisicoes.revalidate();
            this.tableRequisicoes.repaint();
        }
    }

    private String getXmlResultado(Statement st, String requisicao, String exame, int materialColetado) {
        try {
            StringBuilder buf = new StringBuilder();
            buf.append(" select pegaResultadoExame(fil_codigo, req_codigo, exa_codigo, mco_codigo) as exr_resultado ");
            buf.append("   from examerequisicao ");
            buf.append("  where fil_codigo = ").append(Variaveis.filialPadrao);
            buf.append("    and req_codigo = ").append(requisicao);
            buf.append("    and exa_codigo = '").append(exame).append("' ");
            buf.append("    and mco_codigo = ").append(materialColetado);
            buf.append("    and exr_excluido = false ");
            ResultSet rs = Conexao.executeQuery(st, buf);
            if (rs.next()) {
                return rs.getString("exr_resultado");
            }
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
        }
        return "";
    }

    private String getXmlResultadoAnterior(String requisicao, String exame, int materialColetado) {
        try {
            StringBuilder buf = new StringBuilder();
            buf.append(" select pegaResultadoExame(fil_codigo, req_codigo, exa_codigo, mco_codigo) as exr_resultado ");
            buf.append("   from examerequisicao ");
            buf.append("  where fil_codigo = ").append(Variaveis.filialPadrao);
            buf.append("    and req_codigo < ").append(requisicao);
            buf.append("    and exa_codigo = '").append(exame).append("' ");
            buf.append("    and mco_codigo = ").append(materialColetado);
            buf.append("    and exr_excluido = false ");
            buf.append("  order by req_codigo desc ");
            buf.append("  limit 1 ");
            ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), buf);
            if (rs.next()) {
                return rs.getString("exr_resultado");
            }
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
        }
        return null;
    }

    public void pressioneiF2() {
        if (this.textDataIni.hasFocus()) {
            Funcoes.mostraData(this.textDataIni, this.buttonDataIni, this, true);
        } else if (this.textDataFin.hasFocus()) {
            Funcoes.mostraData(this.textDataFin, this.buttonDataFin, this, true);
        }
    }

    private void exportar() throws ParseException {
        if (this.requisicoes != null && this.requisicoes.size() > 0) {
            Registro r;
            int linha;
            ArrayList<String> requisicoesSemResultado = new ArrayList<String>();
            boolean ignorar = false;
            StringBuilder conteudo = new StringBuilder();
            conteudo.append(this.escreveCabecalho());
            for (linha = 0; linha < this.requisicoes.size(); ++linha) {
                r = this.requisicoes.get(linha);
                String xml = r.getString("ent_xmlintegracao");
                if (xml != null && !Funcoes.textoVazio(xml)) continue;
                Funcoes.mensagem(this, "H\u00e1 pacientes sem empresa configurada ou empresas sem c\u00f3digo de integra\u00e7\u00e3o.\nN\u00e3o \u00e9 poss\u00edvel exportar os dados.", 2);
                return;
            }
            for (linha = 0; linha < this.requisicoes.size(); ++linha) {
                r = this.requisicoes.get(linha);
                try {
                    String requisicao = r.getString("req_codigo");
                    ArrayList exames = (ArrayList)this.modeloRequisicoes.getValueAt(linha, 3);
                    for (Registro re : exames) {
                        DadosLinha dadosLinha = new DadosLinha();
                        String xmlResultado = re.getString("xmlResultado");
                        String xml = re.getString("xml");
                        if (Funcoes.textoVazio(xml) || Funcoes.textoVazio(StringUtil.getValor(xml, "soc"))) {
                            if (ignorar || (ignorar = Funcoes.mensagem(this, "A exporta\u00e7\u00e3o possui exames sem relacionamento!\nDeseja ignorar exames sem relacionamento?", 4) == 0)) continue;
                            Funcoes.mensagem(this, "Exporta\u00e7\u00e3o abortada.", 2);
                            return;
                        }
                        if (Funcoes.textoVazio(xmlResultado)) {
                            requisicoesSemResultado.add("|" + Funcoes.preencheVazio(requisicao, 11, 1) + " | " + Funcoes.preencheVazio(re.getString("exa_codigo") + "-" + re.getString("exa_descricao"), 39, 2) + "|");
                            continue;
                        }
                        Map<String, Object> camposResultado = Resultado.getCamposResultado(xmlResultado, false);
                        String xmlSituacao = r.getString("sit_xmlintegracao");
                        if (xmlSituacao != null && !Funcoes.textoVazio(xmlSituacao)) {
                            xmlSituacao = StringUtil.getValor(xmlSituacao, "soc");
                        }
                        Digitacao digitacao = new Digitacao();
                        digitacao.carregarCampos(xmlResultado);
                        boolean exameAlterado = digitacao.possuiCamposForaDaReferencia();
                        String xmlResultadoAnterior = this.getXmlResultadoAnterior(requisicao, re.getString("exa_codigo"), re.getInt("mco_codigo"));
                        boolean agravamento = false;
                        if (xmlResultadoAnterior != null) {
                            digitacao.carregarCampos(xmlResultadoAnterior);
                            boolean aux = digitacao.possuiCamposForaDaReferencia();
                            if (!aux && exameAlterado) {
                                agravamento = true;
                            }
                        }
                        if (r.getString("req_matricula") == null || Funcoes.textoVazio(r.getString("req_matricula"))) {
                            Funcoes.mensagem(this, "O campo " + ConfiguradorExportacaoSoc.GERAL_IDENTIFICACAO_FUNCIONARIO.descricao + " n\u00e3o pode ser preenchido.\nFuncion\u00e1rio: \"" + r.getString("pac_nome") + "\" - Requisi\u00e7\u00e3o: " + r.getString("req_codigo") + ".\nConfigure a matr\u00edcula na requisi\u00e7\u00e3o.\nN\u00e3o \u00e9 poss\u00edvel gerar o arquivo.", 2);
                            return;
                        }
                        if (re.getString("emc_codigoamb") == null || Funcoes.textoVazio(re.getString("emc_codigoamb"))) {
                            Funcoes.mensagem(this, "O campo " + ConfiguradorExportacaoSoc.GERAL_CODIGO_EXAME.descricao + " n\u00e3o pode ser preenchido.\nExame: " + re.getString("exa_codigo") + ", material: " + re.getString("mco_codigo") + ".\nN\u00e3o \u00e9 poss\u00edvel gerar o arquivo.", 2);
                            return;
                        }
                        if (xmlSituacao == null || Funcoes.textoVazio(xmlSituacao)) {
                            Funcoes.mensagem(this, "O campo " + ConfiguradorExportacaoSoc.GERAL_TIPO_EXAME.descricao + " n\u00e3o pode ser preenchido.\nSitua\u00e7\u00e3o: \"" + r.getString("sit_descricao") + "\".\nVerifique as configura\u00e7\u00f5es do campo Situa\u00e7\u00e3o da requisi\u00e7\u00e3o: " + r.getString("req_codigo") + ".\nN\u00e3o \u00e9 poss\u00edvel gerar o arquivo.", 2);
                            return;
                        }
                        try {
                            String empresa = r.getString("ent_xmlintegracao");
                            if (empresa != null && !Funcoes.textoVazio(empresa)) {
                                empresa = StringUtil.getValor(empresa, "soc");
                            }
                            dadosLinha.add(ConfiguradorExportacaoSoc.GERAL_COD_EMPRESA, empresa);
                            dadosLinha.add(ConfiguradorExportacaoSoc.GERAL_IDENTIFICACAO_FUNCIONARIO, r.getString("req_matricula"));
                            dadosLinha.add(ConfiguradorExportacaoSoc.GERAL_NOME_FUNCIONARIO, r.getString("pac_nome"));
                            dadosLinha.add(ConfiguradorExportacaoSoc.GERAL_CODIGO_EXAME, re.getString("emc_codigoamb"));
                            dadosLinha.add(ConfiguradorExportacaoSoc.GERAL_NOME_EXAME, re.getString("exa_descricao"));
                            dadosLinha.add(ConfiguradorExportacaoSoc.GERAL_DATA_RES_EXAME, re.getDate("exr_datadigita"));
                            dadosLinha.add(ConfiguradorExportacaoSoc.GERAL_DATA_FICHA, r.getDate("req_data"));
                            dadosLinha.add(ConfiguradorExportacaoSoc.GERAL_MESES_PROXIMO_EXAME, 0);
                            dadosLinha.add(ConfiguradorExportacaoSoc.GERAL_EXAME_ALTERADO, exameAlterado);
                            dadosLinha.add(ConfiguradorExportacaoSoc.GERAL_EM_ANALISE, re.getBoolean("emAnalise"));
                            dadosLinha.add(ConfiguradorExportacaoSoc.GERAL_OCUPACIONAL, false);
                            dadosLinha.add(ConfiguradorExportacaoSoc.GERAL_AGRAVAMENTO, agravamento);
                            dadosLinha.add(ConfiguradorExportacaoSoc.GERAL_REF_SEQ_NAOAPLICA, "N");
                            dadosLinha.add(ConfiguradorExportacaoSoc.GERAL_TIPO_EXAME, xmlSituacao == null || Funcoes.textoVazio(xmlSituacao) ? null : Integer.valueOf(Integer.parseInt(xmlSituacao)));
                            dadosLinha.add(ConfiguradorExportacaoSoc.GERAL_OBSERVACAO, null);
                            dadosLinha.add(ConfiguradorExportacaoSoc.GERAL_COD_MEDICO, this.auxMedico);
                            dadosLinha.add(ConfiguradorExportacaoSoc.GERAL_COD_EXAMINADOR, this.auxExaminador);
                            dadosLinha.add(ConfiguradorExportacaoSoc.GERAL_PARECER_ASO, 0);
                            dadosLinha.add(ConfiguradorExportacaoSoc.GERAL_COD_PRESTADOR, this.auxPrestador);
                            dadosLinha.add(ConfiguradorExportacaoSoc.GERAL_LIVRE1, null);
                            dadosLinha.add(ConfiguradorExportacaoSoc.GERAL_LIVRE2, null);
                            dadosLinha.add(ConfiguradorExportacaoSoc.GERAL_LIVRE3, null);
                        }
                        catch (Exception e) {
                            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel escrever os dados.\n" + e.getMessage(), e.getStackTrace());
                        }
                        Hashtable<String, CampoResultado> hash = ConfiguradorExportacaoSoc.getRelacionamentoCampos(xml);
                        for (String s : hash.keySet()) {
                            try {
                                Object valorExame;
                                if (s != null && camposResultado.get(s.toLowerCase()) == null && s != null && s.indexOf("\"") < 0) {
                                    requisicoesSemResultado.add("|" + Funcoes.preencheVazio(requisicao, 11, 1) + " | " + Funcoes.preencheVazio(re.getString("exa_codigo") + "-" + re.getString("exa_descricao"), 39, 2) + "|");
                                    continue;
                                }
                                CampoResultado origem = hash.get(s);
                                CampoResultado auxCampo = this.buscaCampoResultado(hash.get(s).toString());
                                Object object = valorExame = s != null && s.indexOf("\"") > -1 && origem != null && !Funcoes.textoVazio(origem.origem) && origem.origem.indexOf("\"") > -1 ? origem.origem.replaceAll("\"", "") : camposResultado.get(s.toLowerCase());
                                if (valorExame instanceof String) {
                                    valorExame = valorExame.toString().replaceAll("\\<.[html]*[b]*[i]*[u]*[sub]*[sup]*\\>", "");
                                }
                                for (int i = 0; i < dadosLinha.lista.size(); ++i) {
                                    Dados aux = dadosLinha.lista.get(i);
                                    if (!aux.campo.descricao.equalsIgnoreCase(auxCampo.descricao)) continue;
                                    dadosLinha.lista.remove(i);
                                    break;
                                }
                                dadosLinha.add(auxCampo, valorExame);
                            }
                            catch (Exception origem) {}
                        }
                        if (dadosLinha == null || dadosLinha.lista.size() == 0) continue;
                        for (int pos = 0; pos < ConfiguradorExportacaoSoc.TAM_MAX; ++pos) {
                            Dados dados = null;
                            for (int i = 0; i < dadosLinha.lista.size(); ++i) {
                                Dados aux = dadosLinha.lista.get(i);
                                if (aux.campo.posicao > pos) break;
                                if (aux.campo.posicao != pos) continue;
                                dados = aux;
                                break;
                            }
                            try {
                                if (dados != null) {
                                    conteudo.append(this.getValor(dados.valor, dados.campo)).append(pos < ConfiguradorExportacaoSoc.TAM_MAX - 1 ? DEL : "");
                                    continue;
                                }
                                conteudo.append(DEL);
                                continue;
                            }
                            catch (Exception e) {
                                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel escrever dados associados.\n" + e.getMessage(), e.getStackTrace());
                            }
                        }
                        conteudo.append("\n");
                    }
                    continue;
                }
                catch (NullPointerException e) {
                    ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
                    ++linha;
                }
            }
            if (conteudo.length() > 0) {
                JFileChooser f = ComponenteFactory.novoJFileChooser();
                FileFilter flt = ComponenteFactory.novoFileFilter("(*.csv)", "csv");
                f.setFileFilter(flt);
                if (f.showSaveDialog(this) == 0) {
                    String arquivo = f.getSelectedFile().getAbsolutePath();
                    if (!arquivo.toLowerCase().endsWith(".csv")) {
                        arquivo = arquivo + ".csv";
                    }
                    try {
                        StringUtil.escreverArquivoTexto(arquivo, conteudo.toString());
                        Funcoes.mensagem(this, "Exporta\u00e7\u00e3o realizada com sucesso!", 5);
                    }
                    catch (Exception e) {
                        Funcoes.mensagem(null, "N\u00e3o foi poss\u00edvel exportar os dados para o arquivo " + arquivo + ".\nMensagem: " + e.getMessage(), 1);
                    }
                }
                if (requisicoesSemResultado.size() > 0) {
                    SemResultadoSoc sem = SemResultadoSoc.novaInstancia(this.getTopLevelAncestor());
                    sem.setLocationRelativeTo(this.getTopLevelAncestor());
                    sem.setRequisicoes(requisicoesSemResultado);
                    sem.setVisible(true);
                }
            } else {
                Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel realizar a exporta\u00e7\u00e3o", 5);
            }
        }
    }

    private CampoResultado buscaCampoResultado(String descricao) {
        int i;
        for (i = 0; i < ConfiguradorExportacaoSoc.CAMPOS_GERAL.length; ++i) {
            if (!ConfiguradorExportacaoSoc.CAMPOS_GERAL[i].toString().equalsIgnoreCase(descricao)) continue;
            return ConfiguradorExportacaoSoc.CAMPOS_GERAL[i];
        }
        for (i = 0; i < ConfiguradorExportacaoSoc.CAMPOS_AUDIOMETRIA.length; ++i) {
            if (!ConfiguradorExportacaoSoc.CAMPOS_AUDIOMETRIA[i].toString().equalsIgnoreCase(descricao)) continue;
            return ConfiguradorExportacaoSoc.CAMPOS_AUDIOMETRIA[i];
        }
        for (i = 0; i < ConfiguradorExportacaoSoc.CAMPOS_HEMOGRAMA.length; ++i) {
            if (!ConfiguradorExportacaoSoc.CAMPOS_HEMOGRAMA[i].toString().equalsIgnoreCase(descricao)) continue;
            return ConfiguradorExportacaoSoc.CAMPOS_HEMOGRAMA[i];
        }
        for (i = 0; i < ConfiguradorExportacaoSoc.CAMPOS_ERITROGRAMA.length; ++i) {
            if (!ConfiguradorExportacaoSoc.CAMPOS_ERITROGRAMA[i].toString().equalsIgnoreCase(descricao)) continue;
            return ConfiguradorExportacaoSoc.CAMPOS_ERITROGRAMA[i];
        }
        for (i = 0; i < ConfiguradorExportacaoSoc.CAMPOS_LEUCOGRAMA.length; ++i) {
            if (!ConfiguradorExportacaoSoc.CAMPOS_LEUCOGRAMA[i].toString().equalsIgnoreCase(descricao)) continue;
            return ConfiguradorExportacaoSoc.CAMPOS_LEUCOGRAMA[i];
        }
        for (i = 0; i < ConfiguradorExportacaoSoc.CAMPOS_URINA.length; ++i) {
            if (!ConfiguradorExportacaoSoc.CAMPOS_URINA[i].toString().equalsIgnoreCase(descricao)) continue;
            return ConfiguradorExportacaoSoc.CAMPOS_URINA[i];
        }
        return null;
    }

    private String escreveCabecalho() {
        int i;
        StringBuilder buf = new StringBuilder();
        buf.append("Importar Multi-Empresas (Com Prestador)");
        for (i = 0; i < ConfiguradorExportacaoSoc.CAMPOS_GERAL.length; ++i) {
            buf.append(DEL);
        }
        for (i = 0; i < ConfiguradorExportacaoSoc.CAMPOS_URINA.length; ++i) {
            buf.append(ConfiguradorExportacaoSoc.CAMPOS_URINA[i].descricao).append(i < ConfiguradorExportacaoSoc.CAMPOS_URINA.length - 1 ? DEL : "");
        }
        buf.append("\n");
        for (i = 0; i < ConfiguradorExportacaoSoc.CAMPOS_GERAL.length; ++i) {
            buf.append(ConfiguradorExportacaoSoc.CAMPOS_GERAL[i].descricao).append(DEL);
        }
        for (i = 0; i < ConfiguradorExportacaoSoc.CAMPOS_AUDIOMETRIA.length; ++i) {
            buf.append(ConfiguradorExportacaoSoc.CAMPOS_AUDIOMETRIA[i].descricao).append(i < ConfiguradorExportacaoSoc.CAMPOS_AUDIOMETRIA.length - 1 ? DEL : "");
        }
        buf.append("\n");
        for (i = 0; i < ConfiguradorExportacaoSoc.CAMPOS_GERAL.length - 4; ++i) {
            buf.append(ConfiguradorExportacaoSoc.CAMPOS_GERAL[i].descricao).append(i < ConfiguradorExportacaoSoc.CAMPOS_GERAL.length - 1 ? DEL : "");
        }
        buf.append(DEL).append(DEL).append(DEL).append(DEL);
        for (i = 0; i < ConfiguradorExportacaoSoc.CAMPOS_HEMOGRAMA.length; ++i) {
            buf.append(ConfiguradorExportacaoSoc.CAMPOS_HEMOGRAMA[i].descricao).append(i < ConfiguradorExportacaoSoc.CAMPOS_HEMOGRAMA.length - 1 ? DEL : "");
        }
        buf.append("\n");
        for (i = 0; i < ConfiguradorExportacaoSoc.CAMPOS_GERAL.length - 4; ++i) {
            buf.append(ConfiguradorExportacaoSoc.CAMPOS_GERAL[i].descricao).append(i < ConfiguradorExportacaoSoc.CAMPOS_GERAL.length - 1 ? DEL : "");
        }
        buf.append(DEL).append(DEL).append(DEL).append(DEL);
        for (i = 0; i < ConfiguradorExportacaoSoc.CAMPOS_ERITROGRAMA.length; ++i) {
            buf.append(ConfiguradorExportacaoSoc.CAMPOS_ERITROGRAMA[i].descricao).append(i < ConfiguradorExportacaoSoc.CAMPOS_ERITROGRAMA.length - 1 ? DEL : "");
        }
        buf.append("\n");
        for (i = 0; i < ConfiguradorExportacaoSoc.CAMPOS_GERAL.length - 4; ++i) {
            buf.append(ConfiguradorExportacaoSoc.CAMPOS_GERAL[i].descricao).append(i < ConfiguradorExportacaoSoc.CAMPOS_GERAL.length - 1 ? DEL : "");
        }
        buf.append(DEL).append(DEL).append(DEL).append(DEL);
        for (i = 0; i < ConfiguradorExportacaoSoc.CAMPOS_LEUCOGRAMA.length; ++i) {
            buf.append(ConfiguradorExportacaoSoc.CAMPOS_LEUCOGRAMA[i].descricao).append(i < ConfiguradorExportacaoSoc.CAMPOS_LEUCOGRAMA.length - 1 ? DEL : "");
        }
        buf.append("\n");
        for (i = 0; i < ConfiguradorExportacaoSoc.CAMPOS_GERAL.length - 4; ++i) {
            buf.append(ConfiguradorExportacaoSoc.CAMPOS_GERAL[i].descricao).append(i < ConfiguradorExportacaoSoc.CAMPOS_GERAL.length - 1 ? DEL : "");
        }
        buf.append(DEL).append(DEL).append(DEL).append(DEL);
        for (i = 0; i < ConfiguradorExportacaoSoc.CAMPOS_PNEUMOLOGIA.length; ++i) {
            buf.append(ConfiguradorExportacaoSoc.CAMPOS_PNEUMOLOGIA[i].descricao).append(i < ConfiguradorExportacaoSoc.CAMPOS_PNEUMOLOGIA.length - 1 ? DEL : "");
        }
        buf.append("\n");
        return buf.toString();
    }

    private String substring(String str, int tamanho) {
        return str.substring(0, str.length() > tamanho ? tamanho : str.length());
    }

    private String getValor(Object valor, CampoResultado campo) throws Exception {
        if (campo == null) {
            throw new Exception("Campo n\u00e3o informado.");
        }
        if (valor == null && campo.obrigatorio.booleanValue()) {
            throw new Exception("Campo obrigat\u00f3rio sem valor. Campo: \"" + campo.descricao + "\".\nVerifique as configura\u00e7\u00f5es da exporta\u00e7\u00e3o para o SOC.");
        }
        if (valor == null && !campo.obrigatorio.booleanValue()) {
            if (campo.tipo.equals(CampoResultado.Tipo.NUMERO.codigo)) {
                return "0";
            }
            if (campo.tipo.equals(CampoResultado.Tipo.TEXTO.codigo)) {
                return "";
            }
            throw new Exception("O campo n\u00e3o pode ser nulo. Campo: \"" + campo.descricao + "\".");
        }
        if (campo.tipo.equals(CampoResultado.Tipo.NUMERO.codigo)) {
            if (valor instanceof Integer || valor instanceof Double || valor instanceof BigDecimal || valor instanceof String) {
                String aux = valor.toString().replaceAll(",", ".");
                aux = aux.replaceAll(DEL, ".");
                return this.substring(aux, campo.tamanho);
            }
            throw new Exception("Valor inteiro incorreto");
        }
        if (campo.tipo.equals(CampoResultado.Tipo.TEXTO.codigo)) {
            valor = valor.toString().replaceAll(DEL, " ");
            return this.substring(valor.toString(), campo.tamanho);
        }
        if (campo.tipo.equals(CampoResultado.Tipo.DATA.codigo)) {
            if (valor instanceof Date) {
                return this.substring(Funcoes.formataData("dd/MM/yyyy", (Date)valor), campo.tamanho);
            }
            if (valor instanceof String && Funcoes.verificaData(valor.toString())) {
                return this.substring(Funcoes.formataData("dd/MM/yyyy", Funcoes.stringToDate("dd/MM/yyyy", valor.toString())), campo.tamanho);
            }
            throw new Exception("Valor de data incorreto. (Campo: " + campo.descricao + ")");
        }
        if (campo.tipo.equals(CampoResultado.Tipo.BOOLEAN.codigo)) {
            if (valor instanceof Boolean) {
                return this.substring((Boolean)valor != false ? "S" : "N", campo.tamanho);
            }
            throw new Exception("Valor SIM/N\u00c3O incorreto.");
        }
        throw new Exception("Tipo de dados desconhecido.");
    }
}

