/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao;

import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosUsuarios;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.exportacao.SalvarPdf;
import jalis.laboratorio.resultados.ImpressaoResultados;
import jalis.service.integracao.ExportacaoResultadoPdfService;
import jalis.service.integracao.SituacaoExame;
import jalis.util.ArraysUtil;
import jalis.util.CheckItemFiltro;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.SplashMensagem;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;

public class ExportacaoResultadoPdf
extends JPanel
implements ActionListener,
ListSelectionListener {
    private static final long ACESSO = Long.parseLong("0909000303");
    private static final int COLUNA_REQUISICAO = 0;
    private static final int COLUNA_NOME_PACIENTE = 1;
    private static final int COLUNA_REGISTRO = 2;
    private static final String REQUISICOES = "requisicoes";
    private static final String REQUISICAO = "requisicao";
    private static final String CODIGO = "codigo";
    private static final String DATA = "data";
    private static final String CODIGO_PACIENTE = "codigoPaciente";
    private static final String NASCIMENTO = "nascimento";
    private static final String CONVENIO = "convenio";
    private static final String NOME = "nome";
    private static final String DIRETORIO = "diretorio";
    private static final String ARQUIVO_PDF = "arquivoPDF";
    private static final String MEDICO = "medico";
    private static final String CONSELHO = "conselho";
    private static final String UF = "uf";
    private static final String EXAMES = "exames";
    private static final String EXAME = "exame";
    private static final String DESCRICAO = "descricao";
    public static final String PADRAOCLINIC = "Padr\u00e3o Clinic";
    private CheckItemFiltro itemPaciente;
    private CheckItemFiltro itemConvenio;
    private CheckItemFiltro itemExame;
    private CheckItemFiltro itemCidade;
    private CheckItemFiltro itemMedico;
    private CheckItemFiltro itemSituacao;
    private CheckItemFiltro itemColeta;
    private CheckItemFiltro itemDestino;
    private TTextField textDataIni = new TTextField(0, 4);
    private TTextField textDataFin = new TTextField(0, 4);
    private JLabel labelDataIni = new JLabel("Data Inicial:");
    private JLabel labelDataFin = new JLabel("Data Final:");
    private JButton buttonDataIni = ComponenteFactory.novoJButton(this, null, new Dimension(20, 20), true);
    private JButton buttonDataFin = ComponenteFactory.novoJButton(this, null, new Dimension(20, 20), true);
    private JLabel labelNomePadrao = new JLabel("Nome Padr\u00e3o: ");
    private JComboBox<String> comboNomePadrao = new JComboBox<String>(new String[]{"Padr\u00e3o Jalis", "Padr\u00e3o Clinic"});
    private JButton buttonConsultar = ComponenteFactory.novoJButton("Consultar", 'C', this, null, null);
    private JButton buttonConfigurar = ComponenteFactory.novoJButton("Configurar", 'O', this, null, null);
    private JButton buttonNovo = ComponenteFactory.novoJButton("Novo", 'N', this, null, null);
    private JButton buttonExportar = ComponenteFactory.novoJButton("Exportar", 'E', this, null, null);
    private JButton buttonFechar = ComponenteFactory.novoJButton("Fechar", 'F', this, null, null);
    private JPanel panelRequisicoes = new JPanel(new BorderLayout());
    private JPanel panelExames = new JPanel(new BorderLayout());
    private JSplitPane splitCentral = new JSplitPane(1, this.panelRequisicoes, this.panelExames);
    private ModeloGridTable modeloRequisicoes = new ModeloGridTable(new String[]{"Requisi\u00e7\u00e3o", "Paciente", ""});
    private JTable tableRequisicoes = ComponenteFactory.novoJTable((TableModel)this.modeloRequisicoes, (ListSelectionListener)this, 70, 350, 1);
    private JScrollPane scrollRequisicoes = new JScrollPane(this.tableRequisicoes);
    private ModeloGridTable modeloExames = new ModeloGridTable(new String[]{"C\u00f3d.", "Mat.", "Exame", "Sit."});
    private JTable tableExames = ComponenteFactory.novoJTable((TableModel)this.modeloExames, null, 50, 30, 0, 30);
    private JScrollPane scrollExames = new JScrollPane(this.tableExames);
    private String path = "";
    private static final String ULTIMO_FILTRO = "ExportacaoResultadoPdf.ultimoFiltro";
    private HashMap<String, ArrayList<Registro>> requisicoes = new HashMap();
    private ExportacaoResultadoPdfService service = new ExportacaoResultadoPdfService();

    public ExportacaoResultadoPdf() {
        this.montarTela();
    }

    private void montarTela() {
        this.setLayout(new BorderLayout());
        Funcoes.criaBarraDescricao(this, "Exportar resultados para pdf", "Exporta\u00e7\u00e3o de resultados para arquivos pdf", "integracao/export_result_pdf.jpg");
        Funcoes.montaEnter((JComponent)this);
        Dimension dimensionFiltro = new Dimension(200, 20);
        Dimension dimensionText = new Dimension(90, 20);
        Dimension dimensionCombo = new Dimension(110, 20);
        Dimension dimensionButton = new Dimension(20, 20);
        JPanel panelPrincipal = new JPanel();
        panelPrincipal.setLayout(new BorderLayout());
        this.add((Component)panelPrincipal, "Center");
        JPanel panelFiltro = new JPanel();
        panelPrincipal.add((Component)panelFiltro, "North");
        panelFiltro.setBorder(BorderFactory.createTitledBorder("Filtro"));
        panelFiltro.setLayout(new GridBagLayout());
        this.itemPaciente = Variaveis.tipoFilialPadrao.equals("A") ? new CheckItemFiltro("Cliente", "Filtrar", "Filtrando empresa", "fil_codigo = " + Variaveis.filialPadrao) : new CheckItemFiltro("Paciente", "Filtrar", "Filtrando pacientes", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemPaciente.setDados("paciente", new String[]{"pac_codigo", "pac_nome"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{70, 0});
        this.itemPaciente.setColunaHint(1);
        this.itemPaciente.setPreferredSize(dimensionFiltro);
        this.itemPaciente.setMinimumSize(dimensionFiltro);
        this.itemConvenio = new CheckItemFiltro("Conv\u00eanio", "Filtrar", "Filtrando conv\u00eanios", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemConvenio.setDados("convenios", new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Fantasia"}, new int[]{70, 0});
        this.itemConvenio.setColunaHint(1);
        this.itemConvenio.setPreferredSize(dimensionFiltro);
        this.itemConvenio.setMinimumSize(dimensionFiltro);
        this.itemExame = new CheckItemFiltro("Exame", "Filtrar", "Filtrando exames", "fil_codigo =" + Variaveis.filialPadrao);
        this.itemExame.setDados(EXAMES, new String[]{"exa_codigo", "exa_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemExame.setColunaHint(1);
        this.itemExame.setPreferredSize(dimensionFiltro);
        this.itemExame.setMinimumSize(dimensionFiltro);
        this.itemCidade = new CheckItemFiltro("Cidade", "Filtrar", "Filtrando cidades", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemCidade.setDados("cidades", new String[]{"cid_codigo", "cid_nome"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemCidade.setColunaHint(1);
        this.itemCidade.setPreferredSize(dimensionFiltro);
        this.itemCidade.setMinimumSize(dimensionFiltro);
        this.itemMedico = Variaveis.tipoFilialPadrao.equals("A") ? new CheckItemFiltro("Coletador", "Filtrar", "Filtrando coletador", "fil_codigo = " + Variaveis.filialPadrao, new int[]{0, 1, 2}, false) : new CheckItemFiltro("M\u00e9dico", "Filtrar", "Filtrando m\u00e9dicos", "fil_codigo = " + Variaveis.filialPadrao, new int[]{0, 1, 2}, false);
        this.itemMedico.setDados(MEDICO, new String[]{"med_conselho", "med_crm", "med_uf", "med_nome"}, new String[]{"Conselho", "C\u00f3digo", "UF", "Nome"}, new int[]{30, 70, 30, 0}, 4, false, true, false);
        this.itemMedico.setColunaHint(3);
        this.itemMedico.setPreferredSize(dimensionFiltro);
        this.itemMedico.setMinimumSize(dimensionFiltro);
        this.itemColeta = new CheckItemFiltro("Coleta", "Filtrar", "Filtrando coletas", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemColeta.setDados("coletas", new String[]{"col_codigo", "col_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemColeta.setColunaHint(1);
        this.itemColeta.setPreferredSize(dimensionFiltro);
        this.itemColeta.setMinimumSize(dimensionFiltro);
        this.itemDestino = new CheckItemFiltro("Destino", "Filtrar", "Filtrando destinos", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemDestino.setDados("destino", new String[]{"des_codigo", "des_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemDestino.setColunaHint(1);
        this.itemDestino.setPreferredSize(dimensionFiltro);
        this.itemDestino.setMinimumSize(dimensionFiltro);
        this.itemSituacao = new CheckItemFiltro("Situa\u00e7\u00e3o Do Exame", "Filtrar", "Filtrando Situa\u00e7\u00e3o do Exame", null);
        ArrayList<Object[]> lista = new ArrayList<Object[]>();
        lista.add(new Object[]{SituacaoExame.getDescricao(SituacaoExame.CONFERIDO)});
        lista.add(new Object[]{SituacaoExame.getDescricao(SituacaoExame.IMPRESSO)});
        lista.add(new Object[]{SituacaoExame.getDescricao(SituacaoExame.ENTREGUE)});
        this.itemSituacao.setDados(null, new String[]{""}, new String[]{"Descri\u00e7\u00e3o"}, new int[]{0});
        this.itemSituacao.setConsultaFixa(lista);
        this.itemSituacao.setColunaHint(0);
        this.itemSituacao.setPreferredSize(dimensionFiltro);
        this.itemSituacao.setMinimumSize(dimensionFiltro);
        this.comboNomePadrao.setPreferredSize(dimensionCombo);
        this.comboNomePadrao.setMinimumSize(dimensionCombo);
        Insets insetsEsquerda = new Insets(0, 20, 0, 0);
        Insets insetsNormal = new Insets(0, 0, 0, 0);
        GridBagConstraints cons = new GridBagConstraints();
        cons.anchor = 17;
        cons.fill = 0;
        cons.gridheight = 1;
        cons.gridwidth = 1;
        cons.gridx = 0;
        cons.gridy = 0;
        cons.insets = insetsNormal;
        cons.weightx = 0.0;
        cons.weighty = 0.0;
        panelFiltro.add((Component)this.itemPaciente, cons);
        ++cons.gridx;
        cons.insets = insetsEsquerda;
        panelFiltro.add((Component)this.itemCidade, cons);
        ++cons.gridx;
        panelFiltro.add((Component)this.labelDataIni, cons);
        ++cons.gridx;
        cons.insets = insetsNormal;
        this.textDataIni.setPreferredSize(dimensionText);
        this.textDataIni.setMinimumSize(dimensionText);
        panelFiltro.add((Component)this.textDataIni, cons);
        ++cons.gridx;
        this.buttonDataIni.setPreferredSize(dimensionButton);
        this.buttonDataIni.setMinimumSize(dimensionButton);
        panelFiltro.add((Component)this.buttonDataIni, cons);
        ++cons.gridy;
        cons.gridx = 0;
        panelFiltro.add((Component)this.itemConvenio, cons);
        ++cons.gridx;
        cons.insets = insetsEsquerda;
        panelFiltro.add((Component)this.itemMedico, cons);
        ++cons.gridx;
        panelFiltro.add((Component)this.labelDataFin, cons);
        ++cons.gridx;
        cons.insets = insetsNormal;
        this.textDataFin.setPreferredSize(dimensionText);
        this.textDataFin.setMinimumSize(dimensionText);
        panelFiltro.add((Component)this.textDataFin, cons);
        ++cons.gridx;
        this.buttonDataFin.setPreferredSize(dimensionButton);
        this.buttonDataFin.setMinimumSize(dimensionButton);
        panelFiltro.add((Component)this.buttonDataFin, cons);
        ++cons.gridy;
        cons.gridx = 0;
        panelFiltro.add((Component)this.itemExame, cons);
        ++cons.gridx;
        cons.insets = insetsEsquerda;
        panelFiltro.add((Component)this.itemSituacao, cons);
        ++cons.gridx;
        cons.insets = insetsEsquerda;
        panelFiltro.add((Component)this.labelNomePadrao, cons);
        ++cons.gridx;
        cons.gridwidth = 2;
        cons.insets = insetsNormal;
        panelFiltro.add(this.comboNomePadrao, cons);
        cons.insets = insetsNormal;
        cons.gridx = 0;
        ++cons.gridy;
        panelFiltro.add((Component)this.itemColeta, cons);
        cons.insets = insetsEsquerda;
        ++cons.gridx;
        panelFiltro.add((Component)this.itemDestino, cons);
        ++cons.gridy;
        cons.gridx = 3;
        cons.gridwidth = 3;
        cons.anchor = 13;
        cons.weightx = 1.0;
        panelFiltro.add((Component)this.buttonConsultar, cons);
        panelPrincipal.add((Component)this.splitCentral, "Center");
        this.splitCentral.setBorder(null);
        this.splitCentral.setDividerSize(3);
        this.splitCentral.setDividerLocation(350);
        this.splitCentral.setEnabled(false);
        panelPrincipal = new JPanel(new FlowLayout(2, 3, 3));
        this.add((Component)ComponenteFactory.novoJPanelBorderLayout(panelPrincipal, null, null, null, null), "South");
        panelPrincipal.add(this.buttonConfigurar);
        panelPrincipal.add(this.buttonNovo);
        panelPrincipal.add(this.buttonExportar);
        panelPrincipal.add(this.buttonFechar);
        this.panelRequisicoes.setBorder(BorderFactory.createTitledBorder("Requisi\u00e7\u00f5es"));
        this.panelRequisicoes.add((Component)this.scrollRequisicoes, "Center");
        this.panelExames.setBorder(BorderFactory.createTitledBorder("Exames"));
        this.panelExames.add((Component)this.scrollExames, "Center");
        this.textDataIni.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    ExportacaoResultadoPdf.this.buttonDataIni.doClick();
                }
            }
        });
        this.textDataFin.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    ExportacaoResultadoPdf.this.buttonDataFin.doClick();
                }
            }
        });
        this.comboNomePadrao.addItemListener(listener -> {
            this.modeloRequisicoes.clear();
            this.modeloExames.clear();
        });
        this.carregarParametros();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        ArrayList exames;
        this.modeloExames.clear();
        if (this.contemRegistro() && this.contemDados(exames = (ArrayList)this.modeloRequisicoes.getValueAt(this.tableRequisicoes.getSelectedRow(), 2))) {
            for (Registro exa : exames) {
                this.modeloExames.addLine(new Object[]{exa.getString("exa_codigo"), exa.getString("mco_abreviatura"), exa.getString("exa_descricao"), exa.getString("exr_situacao")});
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.buttonFechar) {
            this.setVisible(false);
            if (this.getParent() != null) {
                this.getParent().removeAll();
            }
        } else if (o == this.buttonConfigurar) {
            SalvarPdf salvarPdf = SalvarPdf.novaInstancia((Window)this.getTopLevelAncestor());
            salvarPdf.setCaminho(this.path);
            salvarPdf.setVisible(true);
            if (salvarPdf.getOK() && !salvarPdf.getCaminho().isEmpty()) {
                this.path = salvarPdf.getCaminho();
                this.gravarParametros();
            }
        } else if (o == this.buttonNovo) {
            this.limpaCampos();
        } else if (o == this.buttonConsultar) {
            this.modeloRequisicoes.clear();
            this.consultarRequisicoes();
            this.gravarParametros();
        } else if (o == this.buttonExportar) {
            this.exportarRequisicoes();
            this.gravarParametros();
        } else if (o == this.buttonDataIni) {
            Funcoes.mostraData(this.textDataIni, this.buttonDataIni, (JPanel)this.buttonDataIni.getParent(), false);
        } else if (o == this.buttonDataFin) {
            Funcoes.mostraData(this.textDataFin, this.buttonDataFin, (JPanel)this.buttonDataFin.getParent(), false);
        }
    }

    private void exportarRequisicoes() {
        if (this.contemRegistro()) {
            SplashMensagem splash = null;
            try {
                new SplashMensagem();
                splash = SplashMensagem.getInstancia(this);
                while (!Funcoes.diretorioExiste(this.path)) {
                    JFileChooser file = ComponenteFactory.novoJFileChooser();
                    file.setFileSelectionMode(2);
                    if (!this.isCaminhoSelecionado(file)) {
                        return;
                    }
                    this.path = file.getSelectedFile().getAbsolutePath();
                }
                splash.mostrar("Gerando dados. Aguarde...");
                HashMap<String, ArrayList<ArrayList>> map = this.agruparPorDate();
                boolean padraoClinic = this.comboNomePadrao.getSelectedItem().toString().equalsIgnoreCase(PADRAOCLINIC);
                this.geraPDF(this.path, map, padraoClinic);
                this.gerarXML(this.path);
                Funcoes.mensagem(this, "Arquivo(s) criado(s) com sucesso.", 5);
                splash.apagar();
            }
            catch (Exception e) {
                if (splash != null) {
                    splash.apagar();
                }
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel exportar os dados \n" + e.getMessage(), e.getStackTrace(), "ExportarResultadoPDF: 296");
            }
        }
    }

    private void geraPDF(String path, HashMap<String, ArrayList<ArrayList>> map, boolean nomePadraoClinic) throws Exception {
        for (String key : map.keySet()) {
            String nomePasta = this.getNomePasta(key);
            String nomeSubPasta = this.getSubNomePasta(key);
            File dPDF = new File(path);
            this.criarPasta(dPDF);
            dPDF = new File(path + File.separator + nomePasta);
            this.criarPasta(dPDF);
            dPDF = new File(path + File.separator + nomePasta + File.separator + nomeSubPasta);
            this.criarPasta(dPDF);
            ArrayList<ArrayList> requisicoesList = map.get(key);
            for (ArrayList alRequisicao : requisicoesList) {
                String req = alRequisicao.get(0).toString();
                String fil = req.substring(0, ParametrosGerais.getDigitosTuboFilial());
                String codReq = req.substring(ParametrosGerais.getDigitosTuboFilial(), req.length());
                String nomeArquivo = nomePadraoClinic ? this.getNomePadroClinic((ArrayList)alRequisicao.get(1), codReq) : req;
                String arquivoPDF = dPDF + File.separator + nomeArquivo + ".pdf";
                String[] exames = new String[]{};
                String[] materiais = new String[]{};
                for (Registro r : (ArrayList)alRequisicao.get(1)) {
                    exames = ArraysUtil.concatenar(exames, new String[]{r.getString("exa_codigo")});
                    materiais = ArraysUtil.concatenar(materiais, new String[]{r.getString("mco_codigo")});
                }
                ImpressaoResultados.imprimirExamesPdf(fil, codReq, exames, materiais, arquivoPDF, false, "", false);
            }
        }
    }

    private String getNomePadroClinic(ArrayList<Registro> registro, String req) throws ParseException {
        StringBuilder retorno = new StringBuilder();
        Registro reg = registro.get(0);
        retorno.append(reg.getString("req_prontuario")).append("_");
        String data = Funcoes.formataData("ddMMyyyy_HHmm_", reg.getDate("exr_dataassina"));
        retorno.append(data).append(Integer.valueOf(req));
        return retorno.toString();
    }

    private void criarPasta(File dPDF) throws Exception {
        if (!dPDF.exists()) {
            try {
                dPDF.mkdir();
            }
            catch (Exception e) {
                new Exception("Erro ao criar diret\u00f3rio. \n" + e.getMessage());
            }
        }
    }

    private HashMap<String, ArrayList<ArrayList>> agruparPorDate() {
        HashMap<String, ArrayList<ArrayList>> map = new HashMap<String, ArrayList<ArrayList>>();
        for (int i = 0; i < this.tableRequisicoes.getRowCount(); ++i) {
            ArrayList exames = (ArrayList)this.modeloRequisicoes.getValueAt(i, 2);
            ArrayList listReg = null;
            String fil = Funcoes.preencheZero(Variaveis.filialPadrao, ParametrosGerais.getDigitosTuboFilial());
            String req = Funcoes.preencheZero(this.modeloRequisicoes.getValueAt(i, 0).toString(), ParametrosGerais.getDigitosTuboRequisicao());
            String date = ((Registro)exames.get(0)).getString("req_data");
            listReg = map.get(date);
            if (listReg == null) {
                listReg = new ArrayList();
            }
            if (this.contemRegistro(listReg, fil, req)) {
                ArrayList<Object> listaRequisicao = new ArrayList<Object>();
                listaRequisicao.add(fil + req);
                listaRequisicao.add(exames);
                listReg.add(listaRequisicao);
            }
            map.put(date, listReg);
        }
        return map;
    }

    private void gerarXML(String path) throws ParseException, XMLStringBuilderException, Exception {
        XMLStringBuilder xml = new XMLStringBuilder();
        xml.abrir(REQUISICOES);
        for (int i = 0; i < this.tableRequisicoes.getRowCount(); ++i) {
            ArrayList exames = (ArrayList)this.modeloRequisicoes.getValueAt(i, 2);
            xml.abrir(REQUISICAO);
            String req = Funcoes.preencheZero(this.modeloRequisicoes.getValueAt(i, 0).toString(), ParametrosGerais.getDigitosTuboRequisicao());
            String data = Funcoes.formataData(((Registro)exames.get(0)).getDate("req_data"));
            String codigoPac = ((Registro)exames.get(0)).getString("pac_codigo");
            String dataNasc = Funcoes.formataData(((Registro)exames.get(0)).getDate("pac_datanasc"));
            String convenio = ((Registro)exames.get(0)).getString("con_fantasia");
            String nomePac = this.modeloRequisicoes.getValueAt(i, 1).toString();
            String conselho = ((Registro)exames.get(0)).getString("med_conselho");
            String uf = ((Registro)exames.get(0)).getString("med_uf");
            String codigoMed = ((Registro)exames.get(0)).getString("med_crm");
            String nomeMedico = ((Registro)exames.get(0)).getString("med_nome");
            xml.escrever(CODIGO, req);
            xml.escrever(DATA, Funcoes.formataData("dd/MM/yyyy", data));
            xml.escrever(CODIGO_PACIENTE, codigoPac);
            xml.escrever(NASCIMENTO, dataNasc);
            xml.escrever(CONVENIO, convenio);
            xml.escrever(NOME, StringUtil.trataCaracteresEspeciais(nomePac));
            xml.escrever(DIRETORIO, this.getDiretorio(Funcoes.formataData("yyyy/MM/dd", ((Registro)exames.get(0)).getDate("req_data"))));
            xml.escrever(ARQUIVO_PDF, this.getNomePDF(req));
            xml.abrir(MEDICO);
            xml.escrever(CONSELHO, conselho);
            xml.escrever(UF, uf);
            xml.escrever(CODIGO, codigoMed);
            xml.escrever(NOME, StringUtil.trataCaracteresEspeciais(nomeMedico));
            xml.fechar(MEDICO);
            xml.abrir(EXAMES);
            for (Registro exa : exames) {
                xml.abrir(EXAME);
                xml.escrever(DESCRICAO, StringUtil.trataCaracteresEspeciais(exa.getString("exa_descricao")));
                xml.fechar(EXAME);
            }
            xml.fechar(EXAMES);
            xml.fechar(REQUISICAO);
        }
        xml.fechar(REQUISICOES);
        StringUtil.escreverArquivoTexto(path + File.separator + "resultados.xml", xml.getXML());
    }

    private void consultarRequisicoes() {
        if (this.validaData()) {
            this.requisicoes.clear();
            String[] filtroPaciente = this.itemPaciente.getSelecionados(0);
            String[] filtroConvenio = this.itemConvenio.getSelecionados(0);
            String[] filtroExame = this.itemExame.getSelecionados(0);
            String[] filtroCidade = this.itemCidade.getSelecionados(0);
            String[] filtroMedicoConselho = this.itemMedico.getSelecionadosAvancado(0);
            String[] filtroMedicoCodigo = this.itemMedico.getSelecionadosAvancado(1);
            String[] filtroMedicoUF = this.itemMedico.getSelecionadosAvancado(2);
            String[] filtroColeta = this.itemColeta.getSelecionados(0);
            String[] filtroDestino = this.itemDestino.getSelecionados(0);
            if (!this.itemMedico.isSelected() || this.itemMedico.getSelecionadosAvancado() == null) {
                this.itemMedico.clear();
                filtroMedicoConselho = null;
                filtroMedicoCodigo = null;
                filtroMedicoUF = null;
            }
            String[] filtroSituacaoExame = this.itemSituacao.getSelecionados(0);
            String filtroDateIni = Funcoes.formataData("dd/MM/yyyy", this.textDataIni.getText());
            String filtroDateFim = Funcoes.formataData("dd/MM/yyyy", this.textDataFin.getText());
            String filtroNomePadrao = this.comboNomePadrao.getSelectedItem().toString();
            try {
                this.requisicoes.putAll(this.service.getRequisicoes(Variaveis.filialPadrao, filtroPaciente, filtroConvenio, filtroExame, filtroCidade, filtroMedicoCodigo, filtroMedicoConselho, filtroMedicoUF, filtroSituacaoExame, filtroDateIni, filtroDateFim, filtroNomePadrao, filtroColeta, filtroDestino));
                if (this.carregouRegistros(this.requisicoes)) {
                    for (String key : this.requisicoes.keySet()) {
                        String[] dados = key.split(",");
                        this.modeloRequisicoes.addLine(new Object[]{dados[0], dados[1], this.requisicoes.get(key)});
                    }
                    this.modeloRequisicoes.ordenarColuna(0, 1);
                }
            }
            catch (SQLException | ParseException e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel consultar os dados. \n" + e.getMessage(), e.getStackTrace(), "ExportarResultadoPDF: 376");
            }
        }
    }

    private boolean validaData() {
        if (Funcoes.textoVazio(this.textDataIni.getText()) && !Funcoes.verificaData(this.textDataIni.getText())) {
            Funcoes.mensagem(this, "Data Inicial inv\u00e1lida.", 2);
            ScreenUtil.requisitarFoco(this.textDataIni);
            return false;
        }
        if (Funcoes.textoVazio(this.textDataFin.getText()) && !Funcoes.verificaData(this.textDataFin.getText())) {
            Funcoes.mensagem(this, "Data Final inv\u00e1lida.", 2);
            ScreenUtil.requisitarFoco(this.textDataFin);
            return false;
        }
        return true;
    }

    private void carregarParametros() {
        if (ParametrosUsuarios.contemParametro(ULTIMO_FILTRO)) {
            String str = StringUtil.getValor(ParametrosUsuarios.getValor(ULTIMO_FILTRO), "filtro");
            this.setAtributosFiltro(this.itemPaciente, StringUtil.getValor(str, "paciente"));
            this.setAtributosFiltro(this.itemConvenio, StringUtil.getValor(str, CONVENIO));
            this.setAtributosFiltro(this.itemExame, StringUtil.getValor(str, EXAME));
            this.setAtributosFiltro(this.itemCidade, StringUtil.getValor(str, "cidade"));
            this.setAtributosFiltro(this.itemMedico, StringUtil.getValor(str, MEDICO));
            this.setAtributosFiltro(this.itemColeta, StringUtil.getValor(str, "coleta"));
            this.setAtributosFiltro(this.itemDestino, StringUtil.getValor(str, "destino"));
            String filtroSituacao = StringUtil.getValor(str, "situacao");
            if (Funcoes.textoVazio(filtroSituacao)) {
                filtroSituacao = "<sel>true</sel><item>Entregue</item><item>Impresso</item>";
            }
            this.setAtributosFiltro(this.itemSituacao, filtroSituacao);
            this.textDataIni.setText(StringUtil.getValor(str, "dataInicial"));
            this.textDataFin.setText(StringUtil.getValor(str, "dataFinal"));
            this.path = StringUtil.getValor(str, "path");
            String filtroNomePadrao = StringUtil.getValor(str, "nomePadrao");
            if (!Funcoes.textoVazio(filtroNomePadrao)) {
                this.comboNomePadrao.setSelectedItem(filtroNomePadrao);
            }
        } else {
            String filtroSituacao = "<sel>true</sel><item>Entregue</item><item>Impresso</item>";
            this.setAtributosFiltro(this.itemSituacao, filtroSituacao);
        }
    }

    private void gravarParametros() {
        StringBuilder bui = new StringBuilder();
        bui.append(this.getAtributosFiltro(this.itemPaciente, "paciente"));
        bui.append(this.getAtributosFiltro(this.itemConvenio, CONVENIO));
        bui.append(this.getAtributosFiltro(this.itemExame, EXAME));
        bui.append(this.getAtributosFiltro(this.itemCidade, "cidade"));
        bui.append(this.getAtributosFiltro(this.itemMedico, MEDICO));
        bui.append(this.getAtributosFiltro(this.itemSituacao, "situacao"));
        bui.append(this.getAtributosFiltro(this.itemColeta, "coleta"));
        bui.append(this.getAtributosFiltro(this.itemDestino, "destino"));
        bui.append(StringUtil.getTag("dataInicial", this.textDataIni.getText()));
        bui.append(StringUtil.getTag("dataFinal", this.textDataFin.getText()));
        bui.append(StringUtil.getTag("nomePadrao", this.comboNomePadrao.getSelectedItem().toString()));
        bui.append(StringUtil.getTag("path", this.path));
        ParametrosUsuarios.setValor(ULTIMO_FILTRO, StringUtil.getTag("filtro", bui.toString()));
    }

    private void setAtributosFiltro(CheckItemFiltro item, String atributos) {
        if (StringUtil.getBoolean(atributos, "sel")) {
            item.setSelected(true);
            item.setSelecionados(StringUtil.getValores(atributos, "item"));
            if (atributos.contains(CONSELHO)) {
                item.setSelecionados(StringUtil.getValores(atributos, CONSELHO), 1);
                item.setSelecionados(StringUtil.getValores(atributos, UF), 2);
            }
        }
    }

    private String getAtributosFiltro(CheckItemFiltro item, String nome) {
        StringBuilder bui = new StringBuilder();
        bui.append(StringUtil.getTag("sel", String.valueOf(item.isSelected())));
        bui.append(StringUtil.getTag("item", item.getSelecionados(0)));
        if (nome.equalsIgnoreCase(MEDICO)) {
            bui.append(StringUtil.getTag(CONSELHO, item.getSelecionados(1)));
            bui.append(StringUtil.getTag(UF, item.getSelecionados(2)));
        }
        return StringUtil.getTag(nome, bui.toString());
    }

    private boolean contemRegistro(ArrayList<ArrayList> listReg, String fil, String req) {
        for (ArrayList al : listReg) {
            if (!al.contains(fil + req)) continue;
            return false;
        }
        return true;
    }

    private boolean carregouRegistros(HashMap<String, ArrayList<Registro>> list) {
        return list != null && list.size() > 0;
    }

    private boolean contemDados(ArrayList<Registro> reg) {
        return reg != null;
    }

    private boolean contemRegistro() {
        return this.tableRequisicoes.getRowCount() > 0;
    }

    private String getDiretorio(String data) {
        return this.getNomePasta(data) + "/" + this.getSubNomePasta(data);
    }

    private String getNomePDF(String req) {
        String fil = Funcoes.preencheZero(Variaveis.filialPadrao, ParametrosGerais.getDigitosTuboFilial());
        return fil + req;
    }

    private String getSubNomePasta(String key) {
        String[] retorno = key.split("/");
        return retorno[1];
    }

    private String getNomePasta(String key) {
        String[] retorno = key.split("/");
        return retorno[0];
    }

    public static String getUltimoFiltro() {
        return ULTIMO_FILTRO;
    }

    private boolean isCaminhoSelecionado(JFileChooser file) {
        return file.showSaveDialog(this) == 0;
    }

    private void limpaCampos() {
        this.modeloRequisicoes.clear();
        this.modeloExames.clear();
        this.requisicoes.clear();
        this.textDataIni.setText("");
        this.textDataFin.setText("");
        this.itemPaciente.clear();
        this.itemConvenio.clear();
        this.itemExame.clear();
        this.itemCidade.clear();
        this.itemMedico.clear();
        this.itemSituacao.clear();
        this.itemColeta.clear();
        this.itemDestino.clear();
    }

    public static long getModuloAcesso() {
        return ACESSO;
    }
}

