/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.laboratorio.resultados.ImpressaoResultados;
import jalis.util.CheckItemFiltro;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.CorTableCellRenderer;
import jalis.util.tabela.ModeloResultSet;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.TableModel;

class DialogoFiltro
extends JDialog
implements ActionListener {
    private static final String SELECIONADO = "selecionado";
    private JButton buttonConsultar = ComponenteFactory.novoJButton("Consultar", '\u0000', this);
    private JButton buttonDesmarcarTodos = ComponenteFactory.novoJButton("Desmarcar Todos", 'D', this);
    private JButton buttonMarcarTodos = ComponenteFactory.novoJButton("Selecionar Todos", 'S', this);
    private JButton buttonOK = ComponenteFactory.novoJButton("OK", 'O', this);
    private JButton buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this);
    private JButton buttonDataIni = ComponenteFactory.novoJButton(this, null, new Dimension(20, 20), true);
    private JButton buttonDataFin = ComponenteFactory.novoJButton(this, null, new Dimension(20, 20), true);
    private TTextField textDataIni = new TTextField(0, 4);
    private TTextField textDataFin = new TTextField(0, 4);
    private ModeloResultSet modReq = new ModeloResultSet("Requisi\u00e7\u00e3o", "req_codigo", "Paciente", "pac_nome", "Data", "req_data", "", "selecionado");
    private CheckItemFiltro itemColeta;
    private CheckItemFiltro itemDestino;
    private CheckItemFiltro itemConvenio;
    private boolean ok;

    public static DialogoFiltro novaInstancia(Object pai) {
        if (pai instanceof Frame) {
            return new DialogoFiltro((Frame)pai);
        }
        if (pai instanceof Dialog) {
            return new DialogoFiltro((Dialog)pai);
        }
        return null;
    }

    public DialogoFiltro(Frame pai) {
        super(pai, "Filtros", true);
        this.iniciar();
    }

    public DialogoFiltro(Dialog pai) {
        super(pai, "Filtros", true);
        this.iniciar();
    }

    public boolean getOk() {
        return this.ok;
    }

    public List<Registro> getRequisicoesSelecionados() {
        ArrayList<Registro> sel = new ArrayList<Registro>();
        for (Registro reg : this.modReq.getRegistros()) {
            if (!reg.getBoolean(SELECIONADO)) continue;
            sel.add(reg);
        }
        return sel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.buttonOK || o == this.buttonCancelar) {
            this.ok = o == this.buttonOK;
            this.dispose();
        } else if (o == this.buttonMarcarTodos || o == this.buttonDesmarcarTodos) {
            boolean marcar = o == this.buttonMarcarTodos;
            for (Registro reg : this.modReq.getRegistros()) {
                reg.setValor(SELECIONADO, marcar);
            }
            this.modReq.fireTableDataChanged();
        } else if (o == this.buttonDataIni) {
            Funcoes.mostraData(this.textDataIni, this.buttonDataIni, (JPanel)this.buttonDataIni.getParent(), true);
        } else if (o == this.buttonDataFin) {
            Funcoes.mostraData(this.textDataFin, this.buttonDataFin, (JPanel)this.buttonDataFin.getParent(), true);
        } else if (o == this.buttonConsultar) {
            this.consultarRequisicoes();
        }
    }

    private void consultarRequisicoes() {
        Statement st = Conexao.getStatement();
        if (st != null) {
            try {
                this.modReq.limpar();
                ResultSet res = Conexao.executeQuery(st, this.getSelect());
                while (res.next()) {
                    Registro reg = new Registro(res);
                    reg.setValor("req_data", Funcoes.formataData("dd/MM/yyyy", res.getDate("req_data")));
                    this.modReq.addRegistro(reg);
                }
                this.modReq.fireTableDataChanged();
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
            }
        }
    }

    private String getSelect() {
        StringBuilder bui = new StringBuilder();
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        try {
            bui.append("select distinct \n");
            bui.append("  a.req_codigo, a.req_data, a.req_hora, a.req_dum, a.req_obs, \n");
            bui.append("  a.req_peso, a.req_altura, a.req_anomes, a.req_idade, \n");
            bui.append("  b.pac_codigo, b.pac_nome, b.pac_sexo, b.pac_datanasc, \n");
            bui.append("  false as ").append(SELECIONADO).append(" \n");
            bui.append("from requisicao a \n");
            bui.append("left join paciente b \n");
            bui.append("  on a.fil_codigo = b.fil_codigo and a.pac_codigo = b.pac_codigo \n");
            bui.append("left join examerequisicao c \n");
            bui.append("  on a.fil_codigo = c.fil_codigo and a.req_codigo = c.req_codigo \n");
            bui.append("left join examesetor d \n");
            bui.append("  on c.fil_codigo = d.fil_codigo and c.exa_codigo = d.exa_codigo \n");
            bui.append("left join examematcoleta e \n");
            bui.append("  on c.fil_codigo = e.fil_codigo and c.exa_codigo = e.exa_codigo and \n");
            bui.append("     c.mco_codigo = e.mco_codigo \n");
            bui.append("where \n");
            bui.append("  a.fil_codigo = ").append(Variaveis.filialPadrao).append(" ");
            bui.append(" and a.req_excluida = false ");
            if (Funcoes.verificaData(this.textDataIni.getText())) {
                bui.append("and \n  a.req_data >= '");
                bui.append(Funcoes.formataData("MM/dd/yyyy", sdf.parse(this.textDataIni.getText()))).append("' ");
            }
            if (Funcoes.verificaData(this.textDataFin.getText())) {
                bui.append("and \n  a.req_data <= '");
                bui.append(Funcoes.formataData("MM/dd/yyyy", sdf.parse(this.textDataFin.getText()))).append("' ");
            }
            if (!this.itemColeta.vazio()) {
                this.addExpressao(bui, "a.col_codigo", this.itemColeta, true);
            }
            if (!this.itemDestino.vazio()) {
                this.addExpressao(bui, "a.des_codigo", this.itemDestino, true);
            }
            if (!this.itemConvenio.vazio()) {
                this.addExpressao(bui, "a.con_codigo", this.itemConvenio, false);
            }
            bui.append(" order by a.req_codigo ");
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "DialogoFiltro: 833");
        }
        return bui.toString();
    }

    private void addExpressao(StringBuilder bui, String campo, CheckItemFiltro itemFiltro, boolean aspas) {
        bui.append("and \n  ");
        bui.append(ImpressaoResultados.getExpressao(campo, itemFiltro.getSelecionados(0), aspas));
        bui.append(" ");
    }

    private String getAtributosFiltro(CheckItemFiltro item, String nome) {
        StringBuilder bui = new StringBuilder();
        bui.append(StringUtil.getTag("sel", String.valueOf(item.isSelected())));
        bui.append(StringUtil.getTag("item", item.getSelecionados(0)));
        return StringUtil.getTag(nome, bui.toString());
    }

    private void setAtributosFiltro(CheckItemFiltro item, String atributos) {
        if (StringUtil.getBoolean(atributos, "sel")) {
            item.setSelected(true);
            item.setSelecionados(StringUtil.getValores(atributos, "item"));
        }
    }

    private void iniciar() {
        this.getContentPane().setLayout(new BorderLayout());
        JPanel panelAux = new JPanel(new BorderLayout());
        this.getContentPane().add((Component)panelAux, "South");
        panelAux.add((Component)ComponenteFactory.novoJPanelFlowLayout(0, this.buttonMarcarTodos, this.buttonDesmarcarTodos), "West");
        panelAux.add((Component)ComponenteFactory.novoJPanelFlowLayout(2, this.buttonOK, this.buttonCancelar), "East");
        panelAux = ComponenteFactory.novoJPanel(new BorderLayout(), BorderFactory.createTitledBorder("Requisi\u00e7\u00f5es"));
        this.getContentPane().add((Component)panelAux, "Center");
        this.modReq.setColunaEditavel(SELECIONADO);
        JTable table = ComponenteFactory.novoJTable((TableModel)this.modReq, 75, 0, 85, 25);
        table.setDefaultRenderer(String.class, CorTableCellRenderer.novaInstancia(4, -1, 4));
        JScrollPane scroll = new JScrollPane(table);
        scroll.setPreferredSize(new Dimension(scroll.getPreferredSize().width, 250));
        panelAux.add((Component)scroll, "Center");
        panelAux = ComponenteFactory.novoJPanel(new GridBagLayout(), BorderFactory.createTitledBorder("Filtros"));
        this.getContentPane().add((Component)panelAux, "North");
        GridBagConstraints cons = new GridBagConstraints();
        cons.fill = 1;
        cons.insets = new Insets(1, 1, 1, 1);
        cons.gridx = 0;
        cons.gridy = 0;
        cons.gridwidth = 1;
        cons.gridheight = 1;
        cons.weightx = 0.5;
        cons.weighty = 0.5;
        this.itemColeta = new CheckItemFiltro("Coleta", "Filtrar", "Filtrando coletas", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemColeta.setDados("coletas", new String[]{"col_codigo", "col_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemColeta.setColunaHint(1);
        panelAux.add((Component)this.itemColeta, cons);
        cons.gridy = 1;
        this.itemDestino = new CheckItemFiltro("Destino", "Filtrar", "Filtrando destinos", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemDestino.setDados("destino", new String[]{"des_codigo", "des_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemDestino.setColunaHint(1);
        panelAux.add((Component)this.itemDestino, cons);
        cons.gridx = 0;
        cons.gridy = 2;
        this.itemConvenio = new CheckItemFiltro("Conv\u00eanio", "Filtrar", "Filtrando conv\u00eanios", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemConvenio.setDados("convenios", new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Fantasia"}, new int[]{70, 0});
        this.itemConvenio.setColunaHint(1);
        panelAux.add((Component)this.itemConvenio, cons);
        cons.gridx = 1;
        cons.gridy = 0;
        this.textDataIni.setPreferredSize(new Dimension(90, 20));
        this.buttonDataIni.setFocusable(false);
        panelAux.add((Component)ComponenteFactory.novoJPanelBorderLayout(this.textDataIni, null, null, this.buttonDataIni, ComponenteFactory.novoJLabel("Data Inicial:", new Dimension(100, 20))), cons);
        cons.gridy = 1;
        this.textDataFin.setPreferredSize(new Dimension(90, 20));
        this.buttonDataFin.setFocusable(false);
        panelAux.add((Component)ComponenteFactory.novoJPanelBorderLayout(this.textDataFin, null, null, this.buttonDataFin, ComponenteFactory.novoJLabel("Data Final:", new Dimension(100, 20))), cons);
        cons.gridy = 2;
        cons.insets = new Insets(0, 0, 0, 0);
        JPanel panel = new JPanel(new FlowLayout(2, 0, 0));
        panel.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 1));
        panel.add(this.buttonConsultar);
        panelAux.add((Component)panel, cons);
        Funcoes.montaEnter((JComponent)this.getContentPane());
        ScreenUtil.addActionMap((JComponent)this.getContentPane(), KeyStroke.getKeyStroke(113, 0, true), "F2", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DialogoFiltro.this.textDataIni.hasFocus()) {
                    Funcoes.mostraData(DialogoFiltro.this.textDataIni, DialogoFiltro.this.buttonDataIni, (JPanel)DialogoFiltro.this.buttonDataIni.getParent(), true);
                } else if (DialogoFiltro.this.textDataFin.hasFocus()) {
                    Funcoes.mostraData(DialogoFiltro.this.textDataFin, DialogoFiltro.this.buttonDataFin, (JPanel)DialogoFiltro.this.buttonDataFin.getParent(), true);
                }
            }
        });
        this.pack();
        this.setSize(this.getPreferredSize());
        this.setResizable(false);
        ScreenUtil.centralizar(this);
    }
}

