/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao;

import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.integracaooperadoras.sistemas.FabricaIntegracaoOperadora;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Calendar;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class CorrigirLogIntegracaoOperadora
extends AbstractDialogoOKCancelar {
    private TTextField textCartaoSUS = new TTextField(30, 1);
    private TTextField textMatricula = new TTextField(30, 3);
    private TTextField textGuia = new TTextField(30, 3);
    private TTextField textDataGuia = new TTextField(30, 4);
    private TTextField textAMB = new TTextField(30, 3);
    private TTextField textIdExame = new TTextField(30, 3);
    private JButton botaoSalvarReenviar = ComponenteFactory.novoJButton("Salvar/Reenviar", 'R', this);
    private JPanel panelCentral = new JPanel();
    private JPanel painelBotoes = new JPanel(new BorderLayout(0, 0));
    private boolean salvarEReenviar = false;
    private static final String TITULO = "Corrigir";
    private final Border bordaPadrao = BorderFactory.createEmptyBorder(0, 5, 0, 5);
    private final FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora protocoloIntegracaoOperadora;

    private CorrigirLogIntegracaoOperadora(Dialog owner, Registro dadosPreenchidos, FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora protocoloIntegracaoOperadora) {
        super(owner, TITULO);
        this.protocoloIntegracaoOperadora = protocoloIntegracaoOperadora;
        this.construirTela(dadosPreenchidos);
    }

    private CorrigirLogIntegracaoOperadora(JFrame owner, Registro dadosPreenchidos, FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora protocoloIntegracaoOperadora) {
        super((Frame)owner, TITULO);
        this.protocoloIntegracaoOperadora = protocoloIntegracaoOperadora;
        this.construirTela(dadosPreenchidos);
    }

    public static CorrigirLogIntegracaoOperadora getInstancia(Window owner, Registro dadosPreenchidos, FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora protocoloIntegracaoOperadora) {
        return owner instanceof Dialog ? new CorrigirLogIntegracaoOperadora((Dialog)owner, dadosPreenchidos, protocoloIntegracaoOperadora) : new CorrigirLogIntegracaoOperadora((JFrame)owner, dadosPreenchidos, protocoloIntegracaoOperadora);
    }

    private void construirTela(Registro dadosPreenchidos) {
        this.setTitle(TITULO);
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(460, 240));
        this.setResizable(false);
        ScreenUtil.centralizar(this);
        this.setIconImage(ImagemUtils.carregaImagemJalis("icone64x64.png").getImage());
        this.preencherCampos(dadosPreenchidos);
        this.definirFocoInicial();
        this.construirPainelCentral();
        this.construirPainelBotoes();
        this.textAMB.setEnabled(false);
        this.add((Component)this.panelCentral, "First");
        this.add((Component)this.painelBotoes, "Last");
    }

    private void preencherCampos(Registro dadosPreenchidos) {
        this.textCartaoSUS.setText(dadosPreenchidos.getString("cartaosus"));
        this.textMatricula.setText(dadosPreenchidos.getString("matricula"));
        this.textGuia.setText(dadosPreenchidos.getString("guia"));
        this.textDataGuia.setText(this.getFormatData(dadosPreenchidos.getString("dataGuia"), true, "dd/MM/yyyy"));
        this.textAMB.setText(dadosPreenchidos.getString("amb"));
        this.textIdExame.setEnabled(this.protocoloIntegracaoOperadora.equals((Object)FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.SIMUS));
        this.textIdExame.setEditable(this.protocoloIntegracaoOperadora.equals((Object)FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.SIMUS));
        if (this.protocoloIntegracaoOperadora.equals((Object)FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.SIMUS)) {
            this.textIdExame.setText(dadosPreenchidos.getString("idExame"));
        }
    }

    public String getFormatData(String data, boolean formatoGravacao, String formato) {
        Calendar ca = Calendar.getInstance();
        if (!Funcoes.textoVazio(data)) {
            if (formatoGravacao) {
                if (data.contains(" ")) {
                    data = data.substring(0, data.indexOf(" "));
                }
                String[] dataTotal = data.split("-");
                ca.set(Integer.parseInt(dataTotal[0]), Integer.parseInt(dataTotal[1]) - 1, Integer.parseInt(dataTotal[2]));
                data = Funcoes.formataData(formato, ca.getTime());
            } else {
                String[] dataTotal = data.split("/");
                ca.set(Integer.parseInt(dataTotal[2]), Integer.parseInt(dataTotal[1]) - 1, Integer.parseInt(dataTotal[0]));
                data = Funcoes.formataData(formato, ca.getTime());
            }
            return data;
        }
        return "";
    }

    private void definirFocoInicial() {
        if (Funcoes.textoVazio(this.textCartaoSUS)) {
            ScreenUtil.requisitarFoco(this.textCartaoSUS);
        } else if (Funcoes.textoVazio(this.textMatricula)) {
            ScreenUtil.requisitarFoco(this.textMatricula);
        } else if (Funcoes.textoVazio(this.textGuia)) {
            ScreenUtil.requisitarFoco(this.textGuia);
        } else if (Funcoes.textoVazio(this.textDataGuia)) {
            ScreenUtil.requisitarFoco(this.textDataGuia);
        }
    }

    private void construirPainelCentral() {
        this.panelCentral.setBorder(this.bordaPadrao);
        this.panelCentral.setLayout(new GridLayout(6, 2, 5, 0));
        this.panelCentral.add(new JLabel("Cart\u00e3o SUS"));
        this.panelCentral.add(new JLabel("Matr\u00edcula"));
        this.panelCentral.add(this.textCartaoSUS);
        this.panelCentral.add(this.textMatricula);
        this.panelCentral.add(new JLabel("Guia"));
        this.panelCentral.add(new JLabel("Data Guia"));
        this.panelCentral.add(this.textGuia);
        this.panelCentral.add(this.textDataGuia);
        this.panelCentral.add(new JLabel("AMB"));
        this.panelCentral.add(new JLabel("ID. Exame"));
        this.panelCentral.add(this.textAMB);
        this.panelCentral.add(this.textIdExame);
    }

    private JPanel construirPainelBotoes() {
        this.getBotaoOK().setText("Salvar");
        this.getBotaoOK().setMnemonic('S');
        this.getBotaoOK().setEnabled(!this.protocoloIntegracaoOperadora.equals((Object)FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.SIMUS));
        this.painelBotoes.setBorder(this.bordaPadrao);
        this.painelBotoes.add((Component)ComponenteFactory.novoJPanelFlowLayout(2, this.botaoSalvarReenviar, this.buttonOK, this.buttonCancelar), "East");
        return this.painelBotoes;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.botaoSalvarReenviar && this.camposValidos()) {
            this.salvarEReenviar = true;
            this.dispose();
        } else if (o == this.buttonOK && this.camposValidos()) {
            this.ok = true;
            this.dispose();
        } else if (o == this.buttonCancelar) {
            this.ok = false;
            this.dispose();
        }
    }

    private boolean camposValidos() {
        if (!this.protocoloIntegracaoOperadora.equals((Object)FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.SIMUS) && Funcoes.textoVazio(this.textDataGuia.getText())) {
            Funcoes.mensagem(this, "Campo Data Guia deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.textDataGuia);
            return false;
        }
        if (!this.protocoloIntegracaoOperadora.equals((Object)FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.SIMUS) && !this.textDataGuia.isConteudoValido()) {
            ScreenUtil.requisitarFoco(this.textDataGuia);
            return false;
        }
        if (this.protocoloIntegracaoOperadora.equals((Object)FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.SIMUS) && Funcoes.textoVazio(this.textIdExame)) {
            Funcoes.mensagem(this, "Campo ID. Exame deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.textIdExame);
            return false;
        }
        return true;
    }

    public String getCartaoSus() {
        return this.textCartaoSUS.getText();
    }

    public String getMatricula() {
        return this.textMatricula.getText();
    }

    public String getGuia() {
        return this.textGuia.getText();
    }

    public String getDataGuia() {
        return this.textDataGuia.getText();
    }

    public boolean isSalvarEReenviar() {
        return this.salvarEReenviar;
    }

    public String getIdExame() {
        return this.textIdExame.getText();
    }
}

