/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao;

import jalis.comum.Conexao;
import jalis.comum.ParametrosUsuarios;
import jalis.comum.Variaveis;
import jalis.laboratorio.exportacao.ConsultarIDSDTO;
import jalis.laboratorio.resultados.IntegracaoIDSSaude;
import jalis.util.CheckItemFiltro;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.SplashMensagem;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.componentes.FiltroFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;

public class ConsultarIDSSaude
extends JPanel
implements ActionListener,
ListSelectionListener {
    private static final long ACESSO = Long.parseLong("0910001200");
    private static final int COLUNA_FILIAL = 0;
    private static final int COLUNA_REQUISICAO = 1;
    private static final int COLUNA_REENVIAR = 3;
    private static final int COLUNA_EXAMES = 4;
    private static final int COLUNA_EXAME_MARCADO = 5;
    private static final int COLUNA_EXAME_OBJECT = 6;
    private static final String COLETA = "coleta";
    private static final String CONVENIO = "convenio";
    private static final String DESTINO = "destino";
    private static final String EXAME = "exame";
    private static final String DATA_INICIAL = "dataInicial";
    private static final String DATA_FINAL = "dataFinal";
    private static final String EXPORTADOS = "somenteExportados";
    private static final String REJEITADOS = "somenteRejeitados";
    private static final String NAO_CONFIGURADOS = "somenteNaoConfigurados";
    private static final String NAO_EXPORTADOS = "somenteNaoExportados";
    private CheckItemFiltro itemFilial;
    private CheckItemFiltro itemRequisicao;
    private CheckItemFiltro itemColeta;
    private CheckItemFiltro itemConvenio;
    private CheckItemFiltro itemDestino;
    private CheckItemFiltro itemExame;
    private CheckItemFiltro itemPaciente;
    private TTextField textDataIni = new TTextField(0, 4);
    private TTextField textDataFin = new TTextField(0, 4);
    private JLabel labelDataIni = new JLabel("Data Inicial:");
    private JLabel labelDataFin = new JLabel("Data Final:");
    private JButton buttonDataIni = ComponenteFactory.novoJButton(this, null, new Dimension(20, 20), true);
    private JButton buttonDataFin = ComponenteFactory.novoJButton(this, null, new Dimension(20, 20), true);
    private JButton buttonConsultar = ComponenteFactory.novoJButton("Consultar", 'C', this, null, null);
    private JButton buttonMarcarExportado = ComponenteFactory.novoJButton("Marcar exportado", 'N', this, null, null);
    private JButton buttonMarcarTodos = ComponenteFactory.novoJButton("Marcar todos", 'T', this, null, null);
    private JButton buttonReenviar = ComponenteFactory.novoJButton("Reenviar", 'E', this, null, null);
    private JButton buttonFechar = ComponenteFactory.novoJButton("Fechar", 'F', this, null, null);
    private JPanel panelRequisicoes = new JPanel(new BorderLayout());
    private JPanel panelExames = new JPanel(new BorderLayout());
    private JPanel panelMensagem = new JPanel(new BorderLayout());
    private JLabel labelExportado = new JLabel("");
    private JPanel panelButtonMarcarTodos = new JPanel(new BorderLayout());
    private JSplitPane panelDireito = new JSplitPane(0, this.panelExames, this.panelMensagem);
    private JSplitPane splitCentral = new JSplitPane(1, this.panelRequisicoes, this.panelDireito);
    private ModeloGridTable modeloRequisicoes = new ModeloGridTable(new String[]{"Filial", "Requisi\u00e7\u00e3o", "Paciente"}){

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 3) {
                return Boolean.class;
            }
            return super.getColumnClass(columnIndex);
        }
    };
    private ModeloGridTable modeloExames = new ModeloGridTable(new String[]{"C\u00f3d.", "Mat.", "Exame", "Data", "Usu\u00e1rio", "#"}){

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 5) {
                return Boolean.class;
            }
            return super.getColumnClass(columnIndex);
        }

        @Override
        public boolean isCellEditable(int row, int columnIndex) {
            return columnIndex == 5;
        }
    };
    private JTextPane textPanelExcecao = new JTextPane();
    private JScrollPane scrollExcecao = new JScrollPane(this.textPanelExcecao);
    private JTable tableExames = ComponenteFactory.novoJTable((TableModel)this.modeloExames, null, 60, 60, 0, 80, 100, 30);
    private JScrollPane scrollExames = new JScrollPane(this.tableExames);
    private JTable tableRequisicoes = ComponenteFactory.novoJTable((TableModel)this.modeloRequisicoes, (ListSelectionListener)this, 40, 80, 0);
    private JScrollPane scrollRequisicoes = new JScrollPane(this.tableRequisicoes);
    public static final String INFO_REQUISICAO = "Requisi\u00e7\u00e3o";
    private JCheckBox checkRejeitados = ComponenteFactory.novoJCheckBox("Listar apenas rejeitados", this);
    private JCheckBox checkNaoConfigurados = ComponenteFactory.novoJCheckBox("Listar apenas n\u00e3o configurados", this);
    private JCheckBox checkNaoExportados = ComponenteFactory.novoJCheckBox("Listar apenas n\u00e3o exportados", this);
    private JCheckBox checkExportados = ComponenteFactory.novoJCheckBox("Listar apenas exportados", this);
    private int posicaoDivisor = 350;
    private static final String POSICAO_DIVISOR = "ExportarResultadoIDS.posicaoDivisor";
    private static final String ULTIMO_FILTRO = "ExportarResultadoIDS.ultimoFiltro";

    public ConsultarIDSSaude() {
        this.montaTela();
    }

    private void montaTela() {
        this.setLayout(new BorderLayout());
        Funcoes.criaBarraDescricao(this, "Consultar IDS Sa\u00fade", "Consulta a requisi\u00e7\u00f5es/resultados exportados para IDS Sa\u00fade", "integracao/export_result_ids.jpg");
        this.construirFiltros();
        this.montaPainelFiltro();
        this.montaPainelRequisicoes();
        this.panelDireito.setDividerLocation(210);
        this.panelExames.setBorder(BorderFactory.createTitledBorder("Exames"));
        this.panelMensagem.setBorder(BorderFactory.createTitledBorder("Mensagem"));
        this.panelExames.setPreferredSize(new Dimension(100, 50));
        this.panelMensagem.setPreferredSize(new Dimension(100, 50));
        this.panelButtonMarcarTodos.add((Component)this.buttonMarcarTodos, "East");
        this.panelExames.add((Component)this.scrollExames, "Center");
        this.panelExames.add((Component)this.panelButtonMarcarTodos, "South");
        this.panelMensagem.add((Component)this.scrollExcecao, "Center");
        this.panelMensagem.add((Component)this.labelExportado, "South");
        this.textPanelExcecao.setEditable(false);
        this.adicionarEventos();
        this.carregarParametros();
        this.controlaBotoes(false);
    }

    private void construirFiltros() {
        CheckItemFiltro filtro;
        Dimension dimensionFiltro = new Dimension(180, 20);
        this.itemFilial = new CheckItemFiltro("Filiais", "Filtrar", "Filtrando filiais", "");
        this.itemFilial.setDados("filiais_postocoleta", new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemFilial.setColunaHint(1);
        this.itemFilial.setPreferredSize(dimensionFiltro);
        this.itemFilial.setMinimumSize(dimensionFiltro);
        this.itemColeta = new CheckItemFiltro("Coleta", "Filtrar", "Filtrando coletas", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemColeta.setDados("coletas", new String[]{"col_codigo", "col_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemColeta.setColunaHint(1);
        this.itemColeta.setPreferredSize(dimensionFiltro);
        this.itemColeta.setMinimumSize(dimensionFiltro);
        this.itemConvenio = new CheckItemFiltro("Conv\u00eanio", "Filtrar", "Filtrando conv\u00eanios", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemConvenio.setDados("convenios", new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Fantasia"}, new int[]{70, 0});
        this.itemConvenio.setColunaHint(1);
        this.itemConvenio.setPreferredSize(dimensionFiltro);
        this.itemConvenio.setMinimumSize(dimensionFiltro);
        this.itemExame = new CheckItemFiltro("Exame", "Filtrar", "Filtrando exames", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemExame.setDados("exames", new String[]{"exa_codigo", "exa_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemExame.setColunaHint(1);
        this.itemExame.setPreferredSize(dimensionFiltro);
        this.itemExame.setMinimumSize(dimensionFiltro);
        this.itemDestino = new CheckItemFiltro("Destino", "Filtrar", "Filtrando destinos", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemDestino.setDados(DESTINO, new String[]{"des_codigo", "des_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemDestino.setColunaHint(1);
        this.itemDestino.setPreferredSize(dimensionFiltro);
        this.itemDestino.setMinimumSize(dimensionFiltro);
        this.itemPaciente = new CheckItemFiltro("Paciente", "Filtrar", "Filtrando pacientes", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemPaciente.setDados("paciente", new String[]{"pac_codigo", "pac_nome"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{70, 0});
        this.itemPaciente.setColunaHint(1);
        this.itemPaciente.setPreferredSize(dimensionFiltro);
        this.itemPaciente.setMinimumSize(dimensionFiltro);
        this.itemRequisicao = filtro = FiltroFactory.filtroItens(INFO_REQUISICAO, "fil_codigo = " + Variaveis.filialPadrao, "requisicao", new String[]{"req_codigo", "pac_codigo", "req_guia", "req_data"}, new String[]{INFO_REQUISICAO, "C\u00f3digo Paciente", "Guia", "Data"}, new int[]{70, 70, 70, 0}, 4, new int[]{0, 1, 2, 3}, 4, false, true, false);
        this.itemRequisicao.setColunaHint(1);
        this.itemRequisicao.setPreferredSize(dimensionFiltro);
        this.itemRequisicao.setMinimumSize(dimensionFiltro);
    }

    private void montaPainelFiltro() {
        Dimension dimensionText = new Dimension(90, 20);
        Dimension dimensionButton = new Dimension(20, 20);
        JPanel panelAux = new JPanel();
        panelAux.setLayout(new BorderLayout());
        this.add((Component)panelAux, "Center");
        JPanel panelFiltro = new JPanel();
        panelAux.add((Component)panelFiltro, "North");
        panelFiltro.setBorder(BorderFactory.createTitledBorder("Filtro"));
        panelFiltro.setLayout(new GridBagLayout());
        Insets insetsNormal = new Insets(0, 0, 0, 0);
        Insets insetsEsquerda = new Insets(0, 20, 0, 0);
        GridBagConstraints cons = new GridBagConstraints();
        cons.anchor = 17;
        cons.fill = 0;
        cons.gridheight = 1;
        cons.gridwidth = 1;
        cons.gridx = 0;
        cons.gridy = 0;
        cons.insets = insetsNormal;
        cons.weightx = 0.0;
        cons.weighty = 0.0;
        panelFiltro.add((Component)this.itemFilial, cons);
        ++cons.gridx;
        cons.insets = insetsEsquerda;
        panelFiltro.add((Component)this.itemColeta, cons);
        ++cons.gridx;
        panelFiltro.add((Component)this.labelDataIni, cons);
        ++cons.gridx;
        cons.insets = insetsNormal;
        this.textDataIni.setPreferredSize(dimensionText);
        this.textDataIni.setMinimumSize(dimensionText);
        panelFiltro.add((Component)this.textDataIni, cons);
        ++cons.gridx;
        this.buttonDataIni.setPreferredSize(dimensionButton);
        this.buttonDataIni.setMinimumSize(dimensionButton);
        panelFiltro.add((Component)this.buttonDataIni, cons);
        ++cons.gridx;
        cons.insets = insetsEsquerda;
        panelFiltro.add((Component)this.checkRejeitados, cons);
        ++cons.gridy;
        cons.gridx = 0;
        cons.insets = insetsNormal;
        panelFiltro.add((Component)this.itemDestino, cons);
        ++cons.gridx;
        cons.insets = insetsEsquerda;
        panelFiltro.add((Component)this.itemConvenio, cons);
        ++cons.gridx;
        panelFiltro.add((Component)this.labelDataFin, cons);
        ++cons.gridx;
        cons.insets = insetsNormal;
        this.textDataFin.setPreferredSize(dimensionText);
        this.textDataFin.setMinimumSize(dimensionText);
        panelFiltro.add((Component)this.textDataFin, cons);
        ++cons.gridx;
        this.buttonDataFin.setPreferredSize(dimensionButton);
        this.buttonDataFin.setMinimumSize(dimensionButton);
        panelFiltro.add((Component)this.buttonDataFin, cons);
        ++cons.gridx;
        cons.insets = insetsEsquerda;
        panelFiltro.add((Component)this.checkNaoConfigurados, cons);
        ++cons.gridy;
        cons.gridx = 0;
        cons.insets = insetsNormal;
        panelFiltro.add((Component)this.itemRequisicao, cons);
        ++cons.gridx;
        cons.insets = insetsEsquerda;
        cons.gridwidth = 2;
        panelFiltro.add((Component)this.itemPaciente, cons);
        ++cons.gridx;
        ++cons.gridx;
        ++cons.gridx;
        ++cons.gridx;
        cons.insets = insetsEsquerda;
        panelFiltro.add((Component)this.checkNaoExportados, cons);
        ++cons.gridy;
        cons.gridx = 0;
        cons.insets = insetsNormal;
        cons.gridwidth = 3;
        panelFiltro.add((Component)this.itemExame, cons);
        ++cons.gridx;
        ++cons.gridx;
        ++cons.gridx;
        ++cons.gridx;
        ++cons.gridx;
        cons.insets = insetsEsquerda;
        panelFiltro.add((Component)this.checkExportados, cons);
        ++cons.gridy;
        cons.gridx = 3;
        cons.gridwidth = 3;
        cons.anchor = 13;
        cons.weightx = 1.0;
        panelFiltro.add((Component)this.buttonConsultar, cons);
        panelAux.add((Component)this.splitCentral, "Center");
        this.splitCentral.setBorder(null);
        this.splitCentral.setDividerSize(3);
        this.splitCentral.setDividerLocation(this.posicaoDivisor);
        panelAux = new JPanel(new FlowLayout(2, 3, 3));
        this.add((Component)ComponenteFactory.novoJPanelBorderLayout(panelAux, null, null, null, null), "South");
        panelAux.add(this.buttonMarcarExportado);
        panelAux.add(this.buttonReenviar);
        panelAux.add(this.buttonFechar);
    }

    private void montaPainelRequisicoes() {
        this.panelRequisicoes.setBorder(BorderFactory.createTitledBorder("Requisi\u00e7\u00f5es"));
        this.panelRequisicoes.add((Component)this.scrollRequisicoes, "Center");
    }

    private void adicionarEventos() {
        this.textDataIni.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    ConsultarIDSSaude.this.buttonDataIni.doClick();
                }
            }
        });
        this.textDataFin.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    ConsultarIDSSaude.this.buttonDataFin.doClick();
                }
            }
        });
        this.tableExames.getSelectionModel().addListSelectionListener(event -> {
            int row = this.tableExames.getSelectedRow();
            if (row > -1 && this.modeloExames != null && this.modeloExames.getRowCount() > 0) {
                ConsultarIDSDTO dto = (ConsultarIDSDTO)this.modeloExames.getValueAt(row, 6);
                String data = Funcoes.textoVazio(dto.getDataHoraExportado()) ? "---" : dto.getDataHoraExportado();
                this.labelExportado.setText("Exportado em " + data);
                this.textPanelExcecao.setText(dto.getMensagem());
                SwingUtilities.invokeLater(() -> this.textPanelExcecao.scrollRectToVisible(new Rectangle(0, 0)));
            }
        });
        this.checkRejeitados.addItemListener(event -> this.desmarcarCheckBoxNaoSelecionado(this.checkRejeitados));
        this.checkExportados.addItemListener(event -> this.desmarcarCheckBoxNaoSelecionado(this.checkExportados));
        this.checkNaoConfigurados.addItemListener(event -> this.desmarcarCheckBoxNaoSelecionado(this.checkNaoConfigurados));
        this.checkNaoExportados.addItemListener(event -> this.desmarcarCheckBoxNaoSelecionado(this.checkNaoExportados));
    }

    private void controlaBotoes(boolean habilitar) {
        this.buttonMarcarExportado.setEnabled(habilitar);
        this.buttonMarcarTodos.setEnabled(habilitar);
        this.buttonReenviar.setEnabled(habilitar);
    }

    private void desmarcarCheckBoxNaoSelecionado(JCheckBox check) {
        if (check.isSelected()) {
            if (!check.equals(this.checkExportados)) {
                this.checkExportados.setSelected(false);
            }
            if (!check.equals(this.checkNaoConfigurados)) {
                this.checkNaoConfigurados.setSelected(false);
            }
            if (!check.equals(this.checkNaoExportados)) {
                this.checkNaoExportados.setSelected(false);
            }
            if (!check.equals(this.checkRejeitados)) {
                this.checkRejeitados.setSelected(false);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.buttonFechar) {
            this.setVisible(false);
            if (this.getParent() != null) {
                this.getParent().removeAll();
            }
        } else if (o == this.buttonMarcarExportado) {
            this.marcarComoExportado();
        } else if (o == this.buttonConsultar) {
            this.consultarRequisicoes();
            this.gravarParametros();
        } else if (o == this.buttonMarcarTodos && !this.checkExportados.isSelected()) {
            this.checkExamesRequisicao(true);
        } else if (o == this.buttonReenviar) {
            this.reenviarExames();
        } else if (o == this.buttonDataIni) {
            Funcoes.mostraData(this.textDataIni, this.buttonDataIni, (JPanel)this.buttonDataIni.getParent(), false);
        } else if (o == this.buttonDataFin) {
            Funcoes.mostraData(this.textDataFin, this.buttonDataFin, (JPanel)this.buttonDataFin.getParent(), false);
        }
    }

    public static long getModuloAcesso() {
        return ACESSO;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        try {
            this.modeloExames.clear();
            this.textPanelExcecao.setText("");
            for (int i = 0; i < this.modeloRequisicoes.getRowCount(); ++i) {
                this.modeloRequisicoes.setValueAt(Boolean.FALSE, i, 3);
            }
            if (this.tableRequisicoes.getSelectedRow() > -1 && this.modeloRequisicoes.getValueAt(this.tableRequisicoes.getSelectedRow(), 4) != null && this.modeloRequisicoes.getValueAt(this.tableRequisicoes.getSelectedRow(), 4) instanceof List) {
                List exames = (List)this.modeloRequisicoes.getValueAt(this.tableRequisicoes.getSelectedRow(), 4);
                exames.forEach(exame -> this.modeloExames.addLine(new Object[]{exame.getCodExame(), exame.getAbreviaturaMaterial(), exame.getDescricaoExame(), exame.getDatahora(), exame.getCodUSuario(), exame.isReenviar(), exame}));
            }
        }
        catch (Exception e1) {
            ErrorLogger.mostraMensagem(this, e1.getMessage(), e1.getStackTrace(), "ExportarResultadoIDS: 315");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void consultarRequisicoes() {
        if (!Funcoes.textoVazio(this.textDataIni.getText()) && !Funcoes.textoVazio(this.textDataFin.getText()) && this.textDataIni.getData().after(this.textDataFin.getData())) {
            Funcoes.mensagem(this, "Data Inicial n\u00e3o pode ser maior que a Data Final.", 5);
            return;
        }
        SplashMensagem spl = SplashMensagem.getInstancia(this);
        try {
            this.modeloRequisicoes.clear();
            this.textPanelExcecao.setText("");
            this.habilitarDesabilitar(false);
            List<ConsultarIDSDTO> dtos = this.carregarDados();
            if (!dtos.isEmpty()) {
                for (ConsultarIDSDTO dto : dtos) {
                    if (this.modeloRequisicoes.localizar(1, dto.getCodRequisicao()) != -1) continue;
                    List exames = dtos.stream().filter(d -> d.getCodFilial().equals(dto.getCodFilial()) && d.getCodRequisicao().equals(dto.getCodRequisicao()) && d.getCodConvenio() == dto.getCodConvenio()).collect(Collectors.toList());
                    this.modeloRequisicoes.addLine(new Object[]{dto.getCodFilial(), dto.getCodRequisicao(), dto.getNomePaciente(), false, exames});
                }
                if (this.modeloRequisicoes.getRowCount() > 0) {
                    this.modeloRequisicoes.ordenarColuna(1, 1, true);
                    this.tableRequisicoes.getSelectionModel().setSelectionInterval(0, 0);
                }
                this.controlaBotoes(true);
            } else {
                this.controlaBotoes(false);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
        }
        finally {
            this.habilitarDesabilitar(true);
            spl.apagar();
        }
    }

    private void checkExamesRequisicao(boolean marca) {
        for (int i = 0; i < this.modeloExames.getRowCount(); ++i) {
            this.modeloExames.setValueAt(marca, i, 5);
        }
    }

    private void carregarParametros() {
        if (ParametrosUsuarios.contemParametro(ULTIMO_FILTRO)) {
            String str = StringUtil.getValor(ParametrosUsuarios.getValor(ULTIMO_FILTRO), "filtro");
            this.setAtributosFiltro(this.itemColeta, StringUtil.getValor(str, COLETA));
            this.setAtributosFiltro(this.itemConvenio, StringUtil.getValor(str, CONVENIO));
            this.setAtributosFiltro(this.itemDestino, StringUtil.getValor(str, DESTINO));
            this.setAtributosFiltro(this.itemExame, StringUtil.getValor(str, EXAME));
            this.textDataIni.setText(StringUtil.getValor(str, DATA_INICIAL));
            this.textDataFin.setText(StringUtil.getValor(str, DATA_FINAL));
            String exportados = StringUtil.getValor(str, EXPORTADOS);
            this.checkExportados.setSelected(Funcoes.textoVazio(exportados) ? false : Boolean.valueOf(exportados));
            String rejeitados = StringUtil.getValor(str, REJEITADOS);
            this.checkRejeitados.setSelected(Funcoes.textoVazio(rejeitados) ? false : Boolean.valueOf(rejeitados));
            String naoConfigurados = StringUtil.getValor(str, NAO_CONFIGURADOS);
            this.checkNaoConfigurados.setSelected(Funcoes.textoVazio(naoConfigurados) ? false : Boolean.valueOf(naoConfigurados));
            String naoExportados = StringUtil.getValor(str, NAO_EXPORTADOS);
            this.checkNaoExportados.setSelected(Funcoes.textoVazio(naoExportados) ? false : Boolean.valueOf(naoExportados));
        } else {
            this.checkRejeitados.setSelected(true);
        }
        if (ParametrosUsuarios.contemParametro(POSICAO_DIVISOR)) {
            this.posicaoDivisor = Integer.parseInt(ParametrosUsuarios.getValor(POSICAO_DIVISOR));
        }
    }

    private void gravarParametros() {
        StringBuilder bui = new StringBuilder();
        bui.append(this.getAtributosFiltro(this.itemColeta, COLETA));
        bui.append(this.getAtributosFiltro(this.itemConvenio, CONVENIO));
        bui.append(this.getAtributosFiltro(this.itemDestino, DESTINO));
        bui.append(this.getAtributosFiltro(this.itemExame, EXAME));
        bui.append(StringUtil.getTag(DATA_INICIAL, this.textDataIni.getText()));
        bui.append(StringUtil.getTag(DATA_FINAL, this.textDataFin.getText()));
        bui.append(StringUtil.getTag(EXPORTADOS, String.valueOf(this.checkExportados.isSelected()).toLowerCase()));
        bui.append(StringUtil.getTag(REJEITADOS, String.valueOf(this.checkRejeitados.isSelected()).toLowerCase()));
        bui.append(StringUtil.getTag(NAO_CONFIGURADOS, String.valueOf(this.checkNaoConfigurados.isSelected()).toLowerCase()));
        bui.append(StringUtil.getTag(NAO_EXPORTADOS, String.valueOf(this.checkNaoExportados.isSelected()).toLowerCase()));
        ParametrosUsuarios.setValor(ULTIMO_FILTRO, StringUtil.getTag("filtro", bui.toString()));
        ParametrosUsuarios.setValor(POSICAO_DIVISOR, String.valueOf(this.splitCentral.getDividerLocation()));
        ParametrosUsuarios.salvarParametros(true);
    }

    private void habilitarDesabilitar(boolean valor) {
        this.tableRequisicoes.setEnabled(valor);
        if (this.tableExames != null) {
            this.tableExames.setEnabled(valor);
        }
        this.itemColeta.setEnabled(valor);
        this.itemConvenio.setEnabled(valor);
        this.itemDestino.setEnabled(valor);
        this.itemExame.setEnabled(valor);
        this.buttonConsultar.setEnabled(valor);
        this.buttonDataFin.setEnabled(valor);
        this.buttonDataIni.setEnabled(valor);
        this.buttonFechar.setEnabled(valor);
        this.labelDataIni.setEnabled(valor);
        this.labelDataFin.setEnabled(valor);
        this.textDataFin.setEnabled(valor);
        this.textDataIni.setEnabled(valor);
        this.checkExportados.setEnabled(valor);
    }

    private List<ConsultarIDSDTO> carregarDados() throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        StringBuilder bui = new StringBuilder("");
        bui.append("SELECT pac.pac_nome,lo.usr_codigo, lo.ids_exportado, lo.ids_codigo, lo.ids_datahora, trim(coalesce(lo.ids_mensagem, '')) as ids_mensagem, req.req_data,req.con_codigo,req.des_codigo,req.col_codigo,req.fil_codigo,fil.fil_descricao,a.req_codigo,");
        bui.append("  a.exa_codigo,a.mco_codigo, e.exa_descricao, mco.mco_abreviatura, lo.ids_datahoraexportado, lo.ids_situacao  ");
        bui.append(" FROM examerequisicao a");
        bui.append(" JOIN exames e ON e.fil_codigo = a.fil_codigo AND e.exa_codigo = a.exa_codigo ");
        bui.append(" JOIN logids lo ON a.fil_codigo = lo.fil_codigo AND a.req_codigo = lo.req_codigo AND a.exa_codigo = lo.exa_codigo AND a.mco_codigo = lo.mco_codigo");
        bui.append(" LEFT JOIN materialcoleta mco on  lo.fil_codigo = mco.fil_codigo and a.mco_codigo = mco.mco_codigo ");
        bui.append(" JOIN filiais_postocoleta fil ON a.fil_codigo = fil.fil_codigo");
        bui.append(" JOIN requisicao req ON req.fil_codigo = a.fil_codigo AND req.req_codigo = a.req_codigo ");
        bui.append(" JOIN paciente pac ON pac.fil_codigo = req.fil_codigo AND pac.pac_codigo = req.pac_codigo ");
        bui.append(" WHERE 1=1 ");
        if (this.checkExportados.isSelected()) {
            bui.append(" and lo.ids_exportado = true and lo.ids_falha = false ");
        }
        if (this.checkNaoExportados.isSelected()) {
            bui.append(" and lo.ids_exportado = false ");
        }
        if (this.itemFilial.isSelected()) {
            this.addExpressao(bui, ConsultarIDSSaude.getExpressao("a.fil_codigo", this.itemFilial.getSelecionados(0), false));
        }
        if (this.itemColeta.isSelected()) {
            this.addExpressao(bui, ConsultarIDSSaude.getExpressao("req.col_codigo", this.itemColeta.getSelecionados(0), true));
        }
        if (this.itemConvenio.isSelected()) {
            this.addExpressao(bui, ConsultarIDSSaude.getExpressao("req.con_codigo", this.itemConvenio.getSelecionados(0), false));
        }
        if (Funcoes.verificaData(this.textDataIni.getText())) {
            bui.append(bui.length() > 0 ? " and " : "");
            bui.append(" req.req_data >= '");
            bui.append(Funcoes.formataData("yyyy-MM-dd", sdf.parse(this.textDataIni.getText())));
            bui.append("' ");
        }
        if (Funcoes.verificaData(this.textDataFin.getText())) {
            bui.append(bui.length() > 0 ? " and " : "");
            bui.append("req.req_data <= '");
            bui.append(Funcoes.formataData("yyyy-MM-dd", sdf.parse(this.textDataFin.getText())));
            bui.append("' ");
        }
        if (this.itemDestino.isSelected()) {
            this.addExpressao(bui, ConsultarIDSSaude.getExpressao("req.des_codigo", this.itemDestino.getSelecionados(0), true));
        }
        if (this.itemExame.isSelected()) {
            this.addExpressao(bui, ConsultarIDSSaude.getExpressao("a.exa_codigo", this.itemExame.getSelecionados(0), true));
        }
        if (this.itemPaciente.isSelected()) {
            this.addExpressao(bui, ConsultarIDSSaude.getExpressao("req.pac_codigo", this.itemPaciente.getSelecionados(0), false));
        }
        if (this.itemRequisicao.isSelected()) {
            this.addExpressao(bui, ConsultarIDSSaude.getExpressao("req.req_codigo", this.itemRequisicao.getSelecionadosAvancado(0), false));
        }
        if (this.checkSelecionado()) {
            bui.append(" and (ids_situacao = ").append(this.getSituacaoSelecionada());
        }
        bui.append(" order by a.fil_codigo, a.req_codigo, a.exa_codigo, a.mco_codigo, lo.ids_codigo ");
        Statement st = Conexao.getStatement();
        ResultSet rs = Conexao.executeQuery(st, bui.toString());
        ArrayList<ConsultarIDSDTO> dtos = new ArrayList<ConsultarIDSDTO>();
        while (rs.next()) {
            ConsultarIDSDTO dto = ConsultarIDSDTO.getInstancia();
            dto.setAbreviaturaMaterial(rs.getString("mco_abreviatura"));
            dto.setCodConvenio(rs.getInt("con_codigo"));
            dto.setCodExame(rs.getString("exa_codigo"));
            dto.setCodFilial(rs.getString("fil_codigo"));
            dto.setCodigo(rs.getInt("ids_codigo"));
            dto.setCodMaterial(rs.getString("mco_codigo"));
            dto.setCodRequisicao(rs.getString("req_codigo"));
            dto.setCodUSuario(rs.getString("usr_codigo"));
            dto.setDatahora(Funcoes.formataData(rs.getDate("ids_datahora")));
            String dataHoraExportado = rs.getDate("ids_datahoraexportado") != null ? Funcoes.formataData("dd/MM/yyyy kk:mm", rs.getDate("ids_datahoraexportado")) : "";
            dto.setDataHoraExportado(dataHoraExportado);
            dto.setDescricaoExame(rs.getString("exa_descricao"));
            dto.setExportado(rs.getBoolean("ids_exportado"));
            dto.setMensagem(rs.getString("ids_mensagem"));
            dto.setNomePaciente(rs.getString("pac_nome"));
            dto.setSituacao(rs.getString("ids_situacao"));
            dtos.add(dto);
        }
        Conexao.fecharStatement(st);
        return dtos;
    }

    private boolean checkSelecionado() {
        return this.checkExportados.isSelected() || this.checkNaoConfigurados.isSelected() || this.checkNaoExportados.isSelected() || this.checkRejeitados.isSelected();
    }

    private String getSituacaoSelecionada() {
        String situacao = "";
        if (this.checkExportados.isSelected()) {
            situacao = " 'E' or ids_situacao = 'M' or ids_situacao = '' or ids_situacao is null";
        } else if (this.checkNaoConfigurados.isSelected()) {
            situacao = " 'N' ";
        } else if (this.checkNaoExportados.isSelected()) {
            situacao = " '' or ids_situacao is null ";
        } else if (this.checkRejeitados.isSelected()) {
            situacao = " 'R' ";
        }
        return situacao + " )";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void reenviarExames() {
        marcado = false;
        reenviado = false;
        mensagem = "";
        for (i = 0; i < this.modeloExames.getRowCount(); ++i) {
            block9: {
                dto = (ConsultarIDSDTO)this.modeloExames.getValueAt(i, 6);
                marcado = (Boolean)this.modeloExames.getValueAt(i, 5);
                mensagem = dto.getMensagem();
                if (!marcado) continue;
                reenviado = true;
                buf = new StringBuilder();
                buf.append("select req.fil_codigo, ");
                buf.append("       req.req_codigo, ");
                buf.append("       req.req_xmlagendamentoids, ");
                buf.append("       req.con_codigo, ");
                buf.append("       req.req_anomes, ");
                buf.append("       req.req_idade, ");
                buf.append("       req.req_codigoapoiado, ");
                buf.append("       req.des_codigo, ");
                buf.append("       exr.exa_codigo, ");
                buf.append("       exr.mco_codigo, ");
                buf.append("       exr.met_codigo, ");
                buf.append("       exr.exr_situacao, ");
                buf.append("       0 as logids, ");
                buf.append("       0 as filial, ");
                buf.append("       err.ert_resultado as exr_resultado ");
                buf.append("  from examerequisicao exr ");
                buf.append("  join examerequisicaoresultado err on exr.fil_codigo = err.fil_codigo and exr.req_codigo = err.req_codigo and exr.exa_codigo = err.exa_codigo and exr.mco_codigo = err.mco_codigo");
                buf.append("  join requisicao req on req.fil_codigo = exr.fil_codigo and req.req_codigo = exr.req_codigo ");
                buf.append(" where ");
                buf.append("   req.fil_codigo = ").append(this.modeloRequisicoes.getValueAt(this.tableRequisicoes.getSelectedRow(), 0));
                buf.append("   and req.req_codigo = ").append(this.modeloRequisicoes.getValueAt(this.tableRequisicoes.getSelectedRow(), 1));
                buf.append("   and exr.exa_codigo = ").append(StringUtil.textoDBEscape(dto.getCodExame()));
                buf.append("   and exr.mco_codigo = ").append(StringUtil.textoDBEscape(dto.getCodMaterial()));
                st = Conexao.getStatement();
                rs = Conexao.executeQuery(st, buf.toString());
                listaExames = new ArrayList<Registro>();
                if (!rs.next()) ** GOTO lbl79
                if (rs.getString("exr_situacao").equalsIgnoreCase("C") || rs.getString("exr_situacao").equalsIgnoreCase("I") || rs.getString("exr_situacao").equalsIgnoreCase("E")) break block9;
                Funcoes.mensagem(this, "Situa\u00e7\u00e3o do exame n\u00e3o permite enviar o resultado para o IDS.", 2);
                Conexao.fecharStatement(new Statement[]{st});
                continue;
            }
            try {
                layout = ExameUtil.getCodigoLayout(rs.getString("fil_codigo"), rs.getString("con_codigo"), rs.getString("des_codigo"));
                do {
                    reg = new Registro(rs);
                    reg.setValor("ids_mensagem", mensagem);
                    reg.setValor("codigoLayout", layout);
                    reg.setValor("logids", dto.getCodigo());
                    reg.setValor("filial", this.modeloRequisicoes.getValueAt(this.tableRequisicoes.getSelectedRow(), 0));
                    listaExames.add(reg.clone());
                } while (rs.next());
lbl79:
                // 2 sources

                rs.close();
                for (Registro reg : listaExames) {
                    msg = reg.getString("ids_mensagem") + "\nReenvio solicitado por " + Variaveis.login + " em " + Funcoes.formataData("dd/MM/yyyy kk:mm:ss", new Date());
                    exportado = dto.getSituacao().equals("N");
                    IntegracaoIDSSaude.atualizarLog(st, Integer.valueOf(reg.getString("logids")), msg, exportado, "C");
                    IntegracaoIDSSaude.adicionarLog(st, reg.getInt("fil_codigo"), reg.getInt("req_codigo"), reg.getString("exa_codigo"), reg.getInt("mco_codigo"));
                    Conexao.arquivaSQL();
                    this.consultarRequisicoes();
                }
                Conexao.arquivaSQL();
                Funcoes.mensagem(this, "Exames adicionados para envio", 2);
            }
            catch (Exception e) {
                try {
                    this.anularSQL();
                    ErrorLogger.mostraMensagem(this, "N\u00e2o foi poss\u00edvel carregar os logs.\n" + e.getMessage(), e.getStackTrace());
                }
                catch (Throwable var14_15) {
                    Conexao.fecharStatement(new Statement[]{st});
                    throw var14_15;
                }
                Conexao.fecharStatement(new Statement[]{st});
                continue;
            }
            Conexao.fecharStatement(new Statement[]{st});
            continue;
        }
        if (reenviado) {
            this.consultarRequisicoes();
        }
    }

    private void marcarComoExportado() {
        if (this.modeloExames != null && this.modeloExames.getRowCount() > 0) {
            ArrayList<ConsultarIDSDTO> dtos = new ArrayList<ConsultarIDSDTO>();
            try {
                for (int i = 0; i < this.modeloExames.getRowCount(); ++i) {
                    boolean exameSelecionado = (Boolean)this.modeloExames.getValueAt(i, 5);
                    if (!exameSelecionado) continue;
                    dtos.add((ConsultarIDSDTO)this.modeloExames.getValueAt(i, 6));
                }
                this.marcarExportadoManual(dtos);
                this.consultarRequisicoes();
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel marcar o log como exportado.\n" + e.getMessage(), e.getStackTrace());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void marcarExportadoManual(List<ConsultarIDSDTO> dtos) {
        StringBuilder sql = new StringBuilder(" update logids set ");
        sql.append(" ids_situacao = ").append(StringUtil.textoDBEscape("M"));
        sql.append(" ,ids_exportado = true ");
        sql.append(" ,ids_datahoraexportado = now()");
        sql.append(" ,ids_mensagem = ? ");
        sql.append(" where fil_codigo = ?");
        sql.append(" and ids_codigo = ? ");
        PreparedStatement pst = Conexao.getPreparedStatement(sql.toString());
        try {
            for (ConsultarIDSDTO dto : dtos) {
                String separadorMennsagem = dto.getMensagem().length() > 0 ? " - " : "";
                String mensagemAnterior = dto.getMensagem();
                pst.setString(1, mensagemAnterior + separadorMennsagem + "Marcado como exportado");
                pst.setInt(2, Integer.parseInt(dto.getCodFilial()));
                pst.setInt(3, dto.getCodigo());
                pst.execute();
            }
            Conexao.arquivaSQL();
            this.textPanelExcecao.setText("");
        }
        catch (Exception e) {
            try {
                this.anularSQL();
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel marcar o log como exportado.\n" + e.getMessage(), e.getStackTrace());
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(pst);
                throw throwable;
            }
            Conexao.fecharStatement(pst);
        }
        Conexao.fecharStatement(pst);
    }

    private void anularSQL() {
        try {
            Conexao.anulaSQL();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String nomeArquivoErro() {
        Date dt = new Date();
        StringBuilder nome = new StringBuilder();
        nome.append(System.getProperty("user.home"));
        nome.append("/ErroIntegracaoIds_");
        nome.append(Funcoes.formataData("yyyyMMdd_HHmmss", dt));
        nome.append(".log");
        return nome.toString();
    }

    private void addExpressao(StringBuilder bui, String exp) {
        if (exp != null && exp.length() > 0) {
            if (bui.length() > 0) {
                bui.append("and ");
            }
            bui.append(exp);
            bui.append(' ');
        }
    }

    private String getAtributosFiltro(CheckItemFiltro item, String nome) {
        StringBuilder bui = new StringBuilder();
        bui.append(StringUtil.getTag("sel", String.valueOf(item.isSelected())));
        bui.append(StringUtil.getTag("item", item.getSelecionados(0)));
        return StringUtil.getTag(nome, bui.toString());
    }

    private void setAtributosFiltro(CheckItemFiltro item, String atributos) {
        if (StringUtil.getBoolean(atributos, "sel")) {
            item.setSelected(true);
            item.setSelecionados(StringUtil.getValores(atributos, "item"));
        }
    }

    public void pressioneiF2() {
        if (this.textDataIni.hasFocus()) {
            Funcoes.mostraData(this.textDataIni, this.buttonDataIni, this, true);
        } else if (this.textDataFin.hasFocus()) {
            Funcoes.mostraData(this.textDataFin, this.buttonDataFin, this, true);
        }
    }

    public static String getExpressao(String campo, String[] valores, boolean aspas) {
        if (campo != null && valores != null && valores.length > 0) {
            StringBuilder buf = new StringBuilder("(");
            for (int i = 0; i < valores.length; ++i) {
                if (i > 0) {
                    buf.append(" or ");
                }
                buf.append(campo);
                buf.append(" = ");
                if (aspas) {
                    buf.append('\'');
                }
                buf.append(StringUtil.textoDB(valores[i]));
                if (!aspas) continue;
                buf.append('\'');
            }
            return buf.append(")").toString();
        }
        return "";
    }
}

