/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao;

import jalis.comum.Variaveis;
import jalis.integracaooperadoras.sistemas.FabricaIntegracaoOperadora;
import jalis.integracaooperadoras.sistemas.util.LogIntegracaoOperadora;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.exportacao.CorrigirLogIntegracaoOperadora;
import jalis.laboratorio.exportacao.integracao.IntegracaoException;
import jalis.laboratorio.exportacao.operadora.ConsultaIntegracao;
import jalis.laboratorio.exportacao.operadora.ConsultaIntegracaoOperadoraFactory;
import jalis.laboratorio.exportacao.operadora.RetornoOperadora;
import jalis.laboratorio.exportacao.operadora.util.Filtros;
import jalis.laboratorio.exportacao.operadora.util.IntervaloData;
import jalis.model.dao.exportacao.ConsultaIntegracaoDao;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.util.Calendar;
import java.util.List;

public class ConsultaIntegracaoService {
    public static final String NAO_ENVIADO = "N\u00e3o Enviado";
    public static final String REJEITADO = "Rejeitado";
    public static final String ENVIADO = "Enviado";
    public static final String NAO_CONFIGURADO = "N\u00e3o Configurado";
    public static final String EXPORTADO_MANUAL = "Exportado Manual";
    public static final String CORRIGIDO = "Corrigido";
    private ConsultaIntegracao consultaIntegracao;
    private final ConsultaIntegracaoDao dao = new ConsultaIntegracaoDao();

    public int consultaLogsHaEnviar(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora protocoloSelecionado) throws IntegracaoException {
        this.consultaIntegracao = ConsultaIntegracaoOperadoraFactory.criar(protocoloSelecionado);
        return this.consultaIntegracao.consultarLogsHaEnviar();
    }

    public RetornoOperadora reenviarLog(LogIntegracaoOperadora log, FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora protocoloSelecionado) throws IntegracaoException {
        this.consultaIntegracao = ConsultaIntegracaoOperadoraFactory.criar(protocoloSelecionado);
        return this.consultaIntegracao.reenviarLog(log);
    }

    public List<Registro> buscarRegistrosLog(IntervaloData intervalo, Filtros itens, FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora protocoloSelecionado, boolean filtraLogsRejeitados) throws IntegracaoException {
        this.consultaIntegracao = ConsultaIntegracaoOperadoraFactory.criar(protocoloSelecionado);
        return this.consultaIntegracao.buscarRegistros(intervalo, itens, filtraLogsRejeitados);
    }

    public ConsultaIntegracao getConsultaIntegracao() {
        return this.consultaIntegracao;
    }

    public String construirDadosPainelInformacoes(Registro reg, int larguraExibicao) {
        int largPrimeiraColuna = larguraExibicao > 700 ? 500 : 280;
        int largColunas = larguraExibicao > 700 ? 250 : 180;
        int fontSize = larguraExibicao > 700 ? 11 : 10;
        String dataGuia = this.getFormatData(reg.getString("dataGuia"), true, "dd/MM/yyyy");
        String dataLog = this.getFormatData(reg.getString("dataLog"), true, "dd/MM/yyyy");
        StringBuilder inf = new StringBuilder("<html>");
        inf.append(String.format("<table style='font-size:%dpt; font-family: monospace;' border='0' cellspacing='0' cellpadding='0'>", fontSize));
        inf.append("<tr>");
        inf.append(String.format("<td width='%d'>Paciente: ", largPrimeiraColuna)).append(Funcoes.preencheVazioHtml(reg.getString("nomePaciente"), 4, 1)).append("</td>");
        inf.append(String.format("<td width='%d'>Conv\u00eanio: ", largColunas)).append(Funcoes.preencheVazioHtml(reg.getString("descricaoConvenio"), 4, 1)).append("</td>");
        inf.append(String.format("<td width='%d'>Guia: ", largColunas)).append(Funcoes.preencheVazioHtml(reg.getString("guia"), 4, 1)).append("</td>");
        inf.append("</tr>");
        inf.append("<tr>");
        inf.append(String.format("<td width='%d'>Cart\u00e3o SUS: ", largPrimeiraColuna)).append(Funcoes.preencheVazioHtml(reg.getString("cartaosus"), 4, 1)).append("</td>");
        inf.append(String.format("<td width='%d'>Matr\u00edcula: ", largColunas)).append(Funcoes.preencheVazioHtml(reg.getString("matricula"), 4, 1)).append("</td>");
        inf.append(String.format("<td width='%d'>Data Guia: ", largColunas)).append(Funcoes.preencheVazioHtml(dataGuia, 4, 1)).append("</td>");
        inf.append("</tr>");
        inf.append("<tr>");
        inf.append(String.format("<td width='%d'>Data Log: ", largPrimeiraColuna)).append(Funcoes.preencheVazioHtml(dataLog, 4, 1)).append("</td>");
        inf.append(String.format("<td width='%d'>Sit. Log: ", largColunas)).append(Funcoes.preencheVazioHtml(this.getSituacaoLog(reg.getString("situacaoLog")), 4, 1)).append("</td>");
        inf.append(String.format("<td width='%d'>AMB: ", largColunas)).append(Funcoes.preencheVazioHtml(reg.getString("amb"), 4, 1)).append("</td>");
        inf.append("</tr>");
        inf.append("<tr>");
        inf.append(String.format("<td width='%d'>Observacao: ", largPrimeiraColuna)).append(Funcoes.preencheVazioHtml(reg.getString("observacao"), 4, 1)).append("</td>");
        inf.append("</tr>");
        inf.append("</table>");
        inf.append("</html>");
        return inf.toString();
    }

    public Registro corrigirLog(Registro log, FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora protocoloSelecionado) {
        CorrigirLogIntegracaoOperadora corrigir = CorrigirLogIntegracaoOperadora.getInstancia(Laboratorio.getInstancia(), log, protocoloSelecionado);
        corrigir.setVisible(true);
        Registro dadosCorrigidos = new Registro();
        if (corrigir.isSalvarEReenviar() || corrigir.getOK()) {
            dadosCorrigidos = this.getDadosCorrigidos(corrigir, log);
            this.atualizarDados(dadosCorrigidos);
            LogIntegracaoOperadora logIntegracao = this.getLogIntegracaoOperadora(dadosCorrigidos);
            try {
                this.reenviarLog(logIntegracao, protocoloSelecionado);
                dadosCorrigidos.setValor("situacaoLog", "");
            }
            catch (IntegracaoException e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
            }
        }
        return dadosCorrigidos;
    }

    private void atualizarDados(Registro dadosCorrigidos) {
        this.dao.inserirLogCorrigido(dadosCorrigidos);
        this.dao.atualizarDadosRequisicao(dadosCorrigidos);
        this.dao.atualizarDadosExameRequisicao(dadosCorrigidos);
    }

    private Registro getDadosCorrigidos(CorrigirLogIntegracaoOperadora corrigir, Registro log) {
        Registro dadosCorrigidos = log.clone();
        dadosCorrigidos.setValor("idExame", corrigir.getIdExame());
        dadosCorrigidos.setValor("guia", corrigir.getGuia());
        dadosCorrigidos.setValor("matricula", corrigir.getMatricula());
        dadosCorrigidos.setValor("dataGuia", this.getFormatData(corrigir.getDataGuia(), false, "yyyy-MM-dd"));
        dadosCorrigidos.setValor("cartaosus", corrigir.getCartaoSus());
        dadosCorrigidos.setValor("retorno", null);
        dadosCorrigidos.setValor("situacaoLog", "C");
        return dadosCorrigidos;
    }

    public String getFormatData(String data, boolean formatoGravacao, String formato) {
        Calendar ca = Calendar.getInstance();
        if (!Funcoes.textoVazio(data)) {
            if (formatoGravacao) {
                if (data.contains(" ")) {
                    data = data.substring(0, data.indexOf(" "));
                }
                String[] dataTotal = data.split("-");
                ca.set(Integer.parseInt(dataTotal[0]), Integer.parseInt(dataTotal[1]) - 1, Integer.parseInt(dataTotal[2]));
                data = Funcoes.formataData(formato, ca.getTime());
            } else {
                String[] dataTotal = data.split("/");
                ca.set(Integer.parseInt(dataTotal[2]), Integer.parseInt(dataTotal[1]) - 1, Integer.parseInt(dataTotal[0]));
                data = Funcoes.formataData(formato, ca.getTime());
            }
            return data;
        }
        return "";
    }

    public String getSituacaoLog(String situacao) {
        if (Funcoes.textoVazio(situacao)) {
            situacao = NAO_ENVIADO;
        } else if (situacao.equalsIgnoreCase("E")) {
            situacao = ENVIADO;
        } else if (situacao.equalsIgnoreCase("R")) {
            situacao = REJEITADO;
        } else if (situacao.equalsIgnoreCase("N")) {
            situacao = NAO_CONFIGURADO;
        } else if (situacao.equalsIgnoreCase("T")) {
            situacao = EXPORTADO_MANUAL;
        } else if (situacao.equalsIgnoreCase("C")) {
            situacao = CORRIGIDO;
        }
        return situacao;
    }

    public LogIntegracaoOperadora getLogIntegracaoOperadora(Registro log) {
        String codigoFilial = (String)log.getValor("filial");
        String codigoLog = (String)log.getValor("log");
        String codigoRequisicao = (String)log.getValor("Requisi\u00e7\u00e3o");
        String codigoPaciente = (String)log.getValor("codigoPaciente");
        String codigoExame = (String)log.getValor("exame");
        String codigoMaterial = (String)log.getValor("codigoMaterial");
        String tipoOperacao = (String)log.getValor("tipoOperacao");
        String xmlLog = (String)log.getValor("xmlLog");
        String retorno = (String)log.getValor("retorno");
        String situacao = (String)log.getValor("situacao");
        String codigoConvenio = log.getString("codigoConvenio");
        return new LogIntegracaoOperadora(Integer.parseInt(codigoFilial != null ? codigoFilial : Variaveis.filialPadrao), Long.parseLong(codigoLog), codigoRequisicao == null ? null : Integer.valueOf(Integer.parseInt(codigoRequisicao)), codigoPaciente, codigoExame, Integer.parseInt(codigoMaterial != null ? codigoMaterial : "0"), tipoOperacao, xmlLog, retorno, situacao, Integer.parseInt(!Funcoes.textoVazio(codigoConvenio) ? codigoConvenio : "0"));
    }

    public void alterarLogExportado(Registro reg, boolean exportado) {
        this.dao.atualizarDadosExportaIntegracaoOperadora(reg, exportado);
    }

    public void teste(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora protocoloSelecionado) throws IntegracaoException {
        this.consultaIntegracao = ConsultaIntegracaoOperadoraFactory.criar(protocoloSelecionado);
        this.consultaIntegracao.teste();
    }

    public boolean verificaLogPrecisandoCorrecao(Registro reg, FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora protocoloSelecionado) {
        return this.dao.verificaLogPrecisandoCorrecao(reg, protocoloSelecionado);
    }
}

