/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao;

import jalis.comum.ConstantesGerais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.integracaooperadoras.sistemas.FabricaIntegracaoOperadora;
import jalis.integracaooperadoras.sistemas.util.LogIntegracaoOperadora;
import jalis.laboratorio.exportacao.ConsultaIntegracaoService;
import jalis.laboratorio.exportacao.integracao.IntegracaoException;
import jalis.laboratorio.exportacao.operadora.util.Filtros;
import jalis.laboratorio.exportacao.operadora.util.IntervaloData;
import jalis.util.CheckItemFiltro;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextAreaDocument;
import jalis.util.TTextField;
import jalis.util.TableUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.componentes.FiltroFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;

public class ConsultaIntegracaoOperadora
extends JPanel
implements ActionListener {
    private static final String DATA_HORA_MINUTO = "dd/MM/yyyy HH:MM";
    private static final String FILTRO_NAO_ENVIADO = "N\u00e3o Enviados";
    private static final String FILTRO_ENVIADOS = "Enviados";
    private static final String FILTRO_TODOS = "Todos";
    private static final String EXPORTADO = "Sim";
    private static final String NAO_EXPORTADO = "N\u00e3o";
    private static final long ACESSO = Long.parseLong("0909000301");
    public static final int COLUNA_FILIAL = 0;
    public static final int COLUNA_REQUISICAO = 1;
    public static final int COLUNA_DATA_HORA_REQ = 2;
    public static final int COLUNA_LOG_OBJETO = 3;
    public static final int COLUNA_LOG_OBJETO_EXAME = 7;
    private static final int[] MEDIDA_COLUNAS_TABLE_REQUISICOES = new int[]{60, 0, 120};
    private ModeloGridTable modeloRequisicoes = new ModeloGridTable(new String[]{"Filial", "Req", "Data/Hora Req."});
    private JTable tableRequisicoes = ComponenteFactory.novoJTable((TableModel)this.modeloRequisicoes, MEDIDA_COLUNAS_TABLE_REQUISICOES);
    private JScrollPane scrollRequisicoes = new JScrollPane(this.tableRequisicoes);
    private static final int[] MEDIDA_COLUNAS_TABLE_EXAMES = new int[]{70, 70, 60, 0, 120, 90, 90};
    private ModeloGridTable modeloExames = new ModeloGridTable(new String[]{"Log", "C\u00f3digo", "Mat.", "Exame", "Data/Hora Conf.", "Usu\u00e1rio", "Sit."});
    private JTable tableExames = ComponenteFactory.novoJTable((TableModel)this.modeloExames, MEDIDA_COLUNAS_TABLE_EXAMES);
    private DefaultTableCellRenderer rendererExames = null;
    private JScrollPane scrollExames = new JScrollPane(this.tableExames);
    private transient Registro logSelecionado = null;
    private JPanel panelBotoesEsquerda = new JPanel(new FlowLayout(0));
    private JPanel panelRequisicoes = new JPanel(new BorderLayout());
    private JPanel panelPesquisa = new JPanel(new BorderLayout());
    private JPanel panelExames = new JPanel(new BorderLayout());
    private JLabel labelInformacoes = new JLabel();
    private CheckItemFiltro itemRequisicao;
    private CheckItemFiltro itemPaciente;
    private CheckItemFiltro itemFilial;
    private CheckItemFiltro itemConvenio;
    private CheckItemFiltro itemSituacao;
    private CheckItemFiltro itemExame;
    private TTextField textDataIni = new TTextField(0, 4);
    private TTextField textDataFin = new TTextField(0, 4);
    private JLabel labelDataIni = new JLabel("Data Inicial:");
    private JLabel labelDataFin = new JLabel("Data Final:");
    private JButton buttonDataIni = ComponenteFactory.novoJButton(this, null, new Dimension(20, 20), true);
    private JButton buttonDataFin = ComponenteFactory.novoJButton(this, null, new Dimension(20, 20), true);
    private JLabel labelExibirExportado = new JLabel("Exporta\u00e7\u00e3o");
    private JComboBox itemExibirExportado = ComponenteFactory.novoJComboBox(new Dimension(121, 20));
    private ArrayList<Registro> logs = new ArrayList();
    private JLabel labelLocalizar = new JLabel("Localizar:");
    private JLabel labelLogsEnviar = new JLabel("Logs para enviar:");
    private TTextField textLocalizar = new TTextField(0, 1);
    private JLabel textLogsEnviar = new JLabel("");
    private JComboBox<String> comboLocalizarLogs = new JComboBox<String>(new String[]{"Requisi\u00e7\u00e3o", "Logs"});
    private final JTextArea textRetorno = new JTextArea(new TTextAreaDocument(2000));
    private JTextArea textXmlEnvio = new JTextArea(new TTextAreaDocument(2000));
    private JTextArea textXmlRetorno = new JTextArea(new TTextAreaDocument(1000000));
    private JTextArea textSugestao = new JTextArea(new TTextAreaDocument(5000));
    private JLabel labelSugestao = new JLabel("Sugest\u00e3o:");
    private JButton buttonCorrigir = ComponenteFactory.novoJButton("Corrigir", 'G', this, null, null);
    private JButton buttonReenviar = ComponenteFactory.novoJButton("Reenviar", 'R', this, null, null);
    private JButton buttonConsultar = ComponenteFactory.novoJButton("Consultar", 'C', this, null, null);
    private final JButton buttonOpcoes = ComponenteFactory.novoJButton("Op\u00e7\u00f5es \u25bc", 'O', this, null, null);
    private final JPopupMenu menuOpcoes = new JPopupMenu();
    private JMenuItem buttonMarcarExportado = ComponenteFactory.novoJMenuItem("Marcar exportado", 'M', (ActionListener)this);
    private JMenuItem buttonDesmarcarExportado = ComponenteFactory.novoJMenuItem("Desmarcar exportado", 'M', (ActionListener)this);
    private JButton buttonNovo = ComponenteFactory.novoJButton("Novo", 'N', this, null, null);
    private JButton buttonFechar = ComponenteFactory.novoJButton("Fechar", 'F', this, null, null);
    private static final String[] ARRAY_SITUACAO = new String[]{"N\u00e3o Enviados", "Enviados", "Todos"};
    private JComboBox comboOperadora = ComponenteFactory.novoJComboBox((Object[])FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.values(), this, true, new Dimension(150, 20));
    private JCheckBox checkApresentarSomenteRejeitados = new JCheckBox("Apresentar somente rejeitados");
    private ConsultaIntegracaoService service = new ConsultaIntegracaoService();

    public ConsultaIntegracaoOperadora() {
        this.montaTela();
    }

    private void montaTela() {
        this.setLayout(new BorderLayout());
        JPanel northPanel = new JPanel(new BorderLayout());
        Funcoes.criaBarraDescricao(northPanel, "Consulta Integra\u00e7\u00e3o Operadora", "Consulta logs de integra\u00e7\u00e3o com operadora", "integracao/consulta_operadora.jpg");
        this.adicionarRenderer();
        this.construirFiltros();
        this.montaPainelRequisicoes();
        this.montaPainelExames();
        this.adicionarBotoes();
        JPanel panelFiltros = new JPanel();
        this.montaPainelFiltros(panelFiltros);
        northPanel.add((Component)panelFiltros, "South");
        this.add((Component)northPanel, "North");
        this.add((Component)this.panelRequisicoes, "West");
        this.add((Component)this.panelExames, "Center");
        this.adicionarListSelectionListener();
        this.adicionarDocumentListener();
        this.adicionarActionListener();
        this.adicionarFocusListener();
        this.adicionarKeyListener();
        this.habilitarFiltros(false);
        Funcoes.montaEnter((JComponent)this);
    }

    private void habilitarFiltros(boolean habilita) {
        this.itemRequisicao.getCheckBox().setEnabled(habilita);
        this.itemConvenio.getCheckBox().setEnabled(habilita);
        this.itemExame.getCheckBox().setEnabled(habilita);
        this.itemFilial.getCheckBox().setEnabled(habilita);
        this.itemPaciente.getCheckBox().setEnabled(habilita);
        this.itemExibirExportado.setEnabled(habilita);
        this.textDataIni.setEnabled(habilita);
        this.textDataFin.setEnabled(habilita);
        this.buttonDataIni.setEnabled(habilita);
        this.buttonDataFin.setEnabled(habilita);
        this.checkApresentarSomenteRejeitados.setSelected(true);
        this.checkApresentarSomenteRejeitados.setEnabled(habilita);
        if (this.getProtocoloSelecionado() == null) {
            this.itemSituacao.setEnabled(habilita);
        }
        this.buttonConsultar.setEnabled(habilita);
    }

    private void adicionarBotoes() {
        this.buttonOpcoes.setEnabled(false);
        this.buttonCorrigir.setEnabled(false);
        this.buttonReenviar.setEnabled(false);
        this.menuOpcoes.add(this.buttonMarcarExportado);
        this.menuOpcoes.add(this.buttonDesmarcarExportado);
        JPanel panelBotoesDireita = new JPanel(new FlowLayout(2));
        panelBotoesDireita.add(this.buttonNovo);
        panelBotoesDireita.add(this.buttonFechar);
        JPanel panelBotoes = new JPanel(new BorderLayout());
        this.panelBotoesEsquerda.add(this.buttonOpcoes);
        panelBotoes.add((Component)panelBotoesDireita, "East");
        panelBotoes.add((Component)this.panelBotoesEsquerda, "West");
        this.add((Component)panelBotoes, "South");
    }

    private void construirFiltros() {
        CheckItemFiltro filtro;
        this.textDataIni.setPreferredSize(new Dimension(100, 20));
        this.textDataIni.setMinimumSize(new Dimension(100, 20));
        this.buttonDataIni.setFocusable(false);
        this.buttonDataIni.setPreferredSize(new Dimension(20, 20));
        this.buttonDataIni.setMinimumSize(new Dimension(20, 20));
        this.textDataFin.setPreferredSize(new Dimension(100, 20));
        this.textDataFin.setMinimumSize(new Dimension(100, 20));
        this.buttonDataFin.setFocusable(false);
        this.buttonDataFin.setPreferredSize(new Dimension(20, 20));
        this.buttonDataFin.setMinimumSize(new Dimension(20, 20));
        Dimension dim = new Dimension(175, 20);
        this.itemRequisicao = filtro = FiltroFactory.filtroItens("Requisi\u00e7\u00e3o", "fil_codigo = " + Variaveis.filialPadrao, "requisicao", new String[]{"req_codigo", "pac_codigo", "req_guia", "req_data"}, new String[]{"Requisi\u00e7\u00e3o", "C\u00f3digo Paciente", "Guia", "Data"}, new int[]{70, 70, 70, 0}, 4, new int[]{0, 1, 2, 3}, 4, false, true, false);
        this.itemRequisicao.setColunaHint(1);
        this.itemRequisicao.setPreferredSize(dim);
        this.itemRequisicao.setMinimumSize(dim);
        this.itemConvenio = new CheckItemFiltro("Conv\u00eanio", "Filtrar", "Filtrando conv\u00eanios", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemConvenio.setDados("convenios", new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Fantasia"}, new int[]{70, 0});
        this.itemConvenio.setColunaHint(1);
        this.itemConvenio.setPreferredSize(dim);
        this.itemConvenio.setMinimumSize(dim);
        this.itemExame = new CheckItemFiltro("Exame", "Filtrar", "Filtrando exames", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemExame.setDados("exames", new String[]{"exa_codigo", "exa_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemExame.setColunaHint(1);
        this.itemExame.setPreferredSize(dim);
        this.itemExame.setMinimumSize(dim);
        this.itemPaciente = new CheckItemFiltro("Paciente", "Filtrar", "Filtrando pacientes", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemPaciente.setDados("paciente", new String[]{"pac_codigo", "pac_nome"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{70, 0});
        this.itemPaciente.setColunaHint(1);
        this.itemPaciente.setPreferredSize(dim);
        this.itemPaciente.setMinimumSize(dim);
        this.itemFilial = new CheckItemFiltro("Filiais", "Filtrar", "Filtrando filiais", "");
        this.itemFilial.setDados("filiais_postocoleta", new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemFilial.setColunaHint(1);
        this.itemFilial.setPreferredSize(dim);
        this.itemFilial.setMinimumSize(dim);
        this.itemSituacao = new CheckItemFiltro("Situa\u00e7\u00e3o Log", "Filtrar", "Filtrando situa\u00e7\u00f5es", null);
        ArrayList<Object[]> lista = new ArrayList<Object[]>();
        lista.add(new Object[]{"", "N\u00e3o Enviado"});
        lista.add(new Object[]{"C", "Corrigido"});
        lista.add(new Object[]{"R", "Rejeitado"});
        lista.add(new Object[]{"E", "Enviado"});
        lista.add(new Object[]{"N", "N\u00e3o Configurado"});
        lista.add(new Object[]{"T", "Exportado Manual"});
        this.itemSituacao.setDados(null, new String[]{"", ""}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemSituacao.setConsultaFixa(lista);
        this.itemSituacao.setColunaHint(1);
        this.itemSituacao.setPreferredSize(dim);
        this.itemSituacao.setMinimumSize(dim);
    }

    private void adicionarListSelectionListener() {
        this.tableRequisicoes.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (ConsultaIntegracaoOperadora.this.tableRequisicoes.getSelectedRow() > -1) {
                    String codigoFilial = (String)ConsultaIntegracaoOperadora.this.modeloRequisicoes.getValueAt(ConsultaIntegracaoOperadora.this.tableRequisicoes.getSelectedRow(), 0);
                    String codigoRequisicao = (String)ConsultaIntegracaoOperadora.this.modeloRequisicoes.getValueAt(ConsultaIntegracaoOperadora.this.tableRequisicoes.getSelectedRow(), 1);
                    ConsultaIntegracaoOperadora.this.carregarRegistrosNoModeloExames(codigoFilial, codigoRequisicao);
                }
            }
        });
        this.tableExames.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ConsultaIntegracaoOperadora.this.atualizarPainelInformacoes();
                ConsultaIntegracaoOperadora.this.atualizarPainelXml();
            }
        });
    }

    private void adicionarDocumentListener() {
        ScreenUtil.addDocumentListener(this.textLocalizar.getDocument(), new Runnable(){

            @Override
            public void run() {
                ConsultaIntegracaoOperadora.this.localizar(ConsultaIntegracaoOperadora.this.textLocalizar.getText());
            }
        });
    }

    private void adicionarActionListener() {
        this.comboOperadora.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora protocolo = (FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora)((Object)ConsultaIntegracaoOperadora.this.comboOperadora.getSelectedItem());
                if (protocolo != null) {
                    ConsultaIntegracaoOperadora.this.habilitarFiltros(true);
                } else {
                    ConsultaIntegracaoOperadora.this.habilitarFiltros(false);
                }
            }
        });
        this.checkApresentarSomenteRejeitados.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ConsultaIntegracaoOperadora.this.checkApresentarSomenteRejeitados.isSelected()) {
                    ConsultaIntegracaoOperadora.this.itemSituacao.clear();
                    ConsultaIntegracaoOperadora.this.itemSituacao.setSelected(false);
                    ConsultaIntegracaoOperadora.this.itemSituacao.setEnabled(false);
                } else {
                    ConsultaIntegracaoOperadora.this.itemSituacao.setEnabled(true);
                }
            }
        });
    }

    private void adicionarFocusListener() {
        this.textLocalizar.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                ConsultaIntegracaoOperadora.this.textLocalizar.selectAll();
            }
        });
    }

    private void adicionarKeyListener() {
        this.textLocalizar.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if ((e.getKeyCode() == 38 || e.getKeyCode() == 40) && ConsultaIntegracaoOperadora.this.tableRequisicoes.getRowCount() > 0) {
                    ConsultaIntegracaoOperadora.this.tableRequisicoes.grabFocus();
                }
            }
        });
        this.textDataIni.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    ConsultaIntegracaoOperadora.this.buttonDataIni.doClick();
                }
            }
        });
        this.textDataFin.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    ConsultaIntegracaoOperadora.this.buttonDataFin.doClick();
                }
            }
        });
        this.textLocalizar.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (ConsultaIntegracaoOperadora.this.getProtocoloSelecionado() != null && e.getKeyCode() == 122) {
                    try {
                        ConsultaIntegracaoOperadora.this.service.teste(ConsultaIntegracaoOperadora.this.getProtocoloSelecionado());
                    }
                    catch (IntegracaoException e1) {
                        e1.printStackTrace();
                    }
                }
            }

            @Override
            @Deprecated
            public void keyTyped(KeyEvent e) {
            }

            @Override
            @Deprecated
            public void keyReleased(KeyEvent e) {
            }
        });
    }

    private void adicionarRenderer() {
        this.rendererExames = new DefaultTableCellRenderer(){

            @Override
            public synchronized Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focused, int row, int column) {
                Component c = super.getTableCellRendererComponent(table, value, selected, focused, row, column);
                this.setValue(value);
                if (selected) {
                    this.setForeground(table.getSelectionForeground());
                    this.setBackground(table.getSelectionBackground());
                } else {
                    this.setForeground(table.getForeground());
                    this.setBackground(table.getBackground());
                }
                if (focused) {
                    Border border = selected ? UIManager.getBorder("Table.focusSelectedCellHighlightBorder") : UIManager.getBorder("Table.focusCellHighlightBorder");
                    ((JComponent)c).setBorder(border);
                    if (!selected && table.isCellEditable(row, column)) {
                        Color col = UIManager.getColor("Table.focusCellForeground");
                        if (col != null) {
                            c.setForeground(col);
                        }
                        if ((col = UIManager.getColor("Table.focusCellBackground")) != null) {
                            c.setBackground(col);
                        }
                    }
                } else {
                    ((JComponent)c).setBorder(noFocusBorder);
                }
                ModeloGridTable modeloExames = (ModeloGridTable)table.getModel();
                Registro reg = (Registro)modeloExames.getValueAt(row, 7);
                if (value != null) {
                    if (column == 0 && (reg.getBoolean("exportado") && !ConsultaIntegracaoOperadora.this.getProtocoloSelecionado().equals((Object)FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.SINOS) && !ConsultaIntegracaoOperadora.this.getProtocoloSelecionado().equals((Object)FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.VTRP) || this.validarSituacaoLogExportado(reg) && (ConsultaIntegracaoOperadora.this.getProtocoloSelecionado().equals((Object)FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.SINOS) || ConsultaIntegracaoOperadora.this.getProtocoloSelecionado().equals((Object)FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.VTRP)))) {
                        c.setForeground(new Color(0, 180, 110));
                    } else if (column == 0 && (!reg.getBoolean("exportado") && !ConsultaIntegracaoOperadora.this.getProtocoloSelecionado().equals((Object)FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.SINOS) && !ConsultaIntegracaoOperadora.this.getProtocoloSelecionado().equals((Object)FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.VTRP) || !this.validarSituacaoLogExportado(reg) && (ConsultaIntegracaoOperadora.this.getProtocoloSelecionado().equals((Object)FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.SINOS) || ConsultaIntegracaoOperadora.this.getProtocoloSelecionado().equals((Object)FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.VTRP)))) {
                        c.setForeground(Color.RED);
                    }
                }
                return c;
            }

            private boolean validarSituacaoLogExportado(Registro reg) {
                return reg.getString("situacaoLog").equals("E") || reg.getString("situacaoLog").equals("T");
            }
        };
    }

    private void atualizarPainelInformacoes() {
        if (this.tableExames.getSelectedRow() > -1) {
            Registro reg = this.getExameSelecionado();
            this.atualizarPainelInformacoes(reg);
            this.buttonReenviar.setEnabled(true);
            if (this.getProtocoloSelecionado().equals((Object)FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.VTRP) && !reg.getString("situacaoLog").equals("C") || this.getProtocoloSelecionado().equals((Object)FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.SIMUS)) {
                this.buttonReenviar.setEnabled(false);
            }
        }
    }

    private void atualizarPainelXml() {
        if (this.tableExames.getSelectedRow() > -1) {
            Registro reg = this.getExameSelecionado();
            this.textRetorno.setText(reg.getString("retorno"));
            this.tratarSugestao(reg);
            this.controlaBotaoCorrigir(reg);
        }
    }

    private void controlaBotaoCorrigir(Registro reg) {
        if (this.comboOperadora.getSelectedItem().equals((Object)FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.VTRP) || this.comboOperadora.getSelectedItem().equals((Object)FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.SINOS)) {
            this.buttonCorrigir.setEnabled(this.logPrecisaDeCorrecao(reg, (FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora)((Object)this.comboOperadora.getSelectedItem())));
        }
        if (this.comboOperadora.getSelectedItem().equals((Object)FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.SINOS)) {
            this.buttonReenviar.setEnabled(false);
        }
        if (this.comboOperadora.getSelectedItem().equals((Object)FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.SIMUS)) {
            boolean corrigir = reg.getString("situacaoLog").equals("R") && !Funcoes.textoVazio(reg.getString("retorno")) && !reg.getString("retorno").contains("Este exame j\u00e1 possui um resultado cadastrado");
            this.buttonCorrigir.setEnabled(corrigir);
        }
    }

    private boolean logPrecisaDeCorrecao(Registro reg, FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora protocoloSelecionado) {
        return this.service.verificaLogPrecisandoCorrecao(reg, protocoloSelecionado);
    }

    private Registro getExameSelecionado() {
        ModeloGridTable modelo = (ModeloGridTable)this.tableExames.getModel();
        return (Registro)modelo.getValueAt(this.tableExames.getSelectedRow(), 7);
    }

    private void atualizarLogsParaEnvio() {
        try {
            this.textLogsEnviar.setText(String.valueOf(this.service.consultaLogsHaEnviar(this.getProtocoloSelecionado())));
        }
        catch (IntegracaoException e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
        }
    }

    private void montaPainelRequisicoes() {
        this.tableRequisicoes.getTableHeader().addMouseListener(this.modeloRequisicoes);
        this.modeloRequisicoes.setColumnSize(MEDIDA_COLUNAS_TABLE_REQUISICOES, this.tableRequisicoes);
        this.modeloRequisicoes.ordenarColuna(1);
        this.panelRequisicoes.setBorder(BorderFactory.createTitledBorder("Requisi\u00e7\u00f5es"));
        this.panelRequisicoes.setPreferredSize(new Dimension(270, 400));
        this.labelLocalizar.setMinimumSize(new Dimension(60, 20));
        this.labelLocalizar.setPreferredSize(new Dimension(60, 20));
        this.textLocalizar.setMinimumSize(new Dimension(120, 20));
        this.textLocalizar.setPreferredSize(new Dimension(200, 20));
        this.labelLogsEnviar.setMinimumSize(new Dimension(120, 20));
        this.labelLogsEnviar.setPreferredSize(new Dimension(120, 20));
        this.textLogsEnviar.setMinimumSize(new Dimension(60, 20));
        this.textLogsEnviar.setPreferredSize(new Dimension(60, 20));
        JPanel panelLocalizar = new JPanel(new GridBagLayout());
        panelLocalizar.setPreferredSize(new Dimension(60, 100));
        GridBagConstraints cons = new GridBagConstraints();
        cons.fill = 2;
        cons.anchor = 17;
        cons.gridx = 0;
        cons.gridy = 0;
        cons.weightx = 0.0;
        cons.gridwidth = 1;
        cons.insets = new Insets(0, 0, 2, 0);
        panelLocalizar.add((Component)this.labelLocalizar, cons);
        ++cons.gridx;
        cons.weightx = 2.0;
        cons.gridwidth = 3;
        panelLocalizar.add(this.comboLocalizarLogs, cons);
        cons.gridx = 0;
        ++cons.gridy;
        cons.weightx = 3.0;
        cons.gridwidth = 4;
        panelLocalizar.add((Component)this.textLocalizar, cons);
        cons.gridx = 0;
        ++cons.gridy;
        cons.weightx = 0.0;
        cons.gridwidth = 2;
        panelLocalizar.add((Component)this.labelLogsEnviar, cons);
        cons.weightx = 1.0;
        cons.gridx += 2;
        panelLocalizar.add((Component)this.textLogsEnviar, cons);
        this.panelPesquisa.add((Component)panelLocalizar, "Center");
        this.panelRequisicoes.add((Component)this.scrollRequisicoes, "Center");
        this.panelRequisicoes.add((Component)this.panelPesquisa, "South");
    }

    private void montaPainelFiltros(JPanel panelFiltros) {
        panelFiltros.setBorder(BorderFactory.createTitledBorder("Filtros"));
        panelFiltros.setLayout(new GridBagLayout());
        GridBagConstraints cons = new GridBagConstraints();
        cons.anchor = 17;
        cons.fill = 1;
        cons.gridwidth = 1;
        cons.gridheight = 1;
        cons.gridx = 0;
        cons.gridy = 0;
        cons.insets = new Insets(0, 6, 1, 0);
        panelFiltros.add((Component)ComponenteFactory.novoJLabel("Operadora:", new Dimension(70, 20)), cons);
        cons.gridwidth = 10;
        cons.insets = new Insets(0, 117, 5, 0);
        this.comboOperadora.setPreferredSize(new Dimension(80, 20));
        this.comboOperadora.setMaximumSize(new Dimension(80, 20));
        this.comboOperadora.setMinimumSize(new Dimension(80, 20));
        this.comboOperadora.setSelectedItem(null);
        panelFiltros.add((Component)this.comboOperadora, cons);
        cons.fill = 0;
        cons.gridwidth = 1;
        cons.gridheight = 1;
        cons.gridx = 0;
        ++cons.gridy;
        cons.insets = new Insets(0, 2, 1, 0);
        panelFiltros.add((Component)this.itemRequisicao, cons);
        ++cons.gridx;
        cons.gridy = 1;
        cons.gridwidth = 1;
        cons.insets = new Insets(0, 5, 1, 0);
        panelFiltros.add((Component)this.itemConvenio, cons);
        ++cons.gridx;
        panelFiltros.add((Component)this.labelExibirExportado, cons);
        ++cons.gridx;
        cons.gridwidth = 2;
        for (String situacao : ARRAY_SITUACAO) {
            this.itemExibirExportado.addItem(situacao);
        }
        panelFiltros.add((Component)this.itemExibirExportado, cons);
        ++cons.gridx;
        ++cons.gridx;
        cons.gridwidth = 2;
        panelFiltros.add((Component)this.checkApresentarSomenteRejeitados, cons);
        cons.gridwidth = 1;
        cons.gridx = 0;
        ++cons.gridy;
        cons.insets = new Insets(0, 2, 1, 0);
        panelFiltros.add((Component)this.itemPaciente, cons);
        ++cons.gridx;
        cons.insets = new Insets(0, 5, 1, 0);
        panelFiltros.add((Component)this.itemSituacao, cons);
        ++cons.gridx;
        cons.gridwidth = 1;
        panelFiltros.add((Component)this.labelDataIni, cons);
        ++cons.gridx;
        panelFiltros.add((Component)this.textDataIni, cons);
        cons.insets = new Insets(0, 1, 1, 0);
        ++cons.gridx;
        panelFiltros.add((Component)this.buttonDataIni, cons);
        cons.gridx = 0;
        ++cons.gridy;
        cons.insets = new Insets(0, 2, 1, 0);
        panelFiltros.add((Component)this.itemFilial, cons);
        ++cons.gridx;
        cons.insets = new Insets(0, 5, 1, 0);
        panelFiltros.add((Component)this.itemExame, cons);
        ++cons.gridx;
        panelFiltros.add((Component)this.labelDataFin, cons);
        ++cons.gridx;
        panelFiltros.add((Component)this.textDataFin, cons);
        ++cons.gridx;
        cons.insets = new Insets(0, 1, 1, 0);
        panelFiltros.add((Component)this.buttonDataFin, cons);
        cons.gridx = 5;
        cons.weightx = 1.0;
        cons.gridy = 2;
        cons.anchor = 26;
        cons.gridwidth = 2;
        panelFiltros.add((Component)this.buttonConsultar, cons);
    }

    private void montaPainelExames() {
        this.modeloExames.setColumnSize(MEDIDA_COLUNAS_TABLE_EXAMES, this.tableExames);
        JPanel panelInformacoesPai = new JPanel(new BorderLayout(0, 0));
        panelInformacoesPai.setBorder(new TitledBorder("Exames"));
        this.tableExames.getTableHeader().addMouseListener(this.modeloExames);
        this.tableExames.setDefaultRenderer(Object.class, this.rendererExames);
        this.scrollExames.setPreferredSize(new Dimension(600, 50));
        JPanel painelAux = new JPanel(new BorderLayout(0, 0));
        painelAux.setBorder(new EmptyBorder(0, 0, 0, 0));
        painelAux.add((Component)this.scrollExames, "Center");
        JPanel painelInformacoes = new JPanel(new FlowLayout(0));
        this.labelInformacoes.setOpaque(true);
        this.labelInformacoes.setBackground(ConstantesGerais.COR_FUNDO_CREME);
        painelInformacoes.add((Component)this.labelInformacoes, 0);
        painelInformacoes.setPreferredSize(new Dimension(600, 100));
        painelInformacoes.setBackground(ConstantesGerais.COR_FUNDO_CREME);
        TitledBorder titulo = BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), "Informa\u00e7\u00f5es");
        titulo.setTitlePosition(1);
        painelInformacoes.setBorder(titulo);
        painelAux.add((Component)painelInformacoes, "Last");
        panelInformacoesPai.add((Component)painelAux, "Center");
        JPanel panelBotoes = new JPanel(new FlowLayout(2));
        panelBotoes.add(this.buttonCorrigir);
        panelBotoes.add(this.buttonReenviar);
        panelInformacoesPai.add((Component)panelBotoes, "Last");
        JTabbedPane panelXml = new JTabbedPane();
        panelXml.setPreferredSize(new Dimension(600, 140));
        JPanel panelXmlEnvio = new JPanel(new BorderLayout());
        JPanel panelXmlRetorno = new JPanel(new BorderLayout());
        JPanel panelXmlMensagem = new JPanel(new BorderLayout());
        panelXmlEnvio.add(new JScrollPane(this.textXmlEnvio));
        panelXmlRetorno.add(new JScrollPane(this.textXmlRetorno));
        panelXmlMensagem.add((Component)new JScrollPane(this.textRetorno), "Center");
        this.textRetorno.setEditable(false);
        this.textXmlEnvio.setEditable(false);
        this.textXmlRetorno.setEditable(false);
        panelXml.add((Component)panelXmlMensagem, "Retorno");
        panelXml.add((Component)panelXmlEnvio, "XML Retorno Solicita\u00e7\u00e3o");
        panelXml.add((Component)panelXmlRetorno, "XML Retorno Resultado");
        JPanel panelSugestao = new JPanel(new BorderLayout());
        this.textSugestao.setEditable(false);
        this.textSugestao.setWrapStyleWord(true);
        this.textSugestao.setLineWrap(true);
        panelSugestao.add((Component)this.labelSugestao, "West");
        panelSugestao.add((Component)this.textSugestao, "Center");
        panelSugestao.setBorder(new LineBorder(new Color(218, 165, 32)));
        panelXmlMensagem.add((Component)panelSugestao, "South");
        this.panelExames.add((Component)panelInformacoesPai, "Center");
        this.panelExames.add((Component)panelXml, "Last");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.buttonConsultar) {
            this.consultarLogs();
        } else if (o == this.buttonCorrigir) {
            this.corrigir();
        } else if (o == this.buttonReenviar) {
            this.reenviar();
        } else if (o == this.buttonFechar) {
            this.setVisible(false);
            if (this.getParent() != null) {
                this.getParent().removeAll();
            }
        } else if (o == this.buttonNovo) {
            this.acaoNovo();
        } else if (o == this.buttonOpcoes) {
            this.menuOpcoes.show(this.panelBotoesEsquerda, this.buttonOpcoes.getY(), this.buttonOpcoes.getX() + this.buttonOpcoes.getHeight());
        } else if (o == this.buttonDataIni) {
            Funcoes.mostraData(this.textDataIni, this.buttonDataIni, (JPanel)this.buttonDataIni.getParent(), false);
        } else if (o == this.buttonDataFin) {
            Funcoes.mostraData(this.textDataFin, this.buttonDataFin, (JPanel)this.buttonDataFin.getParent(), false);
        } else if (o == this.buttonMarcarExportado) {
            this.service.alterarLogExportado(this.getExameSelecionado(), true);
            this.consultarLogs();
        } else if (o == this.buttonDesmarcarExportado) {
            this.service.alterarLogExportado(this.getExameSelecionado(), false);
            this.consultarLogs();
        }
    }

    private void corrigir() {
        Registro log = this.getExameSelecionado();
        Registro corrigido = this.service.corrigirLog(log, this.getProtocoloSelecionado());
        if (corrigido.possuiCampo("filial")) {
            log.setValor("cartaosus", corrigido.getString("cartaosus"));
            log.setValor("guia", corrigido.getString("guia"));
            log.setValor("dataGuia", corrigido.getString("dataGuia"));
            log.setValor("matricula", corrigido.getString("matricula"));
            if (!this.checkApresentarSomenteRejeitados.isSelected()) {
                String dataConf = !Funcoes.textoVazio(corrigido.getString("conferencia")) ? this.service.getFormatData(corrigido.getString("conferencia"), true, DATA_HORA_MINUTO) : "";
                this.atualizarPainelInformacoes(log);
                String situacaoExame = Tipos.tipoSituacaoExame(corrigido.getString("situacao"));
                this.modeloExames.addLine(new Object[]{corrigido.getString("log"), corrigido.getString("exame"), corrigido.getString("descricaoMaterial"), corrigido.getString("descricaoExame"), dataConf, corrigido.getString("usrconferencia"), situacaoExame, corrigido});
                this.tableExames.getSelectionModel().setSelectionInterval(this.tableExames.getRowCount() - 1, this.tableExames.getRowCount() - 1);
            }
            this.buttonCorrigir.setEnabled(false);
        }
    }

    private void reenviar() {
        Registro log = this.getExameSelecionado();
        LogIntegracaoOperadora logIntegracao = this.service.getLogIntegracaoOperadora(log);
        try {
            this.service.reenviarLog(logIntegracao, this.getProtocoloSelecionado());
            this.buttonReenviar.setEnabled(false);
            log.setValor("situacaoLog", null);
            this.atualizarPainelInformacoes(log);
        }
        catch (IntegracaoException e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
        }
    }

    private void atualizarPainelInformacoes(Registro log) {
        String informacoesCorrigidas = this.service.construirDadosPainelInformacoes(log, this.panelExames.getWidth());
        this.labelInformacoes.setText(informacoesCorrigidas);
    }

    private void acaoNovo() {
        this.limparLocalizar();
        this.limparFiltros();
        this.comboOperadora.setSelectedItem(null);
        this.buttonOpcoes.setEnabled(false);
        this.buttonCorrigir.setEnabled(false);
        this.buttonReenviar.setEnabled(false);
        this.buttonOpcoes.setEnabled(false);
        this.textRetorno.setText("");
        this.textSugestao.setText("");
        this.textXmlRetorno.setText("");
        this.textXmlEnvio.setText("");
    }

    private void consultarLogs() {
        try {
            this.modeloRequisicoes.clear();
            this.logs.clear();
            this.limparLocalizar();
            this.logs.addAll(this.buscarLogs());
            this.carregarRegistrosNoModeloRequisicoes();
            this.ordernarColunasModeloRequisicoes();
            this.atualizarLogsParaEnvio();
            if (this.modeloRequisicoes.getRowCount() > 0) {
                this.buttonCorrigir.setEnabled(true);
                this.buttonReenviar.setEnabled(true);
                this.buttonOpcoes.setEnabled(true);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
        }
        finally {
            if (this.tableRequisicoes.getRowCount() > 0) {
                this.tableRequisicoes.getSelectionModel().setSelectionInterval(0, 0);
            } else {
                this.buttonOpcoes.setEnabled(false);
            }
        }
    }

    private List<Registro> buscarLogs() {
        IntervaloData intervalo = new IntervaloData(this.textDataIni.getText(), this.textDataFin.getText());
        Filtros itens = new Filtros(this.itemRequisicao, this.itemPaciente, this.itemFilial, this.itemConvenio, this.itemSituacao, this.itemExame, this.itemExibirExportado);
        try {
            return this.service.buscarRegistrosLog(intervalo, itens, this.getProtocoloSelecionado(), this.checkApresentarSomenteRejeitados.isSelected());
        }
        catch (IntegracaoException e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
            return new ArrayList<Registro>();
        }
    }

    private void carregarRegistrosNoModeloRequisicoes() {
        this.modeloRequisicoes.clear();
        HashMap<String, String> requisicaoFilial = new HashMap<String, String>();
        for (Registro registro : this.logs) {
            if (requisicaoFilial.containsKey(registro.getString("Requisi\u00e7\u00e3o")) && requisicaoFilial.containsValue(registro.getString("filial"))) continue;
            String dataHoraRequisicao = this.service.getFormatData(registro.getString("dataRequisicao"), true, DATA_HORA_MINUTO);
            this.modeloRequisicoes.addLine(new Object[]{registro.getString("filial"), registro.getString("Requisi\u00e7\u00e3o"), dataHoraRequisicao, registro});
            requisicaoFilial.put(registro.getString("Requisi\u00e7\u00e3o"), registro.getString("filial"));
        }
    }

    private void carregarRegistrosNoModeloExames(String codigoFilial, String codigoRequisicao) {
        if (this.buttonCorrigir.getText().equalsIgnoreCase("Salvar")) {
            this.buttonCorrigir.setText("Corrigir");
        }
        this.modeloExames.clear();
        for (Registro reg : this.logs) {
            if (!reg.getString("filial").equals(codigoFilial) || !reg.getString("Requisi\u00e7\u00e3o").equals(codigoRequisicao)) continue;
            String dataConf = !Funcoes.textoVazio(reg.getString("conferencia")) ? this.service.getFormatData(reg.getString("conferencia"), true, DATA_HORA_MINUTO) : "";
            String usuarioConf = !Funcoes.textoVazio(reg.getString("usrconferencia")) ? reg.getString("usrconferencia") : "";
            String situacaoExame = Tipos.tipoSituacaoExame(reg.getString("situacao"));
            this.modeloExames.addLine(new Object[]{reg.getString("log"), reg.getString("exame"), reg.getString("descricaoMaterial"), reg.getString("descricaoExame"), dataConf, usuarioConf, situacaoExame, reg});
        }
        if (this.tableExames.getRowCount() > 0) {
            this.tableExames.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    private void ordernarColunasModeloRequisicoes() {
        if (this.modeloRequisicoes.getColunaOrdenacao() != -1) {
            this.modeloRequisicoes.ordenarColunaSemTrocarSentido(this.modeloRequisicoes.getColunaOrdenacao());
        } else {
            this.modeloRequisicoes.ordenarColunaSemTrocarSentido(1);
        }
    }

    private List<LogIntegracaoOperadora> getLogsNaoEnviadosPorRequisicao() {
        ArrayList<LogIntegracaoOperadora> logsNaoEnviados = new ArrayList<LogIntegracaoOperadora>();
        for (Registro reg : this.logs) {
            if (!reg.getString("filial").equals(this.logSelecionado.getString("filial")) || !reg.getString("Requisi\u00e7\u00e3o").equals(this.logSelecionado.getString("Requisi\u00e7\u00e3o"))) continue;
            logsNaoEnviados.add(this.converterRegistroParaLogIntegracaoOperadora(reg));
        }
        return logsNaoEnviados;
    }

    private LogIntegracaoOperadora converterRegistroParaLogIntegracaoOperadora(Registro reg) {
        String codigoFilial = (String)reg.getValor("filial");
        String codigoLog = (String)reg.getValor("log");
        String codigoRequisicao = (String)reg.getValor("Requisi\u00e7\u00e3o");
        String codigoPaciente = (String)reg.getValor("codigoPaciente");
        String codigoExame = (String)reg.getValor("exame");
        String codigoMaterial = (String)reg.getValor("codigoMaterial");
        String tipoOperacao = (String)reg.getValor("tipoOperacao");
        String xmlLog = (String)reg.getValor("xmlLog");
        String retorno = (String)reg.getValor("retorno");
        String situacao = (String)reg.getValor("situacao");
        String codigoConvenio = reg.getString("codigoConvenio");
        return new LogIntegracaoOperadora(Integer.parseInt(codigoFilial != null ? codigoFilial : Variaveis.filialPadrao), Long.parseLong(codigoLog), codigoRequisicao == null ? null : Integer.valueOf(Integer.parseInt(codigoRequisicao)), codigoPaciente, codigoExame, Integer.parseInt(codigoMaterial != null ? codigoMaterial : "0"), tipoOperacao, xmlLog, retorno, situacao, Integer.parseInt(!Funcoes.textoVazio(codigoConvenio) ? codigoConvenio : "0"));
    }

    private void limparFiltros() {
        this.itemConvenio.clear();
        this.itemRequisicao.clear();
        this.itemPaciente.clear();
        this.itemFilial.clear();
        this.itemSituacao.clear();
        this.itemExame.clear();
        this.textDataIni.setText("");
        this.textDataFin.setText("");
    }

    private void limparLocalizar() {
        this.textLocalizar.clear();
        this.modeloRequisicoes.clear();
        this.modeloExames.clear();
        this.labelInformacoes.setText("");
        this.logs.clear();
        this.textLogsEnviar.setText("");
    }

    private void localizar(String valorDigitado) {
        int coluna;
        int n = coluna = this.comboLocalizarLogs.getSelectedItem().toString().equals("Requisi\u00e7\u00e3o") ? 1 : 0;
        if (coluna == 1) {
            this.localizarRequisicao(coluna, valorDigitado);
        } else {
            this.localizarLog(coluna, valorDigitado);
        }
    }

    private void localizarRequisicao(int coluna, String valorDigitado) {
        int rows = this.tableRequisicoes.getRowCount();
        for (int i = 0; i < rows; ++i) {
            String value;
            Object cell = this.tableRequisicoes.getValueAt(i, coluna);
            if (!(cell instanceof String) && !(cell instanceof Integer) || !(value = cell.toString().toLowerCase()).startsWith(valorDigitado.toLowerCase())) continue;
            this.tableRequisicoes.setRowSelectionInterval(i, i);
            TableUtil.scrollToCenter(this.tableRequisicoes, i);
            break;
        }
    }

    private void localizarLog(int coluna, String valorDigitado) {
        int linhasRequisicoes = this.tableRequisicoes.getRowCount();
        if (Funcoes.textoVazio(valorDigitado)) {
            this.tableRequisicoes.setRowSelectionInterval(0, 0);
            TableUtil.scrollToCenter(this.tableRequisicoes, 0);
            this.tableExames.setRowSelectionInterval(0, 0);
            TableUtil.scrollToCenter(this.tableExames, 0);
        } else {
            for (int linhaReq = 0; linhaReq < linhasRequisicoes; ++linhaReq) {
                String codigoFilial = (String)this.tableRequisicoes.getValueAt(linhaReq, 0);
                String codigoRequisicao = (String)this.tableRequisicoes.getValueAt(linhaReq, 1);
                block1: for (Registro reg : this.logs) {
                    if (!reg.getString("filial").equals(codigoFilial) || !reg.getString("Requisi\u00e7\u00e3o").equals(codigoRequisicao) || !reg.getString("log").equals(valorDigitado)) continue;
                    this.carregarRegistrosNoModeloExames(codigoFilial, codigoRequisicao);
                    int linhasExames = this.tableExames.getRowCount();
                    for (int linhaExame = 0; linhaExame < linhasExames; ++linhaExame) {
                        String value;
                        Object cell = this.tableExames.getValueAt(linhaExame, coluna);
                        if (!(cell instanceof String) && !(cell instanceof Integer) || !(value = cell.toString().toLowerCase()).startsWith(valorDigitado.toLowerCase())) continue;
                        this.tableRequisicoes.setRowSelectionInterval(linhaReq, linhaReq);
                        TableUtil.scrollToCenter(this.tableRequisicoes, linhaReq);
                        this.tableExames.setRowSelectionInterval(linhaExame, linhaExame);
                        TableUtil.scrollToCenter(this.tableExames, linhaExame);
                        continue block1;
                    }
                }
            }
        }
    }

    private void tratarSugestao(Registro reg) {
        switch (this.textRetorno.getText()) {
            case "Usu\u00e1rios enviados para o prestador n\u00e3o tem permiss\u00e3o de publicar resultado de exame": {
                this.textSugestao.setText("Verifique a configura\u00e7\u00e3o de usu\u00e1rio do cadastro de conv\u00eanio.");
                break;
            }
            case "Tipo de Exame enviado \u00e9 inv\u00e1lido": {
                this.textSugestao.setText("Verifique o c\u00f3digo AMB do exame.");
                break;
            }
            case "N\u00famero do arquivo/lote j\u00e1 existe para o prestador.": {
                this.textSugestao.setText("Verifique se o c\u00f3digo do lote est\u00e1 correto na configura\u00e7\u00e3o do conv\u00eanio " + reg.getString("codigoConvenio") + ".");
                break;
            }
            case "Informa\u00e7\u00f5es de benefici\u00e1rio, guia ou senha da guia inv\u00e1lidos.": {
                this.textSugestao.setText("Verifique na requisi\u00e7\u00e3o " + reg.getString("Requisi\u00e7\u00e3o") + " se o n\u00famero de guia e o c\u00f3digo de autoriza\u00e7\u00e3o est\u00e3o corretos para o exame " + reg.getString("exame"));
                break;
            }
            case "C\u00f3digo do procedimento inv\u00e1lido.": {
                this.textSugestao.setText("Verifique se o c\u00f3digo AMB do exame " + reg.getString("exame") + " est\u00e1 correto.");
                break;
            }
            case "C\u00f3digo de procedimento n\u00e3o pertence a guia do benefici\u00e1rio.": {
                this.textSugestao.setText("Verifique se o c\u00f3digo AMB do exame " + reg.getString("exame") + " pertence a guia " + reg.getString("guia"));
                break;
            }
            case "Procedimento j\u00e1 enviado, para reenvio do resultado \u00e9 necess\u00e1rio o motivo do reenvio.": {
                this.textSugestao.setText("O resultado do exame " + reg.getString("exame") + " j\u00e1 consta na Unimed. Reenvie o resultado utilizando o bot\u00e3o Enviar.");
                break;
            }
            case "Procedimento ultrapassou a data limite para reenvio.": {
                this.textSugestao.setText("O resultado do exame " + reg.getString("exame") + " ultrapassou o prazo de reenvio do resultado.");
                break;
            }
            case "Campo(s) obrigat\u00f3rios n\u00e3o enviados: %s": {
                this.textSugestao.setText("Informa\u00e7\u00f5es obrigat\u00f3rias n\u00e3o foram enviadas.");
                break;
            }
            case "Prestador Inv\u00e1lido ou sem permiss\u00e3o para publica\u00e7\u00e3o de resultado de exame.": {
                this.textSugestao.setText("Verifique o c\u00f3digo de prestador no cadastro do conv\u00eanio.");
                break;
            }
            case "Prestador inv\u00e1lido.": {
                this.textSugestao.setText("Verifique o c\u00f3digo de prestador no cadastro do conv\u00eanio.");
                break;
            }
            case "Prestador que est\u00e1 enviando o resultado n\u00e3o \u00e9 o prestador executante da guia.": {
                this.textSugestao.setText("O c\u00f3digo do prestador informado \u00e9 diferente do c\u00f3digo prestador que realizou os exames.");
                break;
            }
            case "O reenvio de resultados excedeu a data limite.": {
                this.textSugestao.setText("Data limite para reenvio de resultados expirou.");
                break;
            }
            case "Nenhum arquivo PDF foi enviado.": {
                this.textSugestao.setText("O arquivo PDF com os resultados dos exames n\u00e3o foi enviado.");
                break;
            }
            case "Nenhum procedimento foi enviado.": {
                this.textSugestao.setText("Nenhum exame foi enviado.");
                break;
            }
            case "Se 'listaValorRef' estiver preenchida, o campo 'obsValorRefListaItensExame' deve ser vazio.": {
                this.textSugestao.setText("Verifique no cadastro do exame se o campo observa\u00e7\u00e3o e o campo de resultado est\u00e3o configurados. Somente um campo pode ser configurado");
                break;
            }
            case "Se 'listaValorRef' estiver preenchida, o campo 'obsVlrRefItemExame' deve ser vazio.": {
                this.textSugestao.setText("Verifique no cadastro do exame se o campo observa\u00e7\u00e3o e o campo de resultado est\u00e3o configurados. Somente um campo pode ser configurado");
                break;
            }
            case "O campo 'idRegistroProcedimento' n\u00e3o pode ser menor do que 1.": {
                this.textSugestao.setText("Verifique se o exame possui o resultado.");
                break;
            }
            case "O campo 'motivoReenvio' n\u00e3o pode ser preenchido na primeira vez que o procedimento \u00e9 enviado.": {
                this.textSugestao.setText("N\u00e3o \u00e9 poss\u00edvel utilizar a op\u00e7\u00e3o de Reenviar para enviar o resultado do exame pela primeira vez.");
                break;
            }
            case "Amostra/execu\u00e7\u00e3o anterior do exame n\u00e3o enviada.": {
                this.textSugestao.setText("Amostra/execu\u00e7\u00e3o anterior do exame n\u00e3o enviada.");
                break;
            }
            case "O procedimento n\u00e3o est\u00e1 autorizado.": {
                this.textSugestao.setText("Procedimento n\u00e3o autorizado. Entre em contato com a Unimed para verificar.");
                break;
            }
            case "Quantidade de execu\u00e7\u00f5es excedeu a quantidade autorizada do procedimento.": {
                this.textSugestao.setText("Verifique se a quantidade de exames realizados coincide com a quantidade de exames liberados na guia.");
                break;
            }
            case "Erro ao verificar assinatura digital do arquivo.": {
                this.textSugestao.setText("N\u00e3o foi poss\u00edvel realizar a assinatura digital do arquivo. Verifique a validade do certificado digital.");
                break;
            }
            case "Este procedimento n\u00e3o deve ser enviado.": {
                this.textSugestao.setText("Este procedimento n\u00e3o deve ser enviado. Entre em contato com a Unimed para verifica\u00e7\u00e3o.");
                break;
            }
            default: {
                this.textSugestao.setText(this.textRetorno.getText());
            }
        }
    }

    private FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora getProtocoloSelecionado() {
        return (FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora)((Object)this.comboOperadora.getSelectedItem());
    }

    public static long getModuloAcesso() {
        return ACESSO;
    }
}

