/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao;

import jalis.comum.ConstantesGerais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.model.bean.cadastro.FilialBean;
import jalis.service.cadastro.FilialService;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JLabel;

class ConfiguradorXml
extends AbstractDialogoOKCancelar {
    private JLabel labelCodigoPrestadoraOperadora = new JLabel("C\u00f3digo do prestador na operadora:");
    private JLabel labelNumeroSequenciaGeracaoArquivo = new JLabel("N\u00famero de sequ\u00eancia de gera\u00e7\u00e3o do arquivo:");
    private JLabel labelCodigoLocalColetaExame = new JLabel("C\u00f3digo do local de coleta do exame:");
    private JLabel labelCodigoConselhoProfissionalExecutante = new JLabel("C\u00f3digo conselho do profissional executante:");
    private JLabel labelNumeroConselhoProfissionalExecutante = new JLabel("N\u00famero conselho do profissional executante:");
    private JLabel labelUfConselhoProfissionalExecutante = new JLabel("UF do conselho do profissional executante:");
    private TTextField textCodigoPrestadoraOperadora = new TTextField(6, 1);
    private TTextField textNumeroSequenciaGeracaoArquivo = new TTextField(6, 1);
    private TTextField textCodigoLocalColetaExame = new TTextField(6, 1);
    private TTextField textlNumeroConselhoProfissionalExecutante = new TTextField(6, 1);
    private List<String> campoSemConfiguracao = new ArrayList<String>();
    private JComboBox comboConselho = new JComboBox<String>(ArraysUtil.concatenar(new String[]{" "}, ConstantesGerais.CONSELHOS));
    private JComboBox comboEstado = new JComboBox<String>(ArraysUtil.concatenar(new String[]{" "}, ConstantesGerais.ESTADOS));

    public static ConfiguradorXml novaInstancia(Object pai, boolean validar) {
        if (pai instanceof Dialog) {
            return new ConfiguradorXml((Dialog)pai, "Configurar Resultado S\u00e3o Lucas", validar);
        }
        return new ConfiguradorXml((Frame)pai, "Configurar Resultado S\u00e3o Lucas", validar);
    }

    public ConfiguradorXml(Dialog pai, String titulo, boolean validar) {
        super(pai, titulo);
        try {
            this.montaTela(validar);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
        }
    }

    public ConfiguradorXml(Frame pai, String titulo, boolean validar) {
        super(pai, titulo);
        try {
            this.montaTela(validar);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
        }
    }

    public String xmlConfiguracao() {
        StringBuilder xml = new StringBuilder();
        xml.append("<configSaoLucas>");
        xml.append("\t<campos>");
        xml.append("\t\t<cpe>").append(this.comboConselho.getSelectedItem().toString()).append("</cpe>");
        xml.append("\t\t<clce>").append(this.textCodigoLocalColetaExame.getText()).append("</clce>");
        xml.append("\t\t<cpo>").append(this.textCodigoPrestadoraOperadora.getText()).append("</cpo>");
        xml.append("\t\t<npe>").append(this.textlNumeroConselhoProfissionalExecutante.getText()).append("</npe>");
        xml.append("\t\t<upe>").append(this.comboEstado.getSelectedItem().toString()).append("</upe>");
        xml.append("\t\t<nsga>").append(this.textNumeroSequenciaGeracaoArquivo.getText()).append("</nsga>");
        xml.append("\t</campos>");
        xml.append("</configSaoLucas>");
        return xml.toString();
    }

    private void montaTela(boolean validar) throws Exception {
        this.setSize(new Dimension(390, 200));
        this.setResizable(false);
        this.textCodigoPrestadoraOperadora = new TTextField(6, 1);
        this.textCodigoPrestadoraOperadora.setUpperCase(true);
        this.textNumeroSequenciaGeracaoArquivo = new TTextField(6, 1);
        this.textNumeroSequenciaGeracaoArquivo.setUpperCase(true);
        this.textCodigoLocalColetaExame = new TTextField(6, 1);
        this.textCodigoLocalColetaExame.setUpperCase(true);
        this.textlNumeroConselhoProfissionalExecutante = new TTextField(6, 1);
        this.textlNumeroConselhoProfissionalExecutante.setUpperCase(true);
        GridBagConstraints layout = new GridBagConstraints();
        this.getPanelCentral().setLayout(new GridBagLayout());
        layout.insets = new Insets(1, 1, 0, 0);
        layout.gridx = 0;
        layout.gridy = 0;
        layout.weightx = 0.0;
        layout.weighty = 0.0;
        layout.anchor = 17;
        this.getPanelCentral().add((Component)this.labelCodigoConselhoProfissionalExecutante, layout);
        ++layout.gridx;
        layout.fill = 2;
        layout.weightx = 1.0;
        layout.insets = new Insets(1, 0, 0, 1);
        this.comboConselho.setPreferredSize(new Dimension(100, 20));
        this.comboConselho.setMinimumSize(new Dimension(100, 20));
        this.getPanelCentral().add((Component)this.comboConselho, layout);
        layout.fill = 0;
        layout.weightx = 0.0;
        ++layout.gridy;
        --layout.gridx;
        layout.insets = new Insets(1, 1, 0, 0);
        this.getPanelCentral().add((Component)this.labelNumeroConselhoProfissionalExecutante, layout);
        ++layout.gridx;
        layout.fill = 2;
        layout.weightx = 1.0;
        layout.insets = new Insets(1, 0, 0, 1);
        this.textlNumeroConselhoProfissionalExecutante.setPreferredSize(new Dimension(50, 20));
        this.textlNumeroConselhoProfissionalExecutante.setMinimumSize(new Dimension(50, 20));
        this.getPanelCentral().add((Component)this.textlNumeroConselhoProfissionalExecutante, layout);
        layout.fill = 0;
        layout.weightx = 0.0;
        ++layout.gridy;
        --layout.gridx;
        layout.insets = new Insets(1, 1, 0, 0);
        this.getPanelCentral().add((Component)this.labelUfConselhoProfissionalExecutante, layout);
        ++layout.gridx;
        layout.fill = 2;
        layout.weightx = 1.0;
        layout.insets = new Insets(1, 0, 0, 1);
        this.comboEstado.setPreferredSize(new Dimension(50, 20));
        this.comboEstado.setMinimumSize(new Dimension(50, 20));
        this.getPanelCentral().add((Component)this.comboEstado, layout);
        layout.fill = 0;
        layout.weightx = 0.0;
        ++layout.gridy;
        --layout.gridx;
        layout.insets = new Insets(1, 1, 0, 0);
        this.getPanelCentral().add((Component)this.labelCodigoLocalColetaExame, layout);
        ++layout.gridx;
        layout.fill = 2;
        layout.weightx = 1.0;
        layout.insets = new Insets(1, 0, 0, 1);
        this.textCodigoLocalColetaExame.setPreferredSize(new Dimension(50, 20));
        this.textCodigoLocalColetaExame.setMinimumSize(new Dimension(50, 20));
        this.getPanelCentral().add((Component)this.textCodigoLocalColetaExame, layout);
        layout.fill = 0;
        layout.weightx = 0.0;
        ++layout.gridy;
        --layout.gridx;
        layout.insets = new Insets(1, 1, 0, 0);
        this.getPanelCentral().add((Component)this.labelCodigoPrestadoraOperadora, layout);
        ++layout.gridx;
        layout.fill = 2;
        layout.weightx = 1.0;
        layout.insets = new Insets(1, 0, 0, 1);
        this.textCodigoPrestadoraOperadora.setPreferredSize(new Dimension(50, 20));
        this.textCodigoPrestadoraOperadora.setMinimumSize(new Dimension(50, 20));
        this.getPanelCentral().add((Component)this.textCodigoPrestadoraOperadora, layout);
        layout.fill = 0;
        layout.weightx = 0.0;
        ++layout.gridy;
        --layout.gridx;
        layout.insets = new Insets(1, 1, 0, 0);
        this.getPanelCentral().add((Component)this.labelNumeroSequenciaGeracaoArquivo, layout);
        ++layout.gridx;
        layout.fill = 2;
        layout.weightx = 1.0;
        layout.insets = new Insets(1, 0, 0, 1);
        this.textNumeroSequenciaGeracaoArquivo.setEditable(false);
        this.textNumeroSequenciaGeracaoArquivo.setPreferredSize(new Dimension(50, 20));
        this.textNumeroSequenciaGeracaoArquivo.setMinimumSize(new Dimension(50, 20));
        this.getPanelCentral().add((Component)this.textNumeroSequenciaGeracaoArquivo, layout);
        layout.fill = 2;
        layout.weightx = 1.0;
        layout.weighty = 1.0;
        ++layout.gridy;
        --layout.gridx;
        this.getPanelCentral().add((Component)new JLabel(), layout);
        this.carregarCampos();
        if (!validar) {
            this.setModal(true);
            ScreenUtil.centralizar(this);
            this.setVisible(true);
        }
    }

    private void carregarCampos() throws Exception {
        String xmlConfigurador = ((FilialBean)new FilialService().get(Variaveis.filialPadrao)).getConfigSaoLucas();
        if (!Funcoes.textoVazio(xmlConfigurador)) {
            String campos = StringUtil.getValor(xmlConfigurador, "campos");
            this.comboConselho.setSelectedItem(StringUtil.getValor(campos, "cpe"));
            this.textCodigoLocalColetaExame.setText(StringUtil.getValor(campos, "clce"));
            this.textCodigoPrestadoraOperadora.setText(StringUtil.getValor(campos, "cpo"));
            this.textlNumeroConselhoProfissionalExecutante.setText(StringUtil.getValor(campos, "npe"));
            this.comboEstado.setSelectedItem(StringUtil.getValor(campos, "upe"));
            this.textNumeroSequenciaGeracaoArquivo.setText(StringUtil.getValor(campos, "nsga"));
        }
    }

    public boolean getPossuiCampoVazio() {
        this.campoSemConfiguracao.clear();
        if (Funcoes.textoVazio(this.comboConselho.getSelectedItem().toString())) {
            this.campoSemConfiguracao.add(this.labelCodigoConselhoProfissionalExecutante.getText().replaceAll("\\:", ".") + "\n");
        }
        if (Funcoes.textoVazio(this.textCodigoLocalColetaExame)) {
            this.campoSemConfiguracao.add(this.labelCodigoLocalColetaExame.getText().replaceAll("\\:", ".") + "\n");
        }
        if (Funcoes.textoVazio(this.textCodigoPrestadoraOperadora)) {
            this.campoSemConfiguracao.add(this.labelCodigoPrestadoraOperadora.getText().replaceAll("\\:", ".") + "\n");
        }
        if (Funcoes.textoVazio(this.textlNumeroConselhoProfissionalExecutante)) {
            this.campoSemConfiguracao.add(this.labelNumeroConselhoProfissionalExecutante.getText().replaceAll("\\:", ".") + "\n");
        }
        if (Funcoes.textoVazio(this.comboEstado.getSelectedItem().toString())) {
            this.campoSemConfiguracao.add(this.labelUfConselhoProfissionalExecutante.getText().replaceAll("\\:", ".") + "\n");
        }
        return !this.campoSemConfiguracao.isEmpty();
    }

    public List<String> getCampoSemConfiguracao() {
        return this.campoSemConfiguracao;
    }
}

