/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao;

import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.exportacao.texto.CampoValor;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class ConfiguradorResultadoSaoLucas
extends AbstractDialogoOKCancelar
implements ActionListener {
    public static final String TIPO = "tipo";
    public static final String CAMPO = "campomodelo";
    private static final String ORDEM = "ordem";
    private static final String TEXTO_OBSERVACAO = "Observa\u00e7\u00e3o";
    private static final String RESULTADO_TEXTO = "Resultado Texto";
    private static final String RESULTADO_NUMERICO = "Resultado num\u00e9rico";
    private static final String TIPO_NUMERICO = "N";
    private static final String TIPO_OBS = "O";
    private static final String TIPO_TEXTO = "T";
    public static final String EXPORTAR_SAO_LUCAS = "exportarsaolucas";
    public static final String TAG_TEXTO_OBSERVACAO = "textobservacao";
    public static final String TAG_RESULTADO_TEXTO = "resultadotexto";
    public static final String TAG_RESULTADO_NUMERICO = "resultadonumerico";
    private final int COLUNA_CAMPO = 0;
    private final int COLUNA_TIPO = 1;
    private int editandoLinha = -1;
    private JComboBox comboCampos = ComponenteFactory.novoJComboBox(new Dimension(40, 20));
    private JLabel labelCampos = ComponenteFactory.novoJLabel("Campos", 'm', null, this.comboCampos);
    private JComboBox comboTipo = new JComboBox<Object>(new Object[]{"Resultado num\u00e9rico", "Resultado Texto", "Observa\u00e7\u00e3o"});
    private JLabel labelCodigoExame = ComponenteFactory.novoJLabel("Tipo", 'x', null, this.comboTipo);
    private JButton buttonOKCampo = ComponenteFactory.novoJButton("OK", '\u0000', this, null, new Dimension(40, 20));
    private ModeloGridTable modelo = new ModeloGridTable(new String[]{"Campo", "Tipo"});
    private JTable table = new JTable(this.modelo);
    private JScrollPane scroll = new JScrollPane(this.table);

    public static ConfiguradorResultadoSaoLucas novaInstancia(Object pai) {
        if (pai instanceof Dialog) {
            return new ConfiguradorResultadoSaoLucas((Dialog)pai, "S\u00e3o Lucas");
        }
        return new ConfiguradorResultadoSaoLucas((Frame)pai, "S\u00e3o Lucas");
    }

    public ConfiguradorResultadoSaoLucas(Dialog pai, String titulo) {
        super(pai, titulo);
        this.montaTela();
    }

    public ConfiguradorResultadoSaoLucas(Frame pai, String titulo) {
        super(pai, titulo);
        this.montaTela();
    }

    private void montaTela() {
        this.setSize(new Dimension(310, 180));
        this.setResizable(false);
        this.setModal(true);
        JPanel panel = this.getPanelCentral();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 1.0;
        c.gridwidth = 1;
        c.anchor = 17;
        panel.add((Component)this.labelCampos, c);
        c.gridx = 1;
        c.fill = 0;
        c.weightx = 0.0;
        panel.add((Component)this.labelCodigoExame, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.fill = 2;
        c.weightx = 1.0;
        this.comboCampos.setMinimumSize(new Dimension(100, 20));
        panel.add((Component)this.comboCampos, c);
        c.gridx = 1;
        c.fill = 0;
        c.weightx = 0.0;
        this.comboTipo.setPreferredSize(new Dimension(150, 20));
        this.comboTipo.setMinimumSize(new Dimension(150, 20));
        panel.add((Component)this.comboTipo, c);
        c.gridx = 2;
        c.fill = 0;
        c.weightx = 0.0;
        this.buttonOKCampo.setMinimumSize(new Dimension(40, 20));
        this.buttonOKCampo.setMaximumSize(new Dimension(40, 20));
        panel.add((Component)this.buttonOKCampo, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 3;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        panel.add((Component)this.scroll, c);
        this.table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127 && ConfiguradorResultadoSaoLucas.this.table.getSelectedRow() > -1 && Funcoes.mensagem(ConfiguradorResultadoSaoLucas.this, "Deseja excluir o registro selecionado?", 4) == 0) {
                    ConfiguradorResultadoSaoLucas.this.modelo.removeLine(ConfiguradorResultadoSaoLucas.this.table.getSelectedRow());
                } else if (e.getKeyCode() == 32 && ConfiguradorResultadoSaoLucas.this.table.getSelectedRow() > -1) {
                    ConfiguradorResultadoSaoLucas.this.editandoLinha = ConfiguradorResultadoSaoLucas.this.table.getSelectedRow();
                    ConfiguradorResultadoSaoLucas.this.comboTipo.setSelectedItem(ConfiguradorResultadoSaoLucas.this.modelo.getValueAt(ConfiguradorResultadoSaoLucas.this.editandoLinha, 1).toString());
                    ConfiguradorResultadoSaoLucas.this.comboCampos.setSelectedItem(ConfiguradorResultadoSaoLucas.this.modelo.getValueAt(ConfiguradorResultadoSaoLucas.this.editandoLinha, 0).toString());
                    ScreenUtil.requisitarFoco(ConfiguradorResultadoSaoLucas.this.comboCampos);
                }
            }
        });
        ScreenUtil.requisitarFoco(this.comboCampos);
    }

    public void setCampos(String[] campos) {
        if (campos != null) {
            this.comboCampos.removeAllItems();
            for (String s : campos) {
                this.comboCampos.addItem(s);
            }
        }
    }

    public String getXml() {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.modelo.getRowCount(); ++i) {
            buf.append("<campo>");
            buf.append(StringUtil.getTag(ORDEM, String.valueOf(i)));
            buf.append(StringUtil.getTag(CAMPO, this.modelo.getValueAt(i, 0).toString()));
            buf.append(StringUtil.getTag(TIPO, this.obterTipoSelecionado(i)));
            buf.append("</campo>");
        }
        return StringUtil.getTag(EXPORTAR_SAO_LUCAS, buf.toString());
    }

    private String obterTipoSelecionado(int i) {
        String tipo = this.modelo.getValueAt(i, 1).toString();
        if (tipo.equalsIgnoreCase(RESULTADO_NUMERICO)) {
            return TAG_RESULTADO_NUMERICO;
        }
        if (tipo.equalsIgnoreCase(RESULTADO_TEXTO)) {
            return TAG_RESULTADO_TEXTO;
        }
        return TAG_TEXTO_OBSERVACAO;
    }

    public void setXml(String xml) {
        if (xml != null) {
            List<CampoValor> campos = ConfiguradorResultadoSaoLucas.getListaRelacionamentoCampos(xml);
            this.modelo.clear();
            for (CampoValor campo : campos) {
                this.modelo.addLine(new Object[]{campo.getCampo(), this.obterTipo(campo), this.getTipoCampoConfigurado(this.obterTipo(campo))});
            }
        }
    }

    private String getTipoCampoConfigurado(String tipo) {
        if (tipo.equalsIgnoreCase(RESULTADO_NUMERICO)) {
            return TIPO_NUMERICO;
        }
        if (tipo.equalsIgnoreCase(RESULTADO_TEXTO)) {
            return TIPO_TEXTO;
        }
        return TIPO_OBS;
    }

    private String obterTipo(CampoValor campo) {
        String valor = campo.getValor();
        if (valor.equalsIgnoreCase(TAG_RESULTADO_NUMERICO)) {
            return RESULTADO_NUMERICO;
        }
        if (valor.equalsIgnoreCase(TAG_RESULTADO_TEXTO)) {
            return RESULTADO_TEXTO;
        }
        return TEXTO_OBSERVACAO;
    }

    public static Hashtable<String, CampoValor> getRelacionamentoCampos(String xml) {
        Hashtable<String, CampoValor> hash = new Hashtable<String, CampoValor>();
        List<CampoValor> lista = ConfiguradorResultadoSaoLucas.getListaRelacionamentoCampos(xml);
        for (CampoValor c : lista) {
            hash.put(c.getCampo(), c);
        }
        return hash;
    }

    public static List<CampoValor> getListaRelacionamentoCampos(String xml) {
        ArrayList<CampoValor> lista = new ArrayList<CampoValor>();
        if (xml != null && !Funcoes.textoVazio(StringUtil.getValor(xml, EXPORTAR_SAO_LUCAS))) {
            String[] campos;
            for (String s : campos = StringUtil.getValores(xml, "campo")) {
                int ordem = StringUtil.getInt(s, ORDEM);
                String nome = StringUtil.getValor(s, CAMPO);
                String valor = StringUtil.getValor(s, TIPO);
                lista.add(new CampoValor(ordem, nome, valor, null, null));
            }
        }
        Collections.sort(lista, new Comparator(){

            public int compare(Object o1, Object o2) {
                int ordem2;
                int ordem1 = ((CampoValor)o1).getOrdem();
                return ordem1 > (ordem2 = ((CampoValor)o2).getOrdem()) ? 1 : (ordem1 < ordem2 ? -1 : 0);
            }
        });
        return lista;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonOKCampo) {
            this.adicionar();
        } else {
            super.actionPerformed(e);
        }
    }

    private void adicionar() {
        if (this.editandoLinha > -1) {
            String tipo;
            int i;
            int linhaLocalizadaCampo = this.modelo.localizar(0, this.comboCampos.getSelectedItem().toString());
            int linhaLocalizadaTipo = this.modelo.localizar(1, this.comboTipo.getSelectedItem().toString());
            if (linhaLocalizadaCampo >= 0 && linhaLocalizadaCampo != this.editandoLinha) {
                Funcoes.mensagem(this, "Campo j\u00e1 foi adicionado.", 2);
                return;
            }
            if (linhaLocalizadaTipo >= 0 && linhaLocalizadaTipo != this.editandoLinha) {
                Funcoes.mensagem(this, "Tipo j\u00e1 foi adicionado.", 2);
                return;
            }
            int linhaNumerico = -1;
            int linhaTexto = -1;
            for (i = 0; i < this.modelo.getRowCount(); ++i) {
                tipo = (String)this.modelo.getValueAt(i, 2);
                if (!tipo.equalsIgnoreCase(TIPO_NUMERICO)) continue;
                linhaNumerico = i;
                break;
            }
            for (i = 0; i < this.modelo.getRowCount(); ++i) {
                tipo = (String)this.modelo.getValueAt(i, 2);
                if (!tipo.equalsIgnoreCase(TIPO_TEXTO)) continue;
                linhaTexto = i;
                break;
            }
            String tipoCampoEditado = (String)this.modelo.getValueAt(this.editandoLinha, 2);
            String tipoResultado = this.getTipoCampoConfigurado(this.comboTipo.getSelectedItem().toString());
            if ((tipoCampoEditado.equalsIgnoreCase(TIPO_NUMERICO) || tipoCampoEditado.equalsIgnoreCase(TIPO_TEXTO) || tipoResultado.equalsIgnoreCase(TIPO_NUMERICO) || tipoResultado.equalsIgnoreCase(TIPO_TEXTO)) && !tipoResultado.equalsIgnoreCase(tipoCampoEditado) && (linhaNumerico > -1 && linhaNumerico != this.editandoLinha || linhaTexto > -1 && linhaTexto != this.editandoLinha) && !this.permiteInserirConfiguracao(true)) {
                return;
            }
            this.modelo.setValueAt(this.comboTipo.getSelectedItem().toString(), this.editandoLinha, 1);
            this.modelo.setValueAt(this.comboCampos.getSelectedItem().toString(), this.editandoLinha, 0);
            this.modelo.setValueAt(this.getTipoCampoConfigurado(this.comboTipo.getSelectedItem().toString()), this.editandoLinha, 2);
            this.editandoLinha = -1;
            this.comboCampos.setSelectedIndex(0);
            this.comboTipo.setSelectedIndex(0);
        } else if (this.modelo.localizar(0, this.comboCampos.getSelectedItem().toString()) < 0 && this.permiteInserirConfiguracao(true)) {
            this.modelo.addLine(new Object[]{this.comboCampos.getSelectedItem().toString(), this.comboTipo.getSelectedItem().toString(), this.getTipoCampoConfigurado(this.comboTipo.getSelectedItem().toString())});
        } else if (this.modelo.localizar(0, this.comboCampos.getSelectedItem().toString()) >= 0) {
            Funcoes.mensagem(this, "Campo j\u00e1 foi adicionado.", 2);
        }
        ScreenUtil.requisitarFoco(this.comboCampos);
    }

    public boolean permiteInserirConfiguracao(boolean exibirMsg) {
        String tipo;
        int i;
        String tipoInserindo = this.getTipoCampoConfigurado(this.comboTipo.getSelectedItem().toString());
        boolean possuiNumerico = false;
        boolean possuiTexto = false;
        for (i = 0; i < this.modelo.getRowCount(); ++i) {
            tipo = (String)this.modelo.getValueAt(i, 2);
            if (!tipo.equalsIgnoreCase(TIPO_NUMERICO)) continue;
            possuiNumerico = true;
            break;
        }
        for (i = 0; i < this.modelo.getRowCount(); ++i) {
            tipo = (String)this.modelo.getValueAt(i, 2);
            if (!tipo.equalsIgnoreCase(TIPO_TEXTO)) continue;
            possuiTexto = true;
            break;
        }
        for (i = 0; i < this.modelo.getRowCount(); ++i) {
            tipo = (String)this.modelo.getValueAt(i, 2);
            if (tipo.equalsIgnoreCase(tipoInserindo)) {
                if (exibirMsg) {
                    Funcoes.mensagem(this, "Tipo j\u00e1 foi adicionado.", 2);
                }
                return false;
            }
            if (possuiNumerico && tipoInserindo.equalsIgnoreCase(TIPO_TEXTO)) {
                if (exibirMsg) {
                    Funcoes.mensagem(this, "N\u00e3o \u00e9 poss\u00edvel adicionar resultado texto e num\u00e9rico juntos.", 2);
                }
                return false;
            }
            if (!possuiTexto || !tipoInserindo.equalsIgnoreCase(TIPO_NUMERICO)) continue;
            if (exibirMsg) {
                Funcoes.mensagem(this, "N\u00e3o \u00e9 poss\u00edvel adicionar resultado num\u00e9rico e texto juntos.", 2);
            }
            return false;
        }
        return true;
    }
}

