/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.exportacao.texto.CampoDetalhe;
import jalis.laboratorio.exportacao.texto.CampoValor;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.SteppedComboBox;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ConfiguradorResultadoNephrosysV2
extends AbstractDialogoOKCancelar
implements ActionListener {
    public static final String EXPORTAR_NEPHROSYSV2 = "exportarnephrosys2";
    private final int COLUNA_CAMPO = 0;
    private final int COLUNA_ALTERNATIVO = 1;
    private final int COLUNA_DETALHES = 2;
    private final int CODIGO_PAI = 1;
    private final int CODIGO_VALOR = 2;
    private final int COLUNA_DETALHES_VALOR = 0;
    private final int COLUNA_DETALHES_TROCA = 1;
    public static final String TAG_VALOR = "valor";
    public static final String TAG_HEMOGRAMA = "hemograma";
    public static final String TAG_PAI = "pai";
    private SteppedComboBox comboCampos = new SteppedComboBox();
    private TTextField textAlternativo = new TTextField(10);
    private TTextField textPaiImportacao = new TTextField(3);
    private JLabel labelCampos = ComponenteFactory.novoJLabel("Campos", 'm', null, this.comboCampos);
    private JLabel labelCodigoExame = ComponenteFactory.novoJLabel("Exame", 'x', null, this.textAlternativo);
    private JLabel labelCodigoPaiImportacao = ComponenteFactory.novoJLabel("C\u00f3digo pai importa\u00e7\u00e3o", 'x', null, this.textAlternativo);
    private JButton buttonOKCampo = ComponenteFactory.novoJButton("OK", '\u0000', this, null, new Dimension(40, 20));
    private ModeloGridTable modelo = new ModeloGridTable(new String[]{"Campo", "Alternativo"});
    private JTable table = new JTable(this.modelo);
    private JScrollPane scroll = new JScrollPane(this.table);
    private JPanel panelDetalhes = ComponenteFactory.novoJPanel(new GridBagLayout(), new TitledBorder("Detalhes"));
    private ModeloGridTable modeloDetalhes = new ModeloGridTable(new String[]{"Resultado", "Valor"});
    private JTable tableDetalhes = ComponenteFactory.novoJTable(this.modeloDetalhes);
    private JScrollPane scrollDetalhes = new JScrollPane(this.tableDetalhes);
    private JLabel labelValor = new JLabel("Valor");
    private JLabel labelTroca = new JLabel("Converter");
    private TTextField textValor = new TTextField();
    private TTextField textTroca = new TTextField();
    private JButton buttonOKDetalhes = ComponenteFactory.novoJButton("OK", '\u0000', this, null, new Dimension(40, 20));
    private String codigoExameBarra;
    private JPanel jPanelPaiExameImportacao = new JPanel();
    private int editandoLinha = -1;

    public static ConfiguradorResultadoNephrosysV2 novaInstancia(Object pai, String codigoExameBarra) {
        if (pai instanceof Dialog) {
            return new ConfiguradorResultadoNephrosysV2((Dialog)pai, "Configurando Nephrosys V2", codigoExameBarra);
        }
        return new ConfiguradorResultadoNephrosysV2((Frame)pai, "Configurando Nephrosys V2", codigoExameBarra);
    }

    public ConfiguradorResultadoNephrosysV2(Dialog pai, String titulo, String codigoExameBarra) {
        super(pai, titulo);
        this.codigoExameBarra = codigoExameBarra;
        this.montaTela();
    }

    public ConfiguradorResultadoNephrosysV2(Frame pai, String titulo, String codigoExameBarra) {
        super(pai, titulo);
        this.codigoExameBarra = codigoExameBarra;
        this.montaTela();
    }

    private void montaTela() {
        this.setSize(new Dimension(420, 420));
        this.setResizable(false);
        this.setModal(true);
        JPanel panel = this.getPanelCentral();
        panel.setLayout(new GridBagLayout());
        this.jPanelPaiExameImportacao.setLayout(new GridBagLayout());
        GridBagConstraints c1 = new GridBagConstraints();
        c1.gridx = 0;
        c1.gridy = 0;
        c1.fill = 17;
        c1.weightx = 1.0;
        c1.gridwidth = 1;
        c1.anchor = 17;
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 1.0;
        c.gridwidth = 3;
        c.anchor = 17;
        this.textPaiImportacao.setPreferredSize(new Dimension(143, 20));
        this.textPaiImportacao.setMinimumSize(new Dimension(143, 20));
        this.jPanelPaiExameImportacao.add((Component)new JLabel("C\u00f3digo pai importa\u00e7\u00e3o"), c1);
        ++c1.gridy;
        this.jPanelPaiExameImportacao.add((Component)this.textPaiImportacao, c1);
        ++c1.gridx;
        this.jPanelPaiExameImportacao.add((Component)new JLabel(), c1);
        panel.add((Component)this.jPanelPaiExameImportacao, c);
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 1.0;
        c.gridwidth = 1;
        c.anchor = 17;
        c.gridy = 1;
        panel.add((Component)this.labelCampos, c);
        c.gridx = 1;
        c.fill = 0;
        c.weightx = 0.0;
        panel.add((Component)this.labelCodigoExame, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        c.fill = 2;
        c.weightx = 1.0;
        c.insets = new Insets(0, 0, 0, 1);
        this.comboCampos.setMinimumSize(new Dimension(100, 20));
        panel.add((Component)this.comboCampos, c);
        c.insets = new Insets(0, 0, 0, 0);
        c.gridx = 1;
        c.fill = 0;
        c.weightx = 0.0;
        this.textAlternativo.setPreferredSize(new Dimension(80, 20));
        this.textAlternativo.setMinimumSize(new Dimension(80, 20));
        panel.add((Component)this.textAlternativo, c);
        c.gridx = 2;
        c.fill = 0;
        c.weightx = 0.0;
        this.buttonOKCampo.setMinimumSize(new Dimension(40, 20));
        this.buttonOKCampo.setMaximumSize(new Dimension(40, 20));
        panel.add((Component)this.buttonOKCampo, c);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 3;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        panel.add((Component)this.scroll, c);
        c.gridx = 0;
        c.gridy = 4;
        panel.add((Component)this.panelDetalhes, c);
        this.jPanelPaiExameImportacao.setBorder(new TitledBorder("Importa\u00e7\u00e3o"));
        this.modelo.setColumnSize(new int[]{0, 80}, this.table);
        this.montaDetalhes();
        this.table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127 && ConfiguradorResultadoNephrosysV2.this.table.getSelectedRow() > -1 && Funcoes.mensagem(ConfiguradorResultadoNephrosysV2.this, "Deseja excluir o registro selecionado?", 4) == 0) {
                    ConfiguradorResultadoNephrosysV2.this.modelo.removeLine(ConfiguradorResultadoNephrosysV2.this.table.getSelectedRow());
                } else if (e.getKeyCode() == 32 && ConfiguradorResultadoNephrosysV2.this.table.getSelectedRow() > -1) {
                    ConfiguradorResultadoNephrosysV2.this.editandoLinha = ConfiguradorResultadoNephrosysV2.this.table.getSelectedRow();
                    ConfiguradorResultadoNephrosysV2.this.textAlternativo.setText(ConfiguradorResultadoNephrosysV2.this.modelo.getValueAt(ConfiguradorResultadoNephrosysV2.this.editandoLinha, 1).toString());
                    ConfiguradorResultadoNephrosysV2.this.comboCampos.setSelectedItem(ConfiguradorResultadoNephrosysV2.this.modelo.getValueAt(ConfiguradorResultadoNephrosysV2.this.editandoLinha, 0).toString());
                    ScreenUtil.requisitarFoco(ConfiguradorResultadoNephrosysV2.this.textAlternativo);
                }
            }
        });
        this.tableDetalhes.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127 && ConfiguradorResultadoNephrosysV2.this.tableDetalhes.getSelectedRow() > -1 && Funcoes.mensagem(ConfiguradorResultadoNephrosysV2.this, "Deseja excluir o registro selecionado?", 4) == 0) {
                    String valor = ConfiguradorResultadoNephrosysV2.this.modeloDetalhes.getValueAt(ConfiguradorResultadoNephrosysV2.this.tableDetalhes.getSelectedRow(), 0).toString();
                    ConfiguradorResultadoNephrosysV2.this.modeloDetalhes.removeLine(ConfiguradorResultadoNephrosysV2.this.tableDetalhes.getSelectedRow());
                    if (ConfiguradorResultadoNephrosysV2.this.modelo.getValueAt(ConfiguradorResultadoNephrosysV2.this.table.getSelectedRow(), 2) != null && ConfiguradorResultadoNephrosysV2.this.modelo.getValueAt(ConfiguradorResultadoNephrosysV2.this.table.getSelectedRow(), 2) instanceof ArrayList) {
                        ArrayList detalhes = (ArrayList)ConfiguradorResultadoNephrosysV2.this.modelo.getValueAt(ConfiguradorResultadoNephrosysV2.this.table.getSelectedRow(), 2);
                        for (int i = 0; i < detalhes.size(); ++i) {
                            CampoDetalhe d = (CampoDetalhe)detalhes.get(i);
                            if (!d.getValor().equalsIgnoreCase(valor)) continue;
                            detalhes.remove(i);
                            break;
                        }
                    }
                }
            }
        });
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ConfiguradorResultadoNephrosysV2.this.modeloDetalhes.clear();
                if (ConfiguradorResultadoNephrosysV2.this.table.getSelectedRow() > -1 && ConfiguradorResultadoNephrosysV2.this.modelo.getValueAt(ConfiguradorResultadoNephrosysV2.this.table.getSelectedRow(), 2) != null && ConfiguradorResultadoNephrosysV2.this.modelo.getValueAt(ConfiguradorResultadoNephrosysV2.this.table.getSelectedRow(), 2) instanceof ArrayList) {
                    ArrayList detalhes = (ArrayList)ConfiguradorResultadoNephrosysV2.this.modelo.getValueAt(ConfiguradorResultadoNephrosysV2.this.table.getSelectedRow(), 2);
                    for (CampoDetalhe d : detalhes) {
                        ConfiguradorResultadoNephrosysV2.this.modeloDetalhes.addLine(new String[]{d.getValor(), d.getTroca()});
                    }
                }
            }
        });
        ScreenUtil.requisitarFoco(this.comboCampos);
    }

    private void montaDetalhes() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 1.0;
        c.gridwidth = 1;
        this.panelDetalhes.add((Component)this.labelValor, c);
        c.gridx = 1;
        c.gridwidth = 2;
        this.panelDetalhes.add((Component)this.labelTroca, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        this.comboCampos.setMinimumSize(new Dimension(40, 20));
        this.panelDetalhes.add((Component)this.textValor, c);
        c.gridx = 1;
        this.textAlternativo.setPreferredSize(new Dimension(100, 20));
        this.panelDetalhes.add((Component)this.textTroca, c);
        c.gridx = 2;
        c.fill = 0;
        c.weightx = 0.0;
        this.buttonOKDetalhes.setMinimumSize(new Dimension(40, 20));
        this.buttonOKDetalhes.setMaximumSize(new Dimension(40, 20));
        this.panelDetalhes.add((Component)this.buttonOKDetalhes, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 3;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.panelDetalhes.add((Component)this.scrollDetalhes, c);
    }

    public void setCampos(String[] campos) {
        if (campos != null) {
            this.comboCampos.removeAllItems();
            for (String s : campos) {
                this.comboCampos.addItem(s);
            }
        }
    }

    public String getXml() {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.modelo.getRowCount(); ++i) {
            buf.append("<campo>");
            buf.append(StringUtil.getTag("ordem", String.valueOf(i)));
            buf.append(StringUtil.getTag("nome", this.modelo.getValueAt(i, 0).toString()));
            buf.append(StringUtil.getTag(TAG_PAI, this.textPaiImportacao.getText()));
            buf.append(StringUtil.getTag(TAG_VALOR, this.modelo.getValueAt(i, 1).toString()));
            if (this.modelo.getValueAt(i, 2) != null && this.modelo.getValueAt(i, 2) instanceof ArrayList) {
                ArrayList detalhes = (ArrayList)this.modelo.getValueAt(i, 2);
                buf.append("<camposdetalhes>");
                for (CampoDetalhe d : detalhes) {
                    buf.append("<campodetalhe>");
                    buf.append(StringUtil.getTag("valordetalhe", d.getValor()));
                    buf.append(StringUtil.getTag("trocadetalhe", d.getTroca()));
                    buf.append("</campodetalhe>");
                }
                buf.append("</camposdetalhes>");
            }
            buf.append("</campo>");
        }
        return StringUtil.getTag(EXPORTAR_NEPHROSYSV2, buf.toString());
    }

    public void setXml(String xml) {
        if (xml != null) {
            List<CampoValor> campos = ConfiguradorResultadoNephrosysV2.getListaRelacionamentoCampos(xml);
            this.modelo.clear();
            for (CampoValor campo : campos) {
                this.textPaiImportacao.setText(campo.getPaiImportacao());
                this.modelo.addLine(new Object[]{campo.getCampo(), campo.getValor(), campo.getDetalhes()});
            }
        }
    }

    public static Hashtable<String, CampoValor> getRelacionamentoCampos(String xml) {
        Hashtable<String, CampoValor> hash = new Hashtable<String, CampoValor>();
        List<CampoValor> lista = ConfiguradorResultadoNephrosysV2.getListaRelacionamentoCampos(xml);
        for (CampoValor c : lista) {
            hash.put(c.getCampo(), c);
        }
        return hash;
    }

    public static List<CampoValor> getListaRelacionamentoCampos(String xml) {
        ArrayList<CampoValor> lista = new ArrayList<CampoValor>();
        if (xml != null && !Funcoes.textoVazio(StringUtil.getValor(xml, EXPORTAR_NEPHROSYSV2))) {
            String[] campos;
            for (String s : campos = StringUtil.getValores(StringUtil.getValor(xml, EXPORTAR_NEPHROSYSV2), "campo")) {
                int ordem = StringUtil.getInt(s, "ordem");
                String nome = StringUtil.getValor(s, "nome");
                String pai = StringUtil.getValor(s, TAG_PAI);
                String valor = StringUtil.getValor(s, TAG_VALOR);
                String detalhes = StringUtil.getValor(s, "camposdetalhes");
                ArrayList<CampoDetalhe> d = new ArrayList<CampoDetalhe>();
                if (!Funcoes.textoVazio(detalhes)) {
                    String[] camposDetalhes;
                    for (String x : camposDetalhes = StringUtil.getValores(detalhes, "campodetalhe")) {
                        d.add(new CampoDetalhe(StringUtil.getValor(x, "valordetalhe"), StringUtil.getValor(x, "trocadetalhe")));
                    }
                }
                lista.add(new CampoValor(ordem, nome, valor, pai, d));
            }
        }
        Collections.sort(lista, new Comparator(){

            public int compare(Object o1, Object o2) {
                int ordem2;
                int ordem1 = ((CampoValor)o1).getOrdem();
                return ordem1 > (ordem2 = ((CampoValor)o2).getOrdem()) ? 1 : (ordem1 < ordem2 ? -1 : 0);
            }
        });
        return lista;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonOKCampo) {
            this.adicionar();
        } else if (e.getSource() == this.buttonOKDetalhes) {
            this.adicionaDetalhes();
        } else if (e.getSource() == this.buttonOK) {
            if (!this.validarAssociacaoCodigo(1)) {
                return;
            }
            if (this.modelo.getRowCount() <= 0 && !Funcoes.textoVazio(this.textPaiImportacao)) {
                Funcoes.mensagem(this, "C\u00f3digo pai da importa\u00e7\u00e3o n\u00e3o pode ser configurado sem associa\u00e7\u00e3o de campos.", 2);
                ScreenUtil.requisitarFoco(this.textAlternativo);
                return;
            }
            super.actionPerformed(e);
        } else {
            super.actionPerformed(e);
        }
    }

    private void adicionar() {
        if (this.editandoLinha > -1) {
            this.modelo.setValueAt(this.textAlternativo.getText(), this.editandoLinha, 1);
            this.modelo.setValueAt(this.comboCampos.getSelectedItem().toString(), this.editandoLinha, 0);
            this.editandoLinha = -1;
        } else if (this.modelo.localizar(0, this.comboCampos.getSelectedItem().toString()) < 0) {
            this.modelo.addLine(new Object[]{this.comboCampos.getSelectedItem().toString(), this.textAlternativo.getText(), new ArrayList()});
        }
        this.textAlternativo.clear();
        ScreenUtil.requisitarFoco(this.comboCampos);
    }

    private boolean validarAssociacaoCodigo(Integer tipo) {
        try {
            StringBuilder buf = new StringBuilder();
            buf.append(" select distinct a.exa_codigo as codigoExame ");
            buf.append("       ,a.mco_codigo as codigoMaterial ");
            buf.append("   from examematcoleta a ");
            buf.append("   join examelayout b on a.fil_codigo = b.fil_codigo and a.exa_codigo = b.exa_codigo and a.mco_codigo = b.mco_codigo ");
            buf.append("   left join examelayoutmetodo c on b.fil_codigo = c.fil_codigo and b.exa_codigo = c.exa_codigo ");
            buf.append("         and b.mco_codigo = c.mco_codigo and b.ela_idadeini = c.ela_idadeini and b.ela_idadefim = c.ela_idadefim ");
            buf.append("         and b.ela_idadeinitipo = c.ela_idadeinitipo and b.ela_idadefimtipo = c.ela_idadefimtipo and b.lay_codigo = c.lay_codigo ");
            buf.append("  where a.fil_codigo = ").append(Variaveis.filialPadrao);
            String codigoLike = null;
            if (tipo.equals(1) && !Funcoes.textoVazio(this.textPaiImportacao.getText())) {
                codigoLike = "'%<exportarnephrosys2>%%" + StringUtil.getTag(TAG_PAI, this.textPaiImportacao.getText()) + "%'";
            }
            buf.append(" and c.elm_exportartexto ilike ").append(codigoLike);
            buf.append(" and c.elm_exportartexto is not null and c.elm_exportartexto <> '' ");
            buf.append(" and a.exa_codigo  <> '" + this.codigoExameBarra + "' ");
            Statement st = Conexao.getStatement();
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            ArrayList<String> codigos = new ArrayList<String>();
            int pos = -1;
            while (rs.next()) {
                ++pos;
                codigos.add("Exame: " + rs.getString("codigoExame") + " | Material: " + rs.getString("codigoMaterial") + "\n");
            }
            String msg = StringUtil.implode(codigos, " ");
            if (!codigos.isEmpty() && tipo.equals(1)) {
                Funcoes.mensagem(this, "O c\u00f3digo pai: ( " + this.textPaiImportacao.getText() + " ) j\u00e1 est\u00e1 sendo usado pelo(s) exame(s): \n" + msg, 2);
                ScreenUtil.requisitarFoco(this.textPaiImportacao);
                return false;
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "Erro ao validar associa\u00e7\u00e3o.", e.getStackTrace());
        }
        return true;
    }

    private void adicionaDetalhes() {
        if (this.table.getSelectedRow() > -1 && this.modelo.getValueAt(this.table.getSelectedRow(), 2) != null && this.modelo.getValueAt(this.table.getSelectedRow(), 2) instanceof ArrayList && this.modeloDetalhes.localizar(0, this.textValor.getText()) < 0) {
            ArrayList detalhes = (ArrayList)this.modelo.getValueAt(this.table.getSelectedRow(), 2);
            detalhes.add(new CampoDetalhe(this.textValor.getText(), this.textTroca.getText()));
            this.modeloDetalhes.addLine(new String[]{this.textValor.getText(), this.textTroca.getText()});
        }
        this.textValor.clear();
        this.textTroca.clear();
        ScreenUtil.requisitarFoco(this.textValor);
    }
}

