/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao;

import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.cadastro.ExameMatCol;
import jalis.laboratorio.exportacao.CampoValorNephrosys;
import jalis.laboratorio.exportacao.ExamesNephrosys;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class ConfiguradorResultadoNephrosys
extends AbstractDialogoOKCancelar
implements ActionListener {
    public static final String EXPORTAR_NEPHROSYS = "exportarnephrosys";
    public static final String TAG_CAMPO = "campo";
    public static final String TAG_ORDEM = "ordem";
    public static final String TAG_NOME = "nome";
    public static final String TAG_VALOR = "valor";
    public static final String TAG_MARCADOR = "marcador";
    public static final String TAG_HEMOGRAMA = "hemograma";
    private final int COLUNA_CAMPO_JALIS = 0;
    private final int COLUNA_EXAME_NEPHROSYS = 1;
    private final int COLUNA_MARCADOR = 2;
    private JCheckBox checkHemograma = new JCheckBox("Hemograma");
    private JComboBox comboExameNephrosys = new JComboBox();
    private JComboBox comboMarcador = ComponenteFactory.novoJComboBox(new Dimension(40, 20));
    private JComboBox comboCampoJalis = ComponenteFactory.novoJComboBox(new Dimension(40, 20));
    private JButton buttonCampoJalis = ComponenteFactory.novoJButton("", this, null, new Dimension(20, 20));
    private JButton buttonExameNephrosys = ComponenteFactory.novoJButton("", this, null, new Dimension(20, 20));
    private JLabel labelCampoJalis = ComponenteFactory.novoJLabel("Campo Jalis", 'm', null, this.comboCampoJalis);
    private JLabel labelExameNephosys = ComponenteFactory.novoJLabel("Exame Nephrosys", 'x', null, this.comboExameNephrosys);
    private JLabel labelCampoValorMarcador = ComponenteFactory.novoJLabel("Titula\u00e7\u00e3o", 'T', null, this.comboMarcador);
    private JButton buttonOKCampo = ComponenteFactory.novoJButton("OK", '\u0000', this, null, new Dimension(40, 20));
    private ModeloGridTable modelo = new ModeloGridTable(new String[]{"Campo Jalis", "Exame Nephrosys", "Titula\u00e7\u00e3o"});
    private JTable table = new JTable(this.modelo);
    private JScrollPane scroll = new JScrollPane(this.table);
    boolean isPreenchendoDados = false;
    private String[] camposLaudo = null;
    private ExameMatCol exameMatColeta = null;
    private int editandoLinha = -1;

    public static ConfiguradorResultadoNephrosys novaInstancia(Object pai) {
        if (pai instanceof Dialog) {
            return new ConfiguradorResultadoNephrosys((Dialog)pai, "Configurando Nephrosys");
        }
        return new ConfiguradorResultadoNephrosys((Frame)pai, "Configurando Nephrosys");
    }

    public ConfiguradorResultadoNephrosys(Dialog pai, String titulo) {
        super(pai, titulo);
        this.montaTela();
    }

    public ConfiguradorResultadoNephrosys(Frame pai, String titulo) {
        super(pai, titulo);
        this.montaTela();
    }

    private void montaTela() {
        this.setSize(new Dimension(680, 400));
        this.setResizable(false);
        this.setModal(true);
        JPanel panel = this.getPanelCentral();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.fill = 0;
        c.weightx = 0.0;
        c.gridwidth = 1;
        panel.add((Component)this.checkHemograma, c);
        ++c.gridy;
        panel.add((Component)this.labelCampoJalis, c);
        c.gridx += 2;
        panel.add((Component)this.labelExameNephosys, c);
        ++c.gridx;
        panel.add((Component)this.labelCampoValorMarcador, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        c.fill = 2;
        c.weightx = 1.0;
        this.comboCampoJalis.setPreferredSize(new Dimension(180, 20));
        this.comboCampoJalis.setMinimumSize(new Dimension(180, 20));
        panel.add((Component)this.comboCampoJalis, c);
        ++c.gridx;
        this.buttonCampoJalis.setPreferredSize(new Dimension(20, 20));
        this.buttonCampoJalis.setMinimumSize(new Dimension(20, 20));
        Funcoes.imagemPesquisa(this.buttonCampoJalis);
        panel.add((Component)this.buttonCampoJalis, c);
        ++c.gridx;
        c.fill = 0;
        c.weightx = 0.0;
        this.comboExameNephrosys.setPreferredSize(new Dimension(180, 20));
        this.comboExameNephrosys.setMinimumSize(new Dimension(180, 20));
        panel.add((Component)this.comboExameNephrosys, c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        this.comboMarcador.setPreferredSize(new Dimension(200, 20));
        this.comboMarcador.setMinimumSize(new Dimension(200, 20));
        panel.add((Component)this.comboMarcador, c);
        ++c.gridx;
        this.buttonExameNephrosys.setPreferredSize(new Dimension(20, 20));
        this.buttonExameNephrosys.setMinimumSize(new Dimension(20, 20));
        Funcoes.imagemPesquisa(this.buttonExameNephrosys);
        panel.add((Component)this.buttonExameNephrosys, c);
        ++c.gridx;
        c.fill = 0;
        c.weightx = 0.0;
        this.buttonOKCampo.setMinimumSize(new Dimension(40, 20));
        this.buttonOKCampo.setPreferredSize(new Dimension(40, 20));
        panel.add((Component)this.buttonOKCampo, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 6;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        panel.add((Component)this.scroll, c);
        this.modelo.setColumnSize(new int[]{0, 0, 0}, this.table);
        this.table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127 && ConfiguradorResultadoNephrosys.this.table.getSelectedRow() > -1 && Funcoes.mensagem(ConfiguradorResultadoNephrosys.this, "Deseja excluir o registro selecionado?", 4) == 0) {
                    ConfiguradorResultadoNephrosys.this.modelo.removeLine(ConfiguradorResultadoNephrosys.this.table.getSelectedRow());
                } else if (e.getKeyCode() == 32 && ConfiguradorResultadoNephrosys.this.table.getSelectedRow() > -1) {
                    ConfiguradorResultadoNephrosys.this.editandoLinha = ConfiguradorResultadoNephrosys.this.table.getSelectedRow();
                    ConfiguradorResultadoNephrosys.this.comboExameNephrosys.setSelectedItem((Object)((ExamesNephrosys)((Object)ConfiguradorResultadoNephrosys.this.modelo.getValueAt(ConfiguradorResultadoNephrosys.this.editandoLinha, 1))));
                    ConfiguradorResultadoNephrosys.this.comboCampoJalis.setSelectedItem(ConfiguradorResultadoNephrosys.this.modelo.getValueAt(ConfiguradorResultadoNephrosys.this.editandoLinha, 0).toString());
                    ConfiguradorResultadoNephrosys.this.comboMarcador.setSelectedItem(ConfiguradorResultadoNephrosys.this.modelo.getValueAt(ConfiguradorResultadoNephrosys.this.editandoLinha, 2).toString());
                    ScreenUtil.requisitarFoco(ConfiguradorResultadoNephrosys.this.comboExameNephrosys);
                }
            }
        });
        this.checkHemograma.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ConfiguradorResultadoNephrosys.this.isPreenchendoDados) {
                    return;
                }
                if (ConfiguradorResultadoNephrosys.this.modelo.getRowCount() > 0) {
                    int resp = Funcoes.mensagem(ConfiguradorResultadoNephrosys.this, "Mudar o tipo do exame remover\u00e1 as configura\u00e7\u00f5es feitas.\nDeseja mudar o tipo?", 4);
                    if (resp == 0) {
                        ConfiguradorResultadoNephrosys.this.modelo.clear();
                        ConfiguradorResultadoNephrosys.this.comboExameNephrosys.setModel(new DefaultComboBoxModel<ExamesNephrosys>(ExamesNephrosys.getExames(ConfiguradorResultadoNephrosys.this.checkHemograma.isSelected())));
                    } else {
                        ConfiguradorResultadoNephrosys.this.checkHemograma.setSelected(!ConfiguradorResultadoNephrosys.this.checkHemograma.isSelected());
                    }
                } else {
                    ConfiguradorResultadoNephrosys.this.comboExameNephrosys.setModel(new DefaultComboBoxModel<ExamesNephrosys>(ExamesNephrosys.getExames(ConfiguradorResultadoNephrosys.this.checkHemograma.isSelected())));
                }
            }
        });
        ScreenUtil.requisitarFoco(this.comboCampoJalis);
    }

    public void setCampos(String[] campos) {
        if (campos != null) {
            this.comboCampoJalis.removeAllItems();
            this.comboMarcador.removeAllItems();
            this.comboMarcador.addItem("");
            this.camposLaudo = campos;
            ArrayList<String> listaCampos = new ArrayList<String>();
            for (String aux : campos) {
                listaCampos.add(aux);
            }
            Collections.sort(listaCampos);
            for (String aux : listaCampos) {
                this.comboCampoJalis.addItem(aux);
                this.comboMarcador.addItem(aux);
            }
        }
    }

    public String getXml() {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.modelo.getRowCount(); ++i) {
            buf.append("<").append(TAG_CAMPO).append(">");
            buf.append(StringUtil.getTag(TAG_ORDEM, String.valueOf(i)));
            buf.append(StringUtil.getTag(TAG_NOME, this.modelo.getValueAt(i, 0).toString()));
            buf.append(StringUtil.getTag(TAG_VALOR, ((ExamesNephrosys)((Object)this.modelo.getValueAt((int)i, (int)1))).codigo));
            buf.append(StringUtil.getTag(TAG_MARCADOR, this.modelo.getValueAt(i, 2).toString()));
            buf.append(StringUtil.getTag(TAG_HEMOGRAMA, this.checkHemograma.isSelected() ? "true" : "false"));
            buf.append("</").append(TAG_CAMPO).append(">");
        }
        return StringUtil.getTag(EXPORTAR_NEPHROSYS, buf.toString());
    }

    public void setXml(String xml) {
        this.isPreenchendoDados = true;
        if (xml != null) {
            List<CampoValorNephrosys> campos = ConfiguradorResultadoNephrosys.getListaRelacionamentoCampos(xml);
            this.modelo.clear();
            boolean isHemograma = false;
            for (CampoValorNephrosys campo : campos) {
                isHemograma = campo.getHemograma();
                this.checkHemograma.setSelected(isHemograma);
                this.modelo.addLine(new Object[]{campo.getCampo(), ExamesNephrosys.getExame(campo.getValor(), campo.getHemograma()), campo.getMarcador()});
            }
            this.comboExameNephrosys.setModel(new DefaultComboBoxModel<ExamesNephrosys>(ExamesNephrosys.getExames(isHemograma)));
        }
        this.isPreenchendoDados = false;
    }

    public static Hashtable<String, CampoValorNephrosys> getRelacionamentoCampos(String xml) {
        Hashtable<String, CampoValorNephrosys> hash = new Hashtable<String, CampoValorNephrosys>();
        List<CampoValorNephrosys> lista = ConfiguradorResultadoNephrosys.getListaRelacionamentoCampos(xml);
        for (CampoValorNephrosys c : lista) {
            hash.put(c.getCampo(), c);
        }
        return hash;
    }

    public static List<CampoValorNephrosys> getListaRelacionamentoCampos(String xml) {
        ArrayList<CampoValorNephrosys> lista = new ArrayList<CampoValorNephrosys>();
        if (xml != null) {
            String[] campos;
            for (String s : campos = StringUtil.getValores(xml, TAG_CAMPO)) {
                int ordem = StringUtil.getInt(s, TAG_ORDEM);
                String nome = StringUtil.getValor(s, TAG_NOME);
                String valor = StringUtil.getValor(s, TAG_VALOR);
                String marcador = StringUtil.getValor(s, TAG_MARCADOR);
                boolean hemograma = StringUtil.getValor(s, TAG_HEMOGRAMA).equalsIgnoreCase("true");
                lista.add(new CampoValorNephrosys(ordem, nome, valor, marcador, hemograma));
            }
        }
        Collections.sort(lista, new Comparator(){

            public int compare(Object o1, Object o2) {
                int ordem2;
                int ordem1 = ((CampoValorNephrosys)o1).getOrdem();
                return ordem1 > (ordem2 = ((CampoValorNephrosys)o2).getOrdem()) ? 1 : (ordem1 < ordem2 ? -1 : 0);
            }
        });
        return lista;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonOKCampo) {
            this.adicionar();
        } else if (e.getSource() == this.buttonCampoJalis) {
            this.configuraCampoLaudo(this.comboCampoJalis);
        } else if (e.getSource() == this.buttonExameNephrosys) {
            this.configuraCampoLaudo(this.comboMarcador);
        } else {
            super.actionPerformed(e);
        }
    }

    private void configuraCampoLaudo(JComboBox combo) {
        String propriedadeCampoNomeUnidade = this.exameMatColeta.configuraAssociaCamposDeResultado();
        for (String campo : this.camposLaudo) {
            if (!campo.equalsIgnoreCase(propriedadeCampoNomeUnidade)) continue;
            combo.setSelectedItem(campo);
        }
    }

    private void adicionar() {
        if (this.editandoLinha > -1) {
            this.modelo.setValueAt((Object)((ExamesNephrosys)((Object)this.comboExameNephrosys.getSelectedItem())), this.editandoLinha, 1);
            this.modelo.setValueAt(this.comboCampoJalis.getSelectedItem().toString(), this.editandoLinha, 0);
            this.modelo.setValueAt(this.comboMarcador.getSelectedItem().toString(), this.editandoLinha, 2);
            this.editandoLinha = -1;
        } else if (this.modelo.localizar(0, this.comboCampoJalis.getSelectedItem().toString()) < 0) {
            this.modelo.addLine(new Object[]{this.comboCampoJalis.getSelectedItem().toString(), (ExamesNephrosys)((Object)this.comboExameNephrosys.getSelectedItem()), this.comboMarcador.getSelectedItem().toString()});
        }
        this.comboExameNephrosys.setSelectedIndex(0);
        ScreenUtil.requisitarFoco(this.comboCampoJalis);
    }

    public ExameMatCol getExameMatColeta() {
        return this.exameMatColeta;
    }

    public void setExameMatColeta(ExameMatCol exameMatColeta) {
        this.exameMatColeta = exameMatColeta;
    }
}

