/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao;

import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class ConfiguradorResultadoExportacaoJalis
extends AbstractDialogoOKCancelar
implements ActionListener {
    public static final String EXPORTAR_TEXTO = "exportartexto";
    private final int COLUNA_CAMPO = 0;
    private final int COLUNA_ALTERNATIVO = 1;
    private final int COLUNA_DETALHES = 2;
    private final int COLUNA_DETALHES_VALOR = 0;
    private final int COLUNA_DETALHES_TROCA = 1;
    private JButton buttonOKCampo = ComponenteFactory.novoJButton("OK", '\u0000', this, null, new Dimension(40, 20));
    private JLabel labelLink = new JLabel("IP:");
    private JLabel labelPorta = new JLabel("Porta:");
    private JLabel labelDiretorio = new JLabel("Diret\u00f3rio:");
    private JLabel labelUsuario = new JLabel("Usu\u00e1rio:");
    private JLabel labelSenha = new JLabel("Senha:");
    private TTextField textLink = new TTextField(50);
    private TTextField textPorta = new TTextField(15);
    private TTextField textDiretorio = new TTextField(100);
    private TTextField textUsuario = new TTextField(30);
    private TTextField textSenha = new TTextField(30);
    private int editandoLinha = -1;

    public static ConfiguradorResultadoExportacaoJalis novaInstancia(Object pai) {
        if (pai instanceof Dialog) {
            return new ConfiguradorResultadoExportacaoJalis((Dialog)pai, "Configura\u00e7\u00f5es de exporta\u00e7\u00e3o");
        }
        return new ConfiguradorResultadoExportacaoJalis((Frame)pai, "Configura\u00e7\u00f5es de exporta\u00e7\u00e3o");
    }

    public ConfiguradorResultadoExportacaoJalis(Dialog pai, String titulo) {
        super(pai, titulo);
        this.montaTela();
    }

    public ConfiguradorResultadoExportacaoJalis(Frame pai, String titulo) {
        super(pai, titulo);
        this.montaTela();
    }

    private void montaTela() {
        this.setSize(new Dimension(400, 200));
        this.setResizable(false);
        this.setModal(true);
        JPanel panel = this.getPanelCentral();
        panel.setLayout(new GridBagLayout());
        panel.setBorder(new TitledBorder("Dados do FTP"));
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = new Insets(1, 1, 1, 1);
        this.labelLink.setPreferredSize(new Dimension(40, 20));
        this.labelLink.setMinimumSize(new Dimension(40, 20));
        panel.add((Component)this.labelLink, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        panel.add((Component)this.textLink, c);
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 0.0;
        c.fill = 0;
        this.labelDiretorio.setPreferredSize(new Dimension(60, 20));
        this.labelDiretorio.setMinimumSize(new Dimension(60, 20));
        panel.add((Component)this.labelDiretorio, c);
        ++c.gridx;
        c.gridwidth = 0;
        c.weightx = 1.0;
        c.fill = 2;
        panel.add((Component)this.textDiretorio, c);
        c.gridx = 0;
        c.gridy = 2;
        c.weightx = 0.0;
        c.anchor = 17;
        c.fill = 0;
        this.labelPorta.setPreferredSize(new Dimension(50, 20));
        this.labelPorta.setMinimumSize(new Dimension(50, 20));
        panel.add((Component)this.labelPorta, c);
        ++c.gridx;
        c.weightx = 1.0;
        this.textPorta.setPreferredSize(new Dimension(50, 20));
        this.textPorta.setMinimumSize(new Dimension(50, 20));
        panel.add((Component)this.textPorta, c);
        c.gridx = 0;
        c.gridy = 3;
        c.weightx = 0.0;
        c.anchor = 17;
        c.fill = 0;
        this.labelUsuario.setPreferredSize(new Dimension(50, 20));
        this.labelUsuario.setMinimumSize(new Dimension(50, 20));
        panel.add((Component)this.labelUsuario, c);
        ++c.gridx;
        c.weightx = 1.0;
        this.textUsuario.setPreferredSize(new Dimension(120, 20));
        this.textUsuario.setMinimumSize(new Dimension(120, 20));
        panel.add((Component)this.textUsuario, c);
        c.gridx = 0;
        c.gridy = 4;
        c.weightx = 0.0;
        c.anchor = 17;
        c.fill = 0;
        this.labelSenha.setPreferredSize(new Dimension(50, 20));
        this.labelSenha.setMinimumSize(new Dimension(50, 20));
        panel.add((Component)this.labelSenha, c);
        ++c.gridx;
        c.weightx = 1.0;
        this.textSenha.setPreferredSize(new Dimension(120, 20));
        this.textSenha.setMinimumSize(new Dimension(120, 20));
        panel.add((Component)this.textSenha, c);
        ScreenUtil.centralizar(this);
    }

    public String getXml() {
        XMLStringBuilder xml = new XMLStringBuilder();
        xml.abrir("configuracaoResultadoExportacaoJalis");
        xml.escrever("link", this.textLink.getText().trim());
        xml.escrever("diretorio", this.textDiretorio.getText().trim());
        xml.escrever("porta", this.textPorta.getText().trim());
        xml.escrever("usuario", this.textUsuario.getText().trim());
        xml.escrever("senha", this.textSenha.getText().trim());
        try {
            xml.fechar("configuracaoResultadoExportacaoJalis");
        }
        catch (XMLStringBuilderException e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel gerar a configura\u00e7\u00e3o de resultado." + e.getMessage(), e.getStackTrace());
        }
        return xml.getXML();
    }

    public void setXml(String xml) {
        if (!Funcoes.textoVazio(xml)) {
            String link = StringUtil.getValor(xml, "link");
            String porta = StringUtil.getValor(xml, "porta");
            String diretorio = StringUtil.getValor(xml, "diretorio");
            String usuario = StringUtil.getValor(xml, "usuario");
            String senha = StringUtil.getValor(xml, "senha");
            this.textLink.setText(link);
            this.textPorta.setText(porta);
            this.textDiretorio.setText(diretorio);
            this.textUsuario.setText(usuario);
            this.textSenha.setText(senha);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonOK) {
            this.ok = true;
        }
        super.actionPerformed(e);
    }
}

