/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao;

import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.exportacao.Campo;
import jalis.laboratorio.exportacao.FabricaConfiguradorExportacaoResultado;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class ConfiguradorExportacaoSus
extends AbstractDialogoOKCancelar
implements FabricaConfiguradorExportacaoResultado {
    public static final String EXPORTAR_SUS = "exportarSus";
    private final int COL_CAMPO_ORIGEM = 0;
    private final int COL_CAMPO_DESTINO = 1;
    private final int COL_CAMPO_TIPO = 2;
    private final int COL_CAMPO_POS = 3;
    private final int COL_RESULTADO_DESC = 0;
    private final int COL_RESULTADO_CAMPOS = 1;
    public static final String TIPO_TEXTO = "T";
    public static final String TIPO_MODELO = "M";
    private String[] camposSus = new String[]{"dsUnidade", "vlReferencia", "vlResultado"};
    private JComboBox comboCampos = ComponenteFactory.novoJComboBox(new Dimension(40, 20));
    private JComboBox comboCamposSus = ComponenteFactory.novoJComboBox(new Dimension(40, 20));
    private JLabel labelCampos = ComponenteFactory.novoJLabel("Campos do Modelo", 'm', null, this.comboCampos);
    private JLabel labelCampoDestino = ComponenteFactory.novoJLabel("Destino", 'd', null, this.comboCamposSus);
    private TTextField textTextoFixo = ComponenteFactory.novoTTextField(20, 3);
    private JLabel labelTextoFixo = ComponenteFactory.novoJLabel("Texto Fixo", 't', null, this.textTextoFixo);
    private JButton buttonOKCampo = ComponenteFactory.novoJButton("OK", '\u0000', this, null, new Dimension(40, 20));
    private ModeloGridTable modelo = new ModeloGridTable(new String[]{"Origem", "Destino"});
    private JTable table = new JTable(this.modelo);
    private JScrollPane scroll = new JScrollPane(this.table);
    private JLabel labelResultado = new JLabel("Descri\u00e7\u00e3o do Resultado (dsResultado)");
    private TTextField textDescResultado = new TTextField();
    private ModeloGridTable modeloResultados = new ModeloGridTable(new String[]{"Descri\u00e7\u00e3o do Resultado"});
    private JTable tableResultados = ComponenteFactory.novoJTable(this.modeloResultados);
    private JScrollPane scrollResultados = new JScrollPane(this.tableResultados);
    private JButton buttonAddResultado = ComponenteFactory.novoJButton("Adiciona", '\u0000', this, null, new Dimension(40, 20));
    private JPanel panelCampos;
    private int editandoLinhaCampo = -1;
    private int editandoLinhaResultado = -1;

    public static ConfiguradorExportacaoSus novaInstancia(Object pai) {
        if (pai instanceof Dialog) {
            return new ConfiguradorExportacaoSus((Dialog)pai, "Resultado - Sistema SUS");
        }
        return new ConfiguradorExportacaoSus((Frame)pai, "Resultado - Sistema SUS");
    }

    public ConfiguradorExportacaoSus(Dialog pai, String titulo) {
        super(pai, titulo);
        this.montaTela();
    }

    public ConfiguradorExportacaoSus(Frame pai, String titulo) {
        super(pai, titulo);
        this.montaTela();
    }

    private void montaTela() {
        this.setSize(new Dimension(400, 470));
        this.setResizable(false);
        this.setModal(true);
        JPanel panel = this.getPanelCentral();
        this.panelCampos = new JPanel(new GridBagLayout());
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        JPanel aux = new JPanel(new GridBagLayout());
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 1.0;
        c.gridwidth = 4;
        panel.add((Component)aux, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 1.0;
        c.gridwidth = 2;
        aux.add((Component)this.labelResultado, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        this.textDescResultado.setPreferredSize(new Dimension(302, 20));
        c.fill = 2;
        c.anchor = 17;
        aux.add((Component)this.textDescResultado, c);
        c.gridx = 1;
        c.gridy = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.anchor = 13;
        c.fill = 0;
        this.buttonAddResultado.setPreferredSize(new Dimension(80, 20));
        aux.add((Component)this.buttonAddResultado, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 4;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        panel.add((Component)this.scrollResultados, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 4;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        panel.add((Component)this.panelCampos, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.fill = 2;
        c.weightx = 1.0;
        c.gridwidth = 3;
        this.panelCampos.add((Component)this.labelCampoDestino, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        this.comboCamposSus.setMinimumSize(new Dimension(40, 20));
        this.panelCampos.add((Component)this.comboCamposSus, c);
        c.gridx = 0;
        ++c.gridy;
        c.fill = 2;
        c.weightx = 1.0;
        c.gridwidth = 2;
        this.panelCampos.add((Component)this.labelCampos, c);
        c.gridx = 2;
        c.fill = 2;
        c.weightx = 1.0;
        c.gridwidth = 2;
        this.panelCampos.add((Component)this.labelTextoFixo, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        this.comboCampos.setMinimumSize(new Dimension(40, 20));
        this.panelCampos.add((Component)this.comboCampos, c);
        c.gridx = 2;
        c.fill = 2;
        c.weightx = 1.0;
        this.textTextoFixo.setMinimumSize(new Dimension(80, 20));
        this.panelCampos.add((Component)this.textTextoFixo, c);
        c.gridx = 3;
        c.fill = 0;
        c.weightx = 0.0;
        this.buttonOKCampo.setMinimumSize(new Dimension(40, 20));
        this.buttonOKCampo.setMaximumSize(new Dimension(40, 20));
        this.panelCampos.add((Component)this.buttonOKCampo, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 4;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.panelCampos.add((Component)this.scroll, c);
        for (String item : this.camposSus) {
            this.comboCamposSus.addItem(item);
        }
        this.table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127 && ConfiguradorExportacaoSus.this.table.getSelectedRow() > -1 && Funcoes.mensagem(ConfiguradorExportacaoSus.this, "Deseja excluir o registro selecionado?", 4) == 0) {
                    int pos = ConfiguradorExportacaoSus.this.table.getSelectedRow();
                    ArrayList campos = (ArrayList)ConfiguradorExportacaoSus.this.modeloResultados.getValueAt(ConfiguradorExportacaoSus.this.editandoLinhaResultado, 1);
                    campos.remove(Integer.parseInt(ConfiguradorExportacaoSus.this.modelo.getValueAt(pos, 3).toString()));
                    ConfiguradorExportacaoSus.this.modelo.removeLine(pos);
                } else if (e.getKeyCode() == 32 && ConfiguradorExportacaoSus.this.table.getSelectedRow() > -1) {
                    ConfiguradorExportacaoSus.this.editCampo();
                }
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ConfiguradorExportacaoSus.this.editCampo();
                }
            }
        });
        this.tableResultados.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && ConfiguradorExportacaoSus.this.tableResultados.getSelectedRow() > -1) {
                    ConfiguradorExportacaoSus.this.editResultado();
                }
            }
        });
        this.tableResultados.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127 && ConfiguradorExportacaoSus.this.tableResultados.getSelectedRow() > -1 && Funcoes.mensagem(ConfiguradorExportacaoSus.this, "Deseja excluir o registro selecionado?", 4) == 0) {
                    ScreenUtil.habilitarDesabilitarComponentes(ConfiguradorExportacaoSus.this.panelCampos, false);
                    ConfiguradorExportacaoSus.this.modeloResultados.removeLine(ConfiguradorExportacaoSus.this.tableResultados.getSelectedRow());
                    ConfiguradorExportacaoSus.this.modelo.clear();
                } else if (e.getKeyCode() == 32 && ConfiguradorExportacaoSus.this.tableResultados.getSelectedRow() > -1) {
                    ConfiguradorExportacaoSus.this.editResultado();
                }
            }
        });
        this.tableResultados.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ConfiguradorExportacaoSus.this.editResultado();
                }
            }
        });
        this.comboCamposSus.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ConfiguradorExportacaoSus.this.comboCampoSusStateChagend();
                }
            }
        });
        this.comboCampos.setEnabled(false);
        ScreenUtil.requisitarFoco(this.textDescResultado);
        ScreenUtil.habilitarDesabilitarComponentes(this.panelCampos, false);
    }

    public void setCampos(String[] campos) {
        if (campos != null) {
            this.comboCampos.removeAllItems();
            for (String s : campos) {
                this.comboCampos.addItem(s.toLowerCase());
            }
        }
    }

    @Override
    public String getXml() {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.modeloResultados.getRowCount(); ++i) {
            buf.append("<resultado>");
            buf.append(StringUtil.getTag("descricao", this.modeloResultados.getValueAt(i, 0).toString()));
            buf.append(StringUtil.getTag("campos", this.getCampos((ArrayList)this.modeloResultados.getValueAt(i, 1))));
            buf.append("</resultado>");
        }
        return StringUtil.getTag(EXPORTAR_SUS, buf.toString());
    }

    private String getCampos(ArrayList<Campo> campos) {
        StringBuilder bui = new StringBuilder();
        for (Campo campo : campos) {
            bui.append("<campo>");
            bui.append("<origem>").append(campo.getOrigem()).append("</origem>");
            bui.append("<destino>").append(campo.getDestino()).append("</destino>");
            bui.append("<tipo>").append(campo.getTipo()).append("</tipo>");
            bui.append("</campo>/n");
        }
        return bui.toString();
    }

    @Override
    public void setXml(String xml) {
        if (xml != null) {
            this.modeloResultados.clear();
            for (String resultado : StringUtil.getValores(xml, "resultado")) {
                ArrayList<Campo> campos = new ArrayList<Campo>();
                String xmlCampos = StringUtil.getValor(resultado, "campos");
                for (String xmlCampo : StringUtil.getValores(xmlCampos, "campo")) {
                    campos.add(new Campo(StringUtil.getValor(xmlCampo, "origem"), StringUtil.getValor(xmlCampo, "destino"), StringUtil.getValor(xmlCampo, "tipo")));
                }
                this.modeloResultados.addLine(new Object[]{StringUtil.getValor(resultado, "descricao"), campos});
            }
        }
    }

    private void setCamposResultado(ArrayList<Campo> campos) {
        if (campos != null) {
            this.modelo.clear();
            for (Campo campo : campos) {
                this.modelo.addLine(new Object[]{campo.getOrigem(), campo.getDestino(), campo.getTipo(), campos.indexOf(campo)});
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonOKCampo) {
            this.adicionar();
        } else if (e.getSource() == this.buttonAddResultado) {
            this.adicionarResultado();
        } else {
            super.actionPerformed(e);
        }
    }

    private void adicionar() {
        if (this.textTextoFixo.isEnabled() && Funcoes.textoVazio(this.textTextoFixo)) {
            Funcoes.mensagem(this, "Campo texto deve ser preenchido", 2);
            return;
        }
        if (this.modelo.localizar(1, this.comboCamposSus.getSelectedItem().toString()) > -1 && this.editandoLinhaCampo < 0) {
            Funcoes.mensagem(this, "Campo j\u00e1 cadastrado", 2);
            return;
        }
        if (this.editandoLinhaCampo > -1 && this.textTextoFixo.isEnabled()) {
            this.setCampo(TIPO_TEXTO, this.textTextoFixo.getText());
        } else if (this.editandoLinhaCampo > -1 && this.comboCampos.isEnabled()) {
            this.setCampo(TIPO_MODELO, this.comboCampos.getSelectedItem().toString());
        } else if (this.modelo.localizar(0, this.comboCampos.getSelectedItem().toString()) < 0 && this.modelo.localizar(1, this.comboCamposSus.getSelectedItem().toString()) < 0 && this.comboCampos.isEnabled() && this.editandoLinhaResultado > -1) {
            this.addCampo(TIPO_MODELO, this.comboCampos.getSelectedItem().toString());
        } else if (this.textTextoFixo.isEnabled() && !Funcoes.textoVazio(this.textTextoFixo) && this.editandoLinhaResultado > -1) {
            this.addCampo(TIPO_TEXTO, this.textTextoFixo.getText());
        }
        this.textTextoFixo.clear();
        ScreenUtil.requisitarFoco(this.comboCamposSus);
    }

    private void setCampo(String tipo, String destino) {
        ArrayList campos = (ArrayList)this.modeloResultados.getValueAt(this.editandoLinhaResultado, 1);
        Campo campo = new Campo(destino, this.comboCamposSus.getSelectedItem().toString(), tipo);
        campos.add(campo);
        this.modelo.setValueAt(campo.getDestino(), this.editandoLinhaCampo, 1);
        this.modelo.setValueAt(campo.getOrigem(), this.editandoLinhaCampo, 0);
        this.editandoLinhaCampo = -1;
    }

    private void addCampo(String tipo, String origem) {
        ArrayList campos = (ArrayList)this.modeloResultados.getValueAt(this.editandoLinhaResultado, 1);
        Campo campo = new Campo(origem, this.comboCamposSus.getSelectedItem().toString(), tipo);
        campos.add(campo);
        this.modelo.addLine(new Object[]{campo.getOrigem(), campo.getDestino(), campo.getTipo(), campos.indexOf(campo)});
    }

    private void adicionarResultado() {
        if (Funcoes.textoVazio(this.textDescResultado)) {
            Funcoes.mensagem(this, "Descri\u00e7\u00e3o para o resultado deve ser preenchida", 2);
            return;
        }
        int pos = this.modeloResultados.localizar(0, this.textDescResultado.getText());
        if (pos > -1 && pos != this.editandoLinhaResultado) {
            Funcoes.mensagem(this, "Resultado j\u00e1 cadastrado", 2);
            return;
        }
        if (!Funcoes.textoVazio(this.textDescResultado)) {
            this.modeloResultados.addLine(new Object[]{this.textDescResultado.getText(), new ArrayList()});
        }
        this.textDescResultado.clear();
        this.modelo.clear();
        ScreenUtil.requisitarFoco(this.comboCamposSus);
        ScreenUtil.habilitarDesabilitarComponentes(this.panelCampos, false);
    }

    private boolean validaExames() {
        if (this.modeloResultados.getRowCount() > 0) {
            ArrayList<String> res = new ArrayList<String>();
            for (int i = 0; i < this.modeloResultados.getRowCount(); ++i) {
                if (!Funcoes.textoVazio(this.modeloResultados.getValueAt(i, 1).toString())) continue;
                res.add(this.modeloResultados.getValueAt(i, 0).toString());
            }
            if (res.size() > 0) {
                Funcoes.mensagem(this, "Os resultados " + StringUtil.implode(res, ",") + " n\u00e3o est\u00e3o com seus campos definidos", 2);
            }
            ScreenUtil.requisitarFoco(this.comboCamposSus);
            return false;
        }
        return true;
    }

    private void editCampo() {
        this.editandoLinhaCampo = this.table.getSelectedRow();
        if (this.modelo.getValueAt(this.editandoLinhaCampo, 2).toString().equals(TIPO_TEXTO)) {
            this.textTextoFixo.setEnabled(true);
            this.comboCampos.setEnabled(false);
            this.textTextoFixo.setText(this.modelo.getValueAt(this.editandoLinhaCampo, 0).toString());
            this.comboCamposSus.setSelectedItem(this.modelo.getValueAt(this.editandoLinhaCampo, 1).toString());
        } else {
            this.textTextoFixo.setEnabled(false);
            this.comboCampos.setEnabled(true);
            this.comboCamposSus.setSelectedItem(this.modelo.getValueAt(this.editandoLinhaCampo, 1).toString());
            this.comboCampos.setSelectedItem(this.modelo.getValueAt(this.editandoLinhaCampo, 0).toString());
        }
        ScreenUtil.requisitarFoco(this.comboCamposSus);
    }

    private void editResultado() {
        this.editandoLinhaResultado = this.tableResultados.getSelectedRow();
        this.textDescResultado.setText(this.modeloResultados.getValueAt(this.editandoLinhaResultado, 0).toString());
        this.setCamposResultado((ArrayList)this.modeloResultados.getValueAt(this.editandoLinhaResultado, 1));
        ScreenUtil.habilitarDesabilitarComponentes(this.panelCampos, true);
        ScreenUtil.requisitarFoco(this.comboCamposSus);
        this.comboCampoSusStateChagend();
    }

    private void comboCampoSusStateChagend() {
        this.textTextoFixo.setEnabled(this.comboCamposSus.getSelectedIndex() != 2);
        this.comboCampos.setEnabled(!this.textTextoFixo.isEnabled());
    }
}

