/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao;

import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.exportacao.CampoResultado;
import jalis.laboratorio.exportacao.FabricaConfiguradorExportacaoResultado;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class ConfiguradorExportacaoSoc
extends AbstractDialogoOKCancelar
implements FabricaConfiguradorExportacaoResultado,
ActionListener {
    public static final String PRIMEIRO_CAMPO = "Importar Multi-Empresas (Com Prestador)";
    public static final CampoResultado GERAL_COD_EMPRESA = new CampoResultado(0, "CodEmpresa", 8, CampoResultado.Tipo.TEXTO.codigo, true);
    public static final CampoResultado GERAL_IDENTIFICACAO_FUNCIONARIO = new CampoResultado(1, "Identifica\u00e7\u00e3o Funcion\u00e1rio", 8, CampoResultado.Tipo.TEXTO.codigo, true);
    public static final CampoResultado GERAL_NOME_FUNCIONARIO = new CampoResultado(2, "Nome Funcion\u00e1rio", 60, CampoResultado.Tipo.TEXTO.codigo);
    public static final CampoResultado GERAL_CODIGO_EXAME = new CampoResultado(3, "C\u00f3digo do Exame", 12, CampoResultado.Tipo.TEXTO.codigo, true, true);
    public static final CampoResultado GERAL_NOME_EXAME = new CampoResultado(4, "Nome do Exame", 80, CampoResultado.Tipo.TEXTO.codigo, false, true);
    public static final CampoResultado GERAL_DATA_RES_EXAME = new CampoResultado(5, "Data Res. Exame", 10, CampoResultado.Tipo.DATA.codigo, true);
    public static final CampoResultado GERAL_DATA_FICHA = new CampoResultado(6, "Data da Ficha", 10, CampoResultado.Tipo.DATA.codigo, true);
    public static final CampoResultado GERAL_MESES_PROXIMO_EXAME = new CampoResultado(7, "Meses do Pr\u00f3ximo Exame", 2, CampoResultado.Tipo.NUMERO.codigo);
    public static final CampoResultado GERAL_EXAME_ALTERADO = new CampoResultado(8, "Exame Alterado", 1, CampoResultado.Tipo.BOOLEAN.codigo, true);
    public static final CampoResultado GERAL_EM_ANALISE = new CampoResultado(9, "Em An\u00e1lise", 1, CampoResultado.Tipo.BOOLEAN.codigo, true);
    public static final CampoResultado GERAL_OCUPACIONAL = new CampoResultado(10, "Ocupacional", 1, CampoResultado.Tipo.BOOLEAN.codigo, true);
    public static final CampoResultado GERAL_AGRAVAMENTO = new CampoResultado(11, "Agravamento", 1, CampoResultado.Tipo.BOOLEAN.codigo, true);
    public static final CampoResultado GERAL_REF_SEQ_NAOAPLICA = new CampoResultado(12, "Ref./Seq.", 1, CampoResultado.Tipo.NUMERO.codigo);
    public static final CampoResultado GERAL_TIPO_EXAME = new CampoResultado(13, "Tipo de exame", 2, CampoResultado.Tipo.TEXTO.codigo, true);
    public static final CampoResultado GERAL_OBSERVACAO = new CampoResultado(14, "Observa\u00e7\u00e3o", 70, CampoResultado.Tipo.TEXTO.codigo);
    public static final CampoResultado GERAL_RESULTADO = new CampoResultado(15, "Resultado", 100, CampoResultado.Tipo.TEXTO.codigo);
    public static final CampoResultado GERAL_COD_MEDICO = new CampoResultado(16, "C\u00f3d M\u00e9dico", 5, CampoResultado.Tipo.NUMERO.codigo);
    public static final CampoResultado GERAL_COD_EXAMINADOR = new CampoResultado(17, "C\u00f3d Examinador", 5, CampoResultado.Tipo.NUMERO.codigo);
    public static final CampoResultado GERAL_PARECER_ASO = new CampoResultado(18, "Parecer Aso", 1, CampoResultado.Tipo.NUMERO.codigo);
    public static final CampoResultado GERAL_COD_PRESTADOR = new CampoResultado(19, "C\u00f3d. Prestador", 4, CampoResultado.Tipo.NUMERO.codigo, true);
    public static final CampoResultado GERAL_LIVRE1 = new CampoResultado(20, "Livre", 0, CampoResultado.Tipo.TEXTO.codigo);
    public static final CampoResultado GERAL_LIVRE2 = new CampoResultado(21, "Livre", 0, CampoResultado.Tipo.TEXTO.codigo);
    public static final CampoResultado GERAL_LIVRE3 = new CampoResultado(22, "Livre", 0, CampoResultado.Tipo.TEXTO.codigo);
    public static final CampoResultado[] CAMPOS_GERAL = new CampoResultado[]{GERAL_COD_EMPRESA, GERAL_IDENTIFICACAO_FUNCIONARIO, GERAL_NOME_FUNCIONARIO, GERAL_CODIGO_EXAME, GERAL_NOME_EXAME, GERAL_DATA_RES_EXAME, GERAL_DATA_FICHA, GERAL_MESES_PROXIMO_EXAME, GERAL_EXAME_ALTERADO, GERAL_EM_ANALISE, GERAL_OCUPACIONAL, GERAL_AGRAVAMENTO, GERAL_REF_SEQ_NAOAPLICA, GERAL_TIPO_EXAME, GERAL_OBSERVACAO, GERAL_RESULTADO, GERAL_COD_MEDICO, GERAL_COD_EXAMINADOR, GERAL_PARECER_ASO, GERAL_COD_PRESTADOR, GERAL_LIVRE1, GERAL_LIVRE2, GERAL_LIVRE3};
    public static final CampoResultado AUDIOMETRIA_OUVIDO_DIREITO = new CampoResultado(CAMPOS_GERAL.length + 0, "Ouvido Direito(OD)", 40, CampoResultado.Tipo.TEXTO.codigo);
    public static final CampoResultado AUDIOMETRIA_OUVIDO_ESQUERDO = new CampoResultado(CAMPOS_GERAL.length + 1, "Ouvido Esquerdo(OE)", 40, CampoResultado.Tipo.TEXTO.codigo);
    public static final CampoResultado AUDIOMETRIA_OD250_AEREA = new CampoResultado(CAMPOS_GERAL.length + 2, "OD 250 - Via Aerea", 3, CampoResultado.Tipo.NUMERO.codigo);
    public static final CampoResultado AUDIOMETRIA_OD500_AEREA = new CampoResultado(CAMPOS_GERAL.length + 3, "OD 500 - Via Aerea", 3, CampoResultado.Tipo.NUMERO.codigo);
    public static final CampoResultado AUDIOMETRIA_OD1000_AEREA = new CampoResultado(CAMPOS_GERAL.length + 4, "OD 1000 - Via Aerea", 3, CampoResultado.Tipo.NUMERO.codigo);
    public static final CampoResultado AUDIOMETRIA_OD2000_AEREA = new CampoResultado(CAMPOS_GERAL.length + 5, "OD 2000 - Via Aerea", 3, CampoResultado.Tipo.NUMERO.codigo);
    public static final CampoResultado AUDIOMETRIA_OD3000_AEREA = new CampoResultado(CAMPOS_GERAL.length + 6, "OD 3000 - Via Aerea", 3, CampoResultado.Tipo.NUMERO.codigo);
    public static final CampoResultado AUDIOMETRIA_OD4000_AEREA = new CampoResultado(CAMPOS_GERAL.length + 7, "OD 4000 - Via Aerea", 3, CampoResultado.Tipo.NUMERO.codigo);
    public static final CampoResultado AUDIOMETRIA_OD6000_AEREA = new CampoResultado(CAMPOS_GERAL.length + 8, "OD 6000 - Via Aerea", 3, CampoResultado.Tipo.NUMERO.codigo);
    public static final CampoResultado AUDIOMETRIA_OD8000_AEREA = new CampoResultado(CAMPOS_GERAL.length + 9, "OD 8000 - Via Aerea", 3, CampoResultado.Tipo.NUMERO.codigo);
    public static final CampoResultado AUDIOMETRIA_OD250_OSSEA = new CampoResultado(CAMPOS_GERAL.length + 10, "OD 250 - Via Ossea", 3, CampoResultado.Tipo.NUMERO.codigo);
    public static final CampoResultado AUDIOMETRIA_OD500_OSSEA = new CampoResultado(CAMPOS_GERAL.length + 11, "OD 500 - Via Ossea", 3, CampoResultado.Tipo.NUMERO.codigo);
    public static final CampoResultado AUDIOMETRIA_OD1000_OSSEA = new CampoResultado(CAMPOS_GERAL.length + 12, "OD 1000 - Via Ossea ", 3, CampoResultado.Tipo.NUMERO.codigo);
    public static final CampoResultado AUDIOMETRIA_OD2000_OSSEA = new CampoResultado(CAMPOS_GERAL.length + 13, "OD 2000 - Via Ossea", 3, CampoResultado.Tipo.NUMERO.codigo);
    public static final CampoResultado AUDIOMETRIA_OD3000_OSSEA = new CampoResultado(CAMPOS_GERAL.length + 14, "OD 3000 - Via Ossea", 3, CampoResultado.Tipo.NUMERO.codigo);
    public static final CampoResultado AUDIOMETRIA_OD4000_OSSEA = new CampoResultado(CAMPOS_GERAL.length + 15, "OD 4000 - Via Ossea", 3, CampoResultado.Tipo.NUMERO.codigo);
    public static final CampoResultado AUDIOMETRIA_OD6000_OSSEA = new CampoResultado(CAMPOS_GERAL.length + 16, "OD 6000 - Via Ossea", 3, CampoResultado.Tipo.NUMERO.codigo);
    public static final CampoResultado AUDIOMETRIA_OD8000_OSSEA = new CampoResultado(CAMPOS_GERAL.length + 17, "OD 8000 - Via Ossea", 3, CampoResultado.Tipo.NUMERO.codigo);
    public static final CampoResultado AUDIOMETRIA_OE250_AEREA = new CampoResultado(CAMPOS_GERAL.length + 18, "OE 250 - Via Aerea", 3, CampoResultado.Tipo.NUMERO.codigo);
    public static final CampoResultado AUDIOMETRIA_OE500_AEREA = new CampoResultado(CAMPOS_GERAL.length + 19, "OE 500 - Via Aerea", 3, CampoResultado.Tipo.NUMERO.codigo);
    public static final CampoResultado AUDIOMETRIA_OE1000_AEREA = new CampoResultado(CAMPOS_GERAL.length + 20, "OE 1000 - Via Aerea", 3, CampoResultado.Tipo.NUMERO.codigo);
    public static final CampoResultado AUDIOMETRIA_OE2000_AEREA = new CampoResultado(CAMPOS_GERAL.length + 21, "OE 2000 - Via Aerea", 3, CampoResultado.Tipo.NUMERO.codigo);
    public static final CampoResultado AUDIOMETRIA_OE3000_AEREA = new CampoResultado(CAMPOS_GERAL.length + 22, "OE 3000 - Via Aerea", 3, CampoResultado.Tipo.NUMERO.codigo);
    public static final CampoResultado AUDIOMETRIA_OE4000_AEREA = new CampoResultado(CAMPOS_GERAL.length + 23, "OE 4000 - Via Aerea", 3, CampoResultado.Tipo.NUMERO.codigo);
    public static final CampoResultado AUDIOMETRIA_OE6000_AEREA = new CampoResultado(CAMPOS_GERAL.length + 24, "OE 6000 - Via Aerea", 3, CampoResultado.Tipo.NUMERO.codigo);
    public static final CampoResultado AUDIOMETRIA_OE8000_AEREA = new CampoResultado(CAMPOS_GERAL.length + 25, "OE 8000 - Via Aerea", 3, CampoResultado.Tipo.NUMERO.codigo);
    public static final CampoResultado AUDIOMETRIA_OE250_OSSEA = new CampoResultado(CAMPOS_GERAL.length + 26, "OE 250 - Via Ossea", 3, CampoResultado.Tipo.NUMERO.codigo);
    public static final CampoResultado AUDIOMETRIA_OE500_OSSEA = new CampoResultado(CAMPOS_GERAL.length + 27, "OE 500 - Via Ossea", 3, CampoResultado.Tipo.NUMERO.codigo);
    public static final CampoResultado AUDIOMETRIA_OE1000_OSSEA = new CampoResultado(CAMPOS_GERAL.length + 28, "OE 1000 - Via Ossea ", 3, CampoResultado.Tipo.NUMERO.codigo);
    public static final CampoResultado AUDIOMETRIA_OE2000_OSSEA = new CampoResultado(CAMPOS_GERAL.length + 29, "OE 2000 - Via Ossea", 3, CampoResultado.Tipo.NUMERO.codigo);
    public static final CampoResultado AUDIOMETRIA_OE3000_OSSEA = new CampoResultado(CAMPOS_GERAL.length + 30, "OE 3000 - Via Ossea", 3, CampoResultado.Tipo.NUMERO.codigo);
    public static final CampoResultado AUDIOMETRIA_OE4000_OSSEA = new CampoResultado(CAMPOS_GERAL.length + 31, "OE 4000 - Via Ossea", 3, CampoResultado.Tipo.NUMERO.codigo);
    public static final CampoResultado AUDIOMETRIA_OE6000_OSSEA = new CampoResultado(CAMPOS_GERAL.length + 32, "OE 6000 - Via Ossea", 3, CampoResultado.Tipo.NUMERO.codigo);
    public static final CampoResultado AUDIOMETRIA_OE8000_OSSEA = new CampoResultado(CAMPOS_GERAL.length + 33, "OE 8000 - Via Ossea", 3, CampoResultado.Tipo.NUMERO.codigo);
    public static final CampoResultado AUDIOMETRIA_REPOUSO_AUDITIVO = new CampoResultado(CAMPOS_GERAL.length + 34, "Repouso Auditivo", 0, CampoResultado.Tipo.TEXTO.codigo);
    public static final CampoResultado AUDIOMETRIA_OTOSCOPIA_OD = new CampoResultado(CAMPOS_GERAL.length + 35, "Otoscopia(OD)", 0, CampoResultado.Tipo.TEXTO.codigo);
    public static final CampoResultado AUDIOMETRIA_OTOSCOPIA_OE = new CampoResultado(CAMPOS_GERAL.length + 36, "Otoscopia(OE)", 0, CampoResultado.Tipo.TEXTO.codigo);
    public static final CampoResultado[] CAMPOS_AUDIOMETRIA = new CampoResultado[]{AUDIOMETRIA_OUVIDO_DIREITO, AUDIOMETRIA_OUVIDO_ESQUERDO, AUDIOMETRIA_OD250_AEREA, AUDIOMETRIA_OD500_AEREA, AUDIOMETRIA_OD1000_AEREA, AUDIOMETRIA_OD2000_AEREA, AUDIOMETRIA_OD3000_AEREA, AUDIOMETRIA_OD4000_AEREA, AUDIOMETRIA_OD6000_AEREA, AUDIOMETRIA_OD8000_AEREA, AUDIOMETRIA_OD250_OSSEA, AUDIOMETRIA_OD500_OSSEA, AUDIOMETRIA_OD1000_OSSEA, AUDIOMETRIA_OD2000_OSSEA, AUDIOMETRIA_OD3000_OSSEA, AUDIOMETRIA_OD4000_OSSEA, AUDIOMETRIA_OD6000_OSSEA, AUDIOMETRIA_OD8000_OSSEA, AUDIOMETRIA_OE250_AEREA, AUDIOMETRIA_OE500_AEREA, AUDIOMETRIA_OE1000_AEREA, AUDIOMETRIA_OE2000_AEREA, AUDIOMETRIA_OE3000_AEREA, AUDIOMETRIA_OE4000_AEREA, AUDIOMETRIA_OE6000_AEREA, AUDIOMETRIA_OE8000_AEREA, AUDIOMETRIA_OE250_OSSEA, AUDIOMETRIA_OE500_OSSEA, AUDIOMETRIA_OE1000_OSSEA, AUDIOMETRIA_OE2000_OSSEA, AUDIOMETRIA_OE3000_OSSEA, AUDIOMETRIA_OE4000_OSSEA, AUDIOMETRIA_OE6000_OSSEA, AUDIOMETRIA_OE8000_OSSEA, AUDIOMETRIA_REPOUSO_AUDITIVO, AUDIOMETRIA_OTOSCOPIA_OD, AUDIOMETRIA_OTOSCOPIA_OE};
    public static final CampoResultado HEMOGRAMA_HEMACIAS = new CampoResultado(CAMPOS_GERAL.length + 0, "Hemacias", 6, CampoResultado.Tipo.NUMERO.codigo);
    public static final CampoResultado HEMOGRAMA_HEMOGLOBINA = new CampoResultado(CAMPOS_GERAL.length + 1, "Hemoglobina", 4, CampoResultado.Tipo.NUMERO.codigo);
    public static final CampoResultado HEMOGRAMA_HEMATOCRITO = new CampoResultado(CAMPOS_GERAL.length + 2, "Hematocrito", 4, CampoResultado.Tipo.NUMERO.codigo);
    public static final CampoResultado HEMOGRAMA_VCM = new CampoResultado(CAMPOS_GERAL.length + 3, "vcm", 20, CampoResultado.Tipo.NUMERO.codigo);
    public static final CampoResultado HEMOGRAMA_HCM = new CampoResultado(CAMPOS_GERAL.length + 4, "hcm", 20, CampoResultado.Tipo.NUMERO.codigo);
    public static final CampoResultado HEMOGRAMA_CHCM = new CampoResultado(CAMPOS_GERAL.length + 5, "chcm", 20, CampoResultado.Tipo.NUMERO.codigo);
    public static final CampoResultado HEMOGRAMA_ALT_MORFO_TINTORIAIS1 = new CampoResultado(CAMPOS_GERAL.length + 6, "Alt.Morfo Tintoriais", 70, CampoResultado.Tipo.TEXTO.codigo);
    public static final CampoResultado HEMOGRAMA_LEUCOCITOS_TOTAIS = new CampoResultado(CAMPOS_GERAL.length + 7, "Luc\u00f3citos Totais", 5, CampoResultado.Tipo.NUMERO.codigo);
    public static final CampoResultado HEMOGRAMA_NEUTROFILOS = new CampoResultado(CAMPOS_GERAL.length + 8, "Neutr\u00f3filos", 5, CampoResultado.Tipo.NUMERO.codigo);
    public static final CampoResultado HEMOGRAMA_METAMIELOCITOS = new CampoResultado(CAMPOS_GERAL.length + 9, "Metantel\u00f3citos", 5, CampoResultado.Tipo.NUMERO.codigo);
    public static final CampoResultado HEMOGRAMA_BASTONETES = new CampoResultado(CAMPOS_GERAL.length + 10, "Bastonetes", 5, CampoResultado.Tipo.NUMERO.codigo);
    public static final CampoResultado HEMOGRAMA_SEGMENTADOS = new CampoResultado(CAMPOS_GERAL.length + 11, "Segmentados", 5, CampoResultado.Tipo.NUMERO.codigo);
    public static final CampoResultado HEMOGRAMA_EOSINOFILOS = new CampoResultado(CAMPOS_GERAL.length + 12, "Eosin\u00f3filos", 5, CampoResultado.Tipo.NUMERO.codigo);
    public static final CampoResultado HEMOGRAMA_BASOFILOS = new CampoResultado(CAMPOS_GERAL.length + 13, "Bas\u00f3filos", 5, CampoResultado.Tipo.NUMERO.codigo);
    public static final CampoResultado HEMOGRAMA_LINFOCITOS_TIPICOS = new CampoResultado(CAMPOS_GERAL.length + 14, "Linf\u00f3citos T\u00edpicos", 5, CampoResultado.Tipo.NUMERO.codigo);
    public static final CampoResultado HEMOGRAMA_LINFOCITOS_ATIPICOS = new CampoResultado(CAMPOS_GERAL.length + 15, "Linf\u00f3citos At\u00edpicos", 5, CampoResultado.Tipo.NUMERO.codigo);
    public static final CampoResultado HEMOGRAMA_MONOCITOS = new CampoResultado(CAMPOS_GERAL.length + 16, "Mon\u00f3citos", 5, CampoResultado.Tipo.NUMERO.codigo);
    public static final CampoResultado HEMOGRAMA_ALT_MORFO_TINTORIAIS2 = new CampoResultado(CAMPOS_GERAL.length + 17, "Alt.Morfo Tintoriais", 70, CampoResultado.Tipo.TEXTO.codigo);
    public static final CampoResultado HEMOGRAMA_PLAQUETAS = new CampoResultado(CAMPOS_GERAL.length + 18, "Plaquetas", 6, CampoResultado.Tipo.NUMERO.codigo);
    public static final CampoResultado HEMOGRAMA_ALT_MORFO_TINTORIAIS3 = new CampoResultado(CAMPOS_GERAL.length + 19, "Alt.Morfo Tintoriais", 70, CampoResultado.Tipo.TEXTO.codigo);
    public static final CampoResultado[] CAMPOS_HEMOGRAMA = new CampoResultado[]{HEMOGRAMA_HEMACIAS, HEMOGRAMA_HEMOGLOBINA, HEMOGRAMA_HEMATOCRITO, HEMOGRAMA_VCM, HEMOGRAMA_HCM, HEMOGRAMA_CHCM, HEMOGRAMA_ALT_MORFO_TINTORIAIS1, HEMOGRAMA_LEUCOCITOS_TOTAIS, HEMOGRAMA_NEUTROFILOS, HEMOGRAMA_METAMIELOCITOS, HEMOGRAMA_BASTONETES, HEMOGRAMA_SEGMENTADOS, HEMOGRAMA_EOSINOFILOS, HEMOGRAMA_BASOFILOS, HEMOGRAMA_LINFOCITOS_TIPICOS, HEMOGRAMA_LINFOCITOS_ATIPICOS, HEMOGRAMA_MONOCITOS, HEMOGRAMA_ALT_MORFO_TINTORIAIS2, HEMOGRAMA_PLAQUETAS, HEMOGRAMA_ALT_MORFO_TINTORIAIS3};
    public static final CampoResultado ERITROGRAMA_HEMACIAS = new CampoResultado(CAMPOS_GERAL.length + 0, "Hemacias", 6, CampoResultado.Tipo.NUMERO.codigo);
    public static final CampoResultado ERITROGRAMA_HEMOGLOBINA = new CampoResultado(CAMPOS_GERAL.length + 1, "Hemoglobina", 4, CampoResultado.Tipo.NUMERO.codigo);
    public static final CampoResultado ERITROGRAMA_HEMATOCRITO = new CampoResultado(CAMPOS_GERAL.length + 2, "Hematocrito", 4, CampoResultado.Tipo.NUMERO.codigo);
    public static final CampoResultado ERITROGRAMA_VCM = new CampoResultado(CAMPOS_GERAL.length + 3, "vcm", 20, CampoResultado.Tipo.NUMERO.codigo);
    public static final CampoResultado ERITROGRAMA_HCM = new CampoResultado(CAMPOS_GERAL.length + 4, "hcm", 20, CampoResultado.Tipo.NUMERO.codigo);
    public static final CampoResultado ERITROGRAMA_CHCM = new CampoResultado(CAMPOS_GERAL.length + 5, "chcm", 20, CampoResultado.Tipo.NUMERO.codigo);
    public static final CampoResultado ERITROGRAMA_ALT_MORFO_TINTORIAIS = new CampoResultado(CAMPOS_GERAL.length + 6, "Alt.Morfo Tintoriais", 70, CampoResultado.Tipo.TEXTO.codigo);
    public static final CampoResultado[] CAMPOS_ERITROGRAMA = new CampoResultado[]{ERITROGRAMA_HEMACIAS, ERITROGRAMA_HEMOGLOBINA, ERITROGRAMA_HEMATOCRITO, ERITROGRAMA_VCM, ERITROGRAMA_HCM, ERITROGRAMA_CHCM, ERITROGRAMA_ALT_MORFO_TINTORIAIS};
    public static final CampoResultado LEUCOGRAMA_LEUCOCITOS_TOTAIS = new CampoResultado(CAMPOS_GERAL.length + 0, "Luc\u00f3citos Totais", 5, CampoResultado.Tipo.NUMERO.codigo);
    public static final CampoResultado LEUCOGRAMA_NEUTROFILOS = new CampoResultado(CAMPOS_GERAL.length + 1, "Neutr\u00f3filos", 5, CampoResultado.Tipo.NUMERO.codigo);
    public static final CampoResultado LEUCOGRAMA_METAMIELOCITOS = new CampoResultado(CAMPOS_GERAL.length + 2, "Metantel\u00f3citos", 5, CampoResultado.Tipo.NUMERO.codigo);
    public static final CampoResultado LEUCOGRAMA_BASTONETES = new CampoResultado(CAMPOS_GERAL.length + 3, "Bastonetes", 5, CampoResultado.Tipo.NUMERO.codigo);
    public static final CampoResultado LEUCOGRAMA_SEGMENTADOS = new CampoResultado(CAMPOS_GERAL.length + 4, "Segmentados", 5, CampoResultado.Tipo.NUMERO.codigo);
    public static final CampoResultado LEUCOGRAMA_EOSINOFILOS = new CampoResultado(CAMPOS_GERAL.length + 5, "Eosin\u00f3filos", 5, CampoResultado.Tipo.NUMERO.codigo);
    public static final CampoResultado LEUCOGRAMA_BASOFILOS = new CampoResultado(CAMPOS_GERAL.length + 6, "Bas\u00f3filos", 5, CampoResultado.Tipo.NUMERO.codigo);
    public static final CampoResultado LEUCOGRAMA_LINFOCITOS_TIPICOS = new CampoResultado(CAMPOS_GERAL.length + 7, "Linf\u00f3citos T\u00edpicos", 5, CampoResultado.Tipo.NUMERO.codigo);
    public static final CampoResultado LEUCOGRAMA_LINFOCITOS_ATIPICOS = new CampoResultado(CAMPOS_GERAL.length + 8, "Linf\u00f3citos At\u00edpicos", 5, CampoResultado.Tipo.NUMERO.codigo);
    public static final CampoResultado LEUCOGRAMA_MONOCITOS = new CampoResultado(CAMPOS_GERAL.length + 9, "Mon\u00f3citos", 5, CampoResultado.Tipo.NUMERO.codigo);
    public static final CampoResultado LEUCOGRAMA_ALT_MORFO_TINTORIAIS = new CampoResultado(CAMPOS_GERAL.length + 10, "Alt.Morfo Tintoriais", 70, CampoResultado.Tipo.TEXTO.codigo);
    public static final CampoResultado[] CAMPOS_LEUCOGRAMA = new CampoResultado[]{LEUCOGRAMA_LEUCOCITOS_TOTAIS, LEUCOGRAMA_NEUTROFILOS, LEUCOGRAMA_METAMIELOCITOS, LEUCOGRAMA_BASTONETES, LEUCOGRAMA_SEGMENTADOS, LEUCOGRAMA_EOSINOFILOS, LEUCOGRAMA_BASOFILOS, LEUCOGRAMA_LINFOCITOS_TIPICOS, LEUCOGRAMA_LINFOCITOS_ATIPICOS, LEUCOGRAMA_MONOCITOS, LEUCOGRAMA_ALT_MORFO_TINTORIAIS};
    public static final CampoResultado URINA_VOLUME = new CampoResultado(CAMPOS_GERAL.length + 0, "Volume", 20, CampoResultado.Tipo.NUMERO.codigo);
    public static final CampoResultado URINA_COR = new CampoResultado(CAMPOS_GERAL.length + 1, "Cor", 20, CampoResultado.Tipo.TEXTO.codigo);
    public static final CampoResultado URINA_ASPECTO = new CampoResultado(CAMPOS_GERAL.length + 2, "Aspecto", 20, CampoResultado.Tipo.TEXTO.codigo);
    public static final CampoResultado URINA_PH = new CampoResultado(CAMPOS_GERAL.length + 3, "PH", 5, CampoResultado.Tipo.NUMERO.codigo);
    public static final CampoResultado URINA_DENSIDADE = new CampoResultado(CAMPOS_GERAL.length + 4, "Densidade", 20, CampoResultado.Tipo.NUMERO.codigo);
    public static final CampoResultado URINA_REACAO = new CampoResultado(CAMPOS_GERAL.length + 5, "Rea\u00e7\u00e3o", 1, CampoResultado.Tipo.NUMERO.codigo);
    public static final CampoResultado URINA_DESC_REACAO = new CampoResultado(CAMPOS_GERAL.length + 6, "Desc. Da Rea\u00e7\u00e3o", 41, CampoResultado.Tipo.TEXTO.codigo);
    public static final CampoResultado URINA_PROTEINA = new CampoResultado(CAMPOS_GERAL.length + 7, "Proteina", 20, CampoResultado.Tipo.TEXTO.codigo);
    public static final CampoResultado URINA_GLICOSE = new CampoResultado(CAMPOS_GERAL.length + 8, "Glicose", 20, CampoResultado.Tipo.TEXTO.codigo);
    public static final CampoResultado URINA_C_CETONICOS = new CampoResultado(CAMPOS_GERAL.length + 9, "C.Cet\u00f4nicos", 20, CampoResultado.Tipo.TEXTO.codigo);
    public static final CampoResultado URINA_HEMOGLOBINA = new CampoResultado(CAMPOS_GERAL.length + 10, "Hemoglobina", 20, CampoResultado.Tipo.TEXTO.codigo);
    public static final CampoResultado URINA_BILIRRUBINA = new CampoResultado(CAMPOS_GERAL.length + 11, "Bilirrubina", 20, CampoResultado.Tipo.TEXTO.codigo);
    public static final CampoResultado URINA_UROBILINOGENIO = new CampoResultado(CAMPOS_GERAL.length + 12, "Urobilinogenio", 20, CampoResultado.Tipo.TEXTO.codigo);
    public static final CampoResultado URINA_LEUCOCITOS = new CampoResultado(CAMPOS_GERAL.length + 13, "Leuc\u00f3citos", 20, CampoResultado.Tipo.TEXTO.codigo);
    public static final CampoResultado URINA_HEMACIAS = new CampoResultado(CAMPOS_GERAL.length + 14, "Hem\u00e1cias", 20, CampoResultado.Tipo.TEXTO.codigo);
    public static final CampoResultado URINA_CELULAS = new CampoResultado(CAMPOS_GERAL.length + 15, "C\u00e9lulas", 20, CampoResultado.Tipo.TEXTO.codigo);
    public static final CampoResultado URINA_FILA_MUCO = new CampoResultado(CAMPOS_GERAL.length + 16, "Fila de Muco", 20, CampoResultado.Tipo.TEXTO.codigo);
    public static final CampoResultado URINA_CILINDROS = new CampoResultado(CAMPOS_GERAL.length + 17, "Cilindros", 20, CampoResultado.Tipo.TEXTO.codigo);
    public static final CampoResultado URINA_BACTERIAS = new CampoResultado(CAMPOS_GERAL.length + 18, "Bacterias", 20, CampoResultado.Tipo.TEXTO.codigo);
    public static final CampoResultado URINA_CRISTAIS = new CampoResultado(CAMPOS_GERAL.length + 19, "Cristais", 20, CampoResultado.Tipo.TEXTO.codigo);
    public static final CampoResultado URINA_LEVEDURAS = new CampoResultado(CAMPOS_GERAL.length + 20, "Leveduras", 20, CampoResultado.Tipo.TEXTO.codigo);
    public static final CampoResultado URINA_DISMORF_ERITROCITARIO = new CampoResultado(CAMPOS_GERAL.length + 21, "Dismof.Eritrocitario", 20, CampoResultado.Tipo.TEXTO.codigo);
    public static final CampoResultado URINA_FLORA_BACTERIANA = new CampoResultado(CAMPOS_GERAL.length + 22, "Flora bacteriana", 20, CampoResultado.Tipo.TEXTO.codigo);
    public static final CampoResultado URINA_PROTOZOARIOS = new CampoResultado(CAMPOS_GERAL.length + 23, "Protozoarios", 20, CampoResultado.Tipo.TEXTO.codigo);
    public static final CampoResultado URINA_OUTROS = new CampoResultado(CAMPOS_GERAL.length + 24, "Outros", 70, CampoResultado.Tipo.TEXTO.codigo);
    public static final CampoResultado[] CAMPOS_URINA = new CampoResultado[]{URINA_VOLUME, URINA_COR, URINA_ASPECTO, URINA_PH, URINA_DENSIDADE, URINA_REACAO, URINA_DESC_REACAO, URINA_PROTEINA, URINA_GLICOSE, URINA_C_CETONICOS, URINA_HEMOGLOBINA, URINA_BILIRRUBINA, URINA_UROBILINOGENIO, URINA_LEUCOCITOS, URINA_HEMACIAS, URINA_CELULAS, URINA_FILA_MUCO, URINA_CILINDROS, URINA_BACTERIAS, URINA_CRISTAIS, URINA_LEVEDURAS, URINA_DISMORF_ERITROCITARIO, URINA_FLORA_BACTERIANA, URINA_PROTOZOARIOS, URINA_OUTROS};
    public static final CampoResultado PNEUMOLOGIA_CVF_MEDIDO = new CampoResultado(CAMPOS_GERAL.length + 0, "CVF - Medido", 20, CampoResultado.Tipo.NUMERO.codigo);
    public static final CampoResultado PNEUMOLOGIA_CVF_PREVISTO = new CampoResultado(CAMPOS_GERAL.length + 1, "CVF - Previsto", 20, CampoResultado.Tipo.NUMERO.codigo);
    public static final CampoResultado PNEUMOLOGIA_CVF_PERC_PREVISTO = new CampoResultado(CAMPOS_GERAL.length + 2, "CVF - % do Previsto", 20, CampoResultado.Tipo.NUMERO.codigo);
    public static final CampoResultado PNEUMOLOGIA_CVF_POS_BD = new CampoResultado(CAMPOS_GERAL.length + 3, "CVF - p\u00f3s BD", 20, CampoResultado.Tipo.NUMERO.codigo);
    public static final CampoResultado PNEUMOLOGIA_CVF_PERC_MELHORIA = new CampoResultado(CAMPOS_GERAL.length + 4, "CVF - % de Melhoria", 20, CampoResultado.Tipo.NUMERO.codigo);
    public static final CampoResultado PNEUMOLOGIA_VEF1_MEDIDO = new CampoResultado(CAMPOS_GERAL.length + 5, "VEF1 - Medido", 20, CampoResultado.Tipo.NUMERO.codigo);
    public static final CampoResultado PNEUMOLOGIA_VEF1_PREVISTO = new CampoResultado(CAMPOS_GERAL.length + 6, "VEF1 - Previsto", 20, CampoResultado.Tipo.NUMERO.codigo);
    public static final CampoResultado PNEUMOLOGIA_VEF1_PERC_PREVISTO = new CampoResultado(CAMPOS_GERAL.length + 7, "VEF1 - % do Previsto", 20, CampoResultado.Tipo.NUMERO.codigo);
    public static final CampoResultado PNEUMOLOGIA_VEF1_POS_BD = new CampoResultado(CAMPOS_GERAL.length + 8, "VEF1 - p\u00f3s BD", 20, CampoResultado.Tipo.NUMERO.codigo);
    public static final CampoResultado PNEUMOLOGIA_VEF1_PERC_MELHORIA = new CampoResultado(CAMPOS_GERAL.length + 9, "VEF1 - % de Melhoria", 20, CampoResultado.Tipo.NUMERO.codigo);
    public static final CampoResultado PNEUMOLOGIA_PFE_MEDIDO = new CampoResultado(CAMPOS_GERAL.length + 10, "PFE - Medido", 20, CampoResultado.Tipo.NUMERO.codigo);
    public static final CampoResultado PNEUMOLOGIA_PFE_PREVISTO = new CampoResultado(CAMPOS_GERAL.length + 11, "PFE - Previsto", 20, CampoResultado.Tipo.NUMERO.codigo);
    public static final CampoResultado PNEUMOLOGIA_PFE_PERC_PREVISTO = new CampoResultado(CAMPOS_GERAL.length + 12, "PFE - % do Previsto", 20, CampoResultado.Tipo.NUMERO.codigo);
    public static final CampoResultado PNEUMOLOGIA_PFE_POS_BD = new CampoResultado(CAMPOS_GERAL.length + 13, "PFE - p\u00f3s BD", 20, CampoResultado.Tipo.NUMERO.codigo);
    public static final CampoResultado PNEUMOLOGIA_PFE_PERC_MELHORIA = new CampoResultado(CAMPOS_GERAL.length + 14, "PFE - % de Melhoria", 20, CampoResultado.Tipo.NUMERO.codigo);
    public static final CampoResultado PNEUMOLOGIA_VEF1_CVF_MEDIDO = new CampoResultado(CAMPOS_GERAL.length + 15, "VEF1/CVF - Medido", 20, CampoResultado.Tipo.NUMERO.codigo);
    public static final CampoResultado PNEUMOLOGIA_VEF1_CVF_POS_BD = new CampoResultado(CAMPOS_GERAL.length + 16, "VEF1/CVF - p\u00f3s BD", 20, CampoResultado.Tipo.NUMERO.codigo);
    public static final CampoResultado[] CAMPOS_PNEUMOLOGIA = new CampoResultado[]{PNEUMOLOGIA_CVF_MEDIDO, PNEUMOLOGIA_CVF_PREVISTO, PNEUMOLOGIA_CVF_PERC_PREVISTO, PNEUMOLOGIA_CVF_POS_BD, PNEUMOLOGIA_CVF_PERC_MELHORIA, PNEUMOLOGIA_VEF1_MEDIDO, PNEUMOLOGIA_VEF1_PREVISTO, PNEUMOLOGIA_VEF1_PERC_PREVISTO, PNEUMOLOGIA_VEF1_POS_BD, PNEUMOLOGIA_VEF1_PERC_MELHORIA, PNEUMOLOGIA_PFE_MEDIDO, PNEUMOLOGIA_PFE_PREVISTO, PNEUMOLOGIA_PFE_PERC_PREVISTO, PNEUMOLOGIA_PFE_POS_BD, PNEUMOLOGIA_PFE_PERC_MELHORIA, PNEUMOLOGIA_VEF1_CVF_MEDIDO, PNEUMOLOGIA_VEF1_CVF_POS_BD};
    public static final String EXPORTAR_SOC = "exportar";
    public static int TAM_MAX = CAMPOS_GERAL.length + CAMPOS_AUDIOMETRIA.length;
    private final int COLUNA_ORIGEM = 0;
    private final int COLUNA_SOC = 1;
    private JComboBox comboExame = ComponenteFactory.novoJComboBox(new Dimension(70, 20));
    private JLabel labelExame = ComponenteFactory.novoJLabel("Exame", 'E', null, this.comboExame);
    private JComboBox comboOrigem = ComponenteFactory.novoJComboBox(new Dimension(70, 20));
    private JComboBox comboDestino = ComponenteFactory.novoJComboBox(new Dimension(90, 20));
    private JLabel labelOrigem = ComponenteFactory.novoJLabel("Campos", 'a', null, this.comboOrigem);
    private JButton buttonOKCampo = ComponenteFactory.novoJButton("OK", '\u0000', this, null, new Dimension(40, 20));
    private JButton buttonOutroCampo = ComponenteFactory.novoJButton("...", '\u0000', this, null, new Dimension(40, 20));
    private ModeloGridTable modelo = new ModeloGridTable(new String[]{"Origem", "Campo SOC"});
    private JTable table = new JTable(this.modelo);
    private JScrollPane scroll = new JScrollPane(this.table);
    private int editandoLinha = -1;
    private String valorOutroCampo = "";

    public static ConfiguradorExportacaoSoc novaInstancia(Object pai) {
        if (pai instanceof Dialog) {
            return new ConfiguradorExportacaoSoc((Dialog)pai, "Resultado - Sistema SOC");
        }
        return new ConfiguradorExportacaoSoc((Frame)pai, "Resultado - Sistema SOC");
    }

    public ConfiguradorExportacaoSoc(Dialog pai, String titulo) {
        super(pai, titulo);
        this.montaTela();
    }

    public ConfiguradorExportacaoSoc(Frame pai, String titulo) {
        super(pai, titulo);
        this.montaTela();
    }

    public void setCampos(String[] campos) {
        if (campos != null) {
            this.comboOrigem.removeAllItems();
            for (String s : campos) {
                this.comboOrigem.addItem(s);
            }
        }
    }

    private void montaTela() {
        this.setSize(new Dimension(400, 400));
        this.setResizable(false);
        this.setModal(true);
        this.comboExame.addItem(TipoExame.GERAL);
        this.comboExame.addItem(TipoExame.AUDIOMETRIA);
        this.comboExame.addItem(TipoExame.HEMOGRAMA);
        this.comboExame.addItem(TipoExame.ERITROGRAMA);
        this.comboExame.addItem(TipoExame.LEUCOGRAMA);
        this.comboExame.addItem(TipoExame.URINA);
        this.comboExame.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                block6: {
                    block11: {
                        block10: {
                            block9: {
                                block8: {
                                    block7: {
                                        if (e.getStateChange() != 1) break block6;
                                        ConfiguradorExportacaoSoc.this.valorOutroCampo = "";
                                        ConfiguradorExportacaoSoc.this.comboDestino.removeAllItems();
                                        if (ConfiguradorExportacaoSoc.this.comboExame.getSelectedItem() != TipoExame.GERAL) break block7;
                                        for (int i = 0; i < CAMPOS_GERAL.length; ++i) {
                                            ConfiguradorExportacaoSoc.this.comboDestino.addItem(CAMPOS_GERAL[i]);
                                        }
                                        break block6;
                                    }
                                    if (ConfiguradorExportacaoSoc.this.comboExame.getSelectedItem() != TipoExame.AUDIOMETRIA) break block8;
                                    for (int i = 0; i < CAMPOS_AUDIOMETRIA.length; ++i) {
                                        ConfiguradorExportacaoSoc.this.comboDestino.addItem(CAMPOS_AUDIOMETRIA[i]);
                                    }
                                    break block6;
                                }
                                if (ConfiguradorExportacaoSoc.this.comboExame.getSelectedItem() != TipoExame.HEMOGRAMA) break block9;
                                for (int i = 0; i < CAMPOS_HEMOGRAMA.length; ++i) {
                                    ConfiguradorExportacaoSoc.this.comboDestino.addItem(CAMPOS_HEMOGRAMA[i]);
                                }
                                break block6;
                            }
                            if (ConfiguradorExportacaoSoc.this.comboExame.getSelectedItem() != TipoExame.ERITROGRAMA) break block10;
                            for (int i = 0; i < CAMPOS_ERITROGRAMA.length; ++i) {
                                ConfiguradorExportacaoSoc.this.comboDestino.addItem(CAMPOS_ERITROGRAMA[i]);
                            }
                            break block6;
                        }
                        if (ConfiguradorExportacaoSoc.this.comboExame.getSelectedItem() != TipoExame.LEUCOGRAMA) break block11;
                        for (int i = 0; i < CAMPOS_LEUCOGRAMA.length; ++i) {
                            ConfiguradorExportacaoSoc.this.comboDestino.addItem(CAMPOS_LEUCOGRAMA[i]);
                        }
                        break block6;
                    }
                    if (ConfiguradorExportacaoSoc.this.comboExame.getSelectedItem() != TipoExame.URINA) break block6;
                    for (int i = 0; i < CAMPOS_URINA.length; ++i) {
                        ConfiguradorExportacaoSoc.this.comboDestino.addItem(CAMPOS_URINA[i]);
                    }
                }
            }
        });
        this.comboExame.setSelectedIndex(-1);
        this.comboDestino.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ConfiguradorExportacaoSoc.this.valorOutroCampo = "";
                    if (ConfiguradorExportacaoSoc.this.comboDestino.getSelectedIndex() > -1 && ConfiguradorExportacaoSoc.this.comboDestino.getSelectedItem() instanceof CampoResultado) {
                        CampoResultado c = (CampoResultado)ConfiguradorExportacaoSoc.this.comboDestino.getSelectedItem();
                        ConfiguradorExportacaoSoc.this.buttonOutroCampo.setVisible(c.permitirValorTexto);
                    }
                }
            }
        });
        this.comboExame.setSelectedIndex(-1);
        JPanel panel = this.getPanelCentral();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 1.0;
        c.gridwidth = 4;
        panel.add((Component)this.labelExame, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 4;
        this.comboExame.setMinimumSize(new Dimension(70, 20));
        panel.add((Component)this.comboExame, c);
        c.gridx = 0;
        ++c.gridy;
        c.fill = 2;
        c.weightx = 1.0;
        c.gridwidth = 4;
        panel.add((Component)this.labelOrigem, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        this.comboOrigem.setMinimumSize(new Dimension(70, 20));
        panel.add((Component)this.comboOrigem, c);
        c.gridx = 1;
        this.comboDestino.setMinimumSize(new Dimension(90, 20));
        panel.add((Component)this.comboDestino, c);
        c.gridx = 2;
        c.fill = 0;
        c.weightx = 0.0;
        this.buttonOutroCampo.setMinimumSize(new Dimension(20, 20));
        this.buttonOutroCampo.setMaximumSize(new Dimension(20, 20));
        panel.add((Component)this.buttonOutroCampo, c);
        c.gridx = 3;
        c.fill = 0;
        c.weightx = 0.0;
        this.buttonOKCampo.setMinimumSize(new Dimension(40, 20));
        this.buttonOKCampo.setMaximumSize(new Dimension(40, 20));
        panel.add((Component)this.buttonOKCampo, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 4;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        panel.add((Component)this.scroll, c);
        this.buttonOutroCampo.setVisible(false);
        this.table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127 && ConfiguradorExportacaoSoc.this.table.getSelectedRow() > -1 && Funcoes.mensagem(ConfiguradorExportacaoSoc.this, "Deseja excluir o registro selecionado?", 4) == 0) {
                    ConfiguradorExportacaoSoc.this.modelo.removeLine(ConfiguradorExportacaoSoc.this.table.getSelectedRow());
                } else if (e.getKeyCode() == 32 && ConfiguradorExportacaoSoc.this.table.getSelectedRow() > -1) {
                    ConfiguradorExportacaoSoc.this.editandoLinha = ConfiguradorExportacaoSoc.this.table.getSelectedRow();
                    if (ConfiguradorExportacaoSoc.this.modelo.getValueAt(ConfiguradorExportacaoSoc.this.editandoLinha, 0).toString().indexOf("\"") > -1) {
                        ConfiguradorExportacaoSoc.this.editandoLinha = -1;
                        return;
                    }
                    ConfiguradorExportacaoSoc.this.comboOrigem.setSelectedItem(ConfiguradorExportacaoSoc.this.modelo.getValueAt(ConfiguradorExportacaoSoc.this.editandoLinha, 0).toString());
                    ConfiguradorExportacaoSoc.this.comboDestino.setSelectedItem(ConfiguradorExportacaoSoc.this.modelo.getValueAt(ConfiguradorExportacaoSoc.this.editandoLinha, 1).toString());
                    ScreenUtil.requisitarFoco(ConfiguradorExportacaoSoc.this.comboOrigem);
                }
                ConfiguradorExportacaoSoc.this.bloqueiaExame();
            }
        });
        ScreenUtil.requisitarFoco(this.comboOrigem);
        this.bloqueiaExame();
    }

    public static List<CampoResultado> getListaRelacionamentoCampos(String xml) {
        ArrayList<CampoResultado> lista = new ArrayList<CampoResultado>();
        if (xml != null && !Funcoes.textoVazio(StringUtil.getValor(xml, EXPORTAR_SOC))) {
            String[] campos = StringUtil.getValores(xml, "campo");
            TipoExame aux = null;
            for (String s : campos) {
                int i;
                String origem = StringUtil.getValor(s, "origem");
                String soc = StringUtil.getValor(s, "soc");
                CampoResultado campo = null;
                for (i = 0; i < CAMPOS_GERAL.length; ++i) {
                    if (!CAMPOS_GERAL[i].toString().equalsIgnoreCase(soc)) continue;
                    campo = CAMPOS_GERAL[i];
                    break;
                }
                for (i = 0; i < CAMPOS_AUDIOMETRIA.length && (aux == null || aux == TipoExame.AUDIOMETRIA); ++i) {
                    if (!CAMPOS_AUDIOMETRIA[i].toString().equalsIgnoreCase(soc)) continue;
                    aux = TipoExame.AUDIOMETRIA;
                    campo = CAMPOS_AUDIOMETRIA[i];
                    break;
                }
                for (i = 0; i < CAMPOS_HEMOGRAMA.length && (aux == null || aux == TipoExame.HEMOGRAMA); ++i) {
                    if (!CAMPOS_HEMOGRAMA[i].toString().equalsIgnoreCase(soc)) continue;
                    aux = TipoExame.HEMOGRAMA;
                    campo = CAMPOS_HEMOGRAMA[i];
                    break;
                }
                for (i = 0; i < CAMPOS_ERITROGRAMA.length && (aux == null || aux == TipoExame.ERITROGRAMA); ++i) {
                    if (!CAMPOS_ERITROGRAMA[i].toString().equalsIgnoreCase(soc)) continue;
                    aux = TipoExame.ERITROGRAMA;
                    campo = CAMPOS_ERITROGRAMA[i];
                    break;
                }
                for (i = 0; i < CAMPOS_LEUCOGRAMA.length && (aux == null || aux == TipoExame.LEUCOGRAMA); ++i) {
                    if (!CAMPOS_LEUCOGRAMA[i].toString().equalsIgnoreCase(soc)) continue;
                    aux = TipoExame.LEUCOGRAMA;
                    campo = CAMPOS_LEUCOGRAMA[i];
                    break;
                }
                for (i = 0; i < CAMPOS_URINA.length && (aux == null || aux == TipoExame.URINA); ++i) {
                    if (!CAMPOS_URINA[i].toString().equalsIgnoreCase(soc)) continue;
                    aux = TipoExame.URINA;
                    campo = CAMPOS_URINA[i];
                    break;
                }
                if (campo == null) continue;
                CampoResultado campoTmp = new CampoResultado(origem, campo.posicao, campo.descricao);
                lista.add(campoTmp);
            }
        }
        Collections.sort(lista, new Comparator(){

            public int compare(Object o1, Object o2) {
                String ori1 = ((CampoResultado)o1).origem;
                String ori2 = ((CampoResultado)o2).origem;
                return ori1.compareTo(ori2);
            }
        });
        return lista;
    }

    public static Hashtable<String, CampoResultado> getRelacionamentoCampos(String xml) {
        Hashtable<String, CampoResultado> hash = new Hashtable<String, CampoResultado>();
        List<CampoResultado> lista = ConfiguradorExportacaoSoc.getListaRelacionamentoCampos(xml);
        for (CampoResultado c : lista) {
            hash.put(c.origem.trim().toLowerCase(), c);
        }
        return hash;
    }

    @Override
    public String getXml() {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.modelo.getRowCount(); ++i) {
            buf.append("<campo>");
            buf.append(StringUtil.getTag("origem", this.modelo.getValueAt(i, 0).toString()));
            buf.append(StringUtil.getTag("soc", this.modelo.getValueAt(i, 1).toString()));
            buf.append("</campo>");
        }
        return StringUtil.getTag(EXPORTAR_SOC, buf.toString());
    }

    @Override
    public void setXml(String xml) {
        if (xml != null) {
            List<CampoResultado> campos = ConfiguradorExportacaoSoc.getListaRelacionamentoCampos(xml);
            this.modelo.clear();
            for (CampoResultado campo : campos) {
                this.modelo.addLine(new Object[]{campo.origem, campo});
            }
        }
        this.bloqueiaExame();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonOKCampo) {
            this.adicionar();
        } else if (e.getSource() == this.buttonOutroCampo) {
            String valor = JOptionPane.showInputDialog("Informe o valor a ser utilizado");
            if (valor != null && !this.valorOutroCampo.equals(valor)) {
                this.valorOutroCampo = valor;
            }
        } else {
            super.actionPerformed(e);
        }
    }

    private void adicionar() {
        if (this.editandoLinha > -1) {
            this.modelo.setValueAt(this.comboOrigem.getSelectedItem().toString(), this.editandoLinha, 0);
            this.modelo.setValueAt(this.comboDestino.getSelectedItem(), this.editandoLinha, 1);
            this.editandoLinha = -1;
        } else {
            String valorPesquisa = !Funcoes.textoVazio(this.valorOutroCampo) ? "\"" + this.valorOutroCampo + "\"" : this.comboOrigem.getSelectedItem().toString();
            int pos = this.modelo.localizar(0, valorPesquisa);
            if (pos < 0) {
                this.modelo.addLine(new Object[]{valorPesquisa, this.comboDestino.getSelectedItem()});
            } else {
                this.modelo.setValueAt(this.comboDestino.getSelectedItem(), pos, 1);
            }
        }
        this.bloqueiaExame();
        this.valorOutroCampo = "";
        this.comboDestino.setSelectedIndex(-1);
        ScreenUtil.requisitarFoco(this.comboOrigem);
    }

    private void bloqueiaExame() {
        if (this.modelo.getRowCount() > 0) {
            int i;
            CampoResultado aux = null;
            for (i = 0; i < this.modelo.getRowCount(); ++i) {
                aux = (CampoResultado)this.modelo.getValueAt(0, 1);
                for (int j = 0; j < CAMPOS_GERAL.length; ++j) {
                    if (!aux.posicao.equals(ConfiguradorExportacaoSoc.CAMPOS_GERAL[j].posicao)) continue;
                    aux = null;
                    break;
                }
                if (aux != null) break;
            }
            if (aux != null) {
                this.comboExame.removeAllItems();
                this.comboExame.addItem(TipoExame.GERAL);
                for (i = 0; i < CAMPOS_AUDIOMETRIA.length; ++i) {
                    if (!CAMPOS_AUDIOMETRIA[i].toString().equalsIgnoreCase(aux.toString())) continue;
                    this.comboExame.addItem(TipoExame.AUDIOMETRIA);
                    this.comboExame.setSelectedItem((Object)TipoExame.AUDIOMETRIA);
                }
                for (i = 0; i < CAMPOS_HEMOGRAMA.length; ++i) {
                    if (!CAMPOS_HEMOGRAMA[i].toString().equalsIgnoreCase(aux.toString())) continue;
                    this.comboExame.addItem(TipoExame.HEMOGRAMA);
                    this.comboExame.setSelectedItem((Object)TipoExame.HEMOGRAMA);
                }
                for (i = 0; i < CAMPOS_ERITROGRAMA.length; ++i) {
                    if (!CAMPOS_ERITROGRAMA[i].toString().equalsIgnoreCase(aux.toString())) continue;
                    this.comboExame.addItem(TipoExame.ERITROGRAMA);
                    this.comboExame.setSelectedItem((Object)TipoExame.ERITROGRAMA);
                }
                for (i = 0; i < CAMPOS_LEUCOGRAMA.length; ++i) {
                    if (!CAMPOS_LEUCOGRAMA[i].toString().equalsIgnoreCase(aux.toString())) continue;
                    this.comboExame.addItem(TipoExame.LEUCOGRAMA);
                    this.comboExame.setSelectedItem((Object)TipoExame.LEUCOGRAMA);
                }
                for (i = 0; i < CAMPOS_URINA.length; ++i) {
                    if (!CAMPOS_URINA[i].toString().equalsIgnoreCase(aux.toString())) continue;
                    this.comboExame.addItem(TipoExame.URINA);
                    this.comboExame.setSelectedItem((Object)TipoExame.URINA);
                }
            }
        } else {
            this.comboExame.removeAllItems();
            this.comboExame.addItem(TipoExame.GERAL);
            this.comboExame.addItem(TipoExame.AUDIOMETRIA);
            this.comboExame.addItem(TipoExame.HEMOGRAMA);
            this.comboExame.addItem(TipoExame.ERITROGRAMA);
            this.comboExame.addItem(TipoExame.LEUCOGRAMA);
            this.comboExame.addItem(TipoExame.URINA);
        }
    }

    public static enum TipoExame {
        GERAL(0, "Geral"),
        AUDIOMETRIA(1, "Audiometria"),
        HEMOGRAMA(2, "Hemograma Completo"),
        ERITROGRAMA(3, "Eritrograma"),
        LEUCOGRAMA(4, "Leucograma"),
        URINA(5, "Rotina de Urina");

        int codigo = -1;
        String descricao = "";

        private TipoExame(int codigo, String descricao) {
            this.codigo = codigo;
            this.descricao = descricao;
        }

        public String toString() {
            return this.descricao;
        }
    }
}

