/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao;

import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.cadastro.ExameMatCol;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.SteppedComboBox;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class ConfiguradorExportacaoSisLabo
extends AbstractDialogoOKCancelar
implements ActionListener {
    public static final String TAG_SISLABO = "exportarsislabo";
    private static final String tituloJanela = "Configurando SIS-LABO";
    private final int COLUNA_CAMPO = 0;
    private final int COLUNA_EXAME = 1;
    private String[] rotuloColuna = new String[]{"Campo", "Exame"};
    private int[] tamanhoColuna = new int[]{275, 0};
    private int editandoLinha = -1;
    private SteppedComboBox comboCampos = new SteppedComboBox();
    private JButton buttonLaudoExame = ComponenteFactory.novoJButton("", this, null, new Dimension(20, 20));
    private JLabel labelCampos = ComponenteFactory.novoJLabel("Campos", 'm', null, this.comboCampos);
    private TTextField textExame = new TTextField(0, 1);
    private JLabel labelExame = ComponenteFactory.novoJLabel("Exame", 'x', null, this.textExame);
    private JButton buttonCampoOK = ComponenteFactory.novoJButton("OK", '\u0000', this, null, new Dimension(40, 20));
    private ModeloGridTable modelo = new ModeloGridTable(this.rotuloColuna);
    private JTable table = new JTable(this.modelo);
    private JScrollPane scroll = new JScrollPane(this.table);
    private ExameMatCol exameMatColeta = null;
    private String[] camposLaudo = null;

    public static ConfiguradorExportacaoSisLabo novaInstancia(Object pai) {
        if (pai instanceof Dialog) {
            return new ConfiguradorExportacaoSisLabo((Dialog)pai, tituloJanela);
        }
        return new ConfiguradorExportacaoSisLabo((Frame)pai, tituloJanela);
    }

    public ConfiguradorExportacaoSisLabo(Dialog pai, String titulo) {
        super(pai, titulo);
        this.montaTela();
    }

    public ConfiguradorExportacaoSisLabo(Frame pai, String titulo) {
        super(pai, titulo);
        this.montaTela();
    }

    public void montaTela() {
        this.setSize(new Dimension(445, 215));
        this.setResizable(false);
        this.setModal(true);
        this.setLocationRelativeTo(this.getOwner());
        JPanel panelCentral = this.getPanelCentral();
        panelCentral.setLayout(new GridBagLayout());
        this.labelCampos.setMinimumSize(new Dimension(275, 20));
        this.comboCampos.setPreferredSize(new Dimension(275, 20));
        this.comboCampos.setMinimumSize(this.comboCampos.getPreferredSize());
        this.buttonLaudoExame.setPreferredSize(new Dimension(20, 20));
        this.buttonLaudoExame.setMinimumSize(new Dimension(20, 20));
        Funcoes.imagemPesquisa(this.buttonLaudoExame);
        this.textExame.setPreferredSize(new Dimension(100, 20));
        this.textExame.setMinimumSize(this.textExame.getPreferredSize());
        this.buttonCampoOK.setPreferredSize(new Dimension(40, 20));
        this.buttonCampoOK.setMinimumSize(this.buttonCampoOK.getPreferredSize());
        this.buttonCampoOK.setMaximumSize(this.buttonCampoOK.getPreferredSize());
        this.modelo.setColumnSize(this.tamanhoColuna, this.table);
        this.table.setSelectionMode(0);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (ConfiguradorExportacaoSisLabo.this.table.getSelectedRow() >= 0) {
                    if (e.getKeyCode() == 32) {
                        ConfiguradorExportacaoSisLabo.this.editarRegistro();
                    }
                    if (e.getKeyCode() == 127 && Funcoes.mensagem(ConfiguradorExportacaoSisLabo.this, "Deseja excluir o registro selecionado?", 4) == 0) {
                        ConfiguradorExportacaoSisLabo.this.modelo.removeLine(ConfiguradorExportacaoSisLabo.this.table.getSelectedRow());
                    }
                }
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (ConfiguradorExportacaoSisLabo.this.table.getSelectedRow() >= 0 && e.getClickCount() == 2) {
                    ConfiguradorExportacaoSisLabo.this.editarRegistro();
                }
            }
        });
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(0, 0, 1, 1);
        c.fill = 17;
        c.anchor = 17;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        panelCentral.add((Component)this.labelCampos, c);
        c.gridx = 2;
        c.gridwidth = 2;
        panelCentral.add((Component)this.labelExame, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        panelCentral.add((Component)this.comboCampos, c);
        ++c.gridx;
        panelCentral.add((Component)this.buttonLaudoExame, c);
        ++c.gridx;
        panelCentral.add((Component)this.textExame, c);
        c.insets = new Insets(0, 0, 0, 0);
        ++c.gridx;
        panelCentral.add((Component)this.buttonCampoOK, c);
        c.fill = 1;
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 4;
        c.weighty = 1.0;
        c.weightx = 1.0;
        panelCentral.add((Component)this.scroll, c);
        ScreenUtil.requisitarFoco(this.comboCampos);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonCampoOK) {
            this.adicionarRegistro();
        } else if (e.getSource() == this.buttonOK) {
            super.actionPerformed(e);
        } else if (e.getSource() == this.buttonLaudoExame) {
            this.configuraCampoLaudo();
        } else {
            super.actionPerformed(e);
        }
    }

    private void configuraCampoLaudo() {
        String propriedadeCampoNomeUnidade = this.exameMatColeta.configuraAssociaCamposDeResultado();
        for (String campo : this.camposLaudo) {
            if (!campo.equalsIgnoreCase(propriedadeCampoNomeUnidade)) continue;
            this.comboCampos.setSelectedItem(campo);
        }
    }

    private void adicionarRegistro() {
        if (this.textExame.getText().isEmpty()) {
            ScreenUtil.requisitarFoco(this.textExame);
            return;
        }
        if (this.editandoLinha > -1) {
            this.modelo.setValueAt(this.textExame.getText(), this.editandoLinha, 1);
            this.modelo.setValueAt(this.comboCampos.getSelectedItem().toString(), this.editandoLinha, 0);
            this.editandoLinha = -1;
        } else if (this.modelo.localizar(0, this.comboCampos.getSelectedItem().toString()) < 0) {
            this.modelo.addLine(new Object[]{this.comboCampos.getSelectedItem().toString(), this.textExame.getText(), new ArrayList()});
        }
        this.textExame.clear();
        ScreenUtil.requisitarFoco(this.comboCampos);
    }

    private void editarRegistro() {
        this.editandoLinha = this.table.getSelectedRow();
        this.textExame.setText(this.modelo.getValueAt(this.editandoLinha, 1).toString());
        this.comboCampos.setSelectedItem(this.modelo.getValueAt(this.editandoLinha, 0).toString());
        ScreenUtil.requisitarFoco(this.textExame);
    }

    public String getXml() {
        StringBuilder buffer = new StringBuilder();
        for (int linha = 0; linha < this.modelo.getRowCount(); ++linha) {
            buffer.append("<campo>");
            buffer.append(StringUtil.getTag("nome", this.modelo.getValueAt(linha, 0).toString()));
            buffer.append(StringUtil.getTag("valor", this.modelo.getValueAt(linha, 1).toString()));
            buffer.append("</campo>");
        }
        if (!buffer.toString().isEmpty()) {
            buffer = new StringBuilder(StringUtil.getTag(TAG_SISLABO, buffer.toString()));
        }
        return buffer.toString();
    }

    public void setXml(String xml) {
        if (!Funcoes.objectIsNull(xml)) {
            this.modelo.clear();
            if (!Funcoes.textoVazio(StringUtil.getValor(xml, TAG_SISLABO))) {
                String[] campos;
                for (String s : campos = StringUtil.getValores(StringUtil.getValor(xml, TAG_SISLABO), "campo")) {
                    String nome = StringUtil.getValor(s, "nome");
                    String valor = StringUtil.getValor(s, "valor");
                    this.modelo.addLine(new Object[]{nome, valor});
                }
            }
        }
    }

    public void setCampos(String[] campos) {
        if (campos != null) {
            this.camposLaudo = campos;
            this.comboCampos.removeAllItems();
            for (String s : campos) {
                this.comboCampos.addItem(s);
            }
        }
    }

    public ExameMatCol getExameMatColeta() {
        return this.exameMatColeta;
    }

    public void setExameMatColeta(ExameMatCol exameMatColeta) {
        this.exameMatColeta = exameMatColeta;
    }
}

