/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao;

import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.exportacao.CampoResultado;
import jalis.laboratorio.exportacao.FabricaConfiguradorExportacaoResultado;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class ConfiguradorExportacaoJalis
extends AbstractDialogoOKCancelar
implements FabricaConfiguradorExportacaoResultado,
ActionListener {
    public static final String EXPORTAR_JALIS = "exportarJalis";
    private final int COLUNA_ORIGEM = 0;
    private final int COLUNA_DESTINO = 1;
    private final int COLUNA_SEQRESULTADO = 2;
    private final int COLUNA_DESCRESULTADO = 3;
    private JComboBox comboOrigem = ComponenteFactory.novoJComboBox(new Dimension(70, 20));
    private JComboBox comboDestino = ComponenteFactory.novoJComboBox(new Dimension(90, 20));
    private TTextField textSequencialResultado = new TTextField(9, 1);
    private TTextField textDescricaoResultado = new TTextField(100, 3);
    private JLabel labelOrigem = ComponenteFactory.novoJLabel("Campos", 'a', null, this.comboOrigem);
    private JButton buttonOKCampo = ComponenteFactory.novoJButton("OK", '\u0000', this, null, new Dimension(40, 20));
    private JButton buttonOutroCampo = ComponenteFactory.novoJButton("...", '\u0000', this, null, new Dimension(40, 20));
    private ModeloGridTable modelo = new ModeloGridTable(new String[]{"Origem", "Campo Destino", "Sequ\u00eancia", "Descri\u00e7\u00e3o"});
    private JTable table = new JTable(this.modelo);
    private JScrollPane scroll = new JScrollPane(this.table);
    private int editandoLinha = -1;
    private boolean validarSequencia = true;
    private String valorOutroCampo = "";

    public static ConfiguradorExportacaoJalis novaInstancia(Object pai) {
        if (pai instanceof Dialog) {
            return new ConfiguradorExportacaoJalis((Dialog)pai, "Resultado - Sistema JALIS");
        }
        return new ConfiguradorExportacaoJalis((Frame)pai, "Resultado - Sistema JALIS");
    }

    public ConfiguradorExportacaoJalis(Dialog pai, String titulo) {
        super(pai, titulo);
        this.montaTela();
    }

    public ConfiguradorExportacaoJalis(Frame pai, String titulo) {
        super(pai, titulo);
        this.montaTela();
    }

    public void setCampos(String[] campos) {
        if (campos != null) {
            this.comboOrigem.removeAllItems();
            for (String s : campos) {
                this.comboOrigem.addItem(s);
            }
        }
    }

    private void montaTela() {
        this.setSize(new Dimension(430, 430));
        this.setResizable(false);
        this.setModal(true);
        this.comboDestino.addItem(TipoExame.RESULTADO);
        this.comboDestino.addItem(TipoExame.LD);
        this.comboDestino.addItem(TipoExame.VMP);
        this.comboDestino.addItem(TipoExame.UNIDADE);
        this.comboDestino.addItem(TipoExame.METODOLOGIA);
        this.comboDestino.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ConfiguradorExportacaoJalis.this.valorOutroCampo = "";
                    if (ConfiguradorExportacaoJalis.this.comboDestino.getSelectedIndex() > -1 && ConfiguradorExportacaoJalis.this.comboDestino.getSelectedItem() instanceof CampoResultado) {
                        CampoResultado c = (CampoResultado)ConfiguradorExportacaoJalis.this.comboDestino.getSelectedItem();
                        ConfiguradorExportacaoJalis.this.buttonOutroCampo.setVisible(c.permitirValorTexto);
                    }
                }
            }
        });
        JPanel panel = this.getPanelCentral();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 1.0;
        c.gridwidth = 4;
        panel.add((Component)this.labelOrigem, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        this.comboOrigem.setMinimumSize(new Dimension(70, 20));
        panel.add((Component)this.comboOrigem, c);
        c.gridx = 1;
        this.comboDestino.setMinimumSize(new Dimension(90, 20));
        panel.add((Component)this.comboDestino, c);
        c.gridx = 2;
        this.textSequencialResultado.setMinimumSize(new Dimension(10, 20));
        panel.add((Component)this.textSequencialResultado, c);
        c.gridx = 3;
        this.textDescricaoResultado.setMinimumSize(new Dimension(90, 20));
        panel.add((Component)this.textDescricaoResultado, c);
        c.gridx = 4;
        c.fill = 0;
        c.weightx = 0.0;
        this.buttonOutroCampo.setMinimumSize(new Dimension(20, 20));
        this.buttonOutroCampo.setMaximumSize(new Dimension(20, 20));
        panel.add((Component)this.buttonOutroCampo, c);
        c.gridx = 4;
        c.fill = 0;
        c.weightx = 0.0;
        this.buttonOKCampo.setMinimumSize(new Dimension(40, 20));
        this.buttonOKCampo.setMaximumSize(new Dimension(40, 20));
        panel.add((Component)this.buttonOKCampo, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 5;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        panel.add((Component)this.scroll, c);
        this.buttonOutroCampo.setVisible(false);
        this.table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127 && ConfiguradorExportacaoJalis.this.table.getSelectedRow() > -1 && Funcoes.mensagem(ConfiguradorExportacaoJalis.this, "Deseja excluir o registro selecionado?", 4) == 0) {
                    ConfiguradorExportacaoJalis.this.modelo.removeLine(ConfiguradorExportacaoJalis.this.table.getSelectedRow());
                } else if (e.getKeyCode() == 32 && ConfiguradorExportacaoJalis.this.table.getSelectedRow() > -1) {
                    ConfiguradorExportacaoJalis.this.editandoLinha = ConfiguradorExportacaoJalis.this.table.getSelectedRow();
                    ConfiguradorExportacaoJalis.this.comboOrigem.setSelectedItem(ConfiguradorExportacaoJalis.this.modelo.getValueAt(ConfiguradorExportacaoJalis.this.editandoLinha, 0).toString());
                    ConfiguradorExportacaoJalis.this.comboDestino.setSelectedItem(ConfiguradorExportacaoJalis.this.modelo.getValueAt(ConfiguradorExportacaoJalis.this.editandoLinha, 1));
                    ConfiguradorExportacaoJalis.this.textSequencialResultado.setText(ConfiguradorExportacaoJalis.this.modelo.getValueAt(ConfiguradorExportacaoJalis.this.editandoLinha, 2).toString());
                    ConfiguradorExportacaoJalis.this.textDescricaoResultado.setText(ConfiguradorExportacaoJalis.this.modelo.getValueAt(ConfiguradorExportacaoJalis.this.editandoLinha, 3).toString());
                    ScreenUtil.requisitarFoco(ConfiguradorExportacaoJalis.this.comboOrigem);
                }
                ConfiguradorExportacaoJalis.this.bloqueiaExame();
            }
        });
        ScreenUtil.requisitarFoco(this.comboOrigem);
        this.bloqueiaExame();
    }

    public static List<CampoResultado> getListaRelacionamentoCampos(String xml) {
        ArrayList<CampoResultado> lista = new ArrayList<CampoResultado>();
        if (xml != null && !Funcoes.textoVazio(StringUtil.getValor(xml, EXPORTAR_JALIS))) {
            String[] campos = StringUtil.getValores(xml, "campo");
            Object aux = null;
            for (String s : campos) {
                String origem = StringUtil.getValor(s, "origem");
                String destino = StringUtil.getValor(s, "destino");
                String sequencial = StringUtil.getValor(s, "sequencial");
                String descricaoResultado = StringUtil.getValor(s, "descricao");
                CampoResultado campo = null;
                for (TipoExame valor : TipoExame.values()) {
                    if (!valor.descricao.equalsIgnoreCase(destino)) continue;
                    campo = new CampoResultado(origem, valor.codigo, valor.descricao, sequencial, descricaoResultado);
                    break;
                }
                if (campo == null) continue;
                lista.add(campo);
            }
        }
        ConfiguradorExportacaoJalis.ordenaCampos(lista);
        return lista;
    }

    private static void ordenaCampos(List<CampoResultado> lista) {
        Collections.sort(lista, new Comparator(){

            public int compare(Object o1, Object o2) {
                String ori1 = ((CampoResultado)o1).sequencial;
                String ori2 = ((CampoResultado)o2).sequencial;
                return ori1.compareTo(ori2);
            }
        });
    }

    public static Hashtable<String, CampoResultado> getRelacionamentoCampos(String xml) {
        Hashtable<String, CampoResultado> hash = new Hashtable<String, CampoResultado>();
        List<CampoResultado> lista = ConfiguradorExportacaoJalis.getListaRelacionamentoCampos(xml);
        for (CampoResultado c : lista) {
            hash.put(c.origem.trim().toLowerCase(), c);
        }
        return hash;
    }

    @Override
    public String getXml() {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.modelo.getRowCount(); ++i) {
            buf.append("<campo>");
            buf.append(StringUtil.getTag("origem", this.modelo.getValueAt(i, 0).toString()));
            buf.append(StringUtil.getTag("destino", this.modelo.getValueAt(i, 1).toString()));
            buf.append(StringUtil.getTag("sequencial", this.modelo.getValueAt(i, 2).toString()));
            buf.append(StringUtil.getTag("descricao", this.modelo.getValueAt(i, 3).toString()));
            buf.append("</campo>");
        }
        return StringUtil.getTag(EXPORTAR_JALIS, buf.toString());
    }

    @Override
    public void setXml(String xml) {
        if (xml != null) {
            List<CampoResultado> campos = ConfiguradorExportacaoJalis.getListaRelacionamentoCampos(xml);
            this.modelo.clear();
            for (CampoResultado campo : campos) {
                this.modelo.addLine(new Object[]{campo.origem, TipoExame.getTipo(campo.posicao), campo.sequencial, campo.descricaoResultado});
            }
        }
        this.bloqueiaExame();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonOKCampo) {
            this.adicionar();
        } else if (e.getSource() == this.buttonOutroCampo) {
            String valor = JOptionPane.showInputDialog("Informe o valor a ser utilizado");
            if (valor != null && !this.valorOutroCampo.equals(valor)) {
                this.valorOutroCampo = valor;
            }
        } else {
            super.actionPerformed(e);
        }
    }

    private void adicionar() {
        boolean dadosValidos = this.validarDados();
        if (dadosValidos) {
            if (this.editandoLinha > -1) {
                this.modelo.setValueAt(this.comboOrigem.getSelectedItem().toString(), this.editandoLinha, 0);
                this.modelo.setValueAt(this.comboDestino.getSelectedItem(), this.editandoLinha, 1);
                this.modelo.setValueAt(this.textSequencialResultado.getText().toString(), this.editandoLinha, 2);
                this.modelo.setValueAt(this.textDescricaoResultado.getText().toString(), this.editandoLinha, 3);
                this.editandoLinha = -1;
                this.validarSequencia = true;
            } else {
                this.modelo.addLine(new Object[]{this.comboOrigem.getSelectedItem().toString(), this.comboDestino.getSelectedItem(), this.textSequencialResultado.getText(), this.textDescricaoResultado.getText()});
            }
            this.modelo.ordenarColunaSemTrocarSentido(2);
            this.bloqueiaExame();
            this.valorOutroCampo = "";
            this.limparCampos();
        }
    }

    private boolean validarDados() {
        String seq = this.textSequencialResultado.getText();
        String valorPesquisa = !Funcoes.textoVazio(this.valorOutroCampo) ? "\"" + this.valorOutroCampo + "\"" : this.comboOrigem.getSelectedItem().toString();
        int pos = this.modelo.localizar(0, valorPesquisa);
        if (Funcoes.textoVazio(seq)) {
            Funcoes.mensagem(this, "N\u00famero de sequ\u00eancia n\u00e3o foi informado.", 2);
            ScreenUtil.requisitarFoco(this.textSequencialResultado);
            return false;
        }
        if (this.editandoLinha > -1 && this.modelo.getValueAt(this.editandoLinha, 2).equals(this.textSequencialResultado.getText())) {
            this.validarSequencia = false;
        }
        if (this.validarSequencia) {
            for (int i = 0; i < this.modelo.getRowCount(); ++i) {
                if (!this.modelo.getValueAt(i, 2).toString().equalsIgnoreCase(seq)) continue;
                Funcoes.mensagem(this, "N\u00famero de sequ\u00eancia j\u00e1 cadastrado!", 2);
                ScreenUtil.requisitarFoco(this.textSequencialResultado);
                return false;
            }
        }
        if (this.editandoLinha > -1 && this.editandoLinha != pos && pos != -1 || this.editandoLinha == -1 && pos >= 0) {
            Funcoes.mensagem(this, valorPesquisa + " j\u00e1 est\u00e1 em uso.", 2);
            return false;
        }
        return true;
    }

    private void limparCampos() {
        this.textSequencialResultado.setText("");
        this.textDescricaoResultado.setText("");
        this.comboDestino.setSelectedIndex(0);
        this.comboOrigem.setSelectedIndex(0);
        ScreenUtil.requisitarFoco(this.comboOrigem);
    }

    private void bloqueiaExame() {
        if (this.modelo.getRowCount() > 0) {
            TipoExame aux = null;
            for (int i = 0; i < this.modelo.getRowCount(); ++i) {
                aux = (TipoExame)((Object)this.modelo.getValueAt(0, 1));
                for (TipoExame tipoExame : TipoExame.values()) {
                    if (aux.codigo != tipoExame.codigo) continue;
                    aux = null;
                    break;
                }
                if (aux != null) break;
            }
        }
    }

    public static enum TipoExame {
        RESULTADO(1, "Resultado"),
        LD(2, "LD"),
        VMP(3, "VMP"),
        UNIDADE(4, "Unidade"),
        METODOLOGIA(5, "Metodologia");

        int codigo = -1;
        String descricao = "";

        private TipoExame(int codigo, String descricao) {
            this.codigo = codigo;
            this.descricao = descricao;
        }

        public String toString() {
            return this.descricao;
        }

        public static TipoExame getTipo(int codigo) {
            for (TipoExame tipo : TipoExame.values()) {
                if (tipo.codigo != codigo) continue;
                return tipo;
            }
            return null;
        }
    }
}

