/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao;

import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.exportacao.DadosAssociacao;
import jalis.laboratorio.util.faturamento.FuncoesGerais;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.SplashMensagem;
import jalis.util.SteppedComboBox;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import org.tempuri.IDSIntLabProxy;
import org.tempuri.IDSIntLab___PesquisarExames;
import org.tempuri.IDSIntLab___PesquisarExamesResponse;
import org.tempuri.TCpoExa;
import org.tempuri.TExames;
import org.tempuri.TMateri;
import org.tempuri.TMetodo;

public class ConfiguradorAssociacaoIDS
extends AbstractDialogoOKCancelar
implements ActionListener,
WindowListener {
    public static final String TAG_INTEGRACAO_IDS = "integracaoIDS";
    public static final String TAG_CAMPO_RESULTADO = "campo_resultado";
    public static final String TAG_CAMPO_JALIS = "campo_jalis";
    public static final String TAG_CODIGO_CAMPO = "codigo_campo";
    public static final String TAG_CAMPO = "campo";
    public static final String TAG_CODIGO_METODOLOGIA = "codigo_metodologia";
    public static final String TAG_DESCRICAO_METODOLOGIA = "descricao_metodologia";
    public static final String TAG_DESCRICAO_MATERIAL = "descricao_material";
    public static final String TAG_SIGLA_MATERIAL = "sigla_material";
    public static final String TAG_CODIGO_EXAME = "codigo_exame";
    public static final int COLUNA_EXAME_CODIGO = 0;
    public static final int COLUNA_EXAME_DESCRICAO = 1;
    public static final int COLUNA_EXAME_SIGLA = 2;
    public static final int COLUNA_EXAME_CODIGO_SUS = 3;
    public static final int COLUNA_EXAME_JA_ASSOCIADO = 4;
    public static final int COLUNA_EXAME_OBJETO = 5;
    public static final int COLUNA_EXAME_ASSOCIACAO = 6;
    private static final int COLUNA_MATERIAL_SIGLA = 0;
    private static final int COLUNA_MATERIAL_DESCRICAO = 1;
    private static final int COLUNA_MATERIAL_OBJETO = 2;
    private static final int COLUNA_METODO_CODIGO = 0;
    private static final int COLUNA_METODO_DESCRICAO = 1;
    private static final int COLUNA_METODO_OBJETO = 2;
    private static final int COLUNA_RESULTADO_CODIGO = 0;
    private static final int COLUNA_RESULTADO_DESCRICAO = 1;
    private static final int COLUNA_RESULTADO_TIPO = 2;
    private static final int COLUNA_RESULTADO_TAMANHO = 3;
    private static final int COLUNA_RESULTADO_CASAS_DECIMAL = 4;
    private static final int COLUNA_RESULTADO_REQUERIDA = 5;
    private static final int COLUNA_RESULTADO_UNIDADE_MEDIDA = 6;
    private static final int COLUNA_RESULTADO_CAMPO_JALIS = 7;
    private static final int COLUNA_RESULTADO_OBJETO = 8;
    private static final int COLUNA_OBJETO_DADOS = 9;
    private final int COLUNA_CAMPO = 0;
    private final int COLUNA_ALTERNATIVO = 1;
    private final int COLUNA_DETALHES = 2;
    private final int CODIGO_PAI = 1;
    private final int CODIGO_VALOR = 2;
    private final int COLUNA_DETALHES_VALOR = 0;
    private final int COLUNA_DETALHES_TROCA = 1;
    private SteppedComboBox comboCampos = new SteppedComboBox();
    private TTextField textAlternativo = new TTextField(10);
    private TTextField textLocalizar = new TTextField(30);
    private JLabel labelCampos = ComponenteFactory.novoJLabel("Campos Jalis:", 'm', null, this.comboCampos);
    private JLabel labelLocalizar = ComponenteFactory.novoJLabel("Localizar:", 'L', null, this.textLocalizar);
    private JButton buttonOKCampo = ComponenteFactory.novoJButton("OK", 'K', this, null, new Dimension(40, 20));
    private SteppedComboBox comboMetodologia = new SteppedComboBox();
    private JLabel labelMetodologia = ComponenteFactory.novoJLabel("Metodologia:", 'm', null, this.comboMetodologia);
    private JButton buttonOKMetodologia = ComponenteFactory.novoJButton("OK", 'K', this, null, new Dimension(40, 20));
    private ModeloGridTable modeloExames = new ModeloGridTable(new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o", "Sigla", "C\u00f3d. Sus", "Sel."});
    private ModeloGridTable modeloMaterialColeta = new ModeloGridTable(new String[]{"Sigla", "Descri\u00e7\u00e3o"});
    private ModeloGridTable modeloMetodologia = new ModeloGridTable(new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"});
    private ModeloGridTable modeloResultados = new ModeloGridTable(new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o", "Tipo", "Tamanho", "Casas Dec.", "Req.?", "Unid.Med", "Campo Jalis"});
    private Integer codigoMetodologia;
    private JTable tableExame = new JTable(this.modeloExames){

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 4) {
                return Boolean.class;
            }
            return super.getColumnClass(columnIndex);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 4;
        }
    };
    private JTable tableMaterialColeta = new JTable(this.modeloMaterialColeta);
    private JTable tableMetodologia = new JTable(this.modeloMetodologia);
    private JTable tableResultados = new JTable(this.modeloResultados);
    private JScrollPane scrollExame = new JScrollPane(this.tableExame);
    private JScrollPane scrollMaterialColeta = new JScrollPane(this.tableMaterialColeta);
    private JScrollPane scrollMetodologia = new JScrollPane(this.tableMetodologia);
    private JScrollPane scrollResultados = new JScrollPane(this.tableResultados);
    private JPanel panelExames = ComponenteFactory.novoJPanel(new BorderLayout(), new TitledBorder("Exame"));
    private JPanel panelMaterial = ComponenteFactory.novoJPanel(new BorderLayout(), new TitledBorder("Material de coleta"));
    private JPanel panelMetodologia = ComponenteFactory.novoJPanel(new BorderLayout(), new TitledBorder("Metodologia"));
    private JPanel panelResultados = ComponenteFactory.novoJPanel(new BorderLayout(), new TitledBorder("Campos de resultado"));
    private TTextField textValor = new TTextField();
    private TTextField textTroca = new TTextField();
    private JButton buttonAtualizar = ComponenteFactory.novoJButton("Atualizar exames IDS", '\u0000', this, null, new Dimension(200, 25));
    private int linhaAnterior = -1;

    public static ConfiguradorAssociacaoIDS novaInstancia(Object pai) {
        if (pai instanceof Dialog) {
            return new ConfiguradorAssociacaoIDS((Dialog)pai, "Associando exames - Integra\u00e7\u00e3o com IDS Sa\u00fade");
        }
        return new ConfiguradorAssociacaoIDS((Frame)pai, "Associando exames - Integra\u00e7\u00e3o com IDS Sa\u00fade");
    }

    public ConfiguradorAssociacaoIDS(Dialog pai, String titulo) {
        super(pai, titulo);
        this.montaTela(pai);
    }

    public ConfiguradorAssociacaoIDS(Frame pai, String titulo) {
        super(pai, titulo);
        this.montaTela(pai);
    }

    private void montaTela(Window owner) {
        this.setSize(new Dimension(780, 580));
        this.setModal(true);
        this.setResizable(false);
        this.setLocationRelativeTo(owner);
        this.addWindowListener(this);
        this.tableExame.setDefaultRenderer(Boolean.class, new ExamesRenderer());
        this.tableExame.setDefaultEditor(Boolean.class, new ExamesEditor());
        this.tableExame.setSelectionMode(0);
        this.tableMaterialColeta.setSelectionMode(0);
        this.tableMetodologia.setSelectionMode(0);
        this.tableResultados.setSelectionMode(0);
        JPanel panel = this.getPanelCentral();
        panel.setLayout(new GridBagLayout());
        this.scrollMaterialColeta.setPreferredSize(new Dimension(100, 100));
        this.scrollMetodologia.setPreferredSize(new Dimension(100, 100));
        this.scrollResultados.setPreferredSize(new Dimension(100, 100));
        JPanel panelCampoJalis = new JPanel(new GridBagLayout());
        GridBagConstraints c1 = new GridBagConstraints();
        c1.gridx = 0;
        c1.gridy = 0;
        c1.fill = 0;
        c1.anchor = 17;
        c1.insets = new Insets(1, 1, 1, 0);
        c1.weightx = 0.0;
        panelCampoJalis.add((Component)this.labelCampos, c1);
        ++c1.gridx;
        this.comboCampos.setMinimumSize(new Dimension(250, 20));
        this.comboCampos.setPreferredSize(new Dimension(250, 20));
        panelCampoJalis.add((Component)this.comboCampos, c1);
        ++c1.gridx;
        panelCampoJalis.add((Component)this.buttonOKCampo, c1);
        ++c1.gridx;
        panelCampoJalis.add((Component)this.buttonOKCampo, c1);
        ++c1.gridx;
        c1.fill = 2;
        c1.weightx = 1.0;
        panelCampoJalis.add((Component)new JLabel(), c1);
        JPanel panelCamposMetologia = new JPanel(new GridBagLayout());
        GridBagConstraints cM = new GridBagConstraints();
        cM.gridx = 0;
        cM.gridy = 0;
        cM.fill = 0;
        cM.insets = new Insets(1, 0, 1, 0);
        cM.weightx = 0.0;
        cM.weighty = 0.0;
        panelCamposMetologia.add((Component)this.labelMetodologia, cM);
        ++cM.gridx;
        this.comboMetodologia.setMinimumSize(new Dimension(250, 20));
        this.comboMetodologia.setPreferredSize(new Dimension(250, 20));
        panelCamposMetologia.add((Component)this.comboMetodologia, cM);
        ++cM.gridx;
        panelCamposMetologia.add((Component)this.buttonOKMetodologia, cM);
        ++cM.gridx;
        cM.fill = 2;
        cM.weightx = 1.0;
        panelCamposMetologia.add((Component)new JLabel(), cM);
        this.panelExames.add((Component)this.scrollExame, "Center");
        this.panelMaterial.add((Component)this.scrollMaterialColeta, "Center");
        this.panelMetodologia.add((Component)this.scrollMetodologia, "Center");
        this.panelMetodologia.add((Component)panelCamposMetologia, "North");
        this.panelResultados.add((Component)this.scrollResultados, "Center");
        this.panelResultados.add((Component)panelCampoJalis, "South");
        JPanel panelLocalizar = this.montaPanelLocalizador();
        this.panelExames.add((Component)panelLocalizar, "South");
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.anchor = 17;
        panel.add((Component)this.panelExames, c);
        ++c.gridy;
        c.weighty = 0.3;
        panel.add((Component)this.panelMaterial, c);
        ++c.gridy;
        panel.add((Component)this.panelMetodologia, c);
        ++c.gridy;
        c.weighty = 1.0;
        panel.add((Component)this.panelResultados, c);
        this.modeloExames.setColumnSize(new int[]{80, 0, 80, 80, 50}, this.tableExame);
        this.modeloMaterialColeta.setColumnSize(new int[]{80, 0}, this.tableMaterialColeta);
        this.modeloMetodologia.setColumnSize(new int[]{80, 0}, this.tableMetodologia);
        this.modeloResultados.setColumnSize(new int[]{80, 0, 80, 80, 80, 80, 80, 0, 0}, this.tableResultados);
        this.buttonAtualizar.setMnemonic('A');
        this.getPanelBotoesEsquerda().add(this.buttonAtualizar);
        this.tableExame.getTableHeader().addMouseListener(this.modeloExames);
        this.tableMaterialColeta.getTableHeader().addMouseListener(this.modeloMaterialColeta);
        this.tableMetodologia.getTableHeader().addMouseListener(this.modeloMetodologia);
        this.tableResultados.getTableHeader().addMouseListener(this.modeloResultados);
        this.carregarListener();
        this.carregarExamesWebService(false, this);
        ScreenUtil.requisitarFoco(this.comboCampos);
    }

    private void carregarListener() {
        this.tableExame.getSelectionModel().addListSelectionListener(new ListSelectionListener(){
            boolean isAssociado = false;

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int linhaNova = ConfiguradorAssociacaoIDS.this.tableExame.getSelectedRow();
                if (linhaNova > -1) {
                    TExames exame = (TExames)ConfiguradorAssociacaoIDS.this.modeloExames.getValueAt(linhaNova, 5);
                    ConfiguradorAssociacaoIDS.this.modeloMaterialColeta.clear();
                    ConfiguradorAssociacaoIDS.this.modeloMetodologia.clear();
                    ConfiguradorAssociacaoIDS.this.modeloResultados.clear();
                    for (TMateri tMateri : exame.getMateriais()) {
                        ConfiguradorAssociacaoIDS.this.modeloMaterialColeta.addLine(new Object[]{tMateri.getSigla(), tMateri.getDescricao(), tMateri});
                    }
                    for (TMateri tMateri : exame.getMetodos()) {
                        ConfiguradorAssociacaoIDS.this.modeloMetodologia.addLine(new Object[]{tMateri.getCodigo(), tMateri.getDescricao(), tMateri});
                    }
                    for (TMateri tMateri : exame.getCamposResultadoExame()) {
                        ConfiguradorAssociacaoIDS.this.modeloResultados.addLine(new Object[]{tMateri.getCodigo(), tMateri.getDescricao(), tMateri.getTipo(), tMateri.getTamanho(), tMateri.getCasas_decimais(), tMateri.isRequerido() ? "Sim" : "N\u00e3o", tMateri.getUnidade_medida(), "", tMateri});
                    }
                    ArrayList listaExame = (ArrayList)ConfiguradorAssociacaoIDS.this.modeloExames.getValueAt(linhaNova, 6);
                    if (!listaExame.isEmpty()) {
                        for (DadosAssociacao dados : listaExame) {
                            int n;
                            boolean bl = false;
                            while (n < ConfiguradorAssociacaoIDS.this.modeloMaterialColeta.getRowCount()) {
                                String sigla = (String)ConfiguradorAssociacaoIDS.this.modeloMaterialColeta.getValueAt(n, 0);
                                if (sigla.equalsIgnoreCase(dados.getMaterial().getSigla())) {
                                    ConfiguradorAssociacaoIDS.this.tableMaterialColeta.getSelectionModel().setSelectionInterval(n, n);
                                    ConfiguradorAssociacaoIDS.this.tableMaterialColeta.scrollRectToVisible(ConfiguradorAssociacaoIDS.this.tableMaterialColeta.getCellRect(n, 0, true));
                                }
                                ++n;
                            }
                            n = 0;
                            for (int i = 0; i < ConfiguradorAssociacaoIDS.this.modeloMetodologia.getRowCount(); ++i) {
                                Integer codigoMetodo = (Integer)ConfiguradorAssociacaoIDS.this.modeloMetodologia.getValueAt(i, 0);
                                if (!codigoMetodo.equals(dados.getMetodo().getCodigo())) continue;
                                ConfiguradorAssociacaoIDS.this.tableMetodologia.getSelectionModel().setSelectionInterval(i, i);
                                ConfiguradorAssociacaoIDS.this.tableMetodologia.scrollRectToVisible(ConfiguradorAssociacaoIDS.this.tableMetodologia.getCellRect(i, 0, true));
                                n = 1;
                                break;
                            }
                            if (n == 0) {
                                TMetodo tMetodo = new TMetodo();
                                tMetodo.setCodigo(dados.getMetodo().getCodigo());
                                tMetodo.setDescricao(dados.getMetodo().getDescricao());
                                ConfiguradorAssociacaoIDS.this.modeloMetodologia.addLine(new Object[]{0, dados.getMetodo().getDescricao(), tMetodo});
                            }
                            for (int i = 0; i < ConfiguradorAssociacaoIDS.this.modeloResultados.getRowCount(); ++i) {
                                Integer codigoResultado = (Integer)ConfiguradorAssociacaoIDS.this.modeloResultados.getValueAt(i, 0);
                                if (!codigoResultado.equals(dados.getCampoIDS().getCodigo())) continue;
                                ConfiguradorAssociacaoIDS.this.modeloResultados.setValueAt(dados.campoJalis, i, 7);
                                ConfiguradorAssociacaoIDS.this.tableResultados.getSelectionModel().setSelectionInterval(i, i);
                                ConfiguradorAssociacaoIDS.this.tableResultados.scrollRectToVisible(ConfiguradorAssociacaoIDS.this.tableResultados.getCellRect(i, 0, true));
                            }
                        }
                    }
                }
            }
        });
        this.textLocalizar.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                int colunaOrdenacao = ConfiguradorAssociacaoIDS.this.modeloExames.getColunaOrdenacao();
                int row = -1;
                row = colunaOrdenacao == 0 || colunaOrdenacao == 3 ? ConfiguradorAssociacaoIDS.this.modeloExames.localizarParcial(ConfiguradorAssociacaoIDS.this.modeloExames.getColunaOrdenacao(), ConfiguradorAssociacaoIDS.this.textLocalizar.getText()) : ConfiguradorAssociacaoIDS.this.modeloExames.localizarContendo(ConfiguradorAssociacaoIDS.this.modeloExames.getColunaOrdenacao(), ConfiguradorAssociacaoIDS.this.textLocalizar.getText());
                if (row >= 0) {
                    ConfiguradorAssociacaoIDS.this.tableExame.getSelectionModel().setSelectionInterval(row, row);
                    ConfiguradorAssociacaoIDS.this.tableExame.scrollRectToVisible(ConfiguradorAssociacaoIDS.this.tableExame.getCellRect(row, 0, true));
                } else {
                    ConfiguradorAssociacaoIDS.this.tableExame.getSelectionModel().clearSelection();
                }
            }
        });
        this.buttonAtualizar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String xmlAssociacaoAtual = ConfiguradorAssociacaoIDS.this.getXml();
                ConfiguradorAssociacaoIDS.this.carregarExamesWebService(true, ConfiguradorAssociacaoIDS.this);
                ConfiguradorAssociacaoIDS.this.setXml(xmlAssociacaoAtual);
            }
        });
        this.buttonOKCampo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int posExame = ConfiguradorAssociacaoIDS.this.tableExame.getSelectedRow();
                int posMaterial = ConfiguradorAssociacaoIDS.this.tableMaterialColeta.getSelectedRow();
                int posMetodologia = ConfiguradorAssociacaoIDS.this.tableMetodologia.getSelectedRow();
                int posResultado = ConfiguradorAssociacaoIDS.this.tableResultados.getSelectedRow();
                String campoJalisSelecionado = (String)ConfiguradorAssociacaoIDS.this.comboCampos.getSelectedItem();
                ConfiguradorAssociacaoIDS.this.validarSelecao();
                if (posExame > -1 && posMaterial > -1 && posMetodologia > -1 && posResultado > -1) {
                    TMateri material = (TMateri)ConfiguradorAssociacaoIDS.this.modeloMaterialColeta.getValueAt(posMaterial, 2);
                    TMetodo metodo = (TMetodo)ConfiguradorAssociacaoIDS.this.modeloMetodologia.getValueAt(posMetodologia, 2);
                    TCpoExa campo = (TCpoExa)ConfiguradorAssociacaoIDS.this.modeloResultados.getValueAt(posResultado, 8);
                    ArrayList listaExame = (ArrayList)ConfiguradorAssociacaoIDS.this.modeloExames.getValueAt(posExame, 6);
                    DadosAssociacao dados = new DadosAssociacao();
                    dados.setMaterial(material);
                    dados.setMetodo(metodo);
                    dados.setCampoIDS(campo);
                    dados.setCampoJalis(campoJalisSelecionado);
                    if (!listaExame.contains(dados)) {
                        listaExame.add(dados);
                    }
                    ConfiguradorAssociacaoIDS.this.modeloResultados.setValueAt(campoJalisSelecionado, posResultado, 7);
                    ConfiguradorAssociacaoIDS.this.modeloResultados.setValueAt(dados, posResultado, 9);
                    ConfiguradorAssociacaoIDS.this.modeloExames.setValueAt(listaExame, posExame, 6);
                    ConfiguradorAssociacaoIDS.this.modeloExames.setValueAt(Boolean.TRUE, posExame, 4);
                    TExames tExames = (TExames)ConfiguradorAssociacaoIDS.this.modeloExames.getValueAt(ConfiguradorAssociacaoIDS.this.tableExame.getSelectedRow(), 5);
                    ConfiguradorAssociacaoIDS.this.modeloExames.setValueAt(tExames, ConfiguradorAssociacaoIDS.this.tableExame.getSelectedRow(), 5);
                }
            }
        });
        this.buttonOKMetodologia.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfiguradorAssociacaoIDS.this.atualizarMetodologia();
            }
        });
    }

    private void validarSelecao() {
        if (this.tableExame.getSelectedRow() < 0) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "Nenhum exame selecionado", 2);
        }
        if (this.tableMaterialColeta.getSelectedRow() < 0) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "Nenhum material selecionado", 2);
        }
        if (this.tableMetodologia.getSelectedRow() < 0) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "Nenhuma metodologia selecionado", 2);
        }
        if (this.tableResultados.getSelectedRow() < 0) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "Nenhuma campo de resultado selecionado", 2);
        }
    }

    private void atualizarMetodologia() {
        int posMetodologia = this.tableMetodologia.getSelectedRow();
        String campoMetodologiaSelecionado = (String)this.comboMetodologia.getSelectedItem();
        boolean adicionado = false;
        if (this.modeloMetodologia.getRowCount() > 0) {
            for (int i = 0; i < this.modeloMetodologia.getRowCount(); ++i) {
                Integer metodologia = (Integer)this.modeloMetodologia.getValueAt(i, 0);
                if (metodologia != 0) continue;
                adicionado = true;
                break;
            }
        }
        if (!adicionado) {
            TMetodo tMetodo = new TMetodo();
            tMetodo.setCodigo(0);
            tMetodo.setDescricao(campoMetodologiaSelecionado);
            this.modeloMetodologia.addLine(new Object[]{0, campoMetodologiaSelecionado, tMetodo});
        } else {
            this.modeloMetodologia.setValueAt(campoMetodologiaSelecionado, posMetodologia, 1);
        }
        int posicaoSelecionado = this.tableMetodologia.getRowCount() - 1;
        this.tableMetodologia.getSelectionModel().setSelectionInterval(posicaoSelecionado, posicaoSelecionado);
        this.tableMetodologia.scrollRectToVisible(this.tableMetodologia.getCellRect(posicaoSelecionado, 0, true));
    }

    private JPanel montaPanelLocalizador() {
        JPanel panel = new JPanel(new GridBagLayout());
        JPanel panelLocalizar = new JPanel(new FlowLayout());
        this.textLocalizar.setPreferredSize(new Dimension(250, 20));
        panelLocalizar.add(this.labelLocalizar);
        panelLocalizar.add(this.textLocalizar);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.anchor = 17;
        panel.add((Component)panelLocalizar, c);
        return panel;
    }

    public void carregarExamesWebService(boolean isAtualizar, Window janelPai) {
        String chaveAcesso = ParametrosGerais.getConfiguracaoIntegracaoIDS();
        if (!Funcoes.textoVazio(chaveAcesso)) {
            chaveAcesso = StringUtil.getValor(chaveAcesso, "configuracaoIDS");
            chaveAcesso = StringUtil.getValor(chaveAcesso, "chaveAcesso");
            TExames[] listaExames = Variaveis.listaExamesIDS;
            if (listaExames == null || isAtualizar) {
                SplashMensagem splash = SplashMensagem.getInstancia(janelPai);
                splash.setText("Carregando exames da base de dados do IDS Sa\u00fade...");
                splash.mostrar("Carregando exames da base de dados do IDS Sa\u00fade...");
                IDSIntLabProxy proxy = new IDSIntLabProxy();
                String linkComunicacao = ParametrosGerais.getConfiguracaoIntegracaoIDS();
                linkComunicacao = StringUtil.getValor(linkComunicacao, "link");
                if (!Funcoes.textoVazio(linkComunicacao)) {
                    proxy.setEndpoint(linkComunicacao);
                }
                IDSIntLab___PesquisarExames pesquisa = new IDSIntLab___PesquisarExames();
                pesquisa.setChave_acesso(chaveAcesso);
                pesquisa.setCodigo(-1);
                pesquisa.setDescricao_completa("");
                pesquisa.setDescricao_parcial("");
                pesquisa.setProcedimento(-1);
                pesquisa.setSigla("");
                IDSIntLab___PesquisarExamesResponse resposta = null;
                try {
                    resposta = proxy.pesquisarExames(pesquisa);
                }
                catch (RemoteException e) {
                    splash.apagar();
                    Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel conectar-se ao webservice do IDS Sa\u00fade.\n." + e.getMessage(), 2);
                }
                splash.apagar();
                if (resposta == null || resposta.getResult() == null) {
                    Funcoes.mensagem(this, "Uma situa\u00e7\u00e3o inesperada ocorreu ao carregar os exames do IDS Sa\u00fade.\nVerifique a conex\u00e3o com a internet.", 2);
                    return;
                }
                Variaveis.listaExamesIDS = listaExames = resposta.getResult();
            }
            this.modeloExames.clear();
            for (TExames tExames : listaExames) {
                this.modeloExames.addLine(new Object[]{tExames.getCodigo(), tExames.getDescricao(), tExames.getSigla(), tExames.getProcedimentoSUS(), Boolean.FALSE, tExames, new ArrayList()});
            }
            this.modeloExames.ordenarColuna(1);
        } else {
            Funcoes.mensagem(this, "N\u00e2o foi poss\u00edvel carregar.\nNenhuma configura\u00e7\u00e3o para integra\u00e7\u00e3o IDS foi encontrada.\nVerifique em configura\u00e7\u00f5es gerais.", 2);
        }
    }

    public void setCampos(String[] campos) {
        if (campos != null) {
            this.comboCampos.removeAllItems();
            this.comboCampos.addItem("");
            for (String s : campos) {
                this.comboCampos.addItem(s);
            }
        }
    }

    public void setMetodologia(String[] metodologia) {
        if (metodologia != null) {
            this.comboMetodologia.removeAllItems();
            this.comboMetodologia.addItem("");
            for (String s : metodologia) {
                this.comboMetodologia.addItem(s);
            }
        }
    }

    public String getXml() {
        XMLStringBuilder xml = new XMLStringBuilder();
        XMLStringBuilder xmlCampos = new XMLStringBuilder();
        Boolean isAssociada = false;
        int linhaAsssociada = -1;
        for (int i = 0; i < this.modeloExames.getRowCount(); ++i) {
            isAssociada = (Boolean)this.modeloExames.getValueAt(i, 4);
            if (!isAssociada.booleanValue()) continue;
            linhaAsssociada = i;
            break;
        }
        if (!isAssociada.booleanValue()) {
            return null;
        }
        try {
            xml.abrir(TAG_INTEGRACAO_IDS);
            Integer codigoExame = (Integer)this.modeloExames.getValueAt(linhaAsssociada, 0);
            xml.escrever(TAG_CODIGO_EXAME, String.valueOf(codigoExame));
            xml.escrever(TAG_SIGLA_MATERIAL, this.modeloMaterialColeta.getValueAt(this.tableMaterialColeta.getSelectedRow(), 0).toString());
            xml.escrever(TAG_DESCRICAO_MATERIAL, this.modeloMaterialColeta.getValueAt(this.tableMaterialColeta.getSelectedRow(), 1).toString());
            xml.escrever(TAG_CODIGO_METODOLOGIA, this.modeloMetodologia.getValueAt(this.tableMetodologia.getSelectedRow(), 0).toString());
            xml.escrever(TAG_DESCRICAO_METODOLOGIA, this.modeloMetodologia.getValueAt(this.tableMetodologia.getSelectedRow(), 1).toString());
            ArrayList lista = (ArrayList)this.modeloExames.getValueAt(linhaAsssociada, 6);
            if (lista != null) {
                for (DadosAssociacao dados : lista) {
                    xmlCampos.abrir(TAG_CAMPO);
                    xmlCampos.escrever(TAG_CODIGO_CAMPO, String.valueOf(dados.getCampoIDS().getCodigo()));
                    xmlCampos.escrever(TAG_CAMPO_JALIS, dados.getCampoJalis());
                    xmlCampos.fechar(TAG_CAMPO);
                }
            }
            xml.escrever(TAG_CAMPO_RESULTADO, xmlCampos);
            xml.fechar(TAG_INTEGRACAO_IDS);
        }
        catch (XMLStringBuilderException e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel gerar a associa\u00e7\u00e3o do exame.\n" + e.getMessage(), e.getStackTrace());
        }
        return xml.getXML();
    }

    public void setXml(String xml) {
        if (!Funcoes.textoVazio(xml)) {
            int i;
            String[] camposResultado;
            Integer codigo;
            int i2;
            String codigoExame = StringUtil.getValor(xml, TAG_CODIGO_EXAME);
            String siglaMaterial = StringUtil.getValor(xml, TAG_SIGLA_MATERIAL);
            String codigoMetodologia = StringUtil.getValor(xml, TAG_CODIGO_METODOLOGIA);
            String descricaoMetodologia = StringUtil.getValor(xml, TAG_DESCRICAO_METODOLOGIA);
            for (i2 = 0; i2 < this.modeloExames.getRowCount(); ++i2) {
                codigo = (Integer)this.modeloExames.getValueAt(i2, 0);
                if (!codigo.equals(Integer.parseInt(codigoExame))) continue;
                this.modeloExames.setValueAt(Boolean.TRUE, i2, 4);
                this.tableExame.getSelectionModel().setSelectionInterval(i2, i2);
                this.tableExame.scrollRectToVisible(this.tableExame.getCellRect(i2, 0, true));
                break;
            }
            for (i2 = 0; i2 < this.modeloMaterialColeta.getRowCount(); ++i2) {
                String sigla = (String)this.modeloMaterialColeta.getValueAt(i2, 0);
                if (!sigla.equalsIgnoreCase(siglaMaterial)) continue;
                this.tableMaterialColeta.getSelectionModel().setSelectionInterval(i2, i2);
                this.tableMaterialColeta.scrollRectToVisible(this.tableMaterialColeta.getCellRect(i2, 0, true));
                break;
            }
            if (Integer.valueOf(codigoMetodologia) == 0) {
                TMetodo tMetodo = new TMetodo();
                tMetodo.setCodigo(Integer.valueOf(codigoMetodologia).intValue());
                tMetodo.setDescricao(descricaoMetodologia);
                this.modeloMetodologia.addLine(new Object[]{0, descricaoMetodologia, tMetodo});
            }
            for (int i3 = 0; i3 < this.modeloMetodologia.getRowCount(); ++i3) {
                codigo = (Integer)this.modeloMetodologia.getValueAt(i3, 0);
                if (!codigo.equals(Integer.parseInt(codigoMetodologia))) continue;
                this.tableMetodologia.getSelectionModel().setSelectionInterval(i3, i3);
                this.tableMetodologia.scrollRectToVisible(this.tableMetodologia.getCellRect(i3, 0, true));
                break;
            }
            String xmlAux = StringUtil.getValor(xml, TAG_CAMPO_RESULTADO);
            for (String s : camposResultado = StringUtil.getValores(xmlAux, TAG_CAMPO)) {
                String campoIDS = StringUtil.getValor(s, TAG_CODIGO_CAMPO);
                String campoJalis = StringUtil.getValor(s, TAG_CAMPO_JALIS);
                for (i = 0; i < this.modeloResultados.getRowCount(); ++i) {
                    Integer codigoIDS = (Integer)this.modeloResultados.getValueAt(i, 0);
                    if (!codigoIDS.equals(Integer.parseInt(campoIDS))) continue;
                    this.modeloResultados.setValueAt(campoJalis, i, 7);
                    if (this.tableResultados.getSelectedRow() != -1) continue;
                    this.tableResultados.getSelectionModel().setSelectionInterval(i, i);
                    this.tableResultados.scrollRectToVisible(this.tableResultados.getCellRect(i, 0, true));
                }
            }
            int posExame = this.tableExame.getSelectedRow();
            int posMaterial = this.tableMaterialColeta.getSelectedRow();
            int posMetodologia = this.tableMetodologia.getSelectedRow();
            if (posExame > -1 && posMaterial > -1 && posMetodologia > -1) {
                ArrayList listaExame = (ArrayList)this.modeloExames.getValueAt(posExame, 6);
                TMateri material = (TMateri)this.modeloMaterialColeta.getValueAt(posMaterial, 2);
                TMetodo metodo = (TMetodo)this.modeloMetodologia.getValueAt(posMetodologia, 2);
                for (i = 0; i < this.modeloResultados.getRowCount(); ++i) {
                    TCpoExa campo = (TCpoExa)this.modeloResultados.getValueAt(i, 8);
                    String campoJalis = (String)this.modeloResultados.getValueAt(i, 7);
                    if (Funcoes.textoVazio(campoJalis)) continue;
                    DadosAssociacao dados = new DadosAssociacao();
                    dados.setMaterial(material);
                    dados.setMetodo(metodo);
                    dados.setCampoIDS(campo);
                    dados.setCampoJalis(campoJalis);
                    if (!listaExame.contains(dados)) {
                        listaExame.add(dados);
                    }
                    this.modeloExames.setValueAt(listaExame, posExame, 6);
                    this.modeloExames.setValueAt(Boolean.TRUE, posExame, 4);
                }
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
    }

    @Override
    protected boolean acaoOk() {
        boolean selecionado = false;
        for (int i = 0; i < this.modeloExames.getRowCount(); ++i) {
            if (!((Boolean)this.modeloExames.getValueAt(i, 4)).booleanValue()) continue;
            selecionado = true;
            break;
        }
        if (selecionado) {
            if (this.tableMaterialColeta.getSelectionModel().getMinSelectionIndex() == -1) {
                Funcoes.mensagem(this, "O material de coleta deve ser selecionado.", 2);
                return false;
            }
            if (this.tableMetodologia.getSelectionModel().getMinSelectionIndex() == -1) {
                Funcoes.mensagem(this, "A metodologia deve ser selecionada.", 2);
                return false;
            }
        }
        return true;
    }

    @Override
    public void windowOpened(WindowEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < ConfiguradorAssociacaoIDS.this.modeloExames.getRowCount(); ++i) {
                    boolean selecionado = (Boolean)ConfiguradorAssociacaoIDS.this.modeloExames.getValueAt(i, 4);
                    if (!selecionado) continue;
                    ConfiguradorAssociacaoIDS.this.tableExame.scrollRectToVisible(ConfiguradorAssociacaoIDS.this.tableExame.getCellRect(i, 0, true));
                    break;
                }
            }
        });
    }

    @Override
    @Deprecated
    public void windowClosing(WindowEvent e) {
    }

    @Override
    @Deprecated
    public void windowClosed(WindowEvent e) {
    }

    @Override
    @Deprecated
    public void windowIconified(WindowEvent e) {
    }

    @Override
    @Deprecated
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    @Deprecated
    public void windowActivated(WindowEvent e) {
    }

    @Override
    @Deprecated
    public void windowDeactivated(WindowEvent e) {
    }

    class ExamesEditor
    extends DefaultCellEditor {
        JCheckBox check;
        private final int COLUNA_PADRAO = 4;
        Boolean isAssociado;

        public ExamesEditor() {
            super(new JCheckBox());
            this.check = null;
            this.COLUNA_PADRAO = 4;
            this.isAssociado = false;
            this.check = (JCheckBox)this.editorComponent;
            this.check.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    FuncoesGerais.repaintTabela(ConfiguradorAssociacaoIDS.this.tableExame);
                    for (int i = 0; i < ConfiguradorAssociacaoIDS.this.modeloExames.getRowCount(); ++i) {
                        ExamesEditor.this.isAssociado = (Boolean)ConfiguradorAssociacaoIDS.this.modeloExames.getValueAt(i, 4);
                        if (!ExamesEditor.this.isAssociado.booleanValue()) continue;
                        ConfiguradorAssociacaoIDS.this.tableExame.getSelectionModel().setSelectionInterval(i, i);
                        ConfiguradorAssociacaoIDS.this.tableExame.scrollRectToVisible(ConfiguradorAssociacaoIDS.this.tableExame.getCellRect(i, 0, true));
                        break;
                    }
                }
            });
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int rowIndex, int vColIndex) {
            int i;
            Color cor = UIManager.getColor("Table.selectionBackground");
            this.check.setHorizontalAlignment(0);
            ModeloGridTable modelo = (ModeloGridTable)table.getModel();
            int rowAssociacao = -1;
            for (i = 0; i < modelo.getRowCount(); ++i) {
                this.isAssociado = (Boolean)modelo.getValueAt(i, 4);
                ArrayList listaAssociacoes = (ArrayList)modelo.getValueAt(i, 6);
                if (!this.isAssociado.booleanValue() || listaAssociacoes.isEmpty()) continue;
                rowAssociacao = i;
                break;
            }
            if (this.isAssociado.booleanValue()) {
                int resp = Funcoes.mensagem(ConfiguradorAssociacaoIDS.this, "Exame j\u00e1 associado.\nDeseja remover a associa\u00e7\u00e3o anterior?", 4);
                if (resp == 0) {
                    ArrayList lista = (ArrayList)ConfiguradorAssociacaoIDS.this.modeloExames.getValueAt(rowAssociacao, 6);
                    lista.clear();
                    ConfiguradorAssociacaoIDS.this.modeloExames.setValueAt(Boolean.FALSE, rowAssociacao, 4);
                } else {
                    this.check.setSelected(false);
                    ConfiguradorAssociacaoIDS.this.tableExame.getSelectionModel().setSelectionInterval(rowAssociacao, rowAssociacao);
                    ConfiguradorAssociacaoIDS.this.tableExame.scrollRectToVisible(ConfiguradorAssociacaoIDS.this.tableExame.getCellRect(rowAssociacao, 0, true));
                    return this.check;
                }
            }
            for (i = 0; i < modelo.getRowCount(); ++i) {
                this.isAssociado = (Boolean)modelo.getValueAt(i, 4);
                if (!this.isAssociado.booleanValue()) continue;
                ConfiguradorAssociacaoIDS.this.modeloExames.setValueAt(Boolean.FALSE, i, 4);
                break;
            }
            if (isSelected) {
                this.check.setBackground(cor);
            } else {
                this.check.setBackground(Color.white);
            }
            this.check.setSelected((Boolean)value);
            return this.check;
        }
    }

    class ExamesRenderer
    extends DefaultTableCellRenderer {
        private final int COLUNA_PADRAO = 4;

        ExamesRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JComponent c;
            Color cor = UIManager.getColor("Table.selectionBackground");
            if (column == 4) {
                JCheckBox check = new JCheckBox();
                check.setOpaque(true);
                check.setHorizontalAlignment(0);
                if (value instanceof Boolean) {
                    check.setSelected((Boolean)value);
                }
                if (isSelected) {
                    check.setBackground(cor);
                } else {
                    check.setBackground(Color.white);
                }
                c = check;
            } else {
                JLabel label = null;
                if (value instanceof String) {
                    label = new JLabel((String)value);
                } else if (value instanceof Integer) {
                    label = new JLabel(String.valueOf(value));
                }
                if (table != null && table.getFont() != null && label != null) {
                    label.setFont(table.getFont());
                }
                c = label;
            }
            return c;
        }
    }
}

