/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.estoque.pedido;

import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.table.TableModel;

public class RelatorioComparativoPrecoEstoque
extends FrmRelPadrao {
    private final String FILTRO_FORNECEDOR = "filtroFornecedor";
    private final String FILTRO_MATERIAL = "filtroMaterial";
    private final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private final String FILTRO_APENAS_INATIVO = "filtroApenasInativo";
    private final String[] camposMaterial = new String[]{"dataEmissaoNotaFiscal", "serieNotaFiscal", "codigoMaterial", "descricaoMaterial", "materialInativo", "codigoFornecedor", "fantasiaFornecedor", "razaoSocialFornecedor", "valorUnitarioMaterialNotaFiscal1", "quantidadeMaterialNotaFiscal1", "valorUnitarioMaterialNotaFiscal2", "quantidadeMaterialNotaFiscal2", "valorUnitarioMaterialNotaFiscal3", "quantidadeMaterialNotaFiscal3", "dataEmissaoNotaFiscal1", "dataEmissaoNotaFiscal2", "dataEmissaoNotaFiscal3", "foneFornecedor", "enderecoFornecedor", "faxFornecedor", "cnpjCpfFornecedor", "ieRgFornecedor", "complementoFornecedor", "desvioPadrao", "codigoNotaFiscal", "cepFornecedor", "dataCancelamentoNotaFiscal", "numeroEnderecoFornecedor", "tipoLogradouroFornecedor"};
    private final String[] camposRelatorio = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, this.camposMaterial);

    public RelatorioComparativoPrecoEstoque() {
        this.montaBarraDescricao("Relat\u00f3rio comparativo de pre\u00e7os", "Listagem dos materiais no per\u00edodo por fornecedor comparadas por valor", "relatorios/rel_estoque_pedido_comparativo_preco.jpg");
        this.adicionaItemFiltro("filtroFornecedor", "Fornecedor", "entidade", "fil_codigo = " + Variaveis.filialPadrao + " AND ent_tipo = '" + "F" + "'  AND ent_inativo = false", 1, new String[]{"ent_codigo", "ent_fantasia", "ent_razaosocial"}, new String[]{"C\u00f3digo", "Fantasia", "Raz\u00e3o Social"}, new int[]{70, 0, 0});
        this.adicionaItemFiltro("filtroMaterial", "Material", "material", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"mat_codigo", "mat_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaFiltroData("filtroDataInicial", "Data inicial:");
        this.adicionaFiltroData("filtroDataFinal", "Data final:");
        this.adicionaFiltroCheck("filtroApenasInativo", "Apenas material inativo", false);
        this.adicionaRelatorioListener(this);
        this.setModuloConfigurar(RelatorioComparativoPrecoEstoque.getModuloConfigurar());
        this.setModuloAcesso(RelatorioComparativoPrecoEstoque.getModuloAcesso());
        this.setCamposConfigurador(this.camposRelatorio);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void imprimirPressionado() {
        Statement st;
        block27: {
            String[] material;
            this.setCursor(Cursor.getPredefinedCursor(3));
            StringBuilder buf = new StringBuilder();
            buf.append(" SELECT a.ser_codigo \t\t\t\t\t\tAS serieNotaFiscal ");
            buf.append("     ,mat.mat_codigo\t\t\t\t\t\tAS codigoMaterial ");
            buf.append("     ,mat.mat_descricao \t\t\t\tAS descricaoMaterial ");
            buf.append("\t\t ,mat.mat_inativo \t\t\t\t\tas materialInativo ");
            buf.append("\t\t ,nfm.nfm_quantidade        AS quantidadeMaterialNotaFiscal ");
            buf.append("\t\t ,nfm.nfm_valorunitario     AS valorUnitarioMaterialNotaFiscal ");
            buf.append("     ,a.ent_codigo \t\t\t\t\t\t\tAS codigoFornecedor ");
            buf.append("     ,ent.ent_fantasia \t\t\t\t\tAS fantasiaFornecedor ");
            buf.append("     ,ent.ent_razaosocial \t\t\tAS razaoSocialFornecedor ");
            buf.append("     ,ent.ent_fone \t\t\t\t\t\t\tAS foneFornecedor ");
            buf.append("     ,ent.ent_endereco \t\t\t\t\tAS enderecoFornecedor ");
            buf.append("     ,ent.ent_numeroendereco\t\tAS numeroEnderecoFornecedor ");
            buf.append("     ,ent.ent_tipologradouroendereco AS tipoLogradouroFornecedor ");
            buf.append("     ,ent.ent_fax \t\t\t\t\t\t\tAS faxFornecedor ");
            buf.append("     ,ent.ent_cpfcnpj \t\t\t\t\tAS cnpjCpfFornecedor ");
            buf.append("     ,ent.ent_rgie \t\t\t\t\t\t\tAS ieRgFornecedor ");
            buf.append("     ,ent.ent_complemento \t\t\tAS complementoFornecedor ");
            buf.append("     ,ent.ent_cep \t\t\t\t\t\t\tAS cepFornecedor ");
            buf.append("\t\t ,a.nfi_codigo              AS codigoNotaFiscal");
            buf.append("\t\t ,a.nfi_dataemissao\t\t\t\t\tAS dataEmissaoNotaFiscal");
            buf.append("     ,a.nfi_datahoracancelada \tAS dataCancelamentoNotaFiscal ");
            buf.append("\t\t ,0.0 \tAS valorTotalMaterial ");
            buf.append("\t\t ,0 \t\tAS desvioPadrao ");
            buf.append(", ").append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
            buf.append("  FROM notafiscal a ");
            buf.append("  LEFT JOIN usuario usrrecpag \t\t \tON a.usr_codigo = usrrecpag.usr_codigo ");
            buf.append("  LEFT JOIN entidade ent \t\t\t\t\t \tON a.fil_codigo = ent.fil_codigo \t\tAND a.ent_codigo = ent.ent_codigo ");
            buf.append("  LEFT JOIN notafiscalmaterial nfm \tON nfm.fil_codigo = a.fil_codigo \t\tAND nfm.nfi_codigo = a.nfi_codigo ");
            buf.append("  LEFT JOIN material mat \t\t\t\t\t\tON mat.fil_codigo = nfm.fil_codigo \tAND mat.mat_codigo = nfm.mat_codigo ");
            buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
            buf.append("WHERE a.fil_codigo = ").append(Variaveis.filialPadrao);
            String[] fornecedor = this.getSelecionadosFiltro("filtroFornecedor", 0);
            if (fornecedor != null) {
                buf.append(" and ent.ent_codigo in (");
                for (int i = 0; i < fornecedor.length; ++i) {
                    buf.append(fornecedor[i]);
                    if (i >= fornecedor.length - 1) continue;
                    buf.append(",");
                }
                buf.append(") ");
            }
            if ((material = this.getSelecionadosFiltro("filtroMaterial", 0)) != null) {
                buf.append(" and mat.mat_codigo in (");
                for (int i = 0; i < material.length; ++i) {
                    buf.append(material[i]);
                    if (i >= material.length - 1) continue;
                    buf.append(",");
                }
                buf.append(") ");
            }
            if (Funcoes.verificaData(this.getFiltroData("filtroDataInicial"))) {
                buf.append(" AND cast(a.nfi_dataemissao as date) >= '");
                buf.append(Funcoes.formataData("yyyy/MM/dd", this.getFiltroData("filtroDataInicial")));
                buf.append("'");
            }
            if (Funcoes.verificaData(this.getFiltroData("filtroDataFinal"))) {
                buf.append(" AND cast(a.nfi_dataemissao as date) <= '");
                buf.append(Funcoes.formataData("yyyy/MM/dd", this.getFiltroData("filtroDataFinal")));
                buf.append("'");
            }
            buf.append(" AND a.nfi_tipo = '").append("E").append("' ");
            buf.append(" AND (a.nfi_datahoracancelada is null or a.nfi_datahoracancelada = null) ");
            if (this.getFiltroCheck("filtroApenasInativo")) {
                buf.append(" AND mat.mat_inativo = true ");
            } else {
                buf.append(" AND mat.mat_inativo = false ");
            }
            buf.append("GROUP BY ");
            buf.append("filial.fil_codigo, filial.fil_descricao, filial.fil_cnpj, filial.fil_endereco, filial.fil_complemento, filial.fil_cep, filial.fil_fone, filial.fil_fax, filial.fil_razaosocial, filial.fil_cnes, cidadefilial.cid_codigo, cidadefilial.cid_nome, cidadefilial.cid_uf, bairrofilial.bai_codigo, bairrofilial.bai_descricao ");
            buf.append(",codigoMaterial ");
            buf.append(",codigoNotaFiscal ");
            buf.append(",serieNotaFiscal ");
            buf.append(",descricaoMaterial ");
            buf.append(",materialInativo ");
            buf.append(",codigoFornecedor ");
            buf.append(",enderecoFornecedor ");
            buf.append(",numeroEnderecoFornecedor ");
            buf.append(",tipoLogradouroFornecedor ");
            buf.append(",fantasiaFornecedor ");
            buf.append(",cnpjCpfFornecedor ");
            buf.append(",faxFornecedor ");
            buf.append(",foneFornecedor ");
            buf.append(",ieRgFornecedor ");
            buf.append(",razaoSocialFornecedor ");
            buf.append(",complementoFornecedor ");
            buf.append(",cepFornecedor ");
            buf.append(",dataCancelamentoNotaFiscal ");
            buf.append(",dataEmissaoNotaFiscal ");
            buf.append(",nfm.nfm_quantidade, nfm.nfm_valorunitario");
            buf.append(" ORDER BY codigoFornecedor, codigoMaterial, dataEmissaoNotaFiscal, codigoNotaFiscal ");
            st = Conexao.getStatement();
            try {
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    ModeloGridTable modelo = new ModeloGridTable(this.camposRelatorio);
                    int ultimoMaterial = -1;
                    int ultimoFornecedor = -1;
                    int contadorMaterial = 1;
                    ArrayList<Long> valores = new ArrayList<Long>();
                    do {
                        if (ultimoMaterial == -1) {
                            ultimoMaterial = rs.getInt("codigomaterial");
                        }
                        if (ultimoFornecedor == -1) {
                            ultimoFornecedor = rs.getInt("codigofornecedor");
                        }
                        Object[] o = new Object[this.camposRelatorio.length];
                        for (int i = 0; i < this.camposRelatorio.length; ++i) {
                            if (this.camposRelatorio[i].equalsIgnoreCase("tipoLogradouroFornecedor")) {
                                o[modelo.findColumn((String)this.camposRelatorio[i])] = Tipos.tipoLogradouroDescricao(rs.getString(this.camposRelatorio[i]));
                                continue;
                            }
                            if (this.camposRelatorio[i].startsWith("valorUnitarioMaterialNotaFiscal") || this.camposRelatorio[i].startsWith("quantidadeMaterialNotaFiscal") || this.camposRelatorio[i].startsWith("dataEmissaoNotaFiscal")) continue;
                            o[modelo.findColumn((String)this.camposRelatorio[i])] = rs.getObject(this.camposRelatorio[i]);
                        }
                        while (ultimoMaterial > -1) {
                            Date data = rs.getDate("dataEmissaoNotaFiscal");
                            BigDecimal quantidade = rs.getBigDecimal("quantidadeMaterialNotaFiscal");
                            Long valor = rs.getLong("valorUnitarioMaterialNotaFiscal");
                            int pos = modelo.findColumn("quantidadeMaterialNotaFiscal" + String.valueOf(contadorMaterial));
                            if (o[pos] == null) {
                                o[pos] = quantidade;
                            }
                            if (o[pos = modelo.findColumn("valorUnitarioMaterialNotaFiscal" + String.valueOf(contadorMaterial))] == null) {
                                o[pos] = valor;
                                valores.add(valor);
                            }
                            if (o[pos = modelo.findColumn("dataEmissaoNotaFiscal" + String.valueOf(contadorMaterial))] == null) {
                                o[pos] = data;
                            }
                            ++contadorMaterial;
                            if (!rs.next()) break;
                            if (ultimoMaterial == rs.getInt("codigoMaterial") && ultimoFornecedor == rs.getInt("codigofornecedor") && contadorMaterial <= 3) continue;
                            o[modelo.findColumn((String)"desvioPadrao")] = Funcoes.desvioPadrao(valores);
                            ultimoMaterial = -1;
                            ultimoFornecedor = -1;
                            contadorMaterial = 1;
                            valores.clear();
                            rs.previous();
                        }
                        modelo.addLine(o);
                    } while (rs.next());
                    buf.delete(0, buf.length());
                    buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                    buf.append(RelatorioComparativoPrecoEstoque.getModuloAcesso());
                    rs = Conexao.executeQuery(st, buf.toString());
                    if (rs.next()) {
                        Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                        gerador.setPai(this.panelCentro);
                        gerador.setPreVisualizar(true);
                        gerador.setZoomPreVisualizar(1.0f);
                        gerador.setAcaoFechar(new Runnable(){

                            @Override
                            public void run() {
                                RelatorioComparativoPrecoEstoque.this.panelCentro.removeAll();
                                RelatorioComparativoPrecoEstoque.this.panelCentro.repaint();
                                RelatorioComparativoPrecoEstoque.this.habilitaBotaoImprimir(true);
                            }
                        });
                        HashMap<String, Object> var = new HashMap<String, Object>();
                        var.put("filtroDataInicial", this.getFiltroData("filtroDataInicial"));
                        var.put("filtroDataFinal", this.getFiltroData("filtroDataFinal"));
                        var.put("filtroApenasInativo", this.getFiltroCheck("filtroApenasInativo") ? "Sim" : "N\u00e3o");
                        buf.delete(0, buf.length());
                        if (fornecedor != null) {
                            for (int i = 0; i < fornecedor.length; ++i) {
                                buf.append(fornecedor[i]);
                                if (i >= fornecedor.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put("filtroFornecedor", buf.toString());
                        buf.delete(0, buf.length());
                        if (material != null) {
                            for (int i = 0; i < material.length; ++i) {
                                buf.append(material[i]);
                                if (i >= material.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put("filtroMaterial", buf.toString());
                        gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                        this.panelCentro.revalidate();
                    }
                    break block27;
                }
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            catch (Exception e) {
                try {
                    ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
        this.setCursor(Cursor.getDefaultCursor());
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0800901000");
    }

    public static long getModuloConfigurar() {
        return Long.parseLong("0800901001");
    }
}

