/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.estoque.pedido;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadrao;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.cadastro.VisualizarMateriaisAlternativos;
import jalis.laboratorio.estoque.SolicitarLoteMaterial;
import jalis.laboratorio.util.FinanceiroUtil;
import jalis.model.bean.cadastro.EntidadeBean;
import jalis.model.bean.estoque.CotacaoBean;
import jalis.model.bean.estoque.CotacaoEntidadeBean;
import jalis.model.bean.estoque.CotacaoEntidadeParcelaBean;
import jalis.model.bean.estoque.CotacaoMaterialEntidadeBean;
import jalis.model.bean.estoque.MaterialBean;
import jalis.model.bean.estoque.MaterialLoteBean;
import jalis.model.bean.estoque.MaterialLoteLanctoEstoqueBean;
import jalis.model.bean.estoque.PedidoBean;
import jalis.model.bean.estoque.PedidoLanctoEstoqueBean;
import jalis.model.bean.estoque.PedidoMaterialBean;
import jalis.model.bean.estoque.PedidoParcelaBean;
import jalis.model.bean.financeiro.ReceberPagarBean;
import jalis.model.dao.estoque.PedidoDao;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.EntidadeVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.model.vo.cadastro.financeiro.FormaPagamentoVO;
import jalis.model.vo.estoque.CelulaEstoqueVO;
import jalis.model.vo.estoque.CotacaoVO;
import jalis.model.vo.estoque.LancamentoEstoqueVO;
import jalis.model.vo.estoque.PedidoVO;
import jalis.service.cadastro.EntidadeService;
import jalis.service.cadastro.financeiro.FormaPagamentoParcelaService;
import jalis.service.cadastro.financeiro.FormaPagamentoService;
import jalis.service.estoque.CelulaEstoqueService;
import jalis.service.estoque.CotacaoService;
import jalis.service.estoque.MaterialService;
import jalis.service.estoque.PedidoLanctoEstoqueService;
import jalis.service.estoque.PedidoService;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;

public class PedidoCompra
extends FrmCadPadrao {
    private static final int COLUNA_CODIGO = 0;
    private static final int COLUNA_DESCRICAO = 1;
    private static final int COLUNA_VALOR_UNITARIO = 2;
    private static final int COLUNA_QUANTIDADE = 3;
    private static final int COLUNA_VALOR_DESCONTO = 4;
    private static final int COLUNA_VALOR_TOTAL = 5;
    private static final int COLUNA_OBJETO = 6;
    private JLabel labelCodigo = new JLabel();
    private JLabel labelData = new JLabel();
    private JLabel labelVlrData = new JLabel();
    private JLabel labelUsuario = new JLabel();
    private JLabel labelVlrUsuario = new JLabel();
    private JLabel labelMaterial = new JLabel();
    private JLabel labelDescricaoMaterial = new JLabel();
    private JLabel labelUnitario = new JLabel();
    private JLabel labelQuantidade = new JLabel();
    private JLabel labelDesconto = new JLabel();
    private JLabel labelTotal = new JLabel();
    private JLabel labelFornecedor = new JLabel();
    private JLabel labelFantasiaFornecedor = new JLabel();
    private JLabel labelVendedor = new JLabel();
    private JLabel labelFormaPagto = new JLabel();
    private JLabel labelDescricaoFormaPagto = new JLabel();
    private JLabel labelCotacao = new JLabel();
    private JLabel labelVlrCotacao = new JLabel();
    private JLabel labelAux1 = new JLabel();
    private JLabel labelSubTotal = new JLabel();
    private JLabel labelDescontoTotal = new JLabel();
    private JLabel labelTotalGeral = new JLabel();
    private JLabel labelObservacao = new JLabel();
    private JLabel labelAux2 = new JLabel();
    private JLabel labelVlrTotal = new JLabel();
    private JLabel labelVlrSubTotal = new JLabel();
    private JLabel labelVlrTotalGeral = new JLabel();
    private JLabel labelFrete = new JLabel();
    private TTextField textUnitario = new TTextField(10, 2, 4);
    private TTextField textMaterial = new TTextField(18, 3);
    private TTextField textCodigo = new TTextField(8, 1);
    private TTextField textQuantidade = new TTextField(10, 2);
    private TTextField textDesconto = new TTextField(10, 2);
    private TTextField textFornecedor = new TTextField(8, 1);
    private TTextField textVendedor = new TTextField(80, 3);
    private TTextField textFormaPagto = new TTextField(8, 1);
    private TTextField textDescontoTotal = new TTextField(10, 2);
    private TTextField textFrete = new TTextField(10, 2);
    private JButton buttonCodigo = new JButton();
    private JButton buttonMaterial = new JButton();
    private JButton buttonOk = new JButton();
    private JButton buttonFornecedor = new JButton();
    private JButton buttonFormaPagto = new JButton();
    private JButton buttonImportar = new JButton("Importar");
    private JComboBox comboDesconto = new JComboBox();
    private JComboBox comboDescontoTotal = new JComboBox();
    private JPanel panelMateriais = new JPanel();
    private JPanel panelDados = new JPanel();
    private JPanel panelTotal = new JPanel();
    private JPanel panelObservacao = new JPanel();
    private JPanel panelMateriaisAux = new JPanel();
    private JScrollPane scrollObservacao = new JScrollPane();
    private JTextArea areaObservacao = new JTextArea();
    private JScrollPane scrollMateriais;
    private JTable tableMateriais = null;
    private ModeloGridTable modeloMateriais = null;
    private PedidoBean pedidoAux = null;
    private CotacaoVO cotacaoAux = null;
    private Date datahoraAux = null;
    private EntidadeVO fornecedorAux = null;
    private FormaPagamentoVO formaPagtoAux = null;
    private MaterialBean materialAux = null;
    private final int CASAS = ParametrosGerais.getCasasPrecoExame();
    private final int CASAS_MAIOR = 4;
    private RoundingMode ROUND = ParametrosGerais.getArredondamentoPrecoExame();
    private boolean isAlterandoMaterial = false;
    private String retornoParaPesquisa = "";
    private ArrayList<PedidoMaterialBean> materiaisRemovidos = null;
    private boolean isFinalizarCotacao = false;

    public PedidoCompra(PedidoBean pedido, boolean isFinalizarCotacao) {
        this();
        this.isFinalizarCotacao = isFinalizarCotacao;
        this.novo();
        this.preencherCampos(pedido);
        this.pedidoAux = pedido;
        this.controlaCampos();
    }

    public PedidoCompra() {
        Funcoes.criaBarraDescricao(this, "Pedido de Compra", "Cadastro de pedidos de compra", "estoque/pedido_compra.jpg");
        ScreenUtil.setBorda(new Component[]{this.labelVlrData, this.labelVlrUsuario, this.labelFantasiaFornecedor, this.labelDescricaoFormaPagto, this.labelVlrCotacao, this.labelDescricaoMaterial, this.labelVlrTotal, this.labelVlrSubTotal, this.labelVlrTotalGeral}, new TitledBorder(""));
        this.buttonImportar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CotacaoService serviceCotacao = new CotacaoService();
                CotacaoVO cotacao = new CotacaoVO();
                cotacao = (CotacaoVO)serviceCotacao.pesquisaCotacaoDisponivelVO(Laboratorio.getInstancia(), cotacao, "Pesquisando cota\u00e7\u00f5es dispon\u00edveis");
                if (cotacao == null) {
                    return;
                }
                CotacaoBean bean = null;
                try {
                    bean = (CotacaoBean)serviceCotacao.get(cotacao.getFilial().getCodigo().toString(), cotacao.getCodigo().toString());
                }
                catch (Exception e2) {
                    ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e2.getMessage(), e2.getStackTrace(), "PedidoCompra:PedidoCompra");
                }
                if (bean != null) {
                    PedidoCompra.this.limparCampos();
                    PedidoCompra.this.preencheDadosCotacao(bean);
                }
            }
        });
        this.buttonCodigo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PedidoCompra.this.buscaPedido();
            }
        });
        this.textCodigo.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (Funcoes.textoVazio(PedidoCompra.this.textCodigo)) {
                    return;
                }
                if (PedidoCompra.this.pedidoAux != null) {
                    return;
                }
                PedidoBean pedido = null;
                try {
                    pedido = (PedidoBean)new PedidoService().get(PedidoCompra.this.textCodigo.getText());
                }
                catch (Exception e1) {
                    Funcoes.mensagem(PedidoCompra.this, "Os dados do pedido n\u00e3o puderam ser carregados.", 2);
                    return;
                }
                if (pedido == null || pedido.getDataExclusao() != null) {
                    Funcoes.mensagem(PedidoCompra.this, "O pedido n\u00e3o foi encontrado.", 2);
                    ScreenUtil.requisitarFoco(PedidoCompra.this.textCodigo);
                    PedidoCompra.this.textCodigo.selectAll();
                    return;
                }
                PedidoCompra.this.setStatus(3);
                PedidoCompra.this.preencherCampos(pedido);
                PedidoCompra.this.controlaCampos();
                ScreenUtil.requisitarFoco(PedidoCompra.this.textFornecedor);
            }
        });
        this.textFormaPagto.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (Funcoes.textoVazio(PedidoCompra.this.textFormaPagto)) {
                    return;
                }
                FormaPagamentoVO formaPagto = null;
                try {
                    formaPagto = (FormaPagamentoVO)new FormaPagamentoService().getVO(Variaveis.filialPadrao, PedidoCompra.this.textFormaPagto.getText());
                }
                catch (Exception e1) {
                    PedidoCompra.this.formaPagtoAux = null;
                    PedidoCompra.this.labelDescricaoFormaPagto.setText("N\u00e3o cadastrado");
                    return;
                }
                if (formaPagto != null) {
                    PedidoCompra.this.formaPagtoAux = formaPagto;
                    PedidoCompra.this.labelDescricaoFormaPagto.setText(formaPagto.getDescricao());
                } else {
                    PedidoCompra.this.formaPagtoAux = null;
                    PedidoCompra.this.labelDescricaoFormaPagto.setText("N\u00e3o cadastrado");
                }
            }
        });
        this.textMaterial.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (Funcoes.textoVazio(PedidoCompra.this.textMaterial)) {
                    return;
                }
                try {
                    PedidoCompra.this.materialAux = (MaterialBean)new MaterialService().getAtivo(Variaveis.filialPadrao, PedidoCompra.this.textMaterial.getText(), null, PedidoCompra.this.pedidoAux != null ? (PedidoVO)PedidoCompra.this.pedidoAux.toVO() : null);
                }
                catch (Exception e1) {
                    PedidoCompra.this.materialAux = null;
                    PedidoCompra.this.labelDescricaoMaterial.setText("N\u00e3o cadastrado");
                    ErrorLogger.mostraMensagem(PedidoCompra.this, "N\u00e3o foi poss\u00edvel carregar dados do material.\n" + e1.getMessage(), e1.getStackTrace());
                    return;
                }
                PedidoCompra.this.materialAux = VisualizarMateriaisAlternativos.getTelaMaterialAlternativo(PedidoCompra.this.materialAux, PedidoCompra.this.textMaterial);
                if (PedidoCompra.this.materialAux != null) {
                    PedidoCompra.this.textMaterial.setText(PedidoCompra.this.materialAux.getCodigo().toString());
                    PedidoCompra.this.labelDescricaoMaterial.setText(PedidoCompra.this.materialAux.getDescricao());
                } else {
                    PedidoCompra.this.labelDescricaoMaterial.setText("N\u00e3o cadastrado");
                }
                PedidoCompra.this.controlaCampos();
                if (PedidoCompra.this.textUnitario.isEnabled() && PedidoCompra.this.textUnitario.isFocusable()) {
                    ScreenUtil.requisitarFoco(PedidoCompra.this.textUnitario);
                }
            }
        });
        this.textFornecedor.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (Funcoes.textoVazio(PedidoCompra.this.textFornecedor)) {
                    return;
                }
                EntidadeBean entidade = null;
                try {
                    entidade = (EntidadeBean)new EntidadeService().get(Variaveis.filialPadrao, PedidoCompra.this.textFornecedor.getText(), "F");
                }
                catch (Exception e1) {
                    PedidoCompra.this.fornecedorAux = null;
                    PedidoCompra.this.labelFantasiaFornecedor.setText("N\u00e3o cadastrado");
                    ErrorLogger.mostraMensagem(PedidoCompra.this, "N\u00e3o foi poss\u00edvel carrega os dados da entidade.\n" + e1.getMessage(), e1.getStackTrace());
                    return;
                }
                if (entidade != null) {
                    PedidoCompra.this.fornecedorAux = (EntidadeVO)entidade.toVO();
                    PedidoCompra.this.labelFantasiaFornecedor.setText(entidade.getFantasia());
                } else {
                    PedidoCompra.this.fornecedorAux = null;
                    PedidoCompra.this.labelFantasiaFornecedor.setText("N\u00e3o cadastrado");
                }
            }
        });
        this.textDescontoTotal.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PedidoCompra.this.calculaTotaisGerais();
            }
        });
        this.comboDescontoTotal.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PedidoCompra.this.calculaTotaisGerais();
            }
        });
        this.textFrete.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PedidoCompra.this.calculaTotaisGerais();
            }
        });
        this.buttonOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PedidoCompra.this.materialAux == null) {
                    Funcoes.mensagem(PedidoCompra.this, "Nenhum material foi selecionado.", 2);
                    ScreenUtil.requisitarFoco(PedidoCompra.this.textMaterial);
                    return;
                }
                if (Funcoes.textoVazio(PedidoCompra.this.textUnitario) || Double.valueOf(Funcoes.limpaDecimal(PedidoCompra.this.textUnitario.getText())) <= 0.0) {
                    Funcoes.mensagem(PedidoCompra.this, "O valor unit\u00e1rio deve ser maior que zero.", 2);
                    ScreenUtil.requisitarFoco(PedidoCompra.this.textUnitario);
                    return;
                }
                if (Funcoes.textoVazio(PedidoCompra.this.textQuantidade) || Double.valueOf(Funcoes.limpaDecimal(PedidoCompra.this.textQuantidade.getText())) <= 0.0) {
                    Funcoes.mensagem(PedidoCompra.this, "A quantidade deve ser maior que zero.", 2);
                    ScreenUtil.requisitarFoco(PedidoCompra.this.textQuantidade);
                    return;
                }
                if (Double.valueOf(Funcoes.limpaDecimal(PedidoCompra.this.labelVlrTotal.getText())) <= 0.0) {
                    Funcoes.mensagem(PedidoCompra.this, "O valor total deve ser maior que zero.", 2);
                    ScreenUtil.requisitarFoco(PedidoCompra.this.textUnitario);
                    return;
                }
                FilialVO filial = new FilialVO();
                filial.setCodigo(Integer.valueOf(Variaveis.filialPadrao));
                PedidoMaterialBean material = new PedidoMaterialBean();
                material.setFilial(filial);
                if (PedidoCompra.this.pedidoAux != null) {
                    material.setPedido(PedidoCompra.this.pedidoAux);
                }
                material.setMaterial(PedidoCompra.this.materialAux);
                material.setQuantidade(Double.valueOf(Funcoes.limpaDecimal(PedidoCompra.this.textQuantidade.getText())));
                material.setValorTotal(Double.valueOf(Funcoes.limpaDecimal(PedidoCompra.this.labelVlrTotal.getText())));
                material.setValorUnitario(Double.valueOf(Funcoes.limpaDecimal(PedidoCompra.this.textUnitario.getText())));
                if (PedidoCompra.this.comboDesconto.getSelectedItem().equals("$")) {
                    BigDecimal valor = new BigDecimal(Funcoes.textoVazio(PedidoCompra.this.textDesconto) ? "0" : Funcoes.limpaDecimal(PedidoCompra.this.textDesconto.getText())).setScale(4, PedidoCompra.this.ROUND);
                    material.setValorDesconto(valor.setScale(PedidoCompra.this.CASAS, PedidoCompra.this.ROUND).doubleValue());
                    BigDecimal subtotal = new BigDecimal(Funcoes.textoVazio(PedidoCompra.this.textUnitario) ? "0" : Funcoes.limpaDecimal(PedidoCompra.this.textUnitario.getText())).setScale(4, PedidoCompra.this.ROUND);
                    subtotal = subtotal.multiply(new BigDecimal(Funcoes.textoVazio(PedidoCompra.this.textQuantidade) ? "0" : Funcoes.limpaDecimal(PedidoCompra.this.textQuantidade.getText())).setScale(4, PedidoCompra.this.ROUND));
                    valor = valor.multiply(new BigDecimal("100").setScale(4, PedidoCompra.this.ROUND)).divide(subtotal, PedidoCompra.this.ROUND);
                    material.setPercentualDesconto(valor.setScale(PedidoCompra.this.CASAS, PedidoCompra.this.ROUND).doubleValue());
                } else {
                    BigDecimal perc = new BigDecimal(Funcoes.textoVazio(PedidoCompra.this.textDesconto) ? "0" : Funcoes.limpaDecimal(PedidoCompra.this.textDesconto.getText())).setScale(4, PedidoCompra.this.ROUND);
                    material.setPercentualDesconto(perc.setScale(PedidoCompra.this.CASAS, PedidoCompra.this.ROUND).doubleValue());
                    BigDecimal subtotal = new BigDecimal(Funcoes.textoVazio(PedidoCompra.this.textUnitario) ? "0" : Funcoes.limpaDecimal(PedidoCompra.this.textUnitario.getText())).setScale(4, PedidoCompra.this.ROUND);
                    perc = perc.multiply(subtotal).divide(new BigDecimal("100").setScale(4, PedidoCompra.this.ROUND), PedidoCompra.this.ROUND);
                    perc = perc.multiply(new BigDecimal(Funcoes.textoVazio(PedidoCompra.this.textQuantidade) ? "0" : Funcoes.limpaDecimal(PedidoCompra.this.textQuantidade.getText())).setScale(4, PedidoCompra.this.ROUND));
                    material.setValorDesconto(perc.setScale(PedidoCompra.this.CASAS, PedidoCompra.this.ROUND).doubleValue());
                }
                if (PedidoCompra.this.adicionaMaterial(material)) {
                    PedidoCompra.this.textMaterial.setText("");
                    PedidoCompra.this.textUnitario.setText("");
                    PedidoCompra.this.textQuantidade.setText("");
                    PedidoCompra.this.textDesconto.setText("");
                    PedidoCompra.this.comboDesconto.setSelectedIndex(0);
                    PedidoCompra.this.labelVlrTotal.setText("");
                    PedidoCompra.this.labelDescricaoMaterial.setText("");
                    PedidoCompra.this.isAlterandoMaterial = false;
                    PedidoCompra.this.textMaterial.setEnabled(true);
                }
                ScreenUtil.requisitarFoco(PedidoCompra.this.textMaterial);
            }
        });
        this.buttonMaterial.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Hashtable hash = Pesquisas.materialAtivo(Laboratorio.getInstancia(), true);
                if (hash != null) {
                    MaterialBean bean = null;
                    try {
                        bean = (MaterialBean)new MaterialService().getAtivo(Variaveis.filialPadrao, String.valueOf((Integer)hash.get("mat_codigo")), null, PedidoCompra.this.pedidoAux != null ? (PedidoVO)PedidoCompra.this.pedidoAux.toVO() : null);
                    }
                    catch (Exception e1) {
                        ErrorLogger.mostraMensagem(PedidoCompra.this, "N\u00e3o foi poss\u00edvel buscar dados do material.\n" + e1.getMessage(), e1.getStackTrace());
                        return;
                    }
                    if (bean != null) {
                        PedidoCompra.this.textMaterial.setText(String.valueOf(bean.getCodigo()));
                        PedidoCompra.this.labelDescricaoMaterial.setText(bean.getDescricao());
                        PedidoCompra.this.materialAux = bean;
                        PedidoCompra.this.calculaTotalMaterial();
                    } else {
                        PedidoCompra.this.textMaterial.setText(String.valueOf((Integer)hash.get("mat_codigo")));
                        PedidoCompra.this.labelDescricaoMaterial.setText("N\u00e3o cadastrado");
                    }
                }
                PedidoCompra.this.controlaCampos();
            }
        });
        this.buttonFormaPagto.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FormaPagamentoService service = new FormaPagamentoService();
                PedidoCompra.this.formaPagtoAux = (FormaPagamentoVO)service.pesquisaVO(Laboratorio.getInstancia(), new FormaPagamentoVO(), "Pesquisando Formas de Pagamento", false);
                if (PedidoCompra.this.formaPagtoAux != null) {
                    PedidoCompra.this.textFormaPagto.setText(String.valueOf(PedidoCompra.this.formaPagtoAux.getCodigo()));
                    PedidoCompra.this.labelDescricaoFormaPagto.setText(PedidoCompra.this.formaPagtoAux.getDescricao());
                } else {
                    PedidoCompra.this.textFormaPagto.setText("");
                    PedidoCompra.this.labelDescricaoFormaPagto.setText("");
                }
            }
        });
        this.buttonFornecedor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EntidadeService service = new EntidadeService();
                PedidoCompra.this.fornecedorAux = (EntidadeVO)service.pesquisaVO((Object)PedidoCompra.this.getTopLevelAncestor(), (AbstractThreadVO)new EntidadeVO(), "Pesquisando fornecedores", 1, "F", true);
                if (PedidoCompra.this.fornecedorAux != null) {
                    PedidoCompra.this.textFornecedor.setText(String.valueOf(PedidoCompra.this.fornecedorAux.getCodigo()));
                    PedidoCompra.this.labelFantasiaFornecedor.setText(PedidoCompra.this.fornecedorAux.getFantasia());
                } else {
                    PedidoCompra.this.textFornecedor.setText("");
                    PedidoCompra.this.labelFantasiaFornecedor.setText("");
                }
            }
        });
        FocusAdapter focoCamposMaterial = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PedidoCompra.this.calculaTotalMaterial();
            }
        };
        this.textUnitario.addFocusListener(focoCamposMaterial);
        this.textQuantidade.addFocusListener(focoCamposMaterial);
        this.textDesconto.addFocusListener(focoCamposMaterial);
        this.comboDesconto.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (PedidoCompra.this.comboDesconto.getSelectedItem().equals("%") && Double.valueOf(Funcoes.limpaDecimal(PedidoCompra.this.textDesconto.getText())) > 100.0) {
                    PedidoCompra.this.textDesconto.setText(Funcoes.formataDecimal(100));
                }
                PedidoCompra.this.calculaTotalMaterial();
            }
        });
        this.modeloMateriais = new ModeloGridTable(new String[]{"C\u00f3d.", "Descri\u00e7\u00e3o", "Vlr. Unit\u00e1rio", "Quantidade", "Vlr. Desconto", "Vlr. Total"}){

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }
        };
        this.tableMateriais = new JTable(this.modeloMateriais);
        this.tableMateriais.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127) {
                    int resp = Funcoes.mensagem(PedidoCompra.this, "Deseja remover o material do pedido de compra?", 4);
                    if (resp == 0) {
                        int row = ((JTable)e.getSource()).getSelectedRow();
                        if (row < 0) {
                            return;
                        }
                        if (PedidoCompra.this.materiaisRemovidos != null) {
                            PedidoCompra.this.materiaisRemovidos.add((PedidoMaterialBean)PedidoCompra.this.modeloMateriais.getValueAt(row, 6));
                        }
                        PedidoCompra.this.modeloMateriais.removeLine(row);
                        PedidoCompra.this.calculaTotaisGerais();
                    }
                } else if (e.getKeyCode() == 32) {
                    if (ParametrosGerais.getTipoMovimentarEstoque().equalsIgnoreCase("P")) {
                        Funcoes.mensagem(PedidoCompra.this, "O sistema est\u00e1 configurado para movimentar estoque ao criar o pedido de compra.\nN\u00e3o \u00e9 poss\u00edvel editar os \u00edtens do pedido.", 2);
                        return;
                    }
                    int row = PedidoCompra.this.tableMateriais.getSelectedRow();
                    if (row >= 0) {
                        PedidoMaterialBean pedMaterial = (PedidoMaterialBean)PedidoCompra.this.modeloMateriais.getValueAt(row, 6);
                        PedidoCompra.this.textMaterial.setText(String.valueOf(pedMaterial.getMaterial().getCodigo()));
                        PedidoCompra.this.labelDescricaoMaterial.setText(pedMaterial.getMaterial().getDescricao());
                        PedidoCompra.this.textUnitario.setText(Funcoes.formataDecimal("###,##0.00##", pedMaterial.getValorUnitario()));
                        PedidoCompra.this.textQuantidade.setText(Funcoes.formataDecimal(pedMaterial.getQuantidade()));
                        PedidoCompra.this.textDesconto.setText(Funcoes.formataDecimal(pedMaterial.getValorDesconto()));
                        PedidoCompra.this.labelVlrTotal.setText(Funcoes.formataDecimal("###,##0.00##", pedMaterial.getValorTotal()));
                        PedidoCompra.this.isAlterandoMaterial = true;
                        PedidoCompra.this.materialAux = pedMaterial.getMaterial();
                        PedidoCompra.this.controlaCampos();
                        ScreenUtil.requisitarFoco(PedidoCompra.this.textUnitario);
                    }
                }
            }
        });
        this.tableMateriais.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (PedidoCompra.this.isAlterandoMaterial) {
                    PedidoCompra.this.textMaterial.setText("");
                    PedidoCompra.this.labelDescricaoMaterial.setText("");
                    PedidoCompra.this.textUnitario.setText("");
                    PedidoCompra.this.textQuantidade.setText("");
                    PedidoCompra.this.textDesconto.setText("");
                    PedidoCompra.this.labelVlrTotal.setText("");
                    PedidoCompra.this.isAlterandoMaterial = false;
                    PedidoCompra.this.controlaCampos();
                }
                if (e.getClickCount() == 2) {
                    if (ParametrosGerais.getTipoMovimentarEstoque().equalsIgnoreCase("P")) {
                        Funcoes.mensagem(PedidoCompra.this, "O sistema est\u00e1 configurado para movimentar estoque ao criar o pedido de compra.\nN\u00e3o \u00e9 poss\u00edvel editar os \u00edtens do pedido.", 2);
                        return;
                    }
                    int row = ((JTable)e.getSource()).getSelectedRow();
                    if (row >= 0) {
                        PedidoMaterialBean material = (PedidoMaterialBean)PedidoCompra.this.modeloMateriais.getValueAt(row, 6);
                        PedidoCompra.this.isAlterandoMaterial = true;
                        PedidoCompra.this.textMaterial.setText(String.valueOf(material.getMaterial().getCodigo()));
                        PedidoCompra.this.labelDescricaoMaterial.setText(material.getMaterial().getDescricao());
                        PedidoCompra.this.textUnitario.setText(Funcoes.formataDecimal(PedidoCompra.this.textUnitario.getMaskDecimal(), material.getValorUnitario()));
                        PedidoCompra.this.textQuantidade.setText(Funcoes.formataDecimal(material.getQuantidade()));
                        PedidoCompra.this.textDesconto.setText(Funcoes.formataDecimal(material.getValorDesconto()));
                        PedidoCompra.this.labelVlrTotal.setText(Funcoes.formataDecimal(material.getValorTotal()));
                        PedidoCompra.this.controlaCampos();
                        ScreenUtil.requisitarFoco(PedidoCompra.this.textUnitario);
                    }
                }
            }
        });
        this.modeloMateriais.setColumnSize(new int[]{60, 0, 90, 90, 100, 80}, this.tableMateriais);
        this.tableMateriais.getTableHeader().addMouseListener(this.modeloMateriais);
        this.scrollMateriais = new JScrollPane(this.tableMateriais);
        this.painelCentral.setLayout(new GridBagLayout());
        this.labelCodigo.setText("C\u00f3digo:");
        this.labelCodigo.setDisplayedMnemonic('g');
        this.labelCodigo.setLabelFor(this.textCodigo);
        this.painelCentral.add((Component)this.labelCodigo, new GridBagConstraints());
        this.textCodigo.setMinimumSize(new Dimension(70, 20));
        this.textCodigo.setPreferredSize(new Dimension(70, 20));
        this.painelCentral.add((Component)this.textCodigo, new GridBagConstraints());
        this.buttonCodigo.setFocusable(false);
        Funcoes.imagemPesquisa(this.buttonCodigo);
        this.buttonCodigo.setMinimumSize(new Dimension(20, 20));
        this.buttonCodigo.setPreferredSize(new Dimension(20, 20));
        this.painelCentral.add((Component)this.buttonCodigo, new GridBagConstraints());
        this.labelData.setText("Data:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        this.painelCentral.add((Component)this.labelData, gridBagConstraints);
        this.labelVlrData.setMinimumSize(new Dimension(150, 20));
        this.labelVlrData.setPreferredSize(new Dimension(150, 20));
        this.painelCentral.add((Component)this.labelVlrData, new GridBagConstraints());
        this.labelUsuario.setText("Usu\u00e1rio:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        this.painelCentral.add((Component)this.labelUsuario, gridBagConstraints);
        this.labelVlrUsuario.setMinimumSize(new Dimension(100, 20));
        this.labelVlrUsuario.setPreferredSize(new Dimension(100, 20));
        this.painelCentral.add((Component)this.labelVlrUsuario, new GridBagConstraints());
        this.panelMateriais.setBorder(BorderFactory.createTitledBorder("Materiais"));
        this.panelMateriais.setLayout(new GridBagLayout());
        this.labelMaterial.setText("Material:");
        this.labelMaterial.setDisplayedMnemonic('M');
        this.labelMaterial.setLabelFor(this.textMaterial);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.panelMateriais.add((Component)this.labelMaterial, gridBagConstraints);
        this.textMaterial.setMinimumSize(new Dimension(70, 20));
        this.textMaterial.setPreferredSize(new Dimension(70, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.panelMateriais.add((Component)this.textMaterial, gridBagConstraints);
        this.buttonMaterial.setMinimumSize(new Dimension(20, 20));
        this.buttonMaterial.setPreferredSize(new Dimension(20, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        this.panelMateriais.add((Component)this.buttonMaterial, gridBagConstraints);
        this.labelDescricaoMaterial.setMinimumSize(new Dimension(20, 20));
        this.labelDescricaoMaterial.setPreferredSize(new Dimension(20, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.panelMateriais.add((Component)this.labelDescricaoMaterial, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panelMateriais.add((Component)this.scrollMateriais, gridBagConstraints);
        this.panelMateriaisAux.setLayout(new GridBagLayout());
        this.labelUnitario.setText("Vlr. Unit\u00e1rio:");
        this.labelUnitario.setDisplayedMnemonic('U');
        this.labelUnitario.setLabelFor(this.textUnitario);
        this.panelMateriaisAux.add((Component)this.labelUnitario, new GridBagConstraints());
        this.textUnitario.setMinimumSize(new Dimension(70, 20));
        this.textUnitario.setPreferredSize(new Dimension(70, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.panelMateriaisAux.add((Component)this.textUnitario, gridBagConstraints);
        this.labelQuantidade.setText("Qtde.:");
        this.labelQuantidade.setDisplayedMnemonic('Q');
        this.labelQuantidade.setLabelFor(this.textQuantidade);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        this.panelMateriaisAux.add((Component)this.labelQuantidade, gridBagConstraints);
        this.textQuantidade.setMinimumSize(new Dimension(70, 20));
        this.textQuantidade.setPreferredSize(new Dimension(70, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        this.panelMateriaisAux.add((Component)this.textQuantidade, gridBagConstraints);
        this.labelDesconto.setText("Desconto:");
        this.labelDesconto.setDisplayedMnemonic('o');
        this.labelDesconto.setLabelFor(this.textDesconto);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        this.panelMateriaisAux.add((Component)this.labelDesconto, gridBagConstraints);
        this.textDesconto.setMinimumSize(new Dimension(70, 20));
        this.textDesconto.setPreferredSize(new Dimension(70, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        this.panelMateriaisAux.add((Component)this.textDesconto, gridBagConstraints);
        this.comboDesconto.setModel(new DefaultComboBoxModel<String>(new String[]{"$", "%"}));
        this.comboDesconto.setMinimumSize(new Dimension(40, 20));
        this.comboDesconto.setPreferredSize(new Dimension(40, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        this.panelMateriaisAux.add((Component)this.comboDesconto, gridBagConstraints);
        this.labelTotal.setText("Total:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        this.panelMateriaisAux.add((Component)this.labelTotal, gridBagConstraints);
        this.labelVlrTotal.setHorizontalAlignment(4);
        this.labelVlrTotal.setMinimumSize(new Dimension(70, 20));
        this.labelVlrTotal.setPreferredSize(new Dimension(70, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 0;
        this.panelMateriaisAux.add((Component)this.labelVlrTotal, gridBagConstraints);
        this.buttonOk.setMinimumSize(new Dimension(40, 20));
        this.buttonOk.setPreferredSize(new Dimension(40, 20));
        this.buttonOk.setMargin(new Insets(1, 1, 1, 1));
        this.buttonOk.setText("OK");
        this.buttonOk.setMnemonic('K');
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 0;
        this.panelMateriaisAux.add((Component)this.buttonOk, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.panelMateriaisAux.add((Component)this.labelAux2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.panelMateriais.add((Component)this.panelMateriaisAux, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 8;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.painelCentral.add((Component)this.panelMateriais, gridBagConstraints);
        this.panelDados.setLayout(new GridBagLayout());
        this.labelFornecedor.setText("Fornecedor:");
        this.labelFornecedor.setDisplayedMnemonic('r');
        this.labelFornecedor.setLabelFor(this.textFornecedor);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.panelDados.add((Component)this.labelFornecedor, gridBagConstraints);
        this.textFornecedor.setMinimumSize(new Dimension(70, 20));
        this.textFornecedor.setPreferredSize(new Dimension(70, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.panelDados.add((Component)this.textFornecedor, gridBagConstraints);
        this.buttonFornecedor.setFocusable(false);
        Funcoes.imagemPesquisa(this.buttonFornecedor);
        this.buttonFornecedor.setMinimumSize(new Dimension(20, 20));
        this.buttonFornecedor.setPreferredSize(new Dimension(20, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.panelDados.add((Component)this.buttonFornecedor, gridBagConstraints);
        this.buttonMaterial.setFocusable(false);
        Funcoes.imagemPesquisa(this.buttonMaterial);
        this.labelFantasiaFornecedor.setMinimumSize(new Dimension(20, 20));
        this.labelFantasiaFornecedor.setPreferredSize(new Dimension(20, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.panelDados.add((Component)this.labelFantasiaFornecedor, gridBagConstraints);
        this.labelVendedor.setText("Vendedor:");
        this.labelVendedor.setDisplayedMnemonic('V');
        this.labelVendedor.setLabelFor(this.textVendedor);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        this.panelDados.add((Component)this.labelVendedor, gridBagConstraints);
        this.textVendedor.setMinimumSize(new Dimension(150, 20));
        this.textVendedor.setPreferredSize(new Dimension(150, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.panelDados.add((Component)this.textVendedor, gridBagConstraints);
        this.labelFormaPagto.setText("Forma Pagto.:");
        this.labelFormaPagto.setDisplayedMnemonic('P');
        this.labelFormaPagto.setLabelFor(this.textFormaPagto);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.panelDados.add((Component)this.labelFormaPagto, gridBagConstraints);
        this.textFormaPagto.setMinimumSize(new Dimension(70, 20));
        this.textFormaPagto.setPreferredSize(new Dimension(70, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.panelDados.add((Component)this.textFormaPagto, gridBagConstraints);
        this.buttonFormaPagto.setFocusable(false);
        Funcoes.imagemPesquisa(this.buttonFormaPagto);
        this.buttonFormaPagto.setMinimumSize(new Dimension(20, 20));
        this.buttonFormaPagto.setPreferredSize(new Dimension(20, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.panelDados.add((Component)this.buttonFormaPagto, gridBagConstraints);
        this.labelDescricaoFormaPagto.setMinimumSize(new Dimension(20, 20));
        this.labelDescricaoFormaPagto.setPreferredSize(new Dimension(20, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.panelDados.add((Component)this.labelDescricaoFormaPagto, gridBagConstraints);
        this.labelCotacao.setText("Cota\u00e7\u00e3o:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        this.panelDados.add((Component)this.labelCotacao, gridBagConstraints);
        this.labelVlrCotacao.setMinimumSize(new Dimension(100, 20));
        this.labelVlrCotacao.setPreferredSize(new Dimension(100, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.panelDados.add((Component)this.labelVlrCotacao, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.painelCentral.add((Component)this.panelDados, gridBagConstraints);
        this.panelTotal.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.panelTotal.add((Component)this.labelAux1, gridBagConstraints);
        this.labelSubTotal.setText("Subtotal:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.panelTotal.add((Component)this.labelSubTotal, gridBagConstraints);
        this.labelVlrSubTotal.setHorizontalAlignment(4);
        this.labelVlrSubTotal.setMinimumSize(new Dimension(70, 20));
        this.labelVlrSubTotal.setPreferredSize(new Dimension(70, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        this.panelTotal.add((Component)this.labelVlrSubTotal, gridBagConstraints);
        this.labelFrete.setText("Frete:");
        this.labelFrete.setDisplayedMnemonic('t');
        this.labelFrete.setLabelFor(this.textFrete);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        this.panelTotal.add((Component)this.labelFrete, gridBagConstraints);
        this.textFrete.setMinimumSize(new Dimension(70, 20));
        this.textFrete.setPreferredSize(new Dimension(70, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        this.panelTotal.add((Component)this.textFrete, gridBagConstraints);
        this.labelDescontoTotal.setText("Desconto:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        this.panelTotal.add((Component)this.labelDescontoTotal, gridBagConstraints);
        this.textDescontoTotal.setMinimumSize(new Dimension(70, 20));
        this.textDescontoTotal.setPreferredSize(new Dimension(70, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        this.panelTotal.add((Component)this.textDescontoTotal, gridBagConstraints);
        this.comboDescontoTotal.setModel(new DefaultComboBoxModel<String>(new String[]{"$", "%"}));
        this.comboDescontoTotal.setMinimumSize(new Dimension(40, 20));
        this.comboDescontoTotal.setPreferredSize(new Dimension(40, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        this.panelTotal.add((Component)this.comboDescontoTotal, gridBagConstraints);
        this.labelTotalGeral.setText("Total Geral:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        this.panelTotal.add((Component)this.labelTotalGeral, gridBagConstraints);
        this.labelVlrTotalGeral.setHorizontalAlignment(4);
        this.labelVlrTotalGeral.setMinimumSize(new Dimension(90, 20));
        this.labelVlrTotalGeral.setPreferredSize(new Dimension(90, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 0;
        this.panelTotal.add((Component)this.labelVlrTotalGeral, gridBagConstraints);
        this.panelObservacao.setLayout(new GridBagLayout());
        this.labelObservacao.setText("Observa\u00e7\u00e3o:");
        this.labelObservacao.setDisplayedMnemonic('b');
        this.labelObservacao.setLabelFor(this.areaObservacao);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        this.panelObservacao.add((Component)this.labelObservacao, gridBagConstraints);
        this.areaObservacao.setRows(2);
        this.scrollObservacao.setMinimumSize(new Dimension(20, 40));
        this.scrollObservacao.setPreferredSize(new Dimension(20, 40));
        this.scrollObservacao.setViewportView(this.areaObservacao);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.panelObservacao.add((Component)this.scrollObservacao, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.panelTotal.add((Component)this.panelObservacao, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.painelCentral.add((Component)this.panelTotal, gridBagConstraints);
        this.montaPanelBotoes();
        Funcoes.defineUpperCase(this, ParametrosGerais.getUpperCase());
        this.controlaCampos();
        this.modeloMateriais.ordenarColuna(1);
    }

    private void preencheDadosCotacao(CotacaoBean cotacao) {
        this.novo();
        PedidoBean pedido = new PedidoBean();
        FilialVO filial = new FilialVO();
        filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
        pedido.setFilial(filial);
        pedido.setCotacao((CotacaoVO)cotacao.toVO());
        pedido.setDataHora(new Date());
        pedido.setCotacao((CotacaoVO)cotacao.toVO());
        for (CotacaoEntidadeBean entidade : cotacao.getEntidadesCotacao()) {
            if (!entidade.getSituacao().equalsIgnoreCase("V")) continue;
            pedido.setEntidade(entidade.getEntidade());
            pedido.setNomeVendedor(entidade.getVendedor());
            pedido.setPercentualDesconto(entidade.getPercentualDesconto());
            pedido.setValorDesconto(entidade.getValorDesconto());
            pedido.setValorTotal(entidade.getValorTotal());
            pedido.setFormaPagto(entidade.getFormaPagamento());
            pedido.setValorFrete(entidade.getValorFrete());
            ArrayList<PedidoParcelaBean> parcelas = new ArrayList<PedidoParcelaBean>();
            ArrayList<CotacaoEntidadeParcelaBean> cotacaoEntidade = entidade.getParcelas();
            if (cotacaoEntidade == null) break;
            for (int i = 0; i < cotacaoEntidade.size(); ++i) {
                CotacaoEntidadeParcelaBean parcelaEntidade = cotacaoEntidade.get(i);
                PedidoParcelaBean parcela = new PedidoParcelaBean();
                parcela.setCodigo(parcelaEntidade.getCodigo());
                parcela.setDataVencimento(parcelaEntidade.getDataVencimento());
                parcela.setDataVencimentoCalculada(parcelaEntidade.getDataVencimentoCalculada());
                parcela.setFilial(parcelaEntidade.getFilial());
                parcela.setValor(parcelaEntidade.getValor());
                parcela.setValorCalculado(parcelaEntidade.getValorCalculado());
                parcelas.add(parcela);
            }
            pedido.setParcelas(parcelas);
            break;
        }
        ArrayList<PedidoMaterialBean> materiaisPedido = new ArrayList<PedidoMaterialBean>();
        for (CotacaoMaterialEntidadeBean materialCot : cotacao.getMaterialEntidadeCotacao()) {
            if (materialCot.getCotacaoEntidade().getEntidade().getCodigo().intValue() != pedido.getEntidade().getCodigo().intValue()) continue;
            PedidoMaterialBean material = new PedidoMaterialBean();
            MaterialBean materialBean = null;
            try {
                materialBean = new MaterialService().getBean(filial.getCodigo().toString(), materialCot.getCotacaoMaterial().getMaterial().getCodigo().toString());
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar dados do material.\n" + e.getMessage(), e.getStackTrace());
                return;
            }
            material.setFilial(filial);
            material.setMaterial(materialBean);
            material.setPercentualDesconto(materialCot.getPercentualDesconto());
            material.setQuantidade(materialCot.getQuantidade());
            material.setValorDesconto(materialCot.getValorDesconto());
            material.setValorTotal(materialCot.getValorTotal());
            material.setValorUnitario(materialCot.getValorUnitario());
            if (ParametrosGerais.getTipoMovimentarEstoque().equalsIgnoreCase("P") && !this.isFinalizarCotacao) {
                try {
                    if (material.getMaterial().getSolicitarLote().booleanValue()) {
                        CelulaEstoqueVO celula = new CelulaEstoqueService().getCelulaPadraoVO(Variaveis.filialPadrao);
                        Double qtdeOriginal = material.getMaterial().getQuantidadeLotes(celula) - material.getMaterial().getQuantidadeConsumidaLotes(celula);
                        SolicitarLoteMaterial lote = new SolicitarLoteMaterial(Laboratorio.getInstancia(), material.getMaterial().getCodigo(), material.getMaterial().getDescricao(), material.getMaterial().getUnidadeMedida().getCodigo(), material.getMaterial().getFichaTecnica(), material.getMaterial().getLotes(), 0, qtdeOriginal, material.getQuantidade(), null, null, celula, false, null, false);
                        if (lote != null) {
                            lote.setVisible(true);
                            if (!lote.getOK()) continue;
                            material.getMaterial().setLotes(lote.getLotes());
                            Double qtde = 0.0;
                            if (material.getMaterial().getLotes() != null && !material.getMaterial().getLotes().isEmpty()) {
                                for (int i = 0; i < lote.getLotes().size(); ++i) {
                                    qtde = qtde + material.getMaterial().getLotes().get(i).getQuantidade();
                                }
                            }
                            material.getMaterial().setQuantidadeInformadaLotes(qtde);
                        }
                    }
                }
                catch (Exception e) {
                    ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar os dados do material (configurando lotes).\n" + e.getMessage(), e.getStackTrace());
                }
            }
            materiaisPedido.add(material);
        }
        pedido.setMateriais(materiaisPedido);
        pedido.setObservacao(cotacao.getObservacao());
        pedido.setUsuario(cotacao.getUsuario());
        this.novo();
        this.preencherCampos(pedido);
        this.pedidoAux = pedido;
        this.controlaCampos();
    }

    private void montaPanelBotoes() {
        JPanel panelImportar = new JPanel(new FlowLayout(0));
        this.buttonImportar.setMnemonic('I');
        panelImportar.add(this.buttonImportar);
        JPanel panelBotoesBasicos = new JPanel(new FlowLayout(2));
        panelBotoesBasicos.add(this.botaoNovo);
        panelBotoesBasicos.add(this.botaoEditar);
        panelBotoesBasicos.add(this.botaoSalvar);
        panelBotoesBasicos.add(this.botaoCancelar);
        panelBotoesBasicos.add(this.botaoExcluir);
        panelBotoesBasicos.add(this.botaoFechar);
        this.painelBotoes.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 2;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        this.painelBotoes.add((Component)panelImportar, c);
        ++c.gridx;
        this.painelBotoes.add((Component)panelBotoesBasicos, c);
    }

    private void calculaTotaisGerais() {
        BigDecimal somatorioValor = new BigDecimal("0").setScale(4, this.ROUND);
        for (int i = 0; i < this.modeloMateriais.getRowCount(); ++i) {
            PedidoMaterialBean aux = (PedidoMaterialBean)this.modeloMateriais.getValueAt(i, 6);
            if (aux == null) continue;
            somatorioValor = somatorioValor.add(new BigDecimal(aux.getValorTotal() == null ? "0" : aux.getValorTotal().toString()).setScale(4, this.ROUND));
        }
        this.labelVlrSubTotal.setText(Funcoes.formataDecimal("###,##0.00##", somatorioValor.setScale(4, this.ROUND).doubleValue()));
        if (this.comboDescontoTotal.getSelectedItem().equals("$")) {
            somatorioValor = somatorioValor.subtract(new BigDecimal(Funcoes.textoVazio(this.textDescontoTotal) ? "0" : this.textDescontoTotal.getText()));
        } else {
            BigDecimal desconto = somatorioValor.multiply(new BigDecimal(Funcoes.textoVazio(this.textDescontoTotal) ? "0" : this.textDescontoTotal.getText()).setScale(4, this.ROUND)).divide(new BigDecimal("100").setScale(4, this.ROUND), this.ROUND);
            somatorioValor = somatorioValor.subtract(desconto.setScale(4, this.ROUND));
        }
        somatorioValor = somatorioValor.add(new BigDecimal(Funcoes.textoVazio(this.textFrete) ? "0" : this.textFrete.getText()));
        this.labelVlrTotalGeral.setText(Funcoes.formataDecimal(somatorioValor.setScale(this.CASAS, this.ROUND).doubleValue()));
    }

    private boolean adicionaMaterial(PedidoMaterialBean material) {
        int posicaoAtualMaterial;
        block13: {
            posicaoAtualMaterial = -1;
            for (int i = 0; i < this.modeloMateriais.getRowCount(); ++i) {
                PedidoMaterialBean aux = (PedidoMaterialBean)this.modeloMateriais.getValueAt(i, 6);
                if (aux == null || aux.getMaterial().getCodigo().intValue() != material.getMaterial().getCodigo().intValue()) continue;
                if (!this.isAlterandoMaterial) {
                    Funcoes.mensagem(this, "Material j\u00e1 inserido.", 2);
                    ScreenUtil.requisitarFoco(this.textMaterial);
                    return false;
                }
                posicaoAtualMaterial = i;
                break;
            }
            if (this.materialAux == null && material.getMaterial() != null) {
                try {
                    this.materialAux = (MaterialBean)new MaterialService().getTodos(String.valueOf(material.getFilial().getCodigo()), String.valueOf(material.getMaterial().getCodigo()), null, this.pedidoAux != null ? (PedidoVO)this.pedidoAux.toVO() : null);
                }
                catch (Exception e1) {
                    ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar dados do material.\n" + e1.getMessage(), e1.getStackTrace());
                }
            }
            try {
                if (!ParametrosGerais.getTipoMovimentarEstoque().equalsIgnoreCase("P") || !this.materialAux.getSolicitarLote().booleanValue()) break block13;
                CelulaEstoqueVO celula = new CelulaEstoqueService().getCelulaPadraoVO(Variaveis.filialPadrao);
                Double qtdeOriginal = this.materialAux.getQuantidadeLotes(celula) - this.materialAux.getQuantidadeConsumidaLotes(celula);
                SolicitarLoteMaterial lote = new SolicitarLoteMaterial(Laboratorio.getInstancia(), this.materialAux.getCodigo(), this.materialAux.getDescricao(), this.materialAux.getUnidadeMedida().getCodigo(), this.materialAux.getFichaTecnica(), this.materialAux.getLotes(), 0, qtdeOriginal, material.getQuantidade(), null, null, celula, false, null, false);
                if (lote == null) break block13;
                lote.setVisible(true);
                if (lote.getOK()) {
                    this.materialAux.setLotes(lote.getLotes());
                    Double qtde = 0.0;
                    if (this.materialAux.getLotes() != null && !this.materialAux.getLotes().isEmpty()) {
                        for (int i = 0; i < lote.getLotes().size(); ++i) {
                            qtde = qtde + this.materialAux.getLotes().get(i).getQuantidade();
                        }
                    }
                    this.materialAux.setQuantidadeInformadaLotes(qtde);
                    break block13;
                }
                return false;
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar os dado do material (configurando lotes).\n" + e.getMessage(), e.getStackTrace());
            }
        }
        if (posicaoAtualMaterial > -1) {
            PedidoMaterialBean pedidoMatAnterior = (PedidoMaterialBean)this.modeloMateriais.getValueAt(posicaoAtualMaterial, 6);
            material.setAlterado(pedidoMatAnterior.getQuantidade().doubleValue() != material.getQuantidade().doubleValue());
            this.modeloMateriais.removeLine(posicaoAtualMaterial);
        }
        this.modeloMateriais.addLine(new Object[]{material.getMaterial().getCodigo(), material.getMaterial().getDescricao(), Funcoes.formataDecimal("###,##0.00##", material.getValorUnitario()), Funcoes.formataDecimal("###,##0.00##", material.getQuantidade()), Funcoes.formataDecimal("###,##0.00##", material.getValorDesconto()), Funcoes.formataDecimal("###,##0.00##", material.getValorTotal()), material});
        if (this.modeloMateriais.getColunaOrdenacao() != -1) {
            this.modeloMateriais.ordenarColunaSemTrocarSentido(this.modeloMateriais.getColunaOrdenacao());
        } else {
            this.modeloMateriais.ordenarColunaSemTrocarSentido(1);
        }
        this.isAlterandoMaterial = false;
        this.materialAux = null;
        this.controlaCampos();
        this.calculaTotaisGerais();
        return true;
    }

    private void calculaTotalMaterial() {
        if (this.materialAux != null) {
            BigDecimal total = new BigDecimal("0").setScale(4, this.ROUND);
            BigDecimal unitario = Funcoes.textoVazio(this.textUnitario) ? new BigDecimal("0") : new BigDecimal(Funcoes.limpaDecimal(this.textUnitario.getText()));
            unitario = unitario.setScale(4, this.ROUND);
            BigDecimal qtde = Funcoes.textoVazio(this.textQuantidade) ? new BigDecimal("0") : new BigDecimal(Funcoes.limpaDecimal(this.textQuantidade.getText()));
            qtde = qtde.setScale(4, this.ROUND);
            BigDecimal desconto = Funcoes.textoVazio(this.textDesconto) ? new BigDecimal("0") : new BigDecimal(Funcoes.limpaDecimal(this.textDesconto.getText()));
            desconto = desconto.setScale(4, this.ROUND);
            if (this.comboDesconto.getSelectedItem().equals("%")) {
                desconto = desconto.multiply(unitario).multiply(qtde).divide(new BigDecimal("100").setScale(4, this.ROUND), this.ROUND);
            }
            total = unitario.multiply(qtde).subtract(desconto);
            total = total.setScale(4, this.ROUND);
            this.labelVlrTotal.setText(Funcoes.formataDecimal("###,##0.00##", total.doubleValue()));
        }
    }

    @Override
    public void pressioneiF2() {
        if (this.textFornecedor.hasFocus()) {
            this.buttonFornecedor.doClick();
            ScreenUtil.requisitarFoco(this.textVendedor);
        } else if (this.textCodigo.hasFocus()) {
            this.buttonCodigo.doClick();
        } else if (this.textFormaPagto.hasFocus()) {
            this.buttonFormaPagto.doClick();
            ScreenUtil.requisitarFoco(this.textMaterial);
        } else if (this.textMaterial.hasFocus()) {
            this.buttonMaterial.doClick();
            ScreenUtil.requisitarFoco(this.textUnitario);
        }
    }

    @Override
    public void cancelar() {
        if (Funcoes.mensagem(this, "As informa\u00e7\u00f5es adicionadas ser\u00e3o perdidas.", 4) == 0) {
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    private void limparCampos() {
        this.textCodigo.setText("");
        this.labelVlrData.setText("");
        this.labelVlrUsuario.setText("");
        this.textFornecedor.setText("");
        this.labelFantasiaFornecedor.setText("");
        this.textVendedor.setText("");
        this.textFormaPagto.setText("");
        this.labelDescricaoFormaPagto.setText("");
        this.labelVlrCotacao.setText("");
        this.textMaterial.setText("");
        this.labelDescricaoMaterial.setText("");
        this.textUnitario.setText("");
        this.textQuantidade.setText("");
        this.textDesconto.setText("");
        this.comboDesconto.setSelectedIndex(0);
        this.labelVlrTotal.setText("");
        this.modeloMateriais.clear();
        this.labelVlrSubTotal.setText("");
        this.textDescontoTotal.setText("");
        this.labelVlrTotalGeral.setText("");
        this.textFrete.setText("");
        this.areaObservacao.setText("");
        this.pedidoAux = null;
        this.cotacaoAux = null;
        this.datahoraAux = null;
        this.fornecedorAux = null;
        this.formaPagtoAux = null;
        this.materialAux = null;
        this.cotacaoAux = null;
        this.isAlterandoMaterial = false;
        this.materiaisRemovidos = null;
    }

    private void controlaCampos() {
        boolean pedidoAutorizado = this.pedidoAux != null ? this.pedidoAux.getDataAutorizacao() != null : false;
        boolean habilitar = (this.getStatus() == 2 || this.getStatus() == 3) && !pedidoAutorizado;
        this.textCodigo.setEnabled(false);
        this.textFornecedor.setEnabled(habilitar);
        this.textVendedor.setEnabled(habilitar);
        this.textFormaPagto.setEnabled(habilitar);
        this.buttonCodigo.setEnabled(habilitar && this.pedidoAux == null);
        this.buttonFornecedor.setEnabled(habilitar);
        this.buttonFormaPagto.setEnabled(habilitar);
        this.textMaterial.setEnabled(habilitar && !this.isAlterandoMaterial);
        this.textUnitario.setEnabled(habilitar && this.materialAux != null);
        this.textQuantidade.setEnabled(habilitar && this.materialAux != null);
        this.textDesconto.setEnabled(habilitar && this.materialAux != null);
        this.comboDesconto.setEnabled(habilitar && this.materialAux != null);
        this.buttonMaterial.setEnabled(habilitar && !this.isAlterandoMaterial);
        this.buttonOk.setEnabled(habilitar && this.materialAux != null);
        this.tableMateriais.setEnabled(habilitar);
        this.comboDescontoTotal.setEnabled(habilitar);
        this.areaObservacao.setEnabled(habilitar);
        this.textDescontoTotal.setEnabled(habilitar);
        this.textFrete.setEnabled(habilitar);
        this.buttonImportar.setEnabled(this.getStatus() == 2);
        this.botaoSalvar.setEnabled(habilitar);
    }

    @Override
    public void editar() {
        this.limparCampos();
        this.textCodigo.setEnabled(true);
        this.buttonCodigo.setEnabled(true);
        this.materiaisRemovidos = new ArrayList();
        ScreenUtil.requisitarFoco(this.textCodigo);
        this.isFinalizarCotacao = false;
        this.buttonCodigo.doClick();
    }

    public void buscaPedido() {
        this.pedidoAux = this.pesquisar();
        if (this.pedidoAux != null) {
            this.setStatus(3);
            this.preencherCampos(this.pedidoAux);
            if (this.pedidoAux.getDataAutorizacao() != null) {
                this.controlaCampos();
                Funcoes.mensagem(this, "Pedido j\u00e1 est\u00e1 autorizado e n\u00e3o poder\u00e1 ser alterado. \n Autorizado por: " + this.pedidoAux.getUsuarioAutorizacao() + " em " + Funcoes.formataData("dd/MM/yyyy HH:mm", this.pedidoAux.getDataAutorizacao()) + ".", 2);
            }
            this.controlaCampos();
        }
    }

    private void preencherCampos(PedidoBean bean) {
        if (bean == null) {
            return;
        }
        ArrayList<PedidoLanctoEstoqueBean> lancamentosPedido = null;
        try {
            HashMap<String, Object> chaves = new HashMap<String, Object>();
            chaves.put("fil_codigo", bean.getFilial().getCodigo());
            chaves.put("ped_codigo", bean.getCodigo());
            lancamentosPedido = new PedidoLanctoEstoqueService().getBeans(chaves);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar os lan\u00e7amentos de estoque associados ao pedido de compra.\n" + e.getMessage(), e.getStackTrace());
            return;
        }
        this.textCodigo.setText(String.valueOf(bean.getCodigo()));
        this.labelVlrData.setText(bean.getDataHora() == null ? "" : Funcoes.formataData("dd/MM/yyyy HH:mm:ss", bean.getDataHora()));
        this.labelVlrUsuario.setText(bean.getUsuario() == null ? "" : bean.getUsuario().getCodigo());
        this.textFornecedor.setText(bean.getEntidade() == null ? "" : String.valueOf(bean.getEntidade().getCodigo()));
        this.labelFantasiaFornecedor.setText(bean.getEntidade() == null ? "" : bean.getEntidade().getFantasia());
        this.textVendedor.setText(bean.getNomeVendedor());
        this.textFormaPagto.setText(bean.getFormaPagto() == null ? "" : String.valueOf(bean.getFormaPagto().getCodigo()));
        this.labelDescricaoFormaPagto.setText(bean.getFormaPagto() == null ? "" : bean.getFormaPagto().getDescricao());
        this.labelVlrCotacao.setText(bean.getCotacao() == null ? "" : bean.getCotacao().getUsuario().getCodigo());
        this.comboDescontoTotal.setSelectedItem("$");
        this.textDescontoTotal.setText(Funcoes.formataDecimal(bean.getPercentualDesconto() == null ? 0.0 : bean.getPercentualDesconto()));
        this.labelVlrTotalGeral.setText(Funcoes.formataDecimal(bean.getValorTotal() == null ? 0.0 : bean.getValorTotal()));
        this.areaObservacao.setText(bean.getObservacao());
        this.textFrete.setText(Funcoes.formataDecimal(bean.getValorFrete() == null ? 0.0 : bean.getValorFrete()));
        BigDecimal subTotal = BigDecimal.ZERO;
        ArrayList<PedidoMaterialBean> lista = bean.getMateriais();
        for (int i = 0; i < lista.size(); ++i) {
            PedidoMaterialBean materialBean = lista.get(i);
            if (lancamentosPedido != null) {
                for (MaterialLoteBean matLoteBean : materialBean.getMaterial().getLotes()) {
                    block6: for (MaterialLoteLanctoEstoqueBean matLoteLanctoBean : matLoteBean.getLancamentosEstoque()) {
                        for (PedidoLanctoEstoqueBean pedidoLanctoBean : lancamentosPedido) {
                            LancamentoEstoqueVO lancto1 = pedidoLanctoBean.getLancamentoEstoque();
                            LancamentoEstoqueVO lancto2 = matLoteLanctoBean.getLancamento();
                            if (lancto1.getFilial().getCodigo().intValue() != lancto2.getFilial().getCodigo().intValue() || lancto1.getCodigo().intValue() != lancto2.getCodigo().intValue()) continue;
                            matLoteBean.setInserir(true);
                            continue block6;
                        }
                    }
                }
            }
            try {
                if (ParametrosGerais.getTipoMovimentarEstoque().equalsIgnoreCase("P") && this.isFinalizarCotacao && materialBean.getMaterial().getSolicitarLote().booleanValue()) {
                    CelulaEstoqueVO celula = new CelulaEstoqueService().getCelulaPadraoVO(Variaveis.filialPadrao);
                    Double qtdeOriginal = materialBean.getMaterial().getQuantidadeLotes(celula) - materialBean.getMaterial().getQuantidadeConsumidaLotes(celula);
                    SolicitarLoteMaterial lote = new SolicitarLoteMaterial(Laboratorio.getInstancia(), materialBean.getMaterial().getCodigo(), materialBean.getMaterial().getDescricao(), materialBean.getMaterial().getUnidadeMedida().getCodigo(), false, materialBean.getMaterial().getLotes(), 0, qtdeOriginal, materialBean.getQuantidade(), null, null, celula, false, null, false);
                    if (lote != null) {
                        lote.setVisible(true);
                        if (!lote.getOK()) continue;
                        materialBean.getMaterial().setLotes(lote.getLotes());
                        Double qtde = 0.0;
                        if (materialBean.getMaterial().getLotes() != null && !materialBean.getMaterial().getLotes().isEmpty()) {
                            for (int x = 0; x < lote.getLotes().size(); ++x) {
                                qtde = qtde + materialBean.getMaterial().getLotes().get(x).getQuantidade();
                            }
                        }
                        materialBean.getMaterial().setQuantidadeInformadaLotes(qtde);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel carregar os dados do material (configurando lotes).\n" + e.getMessage(), e.getStackTrace());
            }
            this.modeloMateriais.addLine(new Object[]{materialBean.getMaterial().getCodigo(), materialBean.getMaterial().getDescricao(), Funcoes.formataDecimal("###,##0.00##", materialBean.getValorUnitario()), Funcoes.formataDecimal("###,##0.00##", materialBean.getQuantidade()), Funcoes.formataDecimal("###,##0.00##", materialBean.getValorDesconto()), Funcoes.formataDecimal("###,##0.00##", materialBean.getValorTotal()), materialBean});
            subTotal = subTotal.add(new BigDecimal(materialBean.getValorTotal().toString()).setScale(4, this.ROUND));
        }
        this.labelVlrSubTotal.setText(Funcoes.formataDecimal(subTotal.doubleValue()));
        this.pedidoAux = bean;
        this.cotacaoAux = bean.getCotacao();
        this.datahoraAux = bean.getDataHora();
        this.fornecedorAux = bean.getEntidade();
        this.formaPagtoAux = bean.getFormaPagto();
    }

    private PedidoBean pesquisar() {
        try {
            PedidoBean pedido;
            String codigo = new PedidoService().pesquisaVO(this.getTopLevelAncestor(), null);
            if (codigo != null && (pedido = (PedidoBean)new PedidoDao().getBean(Variaveis.filialPadrao, codigo)) != null) {
                return pedido;
            }
        }
        catch (Exception e) {
            Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel carregar dados do pedido de compra.", 2);
        }
        return null;
    }

    @Override
    public void excluir() {
        int resp;
        PedidoBean pedido = null;
        PedidoService servicePedido = new PedidoService();
        String codigoPedido = servicePedido.pesquisaPedidoDisponivelNaoConferidoVO(Laboratorio.getInstancia(), new PedidoVO());
        try {
            if (!Funcoes.textoVazio(codigoPedido)) {
                pedido = (PedidoBean)servicePedido.get(codigoPedido);
            }
        }
        catch (Exception e2) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar dados do pedido de compra.\n" + e2.getMessage(), e2.getStackTrace());
            return;
        }
        if (pedido != null && (resp = Funcoes.mensagem(this, "Deseja realmente excluir o pedido de compra?", 4)) == 0) {
            try {
                new PedidoService().delete(pedido, pedido.getCodigo(), String.valueOf(pedido.getFilial().getCodigo()), null);
                Conexao.arquivaSQL();
            }
            catch (Exception e) {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel excluir o pedido de compra." + e.getMessage(), e.getStackTrace());
            }
        }
        this.limparCampos();
    }

    @Override
    public void fechar() {
        if (this.getStatus() == 1 || Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setVisible(false);
        }
    }

    public static long getModuloAcesso() {
        return Long.parseLong("1200200100");
    }

    @Override
    public void novo() {
        this.limparCampos();
        this.setStatus(2);
        this.controlaCampos();
        this.textCodigo.setEnabled(false);
        this.buttonCodigo.setEnabled(false);
        this.datahoraAux = new Date();
        this.labelVlrData.setText(Funcoes.formataData(this.datahoraAux) + " " + Funcoes.formataHora(this.datahoraAux, true));
        this.labelVlrUsuario.setText(Variaveis.login);
        ScreenUtil.requisitarFoco(this.textFornecedor);
    }

    @Override
    public void salvar() {
        PedidoBean bean;
        PedidoService service = new PedidoService();
        if (this.validaCampos() && (bean = this.getBeanPreenchido()) != null) {
            try {
                service.gravaAutoCopiaSemCommit(bean, this.getStatus() == 2 ? 0 : 1, Variaveis.filialPadrao, this.getCopiaFiliais());
                this.calculaParcelasCotacaoPedido(bean);
                this.retornoParaPesquisa = bean.getCodigo().toString();
                Conexao.arquivaSQL();
                this.limparCampos();
                this.setStatus(1);
                this.controlaCampos();
                Conexao.arquivaSQL();
            }
            catch (Exception e) {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel salvar o pedido de compra.\n" + e.getMessage(), e.getStackTrace());
            }
        }
    }

    private void calculaParcelasCotacaoPedido(PedidoBean pedido) throws Exception {
        CotacaoBean cotacaoBean;
        CotacaoService serviceCotacaobean = new CotacaoService();
        Boolean updateCotacao = false;
        CotacaoVO cot = pedido.getCotacao();
        CotacaoBean cotacaoBean2 = cotacaoBean = null != cot ? (CotacaoBean)serviceCotacaobean.get(cot.getCodigo().toString()) : null;
        if (null != cotacaoBean) {
            Set<CotacaoEntidadeBean> listaCotacaoEntidade = cotacaoBean.getEntidadesCotacao();
            for (CotacaoEntidadeBean cotEntidade : listaCotacaoEntidade) {
                if (cotEntidade.getFormaPagamento() == null || !cotEntidade.getSituacao().equalsIgnoreCase("V") || cotEntidade.getFormaPagamento().getCodigo().equals(pedido.getFormaPagto().getCodigo())) continue;
                cotEntidade.setFormaPagamento(pedido.getFormaPagto());
                cotEntidade.setParcelas(this.GerarParcelas(cotEntidade, pedido));
                updateCotacao = true;
            }
            if (updateCotacao.booleanValue()) {
                serviceCotacaobean.gravaAutoCopiaSemCommit(cotacaoBean, 1, Variaveis.filialPadrao, this.getCopiaFiliais());
            }
        }
    }

    private ArrayList<CotacaoEntidadeParcelaBean> GerarParcelas(CotacaoEntidadeBean cotEntidade, PedidoBean pedido) {
        Set setParcelas = null;
        Date dataInicial = new Date();
        ArrayList<CotacaoEntidadeParcelaBean> parcelasAux = null;
        try {
            setParcelas = new FormaPagamentoParcelaService().load(" where fil_codigo = " + Variaveis.filialPadrao + " and fpg_codigo = " + this.formaPagtoAux.getCodigo());
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "IncluirPrecos:DialogParcelas:gerarParcelas");
        }
        if (setParcelas != null) {
            ArrayList<ReceberPagarBean> parcelas = null;
            try {
                parcelas = FinanceiroUtil.gerarParcelas(pedido.getValorTotal(), pedido.getValorTotal(), 0.0, 0.0, 0.0, 0.0, 1, dataInicial, "P", setParcelas);
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "IncluirPreco:DialogParcelas:gerarParcelas");
            }
            if (parcelas != null && parcelas.size() > 0) {
                parcelasAux = new ArrayList<CotacaoEntidadeParcelaBean>();
                for (int i = 0; i < parcelas.size(); ++i) {
                    CotacaoEntidadeParcelaBean parcela = new CotacaoEntidadeParcelaBean();
                    parcela.setCodigo(parcelas.get(i).getParcela());
                    parcela.setDataVencimento(parcelas.get(i).getDataVencimento());
                    parcela.setDataVencimentoCalculada(parcelas.get(i).getDataVencimento());
                    parcela.setValor(parcelas.get(i).getValorTotal());
                    parcela.setValorCalculado(parcelas.get(i).getValorTotal());
                    parcelasAux.add(parcela);
                }
            }
        }
        return parcelasAux;
    }

    private PedidoBean getBeanPreenchido() {
        Double valorSub;
        PedidoBean pedido = null;
        pedido = this.pedidoAux == null ? new PedidoBean() : this.pedidoAux;
        FilialVO filial = new FilialVO();
        filial.setCodigo(Integer.valueOf(Variaveis.filialPadrao));
        UsuarioVO usuario = new UsuarioVO();
        usuario.setCodigo(Variaveis.login);
        pedido.setCotacao(this.cotacaoAux);
        pedido.setDataHora(this.datahoraAux);
        pedido.setEntidade(this.fornecedorAux);
        pedido.setFilial(filial);
        pedido.setFormaPagto(this.formaPagtoAux);
        pedido.setNomeVendedor(this.textVendedor.getText());
        pedido.setObservacao(this.areaObservacao.getText());
        pedido.setUsuario(usuario);
        pedido.setValorTotal(Double.valueOf(Funcoes.limpaDecimal(this.labelVlrTotalGeral.getText())));
        pedido.setValorFrete(Funcoes.textoVazio(this.textFrete) ? 0.0 : Double.valueOf(Funcoes.limpaDecimal(this.textFrete.getText())));
        String desconto = Funcoes.limpaDecimal(Funcoes.textoVazio(this.textDescontoTotal) ? "0" : this.textDescontoTotal.getText());
        if (this.comboDescontoTotal.getSelectedItem().equals("$")) {
            pedido.setValorDesconto(Double.valueOf(desconto));
            valorSub = Double.parseDouble(Funcoes.limpaDecimal(this.labelVlrSubTotal.getText()));
            pedido.setPercentualDesconto(valorSub == 0.0 ? 0.0 : pedido.getValorDesconto() * 100.0 / valorSub);
        } else {
            pedido.setPercentualDesconto(Double.valueOf(desconto));
            valorSub = Double.parseDouble(Funcoes.limpaDecimal(this.labelVlrSubTotal.getText()));
            pedido.setValorDesconto(pedido.getPercentualDesconto() * valorSub / 100.0);
        }
        ArrayList<PedidoMaterialBean> materiais = new ArrayList<PedidoMaterialBean>();
        for (int i = 0; i < this.modeloMateriais.getRowCount(); ++i) {
            PedidoMaterialBean material = (PedidoMaterialBean)this.modeloMateriais.getValueAt(i, 6);
            if (material == null) continue;
            materiais.add(material);
        }
        pedido.setMateriais(materiais);
        pedido.setMateriaisRemovidos(this.materiaisRemovidos);
        return pedido;
    }

    protected String getCopiaFiliais() {
        return null;
    }

    @Override
    public boolean validaCampos() {
        if (this.modeloMateriais.getRowCount() <= 0) {
            Funcoes.mensagem(this, "N\u00e3o h\u00e1 materiais no pedido de compra.", 2);
            return false;
        }
        return true;
    }

    @Override
    public String getRetornoParaPesquisa() {
        return this.retornoParaPesquisa;
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return "ped_codigo";
    }
}

