/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.estoque.pedido;

import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.estoque.pedido.ItemNotaFiscalEntradaDTO;
import jalis.laboratorio.estoque.pedido.NotaFiscalEntradaDTO;
import jalis.model.vo.cadastro.financeiro.SeriesVO;
import jalis.service.cadastro.financeiro.SeriesService;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLUtil;
import java.io.File;
import java.math.BigDecimal;
import java.util.List;
import javax.swing.text.MaskFormatter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ParserImportacaoNotaFiscalEntrada {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Document analisarXMLParaDoc(File arquivoXML, ErrorHandler error) {
        Document doc = null;
        try {
            doc = XMLUtil.analisarXML(arquivoXML, error);
            return doc;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel analisar o XML.\n" + e.getMessage(), e.getStackTrace());
        }
        finally {
            return doc;
        }
    }

    public static NotaFiscalEntradaDTO analisarXML(File arquivoXML) throws Exception {
        Element raiz;
        Document doc = ParserImportacaoNotaFiscalEntrada.analisarXMLParaDoc(arquivoXML, ParserImportacaoNotaFiscalEntrada.getErrorHandler());
        if (doc != null && (raiz = doc.getDocumentElement()).getNodeName().equalsIgnoreCase("nfeProc") && raiz.getAttribute("versao").equalsIgnoreCase("4.00")) {
            List<Element> elementosFilhos = XMLUtil.getElementosFilhos(raiz);
            for (Element element : elementosFilhos) {
                if (!element.getNodeName().equalsIgnoreCase("NFe")) continue;
                for (Element element2 : XMLUtil.getElementosFilhos(element)) {
                    if (!element2.getNodeName().equalsIgnoreCase("infNFe")) continue;
                    return ParserImportacaoNotaFiscalEntrada.parserDadosNotas(element2);
                }
            }
        }
        return null;
    }

    private static NotaFiscalEntradaDTO parserDadosNotas(Element element2) throws Exception {
        NotaFiscalEntradaDTO dto = new NotaFiscalEntradaDTO();
        boolean existeTagImposto = false;
        for (Element element3 : XMLUtil.getElementosFilhos(element2)) {
            if (element3.getNodeName().equalsIgnoreCase("ide")) {
                for (Element element : XMLUtil.getElementosFilhos(element3)) {
                    if (element.getNodeName().equalsIgnoreCase("serie")) {
                        SeriesService serviceSerie = new SeriesService();
                        SeriesVO serie = (SeriesVO)serviceSerie.getVO(Variaveis.filialPadrao, element.getFirstChild().getTextContent());
                        if (serie != null) {
                            dto.setSerie(element.getFirstChild().getTextContent());
                            continue;
                        }
                        Funcoes.mensagem(Laboratorio.getInstancia(), "S\u00e9rie n\u00e3o cadastrada. Opera\u00e7\u00e3o cancelada.", 1);
                        return null;
                    }
                    if (element.getNodeName().equalsIgnoreCase("nNF")) {
                        dto.setnNF(element.getFirstChild().getTextContent());
                        continue;
                    }
                    if (!element.getNodeName().equalsIgnoreCase("dhEmi")) continue;
                    dto.setDhEmi(ParserImportacaoNotaFiscalEntrada.getDataEmissao(element));
                }
                continue;
            }
            if (element3.getNodeName().equalsIgnoreCase("emit")) {
                for (Element element : XMLUtil.getElementosFilhos(element3)) {
                    if (!element.getNodeName().equalsIgnoreCase("CNPJ")) continue;
                    MaskFormatter mask = new MaskFormatter("##.###.###/####-##");
                    mask.setValueContainsLiteralCharacters(false);
                    dto.setCnpj(mask.valueToString(element.getFirstChild().getTextContent()));
                }
                continue;
            }
            if (element3.getNodeName().equals("det")) {
                ItemNotaFiscalEntradaDTO itemDto = new ItemNotaFiscalEntradaDTO();
                for (Element element42 : XMLUtil.getElementosFilhos(element3)) {
                    if (element42.getNodeName().equalsIgnoreCase("prod")) {
                        for (Element element5 : XMLUtil.getElementosFilhos(element42)) {
                            if (element5.getNodeName().equalsIgnoreCase("cProd")) {
                                itemDto.setcProd(element5.getFirstChild().getTextContent());
                                continue;
                            }
                            if (element5.getNodeName().equalsIgnoreCase("xProd")) {
                                itemDto.setDescricaoProduto(element5.getFirstChild().getTextContent());
                                continue;
                            }
                            if (element5.getNodeName().equalsIgnoreCase("qCom")) {
                                itemDto.setQuantidadeProduto(Double.valueOf(element5.getFirstChild().getTextContent()));
                                continue;
                            }
                            if (!element5.getNodeName().equalsIgnoreCase("vUnCom")) continue;
                            itemDto.setValorUnitario(Double.valueOf(element5.getFirstChild().getTextContent()));
                        }
                        continue;
                    }
                    if (!element42.getNodeName().equalsIgnoreCase("imposto")) continue;
                    existeTagImposto = true;
                    for (Element element5 : XMLUtil.getElementosFilhos(element42)) {
                        if (element5.getNodeName().equalsIgnoreCase("vTotTrib")) {
                            itemDto.setvTotTrib(new BigDecimal(element5.getFirstChild().getTextContent().replaceAll("\\n", "").trim()));
                            continue;
                        }
                        if (!element5.getNodeName().equalsIgnoreCase("ICMS")) continue;
                        for (Element element6 : XMLUtil.getElementosFilhos(element5)) {
                            if (!element6.getNodeName().equalsIgnoreCase("ICMS00")) continue;
                            for (Element element7 : XMLUtil.getElementosFilhos(element6)) {
                                if (element7.getNodeName().equalsIgnoreCase("vICMS")) {
                                    itemDto.setValorIcms(Double.valueOf(element7.getFirstChild().getTextContent()));
                                    continue;
                                }
                                if (!element7.getNodeName().equalsIgnoreCase("pICMS")) continue;
                                itemDto.setPercentualIcms(Double.valueOf(element7.getFirstChild().getTextContent()));
                            }
                        }
                    }
                }
                if (!existeTagImposto) {
                    Funcoes.mensagem(Laboratorio.getInstancia(), "O XML especificado est\u00e1 incorreto, faltando imposto.", 1);
                    return null;
                }
                if (StringUtil.isEmpty(itemDto.getcProd())) {
                    Funcoes.mensagem(Laboratorio.getInstancia(), "O XML especificado est\u00e1 incorreto, faltando cprod.", 1);
                    return null;
                }
                dto.getItens().add(itemDto);
                continue;
            }
            if (element3.getNodeName().equals("total")) {
                dto.setExisteTagTotal(true);
                for (Element element : XMLUtil.getElementosFilhos(element3)) {
                    if (!element.getNodeName().equals("ICMSTot")) continue;
                    for (Element element5 : XMLUtil.getElementosFilhos(element)) {
                        if (element5.getNodeName().equals("vIPI")) {
                            dto.setValorIPI(Double.valueOf(element5.getFirstChild().getTextContent()));
                            continue;
                        }
                        if (!element5.getNodeName().equals("vFrete")) continue;
                        dto.setValorFrete(Double.valueOf(element5.getFirstChild().getTextContent()));
                    }
                }
                continue;
            }
            if (!element3.getNodeName().equals("infAdic")) continue;
            for (Element element : XMLUtil.getElementosFilhos(element3)) {
                if (!element.getNodeName().equalsIgnoreCase("infCpl")) continue;
                dto.setObservacao(element.getFirstChild().getTextContent());
            }
        }
        if (ParserImportacaoNotaFiscalEntrada.validarInformacoesNotaFiscal(dto)) {
            return dto;
        }
        return null;
    }

    private static String getDataEmissao(Element element4) {
        String[] separaData = element4.getFirstChild().getTextContent().split("T");
        String[] data = separaData[0].split("-");
        String[] hora = separaData[1].split("-")[0].split(":");
        return data[2] + "/" + data[1] + "/" + data[0];
    }

    private static boolean validarInformacoesNotaFiscal(NotaFiscalEntradaDTO dto) {
        if (StringUtil.isEmpty(dto.getSerie())) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "S\u00e9rie n\u00e3o cadastrada. Opera\u00e7\u00e3o cancelada.", 1);
            return false;
        }
        if (StringUtil.isEmpty(dto.getnNF())) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00famero n\u00e3o cadastrado. Opera\u00e7\u00e3o cancelada.", 1);
            return false;
        }
        if (StringUtil.isEmpty(dto.getCnpj())) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "CNPJ do fornecedor n\u00e3o localizado. Opera\u00e7\u00e3o cancelada.", 1);
            return false;
        }
        if (dto.getDhEmi() == null) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "O XML especificado est\u00e1 incorreto. Est\u00e1 faltando informa\u00e7\u00e3o: Data de emiss\u00e3o.", 1);
            return false;
        }
        if (dto.getItens().isEmpty()) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "O XML especificado est\u00e1 incorreto. Est\u00e1 faltando informa\u00e7\u00e3o: Itens.", 1);
            return false;
        }
        if (!dto.isExisteTagTotal()) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "O XML especificado est\u00e1 incorreto. Est\u00e1 faltando informa\u00e7\u00e3o: Total.", 1);
            return false;
        }
        return true;
    }

    protected static ErrorHandler getErrorHandler() {
        return new ErrorHandler(){

            @Override
            public void error(SAXParseException exception) throws SAXException {
                Funcoes.mensagem(null, "O XML especificado est\u00e1 incorreto:\n" + exception.getMessage(), 1);
            }

            @Override
            public void fatalError(SAXParseException exception) throws SAXException {
                Funcoes.mensagem(null, "O XML especificado est\u00e1 incorreto:\n" + exception.getMessage(), 1);
            }

            @Override
            public void warning(SAXParseException exception) throws SAXException {
            }
        };
    }
}

