/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.estoque.pedido;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.comum.padroes.FrmCadPadrao;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.cadastro.VisualizarMateriaisAlternativos;
import jalis.laboratorio.cadastro.VisualizarPesquisaFornecedor;
import jalis.laboratorio.estoque.SolicitarLoteMaterial;
import jalis.laboratorio.estoque.pedido.InfoPerguntaPesquisaFornecedor;
import jalis.laboratorio.estoque.pedido.ItemNotaFiscalEntradaDTO;
import jalis.laboratorio.estoque.pedido.NotaFiscalEntradaDTO;
import jalis.laboratorio.estoque.pedido.ParserImportacaoNotaFiscalEntrada;
import jalis.laboratorio.financeiro.lancamentos.componente.BuscaBeanPreenchido;
import jalis.laboratorio.financeiro.lancamentos.componente.PanelPlanoContaCentroCusto;
import jalis.laboratorio.util.FinanceiroUtil;
import jalis.model.AbstractThreadBean;
import jalis.model.bean.cadastro.EntidadeBean;
import jalis.model.bean.estoque.MaterialBean;
import jalis.model.bean.estoque.MaterialLoteBean;
import jalis.model.bean.estoque.NotaFiscalMaterialBean;
import jalis.model.bean.estoque.PedidoBean;
import jalis.model.bean.estoque.PedidoMaterialBean;
import jalis.model.bean.estoque.PedidoParcelaBean;
import jalis.model.bean.financeiro.NotaFiscalBean;
import jalis.model.bean.financeiro.ReceberPagarBean;
import jalis.model.dao.estoque.MaterialDao;
import jalis.model.dao.estoque.PedidoDao;
import jalis.model.dao.financeiro.NotaFiscalDao;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.EntidadeVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.model.vo.cadastro.financeiro.FormaPagamentoVO;
import jalis.model.vo.cadastro.financeiro.SeriesVO;
import jalis.model.vo.estoque.CelulaEstoqueVO;
import jalis.model.vo.estoque.MaterialVO;
import jalis.model.vo.estoque.NotaFiscalLanctoEstoqueVO;
import jalis.model.vo.estoque.PedidoVO;
import jalis.model.vo.financeiro.NotaFiscalVO;
import jalis.service.cadastro.EntidadeService;
import jalis.service.cadastro.financeiro.CentroCustoService;
import jalis.service.cadastro.financeiro.FormaPagamentoParcelaService;
import jalis.service.cadastro.financeiro.FormaPagamentoService;
import jalis.service.cadastro.financeiro.PlanoContaService;
import jalis.service.cadastro.financeiro.SeriesService;
import jalis.service.estoque.CelulaEstoqueService;
import jalis.service.estoque.ConferenciaEntradaService;
import jalis.service.estoque.MaterialAlternativoService;
import jalis.service.estoque.MaterialService;
import jalis.service.estoque.NotaFiscalLanctoEstoqueService;
import jalis.service.estoque.PedidoService;
import jalis.service.estoque.TelaPesquisaMateriais;
import jalis.service.financeiro.NotaFiscalService;
import jalis.service.financeiro.ReceberPagarService;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextAreaDocument;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.file.Files;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;

public class NotaFiscalEntrada
extends FrmCadPadrao
implements ActionListener,
FocusListener {
    private boolean isImportacaoNota = false;
    private String registroSelecionado = "";
    private final int COLUNA_PARCELA_PARCELA = 0;
    private final int COLUNA_PARCELA_VENCIMENTO = 1;
    private final int COLUNA_PARCELA_VALOR = 2;
    private final int COLUNA_PARCELA_BEAN = 3;
    private static final long ACESSO_ALTERAR_PARCELAMENTO = Long.parseLong("1200200302");
    private static final long ACESSO_ALTERAR_FORMA_PAGAMENTO = Long.parseLong("1200200303");
    private static final long ACESSO_ALTERAR_PLANO_CONTAS_CENTRO_CUSTO_PARCELAS = Long.parseLong("1200200304");
    private static final long ACESSO_CANCELAR_PESQUISA_FORNECEDOR = Long.parseLong("1200200305");
    private static final long ACESSO_IMPORTAR_NOTA_FISCAL_ENTRADA = Long.parseLong("1200200306");
    private JButton buttonOpcoes = new JButton("Op\u00e7\u00f5es \u25bc");
    private JButton buttonBuscaSerie = ComponenteFactory.novoJButton(this, true);
    private JButton buttonBuscaDataEmissao = ComponenteFactory.novoJButton(this, true);
    private JButton buttonBuscaCadastro = ComponenteFactory.novoJButton(this, true);
    private JButton buttonImpostos = ComponenteFactory.novoJButton("Impostos >>", 'm', this);
    private JButton buttonBuscaMaterial = ComponenteFactory.novoJButton(this, true);
    private JButton buttonOKMaterial = ComponenteFactory.novoJButton("OK", this);
    private JButton buttonBuscaForma = ComponenteFactory.novoJButton(this, true);
    private JButton buttonBuscaDataParcela = ComponenteFactory.novoJButton(this, true);
    private JButton buttonOKParcela = ComponenteFactory.novoJButton("OK", this);
    private JButton buttonRateioFrete = ComponenteFactory.novoJButton("\u00f7", this);
    private final JPopupMenu menuOpcoes = new JPopupMenu();
    private final JMenuItem itemImportarNotaFiscalEntrada = ComponenteFactory.novoJMenuItem(this.menuOpcoes, "Importar Nota Fiscal de Entrada", (ActionListener)this);
    private final JMenuItem itemImportarPedidoCompra = ComponenteFactory.novoJMenuItem(this.menuOpcoes, "Importar pedido de compra", (ActionListener)this);
    private final JMenuItem itemVisualizaPesquisaFornecedor = ComponenteFactory.novoJMenuItem(this.menuOpcoes, "Visualizar hist\u00f3rico de pesquisa", (ActionListener)this);
    private TTextField textCodigoSerie = new TTextField(2);
    private TTextField textNumero = new TTextField(8, 1);
    private TTextField textDataEmissao = new TTextField(10, 4);
    private TTextField textCodigoCadastro = new TTextField(8, 1);
    private TTextField textDescontoNota = new TTextField(8, 2);
    private TTextField textValorMaterial = new TTextField(10, 2);
    private TTextField textCodigoForma = new TTextField(5, 1);
    private TTextField textParcela = new TTextField(3, 1);
    private TTextField textDataParcela = new TTextField(10, 4);
    private TTextField textValorParcela = new TTextField(10, 2);
    private TTextField textValorDesconto;
    private TTextField textIcms;
    private TTextField textIpi;
    private TTextField textMaterial = new TTextField(18, 3);
    private TTextField textQuantidade;
    private TTextField textUnitario;
    private TTextField textFrete = new TTextField(10, 2);
    private JLabel labelSerie = ComponenteFactory.novoJLabel("S\u00e9rie:", 'r', null, this.textCodigoSerie);
    private JLabel labelDescSerie = new JLabel();
    private JLabel labelDataHora = new JLabel();
    private JLabel labelNumero = ComponenteFactory.novoJLabel("N\u00famero:", 'e', null, this.textNumero);
    private JLabel labelDataEmissao = ComponenteFactory.novoJLabel("Data emiss\u00e3o:", 'a', null, this.textDataEmissao);
    private JLabel labelFornecedor = ComponenteFactory.novoJLabel("Fornecedor:", 'o', null, this.textCodigoCadastro);
    private JLabel labelCadastro = new JLabel();
    private JLabel labelDescontoNota = new JLabel("Desconto:");
    private JLabel labelSubTotalNota = new JLabel("Subtotal:");
    private JLabel labelVlrSubTotalNota = new JLabel();
    private JLabel labelVlrTotal = ComponenteFactory.novoJLabel("", new Dimension(80, 20), new TitledBorder(""));
    private JLabel labelForma = ComponenteFactory.novoJLabel("Forma Pagto:", 'g', null, this.textCodigoForma);
    private JLabel labelDescForma = new JLabel();
    private JLabel labelParcela = new JLabel("Parcela");
    private JLabel labelVencimentoParcela = new JLabel("Vencimento");
    private JLabel labelValorParcela = new JLabel("Valor");
    private JLabel labelValorDesconto = new JLabel("Vlr. Desc.");
    private JLabel labelTotalIpi = new JLabel("Total Ipi:");
    private JLabel labelTotalIcms = new JLabel("Total Icms:");
    private JLabel labelVlrTotalIpi = new JLabel();
    private JLabel labelVlrTotalIcms = new JLabel();
    private JLabel labelAux;
    private JLabel labelDescricaoMaterial = new JLabel();
    private JLabel labelIcms;
    private JLabel labelIpi;
    private JLabel labelMaterial;
    private JLabel labelQuantidade;
    private JLabel labelUnitario;
    private JLabel labelVlrTotalMaterial = new JLabel();
    private JLabel labelTotalMaterial;
    private JLabel labelTotal = new JLabel("Total:");
    private JLabel labelFrete = ComponenteFactory.novoJLabel("Frete:", 't', null, this.textFrete);
    private JComboBox comboDesconto = new JComboBox<String>(new String[]{"$", "%"});
    private JComboBox comboIpi = new JComboBox<String>(new String[]{"$", "%"});
    private JComboBox comboIcms = new JComboBox<String>(new String[]{"$", "%"});
    private JTextArea textObs = new JTextArea(new TTextAreaDocument(1000));
    private JPopupMenu pop = new JPopupMenu();
    private JPopupMenu popMaterial = new JPopupMenu();
    private JPanel panelMateriais = ComponenteFactory.novoJPanel(new GridBagLayout(), new TitledBorder("Materiais"));
    private JPanel panelMaterial1;
    private JPanel panelMaterial2;
    private ModeloGridTable modeloMateriais = null;
    private ModeloGridTable modeloParcela = null;
    private JTable tableMateriais = null;
    private JTable tableParcela = null;
    private JMenuItem itemParcela = ComponenteFactory.novoJMenuItem(this.pop, "Editar parcela", (ActionListener)this);
    private JMenuItem itemPlano = ComponenteFactory.novoJMenuItem(this.pop, "Editar plano de contas/centro de custos", (ActionListener)this);
    private JMenuItem itemEditarMaterial = ComponenteFactory.novoJMenuItem(this.popMaterial, "Editar", (ActionListener)this);
    private JMenuItem itemVisualizarLote = ComponenteFactory.novoJMenuItem(this.popMaterial, "Visualizar Lotes", (ActionListener)this);
    private JPopupMenu menuFrete = new JPopupMenu();
    private JMenuItem itemPrimeiraParcela = ComponenteFactory.novoJMenuItem(this.menuFrete, "Primeira Parcela (\u25b2)", (ActionListener)this);
    private JMenuItem itemRateioParcelas = ComponenteFactory.novoJMenuItem(this.menuFrete, "Rateio entre Parcelas (\u00f7)", (ActionListener)this);
    private JMenuItem itemUltimaParcela = ComponenteFactory.novoJMenuItem(this.menuFrete, "\u00daltima parcela (\u25bc)", (ActionListener)this);
    private AbstractThreadVO cadastroVO = null;
    private MaterialBean materialAux = null;
    private boolean isAlterandoMaterial = false;
    private NotaFiscalBean notaFiscalAux = null;
    private PedidoBean pedidoAux = null;
    private EntidadeService serviceEntidade = new EntidadeService();
    private SeriesService serviceSerie = new SeriesService();
    private FormaPagamentoService serviceFormaPagamento = new FormaPagamentoService();
    private FormaPagamentoParcelaService serviceFormaPagamentoParcela = new FormaPagamentoParcelaService();
    private int tipoFrete = -1;
    private boolean notaMovimentouEstoque = false;
    private boolean conferenciaMovimentouEstoque = false;
    private ArrayList<MaterialBean> materiaisExcluidos = new ArrayList();
    private String retornoParaPesquisa = "";
    private static final int CASAS_MAIOR = 4;
    private static final int CASAS = ParametrosGerais.getCasasPrecoExame();
    private static final RoundingMode ROUND = ParametrosGerais.getArredondamentoPrecoExame();
    private boolean alterarOrdemCamposNota = ParametrosLocais.isTrue("alteraPreenchimentoTelaNotaFiscalEntrada");
    private final int COLUNA_ORDEM = 0;
    private final int COLUNA_MATERIAL = 1;
    private final int COLUNA_VALOR_UNITARIO = this.alterarOrdemCamposNota ? 3 : 2;
    private final int COLUNA_QUANTIDADE = this.alterarOrdemCamposNota ? 2 : 3;
    private final int COLUNA_DESCRICAO = 4;
    private final int COLUNA_VALOR_IPI = this.alterarOrdemCamposNota ? 7 : 5;
    private final int COLUNA_PERC_IPI = this.alterarOrdemCamposNota ? 8 : 6;
    private final int COLUNA_VALOR_ICMS = this.alterarOrdemCamposNota ? 5 : 7;
    private final int COLUNA_PERC_ICMS = this.alterarOrdemCamposNota ? 6 : 8;
    private final int COLUNA_VALOR = 9;
    private final int COLUNA_OBJETO = 10;
    private final int COLUNA_OBJETO_MATERIAL = 11;
    private final int COLUNA_MARCA_MATERIAL_NOVO = 12;
    private static final int PARCELA_PARCELA = 0;
    private static final int PARCELA_VENCIMENTO = 1;
    private static final int PARCELA_VALOR_TOTAL = 2;
    private static final int PARCELA_OBJETO = 3;
    private String serieRepetidaAux = null;
    private String numeroRepetidoAux = null;
    private String codigoFornecedorAux = null;
    private boolean isImportandoPedido = false;
    private boolean isNotaImportada = false;
    private int registro = 0;
    private List<String> codigosMateriais = new ArrayList<String>();
    private byte[] byteArquivoImportacao;

    public static long getModuloAcesso() {
        return Long.parseLong("1200200300");
    }

    public static long getAcessoCancelarPesquisaFornecedor() {
        return ACESSO_CANCELAR_PESQUISA_FORNECEDOR;
    }

    public static long getAcessoPermiteImportarNotaFiscalEntrada() {
        return ACESSO_IMPORTAR_NOTA_FISCAL_ENTRADA;
    }

    public NotaFiscalEntrada() {
        Funcoes.montaEnter((JComponent)this);
        Funcoes.criaBarraDescricao(this, "Nota Fiscal de Entrada", "Preenchimento de notas fiscais de entrada", "estoque/nota_fiscal_entrada.jpg");
        ScreenUtil.setBorda(new Component[]{this.labelDescSerie, this.labelDataHora, this.labelCadastro, this.labelDescForma, this.labelDescricaoMaterial, this.labelVlrTotalMaterial, this.labelVlrSubTotalNota, this.labelVlrTotalIpi, this.labelVlrTotalIcms}, new TitledBorder(""));
        if (!Acesso.getAcesso(ACESSO_ALTERAR_PARCELAMENTO)) {
            this.pop.remove(this.itemParcela);
        }
        try {
            if (!Acesso.getAcesso(ACESSO_ALTERAR_PLANO_CONTAS_CENTRO_CUSTO_PARCELAS) || !new PlanoContaService().haPlanosContas(Variaveis.filialPadrao) && !new CentroCustoService().haCentrosCusto(Variaveis.filialPadrao)) {
                this.pop.remove(this.itemPlano);
            }
        }
        catch (SQLException ex) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar informa\u00e7\u00f5es sobre plano de contas e centro de custo.", ex.getStackTrace());
        }
        this.itemImportarNotaFiscalEntrada.setVisible(Acesso.getAcesso(ACESSO_IMPORTAR_NOTA_FISCAL_ENTRADA));
        this.tipoFrete = 1;
        this.modeloMateriais = new ModeloGridTable(this.montaColunas()){

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return super.getColumnClass(columnIndex);
            }

            @Override
            public void fireTableStructureChanged() {
                super.fireTableStructureChanged();
                try {
                    if (NotaFiscalEntrada.this.tableMateriais != null) {
                        NotaFiscalEntrada.this.tableMateriais.removeColumn(NotaFiscalEntrada.this.tableMateriais.getColumn("Objeto"));
                        NotaFiscalEntrada.this.tableMateriais.removeColumn(NotaFiscalEntrada.this.tableMateriais.getColumn("ObjetoMaterial"));
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                try {
                    NotaFiscalEntrada.this.tableMateriais.removeColumn(NotaFiscalEntrada.this.tableMateriais.getColumn("Objeto"));
                    NotaFiscalEntrada.this.tableMateriais.removeColumn(NotaFiscalEntrada.this.tableMateriais.getColumn("ObjetoMaterial"));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        };
        this.tableMateriais = new JTable(this.modeloMateriais);
        this.tableMateriais.getTableHeader().addMouseListener(this.modeloMateriais);
        this.modeloParcela = new ModeloGridTable(new String[]{"Parcela", "Vencimento", "Valor Total", "Objeto"}){

            @Override
            public void fireTableStructureChanged() {
                super.fireTableStructureChanged();
                try {
                    if (NotaFiscalEntrada.this.modeloParcela != null) {
                        NotaFiscalEntrada.this.tableParcela.removeColumn(NotaFiscalEntrada.this.tableParcela.getColumn("Objeto"));
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                try {
                    NotaFiscalEntrada.this.tableParcela.removeColumn(NotaFiscalEntrada.this.tableParcela.getColumn("Objeto"));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        };
        this.tableParcela = new JTable(this.modeloParcela);
        this.tableParcela.getTableHeader().addMouseListener(this.modeloParcela);
        if (!this.alterarOrdemCamposNota) {
            this.modeloMateriais.setColumnSize(new int[]{25, 0, 80, 55, 70, 70, 60, 75, 60, 80, 0, 0}, this.tableMateriais);
        } else {
            this.modeloMateriais.setColumnSize(new int[]{25, 0, 55, 80, 70, 75, 60, 70, 60, 80, 0, 0}, this.tableMateriais);
        }
        this.modeloParcela.setColumnSize(new int[]{70, 0, 0, 0}, this.tableParcela);
        this.textCodigoSerie.setUpperCase(true);
        this.tableMateriais.removeColumn(this.tableMateriais.getColumn("Objeto"));
        this.tableMateriais.removeColumn(this.tableMateriais.getColumn("ObjetoMaterial"));
        this.tableParcela.removeColumn(this.tableParcela.getColumn("Objeto"));
        this.tableParcela.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 32) {
                    if ((Acesso.getAcesso(ACESSO_ALTERAR_PARCELAMENTO) || Acesso.getAcesso(ACESSO_ALTERAR_PLANO_CONTAS_CENTRO_CUSTO_PARCELAS)) && NotaFiscalEntrada.this.tableParcela.getSelectedRow() > -1) {
                        int x = NotaFiscalEntrada.this.tableParcela.getColumnModel().getColumn(NotaFiscalEntrada.this.tableParcela.getSelectedColumn()).getWidth();
                        int y = NotaFiscalEntrada.this.tableParcela.getSelectedRow() * 18;
                        NotaFiscalEntrada.this.pop.show(NotaFiscalEntrada.this.tableParcela, x, y);
                    }
                } else if (e.getKeyCode() == 127) {
                    Funcoes.mensagem(NotaFiscalEntrada.this, "N\u00e3o \u00e9 poss\u00edvel excluir parcelas. Para alterar \no parcelamento, altere a forma de pagamento.", 2);
                }
            }
        });
        this.tableParcela.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && (Acesso.getAcesso(ACESSO_ALTERAR_PARCELAMENTO) || Acesso.getAcesso(ACESSO_ALTERAR_PLANO_CONTAS_CENTRO_CUSTO_PARCELAS)) && NotaFiscalEntrada.this.tableParcela.getSelectedRow() > -1) {
                    int x = NotaFiscalEntrada.this.tableParcela.getColumnModel().getColumn(NotaFiscalEntrada.this.tableParcela.getSelectedColumn()).getWidth();
                    int y = NotaFiscalEntrada.this.tableParcela.getSelectedRow() * 18;
                    NotaFiscalEntrada.this.pop.show(NotaFiscalEntrada.this.tableParcela, x, y);
                }
            }
        });
        this.tableMateriais.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 32) {
                    int row = NotaFiscalEntrada.this.tableMateriais.getSelectedRow();
                    MaterialBean bean = null;
                    if (row >= 0) {
                        bean = (MaterialBean)NotaFiscalEntrada.this.modeloMateriais.getValueAt(row, 11);
                    }
                    if (bean != null && bean.getSolicitarLote().booleanValue() && (ParametrosGerais.getTipoMovimentarEstoque().equalsIgnoreCase("N") || NotaFiscalEntrada.this.notaMovimentouEstoque || NotaFiscalEntrada.this.conferenciaMovimentouEstoque)) {
                        int x = NotaFiscalEntrada.this.tableMateriais.getColumnModel().getColumn(NotaFiscalEntrada.this.tableMateriais.getSelectedColumn()).getWidth();
                        int y = NotaFiscalEntrada.this.tableMateriais.getSelectedRow() * 18;
                        NotaFiscalEntrada.this.popMaterial.show(NotaFiscalEntrada.this.tableMateriais, x, y);
                    } else {
                        NotaFiscalEntrada.this.editarMaterial();
                    }
                } else if (e.getKeyCode() == 127 && NotaFiscalEntrada.this.tableMateriais.getSelectedRow() > -1 && !NotaFiscalEntrada.this.isImportacaoNota) {
                    int row = NotaFiscalEntrada.this.tableMateriais.getSelectedRow();
                    boolean isMaterialNovo = false;
                    if (row >= 0) {
                        isMaterialNovo = (Boolean)NotaFiscalEntrada.this.modeloMateriais.getValueAt(row, 12);
                    }
                    if (isMaterialNovo || !isMaterialNovo && !NotaFiscalEntrada.this.notaMovimentouEstoque && !NotaFiscalEntrada.this.conferenciaMovimentouEstoque) {
                        if (Funcoes.mensagem(NotaFiscalEntrada.this, "Deseja excluir o registro selecionado?", 4) == 0) {
                            NotaFiscalEntrada.this.materiaisExcluidos.add((MaterialBean)NotaFiscalEntrada.this.modeloMateriais.getValueAt(row, 11));
                            NotaFiscalEntrada.this.modeloMateriais.removeLine(NotaFiscalEntrada.this.tableMateriais.getSelectedRow());
                            try {
                                NotaFiscalEntrada.this.calcularParcelasAutomatico();
                            }
                            catch (Exception e1) {
                                ErrorLogger.mostraMensagem(NotaFiscalEntrada.this, "N\u00e3o foi poss\u00edvel calcular as parcelas.\n" + e1.getMessage(), e1.getStackTrace());
                            }
                        }
                    } else if (NotaFiscalEntrada.this.notaMovimentouEstoque) {
                        Funcoes.mensagem(NotaFiscalEntrada.this, "A nota fiscal de entrada movimentou estoque.\nN\u00e3o \u00e9 poss\u00edvel remover os \u00edtens.", 2);
                    } else {
                        Funcoes.mensagem(NotaFiscalEntrada.this, "A confer\u00eancia de entrada da nota fiscal de entrada movimentou estoque.\nN\u00e3o \u00e9 poss\u00edvel remover os \u00edtens.", 2);
                    }
                    NotaFiscalEntrada.this.aplicaNovaSequencia();
                }
                NotaFiscalEntrada.this.calculaTotais();
            }
        });
        this.tableMateriais.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (NotaFiscalEntrada.this.isAlterandoMaterial) {
                    NotaFiscalEntrada.this.textMaterial.setText("");
                    NotaFiscalEntrada.this.labelDescricaoMaterial.setText("");
                    NotaFiscalEntrada.this.textUnitario.setText("");
                    NotaFiscalEntrada.this.textQuantidade.setText("");
                    NotaFiscalEntrada.this.textIpi.setText("");
                    NotaFiscalEntrada.this.textIcms.setText("");
                    NotaFiscalEntrada.this.isAlterandoMaterial = false;
                    NotaFiscalEntrada.this.controlaCampos();
                }
                if (e.getClickCount() == 2) {
                    if (ParametrosGerais.getTipoMovimentarEstoque().equalsIgnoreCase("N")) {
                        Funcoes.mensagem(NotaFiscalEntrada.this, "O sistema est\u00e1 configurado para movimentar estoque ao criar a nota fiscal de entrada.\nN\u00e3o \u00e9 poss\u00edvel editar os \u00edtens da nota fiscal de entrada.", 2);
                        return;
                    }
                    int row = ((JTable)e.getSource()).getSelectedRow();
                    if (row >= 0) {
                        NotaFiscalMaterialBean material = (NotaFiscalMaterialBean)NotaFiscalEntrada.this.modeloMateriais.getValueAt(row, 10);
                        NotaFiscalEntrada.this.isAlterandoMaterial = true;
                        NotaFiscalEntrada.this.materialAux = (MaterialBean)NotaFiscalEntrada.this.modeloMateriais.getValueAt(row, 11);
                        NotaFiscalEntrada.this.textMaterial.setText(String.valueOf(material.getMaterial().getCodigo()));
                        NotaFiscalEntrada.this.labelDescricaoMaterial.setText(material.getMaterial().getDescricao());
                        NotaFiscalEntrada.this.textUnitario.setText(Funcoes.formataDecimal("#,##0.0000", material.getValorUnitario()));
                        NotaFiscalEntrada.this.textQuantidade.setText(Funcoes.formataDecimal(material.getQuantidade()));
                        NotaFiscalEntrada.this.textIcms.setText(Funcoes.formataDecimal("#,##0.00##", material.getValorIcms()));
                        NotaFiscalEntrada.this.textIpi.setText(Funcoes.formataDecimal("#,##0.00##", material.getValorIpi()));
                        NotaFiscalEntrada.this.textValorDesconto.setText(Funcoes.formataDecimal(material.getValorDesconto()));
                        NotaFiscalEntrada.this.labelVlrTotalMaterial.setText(Funcoes.formataDecimal("#,##0.00##", material.getValorTotal()));
                        NotaFiscalEntrada.this.comboIpi.setSelectedItem("$");
                        NotaFiscalEntrada.this.comboIcms.setSelectedItem("$");
                        NotaFiscalEntrada.this.controlaCampos();
                        if (NotaFiscalEntrada.this.textMaterial.isFocusable() && NotaFiscalEntrada.this.textMaterial.isEnabled()) {
                            NotaFiscalEntrada.this.textMaterial.grabFocus();
                        }
                    }
                }
            }
        });
        this.textCodigoSerie.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    NotaFiscalEntrada.this.pesquisaSerie();
                }
            }
        });
        this.textCodigoForma.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    NotaFiscalEntrada.this.pesquisaFormaPagto();
                }
            }
        });
        this.textCodigoCadastro.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    NotaFiscalEntrada.this.pesquisaCadastro();
                }
            }
        });
        this.textDataEmissao.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    Funcoes.mostraData(NotaFiscalEntrada.this.textDataEmissao, NotaFiscalEntrada.this.buttonBuscaDataEmissao, (JPanel)NotaFiscalEntrada.this.textDataEmissao.getParent(), true);
                }
            }
        });
        this.textDataParcela.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    Funcoes.mostraData(NotaFiscalEntrada.this.textDataParcela, NotaFiscalEntrada.this.buttonBuscaDataParcela, (JPanel)NotaFiscalEntrada.this.textDataParcela.getParent(), true);
                }
            }
        });
        this.textMaterial.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    NotaFiscalEntrada.this.buttonBuscaMaterial.doClick();
                }
            }
        });
        this.textMaterial.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (NotaFiscalEntrada.this.textMaterial.getText().isEmpty()) {
                    return;
                }
                if (NotaFiscalEntrada.this.materialAux == null || !Funcoes.isNumeric(NotaFiscalEntrada.this.textMaterial.getText()) || Funcoes.isNumeric(NotaFiscalEntrada.this.textMaterial.getText()) && NotaFiscalEntrada.this.materialAux.getCodigo() != Integer.parseInt(NotaFiscalEntrada.this.textMaterial.getText())) {
                    try {
                        if (!NotaFiscalEntrada.this.textMaterial.getText().contains(",")) {
                            NotaFiscalEntrada.this.materialAux = (MaterialBean)new MaterialService().getAtivo(Variaveis.filialPadrao, NotaFiscalEntrada.this.textMaterial.getText(), null, null);
                        }
                    }
                    catch (Exception e1) {
                        NotaFiscalEntrada.this.materialAux = null;
                        NotaFiscalEntrada.this.labelDescricaoMaterial.setText("N\u00e3o cadastrado");
                        NotaFiscalEntrada.this.controlaCampos();
                        return;
                    }
                    NotaFiscalEntrada.this.materialAux = VisualizarMateriaisAlternativos.getTelaMaterialAlternativo(NotaFiscalEntrada.this.materialAux, NotaFiscalEntrada.this.textMaterial);
                    if (NotaFiscalEntrada.this.materialAux != null) {
                        NotaFiscalEntrada.this.labelDescricaoMaterial.setText(NotaFiscalEntrada.this.materialAux.getDescricao());
                        NotaFiscalEntrada.this.textMaterial.setText(NotaFiscalEntrada.this.materialAux.getCodigo().toString());
                    } else {
                        NotaFiscalEntrada.this.labelDescricaoMaterial.setText("N\u00e3o cadastrado");
                    }
                }
                NotaFiscalEntrada.this.controlaCampos();
                if (!NotaFiscalEntrada.this.alterarOrdemCamposNota) {
                    if (NotaFiscalEntrada.this.textUnitario.isEnabled() && NotaFiscalEntrada.this.textUnitario.isFocusable()) {
                        NotaFiscalEntrada.this.textUnitario.grabFocus();
                    }
                } else if (NotaFiscalEntrada.this.textQuantidade.isEnabled() && NotaFiscalEntrada.this.textQuantidade.isFocusable()) {
                    NotaFiscalEntrada.this.textQuantidade.grabFocus();
                }
            }
        });
        this.buttonBuscaMaterial.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Hashtable hash = Pesquisas.materialAtivo(Laboratorio.getInstancia(), true);
                if (hash != null) {
                    MaterialBean bean = null;
                    try {
                        bean = (MaterialBean)new MaterialService().getAtivo(Variaveis.filialPadrao, String.valueOf((Integer)hash.get("mat_codigo")), null, null);
                    }
                    catch (Exception e1) {
                        Funcoes.mensagem(NotaFiscalEntrada.this, "N\u00e3o foi poss\u00edvel buscar dados do material.", 2);
                        return;
                    }
                    if (bean != null) {
                        NotaFiscalEntrada.this.textMaterial.setText(String.valueOf(bean.getCodigo()));
                        NotaFiscalEntrada.this.labelDescricaoMaterial.setText(bean.getDescricao());
                        NotaFiscalEntrada.this.materialAux = bean;
                        NotaFiscalEntrada.this.calculaTotais();
                    } else {
                        NotaFiscalEntrada.this.textMaterial.setText(String.valueOf((Integer)hash.get("mat_codigo")));
                        NotaFiscalEntrada.this.labelDescricaoMaterial.setText("N\u00e3o cadastrado");
                    }
                }
                NotaFiscalEntrada.this.controlaCampos();
            }
        });
        this.buttonOpcoes.setMnemonic('O');
        this.buttonOpcoes.addActionListener(this);
        this.comboDesconto.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                NotaFiscalEntrada.this.calculaTotais();
            }
        });
        this.textDescontoNota.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                NotaFiscalEntrada.this.calculaTotais();
            }
        });
        this.textFrete.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                NotaFiscalEntrada.this.calculaTotais();
            }
        });
        this.itemPrimeiraParcela.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NotaFiscalEntrada.this.buttonRateioFrete.setText("\u25b2");
                NotaFiscalEntrada.this.buttonRateioFrete.setToolTipText("Primeira Parcela");
                NotaFiscalEntrada.this.tipoFrete = 0;
            }
        });
        this.itemRateioParcelas.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NotaFiscalEntrada.this.buttonRateioFrete.setText("\u00f7");
                NotaFiscalEntrada.this.buttonRateioFrete.setToolTipText("Rateio entre Parcelas");
                NotaFiscalEntrada.this.tipoFrete = 1;
            }
        });
        this.itemUltimaParcela.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NotaFiscalEntrada.this.buttonRateioFrete.setText("\u25bc");
                NotaFiscalEntrada.this.buttonRateioFrete.setToolTipText("\u00daltima Parcela");
                NotaFiscalEntrada.this.tipoFrete = 2;
            }
        });
        this.painelCentral.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.gridx = 0;
        c.gridy = 0;
        this.painelCentral.add((Component)this.labelSerie, c);
        ++c.gridx;
        c.fill = 2;
        this.textCodigoSerie.setMinimumSize(new Dimension(69, 20));
        this.textCodigoSerie.setPreferredSize(new Dimension(69, 20));
        this.painelCentral.add((Component)this.textCodigoSerie, c);
        ++c.gridx;
        this.buttonBuscaSerie.setPreferredSize(new Dimension(20, 20));
        this.buttonBuscaSerie.setMaximumSize(new Dimension(20, 20));
        this.buttonBuscaSerie.setMinimumSize(new Dimension(20, 20));
        this.painelCentral.add((Component)this.buttonBuscaSerie, c);
        ++c.gridx;
        c.fill = 2;
        c.gridwidth = 3;
        c.weightx = 1.0;
        this.labelDescSerie.setPreferredSize(new Dimension(100, 20));
        this.labelDescSerie.setMinimumSize(new Dimension(100, 20));
        this.painelCentral.add((Component)this.labelDescSerie, c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 0.0;
        c.gridwidth = 1;
        this.labelDataHora.setPreferredSize(new Dimension(180, 20));
        this.labelDataHora.setMinimumSize(new Dimension(180, 20));
        ++c.gridy;
        c.gridx = 0;
        this.painelCentral.add((Component)this.labelNumero, c);
        ++c.gridx;
        c.fill = 2;
        this.textNumero.setPreferredSize(new Dimension(75, 20));
        this.painelCentral.add((Component)this.textNumero, c);
        this.textDataEmissao.setMinimumSize(new Dimension(100, 20));
        this.textDataEmissao.setPreferredSize(new Dimension(100, 20));
        this.buttonBuscaDataEmissao.setPreferredSize(new Dimension(20, 20));
        c.gridx += 2;
        this.painelCentral.add((Component)this.labelDataEmissao, c);
        ++c.gridx;
        this.textDataEmissao.setMinimumSize(new Dimension(90, 20));
        this.textDataEmissao.setPreferredSize(new Dimension(90, 20));
        this.painelCentral.add((Component)this.textDataEmissao, c);
        ++c.gridx;
        c.fill = 0;
        this.buttonBuscaDataEmissao.setPreferredSize(new Dimension(20, 20));
        this.buttonBuscaDataEmissao.setMinimumSize(new Dimension(20, 20));
        this.painelCentral.add((Component)this.buttonBuscaDataEmissao, c);
        c.gridx = 0;
        ++c.gridy;
        c.insets = new Insets(0, 0, 0, 0);
        this.labelCadastro.setPreferredSize(new Dimension(20, 20));
        this.painelCentral.add((Component)this.labelFornecedor, c);
        ++c.gridx;
        c.fill = 2;
        this.textCodigoCadastro.setMinimumSize(new Dimension(69, 20));
        this.textCodigoCadastro.setPreferredSize(new Dimension(69, 20));
        this.painelCentral.add((Component)this.textCodigoCadastro, c);
        ++c.gridx;
        this.buttonBuscaCadastro.setMinimumSize(new Dimension(20, 20));
        this.buttonBuscaCadastro.setPreferredSize(new Dimension(20, 20));
        this.painelCentral.add((Component)this.buttonBuscaCadastro, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.gridwidth = 3;
        c.fill = 2;
        this.labelCadastro.setPreferredSize(new Dimension(20, 20));
        this.labelCadastro.setMinimumSize(new Dimension(20, 20));
        this.painelCentral.add((Component)this.labelCadastro, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 6;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(0, 0, 0, 0);
        this.painelCentral.add((Component)this.panelMateriais, c);
        this.panelMaterial1 = new JPanel();
        this.labelMaterial = new JLabel();
        this.labelUnitario = new JLabel();
        this.textUnitario = new TTextField(12, 2, 4);
        this.panelMaterial2 = new JPanel();
        this.labelQuantidade = new JLabel();
        this.textQuantidade = new TTextField(12, 2);
        this.labelIpi = new JLabel();
        this.textIpi = new TTextField(12, 2, 4);
        this.labelIcms = new JLabel();
        this.textIcms = new TTextField(12, 2, 4);
        this.labelAux = new JLabel();
        this.textValorDesconto = new TTextField(12, 2);
        this.panelMaterial1.setLayout(new GridBagLayout());
        this.labelMaterial.setLabelFor(this.textMaterial);
        this.labelMaterial.setDisplayedMnemonic('M');
        this.labelMaterial.setText("Material:");
        this.panelMaterial1.add((Component)this.labelMaterial, new GridBagConstraints());
        this.textMaterial.setMaximumSize(new Dimension(70, 20));
        this.textMaterial.setMinimumSize(new Dimension(70, 20));
        this.textMaterial.setPreferredSize(new Dimension(70, 20));
        this.labelDescricaoMaterial.setMinimumSize(new Dimension(20, 20));
        this.labelDescricaoMaterial.setPreferredSize(new Dimension(20, 20));
        this.panelMaterial1.add((Component)this.textMaterial, new GridBagConstraints());
        GridBagConstraints g = new GridBagConstraints();
        g.gridx = 2;
        g.gridy = 0;
        g.insets = new Insets(0, 0, 1, 0);
        this.buttonBuscaMaterial.setMinimumSize(new Dimension(20, 20));
        this.buttonBuscaMaterial.setPreferredSize(new Dimension(20, 20));
        this.panelMaterial1.add((Component)this.buttonBuscaMaterial, g);
        g = new GridBagConstraints();
        g.gridx = 3;
        g.fill = 2;
        g.weightx = 1.0;
        this.panelMaterial1.add((Component)this.labelDescricaoMaterial, g);
        this.labelUnitario.setText("Vlr. Unit\u00e1rio:");
        this.labelUnitario.setDisplayedMnemonic('U');
        this.labelUnitario.setLabelFor(this.textUnitario);
        g = new GridBagConstraints();
        g.gridx = !this.alterarOrdemCamposNota ? 4 : 6;
        g.gridy = 0;
        g.insets = new Insets(0, 10, 0, 0);
        this.panelMaterial1.add((Component)this.labelUnitario, g);
        this.textUnitario.setMaximumSize(null);
        this.textUnitario.setMinimumSize(new Dimension(90, 20));
        this.textUnitario.setPreferredSize(new Dimension(90, 20));
        g = new GridBagConstraints();
        g.gridx = !this.alterarOrdemCamposNota ? 5 : 7;
        g.gridy = 0;
        this.panelMaterial1.add((Component)this.textUnitario, g);
        this.labelQuantidade.setText("Quantidade:");
        this.labelQuantidade.setDisplayedMnemonic('Q');
        this.labelQuantidade.setLabelFor(this.textQuantidade);
        g = new GridBagConstraints();
        g.gridx = !this.alterarOrdemCamposNota ? 6 : 4;
        g.gridy = 0;
        g.anchor = 17;
        g.insets = new Insets(0, 10, 0, 0);
        this.panelMaterial1.add((Component)this.labelQuantidade, g);
        this.textQuantidade.setMaximumSize(null);
        this.textQuantidade.setMinimumSize(new Dimension(90, 20));
        this.textQuantidade.setPreferredSize(new Dimension(90, 20));
        g = new GridBagConstraints();
        g.gridx = !this.alterarOrdemCamposNota ? 7 : 5;
        g.gridy = 0;
        g.anchor = 17;
        this.panelMaterial1.add((Component)this.textQuantidade, g);
        g = new GridBagConstraints();
        g.fill = 2;
        g.weightx = 1.0;
        this.panelMateriais.add((Component)this.panelMaterial1, g);
        this.panelMaterial2.setLayout(new GridBagLayout());
        this.labelValorDesconto.setText("Vlr. Desconto:");
        this.labelValorDesconto.setDisplayedMnemonic('V');
        this.labelValorDesconto.setLabelFor(this.textValorDesconto);
        g = new GridBagConstraints();
        g.gridx = 0;
        g.gridy = 0;
        g.anchor = 17;
        this.panelMaterial2.add((Component)this.labelValorDesconto, g);
        this.textValorDesconto.setMaximumSize(null);
        this.textValorDesconto.setMinimumSize(new Dimension(70, 20));
        this.textValorDesconto.setPreferredSize(new Dimension(70, 20));
        ++g.gridx;
        g.gridy = 0;
        this.panelMaterial2.add((Component)this.textValorDesconto, g);
        this.labelIpi.setText("Ipi:");
        g.gridx = !this.alterarOrdemCamposNota ? 2 : 5;
        g.gridy = 0;
        g.insets = new Insets(0, 20, 0, 0);
        this.panelMaterial2.add((Component)this.labelIpi, g);
        this.textIpi.setMinimumSize(new Dimension(70, 20));
        this.textIpi.setPreferredSize(new Dimension(70, 20));
        g.insets = new Insets(0, 0, 0, 0);
        g.gridx = !this.alterarOrdemCamposNota ? 3 : 6;
        g.gridy = 0;
        this.panelMaterial2.add((Component)this.textIpi, g);
        this.comboIpi.setMinimumSize(new Dimension(40, 20));
        this.comboIpi.setPreferredSize(new Dimension(40, 20));
        g.gridx = !this.alterarOrdemCamposNota ? 4 : 7;
        this.panelMaterial2.add((Component)this.comboIpi, g);
        this.labelIcms.setText("Icms:");
        g.gridx = !this.alterarOrdemCamposNota ? 5 : 2;
        g.gridy = 0;
        g.insets = new Insets(0, 20, 0, 0);
        this.panelMaterial2.add((Component)this.labelIcms, g);
        this.textIcms.setMinimumSize(new Dimension(70, 20));
        this.textIcms.setPreferredSize(new Dimension(70, 20));
        g.gridx = !this.alterarOrdemCamposNota ? 6 : 3;
        g.gridy = 0;
        g.insets = new Insets(0, 0, 0, 0);
        this.panelMaterial2.add((Component)this.textIcms, g);
        this.comboIcms.setMinimumSize(new Dimension(40, 20));
        this.comboIcms.setPreferredSize(new Dimension(40, 20));
        g.gridx = !this.alterarOrdemCamposNota ? 7 : 4;
        this.panelMaterial2.add((Component)this.comboIcms, g);
        this.labelTotalMaterial = new JLabel("Valor:");
        g.gridx = 8;
        g.gridy = 0;
        g.insets = new Insets(0, 20, 0, 0);
        this.panelMaterial2.add((Component)this.labelTotalMaterial, g);
        this.labelVlrTotalMaterial.setHorizontalAlignment(4);
        this.labelVlrTotalMaterial.setMinimumSize(new Dimension(80, 20));
        this.labelVlrTotalMaterial.setPreferredSize(new Dimension(80, 20));
        g.gridx = 9;
        g.gridy = 0;
        g.insets = new Insets(0, 0, 0, 0);
        this.panelMaterial2.add((Component)this.labelVlrTotalMaterial, g);
        this.buttonOKMaterial.setMnemonic('K');
        this.buttonOKMaterial.setMinimumSize(new Dimension(40, 20));
        this.buttonOKMaterial.setPreferredSize(new Dimension(40, 20));
        this.buttonOKMaterial.setMargin(new Insets(1, 1, 1, 1));
        g.gridx = 10;
        g.gridy = 0;
        this.panelMaterial2.add((Component)this.buttonOKMaterial, g);
        g = new GridBagConstraints();
        g.fill = 2;
        g.weightx = 1.0;
        this.panelMaterial2.add((Component)this.labelAux, g);
        g = new GridBagConstraints();
        g.gridx = 0;
        g.gridy = 1;
        g.fill = 2;
        g.weightx = 1.0;
        this.panelMateriais.add((Component)this.panelMaterial2, g);
        g = new GridBagConstraints();
        g.gridx = 0;
        g.gridy = 2;
        g.fill = 1;
        g.weightx = 1.0;
        g.weighty = 1.0;
        JScrollPane scrollMateriais = new JScrollPane(this.tableMateriais);
        this.panelMateriais.add((Component)scrollMateriais, g);
        JPanel panelMaterial3 = new JPanel(new GridBagLayout());
        g = new GridBagConstraints();
        g.anchor = 17;
        g.fill = 2;
        g.weightx = 1.0;
        g.gridheight = 1;
        g.gridx = 0;
        g.gridy = 0;
        panelMaterial3.add((Component)new JLabel(), g);
        g.fill = 0;
        g.weightx = 0.0;
        ++g.gridx;
        this.labelSubTotalNota.setHorizontalAlignment(4);
        panelMaterial3.add((Component)this.labelSubTotalNota, g);
        ++g.gridx;
        this.labelVlrSubTotalNota.setHorizontalAlignment(4);
        this.labelVlrSubTotalNota.setPreferredSize(new Dimension(90, 20));
        this.labelVlrSubTotalNota.setMinimumSize(new Dimension(90, 20));
        panelMaterial3.add((Component)this.labelVlrSubTotalNota, g);
        ++g.gridx;
        g.insets = new Insets(0, 20, 0, 0);
        this.labelFrete.setHorizontalAlignment(4);
        panelMaterial3.add((Component)this.labelFrete, g);
        g.insets = new Insets(0, 0, 0, 0);
        ++g.gridx;
        this.textFrete.setPreferredSize(new Dimension(70, 20));
        this.textFrete.setMinimumSize(new Dimension(70, 20));
        panelMaterial3.add((Component)this.textFrete, g);
        this.buttonRateioFrete.setMargin(new Insets(0, 0, 0, 0));
        this.buttonRateioFrete.setPreferredSize(new Dimension(30, 20));
        this.buttonRateioFrete.setMinimumSize(new Dimension(30, 20));
        this.buttonRateioFrete.setToolTipText("Rateio entre Parcelas");
        ++g.gridx;
        panelMaterial3.add((Component)this.buttonRateioFrete, g);
        g.insets = new Insets(0, 20, 0, 0);
        ++g.gridx;
        this.labelDescontoNota.setHorizontalAlignment(4);
        panelMaterial3.add((Component)this.labelDescontoNota, g);
        g.insets = new Insets(0, 0, 0, 0);
        ++g.gridx;
        this.textDescontoNota.setPreferredSize(new Dimension(70, 20));
        this.textDescontoNota.setMinimumSize(new Dimension(70, 20));
        panelMaterial3.add((Component)this.textDescontoNota, g);
        ++g.gridx;
        this.comboDesconto.setPreferredSize(new Dimension(40, 20));
        this.comboDesconto.setMinimumSize(new Dimension(40, 20));
        panelMaterial3.add((Component)this.comboDesconto, g);
        g.gridy += 2;
        g.gridx = 1;
        this.labelTotalIpi.setHorizontalAlignment(4);
        panelMaterial3.add((Component)this.labelTotalIpi, g);
        ++g.gridx;
        this.labelVlrTotalIpi.setPreferredSize(new Dimension(90, 20));
        this.labelVlrTotalIpi.setMinimumSize(new Dimension(90, 20));
        this.labelVlrTotalIpi.setHorizontalAlignment(4);
        panelMaterial3.add((Component)this.labelVlrTotalIpi, g);
        ++g.gridx;
        g.insets = new Insets(0, 20, 0, 0);
        this.labelTotalIcms.setHorizontalAlignment(4);
        panelMaterial3.add((Component)this.labelTotalIcms, g);
        ++g.gridx;
        g.gridwidth = 2;
        g.insets = new Insets(0, 0, 0, 0);
        this.labelVlrTotalIcms.setPreferredSize(new Dimension(100, 20));
        this.labelVlrTotalIcms.setMinimumSize(new Dimension(100, 20));
        this.labelVlrTotalIcms.setHorizontalAlignment(4);
        panelMaterial3.add((Component)this.labelVlrTotalIcms, g);
        g.gridx += 2;
        g.insets = new Insets(0, 20, 0, 0);
        g.gridwidth = 1;
        this.labelTotal.setHorizontalAlignment(4);
        panelMaterial3.add((Component)this.labelTotal, g);
        ++g.gridx;
        g.insets = new Insets(0, 0, 0, 0);
        g.gridwidth = 2;
        this.labelVlrTotal.setPreferredSize(new Dimension(110, 20));
        this.labelVlrTotal.setMinimumSize(new Dimension(110, 20));
        this.labelVlrTotal.setHorizontalAlignment(4);
        panelMaterial3.add((Component)this.labelVlrTotal, g);
        g = new GridBagConstraints();
        g.gridx = 0;
        g.gridy = 3;
        g.fill = 2;
        g.weightx = 1.0;
        this.panelMateriais.add((Component)panelMaterial3, g);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.fill = 0;
        c.weighty = 0.0;
        this.painelCentral.add((Component)this.labelForma, c);
        JPanel p = new JPanel(new GridBagLayout());
        g = new GridBagConstraints();
        this.textCodigoForma.setPreferredSize(new Dimension(70, 20));
        this.buttonBuscaForma.setPreferredSize(new Dimension(20, 20));
        this.labelDescForma.setPreferredSize(new Dimension(20, 20));
        g.gridx = 0;
        g.gridy = 0;
        p.add((Component)this.textCodigoForma, g);
        ++g.gridx;
        p.add((Component)this.buttonBuscaForma, g);
        ++g.gridx;
        g.weightx = 1.0;
        g.fill = 2;
        p.add((Component)this.labelDescForma, g);
        c.gridx = 1;
        c.gridwidth = 5;
        c.weightx = 1.0;
        c.fill = 2;
        this.painelCentral.add((Component)p, c);
        c.gridx = 0;
        ++c.gridy;
        c.weighty = 0.2;
        c.weightx = 1.0;
        c.gridwidth = 6;
        c.fill = 1;
        JPanel panelTemp = ComponenteFactory.novoJPanel(new GridBagLayout(), null);
        GridBagConstraints cTemp = new GridBagConstraints();
        this.painelCentral.add((Component)panelTemp, c);
        cTemp.gridx = 0;
        cTemp.weighty = 1.0;
        cTemp.anchor = 17;
        cTemp.fill = 3;
        p = ComponenteFactory.novoJPanel(new BorderLayout(), new TitledBorder("Parcelas"));
        this.montaPanelParcela(p);
        panelTemp.add((Component)p, cTemp);
        cTemp.gridx = 2;
        cTemp.weightx = 0.6;
        cTemp.fill = 1;
        JPanel panelObs = ComponenteFactory.novoJPanel(new BorderLayout(), new TitledBorder("Observa\u00e7\u00e3o"));
        JScrollPane scrollObs = new JScrollPane(this.textObs);
        scrollObs.setMinimumSize(new Dimension(20, 100));
        scrollObs.setPreferredSize(new Dimension(20, 100));
        panelObs.add((Component)scrollObs, "Center");
        panelTemp.add((Component)panelObs, cTemp);
        this.textObs.setLineWrap(true);
        this.textObs.setWrapStyleWord(true);
        this.textCodigoForma.addFocusListener(this);
        this.textCodigoCadastro.addFocusListener(this);
        this.textCodigoSerie.addFocusListener(this);
        this.textParcela.addFocusListener(this);
        this.textValorMaterial.addFocusListener(this);
        this.textNumero.addFocusListener(this);
        FocusAdapter focusMaterial = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                NotaFiscalEntrada.this.calculaTotalMaterial();
            }
        };
        this.textMaterial.addFocusListener(focusMaterial);
        this.textUnitario.addFocusListener(focusMaterial);
        this.textQuantidade.addFocusListener(focusMaterial);
        this.textValorDesconto.addFocusListener(focusMaterial);
        this.textIpi.addFocusListener(focusMaterial);
        this.textIcms.addFocusListener(focusMaterial);
        this.comboIcms.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                NotaFiscalEntrada.this.calculaTotalMaterial();
            }
        });
        this.comboIpi.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                NotaFiscalEntrada.this.calculaTotalMaterial();
            }
        });
        this.modeloMateriais.ordenarColunaSemTrocarSentido(0);
        this.montaPanelBotoes();
        this.controlaCampos();
    }

    private String[] montaColunas() {
        if (!this.alterarOrdemCamposNota) {
            return new String[]{"#", "Material", "Unit\u00e1rio", "Qtde.", "Desc.", "Vlr. IPI", "% IPI", "Vlr. ICMS", "% ICMS", "Valor", "Objeto", "ObjetoMaterial"};
        }
        return new String[]{"#", "Material", "Qtde.", "Unit\u00e1rio", "Desc.", "Vlr. ICMS", "% ICMS", "Vlr. IPI", "% IPI", "Valor", "Objeto", "ObjetoMaterial"};
    }

    private void montaPanelBotoes() {
        JPanel panelImportar = new JPanel(new FlowLayout(0));
        panelImportar.add(this.buttonOpcoes);
        JPanel panelBotoesBasicos = new JPanel(new FlowLayout(2));
        panelBotoesBasicos.add(this.botaoNovo);
        panelBotoesBasicos.add(this.botaoEditar);
        panelBotoesBasicos.add(this.botaoSalvar);
        panelBotoesBasicos.add(this.botaoCancelar);
        panelBotoesBasicos.add(this.botaoFechar);
        this.painelBotoes.removeAll();
        this.painelBotoes.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 2;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.weighty = 0.0;
        c.weightx = 1.0;
        this.painelBotoes.add((Component)panelImportar, c);
        ++c.gridx;
        this.painelBotoes.add((Component)panelBotoesBasicos, c);
    }

    private void calculaTotais() {
        if (this.modeloMateriais.getRowCount() > 0) {
            BigDecimal subtotal = new BigDecimal("0").setScale(4, ROUND);
            BigDecimal valorIpi = new BigDecimal("0").setScale(4, ROUND);
            BigDecimal valorIcms = new BigDecimal("0").setScale(4, ROUND);
            for (int i = 0; i < this.modeloMateriais.getRowCount(); ++i) {
                NotaFiscalMaterialBean beanMaterial = (NotaFiscalMaterialBean)this.modeloMateriais.getValueAt(i, 10);
                subtotal = subtotal.add(new BigDecimal(beanMaterial.getValorUnitario().toString()).multiply(new BigDecimal(beanMaterial.getQuantidade().toString())).setScale(4, ROUND));
                subtotal = subtotal.subtract(new BigDecimal(beanMaterial.getValorDesconto().toString()).setScale(4, ROUND));
                valorIpi = valorIpi.add(new BigDecimal(beanMaterial.getValorIpi().toString()).setScale(4, ROUND));
                valorIcms = valorIcms.add(new BigDecimal(beanMaterial.getValorIcms().toString()).setScale(4, ROUND));
            }
            this.labelVlrSubTotalNota.setText(Funcoes.formataDecimal("###,##0.00##", subtotal.setScale(4, ROUND).doubleValue()));
            BigDecimal total = new BigDecimal("0").setScale(ParametrosGerais.getCasasPrecoExame(), ROUND);
            total = total.add(valorIpi);
            total = total.add(valorIcms);
            if (this.comboDesconto.getSelectedItem().equals("$")) {
                total = total.add(subtotal);
                total = total.subtract(new BigDecimal(this.textDescontoNota.getText().isEmpty() ? "0" : Funcoes.limpaDecimal(this.textDescontoNota.getText())).setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame()));
            } else {
                total = total.add(subtotal);
                BigDecimal valorDesc = subtotal.multiply(new BigDecimal(this.textDescontoNota.getText().isEmpty() ? "0" : Funcoes.limpaDecimal(this.textDescontoNota.getText())).setScale(4, ROUND));
                valorDesc = valorDesc.divide(new BigDecimal("100").setScale(4, ROUND), CASAS, ROUND);
                total = total.subtract(valorDesc);
            }
            total = total.add(new BigDecimal(this.textFrete.getText().isEmpty() ? "0" : this.textFrete.getText()));
            total = total.setScale(2, ParametrosGerais.getArredondamentoPrecoExame());
            this.labelVlrTotal.setText(Funcoes.formataDecimal("###,##0.00", total.doubleValue()));
            this.labelVlrTotalIcms.setText(Funcoes.formataDecimal(valorIcms.doubleValue()));
            this.labelVlrTotalIpi.setText(Funcoes.formataDecimal(valorIpi.doubleValue()));
        } else {
            this.labelVlrSubTotalNota.setText(Funcoes.formataDecimal(0.0));
            this.labelVlrTotal.setText(Funcoes.formataDecimal(0.0));
            this.labelVlrTotalIcms.setText(Funcoes.formataDecimal(0.0));
            this.labelVlrTotalIpi.setText(Funcoes.formataDecimal(0.0));
        }
    }

    private void montaPanelParcela(JPanel panel) {
        panel.setLayout(new BorderLayout());
        JPanel topo = new JPanel(new GridBagLayout());
        GridBagConstraints g = new GridBagConstraints();
        g.anchor = 17;
        g.gridx = 0;
        g.gridy = 0;
        this.labelParcela.setLabelFor(this.textParcela);
        this.labelParcela.setDisplayedMnemonic('P');
        topo.add((Component)this.labelParcela, g);
        g.gridx = 1;
        topo.add((Component)this.labelVencimentoParcela, g);
        g.gridx = 3;
        topo.add((Component)this.labelValorParcela, g);
        g.gridy = 1;
        g.gridx = 0;
        this.textParcela.setMinimumSize(new Dimension(50, 20));
        this.textParcela.setPreferredSize(new Dimension(50, 20));
        topo.add((Component)this.textParcela, g);
        g.gridx = 1;
        this.textDataParcela.setMinimumSize(new Dimension(85, 20));
        this.textDataParcela.setPreferredSize(new Dimension(85, 20));
        topo.add((Component)this.textDataParcela, g);
        g.gridx = 2;
        this.buttonBuscaDataParcela.setPreferredSize(new Dimension(20, 20));
        this.buttonBuscaDataParcela.setMinimumSize(new Dimension(20, 20));
        topo.add((Component)this.buttonBuscaDataParcela, g);
        g.gridx = 3;
        this.textValorParcela.setPreferredSize(new Dimension(80, 20));
        this.textValorParcela.setMinimumSize(new Dimension(80, 20));
        topo.add((Component)this.textValorParcela, g);
        g.gridx = 4;
        this.buttonOKParcela.setPreferredSize(new Dimension(40, 20));
        this.buttonOKParcela.setMinimumSize(new Dimension(40, 20));
        topo.add((Component)this.buttonOKParcela, g);
        panel.add((Component)topo, "North");
        JScrollPane e = new JScrollPane(this.tableParcela);
        e.setPreferredSize(new Dimension(275, 20));
        panel.add((Component)e, "Center");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonBuscaDataEmissao) {
            Funcoes.mostraData(this.textDataEmissao, this.buttonBuscaDataEmissao, (JPanel)this.textDataEmissao.getParent(), true);
        } else if (e.getSource() == this.buttonBuscaDataParcela) {
            Funcoes.mostraData(this.textDataParcela, this.buttonBuscaDataParcela, (JPanel)this.textDataParcela.getParent(), true);
        } else if (e.getSource() == this.buttonBuscaSerie) {
            this.pesquisaSerie();
        } else if (e.getSource() == this.buttonBuscaForma) {
            this.pesquisaFormaPagto();
        } else if (e.getSource() == this.buttonBuscaCadastro) {
            this.pesquisaCadastro();
        } else if (e.getSource() == this.buttonOKParcela) {
            this.okParcela();
        } else if (e.getSource() == this.buttonOKMaterial) {
            this.okMaterial();
        } else if (e.getSource() == this.itemParcela) {
            this.editarParcelas(this.tableParcela.getSelectedRow());
        } else if (e.getSource() == this.itemPlano) {
            this.editarPlanoCusto(this.tableParcela.getSelectedRow());
        } else if (e.getSource() == this.buttonOpcoes) {
            this.menuOpcoes.show(this.buttonOpcoes.getParent(), this.buttonOpcoes.getX(), this.buttonOpcoes.getY() - this.menuOpcoes.getPreferredSize().height - 1);
        } else if (e.getSource() == this.buttonRateioFrete) {
            this.menuFrete.show(this.buttonRateioFrete, this.buttonRateioFrete.getParent().getX(), this.buttonRateioFrete.getY());
        } else if (e.getSource() == this.itemEditarMaterial) {
            this.editarMaterial();
        } else if (e.getSource() == this.itemVisualizarLote) {
            this.editarVisualizarLotes(this.materialAux, null, true);
        } else if (e.getSource().equals(this.itemImportarPedidoCompra)) {
            this.importarPedidoCompra();
        } else if (e.getSource().equals(this.itemImportarNotaFiscalEntrada)) {
            this.importarNotaFiscalEntrada();
        } else if (e.getSource().equals(this.itemVisualizaPesquisaFornecedor)) {
            VisualizarPesquisaFornecedor visualizaHistorico = new VisualizarPesquisaFornecedor((Frame)Laboratorio.getInstancia(), this.notaFiscalAux, (Boolean)true);
            visualizaHistorico.setVisible(true);
        }
    }

    private void editarVisualizarLotes(MaterialBean bean, NotaFiscalMaterialBean notaBean, boolean visualizarLote) {
        int row = -1;
        if (visualizarLote || bean == null && notaBean == null) {
            row = this.tableMateriais.getSelectedRow();
            bean = (MaterialBean)this.modeloMateriais.getValueAt(row, 11);
            notaBean = (NotaFiscalMaterialBean)this.modeloMateriais.getValueAt(row, 10);
        }
        try {
            if ((ParametrosGerais.getTipoMovimentarEstoque().equalsIgnoreCase("N") || visualizarLote) && bean.getSolicitarLote().booleanValue()) {
                SolicitarLoteMaterial lote;
                CelulaEstoqueVO celula = new CelulaEstoqueService().getCelulaPadraoVO(Variaveis.filialPadrao);
                Double qtdeOriginal = bean.getQuantidadeLotes(celula) - bean.getQuantidadeConsumidaLotes(celula);
                MaterialVO matVO = null;
                if (this.getStatus() != 2 && visualizarLote) {
                    matVO = (MaterialVO)bean.toVO();
                    new MaterialService().carregarDadosLotesNotaEntrada(matVO, (NotaFiscalVO)this.notaFiscalAux.toVO());
                }
                if ((lote = new SolicitarLoteMaterial((Frame)this.getTopLevelAncestor(), bean.getCodigo(), bean.getDescricao(), bean.getUnidadeMedida().getCodigo(), bean.getFichaTecnica(), this.getStatus() == 2 || !visualizarLote ? bean.getLotes() : matVO.getLotes(), this.getStatus() == 2 || !visualizarLote ? 0 : 2, qtdeOriginal, notaBean.getQuantidade(), null, null, celula, false, null, false)) != null) {
                    lote.setVisible(true);
                    if (lote.getOK()) {
                        bean.setLotes(lote.getLotes());
                        Double qtde = 0.0;
                        if (bean.getLotes() != null && !bean.getLotes().isEmpty()) {
                            for (int i = 0; i < lote.getLotes().size(); ++i) {
                                qtde = qtde + bean.getLotes().get(i).getQuantidade();
                            }
                        }
                        bean.setQuantidadeInformadaLotes(qtde);
                    } else if (!visualizarLote) {
                        Funcoes.mensagem(this, "Os lotes do material devem ser informados.", 2);
                    }
                }
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar os dados do material (configurando lotes).\n" + e.getMessage(), e.getStackTrace());
        }
    }

    private void editarMaterial() {
        int row = this.tableMateriais.getSelectedRow();
        if (row >= 0) {
            Boolean isMaterialNovo = (Boolean)this.modeloMateriais.getValueAt(row, 12);
            if (!isMaterialNovo.booleanValue() && this.getStatus() == 3 && ParametrosGerais.getTipoMovimentarEstoque().equalsIgnoreCase("N")) {
                Funcoes.mensagem(this, "O sistema est\u00e1 configurado para movimentar estoque ao criar a nota fiscal de entrada.\nN\u00e3o \u00e9 poss\u00edvel editar os \u00edtens da nota fiscal de entrada.", 2);
                return;
            }
            if (this.notaMovimentouEstoque) {
                Funcoes.mensagem(this, "A nota fiscal de entrada movimentou estoque.\nN\u00e3o \u00e9 poss\u00edvel editar os \u00edtens.", 2);
                return;
            }
            if (this.conferenciaMovimentouEstoque) {
                Funcoes.mensagem(this, "A confer\u00eancia de entrada da nota movimentou estoque.\nN\u00e3o \u00e9 poss\u00edvel editar os \u00edtens.", 2);
                return;
            }
            NotaFiscalMaterialBean material = (NotaFiscalMaterialBean)this.modeloMateriais.getValueAt(row, 10);
            this.isAlterandoMaterial = true;
            this.materialAux = (MaterialBean)this.modeloMateriais.getValueAt(row, 11);
            this.textMaterial.setText(String.valueOf(material.getMaterial().getCodigo()));
            this.labelDescricaoMaterial.setText(material.getMaterial().getDescricao());
            this.textUnitario.setText(Funcoes.formataDecimal("#,##0.0000", material.getValorUnitario()));
            this.textQuantidade.setText(Funcoes.formataDecimal(material.getQuantidade()));
            this.textIcms.setText(Funcoes.formataDecimal("#,##0.00##", material.getValorIcms()));
            this.textIpi.setText(Funcoes.formataDecimal("#,##0.00##", material.getValorIpi()));
            this.textValorDesconto.setText(Funcoes.formataDecimal(material.getValorDesconto()));
            this.labelVlrTotalMaterial.setText(Funcoes.formataDecimal("#,##0.00##", material.getValorTotal()));
            this.comboIpi.setSelectedItem("$");
            this.comboIcms.setSelectedItem("$");
            this.controlaCampos();
            if (this.textMaterial.isFocusable() && this.textMaterial.isEnabled()) {
                this.textMaterial.grabFocus();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void importarNotaFiscalEntrada() {
        this.limparCampos();
        this.isImportacaoNota = true;
        this.codigosMateriais = new ArrayList<String>();
        JFileChooser chooser = ComponenteFactory.novoJFileChooser();
        chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
        chooser.setFileFilter(ComponenteFactory.novoFileFilter("Arquivo de Nota Fiscal Eletr\u00f4nica (*.xml)", "xml"));
        if (chooser.showOpenDialog(this) != 0) return;
        File arquivoXML = chooser.getSelectedFile();
        try {
            this.byteArquivoImportacao = Files.readAllBytes(arquivoXML.toPath());
            NotaFiscalEntradaDTO notaFiscalDTO = ParserImportacaoNotaFiscalEntrada.analisarXML(arquivoXML);
            this.textCodigoSerie.setText(notaFiscalDTO.getSerie());
            this.buscaSerie(notaFiscalDTO.getSerie());
            this.textNumero.setText(notaFiscalDTO.getnNF());
            this.textDataEmissao.setText(notaFiscalDTO.getDhEmi());
            this.textObs.setText(notaFiscalDTO.getObservacao());
            EntidadeService entService = new EntidadeService();
            int qtdeFornecedor = entService.quantosFornecedoresParaCNPJ(Variaveis.filialPadrao, notaFiscalDTO.getCnpj(), "F");
            if (qtdeFornecedor == 1) {
                EntidadeBean fornecedor = entService.localizarPeloDocumento(Variaveis.filialPadrao, notaFiscalDTO.getCnpj(), "F");
                this.textCodigoCadastro.setText(fornecedor.getCodigo().toString());
                this.labelCadastro.setText(fornecedor.getFantasia());
            } else if (qtdeFornecedor > 0) {
                String titulo = "Pesquisando Fornecedores";
                EntidadeVO entidade = (EntidadeVO)this.serviceEntidade.pesquisaVOFornecedor(Laboratorio.getInstancia(), new EntidadeVO(), titulo, Variaveis.filialPadrao, notaFiscalDTO.getCnpj());
                if (entidade == null) return;
                this.textCodigoCadastro.setText(Integer.toString(entidade.getCodigo()));
                this.labelCadastro.setText(entidade.getFantasia());
            } else {
                Funcoes.mensagem(this, "CNPJ do fornecedor n\u00e3o localizado. Opera\u00e7\u00e3o cancelada.", 1);
                this.limparCampos();
                return;
            }
            if (!this.inserirItensImportacaoNota(notaFiscalDTO)) return;
            this.textFrete.setText(Funcoes.formataDecimal(notaFiscalDTO.getValorFrete()));
            this.calculaTotais();
            this.labelVlrTotalIpi.setText(Funcoes.formataDecimal("#,##0.00##", notaFiscalDTO.getValorIPI()));
            this.habilitarCamposImportacaoNota();
            this.habilitaBotoes();
            Funcoes.mensagem(this, "Materiais da nota fiscal de entrada importados com sucesso.", 2);
            return;
        }
        catch (Exception e) {
            Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel importar a nota fiscal de entrada.", 1);
            this.limparCampos();
        }
    }

    private boolean inserirItensImportacaoNota(NotaFiscalEntradaDTO notaFiscalDTO) throws Exception {
        Double valorIpi = notaFiscalDTO.getValorIPI() / (double)notaFiscalDTO.getItens().size();
        for (ItemNotaFiscalEntradaDTO item : notaFiscalDTO.getItens()) {
            this.registroSelecionado = "";
            int qtdeMateriasAlternativos = MaterialAlternativoService.qtdeMateriasAlternativosCodigo(Variaveis.filialPadrao, item.getcProd());
            boolean cancelou = false;
            String matCodigo = "";
            if (qtdeMateriasAlternativos == 1) {
                matCodigo = MaterialAlternativoService.getMateriasAlternativosCodigo(Variaveis.filialPadrao, item.getcProd());
            }
            if (qtdeMateriasAlternativos > 1 || qtdeMateriasAlternativos == 0 || !matCodigo.isEmpty() && this.codigosMateriais.contains(matCodigo)) {
                cancelou = this.selecionarOuCadastrarMaterial(notaFiscalDTO, item);
                matCodigo = this.registroSelecionado;
            }
            if (!cancelou) {
                MaterialBean bean = this.verificaSolicitarLoteMaterial(item, matCodigo);
                if (bean != null) {
                    if (qtdeMateriasAlternativos == 1) {
                        if (this.codigosMateriais.contains(matCodigo)) {
                            Funcoes.mensagem(this, "Esse material j\u00e1 foi inserido na nota fiscal.", 2);
                            this.selecionarOuCadastrarMaterial(notaFiscalDTO, item);
                        } else {
                            this.codigosMateriais.add(matCodigo);
                        }
                    }
                    MaterialVO materialVO = (MaterialVO)new MaterialDao().getVO(matCodigo);
                    NotaFiscalMaterialBean materialBean = new NotaFiscalMaterialBean();
                    int ordem = this.getProximoRegistro();
                    FilialVO filial = new FilialVO();
                    filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
                    materialBean.setFilial(filial);
                    materialBean.setMaterial(materialVO);
                    materialBean.setQuantidade(item.getQuantidadeProduto());
                    materialBean.setValorUnitario(item.getValorUnitario());
                    materialBean.setValorIcms(item.getValorIcms() == null ? Double.valueOf(0.0) : item.getValorIcms());
                    materialBean.setPercentualIcms(item.getPercentualIcms() == null ? Double.valueOf(0.0) : item.getPercentualIcms());
                    materialBean.setValorDesconto(0.0);
                    materialBean.setPercentualDesconto(0.0);
                    if (notaFiscalDTO.getItens().indexOf(item) + 1 == notaFiscalDTO.getItens().size()) {
                        valorIpi = BigDecimal.valueOf(notaFiscalDTO.getValorIPI()).setScale(4, RoundingMode.DOWN).subtract(BigDecimal.valueOf((double)(notaFiscalDTO.getItens().size() - 1) * valorIpi).setScale(4, RoundingMode.DOWN)).doubleValue();
                    }
                    materialBean.setValorIpi(valorIpi);
                    materialBean.setOrdem(ordem);
                    BigDecimal valorTotal = new BigDecimal("100").setScale(4, ROUND);
                    valorTotal = new BigDecimal(materialBean.getValorUnitario().toString()).setScale(4, ROUND).multiply(new BigDecimal(materialBean.getQuantidade().toString()).setScale(4, ROUND));
                    valorTotal = valorTotal.add(new BigDecimal(materialBean.getValorIcms().toString()).setScale(4, ROUND)).add(new BigDecimal(materialBean.getValorIpi().toString()).setScale(4, ROUND));
                    materialBean.setValorTotal(valorTotal.setScale(4, ROUND).doubleValue());
                    this.modeloMateriais.addLine(new Object[]{ordem, materialBean.getMaterial().getDescricao(), Funcoes.formataDecimal("###,##0.0000", item.getValorUnitario()), Funcoes.formataDecimal(item.getQuantidadeProduto()), Funcoes.formataDecimal(0.0), Funcoes.formataDecimal("###,##0.0000", valorIpi), Funcoes.formataDecimal(0.0), Funcoes.formataDecimal("###,##0.0000", item.getValorIcms() == null ? Double.valueOf(0.0) : item.getValorIcms()), Funcoes.formataDecimal(item.getPercentualIcms() == null ? Double.valueOf(0.0) : item.getPercentualIcms()), Funcoes.formataDecimal("###,##0.00##", valorTotal.doubleValue()), materialBean, bean, Boolean.TRUE});
                    continue;
                }
                return false;
            }
            return false;
        }
        return true;
    }

    private void habilitarCamposImportacaoNota() {
        this.textCodigoSerie.setEnabled(false);
        this.buttonBuscaSerie.setEnabled(false);
        this.textNumero.setEnabled(false);
        this.textDataEmissao.setEnabled(false);
        this.buttonBuscaDataEmissao.setEnabled(false);
        this.textCodigoCadastro.setEnabled(false);
        this.buttonBuscaCadastro.setEnabled(false);
        this.textDescontoNota.setEnabled(false);
        this.comboDesconto.setEnabled(false);
        this.textFrete.setEnabled(false);
        this.textMaterial.setEnabled(false);
        this.buttonBuscaMaterial.setEnabled(false);
        this.textValorMaterial.setEnabled(false);
        this.buttonOKMaterial.setEnabled(false);
        this.tableMateriais.setEnabled(false);
        this.textMaterial.setEnabled(false);
        this.textUnitario.setEnabled(false);
        this.textQuantidade.setEnabled(false);
        this.textValorDesconto.setEnabled(false);
        this.textIpi.setEnabled(false);
        this.textIcms.setEnabled(false);
        this.buttonOKMaterial.setEnabled(false);
        this.tableMateriais.setEnabled(false);
        this.buttonRateioFrete.setEnabled(false);
        this.comboIcms.setEnabled(false);
        this.comboIpi.setEnabled(false);
        this.textObs.setEnabled(false);
        this.textCodigoForma.setEnabled(Acesso.getAcesso(ACESSO_ALTERAR_FORMA_PAGAMENTO));
        this.buttonBuscaForma.setEnabled(Acesso.getAcesso(ACESSO_ALTERAR_FORMA_PAGAMENTO));
        this.textParcela.setEnabled(Acesso.getAcesso(ACESSO_ALTERAR_PARCELAMENTO));
        this.textDataParcela.setEnabled(Acesso.getAcesso(ACESSO_ALTERAR_PARCELAMENTO));
        this.buttonBuscaDataParcela.setEnabled(Acesso.getAcesso(ACESSO_ALTERAR_PARCELAMENTO));
        this.textValorParcela.setEnabled(Acesso.getAcesso(ACESSO_ALTERAR_PARCELAMENTO));
        this.buttonOKParcela.setEnabled(Acesso.getAcesso(ACESSO_ALTERAR_PARCELAMENTO));
        this.tableParcela.setEnabled(true);
        this.botaoSalvar.setEnabled(true);
        this.setStatus(2);
    }

    private boolean selecionarOuCadastrarMaterial(NotaFiscalEntradaDTO notaFiscalDTO, ItemNotaFiscalEntradaDTO item) {
        TelaPesquisaMateriais tela = new TelaPesquisaMateriais(Laboratorio.getInstancia(), "Pesquisando materiais", this.cadastroVO, notaFiscalDTO.getnNF(), notaFiscalDTO.getSerie(), this.labelCadastro.getText(), item, this.codigosMateriais);
        tela.setVisible(true);
        this.registroSelecionado = tela.getRegistroSelecionado();
        if (StringUtil.isEmpty(this.registroSelecionado)) {
            Funcoes.mensagem(this, "Importa\u00e7\u00e3o de nota fiscal de entrada cancelada.", 1);
            this.limparCampos();
            return true;
        }
        this.codigosMateriais.add(this.registroSelecionado);
        return tela.isCancelada();
    }

    private MaterialBean verificaSolicitarLoteMaterial(ItemNotaFiscalEntradaDTO item, String matCodigo) throws ThreadDaoException, Exception {
        try {
            FilialVO filialVO = new FilialVO();
            filialVO.setCodigo(Integer.valueOf(Variaveis.filialPadrao));
            MaterialBean beanMat = new MaterialService().getBean(Variaveis.filialPadrao, matCodigo);
            if (beanMat.getSolicitarLote().booleanValue()) {
                CelulaEstoqueVO celula = new CelulaEstoqueService().getCelulaPadraoVO(Variaveis.filialPadrao);
                Double qtdeOriginal = beanMat.getQuantidadeLotes(celula) - beanMat.getQuantidadeConsumidaLotes(celula);
                ArrayList<MaterialLoteBean> lotes = beanMat.getLotes();
                SolicitarLoteMaterial solicitarLote = new SolicitarLoteMaterial((Frame)this.getTopLevelAncestor(), Integer.valueOf(matCodigo), item.getDescricaoProduto(), beanMat.getUnidadeMedida().getCodigo(), false, lotes, 0, 1.0, item.getQuantidadeProduto(), null, null, celula, false, null, false);
                if (solicitarLote != null) {
                    solicitarLote.setVisible(true);
                    if (solicitarLote.getOK()) {
                        beanMat.setLotes(solicitarLote.getLotes());
                        Double qtde = 0.0;
                        if (beanMat.getLotes() != null && !beanMat.getLotes().isEmpty()) {
                            for (int i = 0; i < solicitarLote.getLotes().size(); ++i) {
                                qtde = qtde + beanMat.getLotes().get(i).getQuantidade();
                            }
                        }
                        beanMat.setQuantidadeInformadaLotes(qtde);
                    } else {
                        Funcoes.mensagem(this, "Os lotes do material devem ser informados.", 2);
                    }
                }
                if (solicitarLote.isUsuarioPodeCancelar()) {
                    Funcoes.mensagem(this, "Importa\u00e7\u00e3o de nota fiscal de entrada cancelada.", 1);
                    this.limparCampos();
                    return null;
                }
            }
            return beanMat;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "NotaFiscalEntrada (1646)");
            return null;
        }
    }

    private void importarPedidoCompra() {
        this.isImportandoPedido = true;
        this.itemImportarPedidoCompra.setEnabled(false);
        this.textNumero.grabFocus();
        PedidoBean pedido = this.pesquisarPedidoCompra();
        if (pedido != null) {
            this.novo(false);
            this.pedidoAux = pedido;
            this.cadastroVO = pedido.getEntidade();
            this.textCodigoCadastro.setText(pedido.getEntidade().getCodigo().toString());
            this.labelCadastro.setText(pedido.getEntidade().getFantasia());
            FilialVO filial = new FilialVO();
            filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
            this.textDescontoNota.setText(Funcoes.formataDecimal(pedido.getValorDesconto()));
            this.comboDesconto.setSelectedItem("$");
            this.textFrete.setText(Funcoes.formataDecimal(pedido.getValorFrete() == null ? 0.0 : pedido.getValorFrete()));
            ArrayList<PedidoMaterialBean> materiais = pedido.getMateriais();
            for (int i = 0; i < materiais.size(); ++i) {
                PedidoMaterialBean materialPedido = materiais.get(i);
                NotaFiscalMaterialBean materialNota = new NotaFiscalMaterialBean();
                materialNota.setFilial(filial);
                materialNota.setMaterial((MaterialVO)materialPedido.getMaterial().toVO());
                materialNota.setPercentualIcms(0.0);
                materialNota.setPercentualIpi(0.0);
                materialNota.setQuantidade(materialPedido.getQuantidade());
                materialNota.setValorIcms(0.0);
                materialNota.setValorIpi(0.0);
                materialNota.setValorDesconto(materialPedido.getValorDesconto());
                materialNota.setPercentualDesconto(materialPedido.getPercentualDesconto());
                materialNota.setValorTotal(materialPedido.getValorTotal());
                materialNota.setValorUnitario(materialPedido.getValorUnitario());
                this.adicionaMaterial(materialNota);
            }
            if (pedido.getFormaPagto() != null) {
                this.textCodigoForma.setText(pedido.getFormaPagto().getCodigo().toString());
                this.labelDescForma.setText(pedido.getFormaPagto().getDescricao());
            }
            ArrayList<ReceberPagarBean> parcelasNota = new ArrayList<ReceberPagarBean>();
            ArrayList<PedidoParcelaBean> parcelas = pedido.getParcelas();
            if (parcelas != null) {
                for (int i = 0; i < parcelas.size(); ++i) {
                    PedidoParcelaBean parcela = parcelas.get(i);
                    ReceberPagarBean recPag = new ReceberPagarBean();
                    recPag.setCofinsPercentual(0.0);
                    recPag.setCofinsValor(0.0);
                    recPag.setCsllPercentual(0.0);
                    recPag.setCsllValor(0.0);
                    recPag.setDataCompetencia(parcela.getDataVencimento());
                    recPag.setDataDocumento(parcela.getDataVencimento());
                    recPag.setDataHora(new Date());
                    recPag.setDataProcessamento(new Date());
                    recPag.setDataVencimento(parcela.getDataVencimento());
                    recPag.setEntidade(pedido.getEntidade());
                    recPag.setFilial(pedido.getFilial());
                    recPag.setInssPercentual(0.0);
                    recPag.setInssValor(0.0);
                    recPag.setIrrfPercentual(0.0);
                    recPag.setIrrfValor(0.0);
                    recPag.setIssPercentual(0.0);
                    recPag.setIssValor(0.0);
                    recPag.setParcela(parcela.getCodigo());
                    recPag.setPercentualAcrescimo(0.0);
                    recPag.setPercentualDesconto(0.0);
                    recPag.setPercentualIcms(0.0);
                    recPag.setPercentualIpi(0.0);
                    recPag.setPercentualJuro(0.0);
                    recPag.setPercentualMulta(0.0);
                    recPag.setPisPercentual(0.0);
                    recPag.setPisValor(0.0);
                    if (ParametrosGerais.getTipoAutorizacaoCompra().equalsIgnoreCase("F") || ParametrosGerais.getTipoAutorizacaoCompra().equalsIgnoreCase("E")) {
                        recPag.setSituacao("P");
                    } else {
                        recPag.setSituacao("A");
                    }
                    recPag.setTaxa(0.0);
                    recPag.setTipo("P");
                    recPag.setTipoCadastro("F");
                    recPag.setTipoDocumento("B");
                    recPag.setTipoJuro("D");
                    recPag.setUsarValorMulta(false);
                    UsuarioVO usuario = new UsuarioVO();
                    usuario.setCodigo(Variaveis.login);
                    recPag.setUsuario(usuario);
                    recPag.setValor(parcela.getValor());
                    recPag.setValorAcrescimo(0.0);
                    recPag.setValorDesconto(0.0);
                    recPag.setValorIcms(0.0);
                    recPag.setValorIpi(0.0);
                    recPag.setValorJuro(0.0);
                    recPag.setValorMulta(0.0);
                    recPag.setValorTotal(parcela.getValor());
                    parcelasNota.add(recPag);
                }
            }
            this.adicionarParcelasGrid(parcelasNota);
        }
        this.itemImportarPedidoCompra.setEnabled(true);
        this.itemVisualizaPesquisaFornecedor.setVisible(false);
        this.itemVisualizaPesquisaFornecedor.setEnabled(false);
        this.isImportandoPedido = false;
    }

    private PedidoBean pesquisarPedidoCompra() {
        try {
            PedidoBean pedido;
            String codigo = null;
            codigo = ParametrosGerais.getTipoAutorizacaoCompra().equalsIgnoreCase("P") || ParametrosGerais.getTipoAutorizacaoCompra().equalsIgnoreCase("E") ? new PedidoService().pesquisaPedidoAutorizadoVO(this.getTopLevelAncestor(), null) : new PedidoService().pesquisaPedidoDisponivelVO(this.getTopLevelAncestor(), null);
            if (codigo != null && (pedido = (PedidoBean)new PedidoDao().getBean(Variaveis.filialPadrao, codigo)) != null) {
                return pedido;
            }
        }
        catch (Exception e) {
            Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel carregar dados do pedido de compra.\nMensagem recebida: " + e.getMessage(), 2);
        }
        return null;
    }

    public void setAcessos(long acessoAlterarNumero, long acessoAlterarImpostos) {
        this.textNumero.setEditable(Acesso.getAcesso(acessoAlterarNumero));
        this.buttonImpostos.setVisible(Acesso.getAcesso(acessoAlterarImpostos));
    }

    @Override
    public void fechar() {
        if (this.getStatus() == 1 || Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setVisible(false);
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (e.getSource() instanceof TTextField) {
            ((TTextField)e.getSource()).selectAll();
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        int pos;
        if (this.isImportandoPedido) {
            return;
        }
        if (e.getSource() == this.textCodigoCadastro) {
            this.buscaCadastro(this.textCodigoCadastro.getText());
            this.verificaNotaJaExiste();
        } else if (e.getSource() == this.textCodigoSerie) {
            this.buscaSerie(this.textCodigoSerie.getText());
            this.verificaNotaJaExiste();
        } else if (e.getSource() == this.textNumero) {
            this.verificaNotaJaExiste();
        } else if (e.getSource() == this.textCodigoForma) {
            this.buscaFormaPagamento(this.textCodigoForma.getText());
            try {
                this.calcularParcelasAutomatico();
            }
            catch (Exception e1) {
                ErrorLogger.mostraMensagem(this, e1.getMessage(), e1.getStackTrace(), "NotaFiscalEntrada: 526");
            }
        } else if (e.getSource() == this.textParcela && Funcoes.isNumeric(this.textParcela.getText()) && (pos = this.modeloParcela.localizar(0, this.textParcela.getText())) > -1) {
            this.editarParcelas(pos);
        }
    }

    private void buscaSerie(String codigo) {
        if (Funcoes.textoVazio(codigo)) {
            this.textCodigoSerie.setText("");
            this.labelDescSerie.setText("");
            return;
        }
        try {
            SeriesVO serie = (SeriesVO)this.serviceSerie.getVO(Variaveis.filialPadrao, codigo);
            if (serie != null) {
                this.textCodigoSerie.setText(serie.getCodigo());
                this.labelDescSerie.setText(serie.getDescricao());
            } else {
                this.labelDescSerie.setText("N\u00e3o cadastrado");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "NotaFiscalEntrada:510");
        }
    }

    private void buscaCadastro(String codigo) {
        block5: {
            if (Funcoes.textoVazio(codigo) || codigo == null) {
                this.textCodigoCadastro.setText("");
                this.labelCadastro.setText("");
                this.cadastroVO = null;
                return;
            }
            try {
                this.cadastroVO = null;
                EntidadeVO entidade = (EntidadeVO)this.serviceEntidade.getVO(Variaveis.filialPadrao, codigo, "F");
                if (entidade != null) {
                    this.textCodigoCadastro.setText(Integer.toString(entidade.getCodigo()));
                    this.labelCadastro.setText(entidade.getFantasia());
                    this.cadastroVO = entidade;
                }
                if (Funcoes.textoVazio(this.labelCadastro.getText())) {
                    this.labelCadastro.setText("N\u00e3o cadastrado");
                    ScreenUtil.requisitarFoco(this.textCodigoCadastro);
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar dados do fornecedor.\n" + e.getMessage(), e.getStackTrace(), "NotaFiscal:555");
                if (!this.textCodigoCadastro.isEnabled() || !this.textCodigoCadastro.isFocusable()) break block5;
                this.textCodigoCadastro.selectAll();
                this.textCodigoCadastro.grabFocus();
            }
        }
    }

    private void buscaFormaPagamento(String codigo) {
        if (Funcoes.textoVazio(codigo)) {
            this.textCodigoForma.setText("");
            this.labelDescForma.setText("");
            return;
        }
        try {
            FormaPagamentoVO forma = (FormaPagamentoVO)this.serviceFormaPagamento.getVO(Variaveis.filialPadrao, codigo);
            if (forma != null) {
                this.textCodigoForma.setText(String.valueOf(forma.getCodigo()));
                this.labelDescForma.setText(forma.getDescricao());
            } else {
                this.labelDescForma.setText("N\u00e3o cadastrado");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "NotaFiscalEntrada:615");
        }
    }

    private void pesquisaSerie() {
        try {
            this.textCodigoSerie.setText("");
            this.labelDescSerie.setText("");
            SeriesVO serie = (SeriesVO)this.serviceSerie.pesquisaVO(Laboratorio.getInstancia(), new SeriesVO(), "Pesquisando s\u00e9ries", true);
            if (serie != null) {
                this.textCodigoSerie.setText(serie.getCodigo());
                this.labelDescSerie.setText(serie.getDescricao());
            } else {
                this.labelDescSerie.setText("N\u00e3o cadastrado");
            }
            ScreenUtil.requisitarFoco(this.textCodigoSerie);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "NotaFiscalEntrada:620");
        }
    }

    private void pesquisaFormaPagto() {
        try {
            this.textCodigoForma.setText("");
            this.labelDescForma.setText("");
            FormaPagamentoVO forma = (FormaPagamentoVO)this.serviceFormaPagamento.pesquisaVO(Laboratorio.getInstancia(), new FormaPagamentoVO(), "Pesquisando formas de pagamento", true);
            if (forma != null) {
                this.textCodigoForma.setText(String.valueOf(forma.getCodigo()));
                this.labelDescForma.setText(forma.getDescricao());
            } else {
                this.labelDescForma.setText("N\u00e3o cadastrado");
            }
            ScreenUtil.requisitarFoco(this.textCodigoForma);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "NotaFiscalEntrada:pesquisaFormaPagto");
        }
    }

    private void pesquisaCadastro() {
        try {
            this.textCodigoCadastro.setText("");
            this.labelCadastro.setText("");
            String titulo = "Pesquisando Fornecedores";
            EntidadeVO entidade = (EntidadeVO)this.serviceEntidade.pesquisaVO((Object)Laboratorio.getInstancia(), (AbstractThreadVO)new EntidadeVO(), titulo, 1, "F", true);
            if (entidade != null) {
                this.textCodigoCadastro.setText(Integer.toString(entidade.getCodigo()));
                this.labelCadastro.setText(entidade.getFantasia());
            }
            ScreenUtil.requisitarFoco(this.textCodigoCadastro);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "NotaFiscalEntrada:739");
        }
    }

    private void calcularParcelasAutomatico() throws Exception {
        if (!Funcoes.textoVazio(this.textCodigoForma.getText()) && !this.labelDescForma.getText().equals("N\u00e3o cadastrado")) {
            if (Funcoes.textoVazio(this.textCodigoSerie.getText()) || this.labelDescSerie.getText().equals("N\u00e3o cadastrado")) {
                Funcoes.mensagem(this, "A s\u00e9rie est\u00e1 incorreta", 1);
                return;
            }
            if (!Funcoes.isNumeric(this.textNumero.getText())) {
                Funcoes.mensagem(this, "N\u00famero da nota incorreto", 1);
                return;
            }
            if (!Funcoes.verificaData(this.textDataEmissao.getText())) {
                this.textDataEmissao.setText(Funcoes.formataData(new Date()));
            }
            FilialVO filial = new FilialVO();
            filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
            ArrayList<ReceberPagarBean> parcelas = this.gerarParcelas(this.getBeanPreenchido(), this.serviceFormaPagamentoParcela.load(" where fil_codigo = " + String.valueOf(filial.getCodigo()) + " and fpg_codigo = " + this.textCodigoForma.getText() + " order by fpp_parcela "));
            this.adicionarParcelasGrid(parcelas);
        }
    }

    private ArrayList<ReceberPagarBean> gerarParcelas(NotaFiscalBean bean, Set formaPagamentoParcelas) {
        ArrayList<ReceberPagarBean> parcelas = null;
        try {
            parcelas = FinanceiroUtil.gerarParcelas(bean.getSubTotal(), bean.getValor(), bean.getValorIpi(), bean.getValorIcms(), bean.getValorDescontoIncondicionado(), bean.getValorFrete(), this.tipoFrete, bean.getDataEmissao(), "P", formaPagamentoParcelas);
        }
        catch (Exception e) {
            Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel gerar o parcelamento da nota fiscal.", 2);
        }
        for (int i = 0; parcelas != null && i < parcelas.size(); ++i) {
            ReceberPagarBean beanRP = (ReceberPagarBean)parcelas.get(i);
            beanRP.setDataDocumento(new Date());
            beanRP.setDataHora(new Date());
            beanRP.setDataCompetencia(new Date());
            beanRP.setDataProcessamento(new Date());
            beanRP.setSerie(bean.getSerie());
            beanRP.setFilial(bean.getFilial());
            beanRP.setTipo("P");
            String situacao = ParametrosGerais.getTipoAutorizacaoCompra().equalsIgnoreCase("F") || ParametrosGerais.getTipoAutorizacaoCompra().equalsIgnoreCase("E") ? "P" : "A";
            beanRP.setSituacao(situacao);
            beanRP.setTipoDocumento("B");
            beanRP.setUsuario(bean.getUsuario());
            beanRP.setDataHora(new Date());
            beanRP.setNumeroDocumento(bean.getNumero().toString());
            beanRP.setIrrfPercentual(bean.getIrrfPercentual());
            beanRP.setIssPercentual(bean.getIssPercentual());
            beanRP.setPisPercentual(bean.getPisPercentual());
            beanRP.setCsllPercentual(bean.getCsllPercentual());
            beanRP.setCofinsPercentual(bean.getCofinsPercentual());
            beanRP.setInssPercentual(bean.getInssPercentual());
            beanRP.setPercentualIpi(bean.getPercentualIpi());
            beanRP.setPercentualIcms(bean.getPercentualIcms());
            beanRP.setInserir(true);
            PanelPlanoContaCentroCusto panelPlanoCentro = new PanelPlanoContaCentroCusto(beanRP, PanelPlanoContaCentroCusto.TIPO_RECEBER_PAGAR, 0L, 0L, beanRP.getFilial().getCodigo().toString());
            panelPlanoCentro.setService(new ReceberPagarService());
            panelPlanoCentro.setTipoDebitoCredito("D");
            beanRP = (ReceberPagarBean)FinanceiroUtil.gerarApropriacoes((AbstractThreadBean)beanRP, panelPlanoCentro, 2, null);
            beanRP = FinanceiroUtil.atualizaTotalSemRecalculo(beanRP);
        }
        return parcelas;
    }

    private void editarParcelas(int linha) {
        if (linha > -1 && linha < this.modeloParcela.getRowCount()) {
            ReceberPagarBean b = (ReceberPagarBean)this.modeloParcela.getValueAt(linha, 3);
            this.textParcela.setText(String.valueOf(b.getParcela()));
            this.textDataParcela.setText(Funcoes.formataData(b.getDataVencimento()));
            this.textValorParcela.setText(Funcoes.formataDecimal(b.getValorTotal()));
            this.textParcela.setEnabled(false);
            ScreenUtil.requisitarFoco(this.textDataParcela);
        }
    }

    private void okMaterial() {
        if (this.materialAux == null) {
            Funcoes.mensagem(this, "Nenhum material foi selecionado.", 2);
            if (this.textMaterial.isFocusable() && this.textMaterial.isEnabled()) {
                this.textMaterial.grabFocus();
            }
            return;
        }
        if (this.textUnitario.getText().isEmpty() || Double.parseDouble(this.textUnitario.getText()) <= 0.0) {
            if (this.textUnitario.getText().isEmpty()) {
                Funcoes.mensagem(this, "Deve-se informar o valor unit\u00e1rio do material.", 2);
            } else {
                Funcoes.mensagem(this, "O valor unit\u00e1rio do material deve ser maior que zero.", 2);
            }
            if (this.textUnitario.isFocusable() && this.textUnitario.isEnabled()) {
                this.textUnitario.grabFocus();
            }
            return;
        }
        if (this.textQuantidade.getText().isEmpty() || Double.parseDouble(this.textQuantidade.getText()) <= 0.0) {
            if (this.textQuantidade.getText().isEmpty()) {
                Funcoes.mensagem(this, "Deve-se informar a quantidade do material.", 2);
            } else {
                Funcoes.mensagem(this, "A quantidade do material deve ser maior que zero.", 2);
            }
            if (this.textQuantidade.isFocusable() && this.textQuantidade.isEnabled()) {
                this.textQuantidade.grabFocus();
            }
            return;
        }
        if (this.textValorDesconto.getText().isEmpty()) {
            this.textValorDesconto.setText(Funcoes.formataDecimal(0));
        }
        if (this.textIcms.getText().isEmpty()) {
            this.textIcms.setText(Funcoes.formataDecimal("#,##0.00##", 0));
        }
        if (this.textIpi.getText().isEmpty()) {
            this.textIpi.setText(Funcoes.formataDecimal("#,##0.00##", 0));
        }
        final NotaFiscalMaterialBean materialBean = new NotaFiscalMaterialBean();
        FilialVO filial = new FilialVO();
        filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
        materialBean.setFilial(filial);
        materialBean.setMaterial((MaterialVO)this.materialAux.toVO());
        materialBean.setQuantidade(Double.parseDouble(Funcoes.limpaDecimal(this.textQuantidade.getText().isEmpty() ? "0" : this.textQuantidade.getText())));
        materialBean.setValorUnitario(Double.parseDouble(Funcoes.limpaDecimal(this.textUnitario.getText().isEmpty() ? "0" : this.textUnitario.getText())));
        materialBean.setValorDesconto(Double.parseDouble(Funcoes.limpaDecimal(this.textValorDesconto.getText().isEmpty() ? "0" : this.textValorDesconto.getText())));
        if (this.comboIcms.getSelectedItem().equals("$")) {
            materialBean.setValorIcms(Double.parseDouble(Funcoes.limpaDecimal(this.textIcms.getText().isEmpty() ? "0" : this.textIcms.getText())));
            if (materialBean.getValorUnitario() != 0.0) {
                BigDecimal percIcms = new BigDecimal(materialBean.getValorIcms().toString()).setScale(4, ROUND).multiply(new BigDecimal("100").setScale(4, ROUND));
                percIcms = percIcms.divide(new BigDecimal(materialBean.getValorUnitario().toString()).setScale(4, ROUND).multiply(new BigDecimal(materialBean.getQuantidade().toString()).setScale(4, ROUND)), ROUND);
                materialBean.setPercentualIcms(percIcms.setScale(4, ROUND).doubleValue());
            } else {
                materialBean.setPercentualIcms(0.0);
            }
        } else {
            materialBean.setPercentualIcms(Double.parseDouble(Funcoes.limpaDecimal(this.textIcms.getText().isEmpty() ? "0" : this.textIcms.getText())));
            BigDecimal valorIcms = new BigDecimal(materialBean.getValorUnitario().toString()).setScale(4, ROUND).multiply(new BigDecimal(materialBean.getQuantidade().toString()).setScale(4, ROUND));
            valorIcms = valorIcms.multiply(new BigDecimal(materialBean.getPercentualIcms().toString()).setScale(4, ROUND)).divide(new BigDecimal("100").setScale(4, ROUND), ROUND);
            materialBean.setValorIcms(valorIcms.setScale(4, ROUND).doubleValue());
        }
        if (this.comboIpi.getSelectedItem().equals("$")) {
            materialBean.setValorIpi(Double.parseDouble(Funcoes.limpaDecimal(this.textIpi.getText().isEmpty() ? "0" : this.textIpi.getText())));
            if (materialBean.getValorUnitario() != 0.0) {
                BigDecimal percIpi = new BigDecimal(materialBean.getValorIpi().toString()).setScale(4, ROUND).multiply(new BigDecimal("100").setScale(4, ROUND));
                percIpi = percIpi.divide(new BigDecimal(materialBean.getValorUnitario().toString()).setScale(4, ROUND).multiply(new BigDecimal(materialBean.getQuantidade().toString()).setScale(4, ROUND)), ROUND);
                materialBean.setPercentualIpi(percIpi.setScale(4, ROUND).doubleValue());
            } else {
                materialBean.setPercentualIpi(0.0);
            }
        } else {
            materialBean.setPercentualIpi(Double.parseDouble(Funcoes.limpaDecimal(this.textIpi.getText().isEmpty() ? "0" : this.textIpi.getText())));
            BigDecimal valorIpi = new BigDecimal(materialBean.getValorUnitario().toString()).setScale(4, ROUND).multiply(new BigDecimal(materialBean.getQuantidade().toString()).setScale(4, ROUND));
            valorIpi = valorIpi.multiply(new BigDecimal(materialBean.getPercentualIpi().toString()).setScale(4, ROUND)).divide(new BigDecimal("100").setScale(4, ROUND), ROUND);
            materialBean.setValorIpi(valorIpi.setScale(4, ROUND).doubleValue());
        }
        BigDecimal valorDesconto = new BigDecimal(materialBean.getValorDesconto() == null ? "0" : materialBean.getValorDesconto().toString()).setScale(4, ROUND);
        BigDecimal percDesconto = BigDecimal.ZERO.setScale(4, ROUND);
        percDesconto = new BigDecimal(materialBean.getValorDesconto().toString()).setScale(4, ROUND).multiply(new BigDecimal("100").setScale(4, ROUND));
        percDesconto = percDesconto.divide(new BigDecimal(materialBean.getValorUnitario().toString()).setScale(4, ROUND).multiply(new BigDecimal(materialBean.getQuantidade().toString()).setScale(4, ROUND)), ROUND);
        materialBean.setPercentualDesconto(percDesconto.setScale(CASAS, ROUND).doubleValue());
        BigDecimal valorTotal = new BigDecimal("100").setScale(4, ROUND);
        valorTotal = new BigDecimal(materialBean.getValorUnitario().toString()).setScale(4, ROUND).multiply(new BigDecimal(materialBean.getQuantidade().toString()).setScale(4, ROUND));
        valorTotal = valorTotal.add(new BigDecimal(materialBean.getValorIcms().toString()).setScale(4, ROUND)).add(new BigDecimal(materialBean.getValorIpi().toString()).setScale(4, ROUND));
        valorTotal = valorTotal.subtract(valorDesconto);
        materialBean.setValorTotal(valorTotal.setScale(4, ROUND).doubleValue());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NotaFiscalEntrada.this.adicionaMaterial(materialBean);
                NotaFiscalEntrada.this.aplicaNovaSequencia();
                if (NotaFiscalEntrada.this.textMaterial.isEnabled() && NotaFiscalEntrada.this.textMaterial.isFocusable()) {
                    NotaFiscalEntrada.this.textMaterial.grabFocus();
                }
            }
        });
    }

    private boolean adicionaMaterial(NotaFiscalMaterialBean materialBean) {
        for (int i = 0; i < this.modeloMateriais.getRowCount(); ++i) {
            NotaFiscalMaterialBean material = (NotaFiscalMaterialBean)this.modeloMateriais.getValueAt(i, 10);
            if (material.getMaterial().getCodigo().intValue() != materialBean.getMaterial().getCodigo().intValue()) continue;
            if (!this.isAlterandoMaterial) {
                Funcoes.mensagem(this, "O material j\u00e1 foi inserido.", 2);
                if (this.textMaterial.isEnabled() && this.textMaterial.isFocusable()) {
                    this.textMaterial.grabFocus();
                }
                return false;
            }
            this.modeloMateriais.removeLine(i);
            break;
        }
        if (materialBean.getMaterial() != null) {
            try {
                if (this.materialAux == null) {
                    this.materialAux = (MaterialBean)new MaterialService().getTodos(materialBean.getFilial().getCodigo().toString(), materialBean.getMaterial().getCodigo().toString(), materialBean.getNotaFiscal() != null && materialBean.getNotaFiscal().getCodigo() != null ? materialBean.getNotaFiscal() : null, null);
                }
            }
            catch (Exception e1) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar material.\n" + e1.getMessage(), e1.getStackTrace());
                return false;
            }
        }
        this.editarVisualizarLotes(this.materialAux, materialBean, false);
        materialBean.getMaterial().setInserir(true);
        this.materialAux.setInserir(true);
        if (this.materialSemOrdem(materialBean)) {
            materialBean.setOrdem(this.getProximoRegistro());
        }
        if (this.materialAux.getSolicitarLote() == false || this.materialAux.getSolicitarLote() != false && this.materialAux.getQuantidadeInformadaLotes() > 0.0 || ParametrosGerais.getTipoMovimentarEstoque().equalsIgnoreCase("C")) {
            if (!this.alterarOrdemCamposNota) {
                this.modeloMateriais.addLine(new Object[]{materialBean.getOrdem(), materialBean.getMaterial().getDescricao(), Funcoes.formataDecimal("###,##0.0000", materialBean.getValorUnitario()), Funcoes.formataDecimal(materialBean.getQuantidade()), Funcoes.formataDecimal(materialBean.getValorDesconto()), Funcoes.formataDecimal("###,##0.0000", materialBean.getValorIpi()), Funcoes.formataDecimal(materialBean.getPercentualIpi()), Funcoes.formataDecimal("###,##0.0000", materialBean.getValorIcms()), Funcoes.formataDecimal(materialBean.getPercentualIcms()), Funcoes.formataDecimal("###,##0.00##", materialBean.getValorTotal()), materialBean, this.materialAux, Boolean.TRUE});
            } else {
                this.modeloMateriais.addLine(new Object[]{materialBean.getOrdem(), materialBean.getMaterial().getDescricao(), Funcoes.formataDecimal(materialBean.getQuantidade()), Funcoes.formataDecimal("###,##0.0000", materialBean.getValorUnitario()), Funcoes.formataDecimal(materialBean.getValorDesconto()), Funcoes.formataDecimal("###,##0.0000", materialBean.getValorIcms()), Funcoes.formataDecimal(materialBean.getPercentualIcms()), Funcoes.formataDecimal("###,##0.0000", materialBean.getValorIpi()), Funcoes.formataDecimal(materialBean.getPercentualIpi()), Funcoes.formataDecimal("###,##0.00##", materialBean.getValorTotal()), materialBean, this.materialAux, Boolean.TRUE});
            }
            this.calculaTotais();
            if (this.modeloMateriais.getColunaOrdenacao() != -1) {
                this.modeloMateriais.ordenarColunaSemTrocarSentido(this.modeloMateriais.getColunaOrdenacao());
            } else {
                this.modeloMateriais.ordenarColunaSemTrocarSentido(1);
            }
            this.textMaterial.setText("");
            this.labelDescricaoMaterial.setText("");
            this.textUnitario.setText("");
            this.textQuantidade.setText("");
            this.textIpi.setText("");
            this.textIcms.setText("");
            this.textValorDesconto.setText("");
            this.labelVlrTotalMaterial.setText("");
            this.isAlterandoMaterial = false;
            this.materialAux = null;
            return true;
        }
        return false;
    }

    private int getProximoRegistro() {
        ++this.registro;
        return this.registro;
    }

    private void setProximoRegistro(int registro) {
        this.registro = registro;
    }

    private boolean materialSemOrdem(NotaFiscalMaterialBean materialBean) {
        return materialBean.getOrdem() == null;
    }

    private void aplicaNovaSequencia() {
        if (this.modeloMateriaisVazio()) {
            int x;
            ArrayList<Integer> sequenciaAtual = new ArrayList<Integer>();
            ArrayList sequenciaNova = new ArrayList();
            ArrayList<NotaFiscalMaterialBean> aplicarSequencia = new ArrayList<NotaFiscalMaterialBean>();
            for (x = 0; x < this.modeloMateriais.getRowCount(); ++x) {
                NotaFiscalMaterialBean nfmb = (NotaFiscalMaterialBean)this.modeloMateriais.getValueAt(x, 10);
                sequenciaAtual.add(x, nfmb.getOrdem());
            }
            sequenciaNova = (ArrayList)sequenciaAtual.clone();
            Collections.sort(sequenciaNova, new Comparator(){

                public int compare(Object o1, Object o2) {
                    int valorProximo;
                    int valorAnterior = (Integer)o1;
                    return valorAnterior < (valorProximo = ((Integer)o2).intValue()) ? -1 : (valorAnterior > valorProximo ? 1 : 0);
                }
            });
            this.setProximoRegistro(0);
            for (x = 0; x < sequenciaNova.size(); ++x) {
                int linha = sequenciaAtual.indexOf(sequenciaNova.get(x));
                int ordemNova = this.getProximoRegistro();
                NotaFiscalMaterialBean nfmb = (NotaFiscalMaterialBean)this.modeloMateriais.getValueAt(linha, 10);
                if (nfmb.getOrdem() == ordemNova) continue;
                nfmb.setOrdem(ordemNova);
                aplicarSequencia.add(nfmb);
            }
            for (x = 0; x < aplicarSequencia.size(); ++x) {
                this.isAlterandoMaterial = true;
                this.adicionaMaterial((NotaFiscalMaterialBean)aplicarSequencia.get(x));
            }
            this.isAlterandoMaterial = false;
        } else {
            this.setProximoRegistro(0);
        }
    }

    public boolean modeloMateriaisVazio() {
        return this.modeloMateriais.getRowCount() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean mostrarPesquisaFornecedor(NotaFiscalBean nota) {
        InfoPerguntaPesquisaFornecedor pergunta = this.getTopLevelAncestor() instanceof Dialog ? new InfoPerguntaPesquisaFornecedor((Dialog)this.getTopLevelAncestor(), false, "Pesquisa de fornecedor") : new InfoPerguntaPesquisaFornecedor((Frame)this.getTopLevelAncestor(), false, "Pesquisa de fornecedor");
        StringBuilder buf = new StringBuilder();
        buf.append("select lay_pesquisafornecedor from layout ");
        buf.append("where lay_codigo = ?");
        buf.append("\tand fil_codigo = ?");
        PreparedStatement prepSelect = Conexao.getPreparedStatement(buf.toString());
        try {
            prepSelect.setInt(1, ParametrosGerais.getLayCodigo());
            prepSelect.setInt(2, Integer.parseInt(Variaveis.filialPadrao));
            try (ResultSet rs = null;){
                rs = prepSelect.executeQuery();
                if (!rs.next() || DBUtil.campoNull(rs.getString("lay_pesquisafornecedor")) || Funcoes.textoVazio(StringUtil.getValor(rs.getString("lay_pesquisafornecedor"), "componente"))) {
                    Funcoes.mensagem(this, "Nenhum modelo de pesquisa de fornecedor foi configurado.", 2);
                    boolean bl = false;
                    return bl;
                }
                pergunta.setPerguntas(rs.getString("lay_pesquisafornecedor"), null);
            }
        }
        catch (Exception e) {
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar pesquisa de fornecedor.\n" + e.getMessage(), e.getStackTrace());
            return false;
        }
        pergunta.setVisible(true);
        if (!pergunta.getSalvarPressionado()) return false;
        nota.setPesquisaFornecedor(pergunta.getPergunta());
        buf.delete(0, buf.length());
        buf.append("update notafiscal set nfi_pesquisafornecedor = ?");
        buf.append(" where fil_codigo = ?");
        buf.append("   and nfi_numero = ?");
        PreparedStatement prepUpdate = Conexao.getPreparedStatement(buf.toString());
        try {
            prepUpdate.setString(1, nota.getPesquisaFornecedor());
            prepUpdate.setInt(2, nota.getFilial().getCodigo());
            prepUpdate.setLong(3, nota.getNumero());
            prepUpdate.addBatch();
            prepUpdate.executeBatch();
            Conexao.arquivaSQL();
            prepUpdate.close();
            return true;
        }
        catch (Exception e) {
            try {
                Conexao.anulaSQL();
                prepUpdate.cancel();
                return false;
            }
            catch (SQLException sQLException) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel atualizar nota fiscal com pesquisa de fornecedor.\n" + e.getMessage(), e.getStackTrace());
            }
        }
        return false;
    }

    private void adicionarParcelasGrid(ArrayList<ReceberPagarBean> parcelas) {
        BigDecimal valorNota;
        this.modeloParcela.clear();
        BigDecimal totalParcelas = valorNota = BigDecimal.valueOf(Double.parseDouble(Funcoes.limpaDecimal(this.labelVlrTotal.getText())));
        for (int i = 0; i < parcelas.size(); ++i) {
            ReceberPagarBean r = parcelas.get(i);
            BigDecimal parcela = new BigDecimal(String.valueOf(r.getValorTotal())).setScale(2, RoundingMode.FLOOR);
            BigDecimal valorDiferenca = totalParcelas.subtract(parcela);
            if (i == parcelas.size() - 1) {
                BigDecimal valorTotal = new BigDecimal(String.valueOf(r.getValorTotal()));
                if (parcelas.size() == 1) {
                    totalParcelas = parcela.subtract(totalParcelas);
                    valorDiferenca = valorNota.subtract(parcela);
                }
                if (valorDiferenca.compareTo(BigDecimal.ZERO) != 0) {
                    parcela = valorTotal.add(valorDiferenca);
                    r.setValorTotal(parcela.doubleValue());
                }
            } else {
                totalParcelas = totalParcelas.subtract(parcela);
            }
            this.modeloParcela.addLine(new Object[]{String.valueOf(r.getParcela()), Funcoes.formataData(r.getDataVencimento()), Funcoes.formataDecimal("###,##0.00", parcela.doubleValue()), r});
        }
        this.modeloParcela.ordenarColuna(0, 1);
    }

    private void okParcela() {
        boolean recalculaValores = false;
        if (Funcoes.isNumeric(this.textParcela.getText()) && Funcoes.isNumeric(this.textValorParcela.getText()) && Funcoes.verificaData(this.textDataParcela.getText())) {
            int parcela = Integer.parseInt(this.textParcela.getText());
            BigDecimal novoValor = new BigDecimal(this.textValorParcela.getText());
            novoValor = novoValor.setScale(CASAS, ROUND);
            ReceberPagarBean aux2 = null;
            ArrayList<ReceberPagarBean> arrayRecPag = new ArrayList<ReceberPagarBean>();
            BigDecimal diferencaValores = null;
            for (int i = 0; i < this.modeloParcela.getRowCount(); ++i) {
                arrayRecPag.add((ReceberPagarBean)this.modeloParcela.getValueAt(i, 3));
            }
            for (ReceberPagarBean aux2 : arrayRecPag) {
                if (aux2.getParcela() != parcela) continue;
                diferencaValores = new BigDecimal(aux2.getValorTotal().toString()).subtract(novoValor);
                diferencaValores = diferencaValores.setScale(CASAS, ROUND);
                PanelPlanoContaCentroCusto panelPlanoCentro = new PanelPlanoContaCentroCusto(aux2, PanelPlanoContaCentroCusto.TIPO_RECEBER_PAGAR, 0L, 0L, aux2.getFilial().getCodigo().toString());
                panelPlanoCentro.setPlanoContas(aux2.getPlanosContas());
                panelPlanoCentro.setCentrosCusto(aux2.getCentrosCusto());
                if (aux2.getTipo().equalsIgnoreCase("R")) {
                    panelPlanoCentro.setTipoDebitoCredito("C");
                } else {
                    panelPlanoCentro.setTipoDebitoCredito("D");
                }
                BigDecimal auxValorPlano = new BigDecimal(aux2.getValor().toString());
                auxValorPlano = auxValorPlano.subtract(diferencaValores);
                auxValorPlano = auxValorPlano.setScale(CASAS, ROUND);
                aux2.setValor(auxValorPlano.doubleValue());
                aux2 = (ReceberPagarBean)FinanceiroUtil.gerarApropriacoes((AbstractThreadBean)aux2, panelPlanoCentro, 2, null);
                if (aux2.getValorTotal().doubleValue() != novoValor.doubleValue()) {
                    recalculaValores = true;
                }
                aux2.setValorTotal(novoValor.doubleValue());
                aux2.setDataVencimento(Funcoes.stringToDate(this.textDataParcela.getText()));
                break;
            }
            if (this.modeloParcela.getRowCount() - 1 > 0 && recalculaValores) {
                Object[] mensagens;
                int parcelaSelecionada = this.tableParcela.getSelectedRow();
                int opcao = -1;
                if (parcelaSelecionada < this.modeloParcela.getRowCount() - 1) {
                    mensagens = new String[]{"Todas", "Subsequentes"};
                    opcao = JOptionPane.showOptionDialog(this, "Deseja ratear a diferen\u00e7a sobre todas as outras parcelas ou sobre as parcelas subsequentes?", "Ratear diferen\u00e7a", 0, 2, null, mensagens, mensagens[0]);
                }
                if (parcelaSelecionada == this.modeloParcela.getRowCount() - 1) {
                    mensagens = new String[]{"Ratear"};
                    opcao = JOptionPane.showOptionDialog(this, "Deseja ratear a diferen\u00e7a sobre todas as outras parcelas?", "Ratear diferen\u00e7a", 0, 2, null, mensagens, mensagens[0]);
                }
                BigDecimal divDiferencaValores = null;
                if (opcao == 0) {
                    if (diferencaValores != null) {
                        divDiferencaValores = diferencaValores.divide(new BigDecimal(this.modeloParcela.getRowCount() - 1), ROUND).setScale(2, ROUND);
                        diferencaValores = diferencaValores.subtract(divDiferencaValores.multiply(new BigDecimal(this.modeloParcela.getRowCount() - 1)));
                    }
                } else if (diferencaValores != null) {
                    parcela = parcelaSelecionada == this.modeloParcela.getRowCount() - 1 ? parcelaSelecionada : parcela;
                    divDiferencaValores = diferencaValores.divide(new BigDecimal(this.modeloParcela.getRowCount() - parcela), ROUND).setScale(2, ROUND);
                    diferencaValores = diferencaValores.subtract(divDiferencaValores.multiply(new BigDecimal(this.modeloParcela.getRowCount() - parcela)));
                }
                if (divDiferencaValores != null) {
                    divDiferencaValores = divDiferencaValores.setScale(CASAS, ROUND);
                }
                Iterator<Object> it = arrayRecPag.iterator();
                boolean addDif = true;
                while (it.hasNext()) {
                    aux2 = (ReceberPagarBean)it.next();
                    if ((opcao != 0 || aux2.getParcela() == parcela) && (opcao != 1 || aux2.getParcela() <= parcela)) continue;
                    PanelPlanoContaCentroCusto panelPlanoCentro = new PanelPlanoContaCentroCusto(aux2, PanelPlanoContaCentroCusto.TIPO_RECEBER_PAGAR, 0L, 0L, aux2.getFilial().getCodigo().toString());
                    panelPlanoCentro.setPlanoContas(aux2.getPlanosContas());
                    panelPlanoCentro.setCentrosCusto(aux2.getCentrosCusto());
                    String tipoDebitoCredito = aux2.getTipo().equalsIgnoreCase("R") ? "C" : "D";
                    panelPlanoCentro.setTipoDebitoCredito(tipoDebitoCredito);
                    BigDecimal auxValorPlano = new BigDecimal(aux2.getValor().toString());
                    auxValorPlano = !addDif ? auxValorPlano.add(divDiferencaValores) : auxValorPlano.add(divDiferencaValores).add(diferencaValores);
                    auxValorPlano = auxValorPlano.setScale(CASAS, ROUND);
                    BigDecimal auxValorTotal = new BigDecimal(aux2.getValorTotal().toString());
                    auxValorTotal = !addDif ? auxValorTotal.add(divDiferencaValores) : auxValorTotal.add(divDiferencaValores).add(diferencaValores);
                    auxValorTotal = auxValorTotal.setScale(CASAS, ROUND);
                    aux2.setValor(auxValorPlano.doubleValue());
                    aux2 = (ReceberPagarBean)FinanceiroUtil.gerarApropriacoes((AbstractThreadBean)aux2, panelPlanoCentro, 2, null);
                    aux2.setValor(auxValorPlano.doubleValue());
                    aux2.setValorTotal(auxValorTotal.doubleValue());
                    if (!addDif) continue;
                    addDif = false;
                }
            }
            this.textParcela.clear();
            this.textDataParcela.clear();
            this.textValorParcela.clear();
            this.textParcela.setEnabled(true);
            this.textValorParcela.setEnabled(true);
            if (!this.textParcela.isEnabled()) {
                this.textParcela.setEnabled(true);
            }
            this.adicionarParcelasGrid(arrayRecPag);
        }
    }

    private void controlaCampos() {
        boolean habilitar = this.getStatus() == 2 || this.getStatus() == 3;
        for (int i = 0; i < this.modeloParcela.getRowCount(); ++i) {
            ReceberPagarBean recPag = (ReceberPagarBean)this.modeloParcela.getValueAt(i, 3);
            if (recPag == null || recPag.getSituacao() == null || !recPag.getSituacao().equalsIgnoreCase("Q")) continue;
            habilitar = false;
            Funcoes.mensagem(this, "N\u00e3o \u00e9 poss\u00edvel alterar a nota fiscal, pois a parcela " + recPag.getParcela() + " foi baixada.", 2);
            break;
        }
        this.textCodigoSerie.setEnabled(habilitar);
        this.buttonBuscaSerie.setEnabled(habilitar);
        this.textNumero.setEnabled(habilitar);
        this.textDataEmissao.setEnabled(habilitar);
        this.buttonBuscaDataEmissao.setEnabled(habilitar);
        this.textCodigoCadastro.setEnabled(habilitar);
        this.buttonBuscaCadastro.setEnabled(habilitar);
        this.textDescontoNota.setEnabled(habilitar);
        this.comboDesconto.setEnabled(habilitar);
        this.textFrete.setEnabled(habilitar);
        this.textMaterial.setEnabled(habilitar);
        this.buttonBuscaMaterial.setEnabled(habilitar);
        this.textValorMaterial.setEnabled(habilitar);
        this.buttonOKMaterial.setEnabled(habilitar);
        this.tableMateriais.setEnabled(habilitar);
        this.textMaterial.setEnabled(habilitar);
        this.textUnitario.setEnabled(habilitar);
        this.textQuantidade.setEnabled(habilitar);
        this.textValorDesconto.setEnabled(habilitar);
        this.textIpi.setEnabled(habilitar);
        this.textIcms.setEnabled(habilitar);
        this.buttonOKMaterial.setEnabled(habilitar);
        this.tableMateriais.setEnabled(habilitar);
        this.buttonRateioFrete.setEnabled(habilitar);
        this.comboIcms.setEnabled(habilitar);
        this.comboIpi.setEnabled(habilitar);
        this.textCodigoForma.setEnabled(habilitar && Acesso.getAcesso(ACESSO_ALTERAR_FORMA_PAGAMENTO));
        this.buttonBuscaForma.setEnabled(habilitar && Acesso.getAcesso(ACESSO_ALTERAR_FORMA_PAGAMENTO));
        this.textParcela.setEnabled(habilitar && Acesso.getAcesso(ACESSO_ALTERAR_PARCELAMENTO));
        this.textDataParcela.setEnabled(habilitar && Acesso.getAcesso(ACESSO_ALTERAR_PARCELAMENTO));
        this.buttonBuscaDataParcela.setEnabled(habilitar && Acesso.getAcesso(ACESSO_ALTERAR_PARCELAMENTO));
        this.textValorParcela.setEnabled(habilitar && Acesso.getAcesso(ACESSO_ALTERAR_PARCELAMENTO));
        this.buttonOKParcela.setEnabled(habilitar && Acesso.getAcesso(ACESSO_ALTERAR_PARCELAMENTO));
        this.tableParcela.setEnabled(habilitar);
        this.textObs.setEnabled(habilitar);
        if (this.getStatus() == 1) {
            this.itemImportarPedidoCompra.setEnabled(false);
            this.tableMateriais.setEnabled(true);
        } else {
            this.itemImportarPedidoCompra.setEnabled(true);
        }
        this.itemVisualizaPesquisaFornecedor.setVisible(false);
        this.itemVisualizaPesquisaFornecedor.setEnabled(false);
    }

    private NotaFiscalBean getBeanPreenchido() {
        NotaFiscalBean bean = null;
        bean = this.notaFiscalAux == null ? new NotaFiscalBean() : this.notaFiscalAux;
        bean.setMateriais(null);
        bean.setMateriaisAlterados(null);
        FilialVO filial = new FilialVO();
        filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
        if (!Funcoes.textoVazio(this.textCodigoSerie.getText())) {
            SeriesVO serie = new SeriesVO();
            serie.setFilial(filial);
            serie.setCodigo(this.textCodigoSerie.getText());
            bean.setSerie(serie);
        }
        if (!Funcoes.textoVazio(this.textCodigoForma.getText())) {
            FormaPagamentoVO forma = new FormaPagamentoVO();
            forma.setFilial(filial);
            forma.setCodigo(Integer.parseInt(this.textCodigoForma.getText()));
            bean.setFormaPagamento(forma);
        }
        UsuarioVO usuario = new UsuarioVO();
        usuario.setCodigo(Variaveis.login);
        bean.setUsuario(usuario);
        bean.setFilial(filial);
        bean.setDataHora(new Date());
        bean.setDataEmissao(Funcoes.verificaData(this.textDataEmissao.getText()) ? Funcoes.stringToDate(this.textDataEmissao.getText()) : new Date());
        bean.setTipo("E");
        try {
            bean.setNumero(Long.parseLong(this.textNumero.getText()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        bean.setObservacao(this.textObs.getText());
        bean.setValor(Funcoes.isNumeric(this.labelVlrTotal.getText()) ? Double.parseDouble(Funcoes.limpaDecimal(this.labelVlrTotal.getText())) : 0.0);
        bean.setSituacao("A");
        bean.setTipoCadastro("F");
        if (!Funcoes.textoVazio(this.textCodigoCadastro.getText())) {
            EntidadeVO entidade = new EntidadeVO();
            entidade.setFilial(filial);
            entidade.setCodigo(Integer.parseInt(this.textCodigoCadastro.getText()));
            bean.setEntidade(entidade);
        }
        bean.setValorIpi(0.0);
        bean.setPercentualIpi(0.0);
        bean.setValorIcms(0.0);
        bean.setPercentualIcms(0.0);
        HashSet<ReceberPagarBean> receberPagar = new HashSet<ReceberPagarBean>();
        for (int i = 0; i < this.modeloParcela.getRowCount(); ++i) {
            if (!(this.modeloParcela.getValueAt(i, 3) instanceof ReceberPagarBean)) continue;
            receberPagar.add((ReceberPagarBean)this.modeloParcela.getValueAt(i, 3));
        }
        bean.setParcelas(receberPagar);
        ArrayList<MaterialBean> materiaisAlterados = new ArrayList<MaterialBean>();
        ArrayList<NotaFiscalMaterialBean> materiais = new ArrayList<NotaFiscalMaterialBean>();
        BigDecimal somatorioValores = new BigDecimal("0").setScale(4, ROUND);
        BigDecimal somatorioIPI = new BigDecimal("0").setScale(4, ROUND);
        BigDecimal somatorioICMS = new BigDecimal("0").setScale(4, ROUND);
        for (int i = 0; i < this.modeloMateriais.getRowCount(); ++i) {
            NotaFiscalMaterialBean materialBean = (NotaFiscalMaterialBean)this.modeloMateriais.getValueAt(i, 10);
            somatorioIPI = somatorioIPI.add(new BigDecimal(materialBean.getValorIpi().toString()).setScale(4, ROUND));
            somatorioICMS = somatorioICMS.add(new BigDecimal(materialBean.getValorIcms().toString()).setScale(4, ROUND));
            somatorioValores = somatorioValores.add(new BigDecimal(materialBean.getValorUnitario().toString()).multiply(new BigDecimal(materialBean.getQuantidade().toString())).setScale(4, ROUND));
            somatorioValores = somatorioValores.subtract(new BigDecimal(materialBean.getValorDesconto().toString()).setScale(4, ROUND));
            materiais.add(materialBean);
            MaterialBean materialBeanAlterado = (MaterialBean)this.modeloMateriais.getValueAt(i, 11);
            materialBeanAlterado.setIpiUltimaCompra(new BigDecimal(materialBean.getValorIpi().toString()).setScale(4, ROUND).doubleValue());
            materiaisAlterados.add((MaterialBean)this.modeloMateriais.getValueAt(i, 11));
        }
        for (MaterialBean matExcluido : this.materiaisExcluidos) {
            matExcluido.setExcluido(true);
            materiaisAlterados.add(matExcluido);
        }
        if (somatorioValores.compareTo(BigDecimal.ZERO) > 0) {
            bean.setValorIpi(somatorioIPI.setScale(4, ROUND).doubleValue());
            bean.setPercentualIpi(somatorioIPI.multiply(new BigDecimal("100").setScale(4, ROUND)).divide(somatorioValores, ROUND).setScale(4, ROUND).doubleValue());
            bean.setValorIcms(somatorioICMS.setScale(4, ROUND).doubleValue());
            bean.setPercentualIcms(somatorioICMS.multiply(new BigDecimal("100").setScale(4, ROUND)).divide(somatorioValores, ROUND).setScale(4, ROUND).doubleValue());
        } else {
            bean.setValorIpi(0.0);
            bean.setPercentualIpi(0.0);
            bean.setValorIcms(0.0);
            bean.setPercentualIcms(0.0);
        }
        bean.setSubTotal(somatorioValores.setScale(4, ROUND).doubleValue());
        if (this.comboDesconto.getSelectedItem().equals("$")) {
            bean.setValorDescontoIncondicionado(Double.parseDouble(Funcoes.limpaDecimal(this.textDescontoNota.getText().isEmpty() ? "0" : this.textDescontoNota.getText())));
            BigDecimal percDesc = new BigDecimal(bean.getValorDescontoIncondicionado().toString()).setScale(4, ROUND).multiply(new BigDecimal("100").setScale(4, ROUND));
            percDesc = bean.getSubTotal() == 0.0 ? BigDecimal.ZERO : percDesc.divide(new BigDecimal(bean.getSubTotal().toString()).setScale(4, ROUND), 4, ROUND);
            bean.setPercentualDescontoIncondicionado(percDesc.setScale(4, ROUND).doubleValue());
        } else {
            bean.setPercentualDescontoIncondicionado(Double.parseDouble(Funcoes.limpaDecimal(this.textDescontoNota.getText().isEmpty() ? "0" : this.textDescontoNota.getText())));
            BigDecimal valorDesc = new BigDecimal(bean.getPercentualDescontoIncondicionado().toString()).setScale(4, ROUND).multiply(new BigDecimal(bean.getSubTotal().toString()).setScale(4, ROUND));
            valorDesc = valorDesc.divide(new BigDecimal("100").setScale(4, ROUND), 4, ROUND);
            bean.setValorDescontoIncondicionado(valorDesc.setScale(CASAS, ROUND).doubleValue());
        }
        bean.setValorFrete(Double.parseDouble(Funcoes.limpaDecimal(this.textFrete.getText().isEmpty() ? "0" : this.textFrete.getText())));
        BigDecimal subTotal = new BigDecimal(String.valueOf(bean.getSubTotal() - bean.getValorDescontoIncondicionado() + bean.getValorFrete() + bean.getValorIcms() + bean.getValorIpi())).setScale(2, ROUND);
        bean.setValor(subTotal.doubleValue());
        if (materiais.size() > 0) {
            bean.setMateriais(materiais);
        }
        for (MaterialBean matBean : materiaisAlterados) {
            if (matBean.isExcluido()) continue;
            matBean.setFreteUltimaCompra(bean.getValorFrete());
        }
        if (materiaisAlterados.size() > 0) {
            bean.setMateriaisAlterados(materiaisAlterados);
        }
        if (this.pedidoAux != null) {
            bean.setPedido((PedidoVO)this.pedidoAux.toVO());
        }
        return bean;
    }

    private void calculaTotalMaterial() {
        BigDecimal unitario = (this.textUnitario.getText().isEmpty() ? new BigDecimal("0") : new BigDecimal(Funcoes.limpaDecimal(this.textUnitario.getText()))).setScale(4, ROUND);
        BigDecimal quantidade = (this.textQuantidade.getText().isEmpty() ? new BigDecimal("0") : new BigDecimal(Funcoes.limpaDecimal(this.textQuantidade.getText()))).setScale(4, ROUND);
        BigDecimal desconto = (this.textValorDesconto.getText().isEmpty() ? new BigDecimal("0") : new BigDecimal(Funcoes.limpaDecimal(this.textValorDesconto.getText()))).setScale(4, ROUND);
        BigDecimal ipi = (this.textIpi.getText().isEmpty() ? new BigDecimal("0") : new BigDecimal(Funcoes.limpaDecimal(this.textIpi.getText()))).setScale(4, ROUND);
        BigDecimal icms = (this.textIcms.getText().isEmpty() ? new BigDecimal("0") : new BigDecimal(Funcoes.limpaDecimal(this.textIcms.getText()))).setScale(4, ROUND);
        BigDecimal total = new BigDecimal("0").setScale(4, ROUND);
        total = total.add(unitario);
        total = total.multiply(quantidade);
        total = total.subtract(desconto);
        total = this.comboIpi.getSelectedItem().equals("$") ? total.add(ipi) : total.add(ipi.multiply(unitario).multiply(quantidade).divide(new BigDecimal("100").setScale(CASAS, ROUND)).setScale(CASAS, ROUND));
        total = this.comboIcms.getSelectedItem().equals("$") ? total.add(icms) : total.add(icms.multiply(unitario).multiply(quantidade).divide(new BigDecimal("100").setScale(CASAS, ROUND)).setScale(CASAS, ROUND));
        total = total.setScale(4, ROUND);
        this.labelVlrTotalMaterial.setText(Funcoes.formataDecimal("#,##0.00##", total.doubleValue()));
    }

    private void limparCampos() {
        this.textCodigoSerie.setText("");
        this.labelDescSerie.setText("");
        this.textNumero.setText("");
        this.textDataEmissao.setText("");
        this.textCodigoCadastro.setText("");
        this.labelCadastro.setText("");
        this.textMaterial.setText("");
        this.labelDescricaoMaterial.setText("");
        this.textUnitario.setText("");
        this.textQuantidade.setText("");
        this.textIcms.setText("");
        this.textIpi.setText("");
        this.labelVlrTotalIpi.setText("");
        this.labelVlrTotalIcms.setText("");
        this.labelVlrTotalMaterial.setText("");
        this.textFrete.setText("");
        this.modeloMateriais.clear();
        this.labelVlrTotal.setText("");
        this.textCodigoForma.setText("");
        this.labelDescForma.setText("");
        this.textParcela.setText("");
        this.textDataParcela.setText("");
        this.textValorParcela.setText("");
        this.modeloParcela.clear();
        this.textObs.setText("");
        this.labelVlrSubTotalNota.setText("");
        this.textDescontoNota.setText("");
        this.comboDesconto.setSelectedItem("$");
        this.isAlterandoMaterial = false;
        this.materialAux = null;
        this.notaFiscalAux = null;
        this.pedidoAux = null;
        this.serieRepetidaAux = null;
        this.numeroRepetidoAux = null;
        this.codigoFornecedorAux = null;
        this.notaMovimentouEstoque = false;
        this.conferenciaMovimentouEstoque = false;
        this.materiaisExcluidos.clear();
    }

    @Override
    public boolean validaCampos() {
        if (Funcoes.textoVazio(this.textCodigoSerie.getText())) {
            Funcoes.mensagem(this, "S\u00e9rie n\u00e3o informada.", 2);
            ScreenUtil.requisitarFoco(this.textCodigoSerie);
            return false;
        }
        if (Funcoes.textoVazio(this.textNumero.getText())) {
            Funcoes.mensagem(this, "N\u00famero da nota fiscal n\u00e3o informado.", 2);
            ScreenUtil.requisitarFoco(this.textNumero);
            return false;
        }
        if (Funcoes.textoVazio(this.textDataEmissao.getText())) {
            Funcoes.mensagem(this, "Data de emiss\u00e3o n\u00e3o informada.", 2);
            ScreenUtil.requisitarFoco(this.textDataEmissao);
            return false;
        }
        if (!Funcoes.textoVazio(this.textDataEmissao.getText()) && !Funcoes.verificaData(this.textDataEmissao.getText())) {
            Funcoes.mensagem(this, "Data de emiss\u00e3o inv\u00e1lida.", 2);
            ScreenUtil.requisitarFoco(this.textDataEmissao);
            return false;
        }
        if (Funcoes.textoVazio(this.textCodigoCadastro.getText()) || this.labelCadastro.getText().equals("N\u00e3o cadastrado")) {
            Funcoes.mensagem(this, "Cadastro inv\u00e1lido.", 2);
            ScreenUtil.requisitarFoco(this.textCodigoCadastro);
            return false;
        }
        if (this.modeloMateriais.getRowCount() == 0) {
            Funcoes.mensagem(this, "Nenhum material informado.", 2);
            ScreenUtil.requisitarFoco(this.textMaterial);
            return false;
        }
        if (this.modeloParcela.getRowCount() == 0) {
            Funcoes.mensagem(this, "Forma de pagamento n\u00e3o informada.", 2);
            ScreenUtil.requisitarFoco(this.textCodigoForma);
            return false;
        }
        BigDecimal valorTotal = new BigDecimal(Funcoes.limpaDecimal(this.labelVlrTotal.getText())).setScale(CASAS, ROUND);
        if (this.getSomaParcelas().doubleValue() != valorTotal.doubleValue()) {
            Funcoes.mensagem(this, "A soma das parcelas \u00e9 diferente do valor da nota.", 2);
            ScreenUtil.requisitarFoco(this.textParcela);
            return false;
        }
        if (Funcoes.textoVazio(this.textCodigoForma.getText())) {
            Funcoes.mensagem(this, "Forma de Pagamento n\u00e3o informada.", 2);
            ScreenUtil.requisitarFoco(this.textCodigoForma);
            return false;
        }
        return true;
    }

    public Double getSomaParcelas() {
        Iterator it = this.getBeanPreenchido().getParcelas().iterator();
        BigDecimal soma = new BigDecimal("0").setScale(4, ROUND);
        while (it.hasNext()) {
            ReceberPagarBean bean = (ReceberPagarBean)it.next();
            soma = soma.add(new BigDecimal(bean.getValorTotal().toString()).setScale(4, ROUND));
        }
        soma = soma.setScale(2, ParametrosGerais.getArredondamentoPrecoExame());
        String valor = Funcoes.limpaDecimal(soma.doubleValue());
        return Double.valueOf(valor);
    }

    public void setDataEmissao(Date data) {
        if (data != null) {
            this.textDataEmissao.setText(Funcoes.formataData(data));
        }
    }

    private void editarPlanoCusto(int linha) {
        if (this.modeloParcela.getValueAt(linha, 3) != null && this.modeloParcela.getValueAt(linha, 3) instanceof ReceberPagarBean) {
            ReceberPagarBean bean = (ReceberPagarBean)this.modeloParcela.getValueAt(linha, 3);
            ParcelaPlanoCusto plc = new ParcelaPlanoCusto(Laboratorio.getInstancia(), bean);
            ReceberPagarService service = new ReceberPagarService();
            plc.setService(service);
            plc.setPlanoContas(bean.getPlanosContas());
            plc.setCentroCusto(bean.getCentrosCusto());
            plc.atualizarPlanosCustos();
            plc.setVisible(true);
            if (plc.getOK()) {
                ReceberPagarBean b = (ReceberPagarBean)this.modeloParcela.getValueAt(linha, 3);
                if (plc.getPlanoConta() != null) {
                    b.setPlanosContas(new HashSet<AbstractThreadBean>(plc.getPlanoConta()));
                } else {
                    b.setPlanosContas(null);
                }
                if (plc.getCentroCusto() != null) {
                    b.setCentrosCusto(new HashSet<AbstractThreadBean>(plc.getCentroCusto()));
                } else {
                    b.setCentrosCusto(null);
                }
            }
        }
    }

    public String getComposicao(NotaFiscalBean bean) {
        StringBuilder composicao = new StringBuilder();
        ArrayList<NotaFiscalVO> setComposicao = new NotaFiscalService().getComposicaoImpostosNota(bean);
        for (NotaFiscalVO aux : setComposicao) {
            if (composicao.length() > 0) {
                composicao.append(", ");
            }
            composicao.append(aux.getNumero());
        }
        if (composicao.length() == 0) {
            composicao.append(" ");
        }
        return composicao.toString();
    }

    @Override
    public void cancelar() {
        this.isImportacaoNota = false;
        if (Funcoes.mensagem(this, "As informa\u00e7\u00f5es adicionadas ser\u00e3o perdidas.", 4) == 0) {
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    private void preencherCampos(NotaFiscalBean nota) {
        this.textCodigoSerie.setText(nota.getSerie().getCodigo());
        this.labelDescSerie.setText(nota.getSerie().getDescricao());
        this.textNumero.setText(String.valueOf(nota.getNumero()));
        this.textDataEmissao.setText(Funcoes.formataData(nota.getDataEmissao()));
        this.textCodigoCadastro.setText(String.valueOf(nota.getEntidade().getCodigo()));
        this.cadastroVO = nota.getEntidade();
        this.labelCadastro.setText(nota.getEntidade().getFantasia());
        this.textObs.setText(nota.getObservacao());
        this.textCodigoForma.setText(String.valueOf(nota.getFormaPagamento().getCodigo()));
        this.labelDescForma.setText(nota.getFormaPagamento().getDescricao());
        this.textDescontoNota.setText(Funcoes.formataDecimal(nota.getValorDescontoIncondicionado()));
        this.comboDesconto.setSelectedItem("$");
        this.textFrete.setText(Funcoes.formataDecimal(nota.getValorFrete()));
        ArrayList<NotaFiscalMaterialBean> materiais = nota.getMateriais();
        MaterialService serviceMaterial = new MaterialService();
        if (materiais != null) {
            for (int i = 0; i < materiais.size(); ++i) {
                NotaFiscalMaterialBean materialBean = materiais.get(i);
                this.setProximoRegistro(materialBean.getOrdem());
                MaterialBean materialAux = null;
                try {
                    materialAux = (MaterialBean)serviceMaterial.getTodos(Variaveis.filialPadrao, materialBean.getMaterial().getCodigo().toString(), (NotaFiscalVO)(nota.getCodigo() != null ? nota.toVO() : null), null);
                }
                catch (Exception e) {
                    ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar dados do material: \"" + materialBean.getMaterial().getDescricao() + "\".\n" + e.getMessage(), e.getStackTrace());
                }
                if (!this.alterarOrdemCamposNota) {
                    this.modeloMateriais.addLine(new Object[]{materialBean.getOrdem(), materialBean.getMaterial().getDescricao(), Funcoes.formataDecimal("#,##0.00##", materialBean.getValorUnitario()), Funcoes.formataDecimal(materialBean.getQuantidade()), Funcoes.formataDecimal(materialBean.getValorDesconto()), Funcoes.formataDecimal("#,##0.00##", materialBean.getValorIpi()), Funcoes.formataDecimal(materialBean.getPercentualIpi()), Funcoes.formataDecimal("#,##0.00##", materialBean.getValorIcms()), Funcoes.formataDecimal(materialBean.getPercentualIcms()), Funcoes.formataDecimal("#,##0.00##", materialBean.getValorTotal()), materialBean, materialAux, false});
                } else {
                    this.modeloMateriais.addLine(new Object[]{materialBean.getOrdem(), materialBean.getMaterial().getDescricao(), Funcoes.formataDecimal(materialBean.getQuantidade()), Funcoes.formataDecimal("#,##0.00##", materialBean.getValorUnitario()), Funcoes.formataDecimal(materialBean.getValorDesconto()), Funcoes.formataDecimal("#,##0.00##", materialBean.getValorIcms()), Funcoes.formataDecimal(materialBean.getPercentualIcms()), Funcoes.formataDecimal("#,##0.00##", materialBean.getValorIpi()), Funcoes.formataDecimal(materialBean.getPercentualIpi()), Funcoes.formataDecimal("#,##0.00##", materialBean.getValorTotal()), materialBean, materialAux, false});
                }
                this.calculaTotais();
            }
        }
        if (nota.getParcelas() != null) {
            ArrayList parcelas = new ArrayList(nota.getParcelas());
            Collections.sort(parcelas);
            if (parcelas != null) {
                for (int i = 0; i < parcelas.size(); ++i) {
                    ReceberPagarBean recPagBean = (ReceberPagarBean)parcelas.get(i);
                    this.modeloParcela.addLine(new Object[]{recPagBean.getParcela(), Funcoes.formataData(recPagBean.getDataVencimento()), Funcoes.formataDecimal(recPagBean.getValorTotal()), recPagBean});
                }
            }
        }
    }

    @Override
    public void editar() {
        block8: {
            this.limparCampos();
            NotaFiscalBean notaAux = this.pesquisar();
            if (notaAux != null) {
                this.preencherCampos(notaAux);
                this.controlaCampos();
                if (this.isNotaImportada) {
                    this.habilitarCamposImportacaoNota();
                }
                this.notaFiscalAux = notaAux;
                NotaFiscalService serviceNota = new NotaFiscalService();
                ArrayList<Object[]> listaNotas = null;
                try {
                    if (this.conferenciaMovimentouEstoque) {
                        this.setStatus(1);
                    } else {
                        this.setStatus(3);
                    }
                    listaNotas = serviceNota.buscaNotasFiscaisCadastroFornecedor(Variaveis.filialPadrao, this.notaFiscalAux.getEntidade().getCodigo().toString(), this.notaFiscalAux.getEntidade().getTipo(), Conexao.getStatement(), false);
                    if (listaNotas != null && listaNotas.size() > 0) {
                        for (int i = 0; i < listaNotas.size(); ++i) {
                            String pesquisa = (String)listaNotas.get(i)[4];
                            if (Funcoes.textoVazio(pesquisa) || !ParametrosGerais.isMostrarPesquisaFornecedor()) continue;
                            this.itemVisualizaPesquisaFornecedor.setVisible(true);
                            this.itemVisualizaPesquisaFornecedor.setEnabled(true);
                            break block8;
                        }
                        break block8;
                    }
                    this.itemVisualizaPesquisaFornecedor.setVisible(false);
                    this.itemVisualizaPesquisaFornecedor.setEnabled(false);
                }
                catch (SQLException e) {
                    ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel verificar se o fornecedor na nota possui perguntas de pesquisa.", e.getStackTrace());
                }
            }
        }
    }

    private NotaFiscalBean pesquisar() {
        NotaFiscalService service = new NotaFiscalService();
        try {
            NotaFiscalVO notaVO;
            Hashtable selecionados = service.pesquisaNotaEntradaVO(this.getTopLevelAncestor(), new NotaFiscalVO(), "Pesquisando Notas Fiscais de Entrada");
            if (selecionados != null && selecionados.size() > 0 && (notaVO = (NotaFiscalVO)service.getVO(Variaveis.filialPadrao, selecionados.get("nfi_codigo").toString())) != null) {
                ArrayList<NotaFiscalLanctoEstoqueVO> lanctos;
                NotaFiscalBean notaBean = (NotaFiscalBean)new NotaFiscalDao().getBean(Variaveis.filialPadrao, String.valueOf(notaVO.getCodigo()));
                this.isNotaImportada = notaBean.getXmlNfse() != null;
                HashMap<String, Object> chaves = new HashMap<String, Object>();
                chaves.put("fil_codigo", Variaveis.filialPadrao);
                if (notaBean != null) {
                    chaves.put("nfi_codigo", notaBean.getCodigo());
                }
                boolean bl = this.notaMovimentouEstoque = (lanctos = new NotaFiscalLanctoEstoqueService().getVOs(chaves)) != null && lanctos.size() > 0;
                if (notaBean != null) {
                    this.conferenciaMovimentouEstoque = new ConferenciaEntradaService().getConferenciaEntradaNotaFiscal(Variaveis.filialPadrao, notaBean.getCodigo().toString()) != null;
                }
                return notaBean;
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar dados da nota fiscal de entrada.\n" + e.getMessage(), e.getStackTrace());
        }
        return null;
    }

    @Override
    @Deprecated
    public void excluir() {
    }

    @Override
    public void novo() {
        if (this.verificaCelulaPadrao()) {
            this.isImportacaoNota = false;
            this.setProximoRegistro(0);
            this.novo(true);
        }
    }

    private void carregarSeries() {
        try {
            SeriesVO serie = (SeriesVO)new SeriesService().getVO(Variaveis.filialPadrao, ParametrosLocais.getParametro("serie"));
            SeriesVO serieEntrada = (SeriesVO)new SeriesService().getVO(Variaveis.filialPadrao, ParametrosLocais.getParametro("serieEntrada"));
            if (serieEntrada != null) {
                this.textCodigoSerie.setText(serieEntrada.getCodigo());
                this.labelDescSerie.setText(serieEntrada.getDescricao());
            } else if (serie != null) {
                this.textCodigoSerie.setText(serie.getCodigo());
                this.labelDescSerie.setText(serie.getDescricao());
            } else {
                this.textCodigoSerie.setText("");
                this.labelDescSerie.setText("");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar s\u00e9rie.", e.getStackTrace());
        }
    }

    public void novo(boolean focoComponente) {
        this.limparCampos();
        this.setStatus(2);
        this.controlaCampos();
        this.carregarSeries();
        if (focoComponente && this.textCodigoSerie.isEnabled() && this.textCodigoSerie.isFocusable()) {
            ScreenUtil.requisitarFoco(this.textCodigoSerie);
        }
    }

    protected String getCopiaFiliais() {
        return null;
    }

    @Override
    public void salvar() {
        if (this.verificaCelulaPadrao()) {
            NotaFiscalBean bean;
            NotaFiscalService service = new NotaFiscalService();
            if (this.validaCampos() && (bean = this.getBeanPreenchido()) != null) {
                try {
                    if (this.isImportacaoNota && this.byteArquivoImportacao != null) {
                        Long xmlOID = DBUtil.gravaLargeObject(this.byteArquivoImportacao, Conexao.getConnection());
                        bean.setXmlNfse(xmlOID);
                    }
                    service.gravaAutoCopiaSemCommit(bean, this.getStatus() == 2 ? 0 : 1, Variaveis.filialPadrao, this.getCopiaFiliais());
                    this.retornoParaPesquisa = bean.getCodigo().toString();
                    Conexao.arquivaSQL();
                    CelulaEstoqueVO codigoCelula = new CelulaEstoqueService().getCelulaPadraoVO(Variaveis.filialPadrao);
                    if (codigoCelula != null && ParametrosGerais.isMostrarPesquisaFornecedor() && this.getStatus() == 2) {
                        this.mostrarPesquisaFornecedor(bean);
                    }
                    this.limparCampos();
                    this.setStatus(1);
                    this.controlaCampos();
                    this.isImportacaoNota = false;
                }
                catch (Exception e) {
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel salvar a nota fiscal de entrada." + e.getMessage(), e.getStackTrace());
                }
            }
        }
    }

    @Override
    public String getRetornoParaPesquisa() {
        return this.retornoParaPesquisa;
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return "nfi_codigo";
    }

    private boolean verificaCelulaPadrao() {
        String filialPadrao = Variaveis.filialPadrao;
        try {
            CelulaEstoqueVO codigoCelula = new CelulaEstoqueService().getCelulaPadraoVO(filialPadrao);
            if (codigoCelula == null) {
                Funcoes.mensagem(null, "Necess\u00e1rio definir uma c\u00e9lula de estoque como padr\u00e3o.", 2, false);
                return false;
            }
        }
        catch (ThreadDaoException e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel encontrar uma c\u00e9lula padr\u00e3o.", e.getStackTrace());
        }
        return true;
    }

    private void verificaNotaJaExiste() {
        block14: {
            String serie = Funcoes.textoVazio(this.textCodigoSerie) ? null : this.textCodigoSerie.getText();
            String numero = Funcoes.textoVazio(this.textNumero) ? null : this.textNumero.getText();
            String fornecedor = Funcoes.textoVazio(this.textCodigoCadastro) ? null : this.textCodigoCadastro.getText();
            String descricaoFornecedor = this.labelCadastro.getText();
            if (serie != null && numero != null && fornecedor != null) {
                if (this.serieRepetidaAux != null && this.numeroRepetidoAux != null && this.codigoFornecedorAux != null && this.serieRepetidaAux.equalsIgnoreCase(serie) && this.numeroRepetidoAux.equalsIgnoreCase(numero) && this.codigoFornecedorAux.equalsIgnoreCase(fornecedor)) {
                    return;
                }
                this.serieRepetidaAux = serie;
                this.numeroRepetidoAux = numero;
                this.codigoFornecedorAux = fornecedor;
                try {
                    String msg;
                    ArrayList<NotaFiscalBean> notas = new NotaFiscalService().getNotasFiscaisFornecedor(Variaveis.filialPadrao, serie, numero, fornecedor);
                    if (notas != null && this.notaFiscalAux != null && this.notaFiscalAux.getCodigo() != null) {
                        for (int i = 0; i < notas.size(); ++i) {
                            if (notas.get(i).getCodigo().intValue() != this.notaFiscalAux.getCodigo().intValue()) continue;
                            notas.remove(i);
                            --i;
                        }
                    }
                    if (notas == null || notas.size() <= 0) break block14;
                    boolean cancelada = false;
                    for (int i = 0; i < notas.size(); ++i) {
                        cancelada = notas.get(i).getDataHoraCancelada() != null && notas.get(i).getSituacao().equalsIgnoreCase("C");
                    }
                    int opcao = -1;
                    if (notas.size() == 1 && !cancelada) {
                        msg = "Existe uma nota de s\u00e9rie: \"" + serie + "\", n\u00famero: " + numero + " do fornecedor \"" + descricaoFornecedor + "\" cadastrada.";
                        opcao = JOptionPane.showOptionDialog(Laboratorio.getInstancia(), msg, "Nota j\u00e1 cadastrada", 0, 2, null, new String[]{"Continuar cadastro atual", "Cancelar cadastro atual", "Editar nota existente"}, "Editar nota existente");
                    } else if (!cancelada) {
                        msg = "Existe mais de uma nota de s\u00e9rie: \"" + serie + "\", n\u00famero: " + numero + " do fornecedor \"" + descricaoFornecedor + "\" cadastrada.";
                        opcao = JOptionPane.showOptionDialog(Laboratorio.getInstancia(), msg, "Nota j\u00e1 cadastrada", 0, 2, null, new String[]{"Continuar cadastro atual", "Cancelar cadastro atual"}, "Cancelar cadastro atual");
                    }
                    if (opcao == 1) {
                        this.cancelar();
                        break block14;
                    }
                    if (opcao != 2) break block14;
                    NotaFiscalBean notaAux = null;
                    try {
                        notaAux = (NotaFiscalBean)new NotaFiscalService().getNotaEntradaFornecedorBean(Variaveis.filialPadrao, serie, numero, fornecedor);
                    }
                    catch (Exception e) {
                        ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel carregar nota fiscal.\n" + e.getMessage(), e.getStackTrace());
                        return;
                    }
                    this.limparCampos();
                    if (notaAux != null) {
                        this.setStatus(3);
                        this.preencherCampos(notaAux);
                        this.controlaCampos();
                        this.notaFiscalAux = notaAux;
                    }
                }
                catch (ThreadDaoException e) {
                    ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel verificar se a nota fiscal de entrada j\u00e1 foi cadastrada.\n" + e.getMessage(), e.getStackTrace());
                }
            }
        }
    }

    class TextFieldImposto
    extends TTextField {
        Double percentualOriginal;

        public TextFieldImposto(int qtde, int documento) {
            super(qtde, documento);
            this.percentualOriginal = 0.0;
        }

        public void setPercentualOriginal(Double d) {
            this.percentualOriginal = d;
        }

        public Double getPercentualOriginal() {
            return this.percentualOriginal;
        }
    }

    class ParcelaPlanoCusto
    extends AbstractDialogoOKCancelar
    implements BuscaBeanPreenchido {
        private PanelPlanoContaCentroCusto plc;
        private ReceberPagarBean bean;

        public ParcelaPlanoCusto(JFrame owner, ReceberPagarBean bean) {
            super((Frame)owner, "Plano de contas/Centros de custo");
            this.plc = new PanelPlanoContaCentroCusto(this, PanelPlanoContaCentroCusto.TIPO_RECEBER_PAGAR, -1L, -1L, Variaveis.filialPadrao);
            this.bean = null;
            this.bean = bean;
            this.montaTela(owner);
        }

        private void montaTela(JFrame owner) {
            this.setSize(new Dimension(750, 400));
            this.setLocationRelativeTo(owner);
            this.getPanelCentral().setLayout(new BorderLayout());
            JTabbedPane tab = new JTabbedPane();
            tab.addTab("Plano/Centro", this.plc);
            this.getPanelCentral().add((Component)tab, "Center");
        }

        @Override
        public AbstractThreadBean buscaBeanPreenchido(PanelPlanoContaCentroCusto source) {
            return this.bean;
        }

        public ArrayList<AbstractThreadBean> getPlanoConta() {
            return this.plc.getPlanoContas();
        }

        public ArrayList<AbstractThreadBean> getCentroCusto() {
            return this.plc.getCentrosCusto();
        }

        public void setPlanoContas(Set plano) {
            if (plano != null) {
                this.plc.setPlanoContas(plano);
            }
        }

        public void setCentroCusto(Set centro) {
            if (centro != null) {
                this.plc.setCentrosCusto(centro);
            }
        }

        public void setService(ReceberPagarService s) {
            this.plc.setService(s);
        }

        public void atualizarPlanosCustos() {
            this.plc.atualizar(this.bean);
        }
    }

    class TipoCadastro {
        public String tipo;
        public String nome;

        public TipoCadastro(String tipo, String nome) {
            this.tipo = tipo;
            this.nome = nome;
        }

        public String toString() {
            return this.nome;
        }
    }
}

