/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.estoque.pedido;

import jalis.comum.Acesso;
import jalis.laboratorio.DisposeListener;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.digitacao.Digitacao;
import jalis.laboratorio.digitacao.Resultado;
import jalis.laboratorio.digitacao.evento.DigitacaoEvento;
import jalis.laboratorio.digitacao.evento.DigitacaoListener;
import jalis.laboratorio.estoque.pedido.NotaFiscalEntrada;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.FocusManager;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;

public class InfoPerguntaPesquisaFornecedor
extends JDialog
implements DisposeListener {
    private JPanel pBotoes = new JPanel(new FlowLayout(2));
    private JButton btnFechar = new JButton("Fechar");
    private Digitacao digitacao = new Digitacao();
    private boolean salvarPressionado = false;
    private boolean visualizar = false;
    private String digitado = "";
    private String valorInstrucao;
    private JScrollPane scrollPane = new JScrollPane();
    private JPanel panelPergunta = new JPanel(new BorderLayout());

    public InfoPerguntaPesquisaFornecedor(Frame owner, boolean visualizar, String titulo) {
        super(owner, titulo);
        if (owner instanceof Laboratorio) {
            ((Laboratorio)owner).addDisposeListener(this);
        }
        this.visualizar = visualizar;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(owner, ex.getMessage(), ex.getStackTrace());
        }
    }

    public InfoPerguntaPesquisaFornecedor(Dialog owner, boolean visualizar, String titulo) {
        super(owner, titulo);
        this.visualizar = visualizar;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(owner, ex.getMessage(), ex.getStackTrace());
        }
    }

    public void setInstrucoes(String instrucoes) {
        this.digitacao.carregarCampos(new Resultado(instrucoes, null).getResultado());
        this.pack();
        this.setSize(this.getPreferredSize());
        this.setLocationRelativeTo(this.getParent());
        this.valorInstrucao = instrucoes;
        if (!this.visualizar) {
            this.digitacao.setFocoPrimeiroCampo();
        }
    }

    public void setPerguntas(String perguntas, HashMap<String, Object> dados) {
        this.digitacao.carregarCampos(perguntas, dados);
        this.pack();
        this.setMinimumSize(this.getPreferredSize());
        this.setLocationRelativeTo(this.getParent());
        this.valorInstrucao = perguntas;
        if (!this.visualizar) {
            this.digitacao.setFocoPrimeiroCampo();
        }
        this.panelPergunta.repaint();
        this.panelPergunta.revalidate();
        this.pack();
    }

    public void jbInit() throws Exception {
        this.setModal(true);
        this.setLayout(new BorderLayout());
        this.setMinimumSize(new Dimension(300, 200));
        this.setMaximumSize(new Dimension(400, 300));
        this.setPreferredSize(new Dimension(400, 300));
        this.setDefaultCloseOperation(0);
        ScreenUtil.centralizar(this);
        this.panelPergunta.setMinimumSize(new Dimension(400, 300));
        this.getContentPane().add((Component)this.pBotoes, "South");
        this.panelPergunta.add((Component)this.digitacao, "Center");
        this.scrollPane.setViewportView(this.panelPergunta);
        this.getContentPane().add((Component)this.panelPergunta, "Center");
        if (!this.visualizar) {
            this.digitacao.exibirCheckBoxImprimir(false);
            if (Acesso.getAcesso(NotaFiscalEntrada.getAcessoCancelarPesquisaFornecedor())) {
                this.digitacao.alterarNomeBotaoFechar("Cancelar");
                this.digitacao.exibirBotaoFechar(true);
            }
            this.digitacao.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0, true), "enter");
            this.digitacao.getActionMap().put("enter", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Component owner = FocusManager.getCurrentManager().getFocusOwner();
                    if (owner instanceof JButton) {
                        ((JButton)owner).doClick();
                    } else {
                        InfoPerguntaPesquisaFornecedor.this.digitacao.setFocoProximo();
                    }
                }
            });
        }
        this.pBotoes.add(this.btnFechar);
        Funcoes.montaEnter((JComponent)this.pBotoes);
        this.btnFechar.setMnemonic('F');
        this.pBotoes.setVisible(this.visualizar);
        this.btnFechar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InfoPerguntaPesquisaFornecedor.this.salvarPressionado = false;
                InfoPerguntaPesquisaFornecedor.this.setVisible(false);
            }
        });
        this.digitacao.addDigitacaoListener(new DigitacaoListener(){

            @Override
            public void acaoSalvar(DigitacaoEvento e) {
                if (!Acesso.getAcesso(NotaFiscalEntrada.getAcessoCancelarPesquisaFornecedor()) && !InfoPerguntaPesquisaFornecedor.this.digitacao.resultadoCompleto(false)) {
                    Funcoes.mensagem(Laboratorio.getInstancia(), "Todos os campos dever\u00e3o ser preenchidos.", 2);
                    return;
                }
                InfoPerguntaPesquisaFornecedor.this.salvarPressionado = true;
                if (InfoPerguntaPesquisaFornecedor.this.digitacao != null) {
                    InfoPerguntaPesquisaFornecedor.this.digitado = InfoPerguntaPesquisaFornecedor.this.digitacao.getResultado();
                }
                if (InfoPerguntaPesquisaFornecedor.this.digitacao != null) {
                    InfoPerguntaPesquisaFornecedor.this.digitacao = null;
                }
                InfoPerguntaPesquisaFornecedor.this.setVisible(false);
            }

            @Override
            public void acaoSalvarParcial(DigitacaoEvento e) {
            }

            @Override
            public void acaoImprimir(DigitacaoEvento e) {
            }

            @Override
            public void acaoFechar(DigitacaoEvento digitacaoEvento) {
                InfoPerguntaPesquisaFornecedor.this.salvarPressionado = false;
                InfoPerguntaPesquisaFornecedor.this.setVisible(false);
            }

            @Override
            @Deprecated
            public void acaoRemover(DigitacaoEvento e) {
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                if (InfoPerguntaPesquisaFornecedor.this.digitacao != null) {
                    InfoPerguntaPesquisaFornecedor.this.digitacao.setFocoPrimeiroCampo();
                }
            }
        });
    }

    public boolean getSalvarPressionado() {
        return this.salvarPressionado;
    }

    public String getPergunta() {
        return this.digitado;
    }

    public String getValorInstrucao() {
        return this.valorInstrucao;
    }
}

