/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.estoque.pedido;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.detalhes.Detalhes;
import jalis.comum.padroes.FrmPadrao;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.recepcao.util.SolicitarMotivoCancelamento;
import jalis.model.AbstractThreadBean;
import jalis.model.bean.estoque.NotaFiscalMaterialBean;
import jalis.model.bean.financeiro.NotaFiscalBean;
import jalis.model.bean.financeiro.ReceberPagarBean;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.ConvenioVO;
import jalis.model.vo.cadastro.EntidadeVO;
import jalis.model.vo.cadastro.PacienteVO;
import jalis.model.vo.financeiro.NotaFiscalVO;
import jalis.service.AbstractThreadService;
import jalis.service.financeiro.NotaFiscalService;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;

public class CancelamentoNotaEntrada
extends FrmPadrao
implements ActionListener {
    protected JButton buttonNovo = ComponenteFactory.novoJButton("Novo", 'N', this);
    protected JButton buttonCancelarNF = ComponenteFactory.novoJButton("Cancelar NF", 'l', this);
    protected JButton buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this);
    protected JButton buttonFechar = ComponenteFactory.novoJButton("Fechar", 'F', this);
    protected JPanel panelBotoes = ComponenteFactory.novoJPanelFlowLayout(2, new Component[0]);
    private JPanel painelCentral = new JPanel(new GridBagLayout());
    private int status;
    private AbstractThreadService service = null;
    protected NotaFiscalBean notaFiscalBean = null;
    ArrayList<NotaFiscalMaterialBean> materiais = null;
    protected Set<ReceberPagarBean> parcelas = null;
    AbstractThreadVO cadastroVO = null;
    private JLabel labelNota = new JLabel("Nota Fiscal:");
    private TTextField textNota = new TTextField(8, 1);
    private JLabel labelCadastro = new JLabel("Cadastro:");
    private TTextField textCadastro = new TTextField(150, 3);
    private JLabel labelTipoCadastroRotulo = new JLabel("Tipo Cadastro:");
    private JLabel labelTipoCadastro = new JLabel("");
    private JLabel labelEmissao = new JLabel("Emiss\u00e3o:");
    private TTextField textEmissao = new TTextField(10, 4);
    private JLabel labelUsuario = new JLabel("Usu\u00e1rio:");
    private TTextField textUsuario = new TTextField(80, 3);
    private JLabel labelSerie = new JLabel("S\u00e9rie:");
    private TTextField textCodSerie = new TTextField(2, 3);
    private TTextField textDescSerie = new TTextField(80, 3);
    private JLabel labelValor = new JLabel("Valor Bruto:");
    private TTextField textValor = new TTextField(18, 2, 2);
    private JLabel labelImpostos = new JLabel("(+)Impostos:");
    private TTextField textImpostos = new TTextField(18, 2, 2);
    private JLabel labelDescontos = new JLabel("(-)Descontos:");
    private TTextField textDescontos = new TTextField(18, 2);
    private JLabel labelTotal = new JLabel("Valor L\u00edquido:");
    private TTextField textTotal = new TTextField(18, 2, 2);
    private JLabel labelFormaPgto = new JLabel("Forma Pagto.:");
    private TTextField textCodFormaPgto = new TTextField(5, 1);
    private TTextField textDescFormaPgto = new TTextField(40, 3);
    private JLabel labelSituacao = new JLabel("Situa\u00e7\u00e3o:");
    private JLabel labelVlrSituacao = new JLabel("");
    private JLabel labelMateriais = new JLabel("Materiais");
    private JLabel labelParcelas = new JLabel("Parcelas");
    private ModeloGridTable modeloParcelas = new ModeloGridTable(new String[]{"Parc.", "N\u00fam. Documento", "Vencto.", "Valor", "Total"});
    private JTable tableParcelas = new JTable(this.modeloParcelas);
    private JLabel labelFaturas = new JLabel("Faturas");
    protected ModeloGridTable modeloMateriais = new ModeloGridTable(new String[]{"C\u00f3digo", "Material", "Qtde.", "Vlr. Unit\u00e1rio", "Vlr. Ipi", "Vlr. Icms", "Vlr. Desc.", "Total", "Objeto"}){

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return super.getColumnClass(columnIndex);
        }

        @Override
        public void fireTableStructureChanged() {
            super.fireTableStructureChanged();
            try {
                if (CancelamentoNotaEntrada.this.tableMateriais != null) {
                    CancelamentoNotaEntrada.this.tableMateriais.removeColumn(CancelamentoNotaEntrada.this.tableMateriais.getColumn("Objeto"));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            super.mouseClicked(e);
            try {
                CancelamentoNotaEntrada.this.tableMateriais.removeColumn(CancelamentoNotaEntrada.this.tableMateriais.getColumn("Objeto"));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    };
    private JTable tableMateriais = new JTable(this.modeloMateriais);
    private JTextArea textObservacao = new JTextArea();
    private JLabel labelObservacao = new JLabel("Observa\u00e7\u00e3o");
    private JScrollPane scrObservacao = new JScrollPane(this.textObservacao);
    private DetalhesImpostos detalhesImpostos = new DetalhesImpostos(2);
    private boolean isTelaCancelamento = false;

    public CancelamentoNotaEntrada(boolean isTelaCancelamento) {
        this.isTelaCancelamento = isTelaCancelamento;
        this.montaTela();
    }

    public CancelamentoNotaEntrada() {
        this.isTelaCancelamento = true;
        this.montaTela();
    }

    public void cancelarNF() {
        if (Funcoes.mensagem(this, "Voc\u00ea realmente deseja cancelar a nota fiscal?", 4) == 0) {
            SolicitarMotivoCancelamento telaMotivoCancelamento = new SolicitarMotivoCancelamento(Laboratorio.getInstancia(), "Motivo de Cancelamento", false);
            telaMotivoCancelamento.setVisible(true);
            if (!telaMotivoCancelamento.getOK()) {
                return;
            }
            if (telaMotivoCancelamento == null || telaMotivoCancelamento.getCodigoMotivo() == -1 || telaMotivoCancelamento.getCancelado()) {
                Funcoes.mensagem(this, "O Motivo de Cancelamento da Nota Fiscal n\u00e3o foi selecionado.\nO cancelamento ser\u00e1 abortado.", 2);
                return;
            }
            try {
                CharSequence msg;
                StringBuilder listaCodigos = new StringBuilder();
                for (ReceberPagarBean aux : this.parcelas) {
                    if (aux.getSituacao() == null || aux.getSituacao().equalsIgnoreCase("A")) continue;
                    if (listaCodigos.length() > 0) {
                        listaCodigos.append(", ").append(aux.getCodigo());
                        continue;
                    }
                    listaCodigos.append(aux.getCodigo());
                }
                if (listaCodigos.length() > 0) {
                    msg = new StringBuilder();
                    ((StringBuilder)msg).append("O(s) t\u00edtulo(s): \"").append(listaCodigos.toString()).append("\", filial: ").append(this.notaFiscalBean.getFilial().getCodigo()).append(" n\u00e3o est\u00e1(\u00e3o) aberto(s).\n");
                    ((StringBuilder)msg).append("N\u00e3o \u00e9 poss\u00edvel ").append("cancelar").append(" a nota fiscal se os Receber/Pagar n\u00e3o estiverem ABERTOS.\n");
                    ((StringBuilder)msg).append("Por favor, verifique.");
                    Funcoes.mensagem(this, ((StringBuilder)msg).toString(), 2);
                    return;
                }
                msg = new NotaFiscalService().cancelarEstornaNF(true, this.notaFiscalBean, this.parcelas, telaMotivoCancelamento);
                if (!Funcoes.textoVazio((String)msg)) {
                    Conexao.arquivaSQL();
                    Funcoes.mensagem(Laboratorio.getInstancia(), (String)msg, 5);
                } else {
                    Conexao.anulaSQL();
                }
                this.cancelar();
            }
            catch (Exception e) {
                try {
                    Conexao.anulaSQL();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
            }
        }
    }

    public void fechar() {
        this.setVisible(false);
    }

    public boolean cancelar() {
        this.limparCampos();
        this.setStatus(1);
        this.notaFiscalBean = null;
        this.controlaCampos();
        return true;
    }

    protected void montaTela() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.painelCentral, "Center");
        this.service = new NotaFiscalService();
        Funcoes.montaEnter((JComponent)this.painelCentral);
        this.panelBotoes.setLayout(new FlowLayout(2));
        this.panelBotoes.add(this.buttonNovo);
        this.panelBotoes.add(this.buttonCancelarNF);
        this.panelBotoes.add(this.buttonCancelar);
        this.panelBotoes.add(this.buttonFechar);
        this.add((Component)this.panelBotoes, "South");
        Funcoes.criaBarraDescricao(this, "Cancelamento de Nota Fiscal de Entrada", "Cancelamento de Notas Fiscais de Entrada", "estoque/cancelamento_nf_entrada.jpg");
        ScreenUtil.setBorda(new Component[]{this.labelTipoCadastro, this.labelVlrSituacao}, new TitledBorder(""));
        this.modeloParcelas.setColumnSize(new int[]{49, 0, 80, 70, 70}, this.tableParcelas);
        this.modeloMateriais.setColumnSize(new int[]{60, 0, 60, 90, 80, 80, 80, 80, 0}, this.tableMateriais);
        this.tableMateriais.removeColumn(this.tableMateriais.getColumn("Objeto"));
        this.tableMateriais.getTableHeader().addMouseListener(this.modeloMateriais);
        this.tableParcelas.getTableHeader().addMouseListener(this.modeloParcelas);
        this.modeloParcelas.ordenarColuna(this.modeloParcelas.findColumn("Parc."));
        this.modeloMateriais.ordenarColuna(this.modeloMateriais.findColumn("Material"));
        this.buttonNovo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CancelamentoNotaEntrada.this.novo();
            }
        });
        this.buttonFechar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CancelamentoNotaEntrada.this.fechar();
            }
        });
        this.buttonCancelar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CancelamentoNotaEntrada.this.cancelar();
            }
        });
        this.buttonCancelarNF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CancelamentoNotaEntrada.this.cancelarNF();
            }
        });
        Dimension d = new Dimension(100, 20);
        this.textNota.setPreferredSize(d);
        d = new Dimension(100, 20);
        this.textNota.setMinimumSize(d);
        this.textNota.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    CancelamentoNotaEntrada.this.novo();
                }
            }
        });
        d = new Dimension(320, 20);
        this.textCadastro.setPreferredSize(d);
        d = new Dimension(320, 20);
        this.textCadastro.setMinimumSize(d);
        d = new Dimension(100, 20);
        this.textEmissao.setPreferredSize(d);
        d = new Dimension(100, 20);
        this.textEmissao.setMinimumSize(d);
        d = new Dimension(150, 20);
        this.textUsuario.setPreferredSize(d);
        d = new Dimension(150, 20);
        this.textUsuario.setMinimumSize(d);
        d = new Dimension(40, 20);
        this.textCodSerie.setPreferredSize(d);
        d = new Dimension(40, 20);
        this.textCodSerie.setMinimumSize(d);
        d = new Dimension(280, 20);
        this.textDescSerie.setPreferredSize(d);
        d = new Dimension(280, 20);
        this.textDescSerie.setMinimumSize(d);
        d = new Dimension(100, 20);
        this.textValor.setPreferredSize(d);
        d = new Dimension(100, 20);
        this.textValor.setMinimumSize(d);
        d = new Dimension(100, 20);
        this.textImpostos.setPreferredSize(d);
        d = new Dimension(100, 20);
        this.textImpostos.setMinimumSize(d);
        d = new Dimension(100, 20);
        this.textDescontos.setPreferredSize(d);
        d = new Dimension(100, 20);
        this.textDescontos.setMinimumSize(d);
        d = new Dimension(100, 20);
        this.textTotal.setPreferredSize(d);
        d = new Dimension(100, 20);
        this.textTotal.setMinimumSize(d);
        d = new Dimension(40, 20);
        this.textCodFormaPgto.setPreferredSize(d);
        d = new Dimension(40, 20);
        this.textCodFormaPgto.setMinimumSize(d);
        d = new Dimension(280, 20);
        this.textDescFormaPgto.setPreferredSize(d);
        d = new Dimension(280, 20);
        this.textDescFormaPgto.setMinimumSize(d);
        d = new Dimension(100, 20);
        this.labelTipoCadastro.setPreferredSize(d);
        d = new Dimension(100, 20);
        this.labelTipoCadastro.setMinimumSize(d);
        d = new Dimension(100, 20);
        this.labelVlrSituacao.setPreferredSize(d);
        this.labelVlrSituacao.setMinimumSize(d);
        d = new Dimension(20, 30);
        this.scrObservacao.setPreferredSize(d);
        this.scrObservacao.setMinimumSize(d);
        this.painelCentral.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        JScrollPane scrollParcelas = new JScrollPane(this.tableParcelas);
        JScrollPane scrollMateriais = new JScrollPane(this.tableMateriais);
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(4, 2, 0, 0);
        c.anchor = 18;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        this.painelCentral.add(new JPanel().add(this.labelNota), c);
        ++c.gridx;
        c.gridwidth = 2;
        this.painelCentral.add((Component)this.textNota, c);
        c.gridwidth = 1;
        c.gridx += 3;
        this.painelCentral.add(new JPanel().add(new JLabel("  ")), c);
        c.gridx += 2;
        this.painelCentral.add((Component)this.labelSituacao, c);
        ++c.gridx;
        this.painelCentral.add((Component)this.labelVlrSituacao, c);
        c.anchor = 18;
        c.insets = new Insets(2, 2, 0, 0);
        ++c.gridy;
        c.gridx = 0;
        c.insets = new Insets(2, 2, 0, 0);
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.fill = 0;
        this.painelCentral.add(new JPanel().add(this.labelTipoCadastroRotulo), c);
        ++c.gridx;
        c.gridwidth = 2;
        this.painelCentral.add((Component)this.labelTipoCadastro, c);
        c.gridx += 4;
        c.gridwidth = 1;
        this.painelCentral.add((Component)new JLabel("  "), c);
        ++c.gridx;
        this.painelCentral.add(new JPanel().add(this.labelCadastro), c);
        ++c.gridx;
        c.gridwidth = 5;
        c.insets = new Insets(2, 2, 0, 4);
        c.fill = 2;
        this.painelCentral.add((Component)this.textCadastro, c);
        c.fill = 0;
        c.insets = new Insets(2, 2, 0, 0);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        this.painelCentral.add(new JPanel().add(this.labelEmissao), c);
        ++c.gridx;
        c.gridwidth = 2;
        this.painelCentral.add((Component)this.textEmissao, c);
        c.gridx += 4;
        c.gridwidth = 1;
        c.insets = new Insets(2, 2, 0, 4);
        this.painelCentral.add((Component)new JLabel("  "), c);
        ++c.gridx;
        this.painelCentral.add(new JPanel().add(this.labelUsuario), c);
        ++c.gridx;
        c.gridwidth = 5;
        c.fill = 2;
        this.painelCentral.add((Component)this.textUsuario, c);
        c.fill = 0;
        c.insets = new Insets(2, 2, 0, 0);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        this.painelCentral.add(new JPanel().add(this.labelSerie), c);
        ++c.gridx;
        c.gridwidth = 1;
        this.painelCentral.add((Component)this.textCodSerie, c);
        ++c.gridx;
        c.gridwidth = 11;
        c.insets = new Insets(2, 2, 0, 4);
        c.fill = 2;
        this.painelCentral.add((Component)this.textDescSerie, c);
        c.fill = 0;
        c.insets = new Insets(2, 2, 0, 0);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        this.painelCentral.add(new JPanel().add(this.labelFormaPgto), c);
        ++c.gridx;
        c.gridwidth = 1;
        this.painelCentral.add((Component)this.textCodFormaPgto, c);
        ++c.gridx;
        c.gridwidth = 11;
        c.insets = new Insets(2, 2, 0, 4);
        c.fill = 2;
        this.painelCentral.add((Component)this.textDescFormaPgto, c);
        c.fill = 0;
        c.insets = new Insets(2, 2, 0, 0);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        this.painelCentral.add((Component)this.labelValor, c);
        ++c.gridx;
        c.gridwidth = 2;
        this.painelCentral.add((Component)this.textValor, c);
        c.gridx += 4;
        c.gridwidth = 1;
        this.painelCentral.add((Component)new JLabel("  "), c);
        ++c.gridx;
        this.painelCentral.add((Component)this.labelImpostos, c);
        ++c.gridx;
        c.gridwidth = 1;
        this.painelCentral.add((Component)this.textImpostos, c);
        ++c.gridy;
        c.gridx = 0;
        this.painelCentral.add((Component)this.labelDescontos, c);
        ++c.gridx;
        c.gridwidth = 2;
        c.insets = new Insets(2, 2, 0, 4);
        this.painelCentral.add((Component)this.textDescontos, c);
        c.gridx += 4;
        c.gridwidth = 1;
        this.painelCentral.add((Component)new JLabel("  "), c);
        ++c.gridx;
        this.painelCentral.add((Component)this.labelTotal, c);
        ++c.gridx;
        c.gridwidth = 1;
        this.painelCentral.add((Component)this.textTotal, c);
        ++c.gridy;
        c.gridx = 0;
        this.painelCentral.add((Component)this.labelObservacao, c);
        ++c.gridx;
        c.gridwidth = 11;
        c.insets = new Insets(2, 2, 0, 4);
        c.fill = 2;
        this.painelCentral.add((Component)this.scrObservacao, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 12;
        c.fill = 2;
        this.painelCentral.add((Component)this.detalhesImpostos, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 12;
        c.insets = new Insets(2, 2, 0, 4);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        JPanel painelInterno = new JPanel(new GridBagLayout());
        painelInterno.setBorder(BorderFactory.createEtchedBorder());
        this.painelCentral.add((Component)painelInterno, c);
        c = new GridBagConstraints();
        c.gridy = 0;
        c.gridx = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.7;
        c.fill = 1;
        GridBagConstraints g = new GridBagConstraints();
        g.fill = 1;
        g.weightx = 1.0;
        g.weighty = 0.6;
        JPanel panelMateriais = new JPanel(new GridBagLayout());
        panelMateriais.setBorder(BorderFactory.createTitledBorder("Materiais"));
        panelMateriais.add((Component)scrollMateriais, g);
        painelInterno.add((Component)panelMateriais, c);
        ++c.gridy;
        c.weighty = 0.4;
        JPanel panelParcelas = new JPanel(new GridBagLayout());
        panelParcelas.setBorder(BorderFactory.createTitledBorder("Parcelas"));
        panelParcelas.add((Component)scrollParcelas, g);
        painelInterno.add((Component)panelParcelas, c);
        this.controlaCampos();
    }

    public void novo() {
        this.cancelar();
        if (this.isTelaCancelamento && ParametrosGerais.getTipoMovimentarEstoque().equalsIgnoreCase("N")) {
            Funcoes.mensagem(this, "O sistema est\u00e1 configurado para movimentar estoque ao criar a nota fiscal de entrada.\nN\u00e3o \u00e9 poss\u00edvel cancelar notas fiscais de entrada.", 2);
            return;
        }
        AbstractThreadBean bean = this.pesquisar();
        if (bean != null) {
            this.setStatus(2);
            this.preencherCampos((NotaFiscalBean)bean);
            this.controlaCampos();
            this.painelCentral.grabFocus();
        }
    }

    private void preencherCampos(NotaFiscalBean bean) {
        if (bean != null) {
            Object[] linha;
            this.textNota.setText(bean.getNumero().toString());
            if (bean.getTipoCadastro().equals("P")) {
                this.cadastroVO = bean.getPaciente();
                this.textCadastro.setText(((PacienteVO)this.cadastroVO).getNome());
                this.labelTipoCadastro.setText(Tipos.tipoCadastro("P"));
            } else if (bean.getTipoCadastro().equals("O")) {
                this.cadastroVO = bean.getConvenio();
                this.textCadastro.setText(((ConvenioVO)this.cadastroVO).getFantasia());
                this.labelTipoCadastro.setText(Tipos.tipoCadastro("O"));
            } else {
                this.cadastroVO = bean.getEntidade();
                this.textCadastro.setText(((EntidadeVO)this.cadastroVO).getFantasia());
                this.labelTipoCadastro.setText(Tipos.tipoCadastro(((EntidadeVO)this.cadastroVO).getTipo()));
            }
            this.textEmissao.setText(Funcoes.formataData("dd/MM/yyyy", bean.getDataEmissao()));
            this.textUsuario.setText(bean.getUsuario().getDescricao());
            this.textCodSerie.setText(bean.getSerie().getCodigo().toString());
            this.textDescSerie.setText(bean.getSerie().getDescricao());
            this.textValor.setText(Funcoes.formataDecimal(this.textValor.getMaskDecimal(), bean.getSubTotal()));
            this.textDescontos.setText(Funcoes.formataDecimal(this.textDescontos.getMaskDecimal(), bean.getSubTotal() + bean.getValorIpi() + bean.getValorIcms() - bean.getValor()));
            this.textImpostos.setText(Funcoes.formataDecimal(this.textImpostos.getMaskDecimal(), bean.getValorIpi() + bean.getValorIcms()));
            this.textTotal.setText(Funcoes.formataDecimal(this.textTotal.getMaskDecimal(), bean.getValor()));
            this.textCodFormaPgto.setText(bean.getFormaPagamento().getCodigo().toString());
            this.textDescFormaPgto.setText(bean.getFormaPagamento().getDescricao());
            this.labelVlrSituacao.setText(Tipos.tipoSituacaoNotaFiscal(bean.getSituacao(), bean.getNumeroRps() != null));
            this.textObservacao.setText(bean.getObservacao() == null ? "" : bean.getObservacao());
            this.notaFiscalBean = bean;
            this.parcelas = bean.getParcelas();
            if (this.parcelas != null) {
                Object[] array = this.parcelas.toArray();
                for (int i = 0; i < array.length; ++i) {
                    linha = new Object[]{((ReceberPagarBean)array[i]).getParcela(), ((ReceberPagarBean)array[i]).getNumeroDocumento(), Funcoes.formataData("dd/MM/yyyy", ((ReceberPagarBean)array[i]).getDataVencimento()), Funcoes.formataDecimal(this.textValor.getMaskDecimal(), ((ReceberPagarBean)array[i]).getValor()), Funcoes.formataDecimal(this.textTotal.getMaskDecimal(), ((ReceberPagarBean)array[i]).getValorTotal())};
                    this.modeloParcelas.addLine(linha);
                }
            }
            this.materiais = bean.getMateriais();
            if (this.materiais != null) {
                for (int i = 0; i < this.materiais.size(); ++i) {
                    NotaFiscalMaterialBean material = this.materiais.get(i);
                    linha = new Object[]{material.getMaterial().getCodigo(), material.getMaterial().getDescricao(), Funcoes.formataDecimal(material.getQuantidade()), Funcoes.formataDecimal(material.getValorUnitario()), Funcoes.formataDecimal("#,##0.00##", material.getValorIpi()), Funcoes.formataDecimal("#,##0.00##", material.getValorIcms()), Funcoes.formataDecimal(material.getValorDesconto()), Funcoes.formataDecimal(material.getValorTotal()), material};
                    this.modeloMateriais.addLine(linha);
                }
            }
            this.detalhesImpostos.setValores(bean.getValorIpi(), bean.getValorIcms(), bean.getPercentualIpi(), bean.getPercentualIcms());
            this.modeloParcelas.ordenarColuna(0);
        }
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void controlaCampos() {
        this.textNota.setEnabled(false);
        this.textCadastro.setEnabled(false);
        this.textEmissao.setEnabled(false);
        this.textUsuario.setEnabled(false);
        this.textCodSerie.setEnabled(false);
        this.textDescSerie.setEnabled(false);
        this.textValor.setEnabled(false);
        this.textDescontos.setEnabled(false);
        this.textImpostos.setEnabled(false);
        this.textTotal.setEnabled(false);
        this.textCodFormaPgto.setEnabled(false);
        this.textDescFormaPgto.setEnabled(false);
        this.labelTipoCadastro.setEnabled(false);
        this.textObservacao.setEnabled(false);
        this.scrObservacao.setEnabled(false);
        this.controlaBotoes();
    }

    protected void controlaBotoes() {
        if (this.notaFiscalBean != null) {
            this.buttonCancelar.setEnabled(true);
            this.buttonFechar.setEnabled(true);
            this.buttonNovo.setEnabled(false);
            this.buttonCancelarNF.setEnabled(true);
        } else {
            this.buttonCancelar.setEnabled(false);
            this.buttonCancelarNF.setEnabled(false);
            this.buttonFechar.setEnabled(true);
            this.buttonNovo.setEnabled(true);
        }
    }

    public void limparCampos() {
        this.textNota.setText("");
        this.textCadastro.setText("");
        this.textEmissao.setText("");
        this.textUsuario.setText("");
        this.textCodSerie.setText("");
        this.textDescSerie.setText("");
        this.textValor.setText("");
        this.textImpostos.setText("");
        this.textTotal.setText("");
        this.textCodFormaPgto.setText("");
        this.textDescFormaPgto.setText("");
        this.textDescontos.setText("");
        this.labelVlrSituacao.setText("");
        this.modeloParcelas.clear();
        this.modeloMateriais.clear();
        this.labelTipoCadastro.setText("");
        this.textObservacao.setText("");
        this.detalhesImpostos.setValores(0.0, 0.0, 0.0, 0.0);
    }

    protected boolean validaNF(NotaFiscalBean bean) {
        if (bean.getSituacao().equals("C")) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "A nota fiscal j\u00e1 foi \"Cancelada\".", 2);
            return false;
        }
        return true;
    }

    protected AbstractThreadBean pesquisar() {
        try {
            Hashtable resultado = ((NotaFiscalService)this.service).pesquisaCancelamentoNotaEntradaVO(this.getTopLevelAncestor(), new NotaFiscalVO(), "Pesquisando Notas Fiscais de Entrada");
            if (resultado != null && resultado.size() > 0) {
                this.notaFiscalBean = (NotaFiscalBean)((NotaFiscalService)this.service).get(Variaveis.filialPadrao, resultado.get("nfi_codigo").toString());
                if (this.notaFiscalBean != null) {
                    if (this.validaNF(this.notaFiscalBean)) {
                        return this.notaFiscalBean;
                    }
                } else {
                    return null;
                }
            }
            return null;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "CancelamentoNotaEntrada:pesquisar(String, boolean)");
            return null;
        }
    }

    public int getStatus() {
        return this.status;
    }

    public static long getModuloAcesso() {
        return Long.parseLong("1200200500");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    private class DetalhesImpostos
    extends Detalhes {
        private Double valorIpi;
        private Double valorIcms;
        private Double percIpi;
        private Double percIcms;

        public DetalhesImpostos(int situacao) {
            super(situacao);
            this.valorIpi = new Double(0.0);
            this.valorIcms = new Double(0.0);
            this.percIpi = new Double(0.0);
            this.percIcms = new Double(0.0);
            this.valorIpi = new Double(0.0);
            this.valorIcms = new Double(0.0);
            this.percIpi = new Double(0.0);
            this.percIcms = new Double(0.0);
            this.setFont(this.getFont().deriveFont(11.0f));
            this.setBotaoExpandirVisible(false);
        }

        @Override
        public void montaReduzido() {
            this.setPreferredSize(new Dimension(10, 20));
            super.montaReduzido();
        }

        public void atualizarDados(String html) {
            if (html.toString().equals("") || this.getSituacao() == 2) {
                this.limpaDados();
            } else {
                this.setDetalhes(html.toString());
            }
        }

        public void setValores(Double valorIpi, Double valorIcms, Double percIpi, Double percIcms) {
            this.valorIpi = valorIpi;
            this.valorIcms = valorIcms;
            this.percIpi = percIpi;
            this.percIcms = percIcms;
            this.atualizarDados();
        }

        @Override
        protected void atualizarDados() {
            StringBuilder html = new StringBuilder();
            html.append("<html>");
            html.append("<table>");
            html.append("<font size=20>");
            html.append("<tr>");
            html.append("<td><b>Ipi: ").append("</b></td>");
            html.append("<td align=\"right\" width=60>").append(this.valorIpi == null ? "" : Funcoes.formataDecimal("0.00", this.valorIpi)).append("</td>");
            html.append("<td width=15>-</td>");
            html.append("<td align=\"right\" width=40>").append(this.percIpi == null ? "" : Funcoes.formataDecimal("0.00", this.percIpi)).append("%</td>");
            html.append("<td width=30>-</td>");
            html.append("<td><b>Icms: ").append("</b></td>");
            html.append("<td align=\"right\" width=60>").append(this.valorIcms == null ? "" : Funcoes.formataDecimal("0.00", this.valorIcms)).append("</td>");
            html.append("<td width=15>-</td>");
            html.append("<td align=\"right\" width=40>").append(this.percIcms == null ? "" : Funcoes.formataDecimal("0.00", this.percIcms)).append("%</td>");
            html.append("</tr>");
            html.append("</font>");
            html.append("</table>");
            html.append("</html>");
            this.setDetalhes(html.toString());
            this.repaint();
        }

        public void limparDetalhes() {
            this.setValores(0.0, 0.0, 0.0, 0.0);
        }
    }
}

