/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.estoque.pedido;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.estoque.pedido.CancelamentoNotaEntrada;
import jalis.laboratorio.relatorios.estoque.pedido.RelatorioAutorizacaoFinanceira;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.service.financeiro.NotaFiscalService;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class AutorizacaoFinanceira
extends CancelamentoNotaEntrada {
    protected JButton buttonAutorizar = new JButton("Autorizar");
    private JButton buttonImprimir = new JButton("Imprimir");

    public static long getModuloAcesso() {
        return Long.parseLong("1200200400");
    }

    public AutorizacaoFinanceira() {
        super(false);
        Funcoes.criaBarraDescricao(this, "Autoriza\u00e7\u00e3o Financeira", "Autoriza\u00e7\u00e3o de pagamento de Notas Fiscais de Entrada", "estoque/autorizacao_financeira.jpg");
        this.buttonAutorizar.setMnemonic('A');
        this.buttonAutorizar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AutorizacaoFinanceira.this.autorizarNotaFiscal();
            }
        });
        this.buttonImprimir.setMnemonic('I');
        this.buttonImprimir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Statement st1 = Conexao.getStatement();
                Statement st2 = Conexao.getStatement();
                JDialog diag = new RelatorioAutorizacaoFinanceira().gerarRelatorio(Laboratorio.getInstancia(), st1, st2, Variaveis.filialPadrao, AutorizacaoFinanceira.this.notaFiscalBean.getCodigo().toString());
                diag.setTitle("Impress\u00e3o de Autoriza\u00e7\u00e3o Financeira");
                diag.setPreferredSize(new Dimension(700, 550));
                diag.setMinimumSize(new Dimension(700, 550));
                ScreenUtil.centralizar(diag);
                diag.setVisible(true);
            }
        });
        this.montaPanelBotoes();
        this.controlaCampos();
    }

    private void montaPanelBotoes() {
        this.panelBotoes.removeAll();
        GridBagConstraints c = new GridBagConstraints();
        JPanel panelImprimir = new JPanel(new FlowLayout(0));
        panelImprimir.add(this.buttonImprimir);
        JPanel panelBotoesBasicos = new JPanel(new FlowLayout(2));
        panelBotoesBasicos.add(this.buttonNovo);
        panelBotoesBasicos.add(this.buttonAutorizar);
        panelBotoesBasicos.add(this.buttonCancelar);
        panelBotoesBasicos.add(this.buttonFechar);
        this.panelBotoes.setLayout(new GridBagLayout());
        c.anchor = 17;
        c.fill = 2;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        this.panelBotoes.add((Component)panelImprimir, c);
        ++c.gridx;
        this.panelBotoes.add((Component)panelBotoesBasicos, c);
    }

    @Override
    public void controlaCampos() {
        super.controlaCampos();
        if (this.buttonImprimir != null) {
            this.buttonImprimir.setEnabled(this.notaFiscalBean != null && this.notaFiscalBean.getDataHoraAutorizacaoFinanceira() != null);
        }
        if (this.buttonAutorizar != null) {
            this.buttonAutorizar.setEnabled(this.notaFiscalBean != null && this.notaFiscalBean.getDataHoraAutorizacaoFinanceira() == null);
        }
    }

    private void autorizarNotaFiscal() {
        if (this.notaFiscalBean != null) {
            this.notaFiscalBean.setDataHoraAutorizacaoFinanceira(new Date());
            UsuarioVO usuario = new UsuarioVO();
            usuario.setCodigo(Variaveis.login);
            this.notaFiscalBean.setUsuarioAutorizacaoFinanceira(usuario);
            try {
                new NotaFiscalService().autorizarNotaFiscalEntrada(this.notaFiscalBean);
                Conexao.arquivaSQL();
                this.controlaCampos();
            }
            catch (Exception e) {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(this, e.getMessage() + " - AutorizacaoFinanceira:autorizaNotaFiscal", e.getStackTrace());
            }
        }
    }
}

