/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.estoque.pedido;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadrao;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.relatorios.estoque.pedido.RelatorioAutorizacaoCompra;
import jalis.model.bean.estoque.PedidoBean;
import jalis.model.bean.estoque.PedidoMaterialBean;
import jalis.model.dao.estoque.PedidoDao;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.model.vo.estoque.PedidoVO;
import jalis.service.estoque.PedidoService;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AutorizacaoCompra
extends FrmCadPadrao {
    private JLabel labelPedido = new JLabel();
    private JLabel labelData = new JLabel();
    private JLabel labelVlrData = new JLabel();
    private JLabel labelUsuario = new JLabel();
    private JLabel labelVlrUsuario = new JLabel();
    private JLabel labelAux1 = new JLabel();
    private JLabel labelSubtotal = new JLabel();
    private JLabel labelVlrSubtotal = new JLabel();
    private JLabel labelDesconto = new JLabel();
    private JLabel labelVlrDesconto = new JLabel();
    private JLabel labelTotal = new JLabel();
    private JLabel labelVlrTotal = new JLabel();
    private JLabel labelFornecedor = new JLabel();
    private JLabel labelCodigoFornecedor = new JLabel();
    private JLabel labelFantasiaFornecedor = new JLabel();
    private JLabel labelFormaPagto = new JLabel();
    private JLabel labelVlrFormaPagto = new JLabel();
    private JLabel labelObservacao = new JLabel();
    private JLabel labelFrete = new JLabel();
    private JLabel labelVlrFrete = new JLabel();
    private JPanel panelMateriais = new JPanel();
    private JPanel panelSubtotal = new JPanel();
    private JPanel panelDados = new JPanel();
    private JPanel panelObservacao = new JPanel();
    private JScrollPane scrollMateriais = new JScrollPane();
    private JScrollPane scrollObservacao = new JScrollPane();
    private JButton buttonPedido = new JButton();
    private JButton botaoAutorizar = new JButton("Autorizar");
    private JButton buttonImprimir = new JButton("Imprimir");
    private JButton buttonRemover = new JButton("Remover");
    private JTextArea areaObservacao = new JTextArea();
    private TTextField textPedido = new TTextField(4, 1);
    private JTable tableMateriais = null;
    private ModeloGridTable modeloMateriais = null;
    private PedidoBean pedidoAux = null;

    public AutorizacaoCompra() {
        Funcoes.criaBarraDescricao(this, "Autoriza\u00e7\u00e3o de Compra", "Autoriza\u00e7\u00e3o de pedidos de compra", "estoque/autorizacao_compra.jpg");
        ScreenUtil.setBorda(new Component[]{this.labelVlrData, this.labelVlrUsuario, this.labelCodigoFornecedor, this.labelFantasiaFornecedor, this.labelVlrFormaPagto, this.labelVlrSubtotal, this.labelVlrDesconto, this.labelVlrTotal, this.labelVlrFrete}, new TitledBorder(""));
        this.botaoAutorizar.setMnemonic('A');
        this.buttonImprimir.setMnemonic('I');
        this.buttonRemover.setMnemonic('R');
        this.validarAcessos();
        this.montaPainelBotoes();
        this.montaListener();
        this.tableMateriais = new JTable(this.modeloMateriais);
        this.tableMateriais.removeColumn(this.tableMateriais.getColumn("Objeto"));
        this.tableMateriais.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
            }
        });
        this.modeloMateriais.setColumnSize(new int[]{60, 0, 90, 90, 100, 80, 0}, this.tableMateriais);
        this.tableMateriais.getTableHeader().addMouseListener(this.modeloMateriais);
        this.scrollMateriais = new JScrollPane(this.tableMateriais);
        this.painelCentral.setLayout(new GridBagLayout());
        this.labelPedido.setText("Pedido:");
        this.labelPedido.setDisplayedMnemonic('P');
        this.labelPedido.setLabelFor(this.textPedido);
        this.painelCentral.add((Component)this.labelPedido, new GridBagConstraints());
        this.textPedido.setMinimumSize(new Dimension(70, 20));
        this.textPedido.setPreferredSize(new Dimension(70, 20));
        this.painelCentral.add((Component)this.textPedido, new GridBagConstraints());
        Funcoes.imagemPesquisa(this.buttonPedido);
        this.buttonPedido.setMinimumSize(new Dimension(20, 20));
        this.buttonPedido.setPreferredSize(new Dimension(20, 20));
        this.painelCentral.add((Component)this.buttonPedido, new GridBagConstraints());
        this.labelData.setText("Data:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        this.painelCentral.add((Component)this.labelData, gridBagConstraints);
        this.labelVlrData.setMinimumSize(new Dimension(150, 20));
        this.labelVlrData.setPreferredSize(new Dimension(150, 20));
        this.painelCentral.add((Component)this.labelVlrData, new GridBagConstraints());
        this.labelUsuario.setText("Usu\u00e1rio:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        this.painelCentral.add((Component)this.labelUsuario, gridBagConstraints);
        this.labelVlrUsuario.setMinimumSize(new Dimension(100, 20));
        this.labelVlrUsuario.setPreferredSize(new Dimension(100, 20));
        this.painelCentral.add((Component)this.labelVlrUsuario, new GridBagConstraints());
        this.panelMateriais.setBorder(BorderFactory.createTitledBorder("Materiais"));
        this.panelMateriais.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panelMateriais.add((Component)this.scrollMateriais, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 8;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.painelCentral.add((Component)this.panelMateriais, gridBagConstraints);
        this.panelSubtotal.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.panelSubtotal.add((Component)this.labelAux1, gridBagConstraints);
        this.labelSubtotal.setText("Subtotal:");
        this.panelSubtotal.add((Component)this.labelSubtotal, new GridBagConstraints());
        this.labelVlrSubtotal.setHorizontalAlignment(4);
        this.labelVlrSubtotal.setMinimumSize(new Dimension(70, 20));
        this.labelVlrSubtotal.setPreferredSize(new Dimension(70, 20));
        this.panelSubtotal.add((Component)this.labelVlrSubtotal, new GridBagConstraints());
        this.labelFrete.setText("Frete:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        this.panelSubtotal.add((Component)this.labelFrete, gridBagConstraints);
        this.labelVlrFrete.setHorizontalAlignment(4);
        this.labelVlrFrete.setMinimumSize(new Dimension(70, 20));
        this.labelVlrFrete.setPreferredSize(new Dimension(70, 20));
        this.panelSubtotal.add((Component)this.labelVlrFrete, new GridBagConstraints());
        this.labelDesconto.setText("Desconto:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        this.panelSubtotal.add((Component)this.labelDesconto, gridBagConstraints);
        this.labelVlrDesconto.setHorizontalAlignment(4);
        this.labelVlrDesconto.setMinimumSize(new Dimension(70, 20));
        this.labelVlrDesconto.setPreferredSize(new Dimension(70, 20));
        this.panelSubtotal.add((Component)this.labelVlrDesconto, new GridBagConstraints());
        this.labelTotal.setText("Total:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        this.panelSubtotal.add((Component)this.labelTotal, gridBagConstraints);
        this.labelVlrTotal.setHorizontalAlignment(4);
        this.labelVlrTotal.setMinimumSize(new Dimension(70, 20));
        this.labelVlrTotal.setPreferredSize(new Dimension(70, 20));
        this.panelSubtotal.add((Component)this.labelVlrTotal, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.painelCentral.add((Component)this.panelSubtotal, gridBagConstraints);
        this.panelDados.setLayout(new GridBagLayout());
        this.labelFornecedor.setText("Fornecedor:");
        this.panelDados.add((Component)this.labelFornecedor, new GridBagConstraints());
        this.labelCodigoFornecedor.setHorizontalAlignment(4);
        this.labelCodigoFornecedor.setMinimumSize(new Dimension(70, 20));
        this.labelCodigoFornecedor.setPreferredSize(new Dimension(70, 20));
        this.panelDados.add((Component)this.labelCodigoFornecedor, new GridBagConstraints());
        this.labelFantasiaFornecedor.setMinimumSize(new Dimension(20, 20));
        this.labelFantasiaFornecedor.setPreferredSize(new Dimension(20, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.panelDados.add((Component)this.labelFantasiaFornecedor, gridBagConstraints);
        this.labelFormaPagto.setText("Forma Pagto.:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        this.panelDados.add((Component)this.labelFormaPagto, gridBagConstraints);
        this.labelVlrFormaPagto.setMinimumSize(new Dimension(200, 20));
        this.labelVlrFormaPagto.setPreferredSize(new Dimension(200, 20));
        this.panelDados.add((Component)this.labelVlrFormaPagto, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.painelCentral.add((Component)this.panelDados, gridBagConstraints);
        this.panelObservacao.setMinimumSize(new Dimension(20, 40));
        this.panelObservacao.setPreferredSize(new Dimension(20, 40));
        this.panelObservacao.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        this.labelObservacao.setText("Observa\u00e7\u00e3o:");
        this.labelObservacao.setDisplayedMnemonic('O');
        this.labelObservacao.setLabelFor(this.areaObservacao);
        this.panelObservacao.add((Component)this.labelObservacao, gridBagConstraints);
        this.scrollObservacao.setMinimumSize(new Dimension(20, 40));
        this.scrollObservacao.setPreferredSize(new Dimension(20, 40));
        this.areaObservacao.setColumns(20);
        this.areaObservacao.setRows(5);
        this.areaObservacao.setMinimumSize(new Dimension(20, 20));
        this.areaObservacao.setPreferredSize(new Dimension(20, 20));
        this.scrollObservacao.setViewportView(this.areaObservacao);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.panelObservacao.add((Component)this.scrollObservacao, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.painelCentral.add((Component)this.panelObservacao, gridBagConstraints);
        this.modeloMateriais.ordenarColuna(this.modeloMateriais.findColumn("Descri\u00e7\u00e3o"));
        this.controlaCampos();
    }

    private void validarAcessos() {
        this.botaoAutorizar.setVisible(Acesso.getAcesso(1200200201L));
        this.buttonRemover.setVisible(Acesso.getAcesso(1200200202L));
    }

    private void montaListener() {
        this.buttonImprimir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Statement st1 = Conexao.getStatement();
                Statement st2 = Conexao.getStatement();
                JDialog diag = new RelatorioAutorizacaoCompra().gerarRelatorio(Laboratorio.getInstancia(), st1, st2, Variaveis.filialPadrao, AutorizacaoCompra.this.pedidoAux.getCodigo().toString());
                diag.setTitle("Impress\u00e3o de Autoriza\u00e7\u00e3o de Compra");
                diag.setPreferredSize(new Dimension(750, 500));
                diag.setMinimumSize(new Dimension(750, 500));
                ScreenUtil.centralizar(diag);
                diag.setVisible(true);
            }
        });
        this.botaoNovo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                AutorizacaoCompra.this.setStatus(1);
                AutorizacaoCompra.this.botaoAutorizar.setEnabled(false);
                AutorizacaoCompra.this.buttonRemover.setEnabled(false);
            }
        });
        this.botaoAutorizar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AutorizacaoCompra.this.pedidoAux == null) {
                    return;
                }
                int resp = Funcoes.mensagem(AutorizacaoCompra.this, "Deseja autorizar o pedido de compra?", 4);
                if (resp == 0) {
                    AutorizacaoCompra.this.pedidoAux.setDataAutorizacao(new Date());
                    AutorizacaoCompra.this.botaoCancelar.setEnabled(false);
                    UsuarioVO usuario = new UsuarioVO();
                    usuario.setCodigo(Variaveis.login);
                    AutorizacaoCompra.this.pedidoAux.setUsuarioAutorizacao(usuario);
                    AutorizacaoCompra.this.salvar();
                }
            }
        });
        this.buttonRemover.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AutorizacaoCompra.this.removerAutorizacaoCompra();
            }
        });
        this.buttonPedido.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AutorizacaoCompra.this.buscarPedido();
            }
        });
        this.textPedido.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (AutorizacaoCompra.this.textPedido.getText().isEmpty()) {
                    return;
                }
                if (AutorizacaoCompra.this.pedidoAux != null) {
                    return;
                }
                PedidoBean pedido = null;
                try {
                    pedido = (PedidoBean)new PedidoService().get(AutorizacaoCompra.this.textPedido.getText());
                }
                catch (Exception e1) {
                    Funcoes.mensagem(AutorizacaoCompra.this, "Os dados do pedido n\u00e3o puderam ser carregados.", 2);
                    return;
                }
                if (pedido == null) {
                    Funcoes.mensagem(AutorizacaoCompra.this, "O pedido n\u00e3o foi encontrado.", 2);
                    if (AutorizacaoCompra.this.textPedido.isFocusable() && AutorizacaoCompra.this.textPedido.isEnabled()) {
                        AutorizacaoCompra.this.textPedido.grabFocus();
                    }
                    AutorizacaoCompra.this.textPedido.selectAll();
                    return;
                }
                AutorizacaoCompra.this.pedidoAux = pedido;
                AutorizacaoCompra.this.setStatus(3);
                AutorizacaoCompra.this.preencherCampos(pedido);
                AutorizacaoCompra.this.controlaCampos();
            }
        });
        this.modeloMateriais = new ModeloGridTable(new String[]{"C\u00f3d.", "Descri\u00e7\u00e3o", "Vlr. Unit\u00e1rio", "Quantidade", "Vlr. Desconto", "Vlr. Total", "Objeto"}){

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return super.getColumnClass(columnIndex);
            }

            @Override
            public void fireTableStructureChanged() {
                super.fireTableStructureChanged();
                try {
                    if (AutorizacaoCompra.this.tableMateriais != null) {
                        AutorizacaoCompra.this.tableMateriais.removeColumn(AutorizacaoCompra.this.tableMateriais.getColumn("Objeto"));
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                try {
                    AutorizacaoCompra.this.tableMateriais.removeColumn(AutorizacaoCompra.this.tableMateriais.getColumn("Objeto"));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        };
    }

    private void montaPainelBotoes() {
        JPanel panelImprimir = new JPanel(new FlowLayout(0));
        panelImprimir.add(this.buttonImprimir);
        JPanel panelBotoesBasicos = new JPanel(new FlowLayout(2));
        panelBotoesBasicos.add(this.botaoNovo);
        panelBotoesBasicos.add(this.botaoAutorizar);
        panelBotoesBasicos.add(this.botaoCancelar);
        panelBotoesBasicos.add(this.buttonRemover);
        panelBotoesBasicos.add(this.botaoFechar);
        this.painelBotoes.removeAll();
        this.painelBotoes.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        this.painelBotoes.add((Component)panelImprimir, c);
        ++c.gridx;
        this.painelBotoes.add((Component)panelBotoesBasicos, c);
    }

    public void buscarPedido() {
        this.pedidoAux = this.pesquisar();
        if (this.pedidoAux != null) {
            this.setStatus(3);
            this.preencherCampos(this.pedidoAux);
            this.controlaCampos();
        }
    }

    private PedidoBean pesquisar() {
        try {
            PedidoBean pedido;
            String codigo = new PedidoService().pesquisaVO(this.getTopLevelAncestor(), null);
            if (codigo != null && (pedido = (PedidoBean)new PedidoDao().getBean(Variaveis.filialPadrao, codigo)) != null && pedido.getDataExclusao() == null) {
                return pedido;
            }
        }
        catch (Exception e) {
            Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel carregar dados do pedido de compra.", 2);
        }
        return null;
    }

    private void removerAutorizacaoCompra() {
        try {
            String mensagem = "Deseja realmente remover a autoriza\u00e7\u00e3o do pedido de compra?";
            if (Funcoes.mensagem(this, mensagem, 4) == 0) {
                PedidoService service = new PedidoService();
                PedidoVO pedido = (PedidoVO)this.pedidoAux.toVO();
                this.pedidoAux.setDataAutorizacao(null);
                this.pedidoAux.setUsuarioAutorizacao(null);
                service.removerAutorizacaoCompra(pedido);
                this.controlaCampos();
            }
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace(), "N\u00e3o foi poss\u00edvel remover a autoriza\u00e7\u00e3o.");
        }
    }

    @Override
    public void pressioneiF2() {
        if (this.textPedido.hasFocus()) {
            this.buttonPedido.doClick();
        }
    }

    private void preencherCampos(PedidoBean pedido) {
        if (pedido == null) {
            return;
        }
        this.textPedido.setText(String.valueOf(pedido.getCodigo()));
        this.labelVlrData.setText(Funcoes.formataData("dd/MM/yyyy HH:mm:ss", pedido.getDataHora()));
        this.labelVlrUsuario.setText(pedido.getUsuario().getCodigo());
        this.labelCodigoFornecedor.setText(String.valueOf(pedido.getEntidade().getCodigo()));
        this.labelFantasiaFornecedor.setText(pedido.getEntidade().getFantasia());
        this.labelVlrFormaPagto.setText(pedido.getFormaPagto() == null ? "" : pedido.getFormaPagto().getDescricao());
        this.labelVlrDesconto.setText(Funcoes.formataDecimal(pedido.getValorDesconto()));
        this.labelVlrTotal.setText(Funcoes.formataDecimal(pedido.getValorTotal()));
        this.labelVlrSubtotal.setText(Funcoes.formataDecimal(pedido.getValorTotal() + pedido.getValorDesconto() - pedido.getValorFrete()));
        this.areaObservacao.setText(pedido.getObservacao());
        this.labelVlrFrete.setText(Funcoes.formataDecimal(pedido.getValorFrete()));
        for (int i = 0; i < pedido.getMateriais().size(); ++i) {
            this.adicionaMaterial(pedido.getMateriais().get(i));
        }
    }

    private void adicionaMaterial(PedidoMaterialBean material) {
        this.modeloMateriais.addLine(new Object[]{material.getMaterial().getCodigo(), material.getMaterial().getDescricao(), Funcoes.formataDecimal(material.getValorUnitario()), Funcoes.formataDecimal(material.getQuantidade()), Funcoes.formataDecimal(material.getValorDesconto()), Funcoes.formataDecimal(material.getValorTotal()), material});
        if (this.modeloMateriais.getColunaOrdenacao() != -1) {
            this.modeloMateriais.ordenarColunaSemTrocarSentido(this.modeloMateriais.getColunaOrdenacao());
        } else {
            this.modeloMateriais.ordenarColunaSemTrocarSentido(this.modeloMateriais.findColumn("Descri\u00e7\u00e3o"));
        }
        this.controlaCampos();
    }

    @Override
    public void cancelar() {
        if (Funcoes.mensagem(this, "As informa\u00e7\u00f5es adicionadas ser\u00e3o perdidas.", 4) == 0) {
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    private void limparCampos() {
        this.textPedido.setText("");
        this.labelVlrData.setText("");
        this.labelVlrUsuario.setText("");
        this.labelCodigoFornecedor.setText("");
        this.labelFantasiaFornecedor.setText("");
        this.labelVlrFormaPagto.setText("");
        this.modeloMateriais.clear();
        this.labelVlrSubtotal.setText("");
        this.labelVlrDesconto.setText("");
        this.labelVlrTotal.setText("");
        this.areaObservacao.setText("");
        this.pedidoAux = null;
    }

    private void controlaCampos() {
        boolean habilitar = this.getStatus() == 2;
        this.textPedido.setEnabled(habilitar);
        this.buttonPedido.setEnabled(habilitar);
        this.buttonImprimir.setEnabled(this.pedidoAux != null && this.pedidoAux.getDataAutorizacao() != null);
        this.botaoAutorizar.setEnabled(this.pedidoAux != null && this.pedidoAux.getDataAutorizacao() == null);
        this.buttonRemover.setEnabled(this.pedidoAux != null && this.pedidoAux.getDataAutorizacao() != null);
        this.botaoCancelar.setEnabled(this.pedidoAux != null && this.pedidoAux.getDataAutorizacao() == null);
        this.tableMateriais.setEnabled(false);
        this.areaObservacao.setEditable(false);
        if (this.getStatus() == 3) {
            this.botaoNovo.setEnabled(true);
            this.botaoFechar.setEnabled(true);
        }
    }

    @Override
    @Deprecated
    public void editar() {
    }

    @Override
    @Deprecated
    public void excluir() {
    }

    @Override
    public void fechar() {
        this.setVisible(false);
    }

    @Override
    public void novo() {
        this.limparCampos();
        this.textPedido.setEnabled(true);
        this.buttonPedido.setEnabled(true);
        if (this.textPedido.isFocusable() && this.textPedido.isEnabled()) {
            this.textPedido.grabFocus();
        }
    }

    @Override
    public void salvar() {
        PedidoService service = new PedidoService();
        PedidoBean bean = this.pedidoAux;
        if (bean != null) {
            try {
                service.gravaAutoCopiaSemCommit(bean, 1, Variaveis.filialPadrao, this.getCopiaFiliais());
                Conexao.arquivaSQL();
                this.controlaCampos();
            }
            catch (Exception e) {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                Funcoes.mensagem(this.getTopLevelAncestor(), "N\u00e3o foi poss\u00edvel salvar o pedido de compra.", 2);
            }
        }
    }

    protected String getCopiaFiliais() {
        return null;
    }

    @Override
    @Deprecated
    public boolean validaCampos() {
        return false;
    }

    public static long getModuloAcesso() {
        return Long.parseLong("1200200200");
    }

    @Override
    public String getRetornoParaPesquisa() {
        return "";
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return null;
    }
}

