/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.estoque.cotacao;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadrao;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.cadastro.VisualizarMateriaisAlternativos;
import jalis.laboratorio.estoque.DialogoFiltroMateriais;
import jalis.laboratorio.estoque.cotacao.DialogAlteracaoQuantidade;
import jalis.model.AbstractThreadBean;
import jalis.model.bean.estoque.CotacaoBean;
import jalis.model.bean.estoque.CotacaoMaterialBean;
import jalis.model.bean.estoque.MaterialBean;
import jalis.model.bean.estoque.RequisicaoEstoqueBean;
import jalis.model.bean.estoque.RequisicaoEstoqueMaterialBean;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.model.vo.estoque.CotacaoVO;
import jalis.model.vo.estoque.MaterialVO;
import jalis.model.vo.estoque.RequisicaoEstoqueVO;
import jalis.service.estoque.CotacaoService;
import jalis.service.estoque.MaterialService;
import jalis.service.estoque.RequisicaoEstoqueService;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.SplashMensagem;
import jalis.util.TTextAreaDocument;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SolicitarCotacao
extends FrmCadPadrao {
    private JButton buttonBuscaMaterial = new JButton();
    private JButton buttonOk = new JButton("OK");
    private JPanel painelBotaoImportar;
    private JButton botaoImportar;
    private JLabel labelAux1 = new JLabel();
    private JLabel labelAux2 = new JLabel();
    private JLabel labelAux3 = new JLabel();
    private JLabel labelData = new JLabel("Data:");
    private JLabel labelDescricaoMaterial = new JLabel();
    private JLabel labelMaterial = new JLabel("Material");
    private JLabel labelQuantidade = new JLabel("Qtde.");
    private JLabel labelUnidade = new JLabel("Unidade");
    private JLabel labelUsuario = new JLabel("Usu\u00e1rio:");
    private JLabel labelCodigo = new JLabel("C\u00f3digo:");
    private JLabel labelVlrData = new JLabel();
    private JLabel labelVlrUnidade = new JLabel();
    private JLabel labelVlrUsuario = new JLabel();
    private JLabel labelVlrCodigo = new JLabel();
    private JPanel panelCabecalho = new JPanel(new GridBagLayout());
    private JPanel panelObservacao = new JPanel(new GridBagLayout());
    private JPanel panelMateriais = new JPanel(new GridBagLayout());
    private JScrollPane scrollMateriais;
    private JScrollPane scrollObservacao;
    private TTextField textMaterial = new TTextField(18, 3);
    private TTextField textQuantidade = new TTextField(10, 2);
    private JTextArea textObservacao = new JTextArea(new TTextAreaDocument(500));
    private ModeloGridTable modeloMateriais;
    private JTable tableMateriais;
    private MaterialBean materialAux = null;
    private Date dataHoraCriacao = null;
    private Component[] botoesPadrao = this.painelBotoes.getComponents();

    public SolicitarCotacao() {
        Funcoes.criaBarraDescricao(this, "Solicitar Cota\u00e7\u00e3o", "Solicita\u00e7\u00e3o de cota\u00e7\u00e3o de materiais", "estoque/solicitar_cotacao.jpg");
        ScreenUtil.setBorda(new Component[]{this.labelVlrUsuario, this.labelVlrData, this.labelDescricaoMaterial, this.labelVlrUnidade, this.labelVlrCodigo}, new TitledBorder(""));
        this.botaoExcluir.setVisible(false);
        Funcoes.imagemPesquisa(this.buttonBuscaMaterial);
        this.painelCentral.setLayout(new GridBagLayout());
        this.textMaterial.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (Funcoes.textoVazio(SolicitarCotacao.this.textMaterial)) {
                    return;
                }
                MaterialBean bean = null;
                try {
                    bean = (MaterialBean)new MaterialService().getAtivo(Variaveis.filialPadrao, SolicitarCotacao.this.textMaterial.getText(), null, null);
                }
                catch (Exception e1) {
                    SolicitarCotacao.this.labelDescricaoMaterial.setText("N\u00e3o cadastrado");
                    SolicitarCotacao.this.materialAux = null;
                    return;
                }
                if (bean == null) {
                    bean = VisualizarMateriaisAlternativos.getTelaMaterialAlternativo(bean, SolicitarCotacao.this.textMaterial);
                }
                if (bean != null) {
                    SolicitarCotacao.this.textMaterial.setText(bean.getCodigo().toString());
                    SolicitarCotacao.this.labelDescricaoMaterial.setText(bean.getDescricao());
                    SolicitarCotacao.this.labelVlrUnidade.setText(bean.getUnidadeMedida().getCodigo());
                    SolicitarCotacao.this.materialAux = bean;
                    if (SolicitarCotacao.this.textQuantidade.isEnabled() && SolicitarCotacao.this.textQuantidade.isFocusable()) {
                        ScreenUtil.requisitarFoco(SolicitarCotacao.this.textQuantidade);
                    }
                } else {
                    SolicitarCotacao.this.labelDescricaoMaterial.setText("N\u00e3o cadastrado");
                    SolicitarCotacao.this.materialAux = null;
                }
            }
        });
        this.buttonBuscaMaterial.setFocusable(false);
        this.buttonBuscaMaterial.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    List<HashMap<String, Object>> materiais = null;
                    DialogoFiltroMateriais diag = new DialogoFiltroMateriais(Laboratorio.getInstancia());
                    diag.setVisible(true);
                    if (diag.getOk() && (materiais = diag.getMateriaisSelecionados()) != null) {
                        Iterator<HashMap<String, Object>> it = materiais.iterator();
                        if (materiais.size() > 0) {
                            SplashMensagem janelaEspera = SplashMensagem.getInstancia(SolicitarCotacao.this);
                            janelaEspera.mostrar("Adicionando materiais");
                            int i = 0;
                            int qtde = materiais.size();
                            while (it.hasNext()) {
                                HashMap<String, Object> reg = it.next();
                                janelaEspera.setText("Adicionando materiais - " + (int)Funcoes.arredondar(++i * 100 / qtde, 2) + "%");
                                MaterialBean material = (MaterialBean)new MaterialService().getAtivo(Variaveis.filialPadrao, String.valueOf(reg.get("C\u00f3digo")), null, null);
                                if (material == null) continue;
                                SolicitarCotacao.this.adicionarMaterial(material, (Double)reg.get("Qtde."));
                            }
                            janelaEspera.apagar();
                        }
                    }
                }
                catch (Exception e1) {
                    ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel adicionar materiais.\n" + e1.getMessage(), e1.getStackTrace());
                }
            }
        });
        this.buttonOk.setMnemonic('O');
        this.buttonOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Funcoes.textoVazio(SolicitarCotacao.this.textQuantidade)) {
                    Funcoes.mensagem(SolicitarCotacao.this, "A quantidade n\u00e3o foi informada.", 2);
                    if (SolicitarCotacao.this.textQuantidade.isEnabled() && SolicitarCotacao.this.textQuantidade.isFocusable()) {
                        ScreenUtil.requisitarFoco(SolicitarCotacao.this.textQuantidade);
                    }
                    return;
                }
                if (Double.valueOf(SolicitarCotacao.this.textQuantidade.getText()) <= 0.0) {
                    Funcoes.mensagem(SolicitarCotacao.this, "A quantidade informada deve ser maior que zero.", 2);
                    if (SolicitarCotacao.this.textQuantidade.isEnabled() && SolicitarCotacao.this.textQuantidade.isFocusable()) {
                        ScreenUtil.requisitarFoco(SolicitarCotacao.this.textQuantidade);
                    }
                    return;
                }
                if (SolicitarCotacao.this.materialAux != null) {
                    SolicitarCotacao.this.adicionarMaterial(SolicitarCotacao.this.materialAux, Double.parseDouble(SolicitarCotacao.this.textQuantidade.getText()));
                }
                SolicitarCotacao.this.textMaterial.setText("");
                SolicitarCotacao.this.labelDescricaoMaterial.setText("");
                SolicitarCotacao.this.materialAux = null;
                if (SolicitarCotacao.this.textMaterial.isEnabled() && SolicitarCotacao.this.textMaterial.isFocusable()) {
                    ScreenUtil.requisitarFoco(SolicitarCotacao.this.textMaterial);
                }
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.panelCabecalho.add((Component)this.labelCodigo, gridBagConstraints);
        this.labelVlrCodigo.setHorizontalAlignment(4);
        this.labelVlrCodigo.setMinimumSize(new Dimension(60, 20));
        this.labelVlrCodigo.setPreferredSize(new Dimension(60, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.panelCabecalho.add((Component)this.labelVlrCodigo, gridBagConstraints);
        this.labelAux3.setMinimumSize(new Dimension(20, 20));
        this.labelAux3.setPreferredSize(new Dimension(20, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.panelCabecalho.add((Component)this.labelAux3, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        this.panelCabecalho.add((Component)this.labelUsuario, gridBagConstraints);
        this.labelVlrUsuario.setMinimumSize(new Dimension(90, 20));
        this.labelVlrUsuario.setPreferredSize(new Dimension(90, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.panelCabecalho.add((Component)this.labelVlrUsuario, gridBagConstraints);
        this.labelAux1.setMinimumSize(new Dimension(20, 20));
        this.labelAux1.setPreferredSize(new Dimension(20, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.panelCabecalho.add((Component)this.labelAux1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.panelCabecalho.add((Component)this.labelData, gridBagConstraints);
        this.labelVlrData.setMinimumSize(new Dimension(150, 20));
        this.labelVlrData.setPreferredSize(new Dimension(150, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.panelCabecalho.add((Component)this.labelVlrData, gridBagConstraints);
        this.labelAux2.setMinimumSize(new Dimension(20, 20));
        this.labelAux2.setPreferredSize(new Dimension(20, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.panelCabecalho.add((Component)this.labelAux2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 2, 1);
        this.painelCentral.add((Component)this.panelCabecalho, gridBagConstraints);
        this.panelMateriais.setBorder(BorderFactory.createTitledBorder("Materiais"));
        this.modeloMateriais = new ModeloGridTable(new String[]{"C\u00f3digo", "Material", "Quantidade", "Unidade", "Objeto"}){

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                Object[] classes = new Object[]{Integer.class, String.class, Object.class, String.class, MaterialBean.class};
                return (Class)classes[columnIndex];
            }

            @Override
            public void fireTableStructureChanged() {
                super.fireTableStructureChanged();
                try {
                    if (SolicitarCotacao.this.tableMateriais != null) {
                        SolicitarCotacao.this.tableMateriais.removeColumn(SolicitarCotacao.this.tableMateriais.getColumn("Objeto"));
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                try {
                    SolicitarCotacao.this.tableMateriais.removeColumn(SolicitarCotacao.this.tableMateriais.getColumn("Objeto"));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        };
        this.tableMateriais = new JTable(this.modeloMateriais);
        this.tableMateriais.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127) {
                    SolicitarCotacao.this.removerMaterialSelecionado();
                } else if (e.getKeyCode() == 32) {
                    SolicitarCotacao.this.alteraQuantidadeMaterial();
                }
            }
        });
        this.tableMateriais.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
            }
        });
        this.tableMateriais.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && (SolicitarCotacao.this.getStatus() == 2 || SolicitarCotacao.this.getStatus() == 3)) {
                    SolicitarCotacao.this.alteraQuantidadeMaterial();
                }
            }
        });
        this.modeloMateriais.setColumnSize(new int[]{70, 0, 90, 70, 0}, this.tableMateriais);
        this.tableMateriais.getTableHeader().addMouseListener(this.modeloMateriais);
        this.tableMateriais.removeColumn(this.tableMateriais.getColumn("Objeto"));
        this.scrollMateriais = new JScrollPane(this.tableMateriais);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 9;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 1, 1, 1);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 0;
        this.panelMateriais.add((Component)this.scrollMateriais, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        this.labelMaterial.setDisplayedMnemonic('M');
        this.labelMaterial.setLabelFor(this.textMaterial);
        this.panelMateriais.add((Component)this.labelMaterial, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 3;
        this.labelQuantidade.setDisplayedMnemonic('Q');
        this.labelQuantidade.setLabelFor(this.textQuantidade);
        this.panelMateriais.add((Component)this.labelQuantidade, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 4;
        this.panelMateriais.add((Component)this.labelUnidade, gridBagConstraints);
        this.textMaterial.setMinimumSize(new Dimension(70, 20));
        this.textMaterial.setPreferredSize(new Dimension(70, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        this.panelMateriais.add((Component)this.textMaterial, gridBagConstraints);
        this.buttonBuscaMaterial.setMinimumSize(new Dimension(20, 20));
        this.buttonBuscaMaterial.setPreferredSize(new Dimension(20, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 1;
        this.panelMateriais.add((Component)this.buttonBuscaMaterial, gridBagConstraints);
        this.labelDescricaoMaterial.setMinimumSize(new Dimension(200, 20));
        this.labelDescricaoMaterial.setPreferredSize(new Dimension(200, 20));
        this.labelDescricaoMaterial.setRequestFocusEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 2;
        this.panelMateriais.add((Component)this.labelDescricaoMaterial, gridBagConstraints);
        this.textQuantidade.setMinimumSize(new Dimension(50, 20));
        this.textQuantidade.setPreferredSize(new Dimension(50, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 3;
        this.panelMateriais.add((Component)this.textQuantidade, gridBagConstraints);
        this.labelVlrUnidade.setMinimumSize(new Dimension(50, 20));
        this.labelVlrUnidade.setPreferredSize(new Dimension(50, 20));
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 4;
        this.panelMateriais.add((Component)this.labelVlrUnidade, gridBagConstraints);
        this.buttonOk.setMargin(new Insets(1, 1, 1, 1));
        this.buttonOk.setMinimumSize(new Dimension(40, 20));
        this.buttonOk.setPreferredSize(new Dimension(40, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 5;
        this.panelMateriais.add((Component)this.buttonOk, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.painelCentral.add((Component)this.panelMateriais, gridBagConstraints);
        this.panelObservacao.setBorder(BorderFactory.createTitledBorder("Observa\u00e7\u00e3o"));
        this.scrollObservacao = new JScrollPane(this.textObservacao);
        this.scrollObservacao.setMinimumSize(new Dimension(100, 50));
        this.scrollObservacao.setPreferredSize(new Dimension(100, 50));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.panelObservacao.add((Component)this.scrollObservacao, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.painelCentral.add((Component)this.panelObservacao, gridBagConstraints);
        this.painelBotoes = new JPanel();
        this.painelBotoes.setLayout(new GridBagLayout());
        this.painelBotoes.setFocusable(false);
        this.painelBotaoImportar = new JPanel(new FlowLayout(0));
        this.botaoImportar = new JButton("Importar");
        this.botaoImportar.setMnemonic('I');
        this.botaoImportar.setEnabled(false);
        this.painelBotaoImportar.add(this.botaoImportar);
        this.painelBotoes.add(this.painelBotaoImportar);
        this.add((Component)this.painelBotoes, "South");
        GridBagConstraints g = new GridBagConstraints();
        g.fill = 2;
        g.weightx = 2.0;
        this.painelBotoes.add((Component)new JLabel(), g);
        GridBagConstraints gbcBotoes = new GridBagConstraints();
        gbcBotoes.insets = new Insets(0, 3, 0, 3);
        for (Component component : this.botoesPadrao) {
            if (!(component instanceof JButton)) continue;
            this.painelBotoes.add(component, gbcBotoes);
        }
        this.botaoImportar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!SolicitarCotacao.this.flagDialogAberto) {
                    SolicitarCotacao.this.importar();
                }
            }
        });
        this.controlaCampos();
    }

    private void importar() {
        RequisicaoEstoqueVO reqVO = new RequisicaoEstoqueVO();
        reqVO = (RequisicaoEstoqueVO)new RequisicaoEstoqueService().pesquisaRequisicaoAbertaVO(Laboratorio.getInstancia(), reqVO, "Pesquisando Requisi\u00e7\u00f5es de Estoque", false);
        if (reqVO != null) {
            RequisicaoEstoqueBean reqBean = null;
            try {
                reqBean = (RequisicaoEstoqueBean)new RequisicaoEstoqueService().get(Variaveis.filialPadrao, reqVO.getCodigo().toString());
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "RequisicaoMaterial:importar");
                return;
            }
            if (reqBean != null && this.showDialogSubstituirOuAtualizar() != -1) {
                if (reqBean.getMateriais() != null) {
                    this.adicionarListaMateriais(reqBean.getMateriais());
                }
                this.controlaCampos();
            }
        }
    }

    private int showDialogSubstituirOuAtualizar() {
        if (this.modeloMateriais.getRowCount() > 0) {
            int resp = Funcoes.mensagem(this, "J\u00e1 existe uma lista de Materiais. O que deseja fazer?", 6);
            if (resp == 3) {
                this.modeloMateriais.clear();
                return resp;
            }
            if (resp == 4) {
                return resp;
            }
            if (resp == -1) {
                return resp;
            }
        }
        return 0;
    }

    private void removerMaterialSelecionado() {
        int resp = Funcoes.mensagem(this, "Deseja remover o material?", 4);
        if (resp == 0) {
            this.modeloMateriais.removeLine(this.tableMateriais.getSelectedRow());
        }
        this.controlaCampos();
    }

    private void adicionarMaterial(MaterialBean bean, Double quantidade) {
        if (bean != null) {
            for (int i = 0; i < this.modeloMateriais.getRowCount(); ++i) {
                if (bean.getCodigo().intValue() != ((Integer)this.modeloMateriais.getValueAt(i, this.modeloMateriais.findColumn("C\u00f3digo"))).intValue()) continue;
                Double quantidadeAtual = Double.parseDouble(this.modeloMateriais.getValueAt(i, this.modeloMateriais.findColumn("Quantidade")).toString().replace(".", "").replace(",", "."));
                quantidade = quantidade + quantidadeAtual;
                this.modeloMateriais.setValueAt(Funcoes.formataDecimal(quantidade), i, this.modeloMateriais.findColumn("Quantidade"));
                return;
            }
            this.adicionaMaterialAoModelo(bean, quantidade);
            if (this.modeloMateriais.getColunaOrdenacao() != -1) {
                this.modeloMateriais.ordenarColunaSemTrocarSentido(this.modeloMateriais.getColunaOrdenacao());
            } else {
                this.modeloMateriais.ordenarColunaSemTrocarSentido(this.modeloMateriais.findColumn("Material"));
            }
            this.textMaterial.setText("");
            this.textQuantidade.setText("");
            this.labelVlrUnidade.setText("");
        }
        this.controlaCampos();
    }

    private void adicionaMaterialAoModelo(MaterialBean bean, Double quantidade) {
        this.modeloMateriais.addLine(new Object[]{bean.getCodigo(), bean.getDescricao(), Funcoes.formataDecimal(quantidade), bean.getUnidadeMedida().getCodigo(), bean});
    }

    private boolean adicionarListaMateriais(ArrayList<RequisicaoEstoqueMaterialBean> materiais) {
        ArrayList<Integer> codigosMateriais = new ArrayList<Integer>();
        for (int i = 0; i < materiais.size(); ++i) {
            for (int j = 0; j < this.modeloMateriais.getRowCount(); ++j) {
                Object aux = this.modeloMateriais.getValueAt(j, this.modeloMateriais.findColumn("Objeto"));
                if (aux instanceof RequisicaoEstoqueMaterialBean) {
                    codigosMateriais.add(((RequisicaoEstoqueMaterialBean)aux).getMaterial().getCodigo());
                    this.adicionarMaterialRequisicaoBean(materiais.get(i), j, aux);
                    continue;
                }
                if (aux instanceof MaterialBean) {
                    codigosMateriais.add(((MaterialBean)aux).getCodigo());
                    this.adicionarMaterialBean(materiais.get(i), aux);
                    continue;
                }
                if (!(aux instanceof MaterialVO)) continue;
                codigosMateriais.add(((MaterialBean)aux).getCodigo());
                MaterialBean auxBean = (MaterialBean)((MaterialVO)aux).toBean();
                this.adicionarMaterialBean(materiais.get(i), auxBean);
            }
            if (codigosMateriais.contains(materiais.get(i).getMaterial().getCodigo())) continue;
            this.adicionaMaterialAoModelo((MaterialBean)materiais.get(i).getMaterial().toBean(), materiais.get(i).getQuantidade());
        }
        if (this.modeloMateriais.getColunaOrdenacao() != -1) {
            this.modeloMateriais.ordenarColunaSemTrocarSentido(this.modeloMateriais.getColunaOrdenacao());
        } else {
            this.modeloMateriais.ordenarColunaSemTrocarSentido(this.modeloMateriais.findColumn("Material"));
        }
        this.controlaCampos();
        return true;
    }

    private void adicionarMaterialBean(RequisicaoEstoqueMaterialBean material, Object aux) {
        if (material != null && ((MaterialBean)aux).getCodigo().intValue() == material.getMaterial().getCodigo().intValue()) {
            this.adicionarMaterial((MaterialBean)aux, material.getQuantidade());
            if (this.textMaterial.isFocusable() && this.textMaterial.isEnabled()) {
                this.textMaterial.grabFocus();
            }
        }
    }

    private void adicionarMaterialRequisicaoBean(RequisicaoEstoqueMaterialBean material, int linha, Object aux) {
        if (material != null && ((RequisicaoEstoqueMaterialBean)aux).getMaterial().getCodigo().intValue() == material.getMaterial().getCodigo().intValue()) {
            Double quantidadeAtualizada = material.getQuantidade() + ((RequisicaoEstoqueMaterialBean)aux).getQuantidade();
            this.modeloMateriais.setValueAt(Funcoes.formataDecimal(quantidadeAtualizada), linha, this.modeloMateriais.findColumn("Quantidade"));
            if (this.textMaterial.isFocusable() && this.textMaterial.isEnabled()) {
                this.textMaterial.grabFocus();
            }
        }
    }

    private void limparCampos() {
        this.labelVlrCodigo.setText("");
        this.labelVlrUsuario.setText("");
        this.labelVlrData.setText("");
        this.textMaterial.setText("");
        this.labelDescricaoMaterial.setText("");
        this.textQuantidade.setText("");
        this.labelVlrUnidade.setText("");
        this.textObservacao.setText("");
        this.modeloMateriais.clear();
        this.dataHoraCriacao = null;
    }

    private void controlaCampos() {
        boolean habilitar = this.getStatus() == 2 || this.getStatus() == 3;
        this.textMaterial.setEnabled(habilitar);
        this.buttonBuscaMaterial.setEnabled(habilitar);
        this.textQuantidade.setEnabled(habilitar);
        this.buttonOk.setEnabled(habilitar);
        this.textObservacao.setEnabled(habilitar);
    }

    @Override
    public void cancelar() {
        if (Funcoes.mensagem(this, "As informa\u00e7\u00f5es adicionadas ser\u00e3o perdidas.", 4) == 0) {
            this.limparCampos();
            this.setStatus(1);
            this.botaoImportar.setEnabled(false);
            this.controlaCampos();
        }
    }

    @Override
    @Deprecated
    public void excluir() {
    }

    @Override
    public void fechar() {
        if (this.getStatus() == 1 || Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setVisible(false);
        }
    }

    @Override
    public void novo() {
        this.limparCampos();
        this.setStatus(2);
        this.controlaCampos();
        this.botaoImportar.setEnabled(true);
        this.labelVlrUsuario.setText(Variaveis.login);
        this.dataHoraCriacao = new Date();
        this.labelVlrData.setText(Funcoes.formataData("dd/MM/yyyy HH:mm:ss", this.dataHoraCriacao));
        if (this.textMaterial.isEnabled() && this.textMaterial.isFocusable()) {
            this.textMaterial.grabFocus();
        }
    }

    @Override
    public boolean validaCampos() {
        if (Funcoes.textoVazio(this.labelVlrUsuario.getText())) {
            return false;
        }
        if (Funcoes.textoVazio(this.labelVlrData.getText())) {
            return false;
        }
        if (this.modeloMateriais.getRowCount() <= 0) {
            Funcoes.mensagem(this, "N\u00e3o \u00e9 poss\u00edvel salvar, pois n\u00e3o h\u00e1 nenhum material na solicita\u00e7\u00e3o.", 2);
            return false;
        }
        for (int i = 0; i < this.modeloMateriais.getRowCount(); ++i) {
            Double qtde = Double.parseDouble(Funcoes.limpaDecimal((String)this.modeloMateriais.getValueAt(i, this.modeloMateriais.findColumn("Quantidade"))));
            if (!(qtde <= 0.0)) continue;
            Funcoes.mensagem(this, "A quantidade do material: " + this.modeloMateriais.getValueAt(i, this.modeloMateriais.findColumn("Material")) + "\n deve ser maior que zero.", 2);
            return false;
        }
        return true;
    }

    public static long getModuloAcesso() {
        return Long.parseLong("1200100100");
    }

    protected String getCopiaFiliais() {
        return null;
    }

    @Override
    public void salvar() {
        CotacaoBean bean;
        CotacaoService service = new CotacaoService();
        if (this.validaCampos() && (bean = this.getBeanPreenchido()) != null) {
            try {
                service.gravaAutoCopiaSemCommit(bean, this.getStatus() == 2 ? 0 : 1, Variaveis.filialPadrao, this.getCopiaFiliais());
                Conexao.arquivaSQL();
                if (this.getStatus() == 2) {
                    Funcoes.mensagem(this, "Cota\u00e7\u00e3o gerada com o c\u00f3digo: " + bean.getCodigo() + ".", 5);
                } else if (this.getStatus() == 3) {
                    Funcoes.mensagem(this, "Cota\u00e7\u00e3o editada com sucesso!", 5);
                }
                service.enviaMensagemResponsavel(bean, this.getStatus() == 3);
                this.limparCampos();
                this.botaoImportar.setEnabled(false);
                this.setStatus(1);
                this.controlaCampos();
            }
            catch (Exception e) {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel inserir a cota\u00e7\u00e3o. - " + e.getMessage(), 2);
            }
        }
    }

    private AbstractThreadBean pesquisar() {
        CotacaoService service = new CotacaoService();
        try {
            AbstractThreadVO vo = service.pesquisaVO((Object)this.getTopLevelAncestor(), (AbstractThreadVO)new CotacaoVO(), "Pesquisando Cota\u00e7\u00f5es", new String[]{"S"});
            if (vo != null) {
                return (CotacaoBean)service.get(String.valueOf(((CotacaoVO)vo).getFilial().getCodigo()), String.valueOf(((CotacaoVO)vo).getCodigo()));
            }
        }
        catch (Exception e) {
            Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel carregar dados da cota\u00e7\u00e3o.", 2);
        }
        return null;
    }

    private void preencherCampos(CotacaoBean cotacao) {
        if (cotacao != null) {
            this.labelVlrCodigo.setText(String.valueOf(cotacao.getCodigo()));
            this.labelVlrUsuario.setText(cotacao.getUsuario().getCodigo());
            this.dataHoraCriacao = cotacao.getDataHora();
            this.labelVlrData.setText(Funcoes.formataData("dd/MM/yyyy HH:mm:ss", cotacao.getDataHora()));
            this.textObservacao.setText(cotacao.getObservacao());
            if (cotacao.getMateriaisCotacao() != null) {
                Set<CotacaoMaterialBean> materais = cotacao.getMateriaisCotacao();
                for (CotacaoMaterialBean material : materais) {
                    MaterialBean beanMaterial = null;
                    try {
                        beanMaterial = (MaterialBean)new MaterialService().getTodos(String.valueOf(material.getFilial().getCodigo()), String.valueOf(material.getMaterial().getCodigo()), null, null);
                    }
                    catch (Exception e) {
                        Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel carregar dados do material. C\u00f3d. Material: " + material.getMaterial().getCodigo(), 2);
                        continue;
                    }
                    this.adicionarMaterial(beanMaterial, material.getQuantidade());
                }
            }
        }
    }

    @Override
    public void editar() {
        this.limparCampos();
        CotacaoBean bean = (CotacaoBean)this.pesquisar();
        this.labelVlrUsuario.setText(Variaveis.login);
        if (bean != null) {
            this.preencherCampos(bean);
            this.setStatus(3);
            this.controlaCampos();
            this.botaoImportar.setEnabled(true);
            if (this.textMaterial.isEnabled() && this.textMaterial.isFocusable()) {
                this.textMaterial.grabFocus();
            }
        } else {
            this.botaoImportar.setEnabled(false);
        }
    }

    @Override
    public void pressioneiF2() {
        if (this.textMaterial.hasFocus()) {
            this.buttonBuscaMaterial.doClick();
        }
    }

    private CotacaoBean getBeanPreenchido() {
        CotacaoBean cotacao = new CotacaoBean();
        FilialVO filial = new FilialVO();
        filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
        UsuarioVO usuario = new UsuarioVO();
        usuario.setCodigo(Variaveis.login);
        if (!Funcoes.textoVazio(this.labelVlrCodigo.getText())) {
            cotacao.setCodigo(Integer.parseInt(this.labelVlrCodigo.getText()));
        }
        cotacao.setFilial(filial);
        cotacao.setDataHora(this.dataHoraCriacao);
        cotacao.setObservacao(this.textObservacao.getText());
        cotacao.setSituacao("S");
        cotacao.setUsuario(usuario);
        HashSet<CotacaoMaterialBean> materiais = new HashSet<CotacaoMaterialBean>();
        for (int i = 0; i < this.modeloMateriais.getRowCount(); ++i) {
            CotacaoMaterialBean material = new CotacaoMaterialBean();
            material.setFilial(filial);
            Object mat = this.modeloMateriais.getValueAt(i, this.modeloMateriais.findColumn("Objeto"));
            if (mat instanceof MaterialVO) {
                material.setMaterial((MaterialVO)this.modeloMateriais.getValueAt(i, this.modeloMateriais.findColumn("Objeto")));
            } else if (mat instanceof MaterialBean) {
                material.setMaterial((MaterialVO)((MaterialBean)this.modeloMateriais.getValueAt(i, this.modeloMateriais.findColumn("Objeto"))).toVO());
            }
            material.setQuantidade(Double.parseDouble(Funcoes.limpaDecimal((String)this.modeloMateriais.getValueAt(i, this.modeloMateriais.findColumn("Quantidade")))));
            materiais.add(material);
        }
        if (!materiais.isEmpty()) {
            cotacao.setMateriaisCotacao(materiais);
        }
        return cotacao;
    }

    public static void novaInstanciaDialog(Frame owner, ArrayList<Object[]> materiais) {
        final JDialog aux = new JDialog(owner, "Solicitar Cota\u00e7\u00e3o", true);
        aux.setSize(700, 600);
        SolicitarCotacao cotacao = new SolicitarCotacao(){

            @Override
            public void fechar() {
                super.fechar();
                aux.setVisible(false);
            }
        };
        cotacao.novo();
        for (int i = 0; i < materiais.size(); ++i) {
            Object[] valores = materiais.get(i);
            super.adicionarMaterial((MaterialBean)valores[0], (Double)valores[1]);
        }
        Container painelConteudo = aux.getContentPane();
        painelConteudo.setLayout(new BorderLayout());
        painelConteudo.add((Component)cotacao, "Center");
        ((JPanel)painelConteudo).setBorder(ScreenUtil.criarBordaVazia());
        aux.setLocationRelativeTo(Laboratorio.getInstancia());
        aux.setVisible(true);
    }

    private void alteraQuantidadeMaterial() {
        if (this.modeloMateriais.getRowCount() > 0 && this.tableMateriais.getSelectedRow() > -1) {
            int linha = this.tableMateriais.getSelectedRow();
            int coluna = this.modeloMateriais.findColumn("Quantidade");
            Double quantidade = Double.parseDouble(Funcoes.limpaDecimal((String)this.modeloMateriais.getValueAt(linha, coluna)));
            quantidade = this.mostraDialogAlteracaoQuantidade(quantidade);
            this.modeloMateriais.setValueAt(Funcoes.formataDecimal(quantidade), linha, coluna);
        }
    }

    private Double mostraDialogAlteracaoQuantidade(Double valorAntigo) {
        DialogAlteracaoQuantidade diag = new DialogAlteracaoQuantidade(valorAntigo);
        return diag.getNovoValor() == null ? valorAntigo : diag.getNovoValor();
    }

    @Override
    public String getRetornoParaPesquisa() {
        return "";
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return null;
    }
}

