/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.estoque.cotacao;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.sql.ResultSet;
import java.sql.Statement;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

class JanelaHistoricoCotacao
extends AbstractDialogoOKCancelar {
    private ModeloGridTable modelo = new ModeloGridTable(new String[]{"Fornecedor", "Data", "Valor"});
    private JTable tabela = new JTable(this.modelo);

    public static JanelaHistoricoCotacao novaInstancia(Container pai, String material, String descricao, String cotacaoAtual) {
        if (pai instanceof Dialog) {
            return new JanelaHistoricoCotacao((Dialog)pai, material, descricao, cotacaoAtual);
        }
        if (pai instanceof Frame) {
            return new JanelaHistoricoCotacao((Frame)pai, material, descricao, cotacaoAtual);
        }
        return null;
    }

    public JanelaHistoricoCotacao(Dialog pai, String codigoMaterial, String descricaoMaterial, String cotacaoAtual) {
        super(pai, "Hist\u00f3rico de cota\u00e7\u00e3o de " + descricaoMaterial);
        this.carregaDados(codigoMaterial, cotacaoAtual);
        this.montaTela();
    }

    public JanelaHistoricoCotacao(Frame pai, String codigoMaterial, String descricaoMaterial, String cotacaoAtual) {
        super(pai, "Hist\u00f3rico de cota\u00e7\u00e3o " + descricaoMaterial);
        this.carregaDados(codigoMaterial, cotacaoAtual);
        this.montaTela();
    }

    private void montaTela() {
        this.setModal(true);
        this.setSize(750, 350);
        this.setResizable(false);
        JPanel panelCentral = this.getPanelCentral();
        panelCentral.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 1;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 1.0;
        c.weighty = 1.0;
        panelCentral.add((Component)new JScrollPane(this.tabela), c);
        this.modelo.setColumnSize(new int[]{0, 130, 100}, this.tabela);
        this.buttonCancelar.setVisible(false);
        this.buttonOK.setText("Fechar");
        this.buttonOK.setMnemonic('F');
        ScreenUtil.centralizar(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void carregaDados(String codigoMaterial, String cotacaoAtual) {
        Statement st = Conexao.getStatement();
        StringBuilder buf = new StringBuilder("select c.ent_fantasia, a.cme_valorunitario, b.cot_datahora ");
        buf.append(" from cotacaomaterialentidade a ");
        buf.append(" left join cotacao b on a.fil_codigo = b.fil_codigo and a.cot_codigo = b.cot_codigo ");
        buf.append(" left join entidade c on b.fil_codigo = c.fil_codigo and a.ent_codigo = c.ent_codigo ");
        buf.append(" where a.fil_codigo = ").append(Variaveis.filialPadrao);
        buf.append("   and a.mat_codigo = ").append(codigoMaterial);
        buf.append("   and a.cot_codigo <> ").append(cotacaoAtual);
        buf.append(" order by b.cot_datahora, c.ent_fantasia ");
        try {
            ResultSet rs = Conexao.executeQuery(st, buf);
            while (rs.next()) {
                this.modelo.addLine(new String[]{rs.getString("ent_fantasia"), Funcoes.formataData("dd/MM/yyyy HH:mm:ss", rs.getTimestamp("cot_datahora")), Funcoes.formataDecimal(rs.getDouble("cme_valorunitario"), 2)});
            }
        }
        catch (Exception e) {
            try {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "FinalizarCotacao (1308)");
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
    }
}

