/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.estoque.cotacao;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadrao;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.util.FinanceiroUtil;
import jalis.model.AbstractThreadBean;
import jalis.model.bean.estoque.CotacaoBean;
import jalis.model.bean.estoque.CotacaoEntidadeBean;
import jalis.model.bean.estoque.CotacaoEntidadeParcelaBean;
import jalis.model.bean.estoque.CotacaoMaterialBean;
import jalis.model.bean.estoque.CotacaoMaterialEntidadeBean;
import jalis.model.bean.financeiro.ReceberPagarBean;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.financeiro.FormaPagamentoVO;
import jalis.model.vo.estoque.CotacaoVO;
import jalis.model.vo.estoque.MaterialVO;
import jalis.service.cadastro.financeiro.FormaPagamentoParcelaService;
import jalis.service.cadastro.financeiro.FormaPagamentoService;
import jalis.service.estoque.CotacaoService;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.SplashMensagem;
import jalis.util.TTextAreaDocument;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class IncluirPrecos
extends FrmCadPadrao {
    private JButton buttonBuscaCotacao = new JButton();
    private JButton buttonOk = new JButton("OK");
    private JButton buttonInformacoes = new JButton("Informa\u00e7\u00f5es");
    private JLabel labelAux1 = new JLabel();
    private JLabel labelAux2 = new JLabel();
    private JLabel labelAux3 = new JLabel();
    private JLabel labelAux5 = new JLabel();
    private JLabel labelData = new JLabel("Data:");
    private JLabel labelSituacaoCot = new JLabel("Situa\u00e7\u00e3o:");
    private JLabel labelMaterial = new JLabel("Material:");
    private JLabel labelQuantidade = new JLabel("   Qtde.:");
    private JLabel labelUnidade = new JLabel("   Unid.:");
    private JLabel labelUnitario = new JLabel("Vl. Unit.:");
    private JLabel labelDesconto = new JLabel("  Desconto:");
    private JLabel labelTotal = new JLabel("  Total:");
    private JLabel labelUsuario = new JLabel("Usu\u00e1rio:");
    private JLabel labelCotacao = new JLabel("Cota\u00e7\u00e3o:");
    private JLabel labelTotalFornecedor = new JLabel("Total:");
    private JLabel labelSituacao = new JLabel("  Situa\u00e7\u00e3o:");
    private JLabel labelVlrData = new JLabel();
    private JLabel labelVlrUnidade = new JLabel();
    private JLabel labelVlrUsuario = new JLabel();
    private JLabel labelVlrSituacaoCot = new JLabel();
    private JLabel labelVlrTotalFornecedor = new JLabel();
    private JLabel labelCodMaterial = new JLabel();
    private JLabel labelMateriais = new JLabel();
    private JLabel labelVlrTotal = new JLabel();
    private JPanel panelCabecalho = new JPanel(new GridBagLayout());
    private JPanel panelObservacao = new JPanel(new GridBagLayout());
    private JPanel panelMateriais = new JPanel(new GridBagLayout());
    private JPanel panelFornecedores = new JPanel(new GridBagLayout());
    private JScrollPane scrollMateriais;
    private JScrollPane scrollFornecedores;
    private JScrollPane scrollObservacao;
    private TTextField textCotacao = new TTextField(8, 1);
    private TTextField textUnitario = new TTextField(10, 2, 4);
    private TTextField textDesconto = new TTextField(10, 2);
    private TTextField textVlrQuantidade = new TTextField(10, 2);
    private JTextArea textObservacao = new JTextArea(new TTextAreaDocument(500));
    private JComboBox comboSituacao = new JComboBox<String>(new String[]{"N\u00e3o configurado", "N\u00e3o encontrado", "N\u00e3o vende", "Sem estoque", "Pre\u00e7o OK"});
    private JComboBox comboDesconto = new JComboBox<String>(new String[]{"$", "%"});
    private ModeloGridTable modeloMateriais;
    private ModeloGridTable modeloFornecedores;
    private JTable tableMateriais;
    private JTable tableFornecedores;
    private CotacaoBean cotacaoAux = null;
    private ArrayList<CotacaoMaterialEntidadeBean> listaMateriaisFornecedores = null;
    private CotacaoMaterialEntidadeBean cotMatEntAux = null;
    private CotacaoEntidadeBean cotEntAux = null;
    private final int CASAS = ParametrosGerais.getCasasPrecoExame();
    private final int CASAS_MAIOR = 4;
    private final RoundingMode ROUND = ParametrosGerais.getArredondamentoPrecoExame();

    public IncluirPrecos() {
        this.listaMateriaisFornecedores = new ArrayList();
        Funcoes.criaBarraDescricao(this, "Incluir Pre\u00e7os", "Inclus\u00e3o de pre\u00e7os dos materiais para os fornecedores da cota\u00e7\u00e3o", "estoque/incluir_precos.jpg");
        ScreenUtil.setBorda(new Component[]{this.labelVlrUsuario, this.labelVlrData, this.labelCodMaterial, this.labelVlrUnidade, this.labelMateriais, this.labelVlrTotalFornecedor, this.labelVlrTotal, this.labelVlrSituacaoCot}, new TitledBorder(""));
        this.botaoExcluir.setVisible(false);
        Funcoes.imagemPesquisa(this.buttonBuscaCotacao);
        this.painelBotoes.removeAll();
        this.painelBotoes.add(this.botaoNovo);
        this.painelBotoes.add(this.botaoSalvar);
        this.painelBotoes.add(this.botaoCancelar);
        this.painelBotoes.add(this.botaoFechar);
        this.painelCentral.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.labelCotacao.setLabelFor(this.textCotacao);
        this.labelCotacao.setDisplayedMnemonic('o');
        this.panelCabecalho.add((Component)this.labelCotacao, gridBagConstraints);
        this.textCotacao.setMinimumSize(new Dimension(60, 20));
        this.textCotacao.setPreferredSize(new Dimension(60, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.panelCabecalho.add((Component)this.textCotacao, gridBagConstraints);
        this.buttonBuscaCotacao.setFocusable(false);
        this.buttonBuscaCotacao.setMinimumSize(new Dimension(20, 20));
        this.buttonBuscaCotacao.setPreferredSize(new Dimension(20, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.panelCabecalho.add((Component)this.buttonBuscaCotacao, gridBagConstraints);
        this.labelAux3.setMinimumSize(new Dimension(20, 20));
        this.labelAux3.setPreferredSize(new Dimension(20, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.panelCabecalho.add((Component)this.labelAux3, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        this.panelCabecalho.add((Component)this.labelUsuario, gridBagConstraints);
        this.labelVlrUsuario.setMinimumSize(new Dimension(90, 20));
        this.labelVlrUsuario.setPreferredSize(new Dimension(90, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.panelCabecalho.add((Component)this.labelVlrUsuario, gridBagConstraints);
        this.labelAux1.setMinimumSize(new Dimension(20, 20));
        this.labelAux1.setPreferredSize(new Dimension(20, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.panelCabecalho.add((Component)this.labelAux1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.panelCabecalho.add((Component)this.labelData, gridBagConstraints);
        this.labelVlrData.setMinimumSize(new Dimension(150, 20));
        this.labelVlrData.setPreferredSize(new Dimension(150, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.panelCabecalho.add((Component)this.labelVlrData, gridBagConstraints);
        this.labelAux5.setMinimumSize(new Dimension(20, 20));
        this.labelAux5.setPreferredSize(new Dimension(20, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.panelCabecalho.add((Component)this.labelAux5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.panelCabecalho.add((Component)this.labelSituacaoCot, gridBagConstraints);
        this.labelVlrSituacaoCot.setMinimumSize(new Dimension(80, 20));
        this.labelVlrSituacaoCot.setPreferredSize(new Dimension(80, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.panelCabecalho.add((Component)this.labelVlrSituacaoCot, gridBagConstraints);
        this.labelAux2.setMinimumSize(new Dimension(20, 20));
        this.labelAux2.setPreferredSize(new Dimension(20, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.panelCabecalho.add((Component)this.labelAux2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 2, 1);
        this.painelCentral.add((Component)this.panelCabecalho, gridBagConstraints);
        JPanel panelInfoMaterial = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        this.labelUnitario.setDisplayedMnemonic('U');
        this.labelUnitario.setLabelFor(this.textUnitario);
        panelInfoMaterial.add((Component)this.labelUnitario, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        this.textUnitario.setPreferredSize(new Dimension(70, 20));
        this.textUnitario.setMinimumSize(new Dimension(70, 20));
        panelInfoMaterial.add((Component)this.textUnitario, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        this.labelDesconto.setDisplayedMnemonic('t');
        this.labelDesconto.setLabelFor(this.textDesconto);
        panelInfoMaterial.add((Component)this.labelDesconto, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        this.textDesconto.setPreferredSize(new Dimension(70, 20));
        this.textDesconto.setMinimumSize(new Dimension(70, 20));
        panelInfoMaterial.add((Component)this.textDesconto, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        this.comboDesconto.setPreferredSize(new Dimension(40, 20));
        this.comboDesconto.setMinimumSize(new Dimension(40, 20));
        panelInfoMaterial.add((Component)this.comboDesconto, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        panelInfoMaterial.add((Component)this.labelTotal, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        this.labelVlrTotal.setPreferredSize(new Dimension(70, 20));
        this.labelVlrTotal.setMinimumSize(new Dimension(70, 20));
        panelInfoMaterial.add((Component)this.labelVlrTotal, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        this.labelSituacao.setDisplayedMnemonic('S');
        this.labelSituacao.setLabelFor(this.comboSituacao);
        panelInfoMaterial.add((Component)this.labelSituacao, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        this.comboSituacao.setPreferredSize(new Dimension(127, 20));
        this.comboSituacao.setMinimumSize(new Dimension(127, 20));
        this.comboSituacao.setEditable(false);
        panelInfoMaterial.add((Component)this.comboSituacao, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        this.buttonOk.setPreferredSize(new Dimension(40, 20));
        this.buttonOk.setMinimumSize(new Dimension(40, 20));
        this.buttonOk.setMargin(new Insets(1, 1, 1, 1));
        this.buttonOk.setMnemonic('O');
        panelInfoMaterial.add((Component)this.buttonOk, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        panelInfoMaterial.add((Component)new JLabel(), gridBagConstraints);
        this.labelVlrTotal.setHorizontalAlignment(4);
        this.labelVlrTotalFornecedor.setHorizontalAlignment(4);
        FocusAdapter foco = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                IncluirPrecos.this.calculaTotalMaterial();
            }

            @Override
            public void focusGained(FocusEvent e) {
                ((TTextField)e.getSource()).selectAll();
            }
        };
        this.textVlrQuantidade.addFocusListener(foco);
        this.textUnitario.addFocusListener(foco);
        this.textDesconto.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                IncluirPrecos.this.calculaTotalMaterial();
                ScreenUtil.requisitarFoco(IncluirPrecos.this.comboDesconto);
            }
        });
        this.comboDesconto.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                IncluirPrecos.this.calculaTotalMaterial();
            }
        });
        this.buttonInformacoes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IncluirPrecos.this.atualizarFornecedor(IncluirPrecos.this.cotEntAux);
                IncluirPrecos.this.cotEntAux.setValorTotal(IncluirPrecos.this.calculaTotalFornecedor(IncluirPrecos.this.cotEntAux));
                DialogInformacoesFornecedores diag = new DialogInformacoesFornecedores(Laboratorio.getInstancia(), IncluirPrecos.this.cotEntAux);
                IncluirPrecos.this.cotEntAux = diag.getDados();
                IncluirPrecos.this.atualizarFornecedor(IncluirPrecos.this.cotEntAux);
                IncluirPrecos.this.calculaTotalFornecedor(IncluirPrecos.this.cotEntAux);
            }
        });
        this.buttonOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                double valorMaximo;
                if (!IncluirPrecos.this.isDescontoValido()) {
                    Funcoes.mensagem(IncluirPrecos.this, "O valor do desconto n\u00e3o pode ser maior que o valor total.", 2);
                    ScreenUtil.requisitarFoco(IncluirPrecos.this.textDesconto);
                    return;
                }
                double valorCampo = Double.parseDouble(Funcoes.limpaDecimal(IncluirPrecos.this.labelVlrTotal.getText()));
                if (valorCampo > (valorMaximo = Double.valueOf("9999999999.99999").doubleValue())) {
                    Funcoes.mensagem(IncluirPrecos.this, "O valor total excede o valor m\u00e1ximo permitido.", 2);
                    ScreenUtil.requisitarFoco(IncluirPrecos.this.textUnitario);
                    return;
                }
                if (IncluirPrecos.this.cotMatEntAux != null) {
                    BigDecimal qtde = new BigDecimal(Funcoes.limpaDecimal(IncluirPrecos.this.textVlrQuantidade.getText().isEmpty() ? "0" : IncluirPrecos.this.textVlrQuantidade.getText())).setScale(4, IncluirPrecos.this.ROUND);
                    BigDecimal valor = new BigDecimal(Funcoes.limpaDecimal(IncluirPrecos.this.textUnitario.getText().isEmpty() ? "0" : IncluirPrecos.this.textUnitario.getText())).setScale(4, IncluirPrecos.this.ROUND);
                    IncluirPrecos.this.cotMatEntAux.setQuantidade(qtde.doubleValue());
                    IncluirPrecos.this.cotMatEntAux.setValorUnitario(valor.doubleValue());
                    if (IncluirPrecos.this.comboDesconto.getSelectedItem().toString().equalsIgnoreCase("%")) {
                        BigDecimal perc = new BigDecimal(Funcoes.limpaDecimal(IncluirPrecos.this.textDesconto.getText().isEmpty() ? "0" : IncluirPrecos.this.textDesconto.getText())).setScale(4, IncluirPrecos.this.ROUND);
                        IncluirPrecos.this.cotMatEntAux.setPercentualDesconto(perc.doubleValue());
                        IncluirPrecos.this.cotMatEntAux.setValorDesconto(valor.multiply(qtde).multiply(perc).divide(new BigDecimal("100").setScale(4, IncluirPrecos.this.ROUND), IncluirPrecos.this.ROUND).doubleValue());
                    } else {
                        BigDecimal desc = new BigDecimal(Funcoes.limpaDecimal(IncluirPrecos.this.textDesconto.getText().isEmpty() ? "0" : IncluirPrecos.this.textDesconto.getText())).setScale(4, IncluirPrecos.this.ROUND);
                        BigDecimal aux = valor.multiply(qtde);
                        IncluirPrecos.this.cotMatEntAux.setValorDesconto(desc.doubleValue());
                        if (aux.doubleValue() > 0.0) {
                            IncluirPrecos.this.cotMatEntAux.setPercentualDesconto(desc.multiply(new BigDecimal("100").setScale(4, IncluirPrecos.this.ROUND)).divide(aux, IncluirPrecos.this.ROUND).doubleValue());
                        }
                    }
                    IncluirPrecos.this.cotMatEntAux.setTipoDesconto(IncluirPrecos.this.comboDesconto.getSelectedItem().toString());
                    IncluirPrecos.this.cotMatEntAux.setValorTotal(Double.parseDouble(Funcoes.limpaDecimal(IncluirPrecos.this.labelVlrTotal.getText())));
                    IncluirPrecos.this.cotMatEntAux.setSituacao(Tipos.getSituacaoMaterialFornecedor(IncluirPrecos.this.comboSituacao.getSelectedItem().toString()));
                    IncluirPrecos.this.atualizarMaterialFornecedor(IncluirPrecos.this.cotMatEntAux);
                    IncluirPrecos.this.calculaTotalFornecedor(IncluirPrecos.this.cotEntAux);
                    IncluirPrecos.this.limparInfoMaterial();
                }
            }
        });
        this.textCotacao.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!IncluirPrecos.this.textCotacao.getText().isEmpty()) {
                    CotacaoBean bean = null;
                    try {
                        SplashMensagem janelaEspera = SplashMensagem.getInstancia(IncluirPrecos.this);
                        janelaEspera.mostrar("Carregando cota\u00e7\u00e3o");
                        bean = (CotacaoBean)new CotacaoService().get(Variaveis.filialPadrao, IncluirPrecos.this.textCotacao.getText());
                        janelaEspera.apagar();
                    }
                    catch (Exception e1) {
                        Funcoes.mensagem(IncluirPrecos.this, "N\u00e3o foi poss\u00edvel carregar a cota\u00e7\u00e3o.", 2);
                    }
                    if (bean != null) {
                        if (!bean.getSituacao().equalsIgnoreCase("A")) {
                            Funcoes.mensagem(IncluirPrecos.this, "A situa\u00e7\u00e3o da cota\u00e7\u00e3o deve ser \"ABERTA\".", 2);
                            IncluirPrecos.this.textCotacao.setText("");
                            if (IncluirPrecos.this.textCotacao.isFocusable() && IncluirPrecos.this.textCotacao.isEnabled()) {
                                IncluirPrecos.this.textCotacao.grabFocus();
                            }
                            return;
                        }
                        IncluirPrecos.this.preencherCampos(bean);
                        IncluirPrecos.this.setStatus(1);
                        if (bean.getSituacao() != null && bean.getSituacao().equalsIgnoreCase("A")) {
                            IncluirPrecos.this.setStatus(3);
                        }
                    } else {
                        Funcoes.mensagem(IncluirPrecos.this, "Cota\u00e7\u00e3o n\u00e3o encontrada.", 2);
                        IncluirPrecos.this.textCotacao.setText("");
                        if (IncluirPrecos.this.textCotacao.isFocusable() && IncluirPrecos.this.textCotacao.isEnabled()) {
                            IncluirPrecos.this.textCotacao.grabFocus();
                        }
                    }
                    IncluirPrecos.this.controlaCampos();
                }
            }
        });
        this.buttonBuscaCotacao.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IncluirPrecos.this.limparCampos();
                CotacaoBean bean = (CotacaoBean)IncluirPrecos.this.pesquisar();
                if (bean != null) {
                    IncluirPrecos.this.preencherCampos(bean);
                    IncluirPrecos.this.setStatus(1);
                    if (bean.getSituacao() != null && bean.getSituacao().equalsIgnoreCase("A")) {
                        IncluirPrecos.this.setStatus(3);
                    }
                }
                IncluirPrecos.this.controlaCampos();
            }
        });
        this.panelMateriais.setBorder(BorderFactory.createTitledBorder("Materiais"));
        this.panelFornecedores.setBorder(BorderFactory.createTitledBorder("Fornecedores"));
        this.modeloMateriais = new ModeloGridTable(new String[]{"C\u00f3digo", "Material", "Qtde.", "Unid.", "Unit\u00e1rio", "Desconto", "% Desc.", "Total", "Situa\u00e7\u00e3o", "Objeto"}){

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public void fireTableStructureChanged() {
                super.fireTableStructureChanged();
                try {
                    if (IncluirPrecos.this.tableMateriais != null) {
                        IncluirPrecos.this.tableMateriais.removeColumn(IncluirPrecos.this.tableMateriais.getColumn("Objeto"));
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                try {
                    IncluirPrecos.this.tableMateriais.removeColumn(IncluirPrecos.this.tableMateriais.getColumn("Objeto"));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        };
        this.modeloFornecedores = new ModeloGridTable(new String[]{"C\u00f3digo", "Fantasia", "Vendedor", "Forma Pgto.", "Pzo. Entrega", "Objeto"}){

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                Object[] classes = new Object[]{Integer.class, String.class, String.class, String.class, String.class, CotacaoEntidadeBean.class};
                return (Class)classes[columnIndex];
            }

            @Override
            public void fireTableStructureChanged() {
                super.fireTableStructureChanged();
                try {
                    if (IncluirPrecos.this.tableFornecedores != null) {
                        IncluirPrecos.this.tableFornecedores.removeColumn(IncluirPrecos.this.tableFornecedores.getColumn("Objeto"));
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                try {
                    IncluirPrecos.this.tableFornecedores.removeColumn(IncluirPrecos.this.tableFornecedores.getColumn("Objeto"));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        };
        this.tableMateriais = new JTable(this.modeloMateriais);
        this.tableMateriais.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
            }
        });
        this.tableMateriais.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (IncluirPrecos.this.getStatus() == 2 || IncluirPrecos.this.getStatus() == 3) {
                    if (e.getClickCount() == 2) {
                        IncluirPrecos.this.alterarMaterial();
                    } else if (e.getClickCount() == 1) {
                        IncluirPrecos.this.limparInfoMaterial();
                    }
                }
            }
        });
        this.tableMateriais.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if ((IncluirPrecos.this.getStatus() == 2 || IncluirPrecos.this.getStatus() == 3) && e.getKeyCode() == 32) {
                    IncluirPrecos.this.alterarMaterial();
                }
            }
        });
        this.modeloMateriais.setColumnSize(new int[]{60, 0, 60, 50, 70, 75, 65, 70, 70, 0}, this.tableMateriais);
        this.tableMateriais.getTableHeader().addMouseListener(this.modeloMateriais);
        this.tableMateriais.removeColumn(this.tableMateriais.getColumn("Objeto"));
        this.scrollMateriais = new JScrollPane(this.tableMateriais);
        this.tableFornecedores = new JTable(this.modeloFornecedores);
        this.tableFornecedores.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (IncluirPrecos.this.modeloFornecedores.getRowCount() > 0 && IncluirPrecos.this.tableFornecedores.getSelectedRow() >= 0) {
                    CotacaoEntidadeBean cotEntidade = (CotacaoEntidadeBean)IncluirPrecos.this.modeloFornecedores.getValueAt(IncluirPrecos.this.tableFornecedores.getSelectedRow(), IncluirPrecos.this.modeloFornecedores.findColumn("Objeto"));
                    IncluirPrecos.this.mostrarMateriaisFornecedor(cotEntidade);
                    IncluirPrecos.this.cotEntAux = cotEntidade;
                    IncluirPrecos.this.calculaTotalFornecedor(IncluirPrecos.this.cotEntAux);
                    IncluirPrecos.this.controlaCampos();
                }
            }
        });
        this.tableFornecedores.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (IncluirPrecos.this.modeloFornecedores.getRowCount() > 0 && IncluirPrecos.this.tableFornecedores.getSelectedRow() >= 0) {
                    CotacaoEntidadeBean cotEntidade = (CotacaoEntidadeBean)IncluirPrecos.this.modeloFornecedores.getValueAt(IncluirPrecos.this.tableFornecedores.getSelectedRow(), IncluirPrecos.this.modeloFornecedores.findColumn("Objeto"));
                    IncluirPrecos.this.mostrarMateriaisFornecedor(cotEntidade);
                    IncluirPrecos.this.cotEntAux = cotEntidade;
                    IncluirPrecos.this.calculaTotalFornecedor(IncluirPrecos.this.cotEntAux);
                    IncluirPrecos.this.controlaCampos();
                }
            }
        });
        this.modeloFornecedores.setColumnSize(new int[]{70, 0, 120, 100, 100, 0}, this.tableFornecedores);
        this.tableFornecedores.getTableHeader().addMouseListener(this.modeloFornecedores);
        this.tableFornecedores.removeColumn(this.tableFornecedores.getColumn("Objeto"));
        this.scrollFornecedores = new JScrollPane(this.tableFornecedores);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 9;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(2, 1, 1, 1);
        this.panelMateriais.add((Component)panelInfoMaterial, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 9;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 1, 1, 1);
        this.panelMateriais.add((Component)this.scrollMateriais, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.panelMateriais.add((Component)this.labelMaterial, gridBagConstraints);
        this.labelCodMaterial.setHorizontalAlignment(4);
        this.labelCodMaterial.setMinimumSize(new Dimension(60, 20));
        this.labelCodMaterial.setPreferredSize(new Dimension(60, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.panelMateriais.add((Component)this.labelCodMaterial, gridBagConstraints);
        this.labelMateriais.setMinimumSize(new Dimension(200, 20));
        this.labelMateriais.setPreferredSize(new Dimension(200, 20));
        this.labelMateriais.setRequestFocusEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.panelMateriais.add((Component)this.labelMateriais, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.labelQuantidade.setDisplayedMnemonic('Q');
        this.labelQuantidade.setLabelFor(this.textVlrQuantidade);
        this.panelMateriais.add((Component)this.labelQuantidade, gridBagConstraints);
        this.textVlrQuantidade.setMinimumSize(new Dimension(50, 20));
        this.textVlrQuantidade.setPreferredSize(new Dimension(50, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.panelMateriais.add((Component)this.textVlrQuantidade, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.panelMateriais.add((Component)this.labelUnidade, gridBagConstraints);
        this.labelVlrUnidade.setMinimumSize(new Dimension(50, 20));
        this.labelVlrUnidade.setPreferredSize(new Dimension(50, 20));
        this.panelMateriais.add((Component)this.labelVlrUnidade, new GridBagConstraints());
        JPanel panelTotal = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(2, 1, 1, 1);
        panelTotal.add((Component)new JLabel(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(2, 1, 1, 1);
        panelTotal.add((Component)this.labelTotalFornecedor, gridBagConstraints);
        this.labelVlrTotalFornecedor.setPreferredSize(new Dimension(90, 20));
        this.labelVlrTotalFornecedor.setMinimumSize(new Dimension(90, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(2, 1, 1, 1);
        panelTotal.add((Component)this.labelVlrTotalFornecedor, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 9;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.panelMateriais.add((Component)panelTotal, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.painelCentral.add((Component)this.panelMateriais, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 9;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 1, 1, 1);
        this.panelFornecedores.add((Component)this.scrollFornecedores, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(2, 1, 1, 1);
        this.buttonInformacoes.setMnemonic('I');
        this.panelFornecedores.add((Component)this.buttonInformacoes, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.8;
        this.painelCentral.add((Component)this.panelFornecedores, gridBagConstraints);
        this.panelObservacao.setBorder(BorderFactory.createTitledBorder("Observa\u00e7\u00e3o"));
        this.scrollObservacao = new JScrollPane(this.textObservacao);
        this.scrollObservacao.setMinimumSize(new Dimension(100, 50));
        this.scrollObservacao.setPreferredSize(new Dimension(100, 50));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.panelObservacao.add((Component)this.scrollObservacao, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.painelCentral.add((Component)this.panelObservacao, gridBagConstraints);
        Funcoes.defineUpperCase(this.painelCentral, ParametrosGerais.getUpperCase());
        this.controlaCampos();
    }

    private void atualizarFornecedor(CotacaoEntidadeBean cotEnt) {
        if (cotEnt == null) {
            return;
        }
        if (this.modeloFornecedores.getRowCount() > 0) {
            for (int i = 0; i < this.modeloFornecedores.getRowCount(); ++i) {
                CotacaoEntidadeBean cotEntModelo = (CotacaoEntidadeBean)this.modeloFornecedores.getValueAt(i, this.modeloFornecedores.findColumn("Objeto"));
                if (cotEntModelo == null || cotEntModelo.getEntidade() == null || cotEntModelo.getEntidade().getCodigo().intValue() != cotEnt.getEntidade().getCodigo().intValue()) continue;
                this.modeloFornecedores.removeLine(i);
                this.adicionarFornecedor(cotEnt);
                this.tableFornecedores.getSelectionModel().setSelectionInterval(i, i);
                break;
            }
        }
    }

    private void atualizarMaterialFornecedor(CotacaoMaterialEntidadeBean cotMatEnt) {
        if (cotMatEnt == null) {
            return;
        }
        if (this.modeloMateriais.getRowCount() > 0) {
            for (int i = 0; i < this.modeloMateriais.getRowCount(); ++i) {
                CotacaoMaterialEntidadeBean cotMatEntModelo = (CotacaoMaterialEntidadeBean)this.modeloMateriais.getValueAt(i, this.modeloMateriais.findColumn("Objeto"));
                if (cotMatEntModelo == null || cotMatEntModelo.getCotacaoMaterial() == null || cotMatEntModelo.getCotacaoMaterial().getMaterial() == null || cotMatEntModelo.getCotacaoMaterial().getMaterial().getCodigo().intValue() != cotMatEnt.getCotacaoMaterial().getMaterial().getCodigo().intValue()) continue;
                this.modeloMateriais.removeLine(i);
                this.adicionarMaterial(cotMatEnt);
                break;
            }
        }
    }

    private boolean isDescontoValido() {
        Double valorSub = Double.parseDouble(Funcoes.limpaDecimal(this.textUnitario.getText())) * Double.parseDouble(Funcoes.limpaDecimal(this.textVlrQuantidade.getText()));
        Double valorDesconto = Double.valueOf(Funcoes.textoVazio(this.textDesconto.getText()) ? "0" : this.textDesconto.getText());
        return !(this.comboDesconto.getSelectedItem().equals("$") && valorDesconto > valorSub) && (!this.comboDesconto.getSelectedItem().equals("%") || !(valorDesconto > 100.0));
    }

    private void mostrarMateriaisFornecedor(CotacaoEntidadeBean cotEntidade) {
        if (cotEntidade != null) {
            if (cotEntidade.getEntidade() == null) {
                return;
            }
            this.modeloMateriais.clear();
            for (int i = 0; i < this.listaMateriaisFornecedores.size(); ++i) {
                CotacaoMaterialEntidadeBean cotMatEnt = this.listaMateriaisFornecedores.get(i);
                if (cotMatEnt == null || cotMatEnt.getCotacaoEntidade() == null || cotMatEnt.getCotacaoEntidade().getEntidade() == null || cotMatEnt.getCotacaoEntidade().getEntidade().getCodigo().intValue() != cotEntidade.getEntidade().getCodigo().intValue()) continue;
                this.adicionarMaterial(cotMatEnt);
            }
        }
    }

    private void limparInfoMaterial() {
        this.labelCodMaterial.setText("");
        this.labelMateriais.setText("");
        this.textVlrQuantidade.setText("");
        this.labelVlrUnidade.setText("");
        this.textUnitario.setText("");
        this.textDesconto.setText("");
        this.comboDesconto.setSelectedIndex(0);
        this.labelVlrTotal.setText("");
        this.comboSituacao.setSelectedItem("");
        this.cotMatEntAux = null;
        this.controlaCampos();
    }

    private Double calculaTotalFornecedor(CotacaoEntidadeBean entidade) {
        if (entidade != null && this.listaMateriaisFornecedores.size() > 0) {
            BigDecimal total = BigDecimal.ZERO.setScale(4, this.ROUND);
            for (int i = 0; i < this.listaMateriaisFornecedores.size(); ++i) {
                CotacaoMaterialEntidadeBean obj = this.listaMateriaisFornecedores.get(i);
                if (obj == null || obj.getCotacaoEntidade().getEntidade().getCodigo().intValue() != entidade.getEntidade().getCodigo().intValue()) continue;
                total = total.add(new BigDecimal(obj.getValorTotal() == null ? "0" : obj.getValorTotal().toString()).setScale(4, this.ROUND));
            }
            if (entidade.getTipoDesconto() != null) {
                if (entidade.getTipoDesconto().equalsIgnoreCase("$")) {
                    if (entidade.getValorDesconto() != null) {
                        total = total.subtract(new BigDecimal(entidade.getValorDesconto().toString()).setScale(4, this.ROUND));
                    }
                } else if (entidade.getPercentualDesconto() != null) {
                    total = total.subtract(total.multiply(new BigDecimal(entidade.getPercentualDesconto().toString()).setScale(4, this.ROUND)).divide(new BigDecimal("100").setScale(4, this.ROUND), this.ROUND));
                }
            }
            total = total.add(new BigDecimal(entidade.getValorFrete().toString()).setScale(4, this.ROUND));
            this.labelVlrTotalFornecedor.setText(Funcoes.formataDecimal(total.doubleValue()));
            return total.doubleValue();
        }
        return 0.0;
    }

    private void calculaTotalMaterial() {
        BigDecimal qtde = new BigDecimal(this.textVlrQuantidade.getText().isEmpty() ? "0" : Funcoes.limpaDecimal(this.textVlrQuantidade.getText())).setScale(4, this.ROUND);
        BigDecimal valor = new BigDecimal(this.textUnitario.getText().isEmpty() ? "0" : Funcoes.limpaDecimal(this.textUnitario.getText())).setScale(4, this.ROUND);
        BigDecimal desc = null;
        if (this.comboDesconto.getSelectedItem().toString().equalsIgnoreCase("%")) {
            BigDecimal perc = new BigDecimal(this.textDesconto.getText().isEmpty() ? "0" : Funcoes.limpaDecimal(this.textDesconto.getText())).setScale(4, this.ROUND);
            desc = valor.multiply(qtde).multiply(perc).divide(new BigDecimal("100").setScale(4, this.ROUND), this.ROUND);
        } else {
            desc = new BigDecimal(this.textDesconto.getText().isEmpty() ? "0" : Funcoes.limpaDecimal(this.textDesconto.getText())).setScale(4, this.ROUND);
        }
        BigDecimal valorTotal = valor.multiply(qtde).subtract(desc);
        if (valorTotal.doubleValue() < 0.0) {
            valorTotal = BigDecimal.ZERO;
        }
        this.labelVlrTotal.setText(Funcoes.formataDecimal("#,##0.00##", valorTotal.doubleValue()));
    }

    private void alterarMaterial() {
        CotacaoMaterialEntidadeBean cotacaoMaterialEntidade;
        if (this.modeloMateriais.getRowCount() > 0 && this.tableMateriais.getSelectedRow() >= 0 && (cotacaoMaterialEntidade = (CotacaoMaterialEntidadeBean)this.modeloMateriais.getValueAt(this.tableMateriais.getSelectedRow(), this.modeloMateriais.findColumn("Objeto"))) != null) {
            this.cotMatEntAux = cotacaoMaterialEntidade;
            this.labelCodMaterial.setText(String.valueOf(cotacaoMaterialEntidade.getCotacaoMaterial().getMaterial().getCodigo()));
            this.labelMateriais.setText(cotacaoMaterialEntidade.getCotacaoMaterial().getMaterial().getDescricao());
            if (cotacaoMaterialEntidade.getQuantidade() == null || cotacaoMaterialEntidade.getQuantidade() == 0.0 && cotacaoMaterialEntidade.getSituacao().equalsIgnoreCase("C")) {
                if (this.cotacaoAux != null && this.cotacaoAux.getMateriaisCotacao() != null) {
                    Double valor = 0.0;
                    for (CotacaoMaterialBean aux : this.cotacaoAux.getMateriaisCotacao()) {
                        if (aux.getMaterial().getCodigo().intValue() != this.cotMatEntAux.getCotacaoMaterial().getMaterial().getCodigo().intValue()) continue;
                        valor = this.cotMatEntAux.getCotacaoMaterial().getQuantidade();
                        break;
                    }
                    this.textVlrQuantidade.setText(Funcoes.formataDecimal(valor == null ? 0.0 : valor));
                }
            } else {
                this.textVlrQuantidade.setText(Funcoes.formataDecimal(cotacaoMaterialEntidade.getQuantidade()));
            }
            this.labelVlrUnidade.setText(cotacaoMaterialEntidade.getCotacaoMaterial().getMaterial().getUnidadeMedida().getCodigo());
            this.textUnitario.setText(cotacaoMaterialEntidade.getValorUnitario() != null ? Funcoes.formataDecimal("#,##0.00##", cotacaoMaterialEntidade.getValorUnitario()) : Funcoes.formataDecimal(0.0));
            if (this.cotMatEntAux.getTipoDesconto() == null) {
                this.comboDesconto.setSelectedItem("$");
                this.textDesconto.setText(Funcoes.formataDecimal(0.0));
            } else if (this.cotMatEntAux.getTipoDesconto().equalsIgnoreCase("$")) {
                this.textDesconto.setText(cotacaoMaterialEntidade.getValorDesconto() != null ? Funcoes.formataDecimal(cotacaoMaterialEntidade.getValorDesconto()) : Funcoes.formataDecimal(0.0));
                this.comboDesconto.setSelectedItem("$");
            } else {
                this.textDesconto.setText(cotacaoMaterialEntidade.getPercentualDesconto() != null ? Funcoes.formataDecimal(cotacaoMaterialEntidade.getPercentualDesconto()) : Funcoes.formataDecimal(0.0));
                this.comboDesconto.setSelectedItem("%");
            }
            this.labelVlrTotal.setText(cotacaoMaterialEntidade.getValorTotal() != null ? Funcoes.formataDecimal("#,##0.00##", cotacaoMaterialEntidade.getValorTotal()) : Funcoes.formataDecimal(0.0));
            this.comboSituacao.setSelectedItem(cotacaoMaterialEntidade.getSituacao() == null ? "" : Tipos.situacaoMaterialFornecedor(cotacaoMaterialEntidade.getSituacao()));
            this.controlaCampos();
            if (this.textVlrQuantidade.isEnabled() && this.textVlrQuantidade.isFocusable()) {
                this.textVlrQuantidade.grabFocus();
            }
        }
    }

    @Override
    public void cancelar() {
        if (Funcoes.mensagem(this, "As informa\u00e7\u00f5es adicionadas ser\u00e3o perdidas.", 4) == 0) {
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    private void controlaCampos() {
        boolean habilitar = this.getStatus() == 2 || this.getStatus() == 3;
        this.textCotacao.setEnabled(habilitar && this.cotacaoAux == null);
        this.buttonBuscaCotacao.setEnabled(habilitar && this.cotacaoAux == null);
        this.buttonInformacoes.setEnabled(habilitar && this.cotEntAux != null);
        this.textVlrQuantidade.setEnabled(habilitar && this.cotMatEntAux != null);
        this.textUnitario.setEnabled(habilitar && this.cotMatEntAux != null);
        this.textDesconto.setEnabled(habilitar && this.cotMatEntAux != null);
        this.comboDesconto.setEnabled(habilitar && this.cotMatEntAux != null);
        this.labelVlrTotal.setEnabled(habilitar && this.cotMatEntAux != null);
        this.comboSituacao.setEnabled(habilitar && this.cotMatEntAux != null);
        this.buttonOk.setEnabled(habilitar && this.cotMatEntAux != null);
        this.textObservacao.setEnabled(habilitar);
    }

    public void limparCampos() {
        this.textCotacao.setText("");
        this.labelVlrUsuario.setText("");
        this.labelVlrData.setText("");
        this.labelCodMaterial.setText("");
        this.labelMateriais.setText("");
        this.textVlrQuantidade.setText("");
        this.labelVlrUnidade.setText("");
        this.textDesconto.setText("");
        this.comboDesconto.setSelectedIndex(0);
        this.labelVlrTotal.setText("");
        this.comboSituacao.setSelectedIndex(0);
        this.textObservacao.setText("");
        this.labelVlrTotalFornecedor.setText("");
        this.labelVlrSituacaoCot.setText("");
        this.modeloMateriais.clear();
        this.modeloFornecedores.clear();
        this.cotacaoAux = null;
        this.listaMateriaisFornecedores.clear();
        this.cotMatEntAux = null;
        this.cotEntAux = null;
    }

    @Override
    @Deprecated
    public void editar() {
    }

    private void preencherCampos(CotacaoBean cotacao) {
        if (cotacao != null) {
            this.cotacaoAux = cotacao;
            this.textCotacao.setText(String.valueOf(cotacao.getCodigo()));
            this.labelVlrUsuario.setText(cotacao.getUsuario().getCodigo());
            this.labelVlrSituacaoCot.setText(Tipos.tipoCotacao(cotacao.getSituacao()));
            this.labelVlrData.setText(Funcoes.formataData("dd/MM/yyyy HH:mm:ss", cotacao.getDataHora()));
            this.textObservacao.setText(cotacao.getObservacao());
            if (cotacao.getEntidadesCotacao() != null) {
                Set<CotacaoEntidadeBean> entidades = cotacao.getEntidadesCotacao();
                for (CotacaoEntidadeBean entidade : entidades) {
                    this.adicionarFornecedor(entidade);
                }
            }
            HashSet set = (HashSet)cotacao.getMaterialEntidadeCotacao();
            Iterator<CotacaoEntidadeBean> it = set.iterator();
            int i = 0;
            while (it.hasNext()) {
                CotacaoMaterialEntidadeBean bean = (CotacaoMaterialEntidadeBean)((Object)it.next());
                this.adicionarMaterialFornecedor(bean);
                ++i;
            }
            this.calculaTotalFornecedor(this.cotEntAux);
        }
        this.controlaCampos();
    }

    private void adicionarMaterial(CotacaoMaterialEntidadeBean cotMatEnt) {
        if (cotMatEnt != null) {
            MaterialVO material = cotMatEnt.getCotacaoMaterial().getMaterial();
            for (int i = 0; i < this.modeloMateriais.getRowCount(); ++i) {
                if (material.getCodigo().intValue() != ((Integer)this.modeloMateriais.getValueAt(i, this.modeloMateriais.findColumn("C\u00f3digo"))).intValue()) continue;
                return;
            }
            this.modeloMateriais.addLine(new Object[]{material.getCodigo(), material.getDescricao(), Funcoes.formataDecimal(cotMatEnt.getQuantidade() == null ? cotMatEnt.getCotacaoMaterial().getQuantidade() : cotMatEnt.getQuantidade()), material.getUnidadeMedida().getCodigo(), cotMatEnt.getValorUnitario() == null ? "" : Funcoes.formataDecimal("#,##0.00##", cotMatEnt.getValorUnitario()), cotMatEnt.getValorDesconto() == null ? "" : Funcoes.formataDecimal(cotMatEnt.getValorDesconto()), cotMatEnt.getPercentualDesconto() == null ? "" : Funcoes.formataDecimal(cotMatEnt.getPercentualDesconto()), cotMatEnt.getValorTotal() == null ? "" : Funcoes.formataDecimal("#,##0.00##", cotMatEnt.getValorTotal()), cotMatEnt.getSituacao() == null ? "" : Tipos.situacaoMaterialFornecedor(cotMatEnt.getSituacao()), cotMatEnt});
            if (this.modeloMateriais.getColunaOrdenacao() != -1) {
                this.modeloMateriais.ordenarColunaSemTrocarSentido(this.modeloMateriais.getColunaOrdenacao());
            } else {
                this.modeloMateriais.ordenarColunaSemTrocarSentido(this.modeloMateriais.findColumn("Material"));
            }
        }
        this.controlaCampos();
    }

    private void adicionarMaterialFornecedor(CotacaoMaterialEntidadeBean cotMaterialEntidade) {
        if (cotMaterialEntidade != null) {
            this.listaMateriaisFornecedores.add(cotMaterialEntidade);
        }
    }

    private void adicionarFornecedor(CotacaoEntidadeBean bean) {
        if (bean != null) {
            for (int i = 0; i < this.modeloFornecedores.getRowCount(); ++i) {
                if (bean.getEntidade().getCodigo().intValue() != ((Integer)this.modeloFornecedores.getValueAt(i, this.modeloFornecedores.findColumn("C\u00f3digo"))).intValue()) continue;
                return;
            }
            this.modeloFornecedores.addLine(new Object[]{bean.getEntidade().getCodigo(), bean.getEntidade().getFantasia(), bean.getVendedor(), bean.getFormaPagamento() == null ? "" : bean.getFormaPagamento().getDescricao(), bean.getPrazoEntrega(), bean});
            if (this.modeloFornecedores.getColunaOrdenacao() != -1) {
                this.modeloFornecedores.ordenarColunaSemTrocarSentido(this.modeloFornecedores.getColunaOrdenacao());
            } else {
                this.modeloFornecedores.ordenarColunaSemTrocarSentido(this.modeloFornecedores.findColumn("Fantasia"));
            }
        }
    }

    private AbstractThreadBean pesquisar() {
        CotacaoService service = new CotacaoService();
        try {
            AbstractThreadVO vo = service.pesquisaVO((Object)this.getTopLevelAncestor(), (AbstractThreadVO)new CotacaoVO(), "Pesquisando Cota\u00e7\u00f5es", new String[]{"A"});
            if (vo != null) {
                SplashMensagem janelaEspera = SplashMensagem.getInstancia(this);
                janelaEspera.mostrar("Carregando cota\u00e7\u00e3o");
                CotacaoBean cotacaoBean = (CotacaoBean)service.get(String.valueOf(((CotacaoVO)vo).getFilial().getCodigo()), String.valueOf(((CotacaoVO)vo).getCodigo()));
                janelaEspera.apagar();
                return cotacaoBean;
            }
        }
        catch (Exception e) {
            Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel carregar dados da cota\u00e7\u00e3o.", 2);
        }
        return null;
    }

    @Override
    @Deprecated
    public void excluir() {
    }

    @Override
    public void fechar() {
        if (this.getStatus() == 1 || Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setVisible(false);
        }
    }

    @Override
    public void novo() {
        this.limparCampos();
        this.setStatus(2);
        this.controlaCampos();
        if (this.textCotacao.isEnabled() && this.textCotacao.isFocusable()) {
            this.textCotacao.grabFocus();
        }
    }

    protected String getCopiaFiliais() {
        return null;
    }

    @Override
    public void salvar() {
        CotacaoBean bean;
        CotacaoService service = new CotacaoService();
        if (this.validaCampos() && (bean = this.getBeanPreenchido()) != null) {
            try {
                service.gravaAutoCopiaSemCommit(bean, 1, Variaveis.filialPadrao, this.getCopiaFiliais());
                Conexao.arquivaSQL();
                this.limparCampos();
                this.setStatus(1);
                this.controlaCampos();
            }
            catch (Exception e) {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                Funcoes.mensagem(this.getTopLevelAncestor(), "N\u00e3o foi poss\u00edvel salvar cota\u00e7\u00e3o.", 2);
            }
        }
    }

    private CotacaoBean getBeanPreenchido() {
        if (this.cotacaoAux == null) {
            this.cotacaoAux = new CotacaoBean();
        }
        this.cotacaoAux.setObservacao(this.textObservacao.getText());
        HashSet<CotacaoMaterialEntidadeBean> materiais = new HashSet<CotacaoMaterialEntidadeBean>();
        for (int i = 0; i < this.listaMateriaisFornecedores.size(); ++i) {
            materiais.add(this.listaMateriaisFornecedores.get(i));
        }
        if (materiais.size() > 0) {
            this.cotacaoAux.setMaterialEntidadeCotacao(materiais);
        }
        HashSet<CotacaoEntidadeBean> entidades = new HashSet<CotacaoEntidadeBean>();
        for (int i = 0; i < this.modeloFornecedores.getRowCount(); ++i) {
            CotacaoEntidadeBean entidade = (CotacaoEntidadeBean)this.modeloFornecedores.getValueAt(i, this.modeloFornecedores.findColumn("Objeto"));
            entidade.setValorTotal(this.calculaTotalFornecedor(entidade));
            entidades.add(entidade);
        }
        if (entidades.size() > 0) {
            this.cotacaoAux.setEntidadesCotacao(entidades);
        }
        return this.cotacaoAux;
    }

    @Override
    public boolean validaCampos() {
        return true;
    }

    public static long getModuloAcesso() {
        return Long.parseLong("1200100300");
    }

    @Override
    public void pressioneiF2() {
        if (this.textCotacao.hasFocus()) {
            this.buttonBuscaCotacao.doClick();
        }
    }

    @Override
    public String getRetornoParaPesquisa() {
        return "";
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return null;
    }

    class DialogParcelas
    extends JDialog {
        private JButton buttonBuscaDataParcela;
        private JLabel labelParcela;
        private JLabel labelVencimentoParcela;
        private JLabel labelValorParcela;
        private JLabel labelDataInicial;
        private TTextField textParcela;
        private TTextField textDataParcela;
        private TTextField textValorParcela;
        private TTextField textDataInicial;
        private JButton buttonOKParcela;
        private JButton buttonOK;
        private JButton buttonCancelar;
        private JButton buttonGerarParcela;
        private ModeloGridTable modeloParcela;
        private JTable tableParcela;
        private JPanel topo;
        private FormaPagamentoVO formaPagtoAux;
        ArrayList<CotacaoEntidadeParcelaBean> parcelasAux;
        Double valorTotalAux;
        CotacaoEntidadeParcelaBean parcelaAlteracao;

        public DialogParcelas(Frame owner, FormaPagamentoVO formaPagto, ArrayList<CotacaoEntidadeParcelaBean> parcelas, Double valorTotal, Boolean showDialog) {
            super(owner, "Parcelas");
            this.buttonBuscaDataParcela = new JButton();
            this.labelParcela = new JLabel("Parcela");
            this.labelVencimentoParcela = new JLabel("Vencimento");
            this.labelValorParcela = new JLabel("Valor");
            this.labelDataInicial = new JLabel("Data Inicial:");
            this.textParcela = new TTextField(4, 1);
            this.textDataParcela = new TTextField(10, 4);
            this.textValorParcela = new TTextField(10, 2);
            this.textDataInicial = new TTextField(10, 4);
            this.buttonOKParcela = new JButton("OK");
            this.buttonOK = new JButton("OK");
            this.buttonCancelar = new JButton("Cancelar");
            this.buttonGerarParcela = new JButton("Gerar Parcelas");
            this.modeloParcela = new ModeloGridTable(new String[]{"Parcela", "Vencimento", "Valor Total"});
            this.tableParcela = new JTable(this.modeloParcela);
            this.topo = new JPanel(new GridBagLayout());
            this.formaPagtoAux = null;
            this.parcelasAux = null;
            this.valorTotalAux = null;
            this.parcelaAlteracao = null;
            if (formaPagto == null || valorTotal == null || valorTotal <= 0.0) {
                if (valorTotal == null || valorTotal <= 0.0) {
                    Funcoes.mensagem(Laboratorio.getInstancia(), "Configure os valores dos materiais antes de definir as parcelas.", 2);
                }
                return;
            }
            this.formaPagtoAux = formaPagto;
            this.valorTotalAux = valorTotal;
            this.parcelasAux = parcelas;
            if (showDialog.booleanValue()) {
                this.montaTela(owner);
            }
        }

        private void montaTela(Frame owner) {
            JPanel panel = new JPanel();
            this.setContentPane(panel);
            this.setModal(true);
            this.setResizable(false);
            this.setPreferredSize(new Dimension(280, 250));
            this.setMinimumSize(new Dimension(280, 250));
            Funcoes.imagemPesquisa(this.buttonBuscaDataParcela);
            Funcoes.montaEnter((JComponent)this.getContentPane());
            ScreenUtil.centralizar(this);
            this.buttonOK.setMnemonic('O');
            this.buttonOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogParcelas.this.setVisible(false);
                }
            });
            this.buttonCancelar.setMnemonic('C');
            this.buttonCancelar.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogParcelas.this.parcelasAux = null;
                    DialogParcelas.this.setVisible(false);
                }
            });
            this.buttonBuscaDataParcela.setFocusable(false);
            this.buttonBuscaDataParcela.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogParcelas.this.buscaDataParcela();
                }
            });
            this.buttonOKParcela.setMnemonic('K');
            this.buttonOKParcela.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (DialogParcelas.this.parcelaAlteracao != null) {
                        DialogParcelas.this.parcelaAlteracao.setDataVencimento(Funcoes.getData("dd/MM/yyyy", DialogParcelas.this.textDataParcela.getText()));
                        DialogParcelas.this.parcelaAlteracao.setValor(Double.parseDouble(Funcoes.limpaDecimal(DialogParcelas.this.textValorParcela.getText())));
                        DialogParcelas.this.textParcela.setText("");
                        DialogParcelas.this.textDataParcela.setText("");
                        DialogParcelas.this.textValorParcela.setText("");
                        DialogParcelas.this.preencheDadosParcelas();
                        DialogParcelas.this.parcelaAlteracao = null;
                    }
                }
            });
            this.tableParcela.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 32 && DialogParcelas.this.parcelasAux != null) {
                        int parcela = (Integer)DialogParcelas.this.modeloParcela.getValueAt(DialogParcelas.this.tableParcela.getSelectedRow(), DialogParcelas.this.modeloParcela.findColumn("Parcela"));
                        for (int i = 0; i < DialogParcelas.this.parcelasAux.size(); ++i) {
                            if (DialogParcelas.this.parcelasAux.get(i).getCodigo() != parcela) continue;
                            DialogParcelas.this.parcelaAlteracao = DialogParcelas.this.parcelasAux.get(i);
                            break;
                        }
                        if (DialogParcelas.this.parcelaAlteracao != null) {
                            DialogParcelas.this.textParcela.setText(DialogParcelas.this.parcelaAlteracao.getCodigo().toString());
                            DialogParcelas.this.textDataParcela.setText(Funcoes.formataData(DialogParcelas.this.parcelaAlteracao.getDataVencimento()));
                            DialogParcelas.this.textValorParcela.setText(Funcoes.formataDecimal(DialogParcelas.this.parcelaAlteracao.getValor()));
                            if (DialogParcelas.this.textDataParcela.isFocusable() && DialogParcelas.this.textDataParcela.isEnabled()) {
                                DialogParcelas.this.textDataParcela.selectAll();
                                DialogParcelas.this.textDataParcela.grabFocus();
                            }
                        }
                    }
                }
            });
            this.buttonGerarParcela.setMnemonic('G');
            this.buttonGerarParcela.setMargin(new Insets(1, 1, 1, 1));
            this.buttonGerarParcela.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogParcelas.this.gerarParcelas();
                }
            });
            panel.setLayout(new GridBagLayout());
            GridBagConstraints g = new GridBagConstraints();
            g.anchor = 17;
            g.gridx = 0;
            g.gridy = 0;
            g.insets = new Insets(5, 1, 0, 0);
            this.topo.add((Component)this.labelParcela, g);
            g.gridx = 1;
            this.topo.add((Component)this.labelVencimentoParcela, g);
            g.gridx = 3;
            this.topo.add((Component)this.labelValorParcela, g);
            g.gridy = 1;
            g.gridx = 0;
            g.insets = new Insets(1, 1, 0, 0);
            this.textParcela.setMinimumSize(new Dimension(50, 20));
            this.textParcela.setPreferredSize(new Dimension(50, 20));
            this.textParcela.setEnabled(false);
            this.topo.add((Component)this.textParcela, g);
            g.gridx = 1;
            this.textDataParcela.setMinimumSize(new Dimension(85, 20));
            this.textDataParcela.setPreferredSize(new Dimension(85, 20));
            this.topo.add((Component)this.textDataParcela, g);
            g.gridx = 2;
            this.buttonBuscaDataParcela.setPreferredSize(new Dimension(20, 20));
            this.buttonBuscaDataParcela.setMinimumSize(new Dimension(20, 20));
            this.topo.add((Component)this.buttonBuscaDataParcela, g);
            g.gridx = 3;
            this.textValorParcela.setPreferredSize(new Dimension(80, 20));
            this.textValorParcela.setMinimumSize(new Dimension(80, 20));
            this.topo.add((Component)this.textValorParcela, g);
            g.gridx = 4;
            this.buttonOKParcela.setPreferredSize(new Dimension(40, 20));
            this.buttonOKParcela.setMinimumSize(new Dimension(40, 20));
            this.buttonOKParcela.setMargin(new Insets(1, 1, 1, 1));
            this.topo.add((Component)this.buttonOKParcela, g);
            g = new GridBagConstraints();
            g.anchor = 17;
            g.fill = 0;
            g.insets = new Insets(1, 1, 0, 0);
            g.gridheight = 1;
            g.gridwidth = 1;
            g.gridx = 0;
            g.gridy = 0;
            g.weightx = 0.0;
            g.weighty = 0.0;
            this.textDataInicial.setPreferredSize(new Dimension(90, 20));
            this.textDataInicial.setMinimumSize(new Dimension(90, 20));
            this.labelDataInicial.setDisplayedMnemonic('D');
            this.labelDataInicial.setLabelFor(this.textDataInicial);
            panel.add((Component)this.labelDataInicial, g);
            ++g.gridx;
            panel.add((Component)this.textDataInicial, g);
            ++g.gridx;
            panel.add((Component)this.buttonGerarParcela, g);
            g.gridx = 0;
            ++g.gridy;
            g.gridwidth = 4;
            g.fill = 2;
            g.weightx = 1.0;
            panel.add((Component)this.topo, g);
            JScrollPane e = new JScrollPane(this.tableParcela);
            g.fill = 1;
            ++g.gridy;
            g.weighty = 1.0;
            panel.add((Component)e, g);
            ++g.gridy;
            g.fill = 2;
            g.weighty = 0.0;
            JPanel panelBotoes = new JPanel(new FlowLayout(2));
            panelBotoes.add(this.buttonOK);
            panelBotoes.add(this.buttonCancelar);
            panel.add((Component)panelBotoes, g);
            if (this.parcelasAux == null) {
                this.gerarParcelas();
            } else {
                this.preencheDadosParcelas();
            }
        }

        private void buscaDataParcela() {
            Funcoes.mostraData(this.textDataInicial, this.buttonBuscaDataParcela, this.topo, true);
        }

        public void gerarParcelas() {
            Set setParcelas = null;
            if (this.textDataInicial.getText().isEmpty()) {
                this.textDataInicial.setText(Funcoes.formataData(new Date()));
            }
            try {
                setParcelas = new FormaPagamentoParcelaService().load(" where fil_codigo = " + Variaveis.filialPadrao + " and fpg_codigo = " + this.formaPagtoAux.getCodigo());
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "IncluirPrecos:DialogParcelas:gerarParcelas");
            }
            if (setParcelas != null) {
                ArrayList<ReceberPagarBean> parcelas = null;
                try {
                    parcelas = FinanceiroUtil.gerarParcelas(this.valorTotalAux, this.valorTotalAux, 0.0, 0.0, 0.0, 0.0, 1, Funcoes.getData("dd/MM/yyyy", this.textDataInicial.getText()), "P", setParcelas);
                }
                catch (Exception e) {
                    ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "IncluirPreco:DialogParcelas:gerarParcelas");
                }
                if (parcelas != null && parcelas.size() > 0) {
                    this.parcelasAux = new ArrayList();
                    for (int i = 0; i < parcelas.size(); ++i) {
                        CotacaoEntidadeParcelaBean parcela = new CotacaoEntidadeParcelaBean();
                        parcela.setCodigo(parcelas.get(i).getParcela());
                        parcela.setDataVencimento(parcelas.get(i).getDataVencimento());
                        parcela.setDataVencimentoCalculada(parcelas.get(i).getDataVencimento());
                        parcela.setValor(parcelas.get(i).getValorTotal());
                        parcela.setValorCalculado(parcelas.get(i).getValorTotal());
                        this.parcelasAux.add(parcela);
                    }
                    this.preencheDadosParcelas();
                }
            }
        }

        private void preencheDadosParcelas() {
            this.modeloParcela.clear();
            if (this.parcelasAux != null) {
                for (int i = 0; i < this.parcelasAux.size(); ++i) {
                    this.modeloParcela.addLine(new Object[]{this.parcelasAux.get(i).getCodigo(), Funcoes.formataData(this.parcelasAux.get(i).getDataVencimento()), Funcoes.formataDecimal(this.parcelasAux.get(i).getValor())});
                }
            }
        }

        public ArrayList<CotacaoEntidadeParcelaBean> getParcelas() {
            return this.parcelasAux;
        }
    }

    class DialogInformacoesFornecedores
    extends JDialog {
        private JLabel labelVendedor;
        private JLabel labelDesconto;
        private JLabel labelFormaPagamento;
        private JLabel labelPrazoEntrega;
        private JLabel labelFrete;
        private JLabel labelValidade;
        private JLabel labelDescFormaPagamento;
        private TTextField textVendedor;
        private TTextField textDesconto;
        private TTextField textFormaPagamento;
        private TTextField textPrazoEntrega;
        private TTextField textFrete;
        private TTextField textValidade;
        private JButton buttonFormaPagamento;
        private JButton buttonOk;
        private JButton buttonCancelar;
        private JButton buttonParcelas;
        private JButton buttonValidade;
        private CotacaoEntidadeBean cotEntidadeAux;
        private FormaPagamentoVO formaPgtoAux;
        private JComboBox comboDescontoForn;
        private Boolean controleGerouParcelas;
        private Boolean mudouFormapagamento;

        public DialogInformacoesFornecedores(Frame owner, CotacaoEntidadeBean cotEntBean) {
            super(owner, "Informa\u00e7\u00f5es - Fornecedor");
            this.labelVendedor = new JLabel("Vendedor:");
            this.labelDesconto = new JLabel("   Desconto:");
            this.labelFormaPagamento = new JLabel("Forma Pgto.:");
            this.labelPrazoEntrega = new JLabel("Pzo. Entrega:");
            this.labelFrete = new JLabel("   Vl. Frete:");
            this.labelValidade = new JLabel("   Validade Cota\u00e7\u00e3o:");
            this.labelDescFormaPagamento = new JLabel();
            this.textVendedor = new TTextField(100, 3);
            this.textDesconto = new TTextField(15, 2);
            this.textFormaPagamento = new TTextField(10, 1);
            this.textPrazoEntrega = new TTextField(50, 3);
            this.textFrete = new TTextField(15, 2);
            this.textValidade = new TTextField(10, 4);
            this.buttonFormaPagamento = new JButton();
            this.buttonOk = new JButton("OK");
            this.buttonCancelar = new JButton("Cancelar");
            this.buttonParcelas = new JButton("...");
            this.buttonValidade = new JButton();
            this.cotEntidadeAux = null;
            this.formaPgtoAux = null;
            this.comboDescontoForn = new JComboBox<String>(new String[]{"$", "%"});
            this.controleGerouParcelas = false;
            this.mudouFormapagamento = false;
            this.cotEntidadeAux = cotEntBean;
            this.montaTela(owner);
        }

        private void montaTela(Frame owner) {
            this.getContentPane().setLayout(new BorderLayout());
            ScreenUtil.setBorda(new Component[]{this.labelDescFormaPagamento}, new TitledBorder(""));
            this.setModal(true);
            this.setResizable(false);
            this.setPreferredSize(new Dimension(655, 130));
            this.setMinimumSize(new Dimension(655, 130));
            Funcoes.imagemPesquisa(this.buttonFormaPagamento);
            Funcoes.montaEnter((JComponent)this.getContentPane());
            ScreenUtil.centralizar(this);
            FocusAdapter focoAtualizaTotal = new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    DialogInformacoesFornecedores.this.cotEntidadeAux.setTipoDesconto(DialogInformacoesFornecedores.this.comboDescontoForn.getSelectedItem().toString());
                    if (e.getSource() == DialogInformacoesFornecedores.this.textDesconto) {
                        if (DialogInformacoesFornecedores.this.cotEntidadeAux.getTipoDesconto().equalsIgnoreCase("$")) {
                            DialogInformacoesFornecedores.this.cotEntidadeAux.setValorDesconto(Double.parseDouble(Funcoes.limpaDecimal(DialogInformacoesFornecedores.this.textDesconto.getText())));
                        } else {
                            DialogInformacoesFornecedores.this.cotEntidadeAux.setPercentualDesconto(Double.parseDouble(Funcoes.limpaDecimal(DialogInformacoesFornecedores.this.textDesconto.getText())));
                        }
                    } else if (e.getSource() == DialogInformacoesFornecedores.this.textFrete) {
                        DialogInformacoesFornecedores.this.cotEntidadeAux.setValorFrete(Double.parseDouble(Funcoes.limpaDecimal(DialogInformacoesFornecedores.this.textFrete.getText())));
                    }
                    DialogInformacoesFornecedores.this.cotEntidadeAux.setValorTotal(IncluirPrecos.this.calculaTotalFornecedor(DialogInformacoesFornecedores.this.cotEntidadeAux));
                }
            };
            FocusAdapter foco = new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    ((TTextField)e.getSource()).selectAll();
                }
            };
            this.textVendedor.addFocusListener(foco);
            this.textValidade.addFocusListener(foco);
            this.textFrete.addFocusListener(foco);
            this.textFormaPagamento.addFocusListener(foco);
            this.textPrazoEntrega.addFocusListener(foco);
            this.textFrete.addFocusListener(focoAtualizaTotal);
            this.comboDescontoForn.addFocusListener(focoAtualizaTotal);
            this.textVendedor.setPreferredSize(new Dimension(200, 20));
            this.textVendedor.setMinimumSize(new Dimension(200, 20));
            this.textDesconto.setPreferredSize(new Dimension(70, 20));
            this.textDesconto.setMinimumSize(new Dimension(70, 20));
            this.textFormaPagamento.setPreferredSize(new Dimension(50, 20));
            this.textFormaPagamento.setMinimumSize(new Dimension(50, 20));
            this.buttonFormaPagamento.setFocusable(false);
            this.buttonFormaPagamento.setPreferredSize(new Dimension(20, 20));
            this.buttonFormaPagamento.setMinimumSize(new Dimension(20, 20));
            this.labelDescFormaPagamento.setPreferredSize(new Dimension(20, 20));
            this.labelDescFormaPagamento.setMinimumSize(new Dimension(20, 20));
            this.textPrazoEntrega.setPreferredSize(new Dimension(200, 20));
            this.textPrazoEntrega.setMinimumSize(new Dimension(200, 20));
            this.textFrete.setPreferredSize(new Dimension(70, 20));
            this.textFrete.setMinimumSize(new Dimension(70, 20));
            this.textValidade.setPreferredSize(new Dimension(85, 20));
            this.textValidade.setMinimumSize(new Dimension(85, 20));
            Funcoes.imagemPesquisa(this.buttonValidade);
            this.buttonValidade.setFocusable(false);
            this.buttonValidade.setPreferredSize(new Dimension(20, 20));
            this.buttonValidade.setMinimumSize(new Dimension(20, 20));
            this.buttonValidade.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Funcoes.mostraData(DialogInformacoesFornecedores.this.textValidade, DialogInformacoesFornecedores.this.buttonValidade, (JPanel)DialogInformacoesFornecedores.this.getContentPane(), true);
                }
            });
            this.textValidade.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 113) {
                        DialogInformacoesFornecedores.this.buttonValidade.doClick();
                    }
                }
            });
            this.textFormaPagamento.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 113) {
                        DialogInformacoesFornecedores.this.pesquisaFormaPagto();
                    }
                }
            });
            this.textFormaPagamento.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    DialogInformacoesFornecedores.this.buscaFormaPagamento(DialogInformacoesFornecedores.this.textFormaPagamento.getText());
                }
            });
            this.buttonFormaPagamento.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogInformacoesFornecedores.this.pesquisaFormaPagto();
                }
            });
            this.buttonOk.setMnemonic('O');
            this.buttonOk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FilialVO filial = new FilialVO();
                    filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
                    if (DialogInformacoesFornecedores.this.formaPgtoAux != null && DialogInformacoesFornecedores.this.cotEntidadeAux.getParcelas() == null || DialogInformacoesFornecedores.this.mudouFormapagamento.booleanValue() && !DialogInformacoesFornecedores.this.controleGerouParcelas.booleanValue()) {
                        DialogParcelas diag = null;
                        diag = DialogInformacoesFornecedores.this.cotEntidadeAux.getFormaPagamento() != null && DialogInformacoesFornecedores.this.cotEntidadeAux.getFormaPagamento().getCodigo().intValue() != DialogInformacoesFornecedores.this.formaPgtoAux.getCodigo().intValue() ? new DialogParcelas(Laboratorio.getInstancia(), DialogInformacoesFornecedores.this.formaPgtoAux, null, DialogInformacoesFornecedores.this.cotEntidadeAux.getValorTotal(), false) : new DialogParcelas(Laboratorio.getInstancia(), DialogInformacoesFornecedores.this.formaPgtoAux, DialogInformacoesFornecedores.this.cotEntidadeAux.getParcelas(), DialogInformacoesFornecedores.this.cotEntidadeAux.getValorTotal(), false);
                        if (DialogInformacoesFornecedores.this.formaPgtoAux != null && DialogInformacoesFornecedores.this.cotEntidadeAux.getValorTotal() != null && DialogInformacoesFornecedores.this.cotEntidadeAux.getValorTotal() > 0.0) {
                            diag.setVisible(true);
                        }
                        if (diag.formaPagtoAux == null) {
                            return;
                        }
                        diag.gerarParcelas();
                        if (diag.getParcelas() != null) {
                            DialogInformacoesFornecedores.this.cotEntidadeAux.setParcelas(diag.getParcelas());
                        }
                        diag.setVisible(false);
                        Object var3_3 = null;
                    }
                    DialogInformacoesFornecedores.this.cotEntidadeAux.setVendedor(DialogInformacoesFornecedores.this.textVendedor.getText());
                    if (DialogInformacoesFornecedores.this.comboDescontoForn.getSelectedItem().equals("$")) {
                        DialogInformacoesFornecedores.this.cotEntidadeAux.setValorDesconto(DialogInformacoesFornecedores.this.textDesconto.getText().isEmpty() ? 0.0 : Double.valueOf(Funcoes.limpaDecimal(DialogInformacoesFornecedores.this.textDesconto.getText())));
                    } else {
                        DialogInformacoesFornecedores.this.cotEntidadeAux.setPercentualDesconto(DialogInformacoesFornecedores.this.textDesconto.getText().isEmpty() ? 0.0 : Double.valueOf(Funcoes.limpaDecimal(DialogInformacoesFornecedores.this.textDesconto.getText())));
                    }
                    DialogInformacoesFornecedores.this.cotEntidadeAux.setTipoDesconto(DialogInformacoesFornecedores.this.comboDescontoForn.getSelectedItem().toString());
                    DialogInformacoesFornecedores.this.cotEntidadeAux.setFormaPagamento(DialogInformacoesFornecedores.this.formaPgtoAux);
                    DialogInformacoesFornecedores.this.cotEntidadeAux.setPrazoEntrega(DialogInformacoesFornecedores.this.textPrazoEntrega.getText());
                    DialogInformacoesFornecedores.this.cotEntidadeAux.setValorFrete(DialogInformacoesFornecedores.this.textFrete.getText().isEmpty() ? 0.0 : Double.valueOf(Funcoes.limpaDecimal(DialogInformacoesFornecedores.this.textFrete.getText())));
                    DialogInformacoesFornecedores.this.cotEntidadeAux.setValidadeCotacao(DialogInformacoesFornecedores.this.textValidade.getText().isEmpty() ? null : Funcoes.getData("dd/MM/yyyy", DialogInformacoesFornecedores.this.textValidade.getText()));
                    if (DialogInformacoesFornecedores.this.formaPgtoAux == null) {
                        DialogInformacoesFornecedores.this.cotEntidadeAux.setParcelas(null);
                    }
                    DialogInformacoesFornecedores.this.setVisible(false);
                }
            });
            this.buttonCancelar.setMnemonic('C');
            this.buttonCancelar.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogInformacoesFornecedores.this.setVisible(false);
                }
            });
            this.comboDescontoForn.setPreferredSize(new Dimension(50, 20));
            this.comboDescontoForn.setMinimumSize(new Dimension(50, 20));
            this.buttonParcelas.setPreferredSize(new Dimension(20, 20));
            this.buttonParcelas.setMinimumSize(new Dimension(20, 20));
            this.buttonParcelas.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (DialogInformacoesFornecedores.this.formaPgtoAux == null) {
                        DialogInformacoesFornecedores.this.cotEntidadeAux.setParcelas(null);
                        return;
                    }
                    DialogParcelas diag = null;
                    diag = DialogInformacoesFornecedores.this.cotEntidadeAux.getFormaPagamento() != null && DialogInformacoesFornecedores.this.cotEntidadeAux.getFormaPagamento().getCodigo().intValue() != DialogInformacoesFornecedores.this.formaPgtoAux.getCodigo().intValue() ? new DialogParcelas(Laboratorio.getInstancia(), DialogInformacoesFornecedores.this.formaPgtoAux, null, DialogInformacoesFornecedores.this.cotEntidadeAux.getValorTotal(), true) : new DialogParcelas(Laboratorio.getInstancia(), DialogInformacoesFornecedores.this.formaPgtoAux, DialogInformacoesFornecedores.this.cotEntidadeAux.getParcelas(), DialogInformacoesFornecedores.this.cotEntidadeAux.getValorTotal(), true);
                    if (DialogInformacoesFornecedores.this.formaPgtoAux != null && DialogInformacoesFornecedores.this.cotEntidadeAux.getValorTotal() != null && DialogInformacoesFornecedores.this.cotEntidadeAux.getValorTotal() > 0.0) {
                        diag.setVisible(true);
                    }
                    if (diag.getParcelas() != null) {
                        DialogInformacoesFornecedores.this.cotEntidadeAux.setParcelas(diag.getParcelas());
                        DialogInformacoesFornecedores.this.controleGerouParcelas = true;
                    }
                }
            });
            JPanel p = new JPanel(new GridBagLayout());
            this.getContentPane().add((Component)p, "Center");
            p.setBorder(ScreenUtil.criarBordaVazia());
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 17;
            c.fill = 0;
            c.gridheight = 1;
            c.gridwidth = 1;
            c.gridx = 0;
            c.gridy = 0;
            c.weightx = 0.0;
            c.weighty = 0.0;
            p.add((Component)this.labelVendedor, c);
            ++c.gridx;
            c.gridwidth = 4;
            p.add((Component)this.textVendedor, c);
            c.gridx += 4;
            c.gridwidth = 1;
            p.add((Component)this.labelValidade, c);
            ++c.gridx;
            c.gridwidth = 2;
            p.add((Component)this.textValidade, c);
            c.gridx += 2;
            c.gridwidth = 1;
            p.add((Component)this.buttonValidade, c);
            ++c.gridx;
            c.gridwidth = 1;
            p.add((Component)this.labelFrete, c);
            ++c.gridx;
            p.add((Component)this.textFrete, c);
            ++c.gridy;
            c.gridx = 0;
            p.add((Component)this.labelFormaPagamento, c);
            ++c.gridx;
            p.add((Component)this.textFormaPagamento, c);
            ++c.gridx;
            p.add((Component)this.buttonFormaPagamento, c);
            ++c.gridx;
            c.fill = 2;
            c.gridwidth = 1;
            c.weightx = 1.0;
            p.add((Component)this.labelDescFormaPagamento, c);
            c.fill = 0;
            ++c.gridx;
            c.weightx = 0.0;
            p.add((Component)this.buttonParcelas, c);
            ++c.gridx;
            c.gridwidth = 1;
            p.add((Component)this.labelDesconto, c);
            ++c.gridx;
            p.add((Component)this.textDesconto, c);
            c.gridwidth = 2;
            ++c.gridx;
            p.add((Component)this.comboDescontoForn, c);
            ++c.gridy;
            c.gridx = 0;
            p.add((Component)this.labelPrazoEntrega, c);
            ++c.gridx;
            c.gridwidth = 4;
            p.add((Component)this.textPrazoEntrega, c);
            JPanel panelBotoes = ComponenteFactory.novoJPanelFlowLayout(2, this.buttonOk, this.buttonCancelar);
            ++c.gridy;
            c.gridx = 0;
            c.gridwidth = 11;
            c.weightx = 1.0;
            c.fill = 2;
            p.add((Component)panelBotoes, c);
            this.pack();
            this.preencherCampos();
            Funcoes.defineUpperCase(this.getContentPane(), ParametrosGerais.getUpperCase());
            this.setVisible(true);
        }

        private void preencherCampos() {
            if (this.cotEntidadeAux != null) {
                this.textVendedor.setText(this.cotEntidadeAux.getVendedor());
                this.textDesconto.setText(Funcoes.formataDecimal(this.cotEntidadeAux.getValorDesconto()));
                if (this.cotEntidadeAux.getTipoDesconto() != null) {
                    if (this.cotEntidadeAux.getTipoDesconto().equalsIgnoreCase("$") || this.cotEntidadeAux.getTipoDesconto().equalsIgnoreCase("M")) {
                        this.textDesconto.setText(Funcoes.formataDecimal(this.cotEntidadeAux.getValorDesconto()));
                        this.comboDescontoForn.setSelectedItem("$");
                    } else if (this.cotEntidadeAux.getTipoDesconto().equalsIgnoreCase("%") || this.cotEntidadeAux.getTipoDesconto().equalsIgnoreCase("P")) {
                        this.textDesconto.setText(Funcoes.formataDecimal(this.cotEntidadeAux.getPercentualDesconto()));
                        this.comboDescontoForn.setSelectedItem("%");
                    }
                }
                this.textFormaPagamento.setText(this.cotEntidadeAux.getFormaPagamento() == null ? "" : String.valueOf(this.cotEntidadeAux.getFormaPagamento().getCodigo()));
                this.labelDescFormaPagamento.setText(this.cotEntidadeAux.getFormaPagamento() == null ? "" : this.cotEntidadeAux.getFormaPagamento().getDescricao());
                this.formaPgtoAux = this.cotEntidadeAux.getFormaPagamento();
                this.textPrazoEntrega.setText(this.cotEntidadeAux.getPrazoEntrega());
                this.textFrete.setText(Funcoes.formataDecimal(this.cotEntidadeAux.getValorFrete()));
                this.textValidade.setText(Funcoes.formataData("dd/MM/yyyy", this.cotEntidadeAux.getValidadeCotacao()));
            }
        }

        public CotacaoEntidadeBean getDados() {
            return this.cotEntidadeAux;
        }

        private void pesquisaFormaPagto() {
            try {
                this.textFormaPagamento.setText("");
                this.labelDescFormaPagamento.setText("");
                FormaPagamentoVO forma = (FormaPagamentoVO)new FormaPagamentoService().pesquisaVO(this, new FormaPagamentoVO(), "Pesquisando formas de pagamento", true);
                if (forma != null) {
                    if (this.formaPgtoAux != forma) {
                        this.mudouFormapagamento = true;
                    }
                    this.formaPgtoAux = forma;
                    this.textFormaPagamento.setText(String.valueOf(forma.getCodigo()));
                    this.labelDescFormaPagamento.setText(forma.getDescricao());
                } else {
                    this.labelDescFormaPagamento.setText("N\u00e3o cadastrado");
                }
                ScreenUtil.requisitarFoco(this.textFormaPagamento);
            }
            catch (Exception e) {
                Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel buscar dados da forma de pagamento.", 2);
            }
        }

        private void buscaFormaPagamento(String codigo) {
            if (Funcoes.textoVazio(codigo)) {
                this.textFormaPagamento.setText("");
                this.labelDescFormaPagamento.setText("");
                this.formaPgtoAux = null;
                this.cotEntidadeAux.setParcelas(null);
                return;
            }
            try {
                FormaPagamentoVO forma = (FormaPagamentoVO)new FormaPagamentoService().getVO(Variaveis.filialPadrao, codigo);
                if (forma != null) {
                    this.formaPgtoAux = forma;
                    this.textFormaPagamento.setText(String.valueOf(forma.getCodigo()));
                    this.labelDescFormaPagamento.setText(forma.getDescricao());
                } else {
                    this.labelDescFormaPagamento.setText("N\u00e3o cadastrado");
                }
            }
            catch (Exception e) {
                Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel buscar dados da forma de pagamento.", 2);
            }
        }
    }
}

