/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.estoque.cotacao;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadrao;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.estoque.cotacao.JanelaHistoricoCotacao;
import jalis.laboratorio.estoque.pedido.PedidoCompra;
import jalis.laboratorio.relatorios.estoque.cotacao.RelatorioCotacao;
import jalis.model.AbstractThreadBean;
import jalis.model.bean.estoque.CotacaoBean;
import jalis.model.bean.estoque.CotacaoEntidadeBean;
import jalis.model.bean.estoque.CotacaoMaterialEntidadeBean;
import jalis.model.bean.estoque.MaterialBean;
import jalis.model.bean.estoque.PedidoBean;
import jalis.model.bean.estoque.PedidoMaterialBean;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.estoque.CotacaoVO;
import jalis.model.vo.estoque.MaterialVO;
import jalis.service.estoque.CotacaoService;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.SplashMensagem;
import jalis.util.TTextField;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class FinalizarCotacao
extends FrmCadPadrao {
    private final int CASAS = ParametrosGerais.getCasasPrecoExame();
    private final int CASAS_MAIOR = 4;
    private RoundingMode ROUND = ParametrosGerais.getArredondamentoPrecoExame();
    private JButton buttonBuscaCotacao = new JButton();
    private JButton buttonVencedor = new JButton("Vencedor");
    private JButton buttonPedidoCompra = new JButton("Pedido Compra");
    private JButton buttonImprimir = new JButton("Imprimir");
    private JLabel labelAux1 = new JLabel();
    private JLabel labelAux2 = new JLabel();
    private JLabel labelAux3 = new JLabel();
    private JLabel labelAux4 = new JLabel();
    private JLabel labelData = new JLabel("Data:");
    private JLabel labelUsuario = new JLabel("Usu\u00e1rio:");
    private JLabel labelCotacao = new JLabel("Cota\u00e7\u00e3o:");
    private JLabel labelVlrData = new JLabel();
    private JLabel labelVlrUsuario = new JLabel();
    private JPanel panelCabecalho = new JPanel(new GridBagLayout());
    private JPanel panelObservacao = new JPanel(new GridBagLayout());
    private JPanel panelMateriais = new JPanel(new GridBagLayout());
    private JPanel panelFornecedores = new JPanel(new GridBagLayout());
    private JPanel panelLegenda = new JPanel(new GridBagLayout());
    private JScrollPane scrollMateriais;
    private JScrollPane scrollFornecedores;
    private JScrollPane scrollObservacao;
    private TTextField textCotacao = new TTextField(8, 1);
    private JTextArea textObservacao = new JTextArea();
    private ModeloGridTable modeloMateriais;
    private ModeloGridTable modeloFornecedores;
    private JTable tableMateriais;
    private JTable tableFornecedores;
    private CotacaoBean cotacaoAux = null;
    private ArrayList<CotacaoMaterialEntidadeBean> listaMateriaisFornecedores = new ArrayList();
    private CotacaoEntidadeBean cotEntAux = null;
    private static final Color COR_VENCEDOR = ScreenUtil.clarearCor(Color.GREEN, 125);

    public FinalizarCotacao() {
        Funcoes.criaBarraDescricao(this, "Finalizar Cota\u00e7\u00e3o", "Finaliza\u00e7\u00e3o de cota\u00e7\u00e3o", "estoque/finalizar_cotacao.jpg");
        ScreenUtil.setBorda(new Component[]{this.labelVlrUsuario, this.labelVlrData}, new TitledBorder(""));
        Funcoes.imagemPesquisa(this.buttonBuscaCotacao);
        this.botaoSalvar.setText("Finalizar");
        this.botaoSalvar.setMnemonic('n');
        this.painelBotoes.removeAll();
        this.painelBotoes.setLayout(new GridBagLayout());
        this.buttonImprimir.setMnemonic('I');
        this.buttonImprimir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int codigo;
                int resp = -1;
                resp = !FinalizarCotacao.this.cotacaoAux.getSituacao().equalsIgnoreCase("F") ? Funcoes.mensagem(FinalizarCotacao.this, "A cota\u00e7\u00e3o ser\u00e1 finalizada antes do processo de impress\u00e3o.\nDeseja Continuar?", 4) : 0;
                if (resp == 0 && (codigo = FinalizarCotacao.this.salvarSemFechar()) > -1) {
                    RelatorioCotacao relatorio = new RelatorioCotacao(0);
                    relatorio.imprimirPressionado(codigo);
                    JDialog aux = new JDialog(Laboratorio.getInstancia(), "Imprimir Cota\u00e7\u00e3o - somente fornecedor vencedor", true);
                    aux.setSize(700, 600);
                    aux.setContentPane(relatorio);
                    ScreenUtil.centralizar(aux);
                    aux.setVisible(true);
                }
            }
        });
        this.painelCentral.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.labelCotacao.setDisplayedMnemonic('o');
        this.labelCotacao.setLabelFor(this.textCotacao);
        this.panelCabecalho.add((Component)this.labelCotacao, gridBagConstraints);
        this.textCotacao.setMinimumSize(new Dimension(60, 20));
        this.textCotacao.setPreferredSize(new Dimension(60, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.panelCabecalho.add((Component)this.textCotacao, gridBagConstraints);
        this.buttonBuscaCotacao.setFocusable(false);
        this.buttonBuscaCotacao.setMinimumSize(new Dimension(20, 20));
        this.buttonBuscaCotacao.setPreferredSize(new Dimension(20, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.panelCabecalho.add((Component)this.buttonBuscaCotacao, gridBagConstraints);
        this.labelAux3.setMinimumSize(new Dimension(20, 20));
        this.labelAux3.setPreferredSize(new Dimension(20, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.panelCabecalho.add((Component)this.labelAux3, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        this.panelCabecalho.add((Component)this.labelUsuario, gridBagConstraints);
        this.labelVlrUsuario.setMinimumSize(new Dimension(90, 20));
        this.labelVlrUsuario.setPreferredSize(new Dimension(90, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.panelCabecalho.add((Component)this.labelVlrUsuario, gridBagConstraints);
        this.labelAux1.setMinimumSize(new Dimension(20, 20));
        this.labelAux1.setPreferredSize(new Dimension(20, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.panelCabecalho.add((Component)this.labelAux1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.panelCabecalho.add((Component)this.labelData, gridBagConstraints);
        this.labelVlrData.setMinimumSize(new Dimension(150, 20));
        this.labelVlrData.setPreferredSize(new Dimension(150, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.panelCabecalho.add((Component)this.labelVlrData, gridBagConstraints);
        this.labelAux4.setMinimumSize(new Dimension(20, 20));
        this.labelAux4.setPreferredSize(new Dimension(20, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.panelCabecalho.add((Component)this.labelAux4, gridBagConstraints);
        this.labelAux2.setMinimumSize(new Dimension(20, 20));
        this.labelAux2.setPreferredSize(new Dimension(20, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.panelCabecalho.add((Component)this.labelAux2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 2, 1);
        this.painelCentral.add((Component)this.panelCabecalho, gridBagConstraints);
        this.buttonBuscaCotacao.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FinalizarCotacao.this.limparCampos();
                CotacaoBean bean = (CotacaoBean)FinalizarCotacao.this.pesquisar();
                if (bean != null) {
                    FinalizarCotacao.this.preencherCampos(bean);
                    FinalizarCotacao.this.setStatus(3);
                    FinalizarCotacao.this.controlaCampos();
                }
            }
        });
        this.buttonPedidoCompra.setMnemonic('P');
        this.buttonPedidoCompra.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PedidoBean pedido = new PedidoBean();
                FilialVO filial = new FilialVO();
                filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
                pedido.setFilial(filial);
                pedido.setCotacao((CotacaoVO)FinalizarCotacao.this.cotacaoAux.toVO());
                pedido.setDataHora(FinalizarCotacao.this.cotacaoAux.getDataFechamento());
                Set<CotacaoEntidadeBean> entidades = FinalizarCotacao.this.cotacaoAux.getEntidadesCotacao();
                for (CotacaoEntidadeBean entidade : entidades) {
                    if (!entidade.getSituacao().equalsIgnoreCase("V")) continue;
                    pedido.setEntidade(entidade.getEntidade());
                    pedido.setNomeVendedor(entidade.getVendedor());
                    pedido.setPercentualDesconto(entidade.getPercentualDesconto());
                    pedido.setValorDesconto(entidade.getValorDesconto());
                    pedido.setValorTotal(entidade.getValorTotal());
                    pedido.setFormaPagto(entidade.getFormaPagamento());
                    break;
                }
                ArrayList<PedidoMaterialBean> materiaisPedido = new ArrayList<PedidoMaterialBean>();
                Set<CotacaoMaterialEntidadeBean> materiaisCotacao = FinalizarCotacao.this.cotacaoAux.getMaterialEntidadeCotacao();
                for (CotacaoMaterialEntidadeBean materialCot : materiaisCotacao) {
                    if (materialCot.getCotacaoEntidade().getEntidade().getCodigo().intValue() != pedido.getEntidade().getCodigo().intValue()) continue;
                    PedidoMaterialBean material = new PedidoMaterialBean();
                    material.setFilial(filial);
                    material.setMaterial((MaterialBean)materialCot.getCotacaoMaterial().getMaterial().toBean());
                    material.setPercentualDesconto(materialCot.getPercentualDesconto());
                    material.setQuantidade(materialCot.getQuantidade());
                    material.setValorDesconto(materialCot.getValorDesconto());
                    material.setValorTotal(materialCot.getValorTotal());
                    material.setValorUnitario(materialCot.getValorUnitario());
                    materiaisPedido.add(material);
                }
                pedido.setMateriais(materiaisPedido);
                pedido.setObservacao(FinalizarCotacao.this.cotacaoAux.getObservacao());
                pedido.setUsuario(FinalizarCotacao.this.cotacaoAux.getUsuario());
                final JDialog dialogPedido = new JDialog((Frame)Laboratorio.getInstancia(), true);
                dialogPedido.setTitle("Pedido de Compra");
                dialogPedido.setSize(700, 600);
                PedidoCompra telaPedido = new PedidoCompra(pedido, true){

                    @Override
                    public void fechar() {
                        super.fechar();
                        dialogPedido.setVisible(false);
                    }
                };
                dialogPedido.setContentPane(telaPedido);
                ScreenUtil.centralizar(dialogPedido);
                dialogPedido.setVisible(true);
            }
        });
        this.panelMateriais.setBorder(BorderFactory.createTitledBorder("Materiais"));
        this.panelFornecedores.setBorder(BorderFactory.createTitledBorder("Fornecedores"));
        this.modeloMateriais = new ModeloGridTable(new String[]{"C\u00f3digo", "Material", "Qtde.", "Unid.", "Unit\u00e1rio", "Desconto", "% Desc.", "Total", "Situa\u00e7\u00e3o", "H", "Objeto"}){

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return columnIndex == 9;
            }

            @Override
            public void fireTableStructureChanged() {
                super.fireTableStructureChanged();
                try {
                    if (FinalizarCotacao.this.tableMateriais != null) {
                        FinalizarCotacao.this.tableMateriais.removeColumn(FinalizarCotacao.this.tableMateriais.getColumn("Objeto"));
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                try {
                    FinalizarCotacao.this.tableMateriais.removeColumn(FinalizarCotacao.this.tableMateriais.getColumn("Objeto"));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        };
        this.modeloFornecedores = new ModeloGridTable(new String[]{"C\u00f3digo", "Fantasia", "Vendedor", "Forma Pgto.", "Pzo. Entrega", "Desconto", "Total", "Objeto"}){

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                Object[] classes = new Object[]{Integer.class, String.class, String.class, String.class, String.class, String.class, String.class, CotacaoEntidadeBean.class};
                return (Class)classes[columnIndex];
            }

            @Override
            public void fireTableStructureChanged() {
                super.fireTableStructureChanged();
                try {
                    if (FinalizarCotacao.this.tableFornecedores != null) {
                        FinalizarCotacao.this.tableFornecedores.removeColumn(FinalizarCotacao.this.tableFornecedores.getColumn("Objeto"));
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                try {
                    FinalizarCotacao.this.tableFornecedores.removeColumn(FinalizarCotacao.this.tableFornecedores.getColumn("Objeto"));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        };
        this.tableMateriais = new JTable(this.modeloMateriais){

            @Override
            public Class<?> getColumnClass(int column) {
                if (column == 9) {
                    return Set.class;
                }
                return String.class;
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return column == 9;
            }
        };
        this.tableMateriais.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
            }
        });
        this.modeloMateriais.setColumnSize(new int[]{60, 0, 60, 50, 70, 75, 65, 70, 70, 20, 0}, this.tableMateriais);
        this.tableMateriais.setRowHeight(20);
        this.tableMateriais.getTableHeader().addMouseListener(this.modeloMateriais);
        this.tableMateriais.removeColumn(this.tableMateriais.getColumn("Objeto"));
        ButtonRenderer buttonRenderer = new ButtonRenderer();
        ButtonEditor buttonEditor = new ButtonEditor();
        this.tableMateriais.setDefaultRenderer(Set.class, buttonRenderer);
        this.tableMateriais.setDefaultEditor(Set.class, buttonEditor);
        this.scrollMateriais = new JScrollPane(this.tableMateriais);
        this.tableFornecedores = new JTable(this.modeloFornecedores);
        this.tableFornecedores.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if ((FinalizarCotacao.this.getStatus() == 2 || FinalizarCotacao.this.getStatus() == 3) && FinalizarCotacao.this.modeloFornecedores.getRowCount() > 0 && FinalizarCotacao.this.tableFornecedores.getSelectedRow() >= 0) {
                    CotacaoEntidadeBean cotEntidade = (CotacaoEntidadeBean)FinalizarCotacao.this.modeloFornecedores.getValueAt(FinalizarCotacao.this.tableFornecedores.getSelectedRow(), FinalizarCotacao.this.modeloFornecedores.findColumn("Objeto"));
                    FinalizarCotacao.this.mostrarMateriaisFornecedor(cotEntidade);
                    FinalizarCotacao.this.cotEntAux = cotEntidade;
                    FinalizarCotacao.this.controlaCampos();
                }
            }
        });
        this.tableFornecedores.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if ((FinalizarCotacao.this.getStatus() == 2 || FinalizarCotacao.this.getStatus() == 3) && FinalizarCotacao.this.modeloFornecedores.getRowCount() > 0 && FinalizarCotacao.this.tableFornecedores.getSelectedRow() >= 0) {
                    CotacaoEntidadeBean cotEntidade = (CotacaoEntidadeBean)FinalizarCotacao.this.modeloFornecedores.getValueAt(FinalizarCotacao.this.tableFornecedores.getSelectedRow(), FinalizarCotacao.this.modeloFornecedores.findColumn("Objeto"));
                    FinalizarCotacao.this.mostrarMateriaisFornecedor(cotEntidade);
                    FinalizarCotacao.this.cotEntAux = cotEntidade;
                    FinalizarCotacao.this.controlaCampos();
                }
            }
        });
        FornecedorRenderer renderer = new FornecedorRenderer();
        this.tableFornecedores.setDefaultRenderer(Object.class, renderer);
        this.tableFornecedores.setDefaultRenderer(String.class, renderer);
        this.tableFornecedores.setDefaultRenderer(Double.class, renderer);
        this.tableFornecedores.setDefaultRenderer(Integer.class, renderer);
        this.modeloFornecedores.setColumnSize(new int[]{70, 0, 120, 100, 100, 75, 75, 0}, this.tableFornecedores);
        this.tableFornecedores.getTableHeader().addMouseListener(this.modeloFornecedores);
        this.tableFornecedores.removeColumn(this.tableFornecedores.getColumn("Objeto"));
        this.scrollFornecedores = new JScrollPane(this.tableFornecedores);
        this.buttonVencedor.setMnemonic('V');
        this.buttonVencedor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FinalizarCotacao.this.cotEntAux != null) {
                    for (int i = 0; i < FinalizarCotacao.this.tableFornecedores.getRowCount(); ++i) {
                        CotacaoEntidadeBean entidade = (CotacaoEntidadeBean)FinalizarCotacao.this.modeloFornecedores.getValueAt(i, FinalizarCotacao.this.modeloFornecedores.findColumn("Objeto"));
                        if (entidade == FinalizarCotacao.this.cotEntAux) {
                            entidade.setSituacao("V");
                            continue;
                        }
                        if (!entidade.getSituacao().equalsIgnoreCase("V")) continue;
                        entidade.setSituacao("A");
                    }
                }
                int linha = FinalizarCotacao.this.tableFornecedores.getSelectedRow();
                FinalizarCotacao.this.modeloFornecedores.fireTableDataChanged();
                if (linha >= 0) {
                    FinalizarCotacao.this.tableFornecedores.getSelectionModel().setSelectionInterval(linha, linha);
                }
            }
        });
        this.textCotacao.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!FinalizarCotacao.this.textCotacao.getText().isEmpty()) {
                    CotacaoBean bean = null;
                    try {
                        SplashMensagem janelaEspera = SplashMensagem.getInstancia(FinalizarCotacao.this);
                        janelaEspera.mostrar("Carregando cota\u00e7\u00e3o");
                        bean = (CotacaoBean)new CotacaoService().get(Variaveis.filialPadrao, FinalizarCotacao.this.textCotacao.getText());
                        janelaEspera.apagar();
                    }
                    catch (Exception e1) {
                        Funcoes.mensagem(FinalizarCotacao.this, "N\u00e3o foi poss\u00edvel carregar a cota\u00e7\u00e3o.", 2);
                    }
                    if (bean != null) {
                        if (!bean.getSituacao().equalsIgnoreCase("A")) {
                            Funcoes.mensagem(FinalizarCotacao.this, "A situa\u00e7\u00e3o da cota\u00e7\u00e3o deve ser \"ABERTA\".", 2);
                            FinalizarCotacao.this.textCotacao.setText("");
                            if (FinalizarCotacao.this.textCotacao.isFocusable() && FinalizarCotacao.this.textCotacao.isEnabled()) {
                                FinalizarCotacao.this.textCotacao.grabFocus();
                            }
                            return;
                        }
                        FinalizarCotacao.this.preencherCampos(bean);
                        FinalizarCotacao.this.setStatus(1);
                        if (bean.getSituacao() != null && bean.getSituacao().equalsIgnoreCase("A")) {
                            FinalizarCotacao.this.setStatus(3);
                        }
                    } else {
                        Funcoes.mensagem(FinalizarCotacao.this, "Cota\u00e7\u00e3o n\u00e3o encontrada.", 2);
                        FinalizarCotacao.this.textCotacao.setText("");
                        if (FinalizarCotacao.this.textCotacao.isFocusable() && FinalizarCotacao.this.textCotacao.isEnabled()) {
                            FinalizarCotacao.this.textCotacao.grabFocus();
                        }
                    }
                    FinalizarCotacao.this.controlaCampos();
                }
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 9;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 1, 1, 1);
        this.panelMateriais.add((Component)this.scrollMateriais, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.6;
        this.painelCentral.add((Component)this.panelMateriais, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 1, 1, 1);
        this.panelFornecedores.add((Component)this.scrollFornecedores, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.panelFornecedores.add((Component)this.buttonVencedor, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.painelCentral.add((Component)this.panelFornecedores, gridBagConstraints);
        this.panelObservacao.setBorder(BorderFactory.createTitledBorder("Observa\u00e7\u00e3o"));
        this.scrollObservacao = new JScrollPane(this.textObservacao);
        this.scrollObservacao.setMinimumSize(new Dimension(100, 50));
        this.scrollObservacao.setPreferredSize(new Dimension(100, 50));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.panelObservacao.add((Component)this.scrollObservacao, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.painelCentral.add((Component)this.panelObservacao, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.painelCentral.add((Component)this.panelLegenda, gridBagConstraints);
        this.montaPainelLegenda();
        this.montaPainelBotoes();
        this.controlaCampos();
    }

    private void montaPainelBotoes() {
        JPanel panelImprimir = new JPanel(new FlowLayout(0));
        panelImprimir.add(this.buttonImprimir);
        JPanel panelBotoesBasicos = new JPanel(new FlowLayout(2));
        panelBotoesBasicos.add(this.botaoNovo);
        panelBotoesBasicos.add(this.botaoSalvar);
        panelBotoesBasicos.add(this.buttonPedidoCompra);
        panelBotoesBasicos.add(this.botaoCancelar);
        panelBotoesBasicos.add(this.botaoFechar);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        this.painelBotoes.add((Component)panelImprimir, c);
        ++c.gridx;
        this.painelBotoes.add((Component)panelBotoesBasicos, c);
    }

    public void limparCampos() {
        this.textCotacao.setText("");
        this.labelVlrUsuario.setText("");
        this.labelVlrData.setText("");
        this.textObservacao.setText("");
        this.modeloMateriais.clear();
        this.modeloFornecedores.clear();
        this.cotacaoAux = null;
    }

    private void controlaCampos() {
        boolean habilitar = this.getStatus() == 2 || this.getStatus() == 3;
        this.textCotacao.setEnabled(habilitar && this.cotacaoAux == null);
        this.buttonBuscaCotacao.setEnabled(habilitar && this.cotacaoAux == null);
        this.textObservacao.setEnabled(habilitar);
        this.buttonVencedor.setEnabled(habilitar && this.tableFornecedores.getSelectedRow() >= 0);
        this.buttonImprimir.setEnabled(this.cotacaoAux != null);
        this.botaoSalvar.setEnabled(habilitar && this.cotacaoAux != null && !this.cotacaoAux.getSituacao().equalsIgnoreCase("F"));
        this.buttonPedidoCompra.setEnabled(this.cotacaoAux != null && this.cotacaoAux.getSituacao().equalsIgnoreCase("F"));
    }

    @Override
    public void cancelar() {
        if (Funcoes.mensagem(this, "As informa\u00e7\u00f5es adicionadas ser\u00e3o perdidas.", 4) == 0) {
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    @Override
    public void editar() {
    }

    @Override
    public void excluir() {
    }

    @Override
    public void fechar() {
        if (this.getStatus() == 1 || Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setVisible(false);
        }
    }

    @Override
    public void novo() {
        this.limparCampos();
        this.setStatus(2);
        this.controlaCampos();
        if (this.textCotacao.isEnabled() && this.textCotacao.isFocusable()) {
            this.textCotacao.grabFocus();
        }
        this.buttonBuscaCotacao.doClick();
    }

    @Override
    public void salvar() {
        this.salvarSemFechar();
    }

    public int salvarSemFechar() {
        CotacaoBean bean;
        CotacaoService service = new CotacaoService();
        if (this.validaCampos() && (bean = this.getBeanPreenchido()) != null) {
            try {
                service.gravaAutoCopiaSemCommit(bean, 1, Variaveis.filialPadrao, this.getCopiaFiliais());
                Conexao.arquivaSQL();
                this.setStatus(1);
                this.controlaCampos();
                return bean.getCodigo();
            }
            catch (Exception e) {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                Funcoes.mensagem(this.getTopLevelAncestor(), "N\u00e3o foi poss\u00edvel salvar cota\u00e7\u00e3o.", 2);
            }
        }
        return -1;
    }

    protected String getCopiaFiliais() {
        return null;
    }

    private CotacaoBean getBeanPreenchido() {
        this.cotacaoAux.setObservacao(this.textObservacao.getText());
        HashSet<CotacaoMaterialEntidadeBean> materiais = new HashSet<CotacaoMaterialEntidadeBean>();
        for (int i = 0; i < this.listaMateriaisFornecedores.size(); ++i) {
            materiais.add(this.listaMateriaisFornecedores.get(i));
        }
        if (materiais.size() > 0) {
            this.cotacaoAux.setMaterialEntidadeCotacao(materiais);
        }
        HashSet<CotacaoEntidadeBean> entidades = new HashSet<CotacaoEntidadeBean>();
        for (int i = 0; i < this.modeloFornecedores.getRowCount(); ++i) {
            entidades.add((CotacaoEntidadeBean)this.modeloFornecedores.getValueAt(i, this.modeloFornecedores.findColumn("Objeto")));
        }
        if (entidades.size() > 0) {
            this.cotacaoAux.setEntidadesCotacao(entidades);
        }
        this.cotacaoAux.setSituacao("F");
        this.cotacaoAux.setDataFechamento(new Date());
        return this.cotacaoAux;
    }

    @Override
    public boolean validaCampos() {
        for (int i = 0; i < this.modeloFornecedores.getRowCount(); ++i) {
            CotacaoEntidadeBean entidade = (CotacaoEntidadeBean)this.modeloFornecedores.getValueAt(i, this.modeloFornecedores.findColumn("Objeto"));
            if (entidade == null || entidade.getSituacao() == null || !entidade.getSituacao().equalsIgnoreCase("V")) continue;
            return true;
        }
        Funcoes.mensagem(this, "N\u00e3o \u00e9 poss\u00edvel finalizar, pois nenhum fornecedor foi marcado como vencedor.", 2);
        return false;
    }

    @Override
    public void pressioneiF2() {
        if (this.textCotacao.hasFocus()) {
            this.buttonBuscaCotacao.doClick();
        }
    }

    private AbstractThreadBean pesquisar() {
        CotacaoService service = new CotacaoService();
        try {
            AbstractThreadVO vo = service.pesquisaVO((Object)this.getTopLevelAncestor(), (AbstractThreadVO)new CotacaoVO(), "Pesquisando Cota\u00e7\u00f5es", new String[]{"A"});
            if (vo != null) {
                SplashMensagem janelaEspera = SplashMensagem.getInstancia(this);
                janelaEspera.mostrar("Carregando cota\u00e7\u00e3o");
                CotacaoBean cotacaoBean = (CotacaoBean)service.get(String.valueOf(((CotacaoVO)vo).getFilial().getCodigo()), String.valueOf(((CotacaoVO)vo).getCodigo()));
                janelaEspera.apagar();
                return cotacaoBean;
            }
        }
        catch (Exception e) {
            Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel carregar dados da cota\u00e7\u00e3o.", 2);
        }
        return null;
    }

    public static long getModuloAcesso() {
        return Long.parseLong("1200100400");
    }

    private void montaPainelLegenda() {
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 0.0;
        c.weighty = 0.0;
        JPanel pnlCorLegenda = new JPanel();
        pnlCorLegenda.setPreferredSize(new Dimension(10, 10));
        pnlCorLegenda.setBackground(COR_VENCEDOR);
        pnlCorLegenda.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
        this.panelLegenda.add((Component)pnlCorLegenda, c);
        JLabel lblLegenda = new JLabel("Fornecedor vencedor");
        Font font = new Font(lblLegenda.getFont().getName(), 0, 10);
        lblLegenda.setFont(font);
        ++c.gridx;
        this.panelLegenda.add((Component)lblLegenda, c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        this.panelLegenda.add((Component)new JLabel(), c);
    }

    private void preencherCampos(CotacaoBean cotacao) {
        if (cotacao != null) {
            this.cotacaoAux = cotacao;
            this.textCotacao.setText(String.valueOf(cotacao.getCodigo()));
            this.labelVlrUsuario.setText(cotacao.getUsuario().getCodigo());
            this.labelVlrData.setText(Funcoes.formataData("dd/MM/yyyy HH:mm:ss", cotacao.getDataHora()));
            this.textObservacao.setText(cotacao.getObservacao());
            if (cotacao.getEntidadesCotacao() != null) {
                Set<CotacaoEntidadeBean> entidades = cotacao.getEntidadesCotacao();
                for (CotacaoEntidadeBean entidade : entidades) {
                    this.adicionarFornecedor(entidade);
                }
            }
            HashSet set = (HashSet)cotacao.getMaterialEntidadeCotacao();
            for (CotacaoMaterialEntidadeBean bean : set) {
                this.listaMateriaisFornecedores.add(bean);
                this.adicionarMaterialFornecedor(bean);
            }
        }
    }

    private void adicionarFornecedor(CotacaoEntidadeBean bean) {
        if (bean != null) {
            for (int i = 0; i < this.modeloFornecedores.getRowCount(); ++i) {
                if (bean.getEntidade().getCodigo().intValue() != ((Integer)this.modeloFornecedores.getValueAt(i, this.modeloFornecedores.findColumn("C\u00f3digo"))).intValue()) continue;
                return;
            }
            this.modeloFornecedores.addLine(new Object[]{bean.getEntidade().getCodigo(), bean.getEntidade().getFantasia(), bean.getVendedor(), bean.getFormaPagamento() == null ? "" : bean.getFormaPagamento().getDescricao(), bean.getPrazoEntrega(), Funcoes.formataDecimal(bean.getValorDesconto() == null ? 0.0 : bean.getValorDesconto()), Funcoes.formataDecimal(bean.getValorTotal() == null ? 0.0 : bean.getValorTotal()), bean});
            if (this.modeloFornecedores.getColunaOrdenacao() != -1) {
                this.modeloFornecedores.ordenarColunaSemTrocarSentido(this.modeloFornecedores.getColunaOrdenacao());
            } else {
                this.modeloFornecedores.ordenarColunaSemTrocarSentido(this.modeloFornecedores.findColumn("Fantasia"));
            }
        }
    }

    private void adicionarMaterialFornecedor(CotacaoMaterialEntidadeBean cotMaterialEntidade) {
        if (cotMaterialEntidade != null) {
            for (int i = 0; i < this.modeloFornecedores.getRowCount(); ++i) {
                this.listaMateriaisFornecedores.add(cotMaterialEntidade);
            }
        }
    }

    private void mostrarMateriaisFornecedor(CotacaoEntidadeBean cotEntidade) {
        if (cotEntidade != null) {
            if (cotEntidade.getEntidade() == null) {
                return;
            }
            this.modeloMateriais.clear();
            for (int i = 0; i < this.listaMateriaisFornecedores.size(); ++i) {
                CotacaoMaterialEntidadeBean cotMatEnt = this.listaMateriaisFornecedores.get(i);
                if (cotMatEnt == null || cotMatEnt.getCotacaoEntidade() == null || cotMatEnt.getCotacaoEntidade().getEntidade() == null || cotMatEnt.getCotacaoEntidade().getEntidade().getCodigo().intValue() != cotEntidade.getEntidade().getCodigo().intValue()) continue;
                this.adicionarMaterial(cotMatEnt);
            }
        }
    }

    private void adicionarMaterial(CotacaoMaterialEntidadeBean cotMatEnt) {
        if (cotMatEnt != null) {
            MaterialVO material = cotMatEnt.getCotacaoMaterial().getMaterial();
            for (int i = 0; i < this.modeloMateriais.getRowCount(); ++i) {
                if (material.getCodigo().intValue() != ((Integer)this.modeloMateriais.getValueAt(i, this.modeloMateriais.findColumn("C\u00f3digo"))).intValue()) continue;
                return;
            }
            this.modeloMateriais.addLine(new Object[]{material.getCodigo(), material.getDescricao(), Funcoes.formataDecimal(cotMatEnt.getQuantidade() == null ? cotMatEnt.getCotacaoMaterial().getQuantidade() : cotMatEnt.getQuantidade()), material.getUnidadeMedida().getCodigo(), cotMatEnt.getValorUnitario() == null ? "" : Funcoes.formataDecimal("###,##0.00##", cotMatEnt.getValorUnitario()), cotMatEnt.getValorDesconto() == null ? "" : Funcoes.formataDecimal(cotMatEnt.getValorDesconto()), cotMatEnt.getPercentualDesconto() == null ? "" : Funcoes.formataDecimal(cotMatEnt.getPercentualDesconto()), cotMatEnt.getValorTotal() == null ? "" : Funcoes.formataDecimal("###,##0.00##", cotMatEnt.getValorTotal()), cotMatEnt.getSituacao() == null ? "" : Tipos.situacaoMaterialFornecedor(cotMatEnt.getSituacao()), cotMatEnt});
            if (this.modeloMateriais.getColunaOrdenacao() != -1) {
                this.modeloMateriais.ordenarColunaSemTrocarSentido(this.modeloMateriais.getColunaOrdenacao());
            } else {
                this.modeloMateriais.ordenarColunaSemTrocarSentido(this.modeloMateriais.findColumn("Material"));
            }
        }
    }

    @Override
    public String getRetornoParaPesquisa() {
        return "";
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return null;
    }

    class ButtonEditor
    extends DefaultCellEditor {
        private JButton button;
        private int linha;
        private final int COLUNA_CODIGO = 0;
        private final int COLUNA_DESCRICAO = 1;

        public ButtonEditor() {
            super(new JCheckBox());
            this.linha = -1;
            this.COLUNA_CODIGO = 0;
            this.COLUNA_DESCRICAO = 1;
            this.button = new JButton();
            this.button.setOpaque(true);
            Funcoes.imagemPesquisa(this.button);
            this.button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ButtonEditor.this.fireEditingStopped();
                }
            });
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (isSelected) {
                this.button.setForeground(table.getSelectionForeground());
                this.button.setBackground(table.getSelectionBackground());
            } else {
                this.button.setForeground(table.getForeground());
                this.button.setBackground(table.getBackground());
            }
            this.linha = row;
            return this.button;
        }

        @Override
        public Object getCellEditorValue() {
            if (this.linha > -1) {
                String material = FinalizarCotacao.this.modeloMateriais.getValueAt(this.linha, 0).toString();
                String descricao = FinalizarCotacao.this.modeloMateriais.getValueAt(this.linha, 1).toString();
                JanelaHistoricoCotacao hist = JanelaHistoricoCotacao.novaInstancia(FinalizarCotacao.this.getTopLevelAncestor(), material, descricao, FinalizarCotacao.this.textCotacao.getText());
                if (hist != null) {
                    hist.setVisible(true);
                }
            }
            return null;
        }

        @Override
        public boolean stopCellEditing() {
            this.linha = -1;
            return super.stopCellEditing();
        }

        @Override
        protected void fireEditingStopped() {
            super.fireEditingStopped();
        }
    }

    class ButtonRenderer
    extends JButton
    implements TableCellRenderer {
        public ButtonRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(UIManager.getColor("Button.background"));
            }
            Funcoes.imagemPesquisa(this);
            return this;
        }
    }

    class FornecedorRenderer
    extends DefaultTableCellRenderer {
        @Override
        public synchronized Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focused, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, value, selected, focused, row, column);
            this.setValue(value);
            if (selected) {
                this.setForeground(table.getSelectionForeground());
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            if (FinalizarCotacao.this.modeloFornecedores.getValueAt(row, FinalizarCotacao.this.modeloFornecedores.findColumn("Objeto")) != null) {
                CotacaoEntidadeBean entidade = (CotacaoEntidadeBean)FinalizarCotacao.this.modeloFornecedores.getValueAt(row, FinalizarCotacao.this.modeloFornecedores.findColumn("Objeto"));
                if (entidade != null && entidade.getSituacao() != null && entidade.getSituacao().equalsIgnoreCase("V")) {
                    c.setBackground(COR_VENCEDOR);
                }
                if (selected && c.getBackground() != table.getSelectionBackground()) {
                    c.setBackground(ScreenUtil.escurecerCor(c.getBackground(), 30));
                }
            }
            if (focused) {
                Border border = selected ? UIManager.getBorder("Table.focusSelectedCellHighlightBorder") : UIManager.getBorder("Table.focusCellHighlightBorder");
                ((JComponent)c).setBorder(border);
                if (!selected && table.isCellEditable(row, column)) {
                    Color col = UIManager.getColor("Table.focusCellForeground");
                    if (col != null) {
                        c.setForeground(col);
                    }
                    if ((col = UIManager.getColor("Table.focusCellBackground")) != null) {
                        c.setBackground(col);
                    }
                }
            } else {
                ((JComponent)c).setBorder(noFocusBorder);
            }
            return c;
        }
    }
}

