/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.estoque.cotacao;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.dados.DadosMaterial;
import jalis.comum.padroes.FrmCadPadrao;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.cadastro.VisualizarMateriaisAlternativos;
import jalis.laboratorio.estoque.DialogoFiltroMateriais;
import jalis.laboratorio.estoque.cotacao.DialogAlteracaoQuantidade;
import jalis.laboratorio.relatorios.estoque.cotacao.RelatorioCotacao;
import jalis.laboratorio.resultados.ImpressaoResultados;
import jalis.laboratorio.util.EmailUtil;
import jalis.laboratorio.util.impressao.Impressao;
import jalis.model.AbstractThreadBean;
import jalis.model.bean.cadastro.EntidadeBean;
import jalis.model.bean.cadastro.FilialBean;
import jalis.model.bean.cadastro.exame.LayoutBean;
import jalis.model.bean.configuracao.UsuarioBean;
import jalis.model.bean.estoque.CotacaoBean;
import jalis.model.bean.estoque.CotacaoEntidadeBean;
import jalis.model.bean.estoque.CotacaoMaterialBean;
import jalis.model.bean.estoque.CotacaoMaterialEntidadeBean;
import jalis.model.bean.estoque.MaterialBean;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.EntidadeVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.model.vo.cadastro.exame.ExameMatColetaVO;
import jalis.model.vo.cadastro.exame.MetodologiaVO;
import jalis.model.vo.estoque.CotacaoEntidadeVO;
import jalis.model.vo.estoque.CotacaoMaterialVO;
import jalis.model.vo.estoque.CotacaoVO;
import jalis.model.vo.estoque.MaterialVO;
import jalis.relatorio.gerador.Relatorio;
import jalis.service.cadastro.EntidadeService;
import jalis.service.estoque.CotacaoService;
import jalis.service.estoque.MaterialService;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.SplashMensagem;
import jalis.util.TTextAreaDocument;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AbrirCotacao
extends FrmCadPadrao {
    private JButton buttonBuscaMaterial = new JButton();
    private JButton buttonBuscaFornecedores = new JButton();
    private JButton buttonOk = new JButton("OK");
    private JButton buttonOkFornecedores = new JButton("OK");
    private JButton buttonAbrirCotacao = new JButton("Abrir Cota\u00e7\u00e3o");
    private JButton buttonOpcoes = new JButton("Op\u00e7\u00f5es \u25bc");
    private JPopupMenu menuOpcoes = new JPopupMenu();
    private JMenuItem menuEnviarEmail = new JMenuItem("Enviar e-mail de cotac\u00e3o");
    private JLabel labelAux1 = new JLabel();
    private JLabel labelAux2 = new JLabel();
    private JLabel labelAux3 = new JLabel();
    private JLabel labelAux4 = new JLabel();
    private JLabel labelData = new JLabel("Data:");
    private JLabel labelSituacao = new JLabel("Situa\u00e7\u00e3o:");
    private JLabel labelDescricaoMaterial = new JLabel();
    private JLabel labelDescricaoFornecedores = new JLabel();
    private JLabel labelMaterial = new JLabel("Material");
    private JLabel labelQuantidade = new JLabel("Qtde.");
    private JLabel labelUnidade = new JLabel("Unidade");
    private JLabel labelUsuario = new JLabel("Usu\u00e1rio:");
    private JLabel labelCodigo = new JLabel("C\u00f3digo:");
    private JLabel labelFornecedores = new JLabel("Fornecedor:");
    private JLabel labelVlrData = new JLabel();
    private JLabel labelVlrUnidade = new JLabel();
    private JLabel labelVlrUsuario = new JLabel();
    private JLabel labelVlrCodigo = new JLabel();
    private JLabel labelVlrSituacao = new JLabel();
    private JPanel panelCabecalho = new JPanel(new GridBagLayout());
    private JPanel panelObservacao = new JPanel(new GridBagLayout());
    private JPanel panelMateriais = new JPanel(new GridBagLayout());
    private JPanel panelFornecedores = new JPanel(new GridBagLayout());
    private JScrollPane scrollMateriais;
    private JScrollPane scrollFornecedores;
    private JScrollPane scrollObservacao;
    private TTextField textMaterial = new TTextField(18, 3);
    private TTextField textFornecedores = new TTextField(8, 1);
    private TTextField textQuantidade = new TTextField(10, 2);
    private JTextArea textObservacao = new JTextArea(new TTextAreaDocument(500));
    private ModeloGridTable modeloMateriais;
    private ModeloGridTable modeloFornecedores;
    private JTable tableMateriais;
    private JTable tableFornecedores;
    private MaterialBean materialAux = null;
    private EntidadeBean fornecedorAux = null;
    private Date dataHoraCriacao = null;
    private CotacaoBean cotacaoAux = null;
    private Date dataHoraAbertura = null;
    private ArrayList<CotacaoMaterialEntidadeBean> listaMatEnt = null;
    public static long ACESSO_ABRIR_COTACAO = Long.parseLong("1200100202");
    public static long ACESSO_REMOVER_MATERIAL_COM_PRECO = Long.parseLong("1200100203");
    public static long ACESSO_REMOVER_FORNECEDOR_COM_PRECO = Long.parseLong("1200100204");
    private String retornoParaPesquisa = "";
    private ArrayList<String> listaEmail = new ArrayList();
    private boolean isEnviandoEmail = false;

    public AbrirCotacao() {
        Funcoes.criaBarraDescricao(this, "Abrir Cota\u00e7\u00e3o", "Inicia a cota\u00e7\u00e3o de materiais", "estoque/abrir_cotacao.jpg");
        ScreenUtil.setBorda(new Component[]{this.labelVlrUsuario, this.labelVlrData, this.labelDescricaoMaterial, this.labelVlrUnidade, this.labelVlrCodigo, this.labelDescricaoFornecedores, this.labelVlrSituacao}, new TitledBorder(""));
        this.botaoExcluir.setVisible(false);
        Funcoes.imagemPesquisa(this.buttonBuscaMaterial);
        Funcoes.imagemPesquisa(this.buttonBuscaFornecedores);
        this.painelBotoes.removeAll();
        this.buttonAbrirCotacao.setMnemonic('A');
        this.painelBotoes.add(this.buttonOpcoes);
        this.painelBotoes.add(this.buttonAbrirCotacao);
        this.painelBotoes.add(this.botaoNovo);
        this.painelBotoes.add(this.botaoEditar);
        this.painelBotoes.add(this.botaoSalvar);
        this.painelBotoes.add(this.botaoCancelar);
        this.painelBotoes.add(this.botaoFechar);
        this.menuOpcoes.add(this.menuEnviarEmail);
        this.painelCentral.setLayout(new GridBagLayout());
        this.buttonOpcoes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbrirCotacao.this.menuOpcoes.show(AbrirCotacao.this.buttonOpcoes.getParent(), AbrirCotacao.this.buttonOpcoes.getX(), AbrirCotacao.this.buttonOpcoes.getY() + AbrirCotacao.this.buttonOpcoes.getHeight());
            }
        });
        this.menuEnviarEmail.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbrirCotacao.this.enviaEmailCotacao();
            }
        });
        this.buttonAbrirCotacao.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int resp = Funcoes.mensagem(AbrirCotacao.this, "Deseja abrir a cota\u00e7\u00e3o?", 4);
                if (resp == 0) {
                    AbrirCotacao.this.labelVlrSituacao.setText(Tipos.tipoCotacao("A"));
                    AbrirCotacao.this.dataHoraAbertura = new Date();
                    AbrirCotacao.this.buttonAbrirCotacao.setEnabled(false);
                }
            }
        });
        this.textMaterial.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (Funcoes.textoVazio(AbrirCotacao.this.textMaterial)) {
                    return;
                }
                MaterialBean bean = null;
                try {
                    bean = (MaterialBean)new MaterialService().getAtivo(Variaveis.filialPadrao, AbrirCotacao.this.textMaterial.getText(), null, null);
                }
                catch (Exception e1) {
                    AbrirCotacao.this.labelDescricaoMaterial.setText("N\u00e3o cadastrado");
                    AbrirCotacao.this.materialAux = null;
                    return;
                }
                if (bean == null) {
                    bean = VisualizarMateriaisAlternativos.getTelaMaterialAlternativo(bean, AbrirCotacao.this.textMaterial);
                }
                if (bean != null) {
                    AbrirCotacao.this.textMaterial.setText(bean.getCodigo().toString());
                    AbrirCotacao.this.labelDescricaoMaterial.setText(bean.getDescricao());
                    AbrirCotacao.this.labelVlrUnidade.setText(bean.getUnidadeMedida().getCodigo());
                    AbrirCotacao.this.materialAux = bean;
                    if (AbrirCotacao.this.textQuantidade.isEnabled() && AbrirCotacao.this.textQuantidade.isFocusable()) {
                        ScreenUtil.requisitarFoco(AbrirCotacao.this.textQuantidade);
                    }
                } else {
                    AbrirCotacao.this.labelDescricaoMaterial.setText("N\u00e3o cadastrado");
                    AbrirCotacao.this.materialAux = null;
                }
            }
        });
        this.textFornecedores.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (Funcoes.textoVazio(AbrirCotacao.this.textFornecedores)) {
                    return;
                }
                EntidadeBean entidade = null;
                try {
                    entidade = (EntidadeBean)new EntidadeService().get(Variaveis.filialPadrao, AbrirCotacao.this.textFornecedores.getText());
                }
                catch (Exception e1) {
                    AbrirCotacao.this.labelDescricaoFornecedores.setText("N\u00e3o cadastrado");
                    AbrirCotacao.this.fornecedorAux = null;
                    return;
                }
                if (entidade != null && entidade.getTipo().equalsIgnoreCase("F")) {
                    AbrirCotacao.this.labelDescricaoFornecedores.setText(entidade.getFantasia());
                    AbrirCotacao.this.fornecedorAux = entidade;
                    if (AbrirCotacao.this.buttonOkFornecedores.isEnabled()) {
                        ScreenUtil.requisitarFoco(AbrirCotacao.this.buttonOkFornecedores);
                    }
                } else {
                    AbrirCotacao.this.labelDescricaoFornecedores.setText("N\u00e3o cadastrado");
                    AbrirCotacao.this.fornecedorAux = null;
                }
            }
        });
        this.buttonBuscaMaterial.setFocusable(false);
        this.buttonBuscaMaterial.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    List<HashMap<String, Object>> materiais = null;
                    DialogoFiltroMateriais diag = new DialogoFiltroMateriais(Laboratorio.getInstancia());
                    diag.setVisible(true);
                    if (diag.getOk() && (materiais = diag.getMateriaisSelecionados()) != null) {
                        Iterator<HashMap<String, Object>> it = materiais.iterator();
                        if (materiais.size() > 0) {
                            SplashMensagem janelaEspera = SplashMensagem.getInstancia(AbrirCotacao.this);
                            janelaEspera.mostrar("Adicionando materiais");
                            int i = 0;
                            int qtde = materiais.size();
                            while (it.hasNext()) {
                                HashMap<String, Object> reg = it.next();
                                janelaEspera.setText("Adicionando materiais - " + (int)Funcoes.arredondar(++i * 100 / qtde, 2) + "%");
                                MaterialBean material = (MaterialBean)new MaterialService().getAtivo(Variaveis.filialPadrao, String.valueOf(reg.get("C\u00f3digo")), null, null);
                                Double auxQtde = Double.parseDouble(Funcoes.limpaDecimal(reg.get("Qtde.").toString()));
                                if (material == null) continue;
                                AbrirCotacao.this.adicionarMaterial(material, auxQtde);
                            }
                            janelaEspera.apagar();
                        }
                    }
                }
                catch (Exception e1) {
                    Funcoes.mensagem(AbrirCotacao.this, "N\u00e3o foi poss\u00edvel adicionar materiais.", 2);
                }
            }
        });
        this.buttonBuscaFornecedores.setFocusable(false);
        this.buttonBuscaFornecedores.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EntidadeVO entidade = (EntidadeVO)new EntidadeService().pesquisaVO(Laboratorio.getInstancia(), new EntidadeVO(), "Pesquisando Fornecedores", false, "F");
                if (entidade != null) {
                    EntidadeBean bean = null;
                    try {
                        bean = (EntidadeBean)new EntidadeService().get(Variaveis.filialPadrao, String.valueOf(entidade.getCodigo()));
                    }
                    catch (Exception e1) {
                        ErrorLogger.mostraMensagem(AbrirCotacao.this, "N\u00e3o foi poss\u00edvel buscar dados do fornecedor.\n" + e1.getMessage(), e1.getStackTrace());
                        return;
                    }
                    if (bean != null) {
                        AbrirCotacao.this.textFornecedores.setText(String.valueOf(bean.getCodigo()));
                        AbrirCotacao.this.labelDescricaoFornecedores.setText(bean.getFantasia());
                        AbrirCotacao.this.fornecedorAux = bean;
                    } else {
                        AbrirCotacao.this.textFornecedores.setText("");
                        AbrirCotacao.this.labelDescricaoFornecedores.setText("");
                        AbrirCotacao.this.fornecedorAux = null;
                    }
                    if (AbrirCotacao.this.buttonOkFornecedores.isFocusable() && AbrirCotacao.this.buttonOkFornecedores.isEnabled()) {
                        ScreenUtil.requisitarFoco(AbrirCotacao.this.buttonOkFornecedores);
                    }
                }
            }
        });
        this.buttonOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Funcoes.textoVazio(AbrirCotacao.this.textMaterial)) {
                    ScreenUtil.requisitarFoco(AbrirCotacao.this.textMaterial);
                    return;
                }
                if (Funcoes.textoVazio(AbrirCotacao.this.textQuantidade)) {
                    Funcoes.mensagem(AbrirCotacao.this, "A quantidade n\u00e3o foi informada.", 2);
                    if (AbrirCotacao.this.textQuantidade.isEnabled() && AbrirCotacao.this.textQuantidade.isFocusable()) {
                        ScreenUtil.requisitarFoco(AbrirCotacao.this.textQuantidade);
                    }
                    return;
                }
                if (Double.valueOf(AbrirCotacao.this.textQuantidade.getText()) <= 0.0) {
                    Funcoes.mensagem(AbrirCotacao.this, "A quantidade informada deve ser maior que zero.", 2);
                    if (AbrirCotacao.this.textQuantidade.isEnabled() && AbrirCotacao.this.textQuantidade.isFocusable()) {
                        ScreenUtil.requisitarFoco(AbrirCotacao.this.textQuantidade);
                    }
                    return;
                }
                if (AbrirCotacao.this.materialAux != null) {
                    AbrirCotacao.this.adicionarMaterial(AbrirCotacao.this.materialAux, Double.parseDouble(AbrirCotacao.this.textQuantidade.getText()));
                }
                AbrirCotacao.this.textMaterial.setText("");
                AbrirCotacao.this.labelDescricaoMaterial.setText("");
                AbrirCotacao.this.materialAux = null;
                if (AbrirCotacao.this.textMaterial.isEnabled() && AbrirCotacao.this.textMaterial.isFocusable()) {
                    ScreenUtil.requisitarFoco(AbrirCotacao.this.textQuantidade);
                }
            }
        });
        this.buttonOkFornecedores.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AbrirCotacao.this.fornecedorAux != null) {
                    FilialVO filial = new FilialVO();
                    filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
                    AbrirCotacao.this.listaEmail.add(AbrirCotacao.this.fornecedorAux.getEmail());
                    CotacaoEntidadeBean entidade = new CotacaoEntidadeBean();
                    entidade.setFilial(filial);
                    entidade.setEntidade((EntidadeVO)AbrirCotacao.this.fornecedorAux.toVO());
                    entidade.setSituacao("A");
                    AbrirCotacao.this.adicionarFornecedor(entidade);
                }
                AbrirCotacao.this.textFornecedores.setText("");
                AbrirCotacao.this.labelDescricaoFornecedores.setText("");
                AbrirCotacao.this.fornecedorAux = null;
                if (AbrirCotacao.this.textFornecedores.isEnabled() && AbrirCotacao.this.textFornecedores.isFocusable()) {
                    ScreenUtil.requisitarFoco(AbrirCotacao.this.textFornecedores);
                }
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.panelCabecalho.add((Component)this.labelCodigo, gridBagConstraints);
        this.labelVlrCodigo.setHorizontalAlignment(4);
        this.labelVlrCodigo.setMinimumSize(new Dimension(60, 20));
        this.labelVlrCodigo.setPreferredSize(new Dimension(60, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.panelCabecalho.add((Component)this.labelVlrCodigo, gridBagConstraints);
        this.labelAux3.setMinimumSize(new Dimension(20, 20));
        this.labelAux3.setPreferredSize(new Dimension(20, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.panelCabecalho.add((Component)this.labelAux3, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        this.panelCabecalho.add((Component)this.labelUsuario, gridBagConstraints);
        this.labelVlrUsuario.setMinimumSize(new Dimension(90, 20));
        this.labelVlrUsuario.setPreferredSize(new Dimension(90, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.panelCabecalho.add((Component)this.labelVlrUsuario, gridBagConstraints);
        this.labelAux1.setMinimumSize(new Dimension(20, 20));
        this.labelAux1.setPreferredSize(new Dimension(20, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.panelCabecalho.add((Component)this.labelAux1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.panelCabecalho.add((Component)this.labelData, gridBagConstraints);
        this.labelVlrData.setMinimumSize(new Dimension(150, 20));
        this.labelVlrData.setPreferredSize(new Dimension(150, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.panelCabecalho.add((Component)this.labelVlrData, gridBagConstraints);
        this.labelAux4.setMinimumSize(new Dimension(20, 20));
        this.labelAux4.setPreferredSize(new Dimension(20, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.panelCabecalho.add((Component)this.labelAux4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.panelCabecalho.add((Component)this.labelSituacao, gridBagConstraints);
        this.labelVlrSituacao.setMinimumSize(new Dimension(100, 20));
        this.labelVlrSituacao.setPreferredSize(new Dimension(100, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.panelCabecalho.add((Component)this.labelVlrSituacao, gridBagConstraints);
        this.labelAux2.setMinimumSize(new Dimension(20, 20));
        this.labelAux2.setPreferredSize(new Dimension(20, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.panelCabecalho.add((Component)this.labelAux2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 2, 1);
        this.painelCentral.add((Component)this.panelCabecalho, gridBagConstraints);
        this.panelMateriais.setBorder(BorderFactory.createTitledBorder("Materiais"));
        this.panelFornecedores.setBorder(BorderFactory.createTitledBorder("Fornecedores"));
        this.modeloMateriais = new ModeloGridTable(new String[]{"C\u00f3digo", "Material", "Quantidade", "Unidade", "MaterialEntidade", "Objeto"}){

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                Object[] classes = new Object[]{Integer.class, String.class, Object.class, String.class, MaterialBean.class};
                return (Class)classes[columnIndex];
            }

            @Override
            public void fireTableStructureChanged() {
                super.fireTableStructureChanged();
                try {
                    if (AbrirCotacao.this.tableMateriais != null) {
                        AbrirCotacao.this.tableMateriais.removeColumn(AbrirCotacao.this.tableMateriais.getColumn("Objeto"));
                        AbrirCotacao.this.tableMateriais.removeColumn(AbrirCotacao.this.tableMateriais.getColumn("MaterialEntidade"));
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                try {
                    AbrirCotacao.this.tableMateriais.removeColumn(AbrirCotacao.this.tableMateriais.getColumn("Objeto"));
                    AbrirCotacao.this.tableMateriais.removeColumn(AbrirCotacao.this.tableMateriais.getColumn("MaterialEntidade"));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        };
        this.modeloFornecedores = new ModeloGridTable(new String[]{"C\u00f3digo", "Fantasia", "MaterialEntidade", "Objeto"}){

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                Object[] classes = new Object[]{Integer.class, String.class, Double.class, String.class, MaterialBean.class};
                return (Class)classes[columnIndex];
            }

            @Override
            public void fireTableStructureChanged() {
                super.fireTableStructureChanged();
                try {
                    if (AbrirCotacao.this.tableFornecedores != null) {
                        AbrirCotacao.this.tableFornecedores.removeColumn(AbrirCotacao.this.tableFornecedores.getColumn("Objeto"));
                        AbrirCotacao.this.tableFornecedores.removeColumn(AbrirCotacao.this.tableFornecedores.getColumn("MaterialEntidade"));
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                try {
                    AbrirCotacao.this.tableFornecedores.removeColumn(AbrirCotacao.this.tableFornecedores.getColumn("Objeto"));
                    AbrirCotacao.this.tableFornecedores.removeColumn(AbrirCotacao.this.tableFornecedores.getColumn("MaterialEntidade"));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        };
        this.tableMateriais = new JTable(this.modeloMateriais);
        this.tableMateriais.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127) {
                    if (AbrirCotacao.this.getStatus() == 2 || AbrirCotacao.this.getStatus() == 3) {
                        AbrirCotacao.this.removerMaterialSelecionado();
                    }
                } else if (e.getKeyCode() == 32 && (AbrirCotacao.this.getStatus() == 2 || AbrirCotacao.this.getStatus() == 3)) {
                    AbrirCotacao.this.alteraQuantidadeMaterial();
                }
            }
        });
        this.tableMateriais.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
            }
        });
        this.tableMateriais.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && (AbrirCotacao.this.getStatus() == 2 || AbrirCotacao.this.getStatus() == 3)) {
                    AbrirCotacao.this.alteraQuantidadeMaterial();
                }
            }
        });
        this.modeloMateriais.setColumnSize(new int[]{70, 0, 90, 70, 0, 0}, this.tableMateriais);
        this.tableMateriais.getTableHeader().addMouseListener(this.modeloMateriais);
        this.tableMateriais.removeColumn(this.tableMateriais.getColumn("Objeto"));
        this.tableMateriais.removeColumn(this.tableMateriais.getColumn("MaterialEntidade"));
        this.scrollMateriais = new JScrollPane(this.tableMateriais);
        this.tableFornecedores = new JTable(this.modeloFornecedores);
        this.tableFornecedores.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127 && (AbrirCotacao.this.getStatus() == 2 || AbrirCotacao.this.getStatus() == 3)) {
                    AbrirCotacao.this.removerFornecedorSelecionado();
                }
            }
        });
        this.tableFornecedores.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
            }
        });
        this.modeloFornecedores.setColumnSize(new int[]{70, 0, 0, 0}, this.tableFornecedores);
        this.tableFornecedores.getTableHeader().addMouseListener(this.modeloFornecedores);
        this.tableFornecedores.removeColumn(this.tableFornecedores.getColumn("Objeto"));
        this.tableFornecedores.removeColumn(this.tableFornecedores.getColumn("MaterialEntidade"));
        this.scrollFornecedores = new JScrollPane(this.tableFornecedores);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 9;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 1, 1, 1);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 0;
        this.panelMateriais.add((Component)this.scrollMateriais, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.labelMaterial.setDisplayedMnemonic('M');
        this.labelMaterial.setLabelFor(this.textMaterial);
        this.panelMateriais.add((Component)this.labelMaterial, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        this.labelQuantidade.setDisplayedMnemonic('Q');
        this.labelQuantidade.setLabelFor(this.textQuantidade);
        this.panelMateriais.add((Component)this.labelQuantidade, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        this.panelMateriais.add((Component)this.labelUnidade, gridBagConstraints);
        this.textMaterial.setMinimumSize(new Dimension(70, 20));
        this.textMaterial.setPreferredSize(new Dimension(70, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.panelMateriais.add((Component)this.textMaterial, gridBagConstraints);
        this.buttonBuscaMaterial.setMinimumSize(new Dimension(20, 20));
        this.buttonBuscaMaterial.setPreferredSize(new Dimension(20, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.panelMateriais.add((Component)this.buttonBuscaMaterial, gridBagConstraints);
        this.labelDescricaoMaterial.setMinimumSize(new Dimension(200, 20));
        this.labelDescricaoMaterial.setPreferredSize(new Dimension(200, 20));
        this.labelDescricaoMaterial.setRequestFocusEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        this.panelMateriais.add((Component)this.labelDescricaoMaterial, gridBagConstraints);
        this.textQuantidade.setMinimumSize(new Dimension(90, 20));
        this.textQuantidade.setPreferredSize(new Dimension(90, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        this.panelMateriais.add((Component)this.textQuantidade, gridBagConstraints);
        this.labelVlrUnidade.setMinimumSize(new Dimension(50, 20));
        this.labelVlrUnidade.setPreferredSize(new Dimension(50, 20));
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        this.panelMateriais.add((Component)this.labelVlrUnidade, gridBagConstraints);
        this.buttonOk.setMargin(new Insets(1, 1, 1, 1));
        this.buttonOk.setMinimumSize(new Dimension(30, 20));
        this.buttonOk.setPreferredSize(new Dimension(30, 20));
        this.buttonOk.setMnemonic('O');
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        this.panelMateriais.add((Component)this.buttonOk, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.painelCentral.add((Component)this.panelMateriais, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 9;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 1, 1, 1);
        this.panelFornecedores.add((Component)this.scrollFornecedores, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.labelFornecedores.setDisplayedMnemonic('r');
        this.labelFornecedores.setLabelFor(this.textFornecedores);
        this.panelFornecedores.add((Component)this.labelFornecedores, gridBagConstraints);
        this.textFornecedores.setMinimumSize(new Dimension(70, 20));
        this.textFornecedores.setPreferredSize(new Dimension(70, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.panelFornecedores.add((Component)this.textFornecedores, gridBagConstraints);
        this.buttonBuscaFornecedores.setMinimumSize(new Dimension(20, 20));
        this.buttonBuscaFornecedores.setPreferredSize(new Dimension(20, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.panelFornecedores.add((Component)this.buttonBuscaFornecedores, gridBagConstraints);
        this.labelDescricaoFornecedores.setMinimumSize(new Dimension(200, 20));
        this.labelDescricaoFornecedores.setPreferredSize(new Dimension(200, 20));
        this.labelDescricaoFornecedores.setRequestFocusEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.panelFornecedores.add((Component)this.labelDescricaoFornecedores, gridBagConstraints);
        this.buttonOkFornecedores.setMargin(new Insets(1, 1, 1, 1));
        this.buttonOkFornecedores.setMinimumSize(new Dimension(30, 20));
        this.buttonOkFornecedores.setPreferredSize(new Dimension(30, 20));
        this.buttonOkFornecedores.setMnemonic('K');
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.panelFornecedores.add((Component)this.buttonOkFornecedores, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.6;
        this.painelCentral.add((Component)this.panelFornecedores, gridBagConstraints);
        this.panelObservacao.setBorder(BorderFactory.createTitledBorder("Observa\u00e7\u00e3o"));
        this.scrollObservacao = new JScrollPane(this.textObservacao);
        this.scrollObservacao.setMinimumSize(new Dimension(100, 50));
        this.scrollObservacao.setPreferredSize(new Dimension(100, 50));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.panelObservacao.add((Component)this.scrollObservacao, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.painelCentral.add((Component)this.panelObservacao, gridBagConstraints);
        this.controlaCampos();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enviaEmailCotacao() {
        block9: {
            this.isEnviandoEmail = true;
            this.salvar();
            if (this.modeloFornecedores.getRowCount() <= 0) break block9;
            for (int i = 0; i < this.modeloFornecedores.getRowCount(); ++i) {
                Statement st;
                block8: {
                    CotacaoEntidadeBean cotacaoBean = (CotacaoEntidadeBean)this.modeloFornecedores.getValueAt(i, 3);
                    final EntidadeVO entidade = cotacaoBean.getEntidade();
                    String emailEnviar = entidade.getEmail();
                    if (Funcoes.textoVazio(emailEnviar)) {
                        Funcoes.mensagem(this, "Fornecedor n\u00e3o possui e-mail para envio.\n" + entidade.getFantasia(), 2);
                        continue;
                    }
                    st = Conexao.getStatement();
                    try {
                        RelatorioCotacao rel = new RelatorioCotacao(0);
                        ModeloGridTable modelo = rel.getModeloDados(st, this.labelVlrCodigo.getText(), String.valueOf(entidade.getCodigo()));
                        if (modelo == null) break block8;
                        Relatorio relatorio = new Relatorio(modelo, null, ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                        relatorio.setConfiguracao(rel.getXMLRelatorio(st));
                        relatorio.gerarRelatorio();
                        final byte[] pdf = ImpressaoResultados.imprimirPdf(relatorio, relatorio.getFormatoPagina(), relatorio.getQuantidadePaginas());
                        Thread threadEnvio = new Thread(){

                            @Override
                            public void run() {
                                try {
                                    Map<String, String> mapsStatusEnvio = EmailUtil.criaLogEmailCotacao(entidade, pdf, EmailUtil.TipoEmail.COTACAO_FORNECEDOR, true, Conexao.getStatement(), AbrirCotacao.this.labelVlrCodigo.getText());
                                    if (mapsStatusEnvio.get("status").equals("sucesso")) {
                                        Funcoes.mensagem(AbrirCotacao.this, "E-mail enviado com sucesso.", 5);
                                    } else {
                                        Funcoes.mensagem(AbrirCotacao.this, mapsStatusEnvio.get("status"), 1);
                                    }
                                }
                                catch (Exception e) {
                                    ErrorLogger.mostraMensagem(AbrirCotacao.this, "N\u00e3o foi poss\u00edvel enviar e-mail da proposta.\n" + e.getMessage(), null);
                                    return;
                                }
                            }
                        };
                        threadEnvio.start();
                    }
                    catch (Exception e) {
                        try {
                            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel enviar e-mail.\n" + e.getMessage(), e.getStackTrace());
                        }
                        catch (Throwable throwable) {
                            Conexao.fecharStatement(st);
                            throw throwable;
                        }
                        Conexao.fecharStatement(st);
                    }
                }
                Conexao.fecharStatement(st);
                try {
                    Thread.sleep(200L);
                    continue;
                }
                catch (InterruptedException e) {
                    ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel enviar e-mail.\n" + e.getMessage(), e.getStackTrace());
                }
            }
        }
        this.isEnviandoEmail = false;
    }

    private ModeloGridTable geraModeloCotacao(FilialBean filial, UsuarioBean usuarioLogado, LayoutBean layout) throws SQLException {
        if (layout == null || layout != null && Funcoes.textoVazio(layout.getProposta())) {
            Funcoes.mensagem(this, "Modelo de proposta n\u00e3o definido.", 1);
            return null;
        }
        for (int i = 0; i < this.tableMateriais.getRowCount(); ++i) {
            ExameMatColetaVO examePai = (ExameMatColetaVO)this.tableMateriais.getValueAt(i, this.tableMateriais.getColumnCount());
            MetodologiaVO metodologia = ParametrosGerais.getPrecoMetodologia() ? (MetodologiaVO)this.tableMateriais.getValueAt(i, 1) : examePai.getMetodologia();
            DadosMaterial dadosMaterial = ExameUtil.getDadosMaterial(examePai.getFilial().getCodigo().toString(), examePai.getMaterial().getCodigo());
        }
        ModeloGridTable modeloImpressao = new ModeloGridTable(Impressao.CAMPOS_PROPOSTA);
        return modeloImpressao;
    }

    private void alteraQuantidadeMaterial() {
        if (this.modeloMateriais.getRowCount() > 0 && this.tableMateriais.getSelectedRow() > -1) {
            int linha = this.tableMateriais.getSelectedRow();
            int coluna = this.modeloMateriais.findColumn("Quantidade");
            Double quantidade = Double.parseDouble(Funcoes.limpaDecimal((String)this.modeloMateriais.getValueAt(linha, coluna)));
            quantidade = this.mostraDialogAlteracaoQuantidade(quantidade);
            this.modeloMateriais.setValueAt(Funcoes.formataDecimal(quantidade), linha, coluna);
        }
    }

    private Double mostraDialogAlteracaoQuantidade(Double valorAntigo) {
        DialogAlteracaoQuantidade diag = new DialogAlteracaoQuantidade(valorAntigo);
        return diag.getNovoValor() == null ? valorAntigo : diag.getNovoValor();
    }

    private void removerFornecedorSelecionado() {
        int resp;
        String msg = "";
        if (this.modeloFornecedores.getRowCount() > 0 && new Boolean(this.modeloFornecedores.getValueAt(this.tableFornecedores.getSelectedRow(), this.modeloFornecedores.findColumn("MaterialEntidade")).toString()).booleanValue()) {
            if (Acesso.getAcesso(ACESSO_REMOVER_FORNECEDOR_COM_PRECO)) {
                msg = "H\u00e1 materiais desse fornecedor com pre\u00e7o definido.\n";
            } else {
                Funcoes.mensagem(this, "N\u00e3o \u00e9 poss\u00edvel remover o fornecedor, pois h\u00e1 materiais desse fornecedor com pre\u00e7o definido.", 2);
                return;
            }
        }
        if ((resp = Funcoes.mensagem(this, msg = msg + "Deseja remover o fornecedor?", 4)) == 0) {
            int row = this.tableFornecedores.getSelectedRow();
            CotacaoEntidadeBean beanCotEnt = (CotacaoEntidadeBean)this.modeloFornecedores.getValueAt(row, this.modeloFornecedores.findColumn("Objeto"));
            this.modeloFornecedores.removeLine(row);
            if (beanCotEnt != null) {
                for (int i = 0; i < this.listaMatEnt.size(); ++i) {
                    CotacaoMaterialEntidadeBean beanEntMat = this.listaMatEnt.get(i);
                    if (beanEntMat.getCotacaoEntidade().getEntidade().getCodigo().intValue() != beanCotEnt.getEntidade().getCodigo().intValue()) continue;
                    this.listaMatEnt.remove(i);
                    --i;
                }
            }
        }
        this.controlaCampos();
    }

    private void removerMaterialSelecionado() {
        int resp;
        String msg = "";
        if (this.modeloMateriais.getRowCount() > 0 && this.tableMateriais.getSelectedRow() > 0 && new Boolean(this.modeloMateriais.getValueAt(this.tableMateriais.getSelectedRow(), this.modeloMateriais.findColumn("MaterialEntidade")).toString()).booleanValue()) {
            if (Acesso.getAcesso(ACESSO_REMOVER_MATERIAL_COM_PRECO)) {
                msg = "O pre\u00e7o do material j\u00e1 foi definido.\n";
            } else {
                Funcoes.mensagem(this, "N\u00e3o \u00e9 poss\u00edvel remover o material, pois o pre\u00e7o do mesmo j\u00e1 foi definido.", 2);
                return;
            }
        }
        if ((resp = Funcoes.mensagem(this, msg = msg + "Deseja remover o material?", 4)) == 0) {
            int row = this.tableMateriais.getSelectedRow();
            MaterialBean beanMat = (MaterialBean)this.modeloMateriais.getValueAt(row, this.modeloMateriais.findColumn("Objeto"));
            this.modeloMateriais.removeLine(row);
            if (beanMat != null && this.listaMatEnt != null) {
                for (int i = 0; i < this.listaMatEnt.size(); ++i) {
                    CotacaoMaterialEntidadeBean beanEntMat = this.listaMatEnt.get(i);
                    if (beanEntMat.getCotacaoMaterial().getMaterial().getCodigo().intValue() != beanMat.getCodigo().intValue()) continue;
                    this.listaMatEnt.remove(i);
                    --i;
                }
            }
        }
        this.controlaCampos();
    }

    private void controlaCampos() {
        boolean habilitar = this.getStatus() == 2 || this.getStatus() == 3;
        this.textMaterial.setEnabled(habilitar);
        this.buttonBuscaMaterial.setEnabled(habilitar);
        this.textQuantidade.setEnabled(habilitar);
        this.buttonOk.setEnabled(habilitar);
        this.textObservacao.setEnabled(habilitar);
        this.textFornecedores.setEnabled(habilitar);
        this.buttonBuscaFornecedores.setEnabled(habilitar);
        this.buttonOkFornecedores.setEnabled(habilitar);
        this.buttonOpcoes.setEnabled(habilitar);
        if (habilitar && this.labelVlrSituacao.getText().equalsIgnoreCase(Tipos.tipoCotacao("S")) && Acesso.getAcesso(ACESSO_ABRIR_COTACAO)) {
            this.buttonAbrirCotacao.setEnabled(true);
        } else {
            this.buttonAbrirCotacao.setEnabled(false);
        }
    }

    private void adicionarFornecedor(CotacaoEntidadeBean bean) {
        if (bean != null) {
            for (int i = 0; i < this.modeloFornecedores.getRowCount(); ++i) {
                if (bean.getEntidade().getCodigo().intValue() != ((Integer)this.modeloFornecedores.getValueAt(i, this.modeloFornecedores.findColumn("C\u00f3digo"))).intValue()) continue;
                return;
            }
            this.modeloFornecedores.addLine(new Object[]{bean.getEntidade().getCodigo(), bean.getEntidade().getFantasia(), this.fornecedorTemPreco(bean.getEntidade()), bean});
            if (this.modeloFornecedores.getColunaOrdenacao() != -1) {
                this.modeloFornecedores.ordenarColunaSemTrocarSentido(this.modeloFornecedores.getColunaOrdenacao());
            } else {
                this.modeloFornecedores.ordenarColunaSemTrocarSentido(this.modeloFornecedores.findColumn("Fantasia"));
            }
            this.textFornecedores.setText("");
        }
    }

    private void adicionarMaterial(MaterialBean bean, Double quantidade) {
        if (bean != null) {
            for (int i = 0; i < this.modeloMateriais.getRowCount(); ++i) {
                if (bean.getCodigo().intValue() != ((Integer)this.modeloMateriais.getValueAt(i, this.modeloMateriais.findColumn("C\u00f3digo"))).intValue()) continue;
                return;
            }
            this.modeloMateriais.addLine(new Object[]{bean.getCodigo(), bean.getDescricao(), Funcoes.formataDecimal(quantidade), bean.getUnidadeMedida().getCodigo(), this.materialTemPreco(bean), bean});
            if (this.modeloMateriais.getColunaOrdenacao() != -1) {
                this.modeloMateriais.ordenarColunaSemTrocarSentido(this.modeloMateriais.getColunaOrdenacao());
            } else {
                this.modeloMateriais.ordenarColunaSemTrocarSentido(this.modeloMateriais.findColumn("Material"));
            }
            this.textMaterial.setText("");
            this.textQuantidade.setText("");
            this.labelVlrUnidade.setText("");
        }
        this.controlaCampos();
    }

    private boolean materialTemPreco(MaterialBean bean) {
        if (this.cotacaoAux == null) {
            return false;
        }
        HashSet matEnt = (HashSet)this.cotacaoAux.getMaterialEntidadeCotacao();
        for (CotacaoMaterialEntidadeBean aux : matEnt) {
            if (aux.getCotacaoMaterial().getMaterial().getCodigo().intValue() != bean.getCodigo().intValue() || aux.getSituacao().equalsIgnoreCase("C")) continue;
            return true;
        }
        return false;
    }

    private boolean fornecedorTemPreco(EntidadeVO entidade) {
        if (this.cotacaoAux == null) {
            return false;
        }
        HashSet matEnt = (HashSet)this.cotacaoAux.getMaterialEntidadeCotacao();
        for (CotacaoMaterialEntidadeBean aux : matEnt) {
            if (aux.getCotacaoEntidade().getEntidade().getCodigo().intValue() != entidade.getCodigo().intValue() || aux.getSituacao().equalsIgnoreCase("C")) continue;
            return true;
        }
        return false;
    }

    public void limparCampos() {
        this.labelVlrCodigo.setText("");
        this.labelVlrUsuario.setText("");
        this.labelVlrData.setText("");
        this.textMaterial.setText("");
        this.labelDescricaoMaterial.setText("");
        this.textQuantidade.setText("");
        this.labelVlrUnidade.setText("");
        this.textObservacao.setText("");
        this.textFornecedores.setText("");
        this.labelVlrSituacao.setText("");
        this.modeloMateriais.clear();
        this.modeloFornecedores.clear();
        this.dataHoraCriacao = null;
        this.cotacaoAux = null;
        this.dataHoraAbertura = null;
        this.listaMatEnt = null;
    }

    @Override
    public void cancelar() {
        if (Funcoes.mensagem(this, "As informa\u00e7\u00f5es adicionadas ser\u00e3o perdidas.", 4) == 0) {
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    private void preencherCampos(CotacaoBean cotacao) {
        if (cotacao != null) {
            this.labelVlrCodigo.setText(String.valueOf(cotacao.getCodigo()));
            this.labelVlrUsuario.setText(cotacao.getUsuario().getCodigo());
            this.dataHoraCriacao = cotacao.getDataHora();
            this.labelVlrData.setText(Funcoes.formataData("dd/MM/yyyy HH:mm:ss", cotacao.getDataHora()));
            this.labelVlrSituacao.setText(Tipos.tipoCotacao(cotacao.getSituacao()));
            this.textObservacao.setText(cotacao.getObservacao());
            if (cotacao.getMateriaisCotacao() != null) {
                Set<CotacaoMaterialBean> materais = cotacao.getMateriaisCotacao();
                for (CotacaoMaterialBean material : materais) {
                    MaterialBean beanMaterial = null;
                    try {
                        beanMaterial = (MaterialBean)new MaterialService().getTodos(String.valueOf(material.getFilial().getCodigo()), String.valueOf(material.getMaterial().getCodigo()), null, null);
                    }
                    catch (Exception e) {
                        Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel carregar dados do material. C\u00f3d. Material: " + material.getMaterial().getCodigo(), 2);
                        continue;
                    }
                    this.adicionarMaterial(beanMaterial, material.getQuantidade());
                }
            }
            if (cotacao.getEntidadesCotacao() != null) {
                Set<CotacaoEntidadeBean> entidades = cotacao.getEntidadesCotacao();
                for (CotacaoEntidadeBean entidade : entidades) {
                    this.adicionarFornecedor(entidade);
                }
            }
            this.listaMatEnt = new ArrayList<CotacaoMaterialEntidadeBean>(cotacao.getMaterialEntidadeCotacao());
        }
    }

    @Override
    public void editar() {
        this.limparCampos();
        this.cotacaoAux = (CotacaoBean)this.pesquisar();
        if (this.cotacaoAux != null) {
            this.preencherCampos(this.cotacaoAux);
            this.setStatus(1);
            if (this.cotacaoAux.getSituacao() != null && (this.cotacaoAux.getSituacao().equalsIgnoreCase("A") || this.cotacaoAux.getSituacao().equalsIgnoreCase("S"))) {
                this.setStatus(3);
            }
            this.controlaCampos();
            if (this.textMaterial.isEnabled() && this.textMaterial.isFocusable()) {
                ScreenUtil.requisitarFoco(this.textMaterial);
            }
        }
    }

    private AbstractThreadBean pesquisar() {
        CotacaoService service = new CotacaoService();
        try {
            AbstractThreadVO vo = service.pesquisaVO((Object)this.getTopLevelAncestor(), (AbstractThreadVO)new CotacaoVO(), "Pesquisando Cota\u00e7\u00f5es", new String[]{"S", "A", "F", "C"});
            if (vo != null) {
                SplashMensagem janelaEspera = SplashMensagem.getInstancia(this);
                janelaEspera.mostrar("Carregando cota\u00e7\u00e3o");
                CotacaoBean cotacaoBean = (CotacaoBean)service.get(String.valueOf(((CotacaoVO)vo).getFilial().getCodigo()), String.valueOf(((CotacaoVO)vo).getCodigo()));
                janelaEspera.apagar();
                return cotacaoBean;
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar dados da cota\u00e7\u00e3o.\n" + e.getMessage(), e.getStackTrace());
        }
        return null;
    }

    @Override
    @Deprecated
    public void excluir() {
    }

    @Override
    public void fechar() {
        if (this.getStatus() == 1 || Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setVisible(false);
        }
    }

    @Override
    public void novo() {
        this.limparCampos();
        this.setStatus(2);
        this.controlaCampos();
        this.labelVlrUsuario.setText(Variaveis.login);
        this.dataHoraCriacao = new Date();
        this.labelVlrData.setText(Funcoes.formataData("dd/MM/yyyy HH:mm:ss", this.dataHoraCriacao));
        this.labelVlrSituacao.setText(Tipos.tipoCotacao("A"));
        if (this.textMaterial.isEnabled() && this.textMaterial.isFocusable()) {
            ScreenUtil.requisitarFoco(this.textMaterial);
        }
    }

    protected String getCopiaFiliais() {
        return null;
    }

    private CotacaoBean getBeanPreenchido() {
        AbstractThreadBean entidade;
        CotacaoBean cotacao = null;
        cotacao = this.cotacaoAux != null ? this.cotacaoAux : new CotacaoBean();
        FilialVO filial = new FilialVO();
        filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
        UsuarioVO usuario = new UsuarioVO();
        usuario.setCodigo(Variaveis.login);
        if (!Funcoes.textoVazio(this.labelVlrCodigo.getText())) {
            cotacao.setCodigo(Integer.parseInt(this.labelVlrCodigo.getText()));
        }
        cotacao.setFilial(filial);
        cotacao.setDataHora(this.dataHoraCriacao);
        cotacao.setObservacao(this.textObservacao.getText());
        cotacao.setSituacao(Tipos.getTipoCotacao(this.labelVlrSituacao.getText()));
        cotacao.setUsuario(usuario);
        cotacao.setDataAbertura(this.dataHoraAbertura);
        HashSet<CotacaoMaterialBean> materiais = new HashSet<CotacaoMaterialBean>();
        for (int i = 0; i < this.modeloMateriais.getRowCount(); ++i) {
            CotacaoMaterialBean material = new CotacaoMaterialBean();
            material.setFilial(filial);
            material.setMaterial((MaterialVO)((MaterialBean)this.modeloMateriais.getValueAt(i, this.modeloMateriais.findColumn("Objeto"))).toVO());
            material.setQuantidade(Double.parseDouble(Funcoes.limpaDecimal((String)this.modeloMateriais.getValueAt(i, this.modeloMateriais.findColumn("Quantidade")))));
            materiais.add(material);
        }
        if (materiais.size() > 0) {
            cotacao.setMateriaisCotacao(materiais);
        }
        HashSet<CotacaoEntidadeBean> entidades = new HashSet<CotacaoEntidadeBean>();
        for (int i = 0; i < this.modeloFornecedores.getRowCount(); ++i) {
            entidade = (CotacaoEntidadeBean)this.modeloFornecedores.getValueAt(i, this.modeloFornecedores.findColumn("Objeto"));
            entidades.add((CotacaoEntidadeBean)entidade);
        }
        if (entidades.size() > 0) {
            cotacao.setEntidadesCotacao(entidades);
        }
        if (this.listaMatEnt == null) {
            this.listaMatEnt = new ArrayList();
        }
        Iterator<CotacaoEntidadeBean> itEnt = entidades.iterator();
        while (itEnt.hasNext()) {
            entidade = (CotacaoEntidadeVO)itEnt.next().toVO();
            Iterator<CotacaoMaterialBean> itMat = materiais.iterator();
            while (itMat.hasNext()) {
                CotacaoMaterialVO matAux = (CotacaoMaterialVO)itMat.next().toVO();
                boolean jaExiste = false;
                CotacaoMaterialEntidadeBean aux = null;
                for (int i = 0; i < this.listaMatEnt.size(); ++i) {
                    aux = this.listaMatEnt.get(i);
                    if (aux.getCotacaoEntidade().getEntidade().getCodigo().intValue() != ((CotacaoEntidadeVO)entidade).getEntidade().getCodigo().intValue() || aux.getCotacaoMaterial().getMaterial().getCodigo().intValue() != matAux.getMaterial().getCodigo().intValue()) continue;
                    jaExiste = true;
                    break;
                }
                if (!jaExiste) {
                    CotacaoMaterialEntidadeBean matEnt = new CotacaoMaterialEntidadeBean();
                    matEnt.setCotacaoMaterial(matAux);
                    matEnt.setCotacao((CotacaoVO)cotacao.toVO());
                    matEnt.setFilial(filial);
                    matEnt.setCotacaoEntidade((CotacaoEntidadeVO)entidade);
                    matEnt.setPercentualDesconto(0.0);
                    matEnt.setQuantidade(matAux.getQuantidade());
                    matEnt.setSituacao("");
                    matEnt.setTipoDesconto("P");
                    matEnt.setValorDesconto(0.0);
                    matEnt.setValorTotal(0.0);
                    matEnt.setValorUnitario(0.0);
                    matEnt.setSituacao("C");
                    this.listaMatEnt.add(matEnt);
                    continue;
                }
                aux.setQuantidade(matAux.getQuantidade());
            }
        }
        if (this.listaMatEnt.size() > 0) {
            cotacao.setMaterialEntidadeCotacao(new HashSet<CotacaoMaterialEntidadeBean>(this.listaMatEnt));
        }
        return cotacao;
    }

    @Override
    public void salvar() {
        CotacaoBean bean;
        CotacaoService service = new CotacaoService();
        if (this.validaCampos() && (bean = this.getBeanPreenchido()) != null) {
            try {
                service.gravaAutoCopiaSemCommit(bean, this.getStatus() == 2 ? 0 : 1, Variaveis.filialPadrao, this.getCopiaFiliais());
                Conexao.arquivaSQL();
                if (this.getStatus() == 2) {
                    Funcoes.mensagem(this, "Cota\u00e7\u00e3o gerada com o c\u00f3digo: " + bean.getCodigo() + ".", 5);
                    this.labelVlrCodigo.setText(String.valueOf(bean.getCodigo()));
                }
                this.retornoParaPesquisa = bean.getCodigo().toString();
                if (!this.isEnviandoEmail) {
                    this.limparCampos();
                    this.setStatus(1);
                    this.controlaCampos();
                } else {
                    this.setStatus(3);
                }
            }
            catch (Exception e) {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                Funcoes.mensagem(this.getTopLevelAncestor(), "N\u00e3o foi poss\u00edvel salvar cota\u00e7\u00e3o.", 2);
            }
        }
    }

    @Override
    public boolean validaCampos() {
        if (Funcoes.textoVazio(this.labelVlrUsuario.getText())) {
            return false;
        }
        if (Funcoes.textoVazio(this.labelVlrData.getText())) {
            return false;
        }
        if (this.modeloMateriais.getRowCount() <= 0) {
            Funcoes.mensagem(this, "N\u00e3o \u00e9 poss\u00edvel salvar, pois n\u00e3o h\u00e1 nenhum material na solicita\u00e7\u00e3o.", 2);
            return false;
        }
        if (this.modeloFornecedores.getRowCount() <= 0) {
            Funcoes.mensagem(this, "N\u00e3o \u00e9 poss\u00edvel salvar, pois n\u00e3o h\u00e1 nenhum fornecedor na solicita\u00e7\u00e3o.", 2);
            return false;
        }
        for (int i = 0; i < this.modeloMateriais.getRowCount(); ++i) {
            Double valor = Double.parseDouble(Funcoes.limpaDecimal((String)this.modeloMateriais.getValueAt(i, this.modeloMateriais.findColumn("Quantidade"))));
            if (!(valor <= 0.0)) continue;
            Funcoes.mensagem(this, "A quantidade do material: " + this.modeloMateriais.getValueAt(i, this.modeloMateriais.findColumn("Material")) + "\n deve ser maior que zero.", 2);
            return false;
        }
        return true;
    }

    public static long getModuloAcesso() {
        return Long.parseLong("1200100200");
    }

    @Override
    public void pressioneiF2() {
        if (this.textMaterial.hasFocus()) {
            this.buttonBuscaMaterial.doClick();
        } else if (this.textFornecedores.hasFocus()) {
            this.buttonBuscaFornecedores.doClick();
        }
    }

    @Override
    public String getRetornoParaPesquisa() {
        return this.retornoParaPesquisa;
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return "cot_codigo";
    }
}

