/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.estoque.almoxarifado;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmPadrao;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.cadastro.DadosPatrimonio;
import jalis.laboratorio.cadastro.Patrimonio;
import jalis.laboratorio.cadastro.VisualizarMateriaisAlternativos;
import jalis.laboratorio.estoque.DialogoFiltroMateriais;
import jalis.laboratorio.estoque.SolicitarLoteMaterial;
import jalis.laboratorio.estoque.VisualizaLoteEntrada;
import jalis.model.bean.estoque.CelulaEstoqueBean;
import jalis.model.bean.estoque.LancamentoEstoqueBean;
import jalis.model.bean.estoque.MaterialBean;
import jalis.model.bean.estoque.MaterialLoteBean;
import jalis.model.bean.estoque.MaterialPatrimonioBean;
import jalis.model.bean.estoque.NotaFiscalMaterialBean;
import jalis.model.bean.estoque.RequisicaoEstoqueBean;
import jalis.model.bean.estoque.RequisicaoEstoqueMaterialBean;
import jalis.model.bean.estoque.SaldoEstoqueCelulaBean;
import jalis.model.bean.estoque.TransfEstoqueBean;
import jalis.model.bean.estoque.TransfEstoqueMaterialBean;
import jalis.model.bean.estoque.TransfEstoqueMaterialPatrimonioBean;
import jalis.model.bean.financeiro.NotaFiscalBean;
import jalis.model.dao.financeiro.NotaFiscalDao;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.model.vo.estoque.CelulaEstoqueVO;
import jalis.model.vo.estoque.MaterialPatrimonioVO;
import jalis.model.vo.estoque.MaterialVO;
import jalis.model.vo.estoque.RequisicaoEstoqueVO;
import jalis.model.vo.estoque.TransfEstoqueVO;
import jalis.model.vo.financeiro.NotaFiscalVO;
import jalis.service.estoque.CelulaEstoqueService;
import jalis.service.estoque.MaterialPatrimonioService;
import jalis.service.estoque.MaterialService;
import jalis.service.estoque.NotaFiscalMaterialService;
import jalis.service.estoque.RequisicaoEstoqueMaterialService;
import jalis.service.estoque.RequisicaoEstoqueService;
import jalis.service.estoque.SaldoEstoqueCelulaService;
import jalis.service.estoque.TransfEstoqueMaterialPatrimonioService;
import jalis.service.estoque.TransfEstoqueService;
import jalis.service.financeiro.NotaFiscalService;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.SplashMensagem;
import jalis.util.TAvisoLabel;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;

public class TransferenciaEstoque
extends FrmPadrao
implements ActionListener {
    private JButton buttonBuscaDestino = ComponenteFactory.novoJButton(this, true);
    private JButton buttonBuscaMaterial = ComponenteFactory.novoJButton(this, true);
    private JButton buttonBuscaOrigem = ComponenteFactory.novoJButton(this, true);
    private JButton buttonCancelar;
    private JButton buttonFechar;
    private JButton buttonNovo;
    private JButton buttonOK;
    private JButton buttonTransferir;
    private JButton buttonImportar = ComponenteFactory.novoJButton(this, false);
    private TAvisoLabel labelDescDestino;
    private TAvisoLabel labelDescOrigem;
    private JLabel labelDescMaterial;
    private JLabel labelDestino;
    private JLabel labelMaterial;
    private JLabel labelOrigem;
    private JLabel labelQuantidade;
    private JLabel labelData = new JLabel("Data:");
    private JLabel labelVlrData = new JLabel();
    private JLabel labelUsuario = new JLabel("Usu\u00e1rio:");
    private JLabel labelVlrUsuario = new JLabel();
    private JPanel panelBotoes;
    private JPanel panelCentro;
    private JPanel panelMaterial;
    private JPanel panelLegenda;
    private JScrollPane scrollMaterial;
    private JTable tabelaMaterial;
    private ModeloGridTable modeloMaterial = null;
    private TTextField textCodigoDestino = new TTextField(5, 1);
    private TTextField textCodigoMaterial = new TTextField(18, 3);
    private TTextField textCodigoOrigem = new TTextField(5, 1);
    private TTextField textQuantidade = new TTextField(10, 2);
    private JPopupMenu menuMaterial = new JPopupMenu();
    private JMenuItem itemAlterar = new JMenuItem("Alterar");
    private JMenuItem itemConfigurarPatrimonios = new JMenuItem("Configurar Patrim\u00f4nios");
    private JPopupMenu menuImportar = new JPopupMenu();
    private JMenuItem itemRequisicao = new JMenuItem("Importar Requisi\u00e7\u00e3o");
    private JMenuItem itemNotaFiscalEntrada = new JMenuItem("Importar Nota Fiscal de Entrada");
    private int status = 1;
    private boolean isAlterando = false;
    private CelulaEstoqueVO celulaOrigemAux = null;
    private CelulaEstoqueVO celulaDestinoAux = null;
    private RequisicaoEstoqueVO requisicaoAux = null;
    private Date dataAux = null;
    private UsuarioVO usuarioAux = null;
    private RequisicaoEstoqueMaterialService requisicaoEstoqueMaterialService = new RequisicaoEstoqueMaterialService();
    private RequisicaoEstoqueService requisicaoEstoqueService = new RequisicaoEstoqueService();
    private Set<MaterialSobraFaltaImportacao> materiaSobraFaltaImportacoes = new HashSet<MaterialSobraFaltaImportacao>();
    private static final int COLUNA_CODIGO = 0;
    private static final int COLUNA_DESCRICAO = 1;
    private static final int COLUNA_SALDO = 2;
    private static final int COLUNA_QUANTIDADE = 3;
    private static final int COLUNA_LANCAMENTO = 4;
    private static final int COLUNA_OBJETOMATERIAL = 5;
    private static final int COLUNA_DADOSPATRIMONIO = 6;
    private static final int COLUNA_IMPORTACAO = 7;
    private static final int COLUNA_CODIGO_REQUISICAO = 8;
    private static final Color COR_SOLICITA_PATRIMONIO = ScreenUtil.clarearCor(Color.YELLOW, 125);
    private final ImageIcon IMAGEM_BAIXA_AUTOMATICA = ImagemUtils.carregaImagemJalis("baixaautomatica.png");

    public TransferenciaEstoque() {
        this.montaTela();
        this.controlaCampos();
    }

    private void montaTela() {
        this.setLayout(new BorderLayout());
        ScreenUtil.setBorda(new Component[]{this.labelVlrData, this.labelVlrUsuario}, new TitledBorder(""));
        this.panelCentro = new JPanel();
        this.labelOrigem = new JLabel();
        this.labelOrigem.setDisplayedMnemonic('O');
        this.labelOrigem.setLabelFor(this.textCodigoOrigem);
        this.labelDestino = new JLabel();
        this.labelDestino.setDisplayedMnemonic('D');
        this.labelDestino.setLabelFor(this.textCodigoDestino);
        this.panelMaterial = new JPanel();
        this.labelMaterial = new JLabel();
        this.labelMaterial.setDisplayedMnemonic('M');
        this.labelMaterial.setLabelFor(this.textCodigoMaterial);
        this.labelQuantidade = new JLabel();
        this.labelQuantidade.setDisplayedMnemonic('Q');
        this.labelQuantidade.setLabelFor(this.textQuantidade);
        this.buttonOK = new JButton("OK");
        this.buttonOK.setMnemonic('K');
        this.labelDescMaterial = new JLabel();
        this.tabelaMaterial = null;
        this.scrollMaterial = new JScrollPane(this.tabelaMaterial);
        this.labelDescOrigem = new TAvisoLabel();
        this.labelDescDestino = new TAvisoLabel();
        this.panelBotoes = new JPanel();
        this.buttonNovo = ComponenteFactory.novoJButton("Novo", 'N', this);
        this.buttonTransferir = ComponenteFactory.novoJButton("Transferir", 'T', this);
        this.buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this);
        this.buttonFechar = ComponenteFactory.novoJButton("Fechar", 'F', this);
        this.buttonImportar.setMnemonic('I');
        this.labelDescDestino.setHorizontalTextPosition(2);
        this.labelDescDestino.setImagem(this.IMAGEM_BAIXA_AUTOMATICA);
        this.labelDescDestino.setAviso(null);
        this.panelCentro.setBorder(ScreenUtil.criarBordaVazia());
        this.setLayout(new BorderLayout());
        this.add((Component)this.panelCentro, "Center");
        Funcoes.criaBarraDescricao(this, "Transfer\u00eancia entre estoques", "Transfer\u00eancia de materiais entre c\u00e9lulas de estoque", "estoque/transferencia_entre_estoques.jpg");
        this.panelCentro.setLayout(new GridBagLayout());
        Funcoes.montaEnter((JComponent)this.panelCentro);
        this.textCodigoDestino.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (e.getSource() == TransferenciaEstoque.this.textCodigoDestino) {
                    TransferenciaEstoque.this.saidaCampoCelula(TransferenciaEstoque.this.textCodigoDestino, TransferenciaEstoque.this.labelDescDestino);
                }
            }
        });
        this.textCodigoOrigem.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (e.getSource() == TransferenciaEstoque.this.textCodigoOrigem) {
                    TransferenciaEstoque.this.saidaCampoCelula(TransferenciaEstoque.this.textCodigoOrigem, TransferenciaEstoque.this.labelDescOrigem);
                }
            }
        });
        this.textCodigoMaterial.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!(e.getOppositeComponent() instanceof JButton) && e.getSource() == TransferenciaEstoque.this.textCodigoMaterial) {
                    if (Funcoes.textoVazio(TransferenciaEstoque.this.textCodigoMaterial.getText())) {
                        return;
                    }
                    MaterialBean material = null;
                    try {
                        material = (MaterialBean)new MaterialService().getAtivo(Variaveis.filialPadrao, TransferenciaEstoque.this.textCodigoMaterial.getText(), null, null);
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                        TransferenciaEstoque.this.labelDescMaterial.setText("N\u00e3o cadastrado");
                        return;
                    }
                    if (material == null) {
                        material = VisualizarMateriaisAlternativos.getTelaMaterialAlternativo(material, TransferenciaEstoque.this.textCodigoMaterial);
                    }
                    if (material != null) {
                        TransferenciaEstoque.this.textCodigoMaterial.setText(material.getCodigo().toString());
                        TransferenciaEstoque.this.labelDescMaterial.setText(material.getDescricao());
                    } else {
                        TransferenciaEstoque.this.labelDescMaterial.setText("N\u00e3o cadastrado");
                    }
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
                TransferenciaEstoque.this.controlaCampos();
            }
        });
        this.modeloMaterial = new ModeloGridTable(new String[]{"C\u00f3digo", "Material", "Estoque", "Quantidade", "Objeto", "ObjetoMaterial", "Patrimonios"}){

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return super.getColumnClass(columnIndex);
            }

            @Override
            public void fireTableStructureChanged() {
                super.fireTableStructureChanged();
                try {
                    if (TransferenciaEstoque.this.tabelaMaterial != null) {
                        TransferenciaEstoque.this.tabelaMaterial.removeColumn(TransferenciaEstoque.this.tabelaMaterial.getColumn("Objeto"));
                        TransferenciaEstoque.this.tabelaMaterial.removeColumn(TransferenciaEstoque.this.tabelaMaterial.getColumn("ObjetoMaterial"));
                        TransferenciaEstoque.this.tabelaMaterial.removeColumn(TransferenciaEstoque.this.tabelaMaterial.getColumn("Patrimonios"));
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                try {
                    TransferenciaEstoque.this.tabelaMaterial.removeColumn(TransferenciaEstoque.this.tabelaMaterial.getColumn("Objeto"));
                    TransferenciaEstoque.this.tabelaMaterial.removeColumn(TransferenciaEstoque.this.tabelaMaterial.getColumn("ObjetoMaterial"));
                    TransferenciaEstoque.this.tabelaMaterial.removeColumn(TransferenciaEstoque.this.tabelaMaterial.getColumn("Patrimonios"));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        };
        this.tabelaMaterial = new JTable(this.modeloMaterial);
        this.tabelaMaterial.removeColumn(this.tabelaMaterial.getColumn("Objeto"));
        this.tabelaMaterial.removeColumn(this.tabelaMaterial.getColumn("ObjetoMaterial"));
        this.tabelaMaterial.removeColumn(this.tabelaMaterial.getColumn("Patrimonios"));
        this.tabelaMaterial.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
            }
        });
        this.tabelaMaterial.getTableHeader().addMouseListener(this.modeloMaterial);
        this.scrollMaterial = new JScrollPane(this.tabelaMaterial);
        this.modeloMaterial.setColumnSize(new int[]{70, 0, 100, 100, 0, 0, 0}, this.tabelaMaterial);
        EstoqueRenderer renderer = new EstoqueRenderer();
        this.tabelaMaterial.setDefaultRenderer(Object.class, renderer);
        this.tabelaMaterial.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int row;
                if (TransferenciaEstoque.this.tabelaMaterial.getSelectedRow() > -1 && e.getKeyCode() == 127 && Funcoes.mensagem(TransferenciaEstoque.this, "Deseja excluir o registro selecionado?", 4) == 0) {
                    TransferenciaEstoque.this.modeloMaterial.removeLine(TransferenciaEstoque.this.tabelaMaterial.getSelectedRow());
                    TransferenciaEstoque.this.textCodigoMaterial.grabFocus();
                    TransferenciaEstoque.this.controlaCampos();
                } else if (e.getKeyCode() == 32 && (row = TransferenciaEstoque.this.tabelaMaterial.getSelectedRow()) >= 0) {
                    MaterialBean material = (MaterialBean)TransferenciaEstoque.this.modeloMaterial.getValueAt(row, TransferenciaEstoque.this.modeloMaterial.findColumn("ObjetoMaterial"));
                    if (material.getSolicitarPatrimonio() != null && material.getSolicitarPatrimonio().booleanValue() && material.getImobilizado() != null && material.getImobilizado().booleanValue()) {
                        TransferenciaEstoque.this.abrirPopup();
                    } else {
                        TransferenciaEstoque.this.alterarMaterial();
                    }
                }
            }
        });
        this.buttonOK.addActionListener(this);
        this.tabelaMaterial.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int row;
                if (e.getClickCount() == 1) {
                    TransferenciaEstoque.this.isAlterando = false;
                    TransferenciaEstoque.this.textCodigoMaterial.clear();
                    TransferenciaEstoque.this.labelDescMaterial.setText("");
                    TransferenciaEstoque.this.textQuantidade.clear();
                } else if (e.getClickCount() == 2 && (row = TransferenciaEstoque.this.tabelaMaterial.getSelectedRow()) >= 0) {
                    MaterialBean material = (MaterialBean)TransferenciaEstoque.this.modeloMaterial.getValueAt(row, TransferenciaEstoque.this.modeloMaterial.findColumn("ObjetoMaterial"));
                    if (material != null && material.getSolicitarPatrimonio() != null && material.getSolicitarPatrimonio().booleanValue() && material.getImobilizado() != null && material.getImobilizado().booleanValue()) {
                        TransferenciaEstoque.this.abrirPopup();
                    } else {
                        TransferenciaEstoque.this.alterarMaterial();
                    }
                }
                TransferenciaEstoque.this.controlaCampos();
            }
        });
        this.menuMaterial.add(this.itemAlterar);
        this.menuMaterial.add(this.itemConfigurarPatrimonios);
        this.menuImportar.add(this.itemRequisicao);
        this.menuImportar.add(this.itemNotaFiscalEntrada);
        this.itemAlterar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TransferenciaEstoque.this.alterarMaterial();
            }
        });
        this.itemConfigurarPatrimonios.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LancamentoEstoqueBean lanctoBean;
                MaterialBean beanMat;
                ArrayList dadosPatrimonio;
                int row = TransferenciaEstoque.this.tabelaMaterial.getSelectedRow();
                TransferenciaEstoque.this.isAlterando = true;
                if (row >= 0 && (dadosPatrimonio = TransferenciaEstoque.this.configurarPatrimonios(beanMat = (MaterialBean)TransferenciaEstoque.this.modeloMaterial.getValueAt(row, TransferenciaEstoque.this.modeloMaterial.findColumn("ObjetoMaterial")), (lanctoBean = (LancamentoEstoqueBean)TransferenciaEstoque.this.modeloMaterial.getValueAt(row, TransferenciaEstoque.this.modeloMaterial.findColumn("Objeto"))).getQuantidade())) != null) {
                    TransferenciaEstoque.this.modeloMaterial.setValueAt(dadosPatrimonio, row, TransferenciaEstoque.this.modeloMaterial.findColumn("Patrimonios"));
                }
                TransferenciaEstoque.this.isAlterando = false;
            }
        });
        this.itemRequisicao.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TransferenciaEstoque.this.importar();
            }
        });
        this.itemNotaFiscalEntrada.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TransferenciaEstoque.this.importarNotaFiscal();
            }
        });
        this.labelVlrData.setMinimumSize(new Dimension(150, 20));
        this.labelVlrData.setPreferredSize(new Dimension(150, 20));
        this.labelVlrData.setMaximumSize(new Dimension(150, 20));
        this.labelVlrUsuario.setMinimumSize(new Dimension(90, 20));
        this.labelVlrUsuario.setPreferredSize(new Dimension(90, 20));
        this.labelVlrUsuario.setMaximumSize(new Dimension(90, 20));
        JPanel panelCabecalho = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 0, 0, 0);
        panelCabecalho.add((Component)this.labelData, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets = new Insets(1, 0, 0, 20);
        panelCabecalho.add((Component)this.labelVlrData, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets = new Insets(1, 0, 0, 0);
        panelCabecalho.add((Component)this.labelUsuario, gridBagConstraints);
        ++gridBagConstraints.gridx;
        panelCabecalho.add((Component)this.labelVlrUsuario, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        panelCabecalho.add((Component)new JLabel(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 0, 10, 0);
        gridBagConstraints.gridwidth = 4;
        this.panelCentro.add((Component)panelCabecalho, gridBagConstraints);
        this.labelOrigem.setText("C\u00e9lula Origem:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 0, 0, 0);
        gridBagConstraints.gridy = 1;
        this.panelCentro.add((Component)this.labelOrigem, gridBagConstraints);
        this.labelDestino.setText("C\u00e9lula Destino:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.panelCentro.add((Component)this.labelDestino, gridBagConstraints);
        this.panelMaterial.setBorder(BorderFactory.createTitledBorder("Materiais"));
        this.panelMaterial.setLayout(new GridBagLayout());
        this.labelMaterial.setText("Material");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.panelMaterial.add((Component)this.labelMaterial, gridBagConstraints);
        this.labelQuantidade.setText("Quantidade");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.panelMaterial.add((Component)this.labelQuantidade, gridBagConstraints);
        this.buttonBuscaMaterial.setMaximumSize(new Dimension(20, 20));
        this.buttonBuscaMaterial.setMinimumSize(new Dimension(20, 20));
        this.buttonBuscaMaterial.setPreferredSize(new Dimension(20, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.panelMaterial.add((Component)this.buttonBuscaMaterial, gridBagConstraints);
        this.buttonOK.setMaximumSize(new Dimension(40, 20));
        this.buttonOK.setMinimumSize(new Dimension(40, 20));
        this.buttonOK.setPreferredSize(new Dimension(40, 20));
        this.buttonOK.setMargin(new Insets(1, 1, 1, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.panelMaterial.add((Component)this.buttonOK, gridBagConstraints);
        this.labelDescMaterial.setBorder(BorderFactory.createTitledBorder(""));
        this.labelDescMaterial.setPreferredSize(new Dimension(24, 20));
        this.labelDescMaterial.setMinimumSize(new Dimension(24, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.panelMaterial.add((Component)this.labelDescMaterial, gridBagConstraints);
        this.textCodigoMaterial.setMaximumSize(new Dimension(70, 20));
        this.textCodigoMaterial.setMinimumSize(new Dimension(70, 20));
        this.textCodigoMaterial.setPreferredSize(new Dimension(70, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.panelMaterial.add((Component)this.textCodigoMaterial, gridBagConstraints);
        this.textQuantidade.setMaximumSize(new Dimension(80, 20));
        this.textQuantidade.setMinimumSize(new Dimension(80, 20));
        this.textQuantidade.setPreferredSize(new Dimension(80, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.panelMaterial.add((Component)this.textQuantidade, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panelMaterial.add((Component)this.scrollMaterial, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panelCentro.add((Component)this.panelMaterial, gridBagConstraints);
        this.textCodigoOrigem.setMinimumSize(new Dimension(70, 20));
        this.textCodigoOrigem.setPreferredSize(new Dimension(70, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 0, 0, 0);
        this.panelCentro.add((Component)this.textCodigoOrigem, gridBagConstraints);
        this.textCodigoDestino.setMinimumSize(new Dimension(70, 20));
        this.textCodigoDestino.setPreferredSize(new Dimension(70, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.panelCentro.add((Component)this.textCodigoDestino, gridBagConstraints);
        this.buttonBuscaOrigem.setMaximumSize(new Dimension(20, 20));
        this.buttonBuscaOrigem.setMinimumSize(new Dimension(20, 20));
        this.buttonBuscaOrigem.setPreferredSize(new Dimension(20, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 0, 0, 0);
        this.panelCentro.add((Component)this.buttonBuscaOrigem, gridBagConstraints);
        this.buttonBuscaDestino.setMaximumSize(new Dimension(20, 20));
        this.buttonBuscaDestino.setMinimumSize(new Dimension(20, 20));
        this.buttonBuscaDestino.setPreferredSize(new Dimension(20, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.panelCentro.add((Component)this.buttonBuscaDestino, gridBagConstraints);
        this.labelDescOrigem.setBorder(BorderFactory.createTitledBorder(""));
        this.labelDescOrigem.setMinimumSize(new Dimension(56, 20));
        this.labelDescOrigem.setPreferredSize(new Dimension(56, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 0, 0, 0);
        this.panelCentro.add((Component)this.labelDescOrigem, gridBagConstraints);
        this.labelDescDestino.setBorder(BorderFactory.createTitledBorder(""));
        this.labelDescDestino.setMinimumSize(new Dimension(56, 20));
        this.labelDescDestino.setPreferredSize(new Dimension(56, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.panelCentro.add((Component)this.labelDescDestino, gridBagConstraints);
        this.panelLegenda = this.montaPainelLegenda();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.panelCentro.add((Component)this.panelLegenda, gridBagConstraints);
        this.buttonImportar.setText("Importar");
        JPanel panelImportar = new JPanel(new FlowLayout(0));
        panelImportar.add(this.buttonImportar);
        JPanel panelBotoesBasicos = new JPanel(new FlowLayout(2));
        panelBotoesBasicos.add(this.buttonNovo);
        panelBotoesBasicos.add(this.buttonTransferir);
        panelBotoesBasicos.add(this.buttonCancelar);
        panelBotoesBasicos.add(this.buttonFechar);
        this.buttonNovo.setText("Novo");
        this.buttonTransferir.setText("Transferir");
        this.buttonCancelar.setText("Cancelar");
        this.buttonFechar.setText("Fechar");
        this.panelBotoes.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.panelBotoes.add((Component)panelImportar, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.panelBotoes.add((Component)panelBotoesBasicos, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.panelCentro.add((Component)this.panelBotoes, gridBagConstraints);
    }

    private void abrirPopup() {
        if (this.tabelaMaterial.getSelectedRowCount() > 0) {
            int x = this.tabelaMaterial.getWidth() / 2 - this.menuMaterial.getWidth() / 2;
            int y = this.tabelaMaterial.getSelectedRow() * this.tabelaMaterial.getRowHeight() + this.tabelaMaterial.getRowHeight() / 2;
            this.menuMaterial.show(this.tabelaMaterial, x, y);
        }
    }

    private void abrirPopupImportar() {
        this.menuImportar.show(this.buttonImportar, this.buttonImportar.getX(), this.buttonImportar.getY());
    }

    /*
     * Unable to fully structure code
     */
    private ArrayList<DadosPatrimonio> configurarPatrimonios(MaterialBean beanMat, Double quantidade) {
        block21: {
            patrimonios = beanMat.getPatrimonios();
            dadosPatrimonio = null;
            if ((patrimonios == null || (double)patrimonios.size() < quantidade) && beanMat.getSolicitarPatrimonio() != null && beanMat.getSolicitarPatrimonio().booleanValue() && beanMat.getImobilizado() != null && beanMat.getImobilizado().booleanValue()) {
                if (patrimonios == null) {
                    Funcoes.mensagem(this, "N\u00e3o h\u00e1 patrim\u00f4nios definidos para o material.\nConfigure os patrim\u00f4nios do material no Cadastro de Material.", 2);
                } else {
                    Funcoes.mensagem(this, "A quantidade de patrim\u00f4nios definidos no Cadastro de Material\n\u00e9 inferior a " + Funcoes.formataDecimal(quantidade) + ".\nConfigure os patrim\u00f4nios em falta no Cadastro de Material.", 2);
                }
                this.textCodigoMaterial.selectAll();
                this.textCodigoMaterial.grabFocus();
                return null;
            }
            if (!this.isAlterando) {
                dadosPatrimonio = new ArrayList<DadosPatrimonio>();
            } else {
                row = this.tabelaMaterial.getSelectedRow();
                if (row >= 0) {
                    dadosPatrimonio = (ArrayList<DadosPatrimonio>)this.modeloMaterial.getValueAt(row, this.modeloMaterial.findColumn("Patrimonios"));
                }
            }
            p = Patrimonio.novaInstancia(this.getTopLevelAncestor(), true);
            if (beanMat.getSolicitarPatrimonio() != null && beanMat.getSolicitarPatrimonio().booleanValue() && beanMat.getImobilizado() != null && beanMat.getImobilizado().booleanValue()) {
                if (!this.isAlterando) {
                    servicePatrimonioMaterial = new MaterialPatrimonioService();
                    ** if (patrimonios == null) goto lbl36
                    for (i = 0; i < patrimonios.size(); ++i) {
                        patrimonioBean = patrimonios.get(i);
                        auxAdiciona = null;
                        try {
                            auxAdiciona = new DadosPatrimonio(beanMat, patrimonioBean.getPatrimonio(), patrimonioBean.getSerie(), patrimonioBean.getNumeroNotaFiscal().toString(), patrimonioBean.getSetor(), servicePatrimonioMaterial.podeAlterarPatrimonioMaterial(Variaveis.filialPadrao, beanMat.getCodigo().toString(), patrimonioBean.getPatrimonio()), false);
                        }
                        catch (Exception e) {
                            continue;
                        }
                        if (dadosPatrimonio == null) continue;
                        dadosPatrimonio.add(auxAdiciona);
lbl-1000:
                        // 2 sources

                        {
                            continue;
                        }
                    }
                }
lbl36:
                // 4 sources

                if (p != null) {
                    block20: {
                        while (true) {
                            p.setPatrimonios(dadosPatrimonio == null || dadosPatrimonio.size() == 0 ? null : dadosPatrimonio);
                            p.setVisible(true);
                            if (!p.getOK()) break block20;
                            dadosPatrimonio = p.getPatrimonios();
                            qtde = 0;
                            for (i = 0; i < dadosPatrimonio.size(); ++i) {
                                if (!dadosPatrimonio.get(i).isSelecionado()) continue;
                                ++qtde;
                            }
                            if ((double)qtde < quantidade) {
                                Funcoes.mensagem(this, "A quantidade de patrim\u00f4nios selecionada \u00e9 inferior \u00e0 quantidade a ser transferida.\nDeve-se selecionar " + Funcoes.formataDecimal(quantidade) + " patrim\u00f4nio(s).", 2);
                                continue;
                            }
                            if (!((double)qtde > quantidade)) break;
                            Funcoes.mensagem(this, "A quantidade de patrim\u00f4nios selecionada \u00e9 superior \u00e0 quantidade a ser transferida.\nDeve-se selecionar apenas " + Funcoes.formataDecimal(quantidade) + " patrim\u00f4nio(s).", 2);
                        }
                        listaPatrimonios = new ArrayList<MaterialPatrimonioBean>();
                        if (patrimonios != null) {
                            for (i = 0; i < dadosPatrimonio.size(); ++i) {
                                dados = dadosPatrimonio.get(i);
                                patrimonio = new MaterialPatrimonioBean();
                                patrimonio.setFilial(beanMat.getFilial());
                                patrimonio.setMaterial((MaterialVO)beanMat.toVO());
                                patrimonio.setNumeroNotaFiscal(Integer.parseInt(dados.getNotaFiscal()));
                                patrimonio.setSerie(dados.getSerie());
                                patrimonio.setPatrimonio(dados.getPatrimonio());
                                patrimonio.setSetor(dados.getSetor());
                                patrimonio.setInutilizado(false);
                                listaPatrimonios.add(patrimonio);
                            }
                        }
                        if (listaPatrimonios.size() > 0) {
                            beanMat.setPatrimonios(listaPatrimonios);
                        }
                        break block21;
                    }
                    if (!this.isAlterando) {
                        Funcoes.mensagem(this, "N\u00e3o \u00e9 poss\u00edvel transferir o(s) material(is) sem selecionar o(s) patrim\u00f4nio(s).", 2);
                        return null;
                    }
                    return dadosPatrimonio;
                }
            }
        }
        return dadosPatrimonio;
    }

    private void alterarMaterial() {
        int row = this.tabelaMaterial.getSelectedRow();
        if (row >= 0) {
            this.textCodigoMaterial.setText(((Integer)this.modeloMaterial.getValueAt(row, this.modeloMaterial.findColumn("C\u00f3digo"))).toString());
            this.labelDescMaterial.setText((String)this.modeloMaterial.getValueAt(row, this.modeloMaterial.findColumn("Material")));
            this.textQuantidade.setText((String)this.modeloMaterial.getValueAt(row, this.modeloMaterial.findColumn("Quantidade")));
            this.isAlterando = true;
            this.controlaCampos();
            this.textQuantidade.grabFocus();
        }
    }

    private JPanel montaPainelLegenda() {
        JPanel pnlLegenda = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 0.0;
        c.weighty = 0.0;
        JPanel pnlCorLegenda = new JPanel();
        pnlCorLegenda.setPreferredSize(new Dimension(10, 10));
        pnlCorLegenda.setBackground(COR_SOLICITA_PATRIMONIO);
        pnlCorLegenda.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
        pnlLegenda.add((Component)pnlCorLegenda, c);
        JLabel lblLegenda = new JLabel("Material solicita patrim\u00f4nio");
        Font font = new Font(lblLegenda.getFont().getName(), 0, 10);
        lblLegenda.setFont(font);
        ++c.gridx;
        pnlLegenda.add((Component)lblLegenda, c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        pnlLegenda.add((Component)new JLabel(), c);
        return pnlLegenda;
    }

    public static long getModuloAcesso() {
        return Long.parseLong("1200300300");
    }

    public static long getModuloAcessoNotaFiscalEntrada() {
        return Long.parseLong("1200300301");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonNovo) {
            this.novo();
        } else if (e.getSource() == this.buttonCancelar) {
            this.cancelar();
        } else if (e.getSource() == this.buttonTransferir) {
            this.transferir();
        } else if (e.getSource() == this.buttonFechar) {
            this.fechar();
        } else if (e.getSource() == this.buttonBuscaDestino) {
            this.celulaDestinoAux = this.pesquisaCelula(this.textCodigoDestino, this.labelDescDestino);
        } else if (e.getSource() == this.buttonBuscaOrigem) {
            this.celulaOrigemAux = this.pesquisaCelula(this.textCodigoOrigem, this.labelDescOrigem);
        } else if (e.getSource() == this.buttonBuscaMaterial) {
            this.pesquisaMaterial();
        } else if (e.getSource() == this.buttonOK) {
            this.adicionarMaterial();
        } else if (e.getSource() == this.buttonImportar) {
            if (Acesso.getAcesso(TransferenciaEstoque.getModuloAcessoNotaFiscalEntrada())) {
                this.abrirPopupImportar();
            } else {
                this.importar();
            }
        }
    }

    private void importar() {
        RequisicaoEstoqueVO requisicao = new RequisicaoEstoqueVO();
        RequisicaoEstoqueService serviceRequisicao = new RequisicaoEstoqueService();
        requisicao = (RequisicaoEstoqueVO)serviceRequisicao.pesquisaRequisicaoAbertaVO(Laboratorio.getInstancia(), requisicao, "Pesquisando Requisi\u00e7\u00f5es", false);
        if (requisicao != null) {
            RequisicaoEstoqueBean reqBean = null;
            this.requisicaoAux = requisicao;
            try {
                reqBean = (RequisicaoEstoqueBean)serviceRequisicao.get(requisicao.getFilial().getCodigo().toString(), requisicao.getCodigo().toString());
            }
            catch (Exception e1) {
                ErrorLogger.mostraMensagem(this, e1.getMessage(), e1.getStackTrace(), "TransferenciaEstoque:importar");
                return;
            }
            this.celulaDestinoAux = reqBean.getCelulaEstoque();
            this.buttonImportar.setEnabled(false);
            this.preencherDadosRequisicao(reqBean);
            this.buttonImportar.setEnabled(true);
            if (reqBean.getCelulaEstoque() == null || reqBean.getCelulaEstoque().getInativa().booleanValue()) {
                Funcoes.mensagem(this, "A c\u00e9lula de estoque de destino est\u00e1 inativa.", 2);
            } else {
                this.textCodigoDestino.setText(reqBean.getCelulaEstoque().getCodigo().toString());
                this.labelDescDestino.setText(reqBean.getCelulaEstoque().getDescricao());
            }
            UsuarioVO usuario = new UsuarioVO();
            usuario.setCodigo(Variaveis.login);
            this.usuarioAux = usuario;
            this.labelVlrUsuario.setText(this.usuarioAux.getCodigo());
            this.dataAux = new Date();
            this.labelVlrData.setText(Funcoes.formataData("dd/MM/yyyy HH:mm:ss", this.dataAux));
            this.setStatus(3);
            this.controlaCampos();
            if (this.textCodigoOrigem.isFocusable() && this.textCodigoOrigem.isEnabled()) {
                this.textCodigoOrigem.grabFocus();
            }
        }
    }

    public void importarNotaFiscal() {
        NotaFiscalService service = new NotaFiscalService();
        NotaFiscalBean notaBean = null;
        NotaFiscalVO notaVO = null;
        ArrayList<NotaFiscalMaterialBean> listaMateriais = null;
        try {
            Hashtable selecionados = service.pesquisaNotaEntradaVO(this.getTopLevelAncestor(), new NotaFiscalVO(), "Pesquisando Notas Fiscais de Entrada");
            if (selecionados != null && selecionados.size() > 0) {
                notaVO = (NotaFiscalVO)service.getVO(Variaveis.filialPadrao, selecionados.get("nfi_codigo").toString());
                if (notaVO != null) {
                    notaBean = (NotaFiscalBean)new NotaFiscalDao().getBean(Variaveis.filialPadrao, String.valueOf(notaVO.getCodigo()));
                }
                listaMateriais = new NotaFiscalMaterialService().getMateriaisNotaFiscal(Variaveis.filialPadrao, notaBean.getCodigo().toString());
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar dados da nota fiscal de entrada.\n" + e.getMessage(), e.getStackTrace());
        }
        this.buttonImportar.setEnabled(false);
        if (listaMateriais != null) {
            this.preencheDadosNotaFiscal(listaMateriais);
        }
        this.buttonImportar.setEnabled(true);
        UsuarioVO usuario = new UsuarioVO();
        usuario.setCodigo(Variaveis.login);
        this.usuarioAux = usuario;
        this.labelVlrUsuario.setText(this.usuarioAux.getCodigo());
        this.dataAux = new Date();
        this.labelVlrData.setText(Funcoes.formataData("dd/MM/yyyy HH:mm:ss", this.dataAux));
        this.setStatus(3);
        this.controlaCampos();
        if (this.textCodigoOrigem.isFocusable() && this.textCodigoOrigem.isEnabled()) {
            this.textCodigoOrigem.grabFocus();
        }
    }

    private void preencherDadosRequisicao(RequisicaoEstoqueBean requisicao) {
        ArrayList<RequisicaoEstoqueMaterialBean> materiais = requisicao.getMateriais();
        for (int i = 0; i < materiais.size(); ++i) {
            RequisicaoEstoqueMaterialBean material = materiais.get(i);
            MaterialBean beanMaterial = null;
            try {
                beanMaterial = (MaterialBean)new MaterialService().getTodos(Variaveis.filialPadrao, material.getMaterial().getCodigo().toString(), null, null);
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel carregar os dados do material.\n" + e.getMessage(), e.getStackTrace());
            }
            if (beanMaterial == null) continue;
            LancamentoEstoqueBean lancto = new LancamentoEstoqueBean();
            this.adicionarMaterial(beanMaterial, material.getQuantidade(), lancto, true);
        }
    }

    private void preencheDadosNotaFiscal(ArrayList<NotaFiscalMaterialBean> listaMateriais) {
        for (int i = 0; i < listaMateriais.size(); ++i) {
            NotaFiscalMaterialBean nota = listaMateriais.get(i);
            MaterialBean beanMaterial = null;
            try {
                beanMaterial = (MaterialBean)new MaterialService().getTodos(Variaveis.filialPadrao, nota.getMaterial().getCodigo().toString(), null, null);
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel carregar os dados do material.\n" + e.getMessage(), e.getStackTrace());
            }
            if (beanMaterial == null) continue;
            LancamentoEstoqueBean lancto = new LancamentoEstoqueBean();
            this.adicionarMaterial(beanMaterial, nota.getQuantidade(), lancto, false);
        }
    }

    private void adicionarMaterial(MaterialBean bean, Double quantidade, LancamentoEstoqueBean lancto, boolean importacao) {
        SaldoEstoqueCelulaBean saldoCelula = null;
        if (bean != null) {
            for (int i = 0; i < this.modeloMaterial.getRowCount(); ++i) {
                if (bean.getCodigo().intValue() != ((Integer)this.modeloMaterial.getValueAt(i, this.modeloMaterial.findColumn("C\u00f3digo"))).intValue()) continue;
                return;
            }
            try {
                saldoCelula = (SaldoEstoqueCelulaBean)new SaldoEstoqueCelulaService().getSaldoAtualEstoqueMaterialCelula(Variaveis.filialPadrao, String.valueOf(bean.getCodigo()), this.celulaOrigemAux.getCodigo().toString());
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel obter saldo em estoque do material.", e.getStackTrace());
            }
            if (saldoCelula == null || saldoCelula.getSaldo() == 0.0) {
                if (importacao) {
                    MaterialSobraFaltaImportacao materiaSobraFaltaImportacao = new MaterialSobraFaltaImportacao();
                    materiaSobraFaltaImportacao.setMaterialVO((MaterialVO)bean.toVO());
                    materiaSobraFaltaImportacao.setQuantidadeTransferida(0.0);
                    materiaSobraFaltaImportacao.setRequisicaoEstoqueVO(this.requisicaoAux);
                    materiaSobraFaltaImportacao.setQuantidadeDaImportacao(quantidade);
                    this.materiaSobraFaltaImportacoes.add(materiaSobraFaltaImportacao);
                }
                StringBuilder buf = new StringBuilder();
                buf.append("N\u00e3o h\u00e1 saldo em estoque para o material \"" + bean.getDescricao() + "\".\nO material ser\u00e1 ignorado.");
                Funcoes.mensagem(this, buf.toString(), 2);
                return;
            }
            if (quantidade > saldoCelula.getSaldo()) {
                StringBuilder buf = new StringBuilder();
                buf.append("A quantidade em estoque do material \"" + bean.getDescricao() + "\" \u00e9 inferior a quantidade a ser transferida.");
                buf.append("\nSaldo atual em estoque = ").append(Funcoes.formataDecimal(saldoCelula.getSaldo())).append(".");
                buf.append("\nA quantidade dispon\u00edvel ser\u00e1 utilizada.");
                Funcoes.mensagem(this, buf.toString(), 2);
                quantidade = saldoCelula.getSaldo();
            }
            if (lancto == null) {
                lancto = new LancamentoEstoqueBean();
            }
            lancto.setMaterial((MaterialVO)bean.toVO());
            lancto.setQuantidade(quantidade);
            ArrayList<DadosPatrimonio> dadosPatrimonio = this.configurarPatrimonios(bean, lancto.getQuantidade());
            if (bean.getSolicitarLote().booleanValue() && !this.solicitarAtualizarLote(bean, lancto, true, this.celulaDestinoAux, this.celulaOrigemAux)) {
                Funcoes.mensagem(this, "Os lotes do material devem ser informados.", 2);
                return;
            }
            this.modeloMaterial.addLine(new Object[]{bean.getCodigo(), bean.getDescricao(), saldoCelula != null ? Funcoes.formataDecimal(saldoCelula.getSaldo()) : "0,00", Funcoes.formataDecimal(quantidade), lancto, bean, dadosPatrimonio, importacao, importacao ? this.requisicaoAux.getCodigo() : null});
            this.textCodigoMaterial.setText("");
            this.textQuantidade.setText("");
        }
        this.controlaCampos();
    }

    private void adicionarMaterial() {
        int row = this.tabelaMaterial.getSelectedRow();
        if (this.textCodigoOrigem.getText().isEmpty() || this.labelDescOrigem.getText().equalsIgnoreCase("N\u00e3o cadastrado")) {
            Funcoes.mensagem(this, "N\u00e3o \u00e9 poss\u00edvel adicionar o material, pois, a c\u00e9lula de origem n\u00e3o foi configurada.", 2);
            if (this.textCodigoOrigem.isEnabled() && this.textCodigoOrigem.isFocusable()) {
                ScreenUtil.requisitarFoco(this.textCodigoOrigem);
            }
            return;
        }
        if (this.textQuantidade.getText().isEmpty() || Double.parseDouble(Funcoes.limpaDecimal(this.textQuantidade.getText())) <= 0.0) {
            Funcoes.mensagem(this, "Quantidade inv\u00e1lida.", 2);
            if (this.textQuantidade.isEnabled() && this.textQuantidade.isFocusable()) {
                this.textQuantidade.selectAll();
                ScreenUtil.requisitarFoco(this.textQuantidade);
            }
            return;
        }
        if (!Funcoes.textoVazio(this.textCodigoMaterial.getText()) && !this.labelDescMaterial.getText().equals("N\u00e3o cadastrado")) {
            MaterialBean beanMat = null;
            SaldoEstoqueCelulaBean saldoCelula = null;
            MaterialService service = new MaterialService();
            SaldoEstoqueCelulaService serviceSaldoCelula = new SaldoEstoqueCelulaService();
            try {
                beanMat = !this.isAlterando ? (MaterialBean)service.getTodos(Variaveis.filialPadrao, this.textCodigoMaterial.getText(), null, null) : (MaterialBean)this.modeloMaterial.getValueAt(row, 5);
                saldoCelula = (SaldoEstoqueCelulaBean)serviceSaldoCelula.getSaldoAtualEstoqueMaterialCelula(Variaveis.filialPadrao, String.valueOf(beanMat.getCodigo()), this.celulaOrigemAux.getCodigo().toString());
            }
            catch (Exception e) {
                Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel obter o material.", 2);
            }
            if (saldoCelula == null || Double.parseDouble(Funcoes.limpaDecimal(this.textQuantidade.getText())) > saldoCelula.getSaldo()) {
                StringBuilder buf = new StringBuilder();
                buf.append("A quantidade em estoque \u00e9 inferior a quantidade a ser transferida.");
                if (saldoCelula != null) {
                    buf.append("\n").append("Saldo atual em estoque = ").append(Funcoes.formataDecimal(saldoCelula.getSaldo())).append(".");
                }
                Funcoes.mensagem(this, buf.toString(), 2);
                if (this.textQuantidade.isFocusable() && this.textQuantidade.isEnabled()) {
                    this.textQuantidade.grabFocus();
                }
                return;
            }
            if (beanMat != null) {
                int linha = this.materialAdicionado(beanMat.getCodigo());
                if (linha >= 0 && !this.isAlterando) {
                    Funcoes.mensagem(this, "O material j\u00e1 foi inserido.", 2);
                    if (this.textCodigoMaterial.isEnabled() && this.textCodigoMaterial.isFocusable()) {
                        this.textCodigoMaterial.grabFocus();
                    }
                    return;
                }
                LancamentoEstoqueBean bean = new LancamentoEstoqueBean();
                bean.setMaterial((MaterialVO)beanMat.toVO());
                bean.setQuantidade(Double.parseDouble(Funcoes.limpaDecimal(this.textQuantidade.getText())));
                ArrayList<DadosPatrimonio> dadosPatrimonio = this.configurarPatrimonios(beanMat, bean.getQuantidade());
                if (beanMat.getSolicitarPatrimonio() != null && beanMat.getSolicitarPatrimonio().booleanValue() && beanMat.getImobilizado() != null && beanMat.getImobilizado().booleanValue() && dadosPatrimonio == null) {
                    if (this.textCodigoMaterial.isFocusable() && this.textCodigoMaterial.isEnabled()) {
                        this.textCodigoMaterial.grabFocus();
                    }
                    return;
                }
                if (beanMat.getSolicitarLote().booleanValue() && !this.solicitarAtualizarLote(beanMat, bean, false, this.celulaDestinoAux, this.celulaOrigemAux)) {
                    Funcoes.mensagem(this, "Os lotes do material devem ser informados.", 2);
                    return;
                }
                if (!this.isAlterando) {
                    this.modeloMaterial.addLine(new Object[]{beanMat.getCodigo(), beanMat.getDescricao(), saldoCelula != null ? Funcoes.formataDecimal(saldoCelula.getSaldo()) : "0,00", Funcoes.formataDecimal(bean.getQuantidade()), bean, beanMat, dadosPatrimonio, false, null});
                } else {
                    if (row >= 0) {
                        LancamentoEstoqueBean lanctoBean = (LancamentoEstoqueBean)this.modeloMaterial.getValueAt(row, this.modeloMaterial.findColumn("Objeto"));
                        lanctoBean.setQuantidade(bean.getQuantidade());
                        this.modeloMaterial.setValueAt(lanctoBean, row, this.modeloMaterial.findColumn("Objeto"));
                        this.modeloMaterial.setValueAt(Funcoes.formataDecimal(bean.getQuantidade()), row, this.modeloMaterial.findColumn("Quantidade"));
                        this.modeloMaterial.setValueAt(dadosPatrimonio, row, this.modeloMaterial.findColumn("Patrimonios"));
                    }
                    this.textCodigoMaterial.clear();
                    this.labelDescMaterial.setText("");
                    this.textQuantidade.clear();
                }
                this.controlaCampos();
            }
        } else {
            if (this.textCodigoMaterial.getText().isEmpty()) {
                Funcoes.mensagem(this, "O material deve ser selecionado.", 2);
            } else {
                Funcoes.mensagem(this, "O material selecionado \u00e9 inv\u00e1lido.", 2);
            }
            if (this.textCodigoMaterial.isEnabled() && this.textCodigoMaterial.isFocusable()) {
                this.textCodigoMaterial.selectAll();
                ScreenUtil.requisitarFoco(this.textCodigoMaterial);
            }
            return;
        }
        this.isAlterando = false;
        this.textCodigoMaterial.clear();
        this.labelDescMaterial.setText("");
        this.textQuantidade.clear();
        this.textCodigoMaterial.grabFocus();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean solicitarAtualizarLote(MaterialBean beanMat, LancamentoEstoqueBean bean, boolean importacao, CelulaEstoqueVO celulaEntrada, CelulaEstoqueVO celulaSaida) {
        VisualizaLoteEntrada visualizarLote;
        if (!beanMat.getSolicitarLote().booleanValue() || beanMat.getLotes().size() <= 0) return true;
        Double qtdeOriginal = beanMat.getQuantidadeLotes(bean.getCelulaEstoque()) - beanMat.getQuantidadeConsumidaOriginalLotes(bean.getCelulaEstoque());
        Double valorQuantidade = 0.0;
        valorQuantidade = importacao ? bean.getQuantidade() : Double.valueOf(Double.parseDouble(!Funcoes.textoVazio(this.textQuantidade.getText()) ? this.textQuantidade.getText() : "0.0"));
        HashSet<MaterialLoteBean> materialLoteBeans = new HashSet<MaterialLoteBean>();
        Double qtde = 0.0;
        SolicitarLoteMaterial lote = new SolicitarLoteMaterial(Laboratorio.getInstancia(), beanMat.getCodigo(), beanMat.getDescricao(), beanMat.getUnidadeMedida().getCodigo(), beanMat.getFichaTecnica(), beanMat.getLotes(), 1, qtdeOriginal, null, valorQuantidade, qtdeOriginal, celulaSaida, false, null, false);
        if (lote != null) {
            lote.setVisible(true);
            if (!lote.getOK()) return false;
            materialLoteBeans.addAll(lote.getLotesAlterados());
            if (beanMat.getLotes() != null && !beanMat.getLotes().isEmpty()) {
                for (int i = 0; i < lote.getLotes().size(); ++i) {
                    qtde = qtde + beanMat.getLotes().get(i).getQuantidade();
                }
            }
            beanMat.setQuantidadeInformadaLotes(qtde);
        }
        if ((visualizarLote = VisualizaLoteEntrada.getInstancia(Laboratorio.getInstancia(), (MaterialVO)beanMat.toVO(), new ArrayList<MaterialLoteBean>(materialLoteBeans), valorQuantidade, celulaEntrada)) != null) {
            visualizarLote.setVisible(true);
            int resp = visualizarLote.getRetorno();
            ArrayList<MaterialLoteBean> lotesSugestao = visualizarLote.getLotes();
            if (resp == 0) {
                materialLoteBeans.addAll(visualizarLote.getLotes());
                if (beanMat.getLotes() != null && !beanMat.getLotes().isEmpty()) {
                    for (MaterialLoteBean aux : visualizarLote.getLotes()) {
                        qtde = qtde + aux.getQuantidade();
                    }
                }
                beanMat.setQuantidadeInformadaLotes(qtde);
            } else {
                if (resp != 2) return false;
                lote = new SolicitarLoteMaterial(Laboratorio.getInstancia(), beanMat.getCodigo(), beanMat.getDescricao(), beanMat.getUnidadeMedida().getCodigo(), beanMat.getFichaTecnica(), beanMat.getLotes(), 0, qtdeOriginal, valorQuantidade, null, null, celulaEntrada, true, lotesSugestao, false);
                if (lote != null) {
                    lote.setVisible(true);
                    if (!lote.getOK()) return false;
                    materialLoteBeans.addAll(lote.getLotes());
                    if (beanMat.getLotes() != null && !beanMat.getLotes().isEmpty()) {
                        for (MaterialLoteBean aux : lote.getLotes()) {
                            qtde = qtde + aux.getQuantidade();
                        }
                    }
                    beanMat.setQuantidadeInformadaLotes(qtde);
                }
            }
        }
        beanMat.getLotes().clear();
        beanMat.getLotes().addAll(materialLoteBeans);
        return true;
    }

    private int materialAdicionado(int codigo) {
        int retorno = -1;
        for (int i = 0; i < this.modeloMaterial.getRowCount(); ++i) {
            LancamentoEstoqueBean lancamento;
            if (this.modeloMaterial.getValueAt(i, 4) == null || (lancamento = (LancamentoEstoqueBean)this.modeloMaterial.getValueAt(i, 4)).getMaterial().getCodigo() != codigo) continue;
            retorno = i;
            break;
        }
        return retorno;
    }

    private void limparCampos() {
        this.textCodigoDestino.clear();
        this.textCodigoOrigem.clear();
        this.textCodigoMaterial.clear();
        this.textQuantidade.clear();
        this.modeloMaterial.clear();
        this.labelDescDestino.setAviso(null);
        this.labelDescDestino.setIcon(null);
        this.labelDescDestino.setText("");
        this.labelDescOrigem.setAviso(null);
        this.labelDescOrigem.setIcon(null);
        this.labelDescOrigem.setText("");
        this.labelDescMaterial.setText("");
        this.celulaOrigemAux = null;
        this.celulaDestinoAux = null;
        this.requisicaoAux = null;
        this.dataAux = null;
        this.usuarioAux = null;
        this.labelVlrData.setText("");
        this.labelVlrUsuario.setText("");
        this.isAlterando = false;
        this.materiaSobraFaltaImportacoes.clear();
    }

    private void setStatus(int status) {
        this.status = status;
        this.controlaCampos();
    }

    private void controlaCampos() {
        this.buttonNovo.setEnabled(this.status == 1);
        this.buttonFechar.setEnabled(this.status == 1);
        this.buttonTransferir.setEnabled(this.status == 3);
        this.buttonCancelar.setEnabled(this.status == 3);
        this.textCodigoDestino.setEnabled(this.status == 3 && (this.textCodigoDestino.getText().isEmpty() || this.modeloMaterial.getRowCount() == 0));
        this.textCodigoOrigem.setEnabled(this.status == 3 && (this.textCodigoOrigem.getText().isEmpty() || this.modeloMaterial.getRowCount() == 0));
        this.textCodigoMaterial.setEnabled(this.status == 3 && !this.isAlterando && !this.textCodigoOrigem.getText().isEmpty());
        this.textQuantidade.setEnabled(this.status == 3 && !this.textCodigoOrigem.getText().isEmpty());
        this.buttonBuscaDestino.setEnabled(this.status == 3 && (this.textCodigoDestino.getText().isEmpty() || this.modeloMaterial.getRowCount() == 0));
        this.buttonBuscaOrigem.setEnabled(this.status == 3 && (this.textCodigoOrigem.getText().isEmpty() || this.modeloMaterial.getRowCount() == 0));
        this.buttonOK.setEnabled(this.status == 3 && !this.textCodigoOrigem.getText().isEmpty());
        this.buttonBuscaMaterial.setEnabled(this.status == 3 && !this.textCodigoOrigem.getText().isEmpty());
        this.buttonImportar.setEnabled(this.status == 3 && !this.textCodigoOrigem.getText().isEmpty());
    }

    private void cancelar() {
        if (Funcoes.mensagem(this, "As informa\u00e7\u00f5es adicionadas ser\u00e3o perdidas.", 4) == 0) {
            this.limparCampos();
            this.setStatus(1);
        }
    }

    private void novo() {
        this.limparCampos();
        this.setStatus(3);
        this.dataAux = new Date();
        this.labelVlrData.setText(Funcoes.formataData("dd/MM/yyyy HH:mm:ss", this.dataAux));
        UsuarioVO usuario = new UsuarioVO();
        usuario.setCodigo(Variaveis.login);
        this.usuarioAux = usuario;
        this.labelVlrUsuario.setText(this.usuarioAux.getCodigo());
        ScreenUtil.requisitarFoco(this.textCodigoOrigem);
        try {
            CelulaEstoqueService celulaEstoqueService = new CelulaEstoqueService();
            CelulaEstoqueBean celulaEstoqueBean = celulaEstoqueService.getCelulaPadraoEstacao(Variaveis.filialPadrao);
            this.textCodigoOrigem.setText(celulaEstoqueBean.getCodigo().toString());
            this.saidaCampoCelula(this.textCodigoOrigem, this.labelDescOrigem);
            ScreenUtil.requisitarFoco(this.textCodigoDestino);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this.getTopLevelAncestor(), e.getMessage(), e.getStackTrace(), "TransferenciaEstoque:transferir");
        }
    }

    private void fechar() {
        this.setVisible(false);
    }

    private void transferir() {
        if (Funcoes.textoVazio(this.textCodigoOrigem.getText())) {
            Funcoes.mensagem(this, "A c\u00e9lula de estoque Origem deve ser informada.", 2);
            return;
        }
        if (!Funcoes.textoVazio(this.textCodigoOrigem.getText()) && this.labelDescOrigem.getText().equals("N\u00e3o cadastrado")) {
            Funcoes.mensagem(this, "C\u00e9lula de estoque Origem n\u00e3o cadastrada.", 2);
            return;
        }
        if (Funcoes.textoVazio(this.textCodigoDestino.getText())) {
            Funcoes.mensagem(this, "A c\u00e9lula de estoque Destino deve ser informada.", 2);
            return;
        }
        if (!Funcoes.textoVazio(this.textCodigoDestino.getText()) && this.labelDescDestino.getText().equals("N\u00e3o cadastrado")) {
            Funcoes.mensagem(this, "C\u00e9lula de estoque Destino n\u00e3o cadastrada.", 2);
            return;
        }
        if (this.textCodigoOrigem.getText().equalsIgnoreCase(this.textCodigoDestino.getText())) {
            Funcoes.mensagem(this, "A c\u00e9lula de estoque Origem n\u00e3o pode ser igual \u00e0 c\u00e9lula de estoque Destino.", 2);
            return;
        }
        if (this.tabelaMaterial.getRowCount() == 0) {
            Funcoes.mensagem(this, "Nenhum material foi informado para transfer\u00eancia.", 2);
            return;
        }
        if (this.celulaDestinoAux.getBaixarAutomatico().booleanValue() && ParametrosGerais.isExigirConferenciaTransferencia()) {
            Funcoes.mensagem(this, "A c\u00e9lula destino est\u00e1 marcada para baixa autom\u00e1tica, n\u00e3o ser\u00e1 necess\u00e1rio conferir a transfer\u00eancia.", 2);
        }
        try {
            FilialVO filial = new FilialVO();
            filial.setCodigo(Integer.valueOf(Variaveis.filialPadrao));
            TransfEstoqueBean transfEstoque = new TransfEstoqueBean();
            transfEstoque.setFilial(filial);
            transfEstoque.setUsuario(this.usuarioAux);
            transfEstoque.setDataHora(this.dataAux);
            transfEstoque.setCelulaOrigem(this.celulaOrigemAux);
            transfEstoque.setCelulaDestino(this.celulaDestinoAux);
            Integer reqTemp = 0;
            RequisicaoEstoqueBean requisicaoEstoque = new RequisicaoEstoqueBean();
            ArrayList<TransfEstoqueMaterialBean> materiais = new ArrayList<TransfEstoqueMaterialBean>();
            for (int i = 0; i < this.modeloMaterial.getRowCount(); ++i) {
                MaterialVO mat = (MaterialVO)new MaterialService().getTodosVO(Variaveis.filialPadrao, this.modeloMaterial.getValueAt(i, 0).toString());
                MaterialBean materialBeanObjetoDoModelo = (MaterialBean)this.modeloMaterial.getValueAt(i, 5);
                mat.setLotes(materialBeanObjetoDoModelo.getLotes());
                TransfEstoqueMaterialBean material = new TransfEstoqueMaterialBean();
                material.setFilial(filial);
                material.setMaterial(mat);
                material.setQuantidade(Double.parseDouble(Funcoes.limpaDecimal((String)this.modeloMaterial.getValueAt(i, 3))));
                SaldoEstoqueCelulaBean saldo = (SaldoEstoqueCelulaBean)new SaldoEstoqueCelulaService().getSaldoAtualEstoqueMaterialCelula(filial.getCodigo().toString(), mat.getCodigo().toString(), this.celulaOrigemAux.getCodigo().toString());
                if (saldo == null || saldo.getSaldo() < material.getQuantidade()) {
                    Funcoes.mensagem(this, "Quantidade em estoque insuficiente para transferir o material:\n\"" + mat.getDescricao() + "\".\n\nQuantidade em estoque atual: " + Funcoes.formataDecimal(saldo == null ? 0.0 : saldo.getSaldo()), 2);
                    return;
                }
                materiais.add(material);
            }
            transfEstoque.setMateriais(materiais);
            transfEstoque.setRequisicao(this.requisicaoAux);
            new TransfEstoqueService().gravaAutoCopiaSemCommit(transfEstoque, 0, Variaveis.filialPadrao, null);
            MaterialService serviceMaterial = new MaterialService();
            TransfEstoqueMaterialPatrimonioService serviceEstoqueMaterialPatrimonio = new TransfEstoqueMaterialPatrimonioService();
            for (int i = 0; i < this.modeloMaterial.getRowCount(); ++i) {
                ArrayList auxDadosPatrimonio = (ArrayList)this.modeloMaterial.getValueAt(i, 6);
                if (auxDadosPatrimonio == null) continue;
                MaterialBean auxMaterial = (MaterialBean)this.modeloMaterial.getValueAt(i, 5);
                boolean importacao = (Boolean)this.modeloMaterial.getValueAt(i, 7);
                if (importacao) {
                    Double quantidade = Double.parseDouble(Funcoes.limpaDecimal(this.modeloMaterial.getValueAt(i, 3).toString()));
                    Integer codRequisicao = Integer.parseInt(this.modeloMaterial.getValueAt(i, 8).toString());
                    Set set = this.requisicaoEstoqueMaterialService.load(" where fil_codigo = " + Variaveis.filialPadrao + " and ree_codigo = " + codRequisicao + " and mat_codigo = " + auxMaterial.getCodigo());
                    RequisicaoEstoqueBean requisicaoEstoqueBean = (RequisicaoEstoqueBean)this.requisicaoEstoqueService.load(" where ree_codigo = " + codRequisicao).toArray()[0];
                    if (requisicaoEstoqueBean != null && set != null) {
                        for (Object obj : set) {
                            RequisicaoEstoqueMaterialBean material = (RequisicaoEstoqueMaterialBean)obj;
                            if (!(quantidade < material.getQuantidade())) continue;
                            MaterialSobraFaltaImportacao materiaSobraFaltaImportacao = new MaterialSobraFaltaImportacao();
                            materiaSobraFaltaImportacao.setMaterialVO((MaterialVO)auxMaterial.toVO());
                            materiaSobraFaltaImportacao.setQuantidadeTransferida(quantidade);
                            materiaSobraFaltaImportacao.setRequisicaoEstoqueVO((RequisicaoEstoqueVO)requisicaoEstoqueBean.toVO());
                            materiaSobraFaltaImportacao.setQuantidadeDaImportacao((double)material.getQuantidade());
                            this.materiaSobraFaltaImportacoes.add(materiaSobraFaltaImportacao);
                            reqTemp = 0;
                        }
                    }
                    if (!this.materiaSobraFaltaImportacoes.isEmpty()) {
                        if (!reqTemp.equals(codRequisicao)) {
                            requisicaoEstoque = new RequisicaoEstoqueBean();
                            requisicaoEstoque.setFilial(requisicaoEstoqueBean.getFilial());
                            requisicaoEstoque.setDataHora(new Date());
                            requisicaoEstoque.setObservacao("Requisi\u00e7\u00e3o original = " + requisicaoEstoqueBean.getCodigo());
                            requisicaoEstoque.setUsuario(this.usuarioAux);
                            requisicaoEstoque.setSituacao("A");
                            requisicaoEstoque.setRequisicaoOriginal(requisicaoEstoqueBean.getCodigo());
                            requisicaoEstoque.setMateriais(new ArrayList<RequisicaoEstoqueMaterialBean>());
                            requisicaoEstoque.setCelulaEstoque(requisicaoEstoqueBean.getCelulaEstoque());
                            requisicaoEstoque.setOrigem(requisicaoEstoqueBean.getOrigem());
                            this.requisicaoEstoqueService.gravaAutoCopiaSemCommit(requisicaoEstoque, 0, Variaveis.filialPadrao, this.getCopiaFiliais());
                        }
                        requisicaoEstoqueBean.setSituacao("P");
                        this.requisicaoEstoqueService.update(requisicaoEstoqueBean, Variaveis.filialPadrao, this.getCopiaFiliais());
                        for (MaterialSobraFaltaImportacao sobraFaltaImportacao : this.materiaSobraFaltaImportacoes) {
                            RequisicaoEstoqueMaterialBean requisicaoEstoqueMaterialBean = new RequisicaoEstoqueMaterialBean();
                            requisicaoEstoqueMaterialBean.setFilial(filial);
                            requisicaoEstoqueMaterialBean.setMaterial(sobraFaltaImportacao.getMaterialVO());
                            requisicaoEstoqueMaterialBean.setQuantidade(sobraFaltaImportacao.quantidadeSobra());
                            requisicaoEstoqueMaterialBean.setRequisicao((RequisicaoEstoqueVO)requisicaoEstoque.toVO());
                            this.requisicaoEstoqueMaterialService.insert(requisicaoEstoqueMaterialBean, 0, Variaveis.filialPadrao, this.getCopiaFiliais());
                        }
                        this.materiaSobraFaltaImportacoes.clear();
                    }
                    reqTemp = codRequisicao;
                }
                serviceMaterial.gravaAutoCopiaSemCommit(auxMaterial, 1, Variaveis.filialPadrao, null);
                for (int j = 0; j < auxDadosPatrimonio.size(); ++j) {
                    DadosPatrimonio dados = (DadosPatrimonio)auxDadosPatrimonio.get(j);
                    if (!dados.isSelecionado()) continue;
                    TransfEstoqueMaterialPatrimonioBean beanEstMatPatr = new TransfEstoqueMaterialPatrimonioBean();
                    filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
                    beanEstMatPatr.setFilial(filial);
                    beanEstMatPatr.setMaterial((MaterialVO)auxMaterial.toVO());
                    MaterialPatrimonioVO matPatrimonioVO = new MaterialPatrimonioVO();
                    matPatrimonioVO.setFilial(filial);
                    matPatrimonioVO.setMaterial((MaterialVO)auxMaterial.toVO());
                    matPatrimonioVO.setPatrimonio(dados.getPatrimonio());
                    beanEstMatPatr.setMaterialPatrimonio(matPatrimonioVO);
                    beanEstMatPatr.setSetor(dados.getSetor());
                    beanEstMatPatr.setTransfEstoque((TransfEstoqueVO)transfEstoque.toVO());
                    serviceEstoqueMaterialPatrimonio.insert(beanEstMatPatr, null, Variaveis.filialPadrao, null);
                }
            }
            if (this.celulaDestinoAux.getBaixarAutomatico().booleanValue() || !ParametrosGerais.isExigirConferenciaTransferencia()) {
                new TransfEstoqueService().conciliaTransferencia(transfEstoque);
            }
            Conexao.arquivaSQL();
            Funcoes.mensagem(this, "Transfer\u00eancia realizada com sucesso.", 5);
        }
        catch (Exception e) {
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            ErrorLogger.mostraMensagem(this.getTopLevelAncestor(), e.getMessage(), e.getStackTrace(), "TransferenciaEstoque:transferir");
        }
        this.limparCampos();
        this.setStatus(1);
        ScreenUtil.requisitarFoco(this.buttonNovo);
    }

    private String getCopiaFiliais() {
        return Variaveis.filialPadrao;
    }

    @Override
    public void pressioneiF2() {
        if (this.textCodigoDestino.hasFocus()) {
            this.pesquisaCelula(this.textCodigoDestino, this.labelDescDestino);
            this.saidaCampoCelula(this.textCodigoDestino, this.labelDescDestino);
        } else if (this.textCodigoOrigem.hasFocus()) {
            this.pesquisaCelula(this.textCodigoOrigem, this.labelDescOrigem);
            this.saidaCampoCelula(this.textCodigoOrigem, this.labelDescOrigem);
        } else if (this.textCodigoMaterial.hasFocus()) {
            this.pesquisaMaterial();
        }
    }

    private CelulaEstoqueVO pesquisaCelula(TTextField campoCodigo, TAvisoLabel campoDescricao) {
        CelulaEstoqueService service = new CelulaEstoqueService();
        CelulaEstoqueVO vo = new CelulaEstoqueVO();
        vo = (CelulaEstoqueVO)service.pesquisaCelulasAtivasVO(Laboratorio.getInstancia(), vo, "Pesquisando C\u00e9lulas de Estoque", false);
        if (vo != null) {
            campoCodigo.setText(String.valueOf(vo.getCodigo()));
            campoDescricao.setText(vo.getDescricao());
            if (vo.getBaixarAutomatico().booleanValue()) {
                campoDescricao.setAviso("C\u00e9lula de baixa autom\u00e1tica");
            }
        } else {
            campoCodigo.clear();
            campoDescricao.setText("");
            campoDescricao.setAviso(null);
        }
        if (!campoCodigo.hasFocus()) {
            campoCodigo.grabFocus();
        }
        return vo;
    }

    private void pesquisaMaterial() {
        try {
            List<HashMap<String, Object>> materiais = null;
            DialogoFiltroMateriais diag = new DialogoFiltroMateriais(Laboratorio.getInstancia());
            diag.setVisible(true);
            if (diag.getOk() && (materiais = diag.getMateriaisSelecionados()) != null) {
                Iterator<HashMap<String, Object>> it = materiais.iterator();
                if (!materiais.isEmpty()) {
                    SplashMensagem janelaEspera = SplashMensagem.getInstancia(this);
                    janelaEspera.mostrar("Adicionando materiais");
                    int i = 0;
                    int qtde = materiais.size();
                    while (it.hasNext()) {
                        HashMap<String, Object> reg = it.next();
                        janelaEspera.setText("Adicionando materiais - " + (int)Funcoes.arredondar(++i * 100 / qtde, 2) + "%");
                        MaterialBean material = (MaterialBean)new MaterialService().getAtivo(Variaveis.filialPadrao, String.valueOf(reg.get("C\u00f3digo")), null, null);
                        if (material == null) continue;
                        this.adicionarMaterial(material, (Double)reg.get("Qtde."), null, false);
                    }
                    janelaEspera.apagar();
                }
            }
        }
        catch (Exception e1) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel adicionar materiais.\n" + e1.getMessage(), e1.getStackTrace());
        }
    }

    private void saidaCampoCelula(TTextField campoCodigo, JLabel campoDescricao) {
        if (campoCodigo.getText().isEmpty()) {
            return;
        }
        CelulaEstoqueVO celula = null;
        try {
            celula = (CelulaEstoqueVO)new CelulaEstoqueService().getVO(Variaveis.filialPadrao, campoCodigo.getText());
        }
        catch (Exception e1) {
            celula = null;
            campoDescricao.setText("N\u00e3o cadastrado");
            return;
        }
        if (celula != null && !celula.getInativa().booleanValue()) {
            campoDescricao.setText(celula.getDescricao());
            if (celula.getBaixarAutomatico().booleanValue()) {
                ((TAvisoLabel)campoDescricao).setAviso("C\u00e9lula de baixa autom\u00e1tica");
            } else {
                ((TAvisoLabel)campoDescricao).setAviso(null);
            }
        } else {
            ((TAvisoLabel)campoDescricao).setAviso(null);
            campoDescricao.setText("N\u00e3o cadastrado");
        }
        if (campoCodigo == this.textCodigoOrigem) {
            this.celulaOrigemAux = celula;
        } else {
            this.celulaDestinoAux = celula;
        }
        this.controlaCampos();
    }

    class MaterialSobraFaltaImportacao {
        private MaterialVO materialVO;
        private Double quantidadeTransferida = 0.0;
        private Double quantidadeDaImportacao = 0.0;
        private RequisicaoEstoqueVO requisicaoEstoqueVO = null;

        public Double quantidadeSobra() {
            return this.quantidadeDaImportacao - this.quantidadeTransferida;
        }

        public Double getQuantidadeDaImportacao() {
            return this.quantidadeDaImportacao;
        }

        public void setQuantidadeDaImportacao(Double quantidadeDaImportacao) {
            this.quantidadeDaImportacao = quantidadeDaImportacao;
        }

        public void setRequisicaoEstoqueVO(RequisicaoEstoqueVO requisicaoEstoqueVO) {
            this.requisicaoEstoqueVO = requisicaoEstoqueVO;
        }

        public RequisicaoEstoqueVO getRequisicaoEstoqueVO() {
            return this.requisicaoEstoqueVO;
        }

        public MaterialVO getMaterialVO() {
            return this.materialVO;
        }

        public void setMaterialVO(MaterialVO materialVO) {
            this.materialVO = materialVO;
        }

        public Double getQuantidadeTransferida() {
            return this.quantidadeTransferida;
        }

        public void setQuantidadeTransferida(Double quantidadeTransferida) {
            this.quantidadeTransferida = quantidadeTransferida;
        }
    }

    class EstoqueRenderer
    extends DefaultTableCellRenderer {
        @Override
        public synchronized Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focused, int row, int column) {
            MaterialVO material;
            Component c = super.getTableCellRendererComponent(table, value, selected, focused, row, column);
            this.setValue(value);
            if (selected) {
                this.setForeground(table.getSelectionForeground());
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            LancamentoEstoqueBean lancto = (LancamentoEstoqueBean)TransferenciaEstoque.this.modeloMaterial.getValueAt(row, TransferenciaEstoque.this.modeloMaterial.findColumn("Objeto"));
            if (lancto != null && (material = lancto.getMaterial()) != null && material.getSolicitarPatrimonio() != null && material.getSolicitarPatrimonio().booleanValue() && material.getImobilizado() != null && material.getImobilizado().booleanValue()) {
                c.setBackground(COR_SOLICITA_PATRIMONIO);
                if (selected && c.getBackground() != table.getSelectionBackground()) {
                    c.setBackground(ScreenUtil.escurecerCor(c.getBackground(), 30));
                }
            }
            if (focused) {
                Border border = selected ? UIManager.getBorder("Table.focusSelectedCellHighlightBorder") : UIManager.getBorder("Table.focusCellHighlightBorder");
                ((JComponent)c).setBorder(border);
                if (!selected && table.isCellEditable(row, column)) {
                    Color col = UIManager.getColor("Table.focusCellForeground");
                    if (col != null) {
                        c.setForeground(col);
                    }
                    if ((col = UIManager.getColor("Table.focusCellBackground")) != null) {
                        c.setBackground(col);
                    }
                }
            } else {
                ((JComponent)c).setBorder(noFocusBorder);
            }
            return c;
        }
    }
}

