/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.estoque.almoxarifado;

import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.Laboratorio;
import jalis.model.bean.estoque.MaterialBean;
import jalis.model.bean.estoque.MaterialLoteBean;
import jalis.service.estoque.MaterialService;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.util.Date;
import javax.swing.JScrollPane;
import javax.swing.JTable;

class SelecionarLote
extends AbstractDialogoOKCancelar {
    private ModeloGridTable modelo = new ModeloGridTable(new String[]{"Lote", "Data", "Validade", "Qtde"});
    private JTable table = new JTable(this.modelo);
    private JScrollPane scroll = new JScrollPane(this.table);

    public SelecionarLote(Frame pai) {
        super(pai, "Selecionar lote");
        this.montaTela();
    }

    private void montaTela() {
        this.setModal(true);
        this.setSize(new Dimension(360, 400));
        this.getPanelCentral().setLayout(new BorderLayout());
        this.getPanelCentral().add((Component)this.scroll, "Center");
        if (this.modelo.getRowCount() > 0) {
            this.table.setRowSelectionInterval(0, 0);
            ScreenUtil.requisitarFoco(this.table);
        }
    }

    public void setMaterial(String filial, String material) {
        this.modelo.clear();
        try {
            MaterialBean mat = (MaterialBean)new MaterialService().getAtivo(filial, material, null, null, true, false);
            if (mat != null && mat.getLotes() != null) {
                for (MaterialLoteBean b : mat.getLotes()) {
                    this.modelo.addLine(new String[]{b.getLote(), Funcoes.formataData(b.getDataHoraCriacao()), Funcoes.formataData(b.getValidadeLote()), Funcoes.formataDecimal(b.getQuantidade())});
                }
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
        }
    }

    @Override
    protected boolean acaoOk() {
        if (this.modelo.getRowCount() > 0 && this.table.getSelectedRow() < 0) {
            Funcoes.mensagem(this, "Nenhum lote foi selecionado", 2);
            return false;
        }
        return super.acaoOk();
    }

    public String getCodigoLoteSelecionado() {
        if (this.modelo.getRowCount() > 0 && this.table.getSelectedRow() > -1) {
            return this.modelo.getValueAt(this.table.getSelectedRow(), 0).toString();
        }
        return "";
    }

    public Date getDataLoteSelecionado() {
        if (this.modelo.getRowCount() > 0 && this.table.getSelectedRow() > -1) {
            String tmp = this.modelo.getValueAt(this.table.getSelectedRow(), 1).toString();
            if (Funcoes.verificaData(tmp)) {
                return Funcoes.stringToDate(tmp);
            }
            return null;
        }
        return null;
    }

    public Date getValidadeLoteSelecionado() {
        if (this.modelo.getRowCount() > 0 && this.table.getSelectedRow() > -1) {
            String tmp = this.modelo.getValueAt(this.table.getSelectedRow(), 2).toString();
            if (Funcoes.verificaData(tmp)) {
                return Funcoes.stringToDate(tmp);
            }
            return null;
        }
        return null;
    }
}

