/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.estoque.almoxarifado;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Pesquisas;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmPadrao;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.cadastro.VisualizarMateriaisAlternativos;
import jalis.laboratorio.relatorios.estoque.almoxarifado.RelatorioRequisicaoMaterial;
import jalis.model.bean.estoque.CelulaEstoqueBean;
import jalis.model.bean.estoque.MaterialBean;
import jalis.model.bean.estoque.RequisicaoEstoqueBean;
import jalis.model.bean.estoque.RequisicaoEstoqueMaterialBean;
import jalis.model.bean.estoque.SaldoEstoqueCelulaBean;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.model.vo.estoque.CelulaEstoqueVO;
import jalis.model.vo.estoque.MaterialVO;
import jalis.model.vo.estoque.RequisicaoEstoqueVO;
import jalis.service.estoque.CelulaEstoqueService;
import jalis.service.estoque.MaterialService;
import jalis.service.estoque.RequisicaoEstoqueService;
import jalis.service.estoque.SaldoEstoqueCelulaService;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.SteppedComboBox;
import jalis.util.TTextAreaDocument;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class RequisicaoMaterial
extends FrmPadrao
implements ActionListener,
FocusListener {
    private JButton buttonBuscaMaterial = ComponenteFactory.novoJButton(this, true);
    private JButton buttonEditar = ComponenteFactory.novoJButton("Editar", 'E', this);
    private JButton buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this);
    private JButton buttonFechar = ComponenteFactory.novoJButton("Fechar", 'F', this);
    private JButton buttonNovo = ComponenteFactory.novoJButton("Novo", 'N', this);
    private JButton buttonSalvar = ComponenteFactory.novoJButton("Salvar", 'S', this);
    private JButton buttonExcluir = ComponenteFactory.novoJButton("Excluir", 'x', this);
    private JButton buttonOK = ComponenteFactory.novoJButton("OK", 'O', this);
    private JButton buttonImprimir = ComponenteFactory.novoJButton("Imprimir", 'I', this);
    private JTable tabelaMaterial;
    private JScrollPane jScrollPane1;
    private ModeloGridTable modelo = null;
    private JLabel labelData;
    private JLabel labelDescData;
    private JLabel labelDescMaterial;
    private JLabel labelDescUsuario;
    private JLabel labelMaterial;
    private JLabel labelNova;
    private JLabel labelUsuario;
    private JLabel labelSituacao;
    private JLabel labelVlrSituacao;
    private JLabel labelCelula;
    private JLabel labelUnidade = new JLabel("Unid.");
    private JLabel labelVlrUnidade = new JLabel();
    private SteppedComboBox comboCelula;
    private JLabel labelObs = new JLabel("Observa\u00e7\u00e3o:");
    private JPanel panelBotoes;
    private JPanel panelData;
    private JPanel panelCentro = new JPanel(new GridBagLayout());
    private TTextField textCodigoMaterial = new TTextField(18, 3);
    private TTextField textQuantidade = new TTextField(10, 2);
    private JTextArea textObs = new JTextArea(new TTextAreaDocument(500));
    private JScrollPane scrollObs = new JScrollPane(this.textObs);
    private int status = 1;
    private Date dataAux = null;
    private UsuarioVO usuarioAux = null;
    private MaterialBean materialAux = null;
    private int codigoAux = -1;
    private boolean isAlterandoMaterial = false;
    private int COLUNA_CODIGO_MATERIAL = 0;
    private int COLUNA_MATERIAL = 1;
    private int COLUNA_QTDE_MATERIAL = 2;
    private int COLUNA_UNIDADE = 3;
    private int COLUNA_SALDO_CELULA = 4;
    private int COLUNA_OBJETO = 5;

    public RequisicaoMaterial() {
        this.montaTela();
        this.controlaCampos();
    }

    private void montaTela() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.panelCentro, "Center");
        Funcoes.criaBarraDescricao(this, "Requisi\u00e7\u00e3o de Material", "Requisi\u00e7\u00e3o de materiais", "estoque/requisicao_material.jpg");
        Funcoes.montaEnter((JComponent)this.panelCentro);
        this.panelCentro.setBorder(ScreenUtil.criarBordaVazia());
        this.labelVlrUnidade.setBorder(BorderFactory.createTitledBorder(""));
        this.panelBotoes = new JPanel();
        this.labelMaterial = new JLabel();
        this.labelNova = new JLabel();
        this.panelData = new JPanel();
        this.labelUsuario = new JLabel();
        this.labelDescData = new JLabel();
        this.labelDescUsuario = new JLabel();
        this.labelData = new JLabel();
        this.labelDescMaterial = new JLabel();
        this.labelSituacao = new JLabel();
        this.labelVlrSituacao = new JLabel();
        this.labelCelula = new JLabel();
        this.comboCelula = new SteppedComboBox(200);
        this.modelo = Acesso.getAcesso(RequisicaoMaterial.getModuloVisualizaEstoque()) ? new ModeloGridTable(new String[]{"C\u00f3digo", "Material", "Quantidade", "Unid.", "Estoque"}){

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return super.getColumnClass(columnIndex);
            }
        } : new ModeloGridTable(new String[]{"C\u00f3digo", "Material", "Quantidade", "Unid."}){

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return super.getColumnClass(columnIndex);
            }
        };
        this.tabelaMaterial = new JTable(this.modelo);
        if (Acesso.getAcesso(RequisicaoMaterial.getModuloVisualizaEstoque())) {
            this.modelo.setColumnSize(new int[]{60, 0, 90, 60, 55}, this.tabelaMaterial);
        } else {
            this.modelo.setColumnSize(new int[]{60, 0, 90, 60}, this.tabelaMaterial);
        }
        this.tabelaMaterial.getTableHeader().addMouseListener(this.modelo);
        this.jScrollPane1 = new JScrollPane(this.tabelaMaterial);
        this.tabelaMaterial.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
            }
        });
        this.tabelaMaterial.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int row;
                if (e.getKeyCode() == 127) {
                    int resp = Funcoes.mensagem(RequisicaoMaterial.this, "Deseja remover o material?", 4);
                    if (resp == 0) {
                        int row2 = ((JTable)e.getSource()).getSelectedRow();
                        RequisicaoMaterial.this.modelo.removeLine(row2);
                    }
                } else if (e.getKeyCode() == 32 && (row = ((JTable)e.getSource()).getSelectedRow()) >= 0) {
                    RequisicaoEstoqueMaterialBean material = (RequisicaoEstoqueMaterialBean)RequisicaoMaterial.this.modelo.getValueAt(row, RequisicaoMaterial.this.COLUNA_OBJETO);
                    MaterialBean beanMaterial = null;
                    try {
                        beanMaterial = (MaterialBean)new MaterialService().getTodos(String.valueOf(material.getFilial().getCodigo()), String.valueOf(material.getMaterial().getCodigo()), null, null);
                    }
                    catch (Exception e1) {
                        Funcoes.mensagem(RequisicaoMaterial.this, "N\u00e3o foi poss\u00edvel carregar os dados do material.", 2);
                        return;
                    }
                    RequisicaoMaterial.this.isAlterandoMaterial = true;
                    RequisicaoMaterial.this.materialAux = beanMaterial;
                    RequisicaoMaterial.this.textCodigoMaterial.setText(String.valueOf(beanMaterial.getCodigo()));
                    RequisicaoMaterial.this.labelDescMaterial.setText(beanMaterial.getDescricao());
                    RequisicaoMaterial.this.labelVlrUnidade.setText(beanMaterial.getUnidadeMedida().getCodigo());
                    RequisicaoMaterial.this.textQuantidade.setText(Funcoes.formataDecimal(material.getQuantidade()));
                    RequisicaoMaterial.this.controlaCampos();
                    if (RequisicaoMaterial.this.textCodigoMaterial.isFocusable() && RequisicaoMaterial.this.textCodigoMaterial.isEnabled()) {
                        RequisicaoMaterial.this.textCodigoMaterial.grabFocus();
                    }
                }
            }
        });
        this.tabelaMaterial.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (RequisicaoMaterial.this.isAlterandoMaterial) {
                    RequisicaoMaterial.this.textCodigoMaterial.setText("");
                    RequisicaoMaterial.this.labelDescMaterial.setText("");
                    RequisicaoMaterial.this.labelVlrUnidade.setText("");
                    RequisicaoMaterial.this.textQuantidade.setText("");
                    RequisicaoMaterial.this.isAlterandoMaterial = false;
                    RequisicaoMaterial.this.controlaCampos();
                }
            }
        });
        this.comboCelula.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (RequisicaoMaterial.this.comboCelula.getSelectedIndex() > -1) {
                    RequisicaoMaterial.this.atualizaSaldoMaterial();
                }
            }
        });
        this.labelData.setText("Data:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 0, 0, 0);
        this.panelCentro.add((Component)this.labelData, gridBagConstraints);
        JPanel panelBotaoImprimir = new JPanel(new FlowLayout(0));
        JPanel panelBotoesBasicos = new JPanel(new FlowLayout(2));
        this.panelBotoes.setLayout(new GridBagLayout());
        this.panelBotoes.add(panelBotaoImprimir);
        GridBagConstraints g = new GridBagConstraints();
        g.fill = 2;
        g.weightx = 2.0;
        this.panelBotoes.add((Component)new JLabel(), g);
        this.panelBotoes.add(panelBotoesBasicos);
        this.buttonImprimir.setText("Imprimir");
        panelBotaoImprimir.add(this.buttonImprimir);
        this.buttonNovo.setText("Novo");
        panelBotoesBasicos.add(this.buttonNovo);
        if (Acesso.getAcesso(RequisicaoMaterial.getModuloEditar())) {
            this.buttonEditar.setText("Editar");
            panelBotoesBasicos.add(this.buttonEditar);
        }
        this.buttonSalvar.setText("Salvar");
        panelBotoesBasicos.add(this.buttonSalvar);
        this.buttonCancelar.setText("Cancelar");
        panelBotoesBasicos.add(this.buttonCancelar);
        panelBotoesBasicos.add(this.buttonExcluir);
        this.buttonFechar.setText("Fechar");
        panelBotoesBasicos.add(this.buttonFechar);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.panelCentro.add((Component)this.panelBotoes, gridBagConstraints);
        this.labelMaterial.setText("Material");
        this.labelMaterial.setDisplayedMnemonic('M');
        this.labelMaterial.setLabelFor(this.textCodigoMaterial);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.panelCentro.add((Component)this.labelMaterial, gridBagConstraints);
        this.labelNova.setText("Quantidade");
        this.labelNova.setDisplayedMnemonic('Q');
        this.labelNova.setLabelFor(this.textQuantidade);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.panelCentro.add((Component)this.labelNova, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.panelCentro.add((Component)this.labelUnidade, gridBagConstraints);
        this.panelData.setPreferredSize(new Dimension(100, 21));
        this.panelData.setLayout(new GridBagLayout());
        this.labelUsuario.setText("Usu\u00e1rio:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(1, 15, 0, 0);
        this.panelData.add((Component)this.labelUsuario, gridBagConstraints);
        this.labelCelula.setText("C\u00e9lula:");
        this.labelCelula.setDisplayedMnemonic('u');
        this.labelCelula.setLabelFor(this.comboCelula);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(1, 15, 0, 0);
        this.panelData.add((Component)this.labelCelula, gridBagConstraints);
        this.labelSituacao.setText("Situa\u00e7\u00e3o:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(1, 15, 0, 0);
        this.panelData.add((Component)this.labelSituacao, gridBagConstraints);
        this.labelDescData.setBorder(BorderFactory.createTitledBorder(""));
        this.labelDescData.setMinimumSize(new Dimension(85, 20));
        this.labelDescData.setPreferredSize(new Dimension(85, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 0, 0, 0);
        this.panelData.add((Component)this.labelDescData, gridBagConstraints);
        this.labelDescUsuario.setBorder(BorderFactory.createTitledBorder(""));
        this.labelDescUsuario.setMinimumSize(new Dimension(24, 20));
        this.labelDescUsuario.setPreferredSize(new Dimension(24, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 0, 0, 0);
        this.panelData.add((Component)this.labelDescUsuario, gridBagConstraints);
        this.comboCelula.setMinimumSize(new Dimension(24, 20));
        this.comboCelula.setPreferredSize(new Dimension(24, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 0, 0, 0);
        this.panelData.add((Component)this.comboCelula, gridBagConstraints);
        this.labelVlrSituacao.setBorder(BorderFactory.createTitledBorder(""));
        this.labelVlrSituacao.setMinimumSize(new Dimension(24, 20));
        this.labelVlrSituacao.setPreferredSize(new Dimension(24, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 0, 0, 0);
        this.panelData.add((Component)this.labelVlrSituacao, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.panelCentro.add((Component)this.panelData, gridBagConstraints);
        this.buttonBuscaMaterial.setMaximumSize(new Dimension(20, 20));
        this.buttonBuscaMaterial.setMinimumSize(new Dimension(20, 20));
        this.buttonBuscaMaterial.setPreferredSize(new Dimension(20, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        this.panelCentro.add((Component)this.buttonBuscaMaterial, gridBagConstraints);
        this.buttonOK.setText("OK");
        this.buttonOK.setMargin(new Insets(1, 1, 1, 1));
        this.buttonOK.setMaximumSize(new Dimension(40, 20));
        this.buttonOK.setMinimumSize(new Dimension(40, 20));
        this.buttonOK.setPreferredSize(new Dimension(40, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        this.panelCentro.add((Component)this.buttonOK, gridBagConstraints);
        this.labelDescMaterial.setBorder(BorderFactory.createTitledBorder(""));
        this.labelDescMaterial.setMaximumSize(new Dimension(12, 20));
        this.labelDescMaterial.setMinimumSize(new Dimension(12, 20));
        this.labelDescMaterial.setPreferredSize(new Dimension(12, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.panelCentro.add((Component)this.labelDescMaterial, gridBagConstraints);
        this.textCodigoMaterial.addFocusListener(this);
        this.textCodigoMaterial.setMinimumSize(new Dimension(70, 20));
        this.textCodigoMaterial.setPreferredSize(new Dimension(70, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        this.panelCentro.add((Component)this.textCodigoMaterial, gridBagConstraints);
        this.textQuantidade.setMinimumSize(new Dimension(100, 20));
        this.textQuantidade.setPreferredSize(new Dimension(100, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        this.panelCentro.add((Component)this.textQuantidade, gridBagConstraints);
        this.labelVlrUnidade.setMinimumSize(new Dimension(65, 20));
        this.labelVlrUnidade.setPreferredSize(new Dimension(65, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        this.panelCentro.add((Component)this.labelVlrUnidade, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panelCentro.add((Component)this.jScrollPane1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        this.labelObs.setDisplayedMnemonic('b');
        this.labelObs.setLabelFor(this.textObs);
        this.panelCentro.add((Component)this.labelObs, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.scrollObs.setPreferredSize(new Dimension(100, 60));
        this.scrollObs.setMinimumSize(new Dimension(100, 60));
        this.scrollObs.setMaximumSize(new Dimension(100, 60));
        this.panelCentro.add((Component)this.scrollObs, gridBagConstraints);
    }

    private void buscaCelulasEstoqueCombo(JComboBox combo) {
        if (combo == null) {
            return;
        }
        combo.removeAllItems();
        CelulaEstoqueBean celulaPadrao = null;
        try {
            celulaPadrao = new CelulaEstoqueService().getCelulaPadraoEstacao(Variaveis.filialPadrao);
        }
        catch (Exception e) {
            Funcoes.mensagem(this.getTopLevelAncestor(), "A c\u00e9lula de estoque padr\u00e3o da esta\u00e7\u00e3o n\u00e3o est\u00e1 configurada corretamente.\n A c\u00e9lula de estoque padr\u00e3o do sistema ser\u00e1 utilizada.", 2);
            return;
        }
        if (Acesso.getAcesso(RequisicaoMaterial.getAcessoAlterarCelula())) {
            ArrayList<CelulaEstoqueBean> celulas = null;
            try {
                celulas = new CelulaEstoqueService().getTodasCelulasFilial(Variaveis.filialPadrao);
            }
            catch (ThreadDaoException e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage() + ".\nN\u00e3o foi poss\u00edvel buscar dados das c\u00e9lulas de estoque.", e.getStackTrace());
            }
            if (celulas != null) {
                int posSelecionada = 0;
                String celulaEstoqueEstacao = ParametrosLocais.getParametro("celulaEstoque") == null ? "" : ParametrosLocais.getParametro("celulaEstoque");
                for (int i = 0; i < celulas.size(); ++i) {
                    CelulaEstoqueBean bean = celulas.get(i);
                    combo.addItem(bean);
                    if (Funcoes.textoVazio(celulaEstoqueEstacao)) {
                        if (!bean.getPadrao().booleanValue()) continue;
                        posSelecionada = i;
                        continue;
                    }
                    if (!bean.getCodigo().toString().equals(celulaEstoqueEstacao)) continue;
                    posSelecionada = i;
                }
                combo.setSelectedIndex(posSelecionada);
            }
        } else {
            combo.addItem(celulaPadrao);
        }
    }

    public static long getModuloAcesso() {
        return Long.parseLong("1200300600");
    }

    public static long getAcessoAlterarCelula() {
        return Long.parseLong("1200300601");
    }

    public static long getModuloEditar() {
        return Long.parseLong("1200300602");
    }

    public static long getModuloVisualizaEstoque() {
        return Long.parseLong("1200300603");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonImprimir) {
            this.imprimir();
        } else if (e.getSource() == this.buttonFechar) {
            this.fechar();
        } else if (e.getSource() == this.buttonNovo) {
            this.novo();
        } else if (e.getSource() == this.buttonEditar) {
            this.editar();
        } else if (e.getSource() == this.buttonCancelar) {
            this.cancelar();
        } else if (e.getSource() == this.buttonSalvar) {
            this.salvarSemFechar();
        } else if (e.getSource() == this.buttonBuscaMaterial) {
            this.pesquisaMaterial(null);
        } else if (e.getSource() == this.buttonOK) {
            if (this.materialAux == null) {
                Funcoes.mensagem(this, "Selecione um material.", 2);
                if (this.textCodigoMaterial.isEnabled() && this.textCodigoMaterial.isFocusable()) {
                    ScreenUtil.requisitarFoco(this.textCodigoMaterial);
                }
                return;
            }
            if (this.textQuantidade.getText().isEmpty() || Funcoes.isNumeric(this.textQuantidade.getText()) && Double.parseDouble(this.textQuantidade.getText()) == 0.0) {
                Funcoes.mensagem(this, "Insira a quantidade do material.", 2);
                if (this.textQuantidade.isEnabled() && this.textQuantidade.isFocusable()) {
                    ScreenUtil.requisitarFoco(this.textQuantidade);
                }
                return;
            }
            RequisicaoEstoqueMaterialBean material = new RequisicaoEstoqueMaterialBean();
            FilialVO filial = new FilialVO();
            filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
            material.setFilial(filial);
            material.setMaterial((MaterialVO)this.materialAux.toVO());
            material.setQuantidade(Double.parseDouble(Funcoes.limpaDecimal(this.textQuantidade.getText())));
            if (this.adicionaMaterial(material)) {
                this.textCodigoMaterial.setText("");
                this.labelDescMaterial.setText("");
                this.labelVlrUnidade.setText("");
                this.textQuantidade.setText("");
                this.isAlterandoMaterial = false;
                this.materialAux = null;
            }
            if (this.textCodigoMaterial.isFocusable() && this.textCodigoMaterial.isEnabled()) {
                this.textCodigoMaterial.grabFocus();
            }
        } else if (e.getSource() == this.buttonExcluir) {
            this.excluir();
        }
    }

    private boolean adicionaMaterial(RequisicaoEstoqueMaterialBean material) {
        for (int i = 0; i < this.modelo.getRowCount(); ++i) {
            RequisicaoEstoqueMaterialBean aux = (RequisicaoEstoqueMaterialBean)this.modelo.getValueAt(i, this.COLUNA_OBJETO);
            if (aux == null || material == null || aux.getMaterial().getCodigo().intValue() != material.getMaterial().getCodigo().intValue()) continue;
            if (!this.isAlterandoMaterial) {
                Funcoes.mensagem(this, "Material j\u00e1 inserido.", 2);
                if (this.textCodigoMaterial.isFocusable() && this.textCodigoMaterial.isEnabled()) {
                    this.textCodigoMaterial.grabFocus();
                }
                return false;
            }
            this.modelo.removeLine(i);
            break;
        }
        SaldoEstoqueCelulaBean saldoCelula = null;
        try {
            saldoCelula = (SaldoEstoqueCelulaBean)new SaldoEstoqueCelulaService().getSaldoAtualEstoqueMaterialCelula(Variaveis.filialPadrao, material.getMaterial().getCodigo().toString(), ((CelulaEstoqueBean)this.comboCelula.getSelectedItem()).getCodigo().toString());
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel buscar saldo de estoque. " + ex.getMessage(), ex.getStackTrace());
        }
        Double estoque = saldoCelula != null ? saldoCelula.getSaldo() : 0.0;
        this.modelo.addLine(new Object[]{material.getMaterial().getCodigo(), material.getMaterial().getDescricao(), Funcoes.formataDecimal(material.getQuantidade()), material.getMaterial().getUnidadeMedida().getCodigo(), Funcoes.formataDecimal(estoque), material});
        if (this.modelo.getColunaOrdenacao() != -1) {
            this.modelo.ordenarColunaSemTrocarSentido(this.modelo.getColunaOrdenacao());
        } else {
            this.modelo.ordenarColunaSemTrocarSentido(this.COLUNA_MATERIAL);
        }
        this.controlaCampos();
        return true;
    }

    private void atualizaSaldoMaterial() {
        if (this.modelo.getRowCount() > 0) {
            for (int i = 0; i < this.modelo.getRowCount(); ++i) {
                RequisicaoEstoqueMaterialBean mat = (RequisicaoEstoqueMaterialBean)this.modelo.getValueAt(i, this.COLUNA_OBJETO);
                SaldoEstoqueCelulaBean saldoCelula = null;
                try {
                    saldoCelula = (SaldoEstoqueCelulaBean)new SaldoEstoqueCelulaService().getSaldoAtualEstoqueMaterialCelula(Variaveis.filialPadrao, mat.getMaterial().getCodigo().toString(), ((CelulaEstoqueBean)this.comboCelula.getSelectedItem()).getCodigo().toString());
                }
                catch (Exception ex) {
                    ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel buscar saldo de estoque. " + ex.getMessage(), ex.getStackTrace());
                }
                Double estoque = saldoCelula != null ? saldoCelula.getSaldo() : 0.0;
                this.modelo.setValueAt(Funcoes.formataDecimal(estoque), i, this.COLUNA_SALDO_CELULA);
            }
        }
    }

    private void imprimir() {
        int resp = -1;
        resp = this.getStatus() != 1 ? Funcoes.mensagem(this, "A requisi\u00e7\u00e3o deve ser salva antes de ser impressa.\nDeseja salvar a requisi\u00e7\u00e3o?", 4) : 0;
        if (resp == 0) {
            int codigo = -1;
            codigo = this.getStatus() != 1 ? this.salvarSemFechar() : this.codigoAux;
            if (codigo > -1) {
                RelatorioRequisicaoMaterial relatorio = new RelatorioRequisicaoMaterial(1);
                relatorio.imprimirPressionado(codigo);
                JDialog aux = new JDialog(Laboratorio.getInstancia(), "Imprimir Requisi\u00e7\u00e3o de Material", true);
                aux.setSize(700, 600);
                aux.setContentPane(relatorio);
                ScreenUtil.centralizar(aux);
                aux.setVisible(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pesquisaMaterial(String codigoMaterial) {
        this.materialAux = null;
        Hashtable hash = null;
        if (codigoMaterial == null) {
            hash = Pesquisas.materialAtivo(Laboratorio.getInstancia(), true);
        }
        if (hash != null || hash == null && codigoMaterial != null) {
            MaterialBean bean = null;
            try {
                Conexao.setSessaoConexao(true);
                bean = hash != null ? (MaterialBean)new MaterialService().getAtivo(Variaveis.filialPadrao, String.valueOf((Integer)hash.get("mat_codigo")), null, null) : (MaterialBean)new MaterialService().getAtivo(Variaveis.filialPadrao, codigoMaterial, null, null);
                if (bean == null) {
                    bean = VisualizarMateriaisAlternativos.getTelaMaterialAlternativo(bean, this.textCodigoMaterial);
                }
                this.materialAux = bean;
            }
            catch (Exception e1) {
                Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel buscar dados do material.", 2);
                return;
            }
            finally {
                Conexao.setSessaoConexao(false);
            }
            if (bean != null) {
                this.textCodigoMaterial.setText(String.valueOf(bean.getCodigo()));
                this.labelDescMaterial.setText(bean.getDescricao());
                this.labelVlrUnidade.setText(bean.getUnidadeMedida().getCodigo());
            } else {
                this.textCodigoMaterial.selectAll();
                this.labelVlrUnidade.setText("");
                this.labelDescMaterial.setText("N\u00e3o cadastrado");
            }
        }
    }

    public int salvarSemFechar() {
        RequisicaoEstoqueBean bean;
        RequisicaoEstoqueService service = new RequisicaoEstoqueService();
        if (this.validaCampos() && (bean = this.getBeanPreenchido()) != null) {
            try {
                service.gravaAutoCopiaSemCommit(bean, this.getStatus() == 2 ? 0 : 1, Variaveis.filialPadrao, this.getCopiaFiliais());
                Conexao.arquivaSQL();
                service.enviaMensagemResponsavel(bean, this.getStatus() == 3);
                this.setStatus(1);
                this.controlaCampos();
                this.limparCampos();
                this.buttonImprimir.setEnabled(true);
                this.codigoAux = bean.getCodigo();
                return bean.getCodigo();
            }
            catch (Exception e) {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                Funcoes.mensagem(this.getTopLevelAncestor(), "N\u00e3o foi poss\u00edvel salvar a requisi\u00e7\u00e3o de estoque.", 2);
            }
        }
        return -1;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    private String getCopiaFiliais() {
        return null;
    }

    @Override
    public void pressioneiF2() {
        if (this.textCodigoMaterial.hasFocus()) {
            this.pesquisaMaterial(null);
        }
    }

    private void cancelar() {
        if (Funcoes.mensagem(this, "As informa\u00e7\u00f5es adicionadas ser\u00e3o perdidas.", 4) == 0) {
            this.limparCampos();
            this.status = 1;
            this.controlaCampos();
        }
    }

    private void controlaCampos() {
        boolean habilitar = this.status == 2 || this.status == 3;
        this.textCodigoMaterial.setEnabled(habilitar);
        this.textObs.setEnabled(habilitar);
        this.textQuantidade.setEnabled(habilitar);
        this.buttonBuscaMaterial.setEnabled(habilitar);
        this.buttonOK.setEnabled(habilitar);
        this.buttonSalvar.setEnabled(habilitar);
        this.buttonCancelar.setEnabled(habilitar);
        this.buttonNovo.setEnabled(!habilitar);
        this.buttonExcluir.setEnabled(this.status == 1);
        this.buttonFechar.setEnabled(!habilitar);
        this.buttonEditar.setEnabled(!habilitar);
        this.buttonImprimir.setEnabled(habilitar);
        this.comboCelula.setEnabled(habilitar);
    }

    private void limparCampos() {
        this.textCodigoMaterial.clear();
        this.textObs.setText("");
        this.textQuantidade.clear();
        this.modelo.clear();
        this.labelVlrUnidade.setText("");
        this.labelDescData.setText("");
        this.labelDescMaterial.setText("");
        this.labelDescUsuario.setText("");
        this.labelVlrSituacao.setText("");
        this.comboCelula.removeAllItems();
        this.dataAux = null;
        this.usuarioAux = null;
        this.materialAux = null;
        this.codigoAux = -1;
        this.isAlterandoMaterial = false;
    }

    private void editar() {
        this.limparCampos();
        RequisicaoEstoqueVO reqVO = new RequisicaoEstoqueVO();
        reqVO = (RequisicaoEstoqueVO)new RequisicaoEstoqueService().pesquisaRequisicaoAbertaVO(Laboratorio.getInstancia(), reqVO, "Pesquisando Requisi\u00e7\u00f5es de Estoque", false);
        if (reqVO != null) {
            RequisicaoEstoqueBean reqBean = null;
            try {
                reqBean = (RequisicaoEstoqueBean)new RequisicaoEstoqueService().get(Variaveis.filialPadrao, reqVO.getCodigo().toString());
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "RequisicaoMaterial:editar");
                return;
            }
            if (reqBean != null) {
                this.preencherCampos(reqBean);
                this.setStatus(3);
                this.controlaCampos();
            }
        }
    }

    private void preencherCampos(RequisicaoEstoqueBean bean) {
        if (bean != null) {
            this.codigoAux = bean.getCodigo();
            this.dataAux = bean.getDataHora();
            this.usuarioAux = bean.getUsuario();
            this.labelDescData.setText(Funcoes.formataData("dd/MM/yyyy HH:mm:ss", bean.getDataHora()));
            this.labelDescUsuario.setText(bean.getUsuario().getCodigo());
            this.labelVlrSituacao.setText(Tipos.getSituacaoRequisicaoEstoque(bean.getSituacao()));
            this.textObs.setText(bean.getObservacao());
            if (!Acesso.getAcesso(RequisicaoMaterial.getAcessoAlterarCelula())) {
                try {
                    this.comboCelula.addItem(new CelulaEstoqueService().get(bean.getCelulaEstoque().getFilial().getCodigo().toString(), bean.getCelulaEstoque().getCodigo().toString()));
                }
                catch (Exception e) {
                    ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
                }
            } else {
                this.buscaCelulasEstoqueCombo(this.comboCelula);
                for (int i = 0; i < this.comboCelula.getItemCount(); ++i) {
                    if (((CelulaEstoqueBean)this.comboCelula.getItemAt(i)).getCodigo().intValue() != bean.getCelulaEstoque().getCodigo().intValue()) continue;
                    this.comboCelula.setSelectedIndex(i);
                    break;
                }
            }
            for (int i = 0; i < bean.getMateriais().size(); ++i) {
                RequisicaoEstoqueMaterialBean material = bean.getMateriais().get(i);
                if (material == null) continue;
                this.adicionaMaterial(material);
            }
        }
    }

    private void novo() {
        this.limparCampos();
        this.status = 2;
        this.controlaCampos();
        this.dataAux = new Date();
        this.usuarioAux = new UsuarioVO();
        this.usuarioAux.setCodigo(Variaveis.login);
        this.labelDescData.setText(Funcoes.formataData("dd/MM/yyyy", this.dataAux));
        this.labelDescUsuario.setText(this.usuarioAux.getCodigo());
        this.labelVlrSituacao.setText(Tipos.getSituacaoRequisicaoEstoque("A"));
        this.buscaCelulasEstoqueCombo(this.comboCelula);
        if (this.comboCelula.getSelectedObjects().length < 1) {
            Funcoes.mensagem(this, "N\u00e3o existe c\u00e9lula de estoque cadastrada.", 2);
            this.limparCampos();
            this.status = 1;
            this.controlaCampos();
            return;
        }
        if (this.textCodigoMaterial.isFocusable() && this.textCodigoMaterial.isEnabled()) {
            this.textCodigoMaterial.grabFocus();
        }
    }

    private void fechar() {
        this.setVisible(false);
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (e.getSource() == this.textCodigoMaterial && !this.textCodigoMaterial.getText().isEmpty()) {
            this.pesquisaMaterial(this.textCodigoMaterial.getText());
        }
    }

    private boolean validaCampos() {
        if (this.modelo.getRowCount() <= 0) {
            Funcoes.mensagem(this, "Pelo menos um material deve ser adicionado.", 2);
            if (this.textCodigoMaterial.isFocusable() && this.textCodigoMaterial.isEnabled()) {
                this.textCodigoMaterial.grabFocus();
            }
            return false;
        }
        return true;
    }

    private RequisicaoEstoqueBean getBeanPreenchido() {
        RequisicaoEstoqueBean bean = new RequisicaoEstoqueBean();
        FilialVO filial = new FilialVO();
        filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
        bean.setFilial(filial);
        if (this.codigoAux != -1) {
            bean.setCodigo(this.codigoAux);
        }
        bean.setDataHora(this.dataAux);
        bean.setObservacao(this.textObs.getText());
        bean.setUsuario(this.usuarioAux);
        bean.setCelulaEstoque((CelulaEstoqueVO)((CelulaEstoqueBean)this.comboCelula.getSelectedItem()).toVO());
        bean.setSituacao(Tipos.situacaoRequisicaoEstoque(this.labelVlrSituacao.getText()));
        bean.setOrigem("R");
        ArrayList<RequisicaoEstoqueMaterialBean> materiais = new ArrayList<RequisicaoEstoqueMaterialBean>();
        for (int i = 0; i < this.modelo.getRowCount(); ++i) {
            materiais.add((RequisicaoEstoqueMaterialBean)this.modelo.getValueAt(i, this.COLUNA_OBJETO));
        }
        bean.setMateriais(materiais);
        return bean;
    }

    private void excluir() {
        RequisicaoEstoqueService service = new RequisicaoEstoqueService();
        RequisicaoEstoqueVO requisicaoVO = (RequisicaoEstoqueVO)service.pesquisaRequisicaoAbertaVO(Laboratorio.getInstancia(), new RequisicaoEstoqueVO(), "Pesquisando requisi\u00e7\u00f5es de material abertas", false);
        if (requisicaoVO == null) {
            return;
        }
        RequisicaoEstoqueBean requisicaoBean = null;
        try {
            requisicaoBean = (RequisicaoEstoqueBean)service.get(requisicaoVO.getFilial().getCodigo().toString(), requisicaoVO.getCodigo().toString());
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar os dados da requisi\u00e7\u00e3o de material.\n" + e.getMessage(), e.getStackTrace());
            return;
        }
        if (requisicaoBean == null) {
            Funcoes.mensagem(this, "Os dados da requisi\u00e7\u00e3o de material n\u00e3o foram carregados.", 2);
            return;
        }
        this.preencherCampos(requisicaoBean);
        if (Funcoes.mensagem(Laboratorio.getInstancia(), "Deseja excluir o registro selecionado?", 4) == 0) {
            try {
                FilialVO filial = new FilialVO();
                filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
                UsuarioVO usuario = new UsuarioVO();
                usuario.setFilial(filial);
                usuario.setCodigo(Variaveis.login);
                requisicaoBean.setSituacao("C");
                requisicaoBean.setUsuarioCancelamento(usuario);
                requisicaoBean.setDataHoraCancelamento(new Date());
                service.gravaAutoCopiaSemCommit(requisicaoBean, 1, Variaveis.filialPadrao, this.getCopiaFiliais());
                Conexao.arquivaSQL();
            }
            catch (Exception e) {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel excluir requisi\u00e7\u00e3o de material.\n" + e.getMessage(), e.getStackTrace());
            }
        }
        this.limparCampos();
    }
}

