/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.estoque.almoxarifado;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.Laboratorio;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

class PreencherDadosEtiquetaAvulsa
extends AbstractDialogoOKCancelar {
    private ModeloGridTable modelo = new ModeloGridTable(new String[]{"Campo", "Valor"});
    private JTable table = new JTable(this.modelo);
    private TTextField textCampo = new TTextField();
    private TTextField textValor = new TTextField();
    private JButton buttonOK = ComponenteFactory.novoJButton("OK", 'K', this);
    private TTextField textQuantidade = new TTextField(3, 1);
    private ArrayList<String> camposLocalizados = new ArrayList();

    public PreencherDadosEtiquetaAvulsa(Frame pai, String titulo) {
        super(pai, titulo);
        this.montaTela();
    }

    private void montaTela() {
        this.modelo.clear();
        this.camposLocalizados.clear();
        this.textCampo.setEditable(false);
        JPanel p = this.getPanelCentral();
        p.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.anchor = 17;
        c.fill = 0;
        p.add((Component)new JLabel("Campo"), c);
        ++c.gridx;
        p.add((Component)new JLabel("Valor"), c);
        c.gridx = 0;
        c.gridy = 1;
        c.fill = 2;
        c.weightx = 1.0;
        this.textCampo.setPreferredSize(new Dimension(70, 20));
        this.textCampo.setMinimumSize(new Dimension(70, 20));
        p.add((Component)this.textCampo, c);
        c.gridx = 1;
        this.textValor.setPreferredSize(new Dimension(70, 20));
        this.textValor.setMinimumSize(new Dimension(70, 20));
        p.add((Component)this.textValor, c);
        c.gridx = 2;
        c.fill = 0;
        c.weightx = 0.0;
        this.buttonOK.setPreferredSize(new Dimension(40, 20));
        this.buttonOK.setMinimumSize(new Dimension(40, 20));
        this.buttonOK.setMaximumSize(new Dimension(40, 20));
        p.add((Component)this.buttonOK, c);
        c.gridx = 0;
        c.gridy = 2;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 3;
        p.add((Component)new JScrollPane(this.table), c);
        c.gridx = 0;
        c.gridy = 3;
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 3;
        JPanel pf = new JPanel(new FlowLayout(0));
        this.textQuantidade.setPreferredSize(new Dimension(100, 20));
        this.textQuantidade.setMinimumSize(new Dimension(100, 20));
        this.textQuantidade.setMaximumSize(new Dimension(100, 20));
        pf.add(new JLabel("Quantidade:"));
        pf.add(this.textQuantidade);
        p.add((Component)pf, c);
        this.setSize(new Dimension(380, 350));
        this.textQuantidade.setText("1");
        this.table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (PreencherDadosEtiquetaAvulsa.this.table.getSelectedRow() > -1 && e.getKeyCode() == 32) {
                    PreencherDadosEtiquetaAvulsa.this.textCampo.setText(PreencherDadosEtiquetaAvulsa.this.modelo.getValueAt(PreencherDadosEtiquetaAvulsa.this.table.getSelectedRow(), 0).toString());
                    PreencherDadosEtiquetaAvulsa.this.textValor.setText(PreencherDadosEtiquetaAvulsa.this.modelo.getValueAt(PreencherDadosEtiquetaAvulsa.this.table.getSelectedRow(), 1).toString());
                    ScreenUtil.requisitarFoco(PreencherDadosEtiquetaAvulsa.this.textValor);
                }
            }
        });
    }

    @Override
    protected boolean acaoOk() {
        if (Funcoes.textoVazio(this.textQuantidade)) {
            Funcoes.mensagem(this, "Quantidade n\u00e3o informada", 1);
            ScreenUtil.requisitarFoco(this.textQuantidade);
            return false;
        }
        return super.acaoOk();
    }

    public void setCamposPossiveis(String[] campos, String layout) {
        if (campos != null && !Funcoes.textoVazio(layout)) {
            for (String campo : campos) {
                if (layout.toUpperCase().indexOf(campo.toUpperCase()) <= -1) continue;
                this.camposLocalizados.add(campo);
            }
        }
        if (this.camposLocalizados.size() > 0) {
            for (String s : this.camposLocalizados) {
                this.modelo.addLine(new String[]{s, ""});
            }
        }
    }

    private void adicionarTabela() {
        if (this.modelo.getRowCount() == 0) {
            this.modelo.addLine(new String[]{this.textCampo.getText(), this.textValor.getText()});
        } else {
            int pos = this.modelo.localizar(0, this.textCampo.getText());
            if (pos > -1) {
                this.modelo.setValueAt(this.textValor.getText(), pos, 1);
            } else if (!Funcoes.textoVazio(this.textCampo.getText())) {
                this.modelo.addLine(new String[]{this.textCampo.getText(), this.textValor.getText()});
            }
        }
        this.textCampo.clear();
        this.textValor.clear();
        ScreenUtil.requisitarFoco(this.table);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonOK) {
            this.adicionarTabela();
        } else {
            super.actionPerformed(e);
        }
    }

    public static String getLayoutEtiqueta(Statement st, String filial) {
        StringBuilder buf = new StringBuilder();
        buf.append(" select lay_etiquetaestoque ");
        buf.append("       ,lay_tipoetiquetaestoque ");
        buf.append("   from layout ");
        buf.append("  where fil_codigo = ").append(filial);
        buf.append("    and lay_codigo = ").append(String.valueOf(ParametrosGerais.getLayCodigo()));
        try {
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                return rs.getString(1);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
        }
        return "";
    }

    public ModeloGridTable getModeloDados() {
        String[] campos = new String[this.modelo.getRowCount()];
        for (int i = 0; i < this.modelo.getRowCount(); ++i) {
            campos[i] = this.modelo.getValueAt(i, 0).toString();
        }
        ModeloGridTable retorno = new ModeloGridTable(campos);
        Object[] o = new Object[campos.length];
        for (int i = 0; i < campos.length; ++i) {
            String s = campos[i];
            int pos = this.modelo.localizar(0, s);
            if (pos <= -1) continue;
            o[i] = this.modelo.getValueAt(pos, 1);
        }
        retorno.addLine(o);
        return retorno;
    }

    public int getQuantidade() {
        return Funcoes.isNumeric(this.textQuantidade.getText()) ? Integer.parseInt(this.textQuantidade.getText()) : 1;
    }
}

