/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.estoque.almoxarifado;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.estoque.almoxarifado.DadosUltimosCustos;
import jalis.service.estoque.LancamentoEstoqueCmcService;
import jalis.service.estoque.LancamentoEstoquePepsService;
import jalis.service.estoque.LancamentoEstoqueUepsService;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;

public class PerguntarValorEstoque
extends JDialog {
    JPanel panelUltimosCustos = new JPanel(new BorderLayout());
    JPanel panelBotoes = new JPanel(new FlowLayout(2));
    JLabel labelPergunta = new JLabel("Informe o custo unit\u00e1rio do material:");
    TTextField textValor = new TTextField(12, 2, 4);
    JButton buttonOk = new JButton("OK");
    ModeloGridTable modeloCustos = null;
    JTable tableCustos = null;
    JScrollPane scrollCustos = null;
    Double valorUnitario = 0.0;
    private boolean isOK = false;
    private String codigoMaterial = null;
    private final int COLUNA_DATA = 0;
    private final int COLUNA_CUSTO = 1;
    private String novaQuantidade;
    private final int CASAS_MAIOR = 4;
    private final RoundingMode ROUND = ParametrosGerais.getArredondamentoPrecoExame();

    public PerguntarValorEstoque(final Frame owner, String codigoMaterial, final String novaQuantidade) {
        super(owner, "Entrada de Material", true);
        this.codigoMaterial = codigoMaterial;
        this.novaQuantidade = novaQuantidade;
        this.setSize(new Dimension(270, 200));
        this.setDefaultCloseOperation(0);
        this.setResizable(false);
        JPanel panel = (JPanel)this.getContentPane();
        panel.setLayout(new BorderLayout());
        this.textValor.setPreferredSize(new Dimension(20, 20));
        this.textValor.setMinimumSize(new Dimension(20, 20));
        this.buttonOk.setMnemonic('O');
        this.panelBotoes.add(this.buttonOk);
        JPanel panelPrincipal = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 1;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 1.0;
        c.weighty = 1.0;
        panelPrincipal.add((Component)this.panelUltimosCustos, c);
        ++c.gridy;
        c.weighty = 0.0;
        c.fill = 2;
        panelPrincipal.add((Component)this.labelPergunta, c);
        ++c.gridy;
        panelPrincipal.add((Component)this.textValor, c);
        this.modeloCustos = new ModeloGridTable(new String[]{"Data", "Custo", "Qtde."}){

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                if (columnIndex == 0) {
                    return Date.class;
                }
                if (columnIndex == 1) {
                    return String.class;
                }
                return Object.class;
            }
        };
        this.tableCustos = new JTable(this.modeloCustos);
        this.modeloCustos.setColumnSize(new int[]{85, 90, 0}, this.tableCustos);
        this.scrollCustos = new JScrollPane(this.tableCustos);
        this.panelUltimosCustos.setBorder(new TitledBorder("Custos das \u00faltimas entradas"));
        this.panelUltimosCustos.add((Component)this.scrollCustos, "Center");
        panel.add((Component)panelPrincipal, "Center");
        panel.add((Component)this.panelBotoes, "South");
        this.buttonOk.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                Double valor;
                block12: {
                    block11: {
                        Double d;
                        valor = 0.0;
                        if (Funcoes.textoVazio(PerguntarValorEstoque.this.textValor)) break block11;
                        valor = new Double(Funcoes.limpaDecimal(PerguntarValorEstoque.this.textValor.getText()));
                        if (!(d <= 0.0)) break block12;
                    }
                    Funcoes.mensagem(owner, "\u00c9 necess\u00e1rio preencher corretamente o valor unit\u00e1rio do material.", 2);
                    ScreenUtil.requisitarFoco(PerguntarValorEstoque.this.textValor);
                    return;
                }
                if (!Funcoes.textoVazio(novaQuantidade)) {
                    Double d;
                    valor = new Double(Funcoes.limpaDecimal(PerguntarValorEstoque.this.textValor.getText()));
                    if (d > 0.0) {
                        BigDecimal valorTotal = new BigDecimal(novaQuantidade).setScale(4, PerguntarValorEstoque.this.ROUND).multiply(new BigDecimal(PerguntarValorEstoque.this.textValor.getText()).setScale(4, PerguntarValorEstoque.this.ROUND));
                        String valorTotalValue = valorTotal.toString();
                        int posPonto = valorTotalValue.indexOf(".");
                        if (posPonto <= -1) return;
                        int quantidadeCasas = valorTotalValue.substring(0, posPonto).length();
                        if (quantidadeCasas <= 11) {
                            PerguntarValorEstoque.this.valorUnitario = valor;
                            PerguntarValorEstoque.this.isOK = true;
                            PerguntarValorEstoque.this.setVisible(false);
                            return;
                        }
                        try {
                            Conexao.anulaSQL();
                        }
                        catch (SQLException sQLException) {}
                        finally {
                            Funcoes.mensagem(Laboratorio.getInstancia(), "Valor informado n\u00e3o \u00e9 suportado.", 2);
                            ScreenUtil.requisitarFoco(PerguntarValorEstoque.this.textValor);
                            return;
                        }
                    }
                }
                PerguntarValorEstoque.this.valorUnitario = valor;
                PerguntarValorEstoque.this.isOK = true;
                PerguntarValorEstoque.this.setVisible(false);
            }
        });
        Funcoes.montaEnter((JComponent)panel);
        ScreenUtil.centralizar(this);
        this.carregarValoresCusto();
        ScreenUtil.requisitarFoco(this.textValor);
    }

    private void carregarValoresCusto() {
        String tipoCalculo = ParametrosGerais.getPerguntarValorEstoque();
        if (tipoCalculo != null) {
            if (tipoCalculo.equalsIgnoreCase("C")) {
                try {
                    this.preencherValoresCusto(new LancamentoEstoqueCmcService().getUltimosCustos(Variaveis.filialPadrao, this.codigoMaterial, 3));
                }
                catch (SQLException e) {
                    ErrorLogger.mostraMensagem(this.getOwner(), "N\u00e3o foi poss\u00edvel buscar \u00faltimos custos do material.\n" + e.getMessage(), e.getStackTrace());
                    return;
                }
            }
            if (tipoCalculo.equalsIgnoreCase("P")) {
                try {
                    this.preencherValoresCusto(new LancamentoEstoquePepsService().getUltimosCustos(Variaveis.filialPadrao, this.codigoMaterial, 3));
                }
                catch (SQLException e) {
                    ErrorLogger.mostraMensagem(this.getOwner(), "N\u00e3o foi poss\u00edvel buscar \u00faltimos custos do material.\n" + e.getMessage(), e.getStackTrace());
                    return;
                }
            }
            if (tipoCalculo.equalsIgnoreCase("U")) {
                try {
                    this.preencherValoresCusto(new LancamentoEstoqueUepsService().getUltimosCustos(Variaveis.filialPadrao, this.codigoMaterial, 3));
                }
                catch (SQLException e) {
                    ErrorLogger.mostraMensagem(this.getOwner(), "N\u00e3o foi poss\u00edvel buscar \u00faltimos custos do material.\n" + e.getMessage(), e.getStackTrace());
                    return;
                }
            }
        }
    }

    private void preencherValoresCusto(ArrayList<DadosUltimosCustos> dados) {
        if (dados != null) {
            for (DadosUltimosCustos aux : dados) {
                this.modeloCustos.addLine(new Object[]{aux.getData(), Funcoes.formataDecimal(aux.getCusto()), Funcoes.formataDecimal(aux.getQuantidade())});
            }
        }
    }

    public Double getValorUnitario() {
        return this.valorUnitario;
    }

    public void setValorUnitario(Double valorUnitario) {
        if (valorUnitario != null) {
            this.textValor.setText(Funcoes.formataDecimal(this.textValor.getMaskDecimal(), valorUnitario));
        }
    }

    public boolean isOk() {
        return this.isOK;
    }

    @Override
    public void setVisible(boolean visible) {
        this.textValor.selectAll();
        super.setVisible(visible);
    }
}

