/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.estoque.almoxarifado;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadrao;
import jalis.laboratorio.Laboratorio;
import jalis.model.bean.estoque.MaterialBean;
import jalis.model.bean.estoque.MaterialPatrimonioBean;
import jalis.model.bean.estoque.SaldoEstoqueBean;
import jalis.model.bean.estoque.SaldoEstoqueCelulaBean;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.exame.SetorVO;
import jalis.model.vo.estoque.MaterialVO;
import jalis.service.cadastro.exame.SetorService;
import jalis.service.estoque.MaterialPatrimonioService;
import jalis.service.estoque.MaterialService;
import jalis.service.estoque.SaldoEstoqueCelulaService;
import jalis.service.estoque.SaldoEstoqueService;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;

public class Patrimonios
extends FrmCadPadrao {
    private JButton buttonOk = new JButton("OK");
    private JButton buttonTamanhoPainel = new JButton("-");
    private JLabel labelDescricaoMaterial = new JLabel();
    private JLabel labelMaterial = new JLabel("Material:");
    private JLabel labelCodigoMaterial = new JLabel();
    private JLabel labelEstoqueTotal = new JLabel("Estoque Total:");
    private JLabel labelVlrEstoqueTotal = new JLabel();
    private JLabel labelPatrimonio = new JLabel("Patrim\u00f4nio");
    private JLabel labelSerie = new JLabel("S\u00e9rie");
    private JLabel labelNumeroNF = new JLabel("N\u00famero NF");
    private JLabel labelSetor = new JLabel("Setor");
    private JLabel labelQtdePatrimonios = new JLabel("Quantidade: 0");
    private TTextField textPatrimonio = new TTextField(13, 3);
    private TTextField textSerie = new TTextField(2, 3);
    private TTextField textNumeroNF = new TTextField(10, 1);
    private JComboBox comboSetor = new JComboBox();
    private JPanel panelMaterial = new JPanel(new GridBagLayout());
    private JPanel panelPatrimonios = new JPanel(new GridBagLayout());
    private JPanel panelCelulasEstoque = new JPanel(new GridBagLayout());
    private JScrollPane scrollPatrimonios;
    private JScrollPane scrollCelulasEstoque;
    private ModeloGridTable modeloPatrimonios;
    private ModeloGridTable modeloCelulasEstoque;
    private JTable tablePatrimonios;
    private JTable tableCelulasEstoque;
    private MaterialBean materialAux = null;
    private boolean isPainelMinimizado = false;
    private Double qtdeEstoqueAux = null;
    private boolean isAlterando = false;

    public Patrimonios() {
        Funcoes.criaBarraDescricao(this, "Patrim\u00f4nios", "Cadastro e manuten\u00e7\u00e3o de patrim\u00f4nios", "estoque/patrimonio.jpg");
        ScreenUtil.setBorda(new Component[]{this.labelCodigoMaterial, this.labelDescricaoMaterial, this.labelVlrEstoqueTotal}, new TitledBorder(""));
        this.botaoExcluir.setVisible(false);
        this.botaoNovo.setVisible(false);
        this.painelCentral.setLayout(new GridBagLayout());
        this.buttonTamanhoPainel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Patrimonios.this.minimizarPainelCelulasEstoque();
            }
        });
        this.buttonOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Patrimonios.this.adicionarPatrimonio();
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.panelMaterial.add((Component)this.labelMaterial, gridBagConstraints);
        this.labelCodigoMaterial.setHorizontalAlignment(4);
        this.labelCodigoMaterial.setMinimumSize(new Dimension(70, 20));
        this.labelCodigoMaterial.setPreferredSize(new Dimension(70, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.panelMaterial.add((Component)this.labelCodigoMaterial, gridBagConstraints);
        this.labelDescricaoMaterial.setMinimumSize(new Dimension(200, 20));
        this.labelDescricaoMaterial.setPreferredSize(new Dimension(200, 20));
        this.labelDescricaoMaterial.setRequestFocusEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        this.panelMaterial.add((Component)this.labelDescricaoMaterial, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        this.panelMaterial.add((Component)this.getPanelVazio(20, 20), gridBagConstraints);
        gridBagConstraints.anchor = 17;
        ++gridBagConstraints.gridx;
        this.panelMaterial.add((Component)this.labelEstoqueTotal, gridBagConstraints);
        this.labelVlrEstoqueTotal.setHorizontalAlignment(4);
        this.labelVlrEstoqueTotal.setMinimumSize(new Dimension(90, 20));
        this.labelVlrEstoqueTotal.setPreferredSize(new Dimension(90, 20));
        gridBagConstraints.anchor = 17;
        ++gridBagConstraints.gridx;
        this.panelMaterial.add((Component)this.labelVlrEstoqueTotal, gridBagConstraints);
        this.panelPatrimonios.setBorder(BorderFactory.createTitledBorder("Patrim\u00f4nios"));
        this.panelCelulasEstoque.setBorder(BorderFactory.createTitledBorder("C\u00e9lulas de Estoque"));
        this.modeloPatrimonios = new ModeloGridTable(new String[]{"Patrim\u00f4nio", "S\u00e9rie", "N\u00famero NF", "Setor", "Pode Alterar", "Objeto"}){

            @Override
            public void fireTableChanged(TableModelEvent e) {
                super.fireTableChanged(e);
                if (Patrimonios.this.tablePatrimonios != null) {
                    Patrimonios.this.labelQtdePatrimonios.setText("Quantidade: " + Patrimonios.this.tablePatrimonios.getRowCount());
                }
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                Object[] classes = new Object[]{String.class, String.class, Integer.class, String.class, MaterialPatrimonioBean.class};
                return (Class)classes[columnIndex];
            }

            @Override
            public void fireTableStructureChanged() {
                super.fireTableStructureChanged();
                try {
                    if (Patrimonios.this.tablePatrimonios != null) {
                        Patrimonios.this.tablePatrimonios.removeColumn(Patrimonios.this.tablePatrimonios.getColumn("Objeto"));
                        Patrimonios.this.tablePatrimonios.removeColumn(Patrimonios.this.tablePatrimonios.getColumn("Pode Alterar"));
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                try {
                    Patrimonios.this.tablePatrimonios.removeColumn(Patrimonios.this.tablePatrimonios.getColumn("Objeto"));
                    Patrimonios.this.tablePatrimonios.removeColumn(Patrimonios.this.tablePatrimonios.getColumn("Pode Alterar"));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        };
        this.modeloCelulasEstoque = new ModeloGridTable(new String[]{"C\u00f3digo", "C\u00e9lula", "Saldo Atual", "Inativa?"}){

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                Object[] classes = new Object[]{Integer.class, String.class, Object.class, Boolean.class};
                return (Class)classes[columnIndex];
            }
        };
        this.tablePatrimonios = new JTable(this.modeloPatrimonios);
        this.tablePatrimonios.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127) {
                    if (Patrimonios.this.getStatus() == 2 || Patrimonios.this.getStatus() == 3) {
                        Patrimonios.this.removerPatrimonioSelecionado();
                    }
                } else if (e.getKeyCode() == 32 && (Patrimonios.this.getStatus() == 2 || Patrimonios.this.getStatus() == 3)) {
                    Patrimonios.this.alterarPatrimonio();
                }
            }
        });
        this.tablePatrimonios.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
            }
        });
        this.tablePatrimonios.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    if (Patrimonios.this.getStatus() == 3) {
                        Patrimonios.this.alterarPatrimonio();
                    }
                } else if (e.getClickCount() == 1 && Patrimonios.this.isAlterando) {
                    Patrimonios.this.textPatrimonio.clear();
                    Patrimonios.this.textSerie.clear();
                    Patrimonios.this.textNumeroNF.clear();
                    Patrimonios.this.comboSetor.setSelectedIndex(0);
                    Patrimonios.this.textPatrimonio.setEnabled(true);
                    Patrimonios.this.isAlterando = false;
                }
            }
        });
        this.modeloPatrimonios.setColumnSize(new int[]{200, 50, 90, 0, 0, 0}, this.tablePatrimonios);
        this.tablePatrimonios.getTableHeader().addMouseListener(this.modeloPatrimonios);
        this.tablePatrimonios.removeColumn(this.tablePatrimonios.getColumn("Objeto"));
        this.tablePatrimonios.removeColumn(this.tablePatrimonios.getColumn("Pode Alterar"));
        this.scrollPatrimonios = new JScrollPane(this.tablePatrimonios);
        this.tableCelulasEstoque = new JTable(this.modeloCelulasEstoque);
        this.modeloCelulasEstoque.setColumnSize(new int[]{70, 0, 100, 70}, this.tableCelulasEstoque);
        this.tableCelulasEstoque.getTableHeader().addMouseListener(this.modeloCelulasEstoque);
        this.scrollCelulasEstoque = new JScrollPane(this.tableCelulasEstoque);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.labelPatrimonio.setDisplayedMnemonic('P');
        this.labelPatrimonio.setLabelFor(this.textPatrimonio);
        this.panelPatrimonios.add((Component)this.labelPatrimonio, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.labelSerie.setDisplayedMnemonic('r');
        this.labelSerie.setLabelFor(this.textSerie);
        this.panelPatrimonios.add((Component)this.labelSerie, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.labelNumeroNF.setDisplayedMnemonic('N');
        this.labelNumeroNF.setLabelFor(this.textNumeroNF);
        this.panelPatrimonios.add((Component)this.labelNumeroNF, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.labelSetor.setDisplayedMnemonic('t');
        this.labelSetor.setLabelFor(this.comboSetor);
        this.panelPatrimonios.add((Component)this.labelSetor, gridBagConstraints);
        this.textPatrimonio.setMinimumSize(new Dimension(120, 20));
        this.textPatrimonio.setPreferredSize(new Dimension(120, 20));
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.panelPatrimonios.add((Component)this.textPatrimonio, gridBagConstraints);
        this.textSerie.setMinimumSize(new Dimension(40, 20));
        this.textSerie.setPreferredSize(new Dimension(40, 20));
        ++gridBagConstraints.gridx;
        this.panelPatrimonios.add((Component)this.textSerie, gridBagConstraints);
        this.textNumeroNF.setMinimumSize(new Dimension(90, 20));
        this.textNumeroNF.setPreferredSize(new Dimension(90, 20));
        ++gridBagConstraints.gridx;
        this.panelPatrimonios.add((Component)this.textNumeroNF, gridBagConstraints);
        this.comboSetor.setMinimumSize(new Dimension(80, 20));
        this.comboSetor.setPreferredSize(new Dimension(80, 20));
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.panelPatrimonios.add((Component)this.comboSetor, gridBagConstraints);
        this.buttonOk.setMinimumSize(new Dimension(30, 20));
        this.buttonOk.setPreferredSize(new Dimension(30, 20));
        this.buttonOk.setMargin(new Insets(1, 1, 1, 1));
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        this.buttonOk.setMnemonic('O');
        this.panelPatrimonios.add((Component)this.buttonOk, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 1, 1, 1);
        this.panelPatrimonios.add((Component)this.scrollPatrimonios, gridBagConstraints);
        this.labelQtdePatrimonios.setHorizontalAlignment(4);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(2, 1, 1, 1);
        this.panelPatrimonios.add((Component)this.labelQtdePatrimonios, gridBagConstraints);
        this.buttonTamanhoPainel.setMargin(new Insets(0, 0, 0, 0));
        this.buttonTamanhoPainel.setMinimumSize(new Dimension(20, 20));
        this.buttonTamanhoPainel.setPreferredSize(new Dimension(20, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.panelCelulasEstoque.add((Component)new JLabel(), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 12;
        this.panelCelulasEstoque.add((Component)this.buttonTamanhoPainel, gridBagConstraints);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        this.panelCelulasEstoque.add((Component)this.scrollCelulasEstoque, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 2, 1);
        this.painelCentral.add((Component)this.panelMaterial, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 0.7;
        this.painelCentral.add((Component)this.panelPatrimonios, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 0.3;
        this.painelCentral.add((Component)this.panelCelulasEstoque, gridBagConstraints);
        this.preencheSetores();
        this.controlaCampos();
        this.modeloPatrimonios.ordenarColuna(this.modeloPatrimonios.findColumn("Patrim\u00f4nio"));
        this.modeloCelulasEstoque.ordenarColuna(this.modeloCelulasEstoque.findColumn("C\u00e9lula"));
    }

    private void adicionarPatrimonio() {
        if (this.textPatrimonio.getText().isEmpty()) {
            Funcoes.mensagem(this, "O n\u00famero do patrim\u00f4nio deve ser informado.", 2);
            if (this.textPatrimonio.isEnabled() && this.textPatrimonio.isFocusable()) {
                ScreenUtil.requisitarFoco(this.textPatrimonio);
            }
            return;
        }
        if (this.comboSetor.getSelectedIndex() == 0) {
            Funcoes.mensagem(this, "O setor deve ser selecionado.", 2);
            if (this.comboSetor.isEnabled() && this.comboSetor.isFocusable()) {
                ScreenUtil.requisitarFoco(this.comboSetor);
            }
            return;
        }
        try {
            if (new MaterialPatrimonioService().patrimonioJaUsado(Variaveis.filialPadrao, this.textPatrimonio.getText())) {
                boolean erro = true;
                ArrayList<MaterialPatrimonioBean> patrimonios = this.materialAux.getPatrimonios();
                for (int i = 0; i < patrimonios.size(); ++i) {
                    MaterialPatrimonioBean patrimonio = patrimonios.get(i);
                    if (!patrimonio.getPatrimonio().equalsIgnoreCase(this.textPatrimonio.getText())) continue;
                    erro = false;
                    break;
                }
                if (erro) {
                    Funcoes.mensagem(this, "O c\u00f3digo do patrim\u00f4nio informado j\u00e1 foi utilizado.", 2);
                    if (this.textPatrimonio.isEnabled() && this.textPatrimonio.isFocusable()) {
                        ScreenUtil.requisitarFoco(this.textPatrimonio);
                    }
                    return;
                }
            }
        }
        catch (SQLException e) {
            Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel verificar se o patrim\u00f4nio est\u00e1 dispon\u00edvel.", 2);
            return;
        }
        if (!this.isAlterando) {
            for (int i = 0; i < this.modeloPatrimonios.getRowCount(); ++i) {
                if (!((String)this.modeloPatrimonios.getValueAt(i, this.modeloPatrimonios.findColumn("Patrim\u00f4nio"))).equalsIgnoreCase(this.textPatrimonio.getText())) continue;
                Funcoes.mensagem(this, "O patrim\u00f4nio j\u00e1 foi informado.", 2);
                if (this.textPatrimonio.isEnabled() && this.textPatrimonio.isFocusable()) {
                    ScreenUtil.requisitarFoco(this.textPatrimonio);
                }
                return;
            }
        }
        MaterialPatrimonioBean materialPatrimonio = new MaterialPatrimonioBean();
        FilialVO filial = new FilialVO();
        filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
        materialPatrimonio.setFilial(filial);
        materialPatrimonio.setInutilizado(false);
        materialPatrimonio.setMaterial((MaterialVO)this.materialAux.toVO());
        materialPatrimonio.setNumeroNotaFiscal(this.textNumeroNF.getText().isEmpty() ? null : Integer.valueOf(Integer.parseInt(this.textNumeroNF.getText())));
        materialPatrimonio.setSerie(this.textSerie.getText());
        materialPatrimonio.setPatrimonio(this.textPatrimonio.getText());
        materialPatrimonio.setSetor((SetorVO)this.comboSetor.getSelectedItem());
        if (!this.isAlterando) {
            this.modeloPatrimonios.addLine(new Object[]{materialPatrimonio.getPatrimonio(), materialPatrimonio.getSerie(), materialPatrimonio.getNumeroNotaFiscal(), materialPatrimonio.getSetor(), true, materialPatrimonio});
        } else {
            int row = this.tablePatrimonios.getSelectedRow();
            this.modeloPatrimonios.setValueAt(materialPatrimonio.getPatrimonio(), row, this.modeloPatrimonios.findColumn("Patrim\u00f4nio"));
            this.modeloPatrimonios.setValueAt(materialPatrimonio.getSerie(), row, this.modeloPatrimonios.findColumn("S\u00e9rie"));
            this.modeloPatrimonios.setValueAt(materialPatrimonio.getNumeroNotaFiscal(), row, this.modeloPatrimonios.findColumn("N\u00famero NF"));
            this.modeloPatrimonios.setValueAt(materialPatrimonio.getSetor(), row, this.modeloPatrimonios.findColumn("Setor"));
            this.modeloPatrimonios.setValueAt(materialPatrimonio, row, this.modeloPatrimonios.findColumn("Objeto"));
        }
        this.textPatrimonio.setEnabled(true);
        this.isAlterando = false;
        this.textPatrimonio.clear();
        this.textSerie.clear();
        this.textNumeroNF.clear();
        this.comboSetor.setSelectedIndex(0);
    }

    private void preencheSetores() {
        SetorService service = new SetorService();
        try {
            Set setores = service.loadVO(" where fil_codigo = " + Variaveis.filialPadrao);
            ArrayList set = new ArrayList(setores);
            Collections.sort(set, new Comparator(){

                public int compare(Object o1, Object o2) {
                    return o1 instanceof SetorVO && o2 instanceof SetorVO ? ((SetorVO)o1).getDescricao().compareToIgnoreCase(((SetorVO)o2).getDescricao()) : 0;
                }
            });
            this.comboSetor.removeAllItems();
            this.comboSetor.addItem("");
            for (SetorVO s : set) {
                this.comboSetor.addItem(s);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "Patrimonio: 894");
        }
    }

    private void minimizarPainelCelulasEstoque() {
        if (this.isPainelMinimizado) {
            this.buttonTamanhoPainel.setText("-");
            this.painelCentral.remove(this.panelCelulasEstoque);
            this.scrollCelulasEstoque.setVisible(true);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(1, 1, 2, 1);
            gridBagConstraints.gridy = 2;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weighty = 0.3;
            this.painelCentral.add((Component)this.panelCelulasEstoque, gridBagConstraints);
            this.isPainelMinimizado = false;
        } else {
            this.buttonTamanhoPainel.setText("+");
            this.painelCentral.remove(this.panelCelulasEstoque);
            this.scrollCelulasEstoque.setVisible(false);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(1, 1, 2, 1);
            gridBagConstraints.gridy = 2;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weighty = 0.0;
            this.painelCentral.add((Component)this.panelCelulasEstoque, gridBagConstraints);
            this.isPainelMinimizado = true;
        }
    }

    private void removerPatrimonioSelecionado() {
        int row = this.tablePatrimonios.getSelectedRow();
        if (!((Boolean)this.modeloPatrimonios.getValueAt(row, this.modeloPatrimonios.findColumn("Pode Alterar"))).booleanValue()) {
            Funcoes.mensagem(this, "O patrim\u00f4nio n\u00e3o pode ser removido, pois, j\u00e1 foi utilizado numa transfer\u00eancia/manuten\u00e7\u00e3o de estoque.", 2);
            return;
        }
        if (row >= 0) {
            this.modeloPatrimonios.removeLine(row);
        }
    }

    public static long getModuloAcesso() {
        return Long.parseLong("1200300110");
    }

    @Override
    public void cancelar() {
        if (Funcoes.mensagem(this, "As informa\u00e7\u00f5es adicionadas ser\u00e3o perdidas.", 4) == 0) {
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    private void limparCampos() {
        this.labelCodigoMaterial.setText("");
        this.labelDescricaoMaterial.setText("");
        this.labelVlrEstoqueTotal.setText("");
        this.textPatrimonio.clear();
        this.textSerie.clear();
        this.textNumeroNF.clear();
        this.comboSetor.setSelectedIndex(0);
        this.modeloPatrimonios.clear();
        this.modeloCelulasEstoque.clear();
        this.materialAux = null;
        this.isAlterando = false;
    }

    @Override
    public void editar() {
        MaterialBean bean = null;
        try {
            MaterialVO vo = (MaterialVO)new MaterialService().pesquisaMaterialImobilizadoComPatrimonioVO(Laboratorio.getInstancia(), new MaterialVO(), "Pesquisando Materiais imobilizados", true);
            if (vo == null) {
                return;
            }
            bean = (MaterialBean)new MaterialService().getTodos(Variaveis.filialPadrao, vo.getCodigo().toString(), null, null);
        }
        catch (Exception e1) {
            Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel buscar dados do material.", 2);
            return;
        }
        if (bean != null) {
            this.preencherCampos(bean);
            this.materialAux = bean;
        }
        this.setStatus(3);
        this.controlaCampos();
        if (this.textPatrimonio.isEnabled() && this.textPatrimonio.isFocusable()) {
            ScreenUtil.requisitarFoco(this.textPatrimonio);
        }
    }

    private void controlaCampos() {
        boolean habilita = this.getStatus() == 3;
        this.textPatrimonio.setEnabled(habilita);
        this.textSerie.setEnabled(habilita);
        this.textNumeroNF.setEnabled(habilita);
        this.comboSetor.setEnabled(habilita);
        this.buttonOk.setEnabled(habilita);
    }

    private void preencherCampos(MaterialBean material) {
        if (material != null) {
            this.labelCodigoMaterial.setText(String.valueOf(material.getCodigo()));
            this.labelDescricaoMaterial.setText(material.getDescricao());
            SaldoEstoqueBean saldo = null;
            try {
                saldo = (SaldoEstoqueBean)new SaldoEstoqueService().getSaldoAtualEstoqueMaterial(Variaveis.filialPadrao, material.getCodigo().toString());
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel buscar o estoque atual do material.\n" + e.getMessage(), e.getStackTrace());
                this.limparCampos();
                this.setStatus(1);
                this.controlaCampos();
                return;
            }
            if (saldo != null) {
                this.labelVlrEstoqueTotal.setText(Funcoes.formataDecimal(saldo.getSaldo()));
                this.qtdeEstoqueAux = saldo.getSaldo();
            } else {
                this.labelVlrEstoqueTotal.setText(Funcoes.formataDecimal(0.0));
                this.qtdeEstoqueAux = 0.0;
            }
            MaterialPatrimonioService serviceMatPatrimonio = new MaterialPatrimonioService();
            ArrayList<MaterialPatrimonioBean> patrimonios = material.getPatrimonios();
            try {
                for (int i = 0; i < patrimonios.size(); ++i) {
                    MaterialPatrimonioBean patrimonio = patrimonios.get(i);
                    this.modeloPatrimonios.addLine(new Object[]{patrimonio.getPatrimonio(), patrimonio.getSerie(), patrimonio.getNumeroNotaFiscal(), patrimonio.getSetor(), serviceMatPatrimonio.podeAlterarPatrimonioMaterial(Variaveis.filialPadrao, material.getCodigo().toString(), patrimonio.getPatrimonio()), patrimonio});
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel carregar os patrim\u00f4nios do material.\n" + e.getMessage(), e.getStackTrace());
                this.limparCampos();
                this.setStatus(1);
                this.controlaCampos();
                return;
            }
            ArrayList<SaldoEstoqueCelulaBean> listaEstoqueCel = null;
            try {
                listaEstoqueCel = new SaldoEstoqueCelulaService().getSaldoAtualEstoqueMaterial(Variaveis.filialPadrao, material.getCodigo().toString());
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel buscar o estoque das c\u00e9lulas do material.\n" + e.getMessage(), e.getStackTrace());
                this.limparCampos();
                this.setStatus(1);
                this.controlaCampos();
                return;
            }
            if (listaEstoqueCel != null) {
                for (int i = 0; i < listaEstoqueCel.size(); ++i) {
                    SaldoEstoqueCelulaBean saldoCelula = listaEstoqueCel.get(i);
                    this.modeloCelulasEstoque.addLine(new Object[]{saldoCelula.getCelula().getCodigo(), saldoCelula.getCelula().getDescricao(), Funcoes.formataDecimal(saldoCelula.getSaldo()), saldoCelula.getCelula().getInativa()});
                }
            }
        }
    }

    @Override
    @Deprecated
    public void excluir() {
    }

    @Override
    public void fechar() {
        if (this.getStatus() == 1 || Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setVisible(false);
        }
    }

    @Override
    @Deprecated
    public void novo() {
    }

    private MaterialBean getBeanPreenchido() {
        if (this.materialAux == null) {
            return null;
        }
        ArrayList<MaterialPatrimonioBean> patrimonios = null;
        if (this.tablePatrimonios.getRowCount() > 0) {
            patrimonios = new ArrayList<MaterialPatrimonioBean>();
            for (int i = 0; i < this.tablePatrimonios.getRowCount(); ++i) {
                patrimonios.add((MaterialPatrimonioBean)this.modeloPatrimonios.getValueAt(i, this.modeloPatrimonios.findColumn("Objeto")));
            }
        }
        this.materialAux.setPatrimonios(patrimonios);
        return this.materialAux;
    }

    @Override
    public void salvar() {
        MaterialBean bean;
        MaterialService service = new MaterialService();
        if (this.validaCampos() && (bean = this.getBeanPreenchido()) != null) {
            try {
                service.gravaAutoCopiaSemCommit(bean, this.getStatus() == 2 ? 0 : 1, Variaveis.filialPadrao, ParametrosGerais.getCopiaMaterial());
                this.limparCampos();
                this.setStatus(1);
                this.controlaCampos();
                Conexao.arquivaSQL();
            }
            catch (Exception e) {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel salvar os patrim\u00f4nios do material. - " + e.getMessage(), e.getStackTrace());
            }
        }
    }

    @Override
    public boolean validaCampos() {
        if (this.qtdeEstoqueAux > (double)this.tablePatrimonios.getRowCount()) {
            Funcoes.mensagem(this, "A quantidade de patrim\u00f4nios informados \u00e9 inferior \u00e0 quantidade em estoque.\nDeve-se informar " + this.qtdeEstoqueAux.intValue() + " patrim\u00f4nios.", 2);
            return false;
        }
        if (this.qtdeEstoqueAux < (double)this.tablePatrimonios.getRowCount()) {
            Funcoes.mensagem(this, "A quantidade de patrim\u00f4nios informados \u00e9 superior \u00e0 quantidade em estoque.\nDeve-se informar apenas " + this.qtdeEstoqueAux.intValue() + " patrim\u00f4nios.", 2);
            return false;
        }
        return true;
    }

    public JPanel getPanelVazio(int width, int height) {
        JPanel panel = new JPanel();
        Dimension d = new Dimension(width, height);
        panel.setMinimumSize(d);
        panel.setPreferredSize(d);
        return panel;
    }

    private void alterarPatrimonio() {
        int row = this.tablePatrimonios.getSelectedRow();
        if (row >= 0) {
            this.textPatrimonio.setEnabled((Boolean)this.modeloPatrimonios.getValueAt(row, this.modeloPatrimonios.findColumn("Pode Alterar")));
            this.textPatrimonio.setText((String)this.modeloPatrimonios.getValueAt(row, this.modeloPatrimonios.findColumn("Patrim\u00f4nio")));
            this.textSerie.setText((String)this.modeloPatrimonios.getValueAt(row, this.modeloPatrimonios.findColumn("S\u00e9rie")));
            if (this.modeloPatrimonios.getValueAt(row, this.modeloPatrimonios.findColumn("N\u00famero NF")) != null) {
                this.textNumeroNF.setText(((Integer)this.modeloPatrimonios.getValueAt(row, this.modeloPatrimonios.findColumn("N\u00famero NF"))).toString());
            }
            this.textSerie.setText((String)this.modeloPatrimonios.getValueAt(row, this.modeloPatrimonios.findColumn("S\u00e9rie")));
            for (int i = 0; i < this.comboSetor.getItemCount(); ++i) {
                if (!(this.comboSetor.getItemAt(i) instanceof SetorVO) || ((SetorVO)this.comboSetor.getItemAt(i)).getCodigo().intValue() != ((SetorVO)this.modeloPatrimonios.getValueAt(row, this.modeloPatrimonios.findColumn("Setor"))).getCodigo().intValue()) continue;
                this.comboSetor.setSelectedIndex(i);
                break;
            }
            if (this.textPatrimonio.isEnabled() && this.textPatrimonio.isFocusable()) {
                ScreenUtil.requisitarFoco(this.textPatrimonio);
            } else if (this.textSerie.isEnabled() && this.textSerie.isFocusable()) {
                ScreenUtil.requisitarFoco(this.textSerie);
            }
            this.isAlterando = true;
        }
    }

    @Override
    public String getRetornoParaPesquisa() {
        return "";
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return null;
    }
}

