/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.estoque.almoxarifado;

import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadrao;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.cadastro.VisualizarMateriaisAlternativos;
import jalis.laboratorio.estoque.SolicitarLoteMaterial;
import jalis.model.bean.estoque.CelulaEstoqueBean;
import jalis.model.bean.estoque.MaterialBean;
import jalis.model.bean.estoque.MaterialLoteBean;
import jalis.model.bean.estoque.MontagemKitBean;
import jalis.model.bean.estoque.MontagemKitConsumidoBean;
import jalis.model.bean.estoque.MontagemKitLanctoEstoqueBean;
import jalis.model.bean.estoque.MontagemKitMaterialBean;
import jalis.model.bean.estoque.SaldoEstoqueCelulaBean;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.model.vo.estoque.CelulaEstoqueVO;
import jalis.model.vo.estoque.MaterialVO;
import jalis.service.estoque.CelulaEstoqueService;
import jalis.service.estoque.MaterialService;
import jalis.service.estoque.MontagemKitLanctoEstoqueService;
import jalis.service.estoque.MontagemKitService;
import jalis.service.estoque.SaldoEstoqueCelulaService;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class MontagemKit
extends FrmCadPadrao {
    private static final int COLUNA_MATERIAIS_CONSUMIDOS_LOTE = 7;
    private static final int CASAS_MAIOR = 4;
    private JPanel panelCabecalho = new JPanel();
    private JPanel panelAdicionaKit = new JPanel();
    private JPanel panelKits = new JPanel();
    private JPanel panelConsumidos = new JPanel();
    private JPanel panelObservacao = new JPanel();
    private JLabel labelData = new JLabel();
    private JLabel labelUsuario = new JLabel();
    private JLabel labelDescData = new JLabel();
    private JLabel labelDescUsuario = new JLabel();
    private JLabel labelKit = new JLabel();
    private JLabel labelDescKit = new JLabel();
    private JLabel labelQuantidade = new JLabel();
    private JLabel labelCelulaOrigem = new JLabel();
    private JLabel labelCelulaDestino = new JLabel();
    private JLabel labelObservacao = new JLabel();
    private TTextField textKit = new TTextField(18, 3);
    private TTextField textQuantidade = new TTextField(10, 2);
    private JButton buttonKit = new JButton();
    private JButton buttonOk = new JButton("OK");
    private JScrollPane scrollKits = null;
    private JScrollPane scrollMateriaisConsumidos = null;
    private JScrollPane scrollObservacao = new JScrollPane();
    private JComboBox comboCelulaOrigem = new JComboBox();
    private JComboBox comboCelulaDestino = new JComboBox();
    private JTable tableKits = null;
    private JTable tableMateriaisConsumidos = null;
    private ModeloGridTable modeloKits = null;
    private ModeloGridTable modeloMateriaisConsumidos = null;
    private JTextArea areaObservacao = new JTextArea();
    private MontagemKitMaterialBean montagemAux = null;
    private MaterialBean materialAux = null;
    private Date dataAux;
    private UsuarioVO usuarioAux;
    private boolean isAlterandoMaterial = false;
    private final int COLUNA_KIT_CODIGO = 0;
    private final int COLUNA_KIT_MATERIAL = 1;
    private final int COLUNA_KIT_QUANTIDADE = 2;
    private final int COLUNA_KIT_CELULA_ORIGEM = 3;
    private final int COLUNA_KIT_CELULA_DESTINO = 4;
    private final int COLUNA_KIT_OBJETO = 5;
    private final int COLUNA_KIT_OBJETO_MATERIAL = 6;
    private final int COLUNA_MAT_CODIGO = 0;
    private final int COLUNA_MAT_MATERIAL = 1;
    private final int COLUNA_MAT_QUANTIDADE = 2;
    private final int COLUNA_MAT_OBJETO = 3;

    public MontagemKit() {
        ScreenUtil.setBorda(new Component[]{this.labelDescKit, this.labelDescData, this.labelDescUsuario}, new TitledBorder(""));
        Funcoes.criaBarraDescricao(this, "Montagem de Kit", "Montagem de Kit", "estoque/montagem_kit.jpg");
        this.buscaCelulasCombo();
        this.textKit.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    MontagemKit.this.buttonKit.doClick();
                }
            }
        });
        this.textKit.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (MontagemKit.this.textKit.getText().isEmpty()) {
                    return;
                }
                MaterialBean material = null;
                try {
                    material = (MaterialBean)new MaterialService().getAtivo(Variaveis.filialPadrao, MontagemKit.this.textKit.getText(), null, null);
                }
                catch (Exception e1) {
                    MontagemKit.this.materialAux = null;
                    MontagemKit.this.labelDescKit.setText("N\u00e3o cadastrado");
                    MontagemKit.this.controlaCampos();
                    return;
                }
                if (material == null) {
                    material = VisualizarMateriaisAlternativos.getTelaMaterialAlternativo(material, MontagemKit.this.textKit);
                }
                if (material != null && material.getFichaTecnica() != null && material.getFichaTecnica().booleanValue()) {
                    MontagemKit.this.materialAux = material;
                    MontagemKit.this.textKit.setText(material.getCodigo().toString());
                    MontagemKit.this.labelDescKit.setText(material.getDescricao());
                } else {
                    MontagemKit.this.materialAux = null;
                    MontagemKit.this.labelDescKit.setText("N\u00e3o cadastrado");
                }
                if (MontagemKit.this.textQuantidade.isEnabled() && MontagemKit.this.textQuantidade.isFocusable()) {
                    MontagemKit.this.textQuantidade.grabFocus();
                }
                MontagemKit.this.controlaCampos();
            }
        });
        this.buttonKit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Hashtable hash = Pesquisas.materialAtivoComFichaTecnica(Laboratorio.getInstancia(), true);
                if (hash != null) {
                    MaterialBean bean = null;
                    try {
                        bean = (MaterialBean)new MaterialService().getAtivo(Variaveis.filialPadrao, String.valueOf((Integer)hash.get("mat_codigo")), null, null);
                    }
                    catch (Exception e1) {
                        Funcoes.mensagem(MontagemKit.this, "N\u00e3o foi poss\u00edvel buscar dados do kit.", 2);
                        return;
                    }
                    if (bean != null) {
                        MontagemKit.this.textKit.setText(String.valueOf(bean.getCodigo()));
                        MontagemKit.this.labelDescKit.setText(bean.getDescricao());
                        MontagemKit.this.materialAux = bean;
                    } else {
                        MontagemKit.this.textKit.setText(String.valueOf((Integer)hash.get("mat_codigo")));
                        MontagemKit.this.labelDescKit.setText("N\u00e3o cadastrado");
                    }
                }
                if (MontagemKit.this.textQuantidade.isEnabled() && MontagemKit.this.textQuantidade.isFocusable()) {
                    MontagemKit.this.textQuantidade.grabFocus();
                }
                MontagemKit.this.controlaCampos();
            }
        });
        this.buttonOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MontagemKit.this.materialAux == null) {
                    return;
                }
                if (MontagemKit.this.textQuantidade.getText().isEmpty()) {
                    Funcoes.mensagem(MontagemKit.this, "A quantidade n\u00e3o foi informada.", 2);
                    if (MontagemKit.this.textQuantidade.isEnabled() && MontagemKit.this.textQuantidade.isFocusable()) {
                        ScreenUtil.requisitarFoco(MontagemKit.this.textQuantidade);
                    }
                    return;
                }
                MontagemKitMaterialBean materialKit = new MontagemKitMaterialBean();
                FilialVO filial = new FilialVO();
                filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
                materialKit.setFilial(filial);
                materialKit.setMaterial((MaterialVO)MontagemKit.this.materialAux.toVO());
                materialKit.setQuantidade(Double.parseDouble(Funcoes.limpaDecimal(MontagemKit.this.textQuantidade.getText())));
                materialKit.setCelulaOrigem((CelulaEstoqueVO)((CelulaEstoqueBean)MontagemKit.this.comboCelulaOrigem.getSelectedItem()).toVO());
                materialKit.setCelulaDestino((CelulaEstoqueVO)((CelulaEstoqueBean)MontagemKit.this.comboCelulaDestino.getSelectedItem()).toVO());
                ArrayList<MontagemKitConsumidoBean> listaConsumidos = new ArrayList<MontagemKitConsumidoBean>();
                if (MontagemKit.this.materialAux.getMateriaisComposicao() != null && MontagemKit.this.materialAux.getMateriaisComposicao().size() > 0) {
                    for (int i = 0; i < MontagemKit.this.materialAux.getMateriaisComposicao().size(); ++i) {
                        MontagemKitConsumidoBean consumido = new MontagemKitConsumidoBean();
                        consumido.setFilial(filial);
                        consumido.setMaterial((MaterialVO)MontagemKit.this.materialAux.toVO());
                        consumido.setMaterialConsumido(MontagemKit.this.materialAux.getMateriaisComposicao().get(i).getMaterialFilho());
                        consumido.setQuantidade(materialKit.getQuantidade() * MontagemKit.this.materialAux.getMateriaisComposicao().get(i).getQuantidade());
                        SaldoEstoqueCelulaBean saldo = null;
                        try {
                            saldo = (SaldoEstoqueCelulaBean)new SaldoEstoqueCelulaService().getSaldoAtualEstoqueMaterialCelula(filial.getCodigo().toString(), consumido.getMaterialConsumido().getCodigo().toString(), materialKit.getCelulaOrigem().getCodigo().toString());
                        }
                        catch (Exception e1) {
                            saldo = new SaldoEstoqueCelulaBean();
                            saldo.setSaldo(0.0);
                        }
                        if (saldo == null || saldo.getSaldo() < consumido.getQuantidade()) {
                            Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o h\u00e1 estoque suficiente do material \"" + consumido.getMaterialConsumido().getDescricao() + "\".\nEstoque atual: " + Funcoes.formataDecimal(saldo == null ? 0.0 : saldo.getSaldo()) + ". Quantidade necess\u00e1ria: " + Funcoes.formataDecimal(consumido.getQuantidade()) + ".", 2);
                            return;
                        }
                        listaConsumidos.add(consumido);
                    }
                }
                materialKit.setMateriaisConsumidos(listaConsumidos);
                if (MontagemKit.this.adicionarKit(materialKit)) {
                    MontagemKit.this.textKit.clear();
                    MontagemKit.this.labelDescKit.setText("");
                    MontagemKit.this.textQuantidade.clear();
                    MontagemKit.this.comboCelulaOrigem.setSelectedIndex(0);
                    MontagemKit.this.comboCelulaDestino.setSelectedIndex(0);
                    if (MontagemKit.this.textKit.isEnabled() && MontagemKit.this.textKit.isFocusable()) {
                        MontagemKit.this.textKit.grabFocus();
                    }
                    MontagemKit.this.materialAux = null;
                    MontagemKit.this.montagemAux = null;
                    MontagemKit.this.controlaCampos();
                }
            }
        });
        this.botaoEditar.setVisible(false);
        this.botaoExcluir.setVisible(false);
        this.painelCentral.setLayout(new GridBagLayout());
        this.panelCabecalho.setLayout(new GridBagLayout());
        this.labelData.setText("Data:");
        this.panelCabecalho.add((Component)this.labelData, new GridBagConstraints());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.labelDescData.setPreferredSize(new Dimension(20, 20));
        this.labelDescData.setMinimumSize(new Dimension(20, 20));
        this.panelCabecalho.add((Component)this.labelDescData, gridBagConstraints);
        this.labelUsuario.setText("Usu\u00e1rio:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        this.panelCabecalho.add((Component)this.labelUsuario, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.labelDescUsuario.setPreferredSize(new Dimension(20, 20));
        this.labelDescUsuario.setMinimumSize(new Dimension(20, 20));
        this.panelCabecalho.add((Component)this.labelDescUsuario, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.painelCentral.add((Component)this.panelCabecalho, gridBagConstraints);
        this.panelAdicionaKit.setLayout(new GridBagLayout());
        this.labelKit.setText("Kit");
        this.labelKit.setDisplayedMnemonic('K');
        this.labelKit.setLabelFor(this.textKit);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        this.panelAdicionaKit.add((Component)this.labelKit, gridBagConstraints);
        this.textKit.setMaximumSize(null);
        this.textKit.setMinimumSize(new Dimension(70, 20));
        this.textKit.setPreferredSize(new Dimension(70, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        this.panelAdicionaKit.add((Component)this.textKit, gridBagConstraints);
        Funcoes.imagemPesquisa(this.buttonKit);
        this.buttonKit.setFocusable(false);
        this.buttonKit.setMaximumSize(null);
        this.buttonKit.setMinimumSize(new Dimension(20, 20));
        this.buttonKit.setPreferredSize(new Dimension(20, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        this.panelAdicionaKit.add((Component)this.buttonKit, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.labelDescKit.setPreferredSize(new Dimension(20, 20));
        this.labelDescKit.setMinimumSize(new Dimension(20, 20));
        this.panelAdicionaKit.add((Component)this.labelDescKit, gridBagConstraints);
        this.labelQuantidade.setText("Qtde.");
        this.labelQuantidade.setDisplayedMnemonic('Q');
        this.labelQuantidade.setLabelFor(this.textQuantidade);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        this.panelAdicionaKit.add((Component)this.labelQuantidade, gridBagConstraints);
        this.textQuantidade.setMaximumSize(null);
        this.textQuantidade.setMinimumSize(new Dimension(70, 20));
        this.textQuantidade.setPreferredSize(new Dimension(70, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        this.panelAdicionaKit.add((Component)this.textQuantidade, gridBagConstraints);
        this.labelCelulaOrigem.setText("C\u00e9lula Origem");
        this.labelCelulaOrigem.setDisplayedMnemonic('u');
        this.labelCelulaOrigem.setLabelFor(this.comboCelulaOrigem);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        this.panelAdicionaKit.add((Component)this.labelCelulaOrigem, gridBagConstraints);
        this.comboCelulaOrigem.setMaximumSize(null);
        this.comboCelulaOrigem.setMinimumSize(new Dimension(120, 20));
        this.comboCelulaOrigem.setPreferredSize(new Dimension(120, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.4;
        this.panelAdicionaKit.add((Component)this.comboCelulaOrigem, gridBagConstraints);
        this.labelCelulaDestino.setText("C\u00e9lula Destino");
        this.labelCelulaDestino.setDisplayedMnemonic('D');
        this.labelCelulaDestino.setLabelFor(this.comboCelulaDestino);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        this.panelAdicionaKit.add((Component)this.labelCelulaDestino, gridBagConstraints);
        this.comboCelulaDestino.setMaximumSize(null);
        this.comboCelulaDestino.setMinimumSize(new Dimension(120, 20));
        this.comboCelulaDestino.setPreferredSize(new Dimension(120, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.4;
        this.panelAdicionaKit.add((Component)this.comboCelulaDestino, gridBagConstraints);
        this.buttonOk.setMinimumSize(new Dimension(40, 20));
        this.buttonOk.setPreferredSize(new Dimension(40, 20));
        this.buttonOk.setMargin(new Insets(1, 1, 1, 1));
        this.buttonOk.setMnemonic('O');
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        this.panelAdicionaKit.add((Component)this.buttonOk, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.painelCentral.add((Component)this.panelAdicionaKit, gridBagConstraints);
        this.panelKits.setBorder(BorderFactory.createTitledBorder("Kits"));
        this.panelKits.setLayout(new GridBagLayout());
        this.modeloKits = new ModeloGridTable(new String[]{"C\u00f3digo", "Material", "Quantidade", "C\u00e9lula Origem", "C\u00e9lula Destino", "Objeto"}){

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return super.getColumnClass(columnIndex);
            }

            @Override
            public void fireTableStructureChanged() {
                super.fireTableStructureChanged();
                try {
                    if (MontagemKit.this.tableKits != null) {
                        MontagemKit.this.tableKits.removeColumn(MontagemKit.this.tableKits.getColumn("Objeto"));
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                try {
                    MontagemKit.this.tableKits.removeColumn(MontagemKit.this.tableKits.getColumn("Objeto"));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        };
        this.tableKits = new JTable(this.modeloKits);
        this.tableKits.removeColumn(this.tableKits.getColumn("Objeto"));
        this.tableKits.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
            }
        });
        this.tableKits.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int row;
                if (e.getKeyCode() == 127) {
                    int resp = Funcoes.mensagem(MontagemKit.this, "Deseja remover o kit?", 4);
                    if (resp == 0) {
                        int row2 = ((JTable)e.getSource()).getSelectedRow();
                        MontagemKit.this.modeloKits.removeLine(row2);
                    }
                } else if (e.getKeyCode() == 32 && (row = ((JTable)e.getSource()).getSelectedRow()) >= 0) {
                    int i;
                    MontagemKitMaterialBean material = (MontagemKitMaterialBean)MontagemKit.this.modeloKits.getValueAt(row, 5);
                    MaterialBean beanMaterial = null;
                    try {
                        beanMaterial = (MaterialBean)new MaterialService().getTodos(String.valueOf(material.getMaterial().getFilial().getCodigo()), String.valueOf(material.getMaterial().getCodigo()), null, null);
                    }
                    catch (Exception e1) {
                        Funcoes.mensagem(MontagemKit.this, "N\u00e3o foi poss\u00edvel carregar os dados do material.", 2);
                        return;
                    }
                    MontagemKit.this.isAlterandoMaterial = true;
                    MontagemKit.this.montagemAux = material;
                    MontagemKit.this.materialAux = beanMaterial;
                    MontagemKit.this.textKit.setText(String.valueOf(material.getMaterial().getCodigo()));
                    MontagemKit.this.labelDescKit.setText(material.getMaterial().getDescricao());
                    MontagemKit.this.textQuantidade.setText(Funcoes.formataDecimal(material.getQuantidade()));
                    for (i = 0; i < MontagemKit.this.comboCelulaOrigem.getItemCount(); ++i) {
                        if (!((CelulaEstoqueBean)MontagemKit.this.comboCelulaOrigem.getItemAt(i)).getDescricao().equalsIgnoreCase(material.getCelulaOrigem().getDescricao())) continue;
                        MontagemKit.this.comboCelulaOrigem.setSelectedIndex(i);
                        break;
                    }
                    for (i = 0; i < MontagemKit.this.comboCelulaDestino.getItemCount(); ++i) {
                        if (!((CelulaEstoqueBean)MontagemKit.this.comboCelulaDestino.getItemAt(i)).getDescricao().equalsIgnoreCase(material.getCelulaDestino().getDescricao())) continue;
                        MontagemKit.this.comboCelulaDestino.setSelectedIndex(i);
                        break;
                    }
                    MontagemKit.this.controlaCampos();
                    MontagemKit.this.textKit.selectAll();
                    if (MontagemKit.this.textKit.isFocusable() && MontagemKit.this.textKit.isEnabled()) {
                        MontagemKit.this.textKit.grabFocus();
                    }
                }
            }
        });
        this.tableKits.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (MontagemKit.this.modeloKits.getRowCount() > 0 && MontagemKit.this.tableKits.getSelectedRow() >= 0) {
                    MontagemKit.this.atualizaDadosMateriaisConsumidos((MontagemKitMaterialBean)MontagemKit.this.modeloKits.getValueAt(MontagemKit.this.tableKits.getSelectedRow(), 5));
                    MontagemKit.this.textKit.clear();
                    MontagemKit.this.labelDescKit.setText("");
                    MontagemKit.this.textQuantidade.clear();
                    MontagemKit.this.comboCelulaOrigem.setSelectedIndex(0);
                    MontagemKit.this.comboCelulaDestino.setSelectedIndex(0);
                    MontagemKit.this.materialAux = null;
                    MontagemKit.this.montagemAux = null;
                    MontagemKit.this.controlaCampos();
                }
            }
        });
        this.modeloKits.setColumnSize(new int[]{70, 0, 90, 130, 130, 0}, this.tableKits);
        this.tableKits.getTableHeader().addMouseListener(this.modeloKits);
        this.scrollKits = new JScrollPane(this.tableKits);
        this.modeloMateriaisConsumidos = new ModeloGridTable(new String[]{"C\u00f3digo", "Material", "Quantidade", "Objeto"}){

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return super.getColumnClass(columnIndex);
            }

            @Override
            public void fireTableStructureChanged() {
                super.fireTableStructureChanged();
                try {
                    if (MontagemKit.this.tableMateriaisConsumidos != null) {
                        MontagemKit.this.tableMateriaisConsumidos.removeColumn(MontagemKit.this.tableMateriaisConsumidos.getColumn("Objeto"));
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                try {
                    MontagemKit.this.tableMateriaisConsumidos.removeColumn(MontagemKit.this.tableMateriaisConsumidos.getColumn("Objeto"));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        };
        this.tableMateriaisConsumidos = new JTable(this.modeloMateriaisConsumidos);
        this.tableMateriaisConsumidos.removeColumn(this.tableMateriaisConsumidos.getColumn("Objeto"));
        this.tableMateriaisConsumidos.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
            }
        });
        this.modeloMateriaisConsumidos.setColumnSize(new int[]{70, 0, 90, 0}, this.tableMateriaisConsumidos);
        this.tableMateriaisConsumidos.getTableHeader().addMouseListener(this.modeloMateriaisConsumidos);
        this.scrollMateriaisConsumidos = new JScrollPane(this.tableMateriaisConsumidos);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panelKits.add((Component)this.scrollKits, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.6;
        this.painelCentral.add((Component)this.panelKits, gridBagConstraints);
        this.panelConsumidos.setBorder(BorderFactory.createTitledBorder("Materiais Consumidos"));
        this.panelConsumidos.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panelConsumidos.add((Component)this.scrollMateriaisConsumidos, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.4;
        this.painelCentral.add((Component)this.panelConsumidos, gridBagConstraints);
        this.panelObservacao.setLayout(new GridBagLayout());
        this.labelObservacao.setText("Observa\u00e7\u00e3o:");
        this.labelObservacao.setDisplayedMnemonic('b');
        this.labelObservacao.setLabelFor(this.areaObservacao);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        this.panelObservacao.add((Component)this.labelObservacao, gridBagConstraints);
        this.scrollObservacao.setMinimumSize(new Dimension(20, 40));
        this.scrollObservacao.setPreferredSize(new Dimension(20, 40));
        this.scrollObservacao.setViewportView(this.areaObservacao);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.panelObservacao.add((Component)this.scrollObservacao, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.painelCentral.add((Component)this.panelObservacao, gridBagConstraints);
        this.controlaCampos();
        this.modeloKits.ordenarColunaSemTrocarSentido(1);
        this.modeloMateriaisConsumidos.ordenarColunaSemTrocarSentido(1);
    }

    private boolean adicionarKit(MontagemKitMaterialBean material) {
        if (material == null) {
            return false;
        }
        for (int i = 0; i < this.modeloKits.getRowCount(); ++i) {
            MontagemKitMaterialBean aux = (MontagemKitMaterialBean)this.modeloKits.getValueAt(i, 5);
            if (aux == null) continue;
            if (!this.isAlterandoMaterial) {
                if (aux.getMaterial().getCodigo().intValue() != material.getMaterial().getCodigo().intValue() || aux.getCelulaOrigem().getCodigo().intValue() != material.getCelulaOrigem().getCodigo().intValue() || aux.getCelulaDestino().getCodigo().intValue() != material.getCelulaDestino().getCodigo().intValue()) continue;
                Funcoes.mensagem(this, "J\u00e1 h\u00e1 um kit com a mesma origem e destino", 2);
                if (this.textKit.isFocusable() && this.textKit.isEnabled()) {
                    this.textKit.grabFocus();
                }
                return false;
            }
            if (aux.getMaterial().getCodigo().intValue() != this.montagemAux.getMaterial().getCodigo().intValue() || aux.getCelulaOrigem().getCodigo().intValue() != this.montagemAux.getCelulaOrigem().getCodigo().intValue() || aux.getCelulaDestino().getCodigo().intValue() != this.montagemAux.getCelulaDestino().getCodigo().intValue()) continue;
            this.modeloKits.removeLine(i);
            break;
        }
        if (this.materialAux.getSolicitarLote().booleanValue()) {
            Double qtdeOriginal = this.materialAux.getQuantidadeLotes(material.getCelulaDestino()) - this.materialAux.getQuantidadeConsumidaLotes(material.getCelulaDestino());
            Double qtdeInserir = material.getQuantidade() == null ? 0.0 : material.getQuantidade();
            SolicitarLoteMaterial lote = new SolicitarLoteMaterial(Laboratorio.getInstancia(), this.materialAux.getCodigo(), this.materialAux.getDescricao(), this.materialAux.getUnidadeMedida().getCodigo(), this.materialAux.getFichaTecnica(), this.materialAux.getLotes(), 0, qtdeOriginal, qtdeInserir, null, null, material.getCelulaDestino(), false, null, false);
            if (lote != null) {
                lote.setVisible(true);
                if (lote.getOK()) {
                    this.materialAux.setLotes(lote.getLotes());
                } else {
                    Funcoes.mensagem(this, "Os lotes do material devem ser informados.", 2);
                    return false;
                }
            }
        }
        ArrayList<MontagemKitConsumidoBean> montagemKitConsumidoBeans = new ArrayList<MontagemKitConsumidoBean>();
        for (MontagemKitConsumidoBean bean : material.getMateriaisConsumidos()) {
            if (!bean.getMaterialConsumido().getSolicitarLote().booleanValue()) continue;
            montagemKitConsumidoBeans.add(bean);
        }
        if (!montagemKitConsumidoBeans.isEmpty()) {
            for (MontagemKitConsumidoBean bean : montagemKitConsumidoBeans) {
                MaterialVO matConsumido = bean.getMaterialConsumido();
                if (!matConsumido.getSolicitarLote().booleanValue()) continue;
                if (matConsumido.getLotes() == null) {
                    try {
                        MaterialService.carregarLotesMaterial(matConsumido);
                    }
                    catch (Exception e) {
                        ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar os dados dos lotes.\n" + e.getMessage(), e.getStackTrace());
                        return false;
                    }
                }
                Double qtdeOriginal = matConsumido.getQuantidadeLotes(material.getCelulaOrigem()) - matConsumido.getQuantidadeConsumidaOriginalLotes(material.getCelulaOrigem());
                SolicitarLoteMaterial lote = new SolicitarLoteMaterial(Laboratorio.getInstancia(), matConsumido.getCodigo(), matConsumido.getDescricao(), matConsumido.getUnidadeMedida().getCodigo(), matConsumido.getFichaTecnica(), matConsumido.getLotes(), 1, qtdeOriginal, null, bean.getQuantidade(), qtdeOriginal, material.getCelulaOrigem(), false, null, false);
                if (lote == null) continue;
                lote.setVisible(true);
                if (lote.getOK()) {
                    bean.getMaterialConsumido().setLotes(lote.getLotes());
                    continue;
                }
                Funcoes.mensagem(this, "Os lotes do material devem ser informados.", 2);
                ScreenUtil.requisitarFoco(this.textKit);
                return false;
            }
        }
        this.modeloKits.addLine(new Object[]{material.getMaterial().getCodigo(), material.getMaterial().getDescricao(), Funcoes.formataDecimal(material.getQuantidade()), material.getCelulaOrigem().toString(), material.getCelulaDestino().toString(), material, this.materialAux, montagemKitConsumidoBeans});
        if (this.modeloKits.getColunaOrdenacao() != -1) {
            this.modeloKits.ordenarColunaSemTrocarSentido(this.modeloKits.getColunaOrdenacao());
        } else {
            this.modeloKits.ordenarColunaSemTrocarSentido(1);
        }
        return true;
    }

    private void atualizaDadosMateriaisConsumidos(MontagemKitMaterialBean materialKit) {
        if (materialKit == null) {
            return;
        }
        this.modeloMateriaisConsumidos.clear();
        ArrayList<MontagemKitConsumidoBean> listaConsumidos = materialKit.getMateriaisConsumidos();
        if (listaConsumidos != null) {
            for (int i = 0; i < listaConsumidos.size(); ++i) {
                MontagemKitConsumidoBean consumido = listaConsumidos.get(i);
                this.modeloMateriaisConsumidos.addLine(new Object[]{consumido.getMaterialConsumido().getCodigo(), consumido.getMaterialConsumido().getDescricao(), Funcoes.formataDecimal(consumido.getQuantidade())});
                if (this.modeloMateriaisConsumidos.getColunaOrdenacao() != -1) {
                    this.modeloMateriaisConsumidos.ordenarColunaSemTrocarSentido(this.modeloMateriaisConsumidos.getColunaOrdenacao());
                    continue;
                }
                this.modeloMateriaisConsumidos.ordenarColunaSemTrocarSentido(1);
            }
        }
    }

    @Override
    public void cancelar() {
        if (Funcoes.mensagem(this, "As informa\u00e7\u00f5es adicionadas ser\u00e3o perdidas.", 4) == 0) {
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    private void limparCampos() {
        this.textKit.clear();
        this.textQuantidade.clear();
        this.labelDescData.setText("");
        this.labelDescUsuario.setText("");
        this.labelDescKit.setText("");
        this.modeloKits.clear();
        this.modeloMateriaisConsumidos.clear();
        this.areaObservacao.setText("");
        this.montagemAux = null;
        this.materialAux = null;
        this.dataAux = null;
        this.usuarioAux = null;
        this.isAlterandoMaterial = false;
    }

    private void controlaCampos() {
        boolean habilitar = this.getStatus() == 2;
        this.textKit.setEnabled(habilitar);
        this.textQuantidade.setEnabled(habilitar);
        this.buttonKit.setEnabled(habilitar);
        this.buttonOk.setEnabled(habilitar && this.materialAux != null);
        this.comboCelulaOrigem.setEnabled(habilitar);
        this.comboCelulaDestino.setEnabled(habilitar);
        this.tableKits.setEnabled(habilitar);
        this.tableMateriaisConsumidos.setEnabled(habilitar);
        this.areaObservacao.setEnabled(habilitar);
    }

    @Override
    @Deprecated
    public void editar() {
    }

    @Override
    @Deprecated
    public void excluir() {
    }

    @Override
    public void fechar() {
        if (this.getStatus() == 1 || Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setVisible(false);
        }
    }

    @Override
    public void novo() {
        this.limparCampos();
        this.setStatus(2);
        this.controlaCampos();
        this.dataAux = new Date();
        this.labelDescData.setText(Funcoes.formataData("dd/MM/yyyy HH:mm:ss", this.dataAux));
        this.usuarioAux = new UsuarioVO();
        this.usuarioAux.setCodigo(Variaveis.login);
        this.labelDescUsuario.setText(this.usuarioAux.getCodigo());
        if (this.textKit.isFocusable() && this.textKit.isEnabled()) {
            this.textKit.grabFocus();
        }
    }

    @Override
    public void salvar() {
        MontagemKitBean bean;
        MontagemKitService service = new MontagemKitService();
        MaterialService materialService = new MaterialService();
        if (this.validaCampos() && (bean = this.getBeanPreenchido()) != null) {
            try {
                service.gravaAutoCopiaSemCommit(bean, 0, Variaveis.filialPadrao, this.getCopiaFiliais());
                for (int i = 0; i < this.modeloKits.getRowCount(); ++i) {
                    MaterialBean matBean = (MaterialBean)this.modeloKits.getValueAt(i, 6);
                    List montagemKitConsumidoBeans = (List)this.modeloKits.getValueAt(i, 7);
                    MontagemKitLanctoEstoqueBean aux = new MontagemKitLanctoEstoqueService().getMontagemKitLanctoEstoqueBean(bean.getFilial().getCodigo().toString(), bean.getCodigo().toString(), matBean.getCodigo().toString());
                    ArrayList<MaterialLoteBean> lotes = matBean.getLotes();
                    for (int j = 0; j < lotes.size(); ++j) {
                        MaterialLoteBean lote = lotes.get(j);
                        if (lote.getRemovido().booleanValue()) continue;
                        materialService.gerarMaterialLoteLancEstoque(aux.getFilial(), aux.getLancamentoEstoque(), lote);
                    }
                    for (MontagemKitConsumidoBean b : montagemKitConsumidoBeans) {
                        if (b.getMaterialConsumido().getLotes() == null || b.getMaterialConsumido().getLotes().isEmpty()) continue;
                        for (MaterialLoteBean materialLoteBean : b.getMaterialConsumido().getLotes()) {
                            if (materialLoteBean.getRemovido().booleanValue()) continue;
                            MontagemKitLanctoEstoqueBean aux2 = new MontagemKitLanctoEstoqueService().getMontagemKitLanctoEstoqueBean(bean.getFilial().getCodigo().toString(), bean.getCodigo().toString(), materialLoteBean.getMaterial().getCodigo().toString());
                            materialService.gerarMaterialLoteLancEstoqueKit(aux.getFilial(), aux2.getLancamentoEstoque(), materialLoteBean);
                            matBean.getLotes().add(materialLoteBean);
                        }
                    }
                    materialService.gravaAutoCopiaSemCommit(matBean, 1, Variaveis.filialPadrao, null);
                }
                Conexao.arquivaSQL();
                this.limparCampos();
                this.setStatus(1);
                this.controlaCampos();
            }
            catch (Exception e) {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(this.getTopLevelAncestor(), "N\u00e3o foi poss\u00edvel salvar a montagem de kit.\n" + e.getMessage(), e.getStackTrace());
            }
        }
    }

    private MontagemKitBean getBeanPreenchido() {
        MontagemKitBean montagem = new MontagemKitBean();
        FilialVO filial = new FilialVO();
        filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
        montagem.setFilial(filial);
        montagem.setDataHora(this.dataAux);
        montagem.setObservacao(this.areaObservacao.getText());
        montagem.setUsuario(this.usuarioAux);
        ArrayList<MontagemKitMaterialBean> materiais = new ArrayList<MontagemKitMaterialBean>();
        for (int i = 0; i < this.modeloKits.getRowCount(); ++i) {
            MontagemKitMaterialBean aux = (MontagemKitMaterialBean)this.modeloKits.getValueAt(i, 5);
            materiais.add(aux);
        }
        montagem.setMateriais(materiais);
        return montagem;
    }

    private String getCopiaFiliais() {
        return null;
    }

    @Override
    public boolean validaCampos() {
        return this.modeloKits.getRowCount() > 0;
    }

    public static long getModuloAcesso() {
        return Long.parseLong("1200300800");
    }

    private void buscaCelulasCombo() {
        ArrayList<CelulaEstoqueBean> lista = null;
        try {
            lista = new CelulaEstoqueService().getTodasCelulasFilial(Variaveis.filialPadrao);
        }
        catch (ThreadDaoException e) {
            Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel buscar dados das c\u00e9lulas de estoque.", 2);
            return;
        }
        if (lista != null) {
            int posSelecionada = 0;
            String celulaEstoqueEstacao = ParametrosLocais.getParametro("celulaEstoque") == null ? "" : ParametrosLocais.getParametro("celulaEstoque");
            for (int i = 0; i < lista.size(); ++i) {
                CelulaEstoqueBean bean = lista.get(i);
                this.comboCelulaOrigem.addItem(bean);
                this.comboCelulaDestino.addItem(bean);
                if (Funcoes.textoVazio(celulaEstoqueEstacao)) {
                    if (!bean.getPadrao().booleanValue()) continue;
                    posSelecionada = i;
                    continue;
                }
                if (!bean.getCodigo().toString().equals(celulaEstoqueEstacao)) continue;
                posSelecionada = i;
            }
            this.comboCelulaOrigem.setSelectedIndex(posSelecionada);
            this.comboCelulaDestino.setSelectedIndex(posSelecionada);
        }
    }

    @Override
    public String getRetornoParaPesquisa() {
        return "";
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return null;
    }
}

